# Rust API client for motis-openapi-sdk

This is the MOTIS routing API.

Overview of MOTIS API versions:

MOTIS 0.x - deprecated/discontinued

MOTIS 2.x - current, providing:

* /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0
* /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0
* /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84 
* /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60
* /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107)
* /api/v1/_* all other endpoints

If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used).



## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: v5
- Package version: v5
- Generator version: 7.15.0
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `motis-openapi-sdk` and add the following to `Cargo.toml` under `[dependencies]`:

```
motis-openapi-sdk = { path = "./motis-openapi-sdk" }
```

## Documentation for API Endpoints

All URIs are relative to *https://api.transitous.org*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DebugApi* | [**transfers**](docs/DebugApi.md#transfers) | **GET** /api/debug/transfers | Prints all transfers of a timetable location (track, bus stop, etc.)
*GeocodeApi* | [**geocode**](docs/GeocodeApi.md#geocode) | **GET** /api/v1/geocode | Autocompletion & geocoding that resolves user input addresses including coordinates
*GeocodeApi* | [**reverse_geocode**](docs/GeocodeApi.md#reverse_geocode) | **GET** /api/v1/reverse-geocode | Translate coordinates to the closest address(es)/places/stops.
*MapApi* | [**initial**](docs/MapApi.md#initial) | **GET** /api/v1/map/initial | initial location to view the map at after loading based on where public transport should be visible
*MapApi* | [**levels**](docs/MapApi.md#levels) | **GET** /api/v1/map/levels | Get all available levels for a map section
*MapApi* | [**rentals**](docs/MapApi.md#rentals) | **GET** /api/v1/rentals | Get a list of rental providers or all rental stations and vehicles for a map section or provider 
*MapApi* | [**stops**](docs/MapApi.md#stops) | **GET** /api/v1/map/stops | Get all stops for a map section
*MapApi* | [**trips**](docs/MapApi.md#trips) | **GET** /api/v5/map/trips | Given a area frame (box defined by top right and bottom left corner) and a time frame, it returns all trips and their respective shapes that operate in this area + time frame. Trips are filtered by zoom level. On low zoom levels, only long distance trains will be shown while on high zoom levels, also metros, buses and trams will be returned. 
*RoutingApi* | [**one_to_all**](docs/RoutingApi.md#one_to_all) | **GET** /api/v1/one-to-all | Computes all reachable locations from a given stop within a set duration. Each result entry will contain the fastest travel duration and the number of connections used. 
*RoutingApi* | [**one_to_many**](docs/RoutingApi.md#one_to_many) | **GET** /api/v1/one-to-many | Street routing from one to many places or many to one. The order in the response array corresponds to the order of coordinates of the \\`many\\` parameter in the query. 
*RoutingApi* | [**plan**](docs/RoutingApi.md#plan) | **GET** /api/v5/plan | Computes optimal connections from one place to another.
*TimetableApi* | [**stoptimes**](docs/TimetableApi.md#stoptimes) | **GET** /api/v5/stoptimes | Get the next N departures or arrivals of a stop sorted by time
*TimetableApi* | [**trip**](docs/TimetableApi.md#trip) | **GET** /api/v5/trip | Get a trip as itinerary


## Documentation For Models

 - [Alert](docs/Alert.md)
 - [AlertCause](docs/AlertCause.md)
 - [AlertEffect](docs/AlertEffect.md)
 - [AlertSeverityLevel](docs/AlertSeverityLevel.md)
 - [Area](docs/Area.md)
 - [Direction](docs/Direction.md)
 - [Duration](docs/Duration.md)
 - [ElevationCosts](docs/ElevationCosts.md)
 - [EncodedPolyline](docs/EncodedPolyline.md)
 - [Error](docs/Error.md)
 - [FareMedia](docs/FareMedia.md)
 - [FareMediaType](docs/FareMediaType.md)
 - [FareProduct](docs/FareProduct.md)
 - [FareTransfer](docs/FareTransfer.md)
 - [FareTransferRule](docs/FareTransferRule.md)
 - [Initial200Response](docs/Initial200Response.md)
 - [Itinerary](docs/Itinerary.md)
 - [Leg](docs/Leg.md)
 - [LocationType](docs/LocationType.md)
 - [Match](docs/Match.md)
 - [Mode](docs/Mode.md)
 - [PedestrianProfile](docs/PedestrianProfile.md)
 - [PickupDropoffType](docs/PickupDropoffType.md)
 - [Place](docs/Place.md)
 - [Plan200Response](docs/Plan200Response.md)
 - [Reachable](docs/Reachable.md)
 - [ReachablePlace](docs/ReachablePlace.md)
 - [Rental](docs/Rental.md)
 - [RentalFormFactor](docs/RentalFormFactor.md)
 - [RentalPropulsionType](docs/RentalPropulsionType.md)
 - [RentalProvider](docs/RentalProvider.md)
 - [RentalProviderGroup](docs/RentalProviderGroup.md)
 - [RentalReturnConstraint](docs/RentalReturnConstraint.md)
 - [RentalStation](docs/RentalStation.md)
 - [RentalVehicle](docs/RentalVehicle.md)
 - [RentalVehicleType](docs/RentalVehicleType.md)
 - [RentalZone](docs/RentalZone.md)
 - [RentalZoneRestrictions](docs/RentalZoneRestrictions.md)
 - [Rentals200Response](docs/Rentals200Response.md)
 - [RiderCategory](docs/RiderCategory.md)
 - [StepInstruction](docs/StepInstruction.md)
 - [StopTime](docs/StopTime.md)
 - [Stoptimes200Response](docs/Stoptimes200Response.md)
 - [TimeRange](docs/TimeRange.md)
 - [Transfer](docs/Transfer.md)
 - [Transfers200Response](docs/Transfers200Response.md)
 - [TripInfo](docs/TripInfo.md)
 - [TripSegment](docs/TripSegment.md)
 - [VertexType](docs/VertexType.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

felix@triptix.tech

