/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.AndExpression;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;

class OrExpression
extends BasicExpression {
    BasicExpression E1;
    BasicExpression E2;

    public OrExpression(BasicExpression basicExpression, BasicExpression basicExpression2) {
        this.E1 = basicExpression;
        this.E2 = basicExpression2;
    }

    public static BasicExpression scan(ExpressionText expressionText) throws ConstructionException {
        BasicExpression basicExpression = AndExpression.scan(expressionText);
        if (expressionText.next() == '|') {
            expressionText.advance();
            if (expressionText.next(true) == '|') {
                expressionText.advance();
            }
            return OrExpression.scan(expressionText, basicExpression);
        }
        return basicExpression;
    }

    public static BasicExpression scan(ExpressionText expressionText, BasicExpression basicExpression) throws ConstructionException {
        BasicExpression basicExpression2 = AndExpression.scan(expressionText);
        if (expressionText.next() == '|') {
            expressionText.advance();
            if (expressionText.next(true) == '|') {
                expressionText.advance();
            }
            return OrExpression.scan(expressionText, new OrExpression(basicExpression, basicExpression2));
        }
        return new OrExpression(basicExpression, basicExpression2);
    }

    public double getValue() throws ConstructionException {
        if (this.E1.getValue() != 0.0 || this.E2.getValue() != 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public void translate() {
        this.E1.translate();
        this.E2.translate();
    }

    public String toString() {
        return this.E1 + "||" + this.E2;
    }

    public void reset() {
        this.E1.reset();
        this.E2.reset();
    }

    public boolean isLogical() {
        return true;
    }
}

