/*
 * Copyright (C) 2024 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticationExtensionsClientInputsJSON.h>
#include <WebCore/PublicKeyCredentialRpEntity.h>
#include <WebCore/PublicKeyCredentialUserEntityJSON.h>
#include <wtf/Forward.h>

namespace WebCore {

enum class AuthenticatorAttachment : uint8_t;
enum class AttestationConveyancePreference : uint8_t;
struct AuthenticatorSelectionCriteria;
struct PublicKeyCredentialDescriptorJSON;
struct PublicKeyCredentialParameters;

struct PublicKeyCredentialCreationOptionsJSON {
    PublicKeyCredentialRpEntity rp;
    PublicKeyCredentialUserEntityJSON user;

    String challenge;
    mutable Vector<PublicKeyCredentialParameters> pubKeyCredParams;

    std::optional<unsigned> timeout;
    Vector<PublicKeyCredentialDescriptorJSON> excludeCredentials;
    std::optional<AuthenticatorSelectionCriteria> authenticatorSelection;
    String attestation;
    std::optional<AuthenticationExtensionsClientInputsJSON> extensions;
};

} // namespace WebCore
#endif // ENABLE(WEB_AUTHN)
