from _typeshed import Incomplete

from antlr4.atn.ATNSimulator import ATNSimulator
from antlr4.error.ErrorListener import (
    ConsoleErrorListener as ConsoleErrorListener,
    ErrorListener,
    ProxyErrorListener as ProxyErrorListener,
)
from antlr4.error.Errors import RecognitionException
from antlr4.RuleContext import RuleContext as RuleContext
from antlr4.Token import Token as Token

class Recognizer:
    __slots__ = ("_listeners", "_interp", "_stateNumber")
    tokenTypeMapCache: dict[Incomplete, int]
    ruleIndexMapCache: dict[str, int]
    _listeners: list[ErrorListener]
    _interp: ATNSimulator | None
    _stateNumber: int
    def __init__(self) -> None: ...
    def extractVersion(self, version: str) -> tuple[str, str]: ...
    def checkVersion(self, toolVersion: str) -> None: ...
    def addErrorListener(self, listener: ErrorListener) -> None: ...
    def removeErrorListener(self, listener: ErrorListener) -> None: ...
    def removeErrorListeners(self) -> None: ...
    def getTokenTypeMap(self) -> dict[Incomplete, int]: ...
    def getRuleIndexMap(self) -> dict[str, int]: ...
    def getTokenType(self, tokenName: str) -> int: ...
    def getErrorHeader(self, e: RecognitionException) -> str: ...
    def getTokenErrorDisplay(self, t: Token | None) -> str: ...
    def getErrorListenerDispatch(self) -> ProxyErrorListener: ...
    def sempred(self, localctx: RuleContext, ruleIndex: int, actionIndex: int) -> bool: ...
    def precpred(self, localctx: RuleContext, precedence: int) -> bool: ...
    @property
    def state(self) -> int: ...
    @state.setter
    def state(self, atnState: int) -> None: ...
