
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                    User Interface                     //
//                                                       //
//                    Program: SAGA                      //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                   DLG_Parameters.h                    //
//                                                       //
//          Copyright (C) 2005 by Olaf Conrad            //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Hamburg                  //
//                Germany                                //
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#ifndef _HEADER_INCLUDED__SAGA_GUI__DLG_Parameters_H
#define _HEADER_INCLUDED__SAGA_GUI__DLG_Parameters_H


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include "dlg_base.h"


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class CDLG_Parameters : public CDLG_Base
{
	DECLARE_CLASS(CDLG_Parameters)

public:
	CDLG_Parameters(class CSG_Parameters *pParameters, const wxString &Caption = "", const wxString &Info = "");
	virtual ~CDLG_Parameters(void);

	static bool					m_bInfo;


	void						Show_Info		(bool bShow = true);


protected:

	virtual void				Save_Changes	(void);

	virtual void				Set_Position	(wxRect r);


private:

	class CSG_Parameters		*m_pParameters;

	class CParameters_Control	*m_pControl;

	class CActive_Description	*m_pInfo;

	class wxButton				*m_pInfo_Button;


	void						On_Ok			(wxCommandEvent &event);
	void						On_Load			(wxCommandEvent &event);
	void						On_Save			(wxCommandEvent &event);
	void						On_Apply		(wxCommandEvent &event);
	void						On_Defaults		(wxCommandEvent &event);
	void						On_Info			(wxCommandEvent &event);


	DECLARE_EVENT_TABLE()
};


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#endif // #ifndef _HEADER_INCLUDED__SAGA_GUI__DLG_Parameters_H
