use super::{Element, Group};

impl Element {
    /// Returns the element's group in the periodic table, if any.
    ///
    /// ```
    /// use mendeleev::{Element, Group};
    /// assert_eq!(Element::H.group(), Some(Group::IA));
    /// assert_eq!(Element::Og.group(), Some(Group::VIIIA));
    /// assert_eq!(Element::U.group(), None);
    /// ```
    pub const fn group(&self) -> Option<Group> {
        match self {
            Element::H => Some(Group::IA),
            Element::He => Some(Group::VIIIA),
            Element::Li => Some(Group::IA),
            Element::Be => Some(Group::IIA),
            Element::B => Some(Group::IIIA),
            Element::C => Some(Group::IVA),
            Element::N => Some(Group::VA),
            Element::O => Some(Group::VIA),
            Element::F => Some(Group::VIIA),
            Element::Ne => Some(Group::VIIIA),
            Element::Na => Some(Group::IA),
            Element::Mg => Some(Group::IIA),
            Element::Al => Some(Group::IIIA),
            Element::Si => Some(Group::IVA),
            Element::P => Some(Group::VA),
            Element::S => Some(Group::VIA),
            Element::Cl => Some(Group::VIIA),
            Element::Ar => Some(Group::VIIIA),
            Element::K => Some(Group::IA),
            Element::Ca => Some(Group::IIA),
            Element::Sc => Some(Group::IIIB),
            Element::Ti => Some(Group::IVB),
            Element::V => Some(Group::VB),
            Element::Cr => Some(Group::VIB),
            Element::Mn => Some(Group::VIIB),
            Element::Fe => Some(Group::VIIIB8),
            Element::Co => Some(Group::VIIIB9),
            Element::Ni => Some(Group::VIIIB10),
            Element::Cu => Some(Group::IB),
            Element::Zn => Some(Group::IIB),
            Element::Ga => Some(Group::IIIA),
            Element::Ge => Some(Group::IVA),
            Element::As => Some(Group::VA),
            Element::Se => Some(Group::VIA),
            Element::Br => Some(Group::VIIA),
            Element::Kr => Some(Group::VIIIA),
            Element::Rb => Some(Group::IA),
            Element::Sr => Some(Group::IIA),
            Element::Y => Some(Group::IIIB),
            Element::Zr => Some(Group::IVB),
            Element::Nb => Some(Group::VB),
            Element::Mo => Some(Group::VIB),
            Element::Tc => Some(Group::VIIB),
            Element::Ru => Some(Group::VIIIB8),
            Element::Rh => Some(Group::VIIIB9),
            Element::Pd => Some(Group::VIIIB10),
            Element::Ag => Some(Group::IB),
            Element::Cd => Some(Group::IIB),
            Element::In => Some(Group::IIIA),
            Element::Sn => Some(Group::IVA),
            Element::Sb => Some(Group::VA),
            Element::Te => Some(Group::VIA),
            Element::I => Some(Group::VIIA),
            Element::Xe => Some(Group::VIIIA),
            Element::Cs => Some(Group::IA),
            Element::Ba => Some(Group::IIA),
            Element::La => None,
            Element::Ce => None,
            Element::Pr => None,
            Element::Nd => None,
            Element::Pm => None,
            Element::Sm => None,
            Element::Eu => None,
            Element::Gd => None,
            Element::Tb => None,
            Element::Dy => None,
            Element::Ho => None,
            Element::Er => None,
            Element::Tm => None,
            Element::Yb => None,
            Element::Lu => Some(Group::IIIB),
            Element::Hf => Some(Group::IVB),
            Element::Ta => Some(Group::VB),
            Element::W => Some(Group::VIB),
            Element::Re => Some(Group::VIIB),
            Element::Os => Some(Group::VIIIB8),
            Element::Ir => Some(Group::VIIIB9),
            Element::Pt => Some(Group::VIIIB10),
            Element::Au => Some(Group::IB),
            Element::Hg => Some(Group::IIB),
            Element::Tl => Some(Group::IIIA),
            Element::Pb => Some(Group::IVA),
            Element::Bi => Some(Group::VA),
            Element::Po => Some(Group::VIA),
            Element::At => Some(Group::VIIA),
            Element::Rn => Some(Group::VIIIA),
            Element::Fr => Some(Group::IA),
            Element::Ra => Some(Group::IIA),
            Element::Ac => None,
            Element::Th => None,
            Element::Pa => None,
            Element::U => None,
            Element::Np => None,
            Element::Pu => None,
            Element::Am => None,
            Element::Cm => None,
            Element::Bk => None,
            Element::Cf => None,
            Element::Es => None,
            Element::Fm => None,
            Element::Md => None,
            Element::No => None,
            Element::Lr => Some(Group::IIIB),
            Element::Rf => Some(Group::IVB),
            Element::Db => Some(Group::VB),
            Element::Sg => Some(Group::VIB),
            Element::Bh => Some(Group::VIIB),
            Element::Hs => Some(Group::VIIIB8),
            Element::Mt => Some(Group::VIIIB9),
            Element::Ds => Some(Group::VIIIB10),
            Element::Rg => Some(Group::IB),
            Element::Cn => Some(Group::IIB),
            Element::Nh => Some(Group::IIIA),
            Element::Fl => Some(Group::IVA),
            Element::Mc => Some(Group::VA),
            Element::Lv => Some(Group::VIA),
            Element::Ts => Some(Group::VIIA),
            Element::Og => Some(Group::VIIIA),
        }
    }
}
