### New features

* [#10839](https://github.com/rubocop/rubocop/pull/10839): Add API for 3rd party template support. ([@r7kamura][])
* [#11528](https://github.com/rubocop/rubocop/pull/11528): Add new `Style/RedundantHeredocDelimiterQuotes` cop. ([@koic][])
* [#11188](https://github.com/rubocop/rubocop/issues/11188): Add a `--no-detach` option for `--start-server`. This will start the server process in the foreground, which can be helpful when running within Docker where detaching the process terminates the container. ([@f1sherman][])
* [#11546](https://github.com/rubocop/rubocop/pull/11546): Make `Lint/UselessAccessModifier` aware of Ruby 3.2's `Data.define`. ([@koic][])
* [#11396](https://github.com/rubocop/rubocop/pull/11396): Add ability to profile rubocop execution via `--profile` and `--memory` options. ([@fatkodima][])

### Bug fixes

* [#11491](https://github.com/rubocop/rubocop/pull/11491): Fix a crash on `Lint/UselessAssignment`. ([@gsamokovarov][])
* [#11515](https://github.com/rubocop/rubocop/pull/11515): Fix a false negative for `Naming/HeredocDelimiterNaming` when using lowercase. ([@koic][])
* [#11511](https://github.com/rubocop/rubocop/issues/11511): Fix a false negative for `Style/YodaCondition` when using constant. ([@koic][])
* [#11520](https://github.com/rubocop/rubocop/pull/11520): Fix a false negative for `Style/YodaExpression` when using constant. ([@koic][])
* [#11521](https://github.com/rubocop/rubocop/issues/11521): Fix a false positive for `Lint/FormatParameterMismatch` when using `Kernel.format` with the interpolated number of decimal places fields match. ([@koic][])
* [#11545](https://github.com/rubocop/rubocop/pull/11545): Fix the following false positive for `Lint/NestedMethodDefinition` when using numbered parameter. ([@koic][])
* [#11535](https://github.com/rubocop/rubocop/issues/11535): Fix a false positive for `Style/NumberedParametersLimit` when only `_2` or higher numbered parameter is used. ([@koic][])
* [#11508](https://github.com/rubocop/rubocop/issues/11508): Fix a false positive for `Style/OperatorMethodCall` when using multiple arguments for operator method. ([@koic][])
* [#11503](https://github.com/rubocop/rubocop/issues/11503): Fix a false positive for `Style/RedundantCondition` when using method argument with operator. ([@koic][])
* [#11529](https://github.com/rubocop/rubocop/pull/11529): Fix an incorrect autocorrect for `Layout/ClassStructure` when definitions that need to be sorted are defined alternately. ([@ydah][])
* [#11530](https://github.com/rubocop/rubocop/pull/11530): Fix an incorrect autocorrect for `Style/AccessModifierDeclarations` when multiple groupable access modifiers are defined. ([@ydah][])
* [#10910](https://github.com/rubocop/rubocop/pull/10910): Fix an incorrect autocorrect for `Style/MultilineTernaryOperator`  when contains a comment. ([@ydah][])
* [#11522](https://github.com/rubocop/rubocop/pull/11522): Don't flag default keyword arguments in `Style/ArgumentsForwarding`. ([@splattael][])
* [#11547](https://github.com/rubocop/rubocop/pull/11547): Fix a false positive for `Lint/NestedMethodDefinition` when using Ruby 3.2's `Data.define`. ([@koic][])
* [#11537](https://github.com/rubocop/rubocop/pull/11537): Fix an infinite loop error for `Layout/ArrayAlignment` when using assigning unbracketed array elements. ([@koic][])
* [#11516](https://github.com/rubocop/rubocop/pull/11516): Fix missing parentheses in shorthand hash syntax as argument calls. ([@gsamokovarov][])

### Changes

* [#11504](https://github.com/rubocop/rubocop/issues/11504): Allow `initialize` method in `Style/DocumentationMethod`. ([@koic][])
* [#11541](https://github.com/rubocop/rubocop/pull/11541): Enable autocorrection for `Layout/LineContinuationLeadingSpace`. ([@eugeneius][])
* [#11542](https://github.com/rubocop/rubocop/pull/11542): Mark `Layout/AssignmentIndentation` as safe and `Lint/AssignmentInCondition` as unsafe for autocorrection. ([@eugeneius][])
* [#11517](https://github.com/rubocop/rubocop/issues/11517): Make `Lint/Debugger` aware of `p`, `PP.pp`, and `pp` methods. ([@koic][])
* [#11539](https://github.com/rubocop/rubocop/pull/11539): Remove `bundler` from default `AllowedGems` of `Gemspec/DevelopmentDependencies`. ([@koic][])

[@r7kamura]: https://github.com/r7kamura
[@koic]: https://github.com/koic
[@f1sherman]: https://github.com/f1sherman
[@fatkodima]: https://github.com/fatkodima
[@gsamokovarov]: https://github.com/gsamokovarov
[@ydah]: https://github.com/ydah
[@splattael]: https://github.com/splattael
[@eugeneius]: https://github.com/eugeneius
