/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION) || defined(DEBUG_DIRECTOR_THREAD_NAME)
#include <iostream>
#endif

#include <exception>

#if defined(SWIG_JAVA_USE_THREAD_NAME)

#if !defined(SWIG_JAVA_GET_THREAD_NAME)
namespace Swig {
  SWIGINTERN int GetThreadName(char *name, size_t len);
}

#if defined(__linux__)

#include <sys/prctl.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
#if defined(PR_GET_NAME)
  return prctl(PR_GET_NAME, (unsigned long)name, 0, 0, 0);
#else
  (void)name;
  return 1;
#endif
}

#elif defined(__unix__) || defined(__APPLE__)

#include <pthread.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  return pthread_getname_np(pthread_self(), name, len);
}

#else

SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
  (void)name;
  return 1;
}
#endif

#endif

#endif

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
        JavaVMAttachArgs args;
        args.version = JNI_VERSION_1_2;
        args.group = NULL;
        args.name = NULL;
#if defined(SWIG_JAVA_USE_THREAD_NAME)
        char thread_name[64];  // MAX_TASK_COMM_LEN=16 is hard-coded in the Linux kernel and MacOS has MAXTHREADNAMESIZE=64.
        if (Swig::GetThreadName(thread_name, sizeof(thread_name)) == 0) {
          args.name = thread_name;
#if defined(DEBUG_DIRECTOR_THREAD_NAME)
          std::cout << "JNIEnvWrapper: thread name: " << thread_name << std::endl;
        } else {
          std::cout << "JNIEnvWrapper: Couldn't set Java thread name" << std::endl;
#endif
        }
#endif
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, &args);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, &args);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    // Return a C string of the exception message in the jthrowable passed in the constructor
    // If no message is available, null_string is return instead
    const char *message(const char *null_string = "Could not get exception message in JavaExceptionMessage") const {
      return message_.c_str(null_string);
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : jenv_(jenv), throwable_(throwable), classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message(0));
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : jenv_(0), throwable_(0), classname_(0), msg_(msg ? copystr(msg) : 0) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_ ? msg_ : "Unspecified DirectorException message";
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void throwException(JNIEnv *jenv) const {
      if (jenv) {
        if (jenv == jenv_ && throwable_) {
          // Throw original exception if not already pending
          jthrowable throwable = jenv->ExceptionOccurred();
          if (throwable && jenv->IsSameObject(throwable, throwable_) == JNI_FALSE) {
            jenv->ExceptionClear();
            throwable = 0;
          }
          if (!throwable)
            jenv->Throw(throwable_);
        } else {
          // Try and reconstruct original exception, but original stacktrace is not reconstructed
          jenv->ExceptionClear();

          jmethodID ctorMethodID = 0;
          jclass throwableclass = 0;
          if (classname_) {
            throwableclass = jenv->FindClass(classname_);
            if (throwableclass)
              ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
          }

          if (ctorMethodID) {
            jenv->ThrowNew(throwableclass, what());
          } else {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
          }
        }
      }
    }

    // Deprecated - use throwException
    void raiseJavaException(JNIEnv *jenv) const {
      throwException(jenv);
    }

    // Create and throw the DirectorException
    static void raise(JNIEnv *jenv, jthrowable throwable) {
      throw DirectorException(jenv, throwable);
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    JNIEnv *jenv_;
    jthrowable throwable_;
    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  // Note side effect of clearing any pending exceptions
  SWIGINTERN bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_RobotRaconteurJavaJNI = NULL;
    jmethodID director_method_ids[88];
  }
}

#if defined(__clang__)
// cSpell: disable-next-line
#pragma clang diagnostic ignored "-Wunused-function"
#endif



#include <RobotRaconteur.h>
#include "RobotRaconteurWrapped.h"
#include <boost/lexical_cast.hpp>
#include <RobotRaconteur/RobotRaconteurServiceIndex_stubskel.h>
#include <boost/foreach.hpp>
using namespace RobotRaconteur;
using namespace std;


#include <string>


#include <typeinfo>
#include <stdexcept>


#include <vector>
#include <stdexcept>


#include <map>
#include <stdexcept>


#include <stdint.h>		// Use the C99 official header


#define SWIGWORDSIZE64
#ifndef LONG_MAX
#include <limits.h>
#endif
#if (__WORDSIZE == 32) || (LONG_MAX == INT_MAX)
# error "SWIG wrapped code invalid in 32 bit architecture, regenerate code using -DSWIGWORDSIZE32"
#endif


#include <stdio.h>


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <boost/filesystem/path.hpp>


template<class T> struct SWIG_intrusive_deleter {
    void operator()(T *p) {
        if (p) 
          intrusive_ptr_release(p);
    }
};


/* Check for overflow converting to Java int (always signed 32-bit) from (unsigned variable-bit) size_t */
SWIGINTERN jint SWIG_JavaIntFromSize_t(size_t size) {
  static const jint JINT_MAX = 0x7FFFFFFF;
  return (size > (size_t)JINT_MAX) ? -1 : (jint)size;
}


SWIGINTERN jint SWIG_VectorSize(size_t size) {
  jint sz = SWIG_JavaIntFromSize_t(size);
  if (sz == -1)
    throw std::out_of_range("vector size is too large to fit into a Java int");
  return sz;
}

SWIGINTERN std::vector< std::string > *new_std_vector_Sl_std_string_Sg___SWIG_2(jint count,std::string const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::string >(static_cast<std::vector< std::string >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_string_Sg__doSize(std::vector< std::string > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doAdd__SWIG_0(std::vector< std::string > *self,std::vector< std::string >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doAdd__SWIG_1(std::vector< std::string > *self,jint index,std::vector< std::string >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string >::value_type std_vector_Sl_std_string_Sg__doRemove(std::vector< std::string > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::string const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string >::value_type const &std_vector_Sl_std_string_Sg__doGet(std::vector< std::string > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::string >::value_type std_vector_Sl_std_string_Sg__doSet(std::vector< std::string > *self,jint index,std::vector< std::string >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::string const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doRemoveRange(std::vector< std::string > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int32_t > *new_std_vector_Sl_int32_t_Sg___SWIG_2(jint count,int const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< int >(static_cast<std::vector< int >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_int32_t_Sg__doSize(std::vector< int32_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_int32_t_Sg__doAdd__SWIG_0(std::vector< int32_t > *self,std::vector< int >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_int32_t_Sg__doAdd__SWIG_1(std::vector< int32_t > *self,jint index,std::vector< int >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int >::value_type std_vector_Sl_int32_t_Sg__doRemove(std::vector< int32_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          int const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int >::value_type const &std_vector_Sl_int32_t_Sg__doGet(std::vector< int32_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< int >::value_type std_vector_Sl_int32_t_Sg__doSet(std::vector< int32_t > *self,jint index,std::vector< int >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          int const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_int32_t_Sg__doRemoveRange(std::vector< int32_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< uint32_t > *new_std_vector_Sl_uint32_t_Sg___SWIG_2(jint count,unsigned int const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< unsigned int >(static_cast<std::vector< unsigned int >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_uint32_t_Sg__doSize(std::vector< uint32_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_uint32_t_Sg__doAdd__SWIG_0(std::vector< uint32_t > *self,std::vector< unsigned int >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_uint32_t_Sg__doAdd__SWIG_1(std::vector< uint32_t > *self,jint index,std::vector< unsigned int >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned int >::value_type std_vector_Sl_uint32_t_Sg__doRemove(std::vector< uint32_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          unsigned int const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned int >::value_type const &std_vector_Sl_uint32_t_Sg__doGet(std::vector< uint32_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< unsigned int >::value_type std_vector_Sl_uint32_t_Sg__doSet(std::vector< uint32_t > *self,jint index,std::vector< unsigned int >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          unsigned int const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_uint32_t_Sg__doRemoveRange(std::vector< uint32_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int8_t > *new_std_vector_Sl_int8_t_Sg___SWIG_2(jint count,signed char const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< signed char >(static_cast<std::vector< signed char >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_int8_t_Sg__doSize(std::vector< int8_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_int8_t_Sg__doAdd__SWIG_0(std::vector< int8_t > *self,std::vector< signed char >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_int8_t_Sg__doAdd__SWIG_1(std::vector< int8_t > *self,jint index,std::vector< signed char >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< signed char >::value_type std_vector_Sl_int8_t_Sg__doRemove(std::vector< int8_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          signed char const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< signed char >::value_type const &std_vector_Sl_int8_t_Sg__doGet(std::vector< int8_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< signed char >::value_type std_vector_Sl_int8_t_Sg__doSet(std::vector< int8_t > *self,jint index,std::vector< signed char >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          signed char const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_int8_t_Sg__doRemoveRange(std::vector< int8_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< uint8_t > *new_std_vector_Sl_uint8_t_Sg___SWIG_2(jint count,unsigned char const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< unsigned char >(static_cast<std::vector< unsigned char >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_uint8_t_Sg__doSize(std::vector< uint8_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_uint8_t_Sg__doAdd__SWIG_0(std::vector< uint8_t > *self,std::vector< unsigned char >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_uint8_t_Sg__doAdd__SWIG_1(std::vector< uint8_t > *self,jint index,std::vector< unsigned char >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned char >::value_type std_vector_Sl_uint8_t_Sg__doRemove(std::vector< uint8_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          unsigned char const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned char >::value_type const &std_vector_Sl_uint8_t_Sg__doGet(std::vector< uint8_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< unsigned char >::value_type std_vector_Sl_uint8_t_Sg__doSet(std::vector< uint8_t > *self,jint index,std::vector< unsigned char >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          unsigned char const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_uint8_t_Sg__doRemoveRange(std::vector< uint8_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< uint64_t > *new_std_vector_Sl_uint64_t_Sg___SWIG_2(jint count,unsigned long const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< unsigned long >(static_cast<std::vector< unsigned long >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_uint64_t_Sg__doSize(std::vector< uint64_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_uint64_t_Sg__doAdd__SWIG_0(std::vector< uint64_t > *self,std::vector< unsigned long >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_uint64_t_Sg__doAdd__SWIG_1(std::vector< uint64_t > *self,jint index,std::vector< unsigned long >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned long >::value_type std_vector_Sl_uint64_t_Sg__doRemove(std::vector< uint64_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          unsigned long const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned long >::value_type const &std_vector_Sl_uint64_t_Sg__doGet(std::vector< uint64_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< unsigned long >::value_type std_vector_Sl_uint64_t_Sg__doSet(std::vector< uint64_t > *self,jint index,std::vector< unsigned long >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          unsigned long const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_uint64_t_Sg__doRemoveRange(std::vector< uint64_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::map< std::string,std::string,std::less< std::string > >::iterator std_map_Sl_std_string_Sc_std_string_Sg__iterator_getNextUnchecked(std::map< std::string,std::string >::iterator *self){
          std::map< std::string, std::string, std::less< std::string > >::iterator copy = (*self);
          return ++copy;
        }
SWIGINTERN bool std_map_Sl_std_string_Sc_std_string_Sg__iterator_isNot(std::map< std::string,std::string >::iterator const *self,std::map< std::string,std::string >::iterator other){
          return (*self != other);
        }
SWIGINTERN std::string std_map_Sl_std_string_Sc_std_string_Sg__iterator_getKey(std::map< std::string,std::string >::iterator const *self){
          return (*self)->first;
        }
SWIGINTERN std::string std_map_Sl_std_string_Sc_std_string_Sg__iterator_getValue(std::map< std::string,std::string >::iterator const *self){
          return (*self)->second;
        }
SWIGINTERN void std_map_Sl_std_string_Sc_std_string_Sg__iterator_setValue(std::map< std::string,std::string >::iterator *self,std::string const &newValue){
          (*self)->second = newValue;
        }

  SWIGINTERN jint SWIG_MapSize(size_t size) {
    jint sz = SWIG_JavaIntFromSize_t(size);
    if (sz == -1) {
      throw std::out_of_range("map size is too large to fit into a Java int");
    }

    return sz;
  }

SWIGINTERN jint std_map_Sl_std_string_Sc_std_string_Sg__sizeImpl(std::map< std::string,std::string > const *self){
        return SWIG_MapSize(self->size());
      }
SWIGINTERN bool std_map_Sl_std_string_Sc_std_string_Sg__containsImpl(std::map< std::string,std::string > *self,std::string const &key){
        return (self->count(key) > 0);
      }
SWIGINTERN void std_map_Sl_std_string_Sc_std_string_Sg__putUnchecked(std::map< std::string,std::string > *self,std::string const &key,std::string const &value){
        (*self)[key] = value;
      }
SWIGINTERN void std_map_Sl_std_string_Sc_std_string_Sg__removeUnchecked(std::map< std::string,std::string > *self,std::map< std::string,std::string,std::less< std::string > >::iterator const itr){
        self->erase(itr);
      }

struct SWIG_null_deleter {
  void operator() (void const *) const {
  }
};
#define SWIG_NO_NULL_DELETER_0 , SWIG_null_deleter()
#define SWIG_NO_NULL_DELETER_1
#define SWIG_NO_NULL_DELETER_SWIG_POINTER_NEW
#define SWIG_NO_NULL_DELETER_SWIG_POINTER_OWN

SWIGINTERN std::vector< RobotRaconteur::ServicePathSegment > *new_std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg___SWIG_2(jint count,RobotRaconteur::ServicePathSegment const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< RobotRaconteur::ServicePathSegment >(static_cast<std::vector< RobotRaconteur::ServicePathSegment >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doSize(std::vector< RobotRaconteur::ServicePathSegment > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doAdd__SWIG_0(std::vector< RobotRaconteur::ServicePathSegment > *self,std::vector< RobotRaconteur::ServicePathSegment >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doAdd__SWIG_1(std::vector< RobotRaconteur::ServicePathSegment > *self,jint index,std::vector< RobotRaconteur::ServicePathSegment >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServicePathSegment >::value_type std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doRemove(std::vector< RobotRaconteur::ServicePathSegment > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          RobotRaconteur::ServicePathSegment const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServicePathSegment >::value_type const &std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doGet(std::vector< RobotRaconteur::ServicePathSegment > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< RobotRaconteur::ServicePathSegment >::value_type std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doSet(std::vector< RobotRaconteur::ServicePathSegment > *self,jint index,std::vector< RobotRaconteur::ServicePathSegment >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          RobotRaconteur::ServicePathSegment const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doRemoveRange(std::vector< RobotRaconteur::ServicePathSegment > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg___SWIG_2(jint count,boost::shared_ptr< RobotRaconteur::TypeDefinition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >(static_cast<std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doSize(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doAdd__SWIG_0(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *self,std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doAdd__SWIG_1(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doRemove(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::shared_ptr< RobotRaconteur::TypeDefinition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doGet(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doSet(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::shared_ptr< RobotRaconteur::TypeDefinition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doRemoveRange(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg___SWIG_2(jint count,boost::shared_ptr< RobotRaconteur::MemberDefinition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >(static_cast<std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doSize(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doAdd__SWIG_0(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *self,std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doAdd__SWIG_1(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doRemove(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::shared_ptr< RobotRaconteur::MemberDefinition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doGet(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doSet(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::shared_ptr< RobotRaconteur::MemberDefinition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doRemoveRange(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg___SWIG_2(jint count,boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >(static_cast<std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doSize(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doAdd__SWIG_0(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *self,std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doAdd__SWIG_1(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doRemove(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doGet(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doSet(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doRemoveRange(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg___SWIG_2(jint count,boost::shared_ptr< RobotRaconteur::ConstantDefinition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >(static_cast<std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doSize(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doAdd__SWIG_0(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *self,std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doAdd__SWIG_1(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doRemove(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::shared_ptr< RobotRaconteur::ConstantDefinition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doGet(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doSet(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::shared_ptr< RobotRaconteur::ConstantDefinition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doRemoveRange(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg___SWIG_2(jint count,boost::shared_ptr< RobotRaconteur::EnumDefinition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >(static_cast<std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doSize(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doAdd__SWIG_0(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *self,std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doAdd__SWIG_1(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doRemove(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::shared_ptr< RobotRaconteur::EnumDefinition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doGet(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doSet(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::shared_ptr< RobotRaconteur::EnumDefinition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doRemoveRange(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ConstantDefinition_StructField > *new_std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg___SWIG_2(jint count,RobotRaconteur::ConstantDefinition_StructField const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< RobotRaconteur::ConstantDefinition_StructField >(static_cast<std::vector< RobotRaconteur::ConstantDefinition_StructField >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doSize(std::vector< RobotRaconteur::ConstantDefinition_StructField > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doAdd__SWIG_0(std::vector< RobotRaconteur::ConstantDefinition_StructField > *self,std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doAdd__SWIG_1(std::vector< RobotRaconteur::ConstantDefinition_StructField > *self,jint index,std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doRemove(std::vector< RobotRaconteur::ConstantDefinition_StructField > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          RobotRaconteur::ConstantDefinition_StructField const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type const &std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doGet(std::vector< RobotRaconteur::ConstantDefinition_StructField > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doSet(std::vector< RobotRaconteur::ConstantDefinition_StructField > *self,jint index,std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          RobotRaconteur::ConstantDefinition_StructField const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doRemoveRange(std::vector< RobotRaconteur::ConstantDefinition_StructField > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::EnumDefinitionValue > *new_std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg___SWIG_2(jint count,RobotRaconteur::EnumDefinitionValue const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< RobotRaconteur::EnumDefinitionValue >(static_cast<std::vector< RobotRaconteur::EnumDefinitionValue >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doSize(std::vector< RobotRaconteur::EnumDefinitionValue > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doAdd__SWIG_0(std::vector< RobotRaconteur::EnumDefinitionValue > *self,std::vector< RobotRaconteur::EnumDefinitionValue >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doAdd__SWIG_1(std::vector< RobotRaconteur::EnumDefinitionValue > *self,jint index,std::vector< RobotRaconteur::EnumDefinitionValue >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::EnumDefinitionValue >::value_type std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doRemove(std::vector< RobotRaconteur::EnumDefinitionValue > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          RobotRaconteur::EnumDefinitionValue const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::EnumDefinitionValue >::value_type const &std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doGet(std::vector< RobotRaconteur::EnumDefinitionValue > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< RobotRaconteur::EnumDefinitionValue >::value_type std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doSet(std::vector< RobotRaconteur::EnumDefinitionValue > *self,jint index,std::vector< RobotRaconteur::EnumDefinitionValue >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          RobotRaconteur::EnumDefinitionValue const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doRemoveRange(std::vector< RobotRaconteur::EnumDefinitionValue > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg___SWIG_2(jint count,boost::shared_ptr< RobotRaconteur::UsingDefinition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >(static_cast<std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doSize(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doAdd__SWIG_0(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *self,std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doAdd__SWIG_1(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doRemove(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::shared_ptr< RobotRaconteur::UsingDefinition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doGet(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doSet(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::shared_ptr< RobotRaconteur::UsingDefinition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doRemoveRange(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg___SWIG_2(jint count,boost::shared_ptr< RobotRaconteur::ExceptionDefinition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >(static_cast<std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doSize(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doAdd__SWIG_0(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *self,std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doAdd__SWIG_1(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doRemove(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::shared_ptr< RobotRaconteur::ExceptionDefinition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doGet(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doSet(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::shared_ptr< RobotRaconteur::ExceptionDefinition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doRemoveRange(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg___SWIG_2(jint count,boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >(static_cast<std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doSize(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doAdd__SWIG_0(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *self,std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doAdd__SWIG_1(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doRemove(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::shared_ptr< RobotRaconteur::ServiceDefinition > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doGet(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doSet(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::shared_ptr< RobotRaconteur::ServiceDefinition > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doRemoveRange(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN boost::shared_ptr< RobotRaconteur::ServiceDefinition > RobotRaconteur_ServiceEntryDefinition_GetServiceDefinition(RobotRaconteur::ServiceEntryDefinition *self){
		return self->ServiceDefinition_.lock();
	}
SWIGINTERN void RobotRaconteur_ServiceEntryDefinition_SetServiceDefinition(RobotRaconteur::ServiceEntryDefinition *self,boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &value){
		self->ServiceDefinition_=value;
	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > RobotRaconteur_MemberDefinition_GetServiceEntry(RobotRaconteur::MemberDefinition *self){
		return self->ServiceEntry.lock();
	}
SWIGINTERN void RobotRaconteur_MemberDefinition_SetServiceEntry(RobotRaconteur::MemberDefinition *self,boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > const &value){
		self->ServiceEntry=value;
	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::MemberDefinition > RobotRaconteur_TypeDefinition_GetMember(RobotRaconteur::TypeDefinition *self){
		return self->member.lock();
	}
SWIGINTERN void RobotRaconteur_TypeDefinition_SetMember(RobotRaconteur::TypeDefinition *self,boost::shared_ptr< RobotRaconteur::MemberDefinition > const &value){
		self->member=value;
	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::ServiceDefinition > RobotRaconteur_UsingDefinition_GetService(RobotRaconteur::UsingDefinition *self){
			return self->service.lock();
		}
SWIGINTERN void RobotRaconteur_UsingDefinition_SetService(RobotRaconteur::UsingDefinition *self,boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &value){
			self->service=value;
		}
SWIGINTERN boost::shared_ptr< RobotRaconteur::ServiceDefinition > RobotRaconteur_ConstantDefinition_GetService(RobotRaconteur::ConstantDefinition *self){
			return self->service.lock();
		}
SWIGINTERN void RobotRaconteur_ConstantDefinition_SetService(RobotRaconteur::ConstantDefinition *self,boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &value){
			self->service=value;
		}
SWIGINTERN boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > RobotRaconteur_ConstantDefinition_GetServiceEntry(RobotRaconteur::ConstantDefinition *self){
			return self->service_entry.lock();
		}
SWIGINTERN void RobotRaconteur_ConstantDefinition_SetServiceEntry(RobotRaconteur::ConstantDefinition *self,boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > const &value){
			self->service_entry=value;
		}
SWIGINTERN boost::shared_ptr< RobotRaconteur::ServiceDefinition > RobotRaconteur_EnumDefinition_GetService(RobotRaconteur::EnumDefinition *self){
			return self->service.lock();
		}
SWIGINTERN void RobotRaconteur_EnumDefinition_SetService(RobotRaconteur::EnumDefinition *self,boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &value){
			self->service=value;
		}
SWIGINTERN boost::shared_ptr< RobotRaconteur::ServiceDefinition > RobotRaconteur_ExceptionDefinition_GetService(RobotRaconteur::ExceptionDefinition *self){
			return self->service.lock();
		}
SWIGINTERN void RobotRaconteur_ExceptionDefinition_SetService(RobotRaconteur::ExceptionDefinition *self,boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &value){
			self->service=value;
		}


class MemberDefinitionUtil
{
public:
static boost::shared_ptr<RobotRaconteur::PropertyDefinition> ToProperty(const boost::shared_ptr<RobotRaconteur::MemberDefinition>& t)
{
return boost::dynamic_pointer_cast<RobotRaconteur::PropertyDefinition>(t);
}

static boost::shared_ptr<RobotRaconteur::FunctionDefinition> ToFunction(const boost::shared_ptr<RobotRaconteur::MemberDefinition>& t)
{
return boost::dynamic_pointer_cast<RobotRaconteur::FunctionDefinition>(t);
}

static boost::shared_ptr<RobotRaconteur::ObjRefDefinition> ToObjRef(const boost::shared_ptr<RobotRaconteur::MemberDefinition>& t)
{
return boost::dynamic_pointer_cast<RobotRaconteur::ObjRefDefinition>(t);
}

static boost::shared_ptr<RobotRaconteur::EventDefinition> ToEvent(const boost::shared_ptr<RobotRaconteur::MemberDefinition>& t)
{
return boost::dynamic_pointer_cast<RobotRaconteur::EventDefinition>(t);
}

static boost::shared_ptr<RobotRaconteur::PipeDefinition> ToPipe(const boost::shared_ptr<RobotRaconteur::MemberDefinition>& t)
{
return boost::dynamic_pointer_cast<RobotRaconteur::PipeDefinition>(t);
}

static boost::shared_ptr<RobotRaconteur::CallbackDefinition> ToCallback(const boost::shared_ptr<RobotRaconteur::MemberDefinition>& t)
{
return boost::dynamic_pointer_cast<RobotRaconteur::CallbackDefinition>(t);
}

static boost::shared_ptr<RobotRaconteur::WireDefinition> ToWire(const boost::shared_ptr<RobotRaconteur::MemberDefinition>& t)
{
return boost::dynamic_pointer_cast<RobotRaconteur::WireDefinition>(t);
}

static boost::shared_ptr<RobotRaconteur::MemoryDefinition> ToMemory(const boost::shared_ptr<RobotRaconteur::MemberDefinition>& t)
{
return boost::dynamic_pointer_cast<RobotRaconteur::MemoryDefinition>(t);
}

};

SWIGINTERN std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > > *new_std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageEntry_Sg__Sg___SWIG_2(jint count,boost::intrusive_ptr< RobotRaconteur::MessageEntry > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > >(static_cast<std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageEntry_Sg__Sg__doSize(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageEntry_Sg__Sg__doAdd__SWIG_0(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > > *self,std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageEntry_Sg__Sg__doAdd__SWIG_1(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > > *self,jint index,std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > >::value_type std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageEntry_Sg__Sg__doRemove(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::intrusive_ptr< RobotRaconteur::MessageEntry > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > >::value_type const &std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageEntry_Sg__Sg__doGet(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > >::value_type std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageEntry_Sg__Sg__doSet(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > > *self,jint index,std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::intrusive_ptr< RobotRaconteur::MessageEntry > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageEntry_Sg__Sg__doRemoveRange(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageEntry > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > *new_std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageElement_Sg__Sg___SWIG_2(jint count,boost::intrusive_ptr< RobotRaconteur::MessageElement > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >(static_cast<std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageElement_Sg__Sg__doSize(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageElement_Sg__Sg__doAdd__SWIG_0(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > *self,std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageElement_Sg__Sg__doAdd__SWIG_1(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > *self,jint index,std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >::value_type std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageElement_Sg__Sg__doRemove(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::intrusive_ptr< RobotRaconteur::MessageElement > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >::value_type const &std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageElement_Sg__Sg__doGet(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >::value_type std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageElement_Sg__Sg__doSet(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > *self,jint index,std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::intrusive_ptr< RobotRaconteur::MessageElement > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_intrusive_ptr_Sl_RobotRaconteur_MessageElement_Sg__Sg__doRemoveRange(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }


class MessageElementDataUtil
{
public:
	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray> ToRRBaseArray(const boost::intrusive_ptr<RobotRaconteur::MessageElementData>& m)
	{
		return boost::dynamic_pointer_cast<RRBaseArray>(m);
	}

	static boost::intrusive_ptr<RobotRaconteur::MessageElementNestedElementList> ToMessageElementNestedElementList(const boost::intrusive_ptr<RobotRaconteur::MessageElementData>& m)
	{
		return boost::dynamic_pointer_cast<MessageElementNestedElementList>(m);
	}



	static std::string RRBaseArrayToString(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		return RRArrayToString(rr_cast<RRArray<char> >(rrarray));
	}

	static void RRBaseArrayToDoubles(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, double* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_double_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(double));
	}

	static void RRBaseArrayToFloats(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, float* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_single_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(float));
	}

	static void RRBaseArrayToBytes(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, int8_t* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_int8_t && rrarray->GetTypeID()!=DataTypes_uint8_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(int8_t));

	}

	static void RRBaseArrayToBytes(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, uint8_t* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_uint8_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(uint8_t));
	}

	static void RRBaseArrayToShorts(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, int16_t* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_int16_t && rrarray->GetTypeID()!=DataTypes_uint16_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(int16_t));
	}

	static void RRBaseArrayToShorts(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, uint16_t* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_uint16_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(uint16_t));
	}

	static void RRBaseArrayToInts(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, int32_t* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_int32_t && rrarray->GetTypeID()!=DataTypes_uint32_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(int32_t));
	}

	static void RRBaseArrayToInts(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, uint32_t* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_uint32_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(uint32_t));
	}

	static void RRBaseArrayToLongs(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, int64_t* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_int64_t && rrarray->GetTypeID()!=DataTypes_uint64_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(int64_t));
	}









	static void RRBaseArrayComplexToDoubles(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, double* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_cdouble_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len/2) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(double));
	}

	static void RRBaseArrayComplexToFloats(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, float* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_csingle_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len/2) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(float));
	}

	static void RRBaseArrayBoolToBytes(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, uint8_t* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_bool_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(uint8_t));
	}

	static void RRBaseArrayBoolToBytes(const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray, int8_t* array_out, int32_t len)
	{
		if (rrarray->GetTypeID()!=DataTypes_bool_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(array_out,rrarray->void_ptr(),len*sizeof(int8_t));
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray> stringToRRBaseArray(const std::string& str)
	{
		return stringToRRArray(str);
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray> DoublesToRRBaseArray(double* array_in, int32_t len)
	{
		return AttachRRArrayCopy(array_in,len);
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray> FloatsToRRBaseArray(float* array_in, int32_t len)
	{
		return AttachRRArrayCopy(array_in,len);
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray>  BytesToRRBaseArray( int8_t* array_in, int32_t len, RobotRaconteur::DataTypes type)
	{
		if (type == DataTypes_int8_t) return AttachRRArrayCopy(array_in,len);
		if (type == DataTypes_uint8_t) return AttachRRArrayCopy((uint8_t*)array_in,len);
		throw DataTypeException("Invalid data type");

	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray>  BytesToRRBaseArray( uint8_t* array_in, int32_t len)
	{
		return AttachRRArrayCopy(array_in,len);
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray>  ShortsToRRBaseArray( int16_t* array_in, int32_t len, RobotRaconteur::DataTypes type)
	{
		if (type == DataTypes_int16_t) return AttachRRArrayCopy(array_in,len);
		if (type == DataTypes_uint16_t) return AttachRRArrayCopy((uint16_t*)array_in,len);
		throw DataTypeException("Invalid data type");
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray>  ShortsToRRBaseArray( uint16_t* array_in, int32_t len)
	{
		return AttachRRArrayCopy(array_in,len);
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray>  IntsToRRBaseArray( int32_t* array_in, int32_t len, RobotRaconteur::DataTypes type)
	{
		if (type == DataTypes_int32_t) return AttachRRArrayCopy(array_in,len);
		if (type == DataTypes_uint32_t) return AttachRRArrayCopy((uint32_t*)array_in,len);
		throw DataTypeException("Invalid data type");

	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray>  IntsToRRBaseArray( uint32_t* array_in, int32_t len)
	{
		return AttachRRArrayCopy(array_in,len);
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray>  LongsToRRBaseArray( int64_t* array_in, int32_t len, RobotRaconteur::DataTypes type)
	{
		if (type == DataTypes_int64_t) return AttachRRArrayCopy(array_in,len);
		if (type == DataTypes_uint64_t) return AttachRRArrayCopy((uint64_t*)array_in,len);
		throw DataTypeException("Invalid data type");

	}







	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray> DoublesToComplexRRBaseArray(double* array_in, int32_t len)
	{
		if (len %2 != 0) throw InvalidArgumentException("Array must be even length");
		return AttachRRArrayCopy((cdouble*)array_in,len/2);
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray> FloatsToComplexRRBaseArray(float* array_in, int32_t len)
	{
		if (len %2 != 0) throw InvalidArgumentException("Array must be even length");
		return AttachRRArrayCopy((cfloat*)array_in,len/2);
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray> BytesToBoolRRBaseArray(uint8_t* array_in, int32_t len)
	{
		return AttachRRArrayCopy((rr_bool*)array_in,len);
	}

	static boost::intrusive_ptr<RobotRaconteur::RRBaseArray> BytesToBoolRRBaseArray(int8_t* array_in, int32_t len)
	{
		return AttachRRArrayCopy((rr_bool*)array_in,len);
	}

	static void DoublesToRRBaseArray(double* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_double_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(double));
	}

	static void FloatsToRRBaseArray(float* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_single_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(float));
	}

	static  void BytesToRRBaseArray( int8_t* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_int8_t && rrarray->GetTypeID()!=DataTypes_uint8_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(int8_t));

	}

	static  void BytesToRRBaseArray( uint8_t* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_uint8_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(uint8_t));
	}


	static  void ShortsToRRBaseArray( int16_t* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_int16_t && rrarray->GetTypeID()!=DataTypes_uint16_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(int16_t));

	}

	static  void ShortsToRRBaseArray( uint16_t* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_uint16_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(uint16_t));

	}

	static void  IntsToRRBaseArray( int32_t* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_int32_t && rrarray->GetTypeID()!=DataTypes_uint32_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(int32_t));

	}

	static void  IntsToRRBaseArray( uint32_t* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_uint32_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(uint32_t));

	}

	static void LongsToRRBaseArray( int64_t* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_int64_t && rrarray->GetTypeID()!=DataTypes_uint64_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(int64_t));

	}









	static void DoublesToComplexRRBaseArray(double* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_cdouble_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len/2) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(double));
	}

	static void FloatsToComplexRRBaseArray(float* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_csingle_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len/2) throw InvalidArgumentException("RRArray error");
		memcpy(rrarray->void_ptr(),array_in,len*sizeof(float));
	}

	static  void BytesToBoolRRBaseArray( int8_t* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_bool_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy((rr_bool*)rrarray->void_ptr(),array_in,len*sizeof(int8_t));
	}

	static  void BytesToBoolRRBaseArray( uint8_t* array_in, int32_t len,const boost::intrusive_ptr<RobotRaconteur::RRBaseArray>& rrarray)
	{
		if (rrarray->GetTypeID()!=DataTypes_bool_t) throw InvalidArgumentException("RRArray error");
		if (rrarray->size()!=len) throw InvalidArgumentException("RRArray error");
		memcpy((rr_bool*)rrarray->void_ptr(),array_in,len*sizeof(uint8_t));
	}


};


SWIGINTERN std::vector< std::string > RobotRaconteur_TcpTransport_GetLocalAdapterIPAddresses(){
		std::vector<std::string> o;
		std::vector<boost::asio::ip::address> addr;
		RobotRaconteur::TcpTransport::GetLocalAdapterIPAddresses(addr);
		for (size_t i=0; i<addr.size(); i++)
		{
			o.push_back(boost::lexical_cast<std::string>(addr[i]));
		}
		return o;
	}

struct WallTimer_initstruct
{
	RobotRaconteur::AsyncTimerEventReturnDirector* handler;
	int32_t id;
};


SWIGINTERN RobotRaconteur::WallTimer *new_RobotRaconteur_WallTimer(boost::posix_time::time_duration const &period,bool oneshot,boost::shared_ptr< RobotRaconteur::RobotRaconteurNode > const &node,WallTimer_initstruct init){
	boost::shared_ptr<AsyncTimerEventReturnDirector> sphandler(init.handler,boost::bind(&ReleaseDirector<AsyncTimerEventReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),init.id));
	return new WallTimer(period,boost::bind(&TimerHandlerFunc,RR_BOOST_PLACEHOLDERS(_1),sphandler),oneshot,node);
}
SWIGINTERN boost::shared_ptr< RobotRaconteur::WrappedServiceStub > RobotRaconteur_WrappedServiceStub_FindObjRef__SWIG_0(RobotRaconteur::WrappedServiceStub *self,std::string const &n){
		return rr_cast<WrappedServiceStub>(self->FindObjRef(n));
	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::WrappedServiceStub > RobotRaconteur_WrappedServiceStub_FindObjRef__SWIG_1(RobotRaconteur::WrappedServiceStub *self,std::string const &n,std::string const &i){
		return rr_cast<WrappedServiceStub>(self->FindObjRef(n,i));
	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::WrappedServiceStub > RobotRaconteur_WrappedServiceStub_FindObjRefTyped__SWIG_0(RobotRaconteur::WrappedServiceStub *self,std::string const &n,std::string const &objecttype){
		return rr_cast<WrappedServiceStub>(self->FindObjRefTyped(n,objecttype));
	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::WrappedServiceStub > RobotRaconteur_WrappedServiceStub_FindObjRefTyped__SWIG_1(RobotRaconteur::WrappedServiceStub *self,std::string const &n,std::string const &i,std::string const &objecttype){
		return rr_cast<WrappedServiceStub>(self->FindObjRefTyped(n,i,objecttype));
	}

class ServerServiceListenerDirector
{
public:

	int32_t objectheapid;

	ServerServiceListenerDirector()
	{
		objectheapid=0;
	}

	void OuterCallback(const boost::shared_ptr<ServerContext>& c,ServerServiceListenerEventType code,const boost::shared_ptr<void>& p)
	{
		if (code==ServerServiceListenerEventType_ClientConnected || code==ServerServiceListenerEventType_ClientDisconnected)
		{
			boost::shared_ptr<uint32_t> p2=boost::static_pointer_cast<uint32_t>(p);

			DIRECTOR_CALL2(Callback(code,*p2));
		}
		else
		{

			DIRECTOR_CALL2(Callback(code,0));
		}
	}
	virtual void Callback(int32_t code, uint32_t endpoint) {};



	virtual ~ServerServiceListenerDirector()
	{

	}

};

SWIGINTERN void RobotRaconteur_ServerContext_AddServerServiceListener(RobotRaconteur::ServerContext *self,ServerServiceListenerDirector *listener){
		boost::shared_ptr<ServerServiceListenerDirector> listener2=boost::shared_ptr<ServerServiceListenerDirector>(listener,boost::bind(&ReleaseDirector<ServerServiceListenerDirector>, RR_BOOST_PLACEHOLDERS(_1), listener->objectheapid));
		self->ServerServiceListener.connect(boost::bind(&ServerServiceListenerDirector::OuterCallback,listener2,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),RR_BOOST_PLACEHOLDERS(_3)));

	}
SWIGINTERN void RobotRaconteur_ServerContext_SetServiceAttributes(RobotRaconteur::ServerContext *self,boost::intrusive_ptr< RobotRaconteur::MessageElement > const &attributes){
		boost::intrusive_ptr<RRMap<std::string,RRValue> > mmap=rr_cast<RRMap<std::string,RRValue> >(RobotRaconteur::detail::packing::UnpackMapType<std::string,RRValue>(attributes->CastData<MessageElementNestedElementList >(),NULL));
		self->SetAttributes(mmap->GetStorageContainer());

	}
SWIGINTERN uint32_t RobotRaconteur_ServerEndpoint_GetCurrentEndpoint(){
			return ServerEndpoint::GetCurrentEndpoint()->GetLocalEndpoint();
		}
SWIGINTERN boost::shared_ptr< RobotRaconteur::AuthenticatedUser > RobotRaconteur_UserAuthenticator_AuthenticateUser(RobotRaconteur::UserAuthenticator *self,std::string const &username,boost::intrusive_ptr< RobotRaconteur::MessageElement > const &credentials,boost::shared_ptr< RobotRaconteur::ServerContext > const &context){
		if (!context) throw InvalidArgumentException("Context cannot be null");
		if (!credentials) throw InvalidArgumentException("Credentials cannot be null");
		boost::intrusive_ptr<RRMap<std::string,RRValue> > r=rr_cast<RRMap<std::string,RRValue> >(context->GetNode()->UnpackMapType<std::string,RRValue>(credentials->CastData<MessageElementNestedElementList >()));
		return self->AuthenticateUser(username,r->GetStorageContainer(),context,RR_SHARED_PTR<RobotRaconteur::ITransportConnection>());
	}
SWIGINTERN std::vector< RobotRaconteur::ServiceInfo2Wrapped > *new_std_vector_Sl_RobotRaconteur_ServiceInfo2Wrapped_Sg___SWIG_2(jint count,RobotRaconteur::ServiceInfo2Wrapped const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< RobotRaconteur::ServiceInfo2Wrapped >(static_cast<std::vector< RobotRaconteur::ServiceInfo2Wrapped >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_RobotRaconteur_ServiceInfo2Wrapped_Sg__doSize(std::vector< RobotRaconteur::ServiceInfo2Wrapped > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServiceInfo2Wrapped_Sg__doAdd__SWIG_0(std::vector< RobotRaconteur::ServiceInfo2Wrapped > *self,std::vector< RobotRaconteur::ServiceInfo2Wrapped >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServiceInfo2Wrapped_Sg__doAdd__SWIG_1(std::vector< RobotRaconteur::ServiceInfo2Wrapped > *self,jint index,std::vector< RobotRaconteur::ServiceInfo2Wrapped >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceInfo2Wrapped >::value_type std_vector_Sl_RobotRaconteur_ServiceInfo2Wrapped_Sg__doRemove(std::vector< RobotRaconteur::ServiceInfo2Wrapped > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          RobotRaconteur::ServiceInfo2Wrapped const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceInfo2Wrapped >::value_type const &std_vector_Sl_RobotRaconteur_ServiceInfo2Wrapped_Sg__doGet(std::vector< RobotRaconteur::ServiceInfo2Wrapped > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceInfo2Wrapped >::value_type std_vector_Sl_RobotRaconteur_ServiceInfo2Wrapped_Sg__doSet(std::vector< RobotRaconteur::ServiceInfo2Wrapped > *self,jint index,std::vector< RobotRaconteur::ServiceInfo2Wrapped >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          RobotRaconteur::ServiceInfo2Wrapped const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServiceInfo2Wrapped_Sg__doRemoveRange(std::vector< RobotRaconteur::ServiceInfo2Wrapped > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::NodeInfo2 > *new_std_vector_Sl_RobotRaconteur_NodeInfo2_Sg___SWIG_2(jint count,RobotRaconteur::NodeInfo2 const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< RobotRaconteur::NodeInfo2 >(static_cast<std::vector< RobotRaconteur::NodeInfo2 >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_RobotRaconteur_NodeInfo2_Sg__doSize(std::vector< RobotRaconteur::NodeInfo2 > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_NodeInfo2_Sg__doAdd__SWIG_0(std::vector< RobotRaconteur::NodeInfo2 > *self,std::vector< RobotRaconteur::NodeInfo2 >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_NodeInfo2_Sg__doAdd__SWIG_1(std::vector< RobotRaconteur::NodeInfo2 > *self,jint index,std::vector< RobotRaconteur::NodeInfo2 >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::NodeInfo2 >::value_type std_vector_Sl_RobotRaconteur_NodeInfo2_Sg__doRemove(std::vector< RobotRaconteur::NodeInfo2 > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          RobotRaconteur::NodeInfo2 const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::NodeInfo2 >::value_type const &std_vector_Sl_RobotRaconteur_NodeInfo2_Sg__doGet(std::vector< RobotRaconteur::NodeInfo2 > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< RobotRaconteur::NodeInfo2 >::value_type std_vector_Sl_RobotRaconteur_NodeInfo2_Sg__doSet(std::vector< RobotRaconteur::NodeInfo2 > *self,jint index,std::vector< RobotRaconteur::NodeInfo2 >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          RobotRaconteur::NodeInfo2 const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_NodeInfo2_Sg__doRemoveRange(std::vector< RobotRaconteur::NodeInfo2 > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped,std::less< RobotRaconteur::ServiceSubscriptionClientID > >::iterator std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_RobotRaconteur_ServiceInfo2Wrapped_Sg__iterator_getNextUnchecked(std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped >::iterator *self){
          std::map< RobotRaconteur::ServiceSubscriptionClientID, RobotRaconteur::ServiceInfo2Wrapped, std::less< RobotRaconteur::ServiceSubscriptionClientID > >::iterator copy = (*self);
          return ++copy;
        }
SWIGINTERN bool std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_RobotRaconteur_ServiceInfo2Wrapped_Sg__iterator_isNot(std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped >::iterator const *self,std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped >::iterator other){
          return (*self != other);
        }
SWIGINTERN RobotRaconteur::ServiceSubscriptionClientID std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_RobotRaconteur_ServiceInfo2Wrapped_Sg__iterator_getKey(std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped >::iterator const *self){
          return (*self)->first;
        }
SWIGINTERN RobotRaconteur::ServiceInfo2Wrapped std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_RobotRaconteur_ServiceInfo2Wrapped_Sg__iterator_getValue(std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped >::iterator const *self){
          return (*self)->second;
        }
SWIGINTERN void std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_RobotRaconteur_ServiceInfo2Wrapped_Sg__iterator_setValue(std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped >::iterator *self,RobotRaconteur::ServiceInfo2Wrapped const &newValue){
          (*self)->second = newValue;
        }
SWIGINTERN jint std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_RobotRaconteur_ServiceInfo2Wrapped_Sg__sizeImpl(std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped > const *self){
        return SWIG_MapSize(self->size());
      }
SWIGINTERN bool std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_RobotRaconteur_ServiceInfo2Wrapped_Sg__containsImpl(std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped > *self,RobotRaconteur::ServiceSubscriptionClientID const &key){
        return (self->count(key) > 0);
      }
SWIGINTERN void std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_RobotRaconteur_ServiceInfo2Wrapped_Sg__putUnchecked(std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped > *self,RobotRaconteur::ServiceSubscriptionClientID const &key,RobotRaconteur::ServiceInfo2Wrapped const &value){
        (*self)[key] = value;
      }
SWIGINTERN void std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_RobotRaconteur_ServiceInfo2Wrapped_Sg__removeUnchecked(std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped > *self,std::map< RobotRaconteur::ServiceSubscriptionClientID,RobotRaconteur::ServiceInfo2Wrapped,std::less< RobotRaconteur::ServiceSubscriptionClientID > >::iterator const itr){
        self->erase(itr);
      }
SWIGINTERN std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub >,std::less< RobotRaconteur::ServiceSubscriptionClientID > >::iterator std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceStub_Sg__Sg__iterator_getNextUnchecked(std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > >::iterator *self){
          std::map< RobotRaconteur::ServiceSubscriptionClientID, boost::shared_ptr< RobotRaconteur::WrappedServiceStub >, std::less< RobotRaconteur::ServiceSubscriptionClientID > >::iterator copy = (*self);
          return ++copy;
        }
SWIGINTERN bool std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceStub_Sg__Sg__iterator_isNot(std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > >::iterator const *self,std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > >::iterator other){
          return (*self != other);
        }
SWIGINTERN RobotRaconteur::ServiceSubscriptionClientID std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceStub_Sg__Sg__iterator_getKey(std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > >::iterator const *self){
          return (*self)->first;
        }
SWIGINTERN boost::shared_ptr< RobotRaconteur::WrappedServiceStub > std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceStub_Sg__Sg__iterator_getValue(std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > >::iterator const *self){
          return (*self)->second;
        }
SWIGINTERN void std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceStub_Sg__Sg__iterator_setValue(std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > >::iterator *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &newValue){
          (*self)->second = newValue;
        }
SWIGINTERN jint std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceStub_Sg__Sg__sizeImpl(std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > > const *self){
        return SWIG_MapSize(self->size());
      }
SWIGINTERN bool std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceStub_Sg__Sg__containsImpl(std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > > *self,RobotRaconteur::ServiceSubscriptionClientID const &key){
        return (self->count(key) > 0);
      }
SWIGINTERN void std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceStub_Sg__Sg__putUnchecked(std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > > *self,RobotRaconteur::ServiceSubscriptionClientID const &key,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &value){
        (*self)[key] = value;
      }
SWIGINTERN void std_map_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sc_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceStub_Sg__Sg__removeUnchecked(std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > > *self,std::map< RobotRaconteur::ServiceSubscriptionClientID,boost::shared_ptr< RobotRaconteur::WrappedServiceStub >,std::less< RobotRaconteur::ServiceSubscriptionClientID > >::iterator const itr){
        self->erase(itr);
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > > *new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceSubscriptionFilterNode_Sg__Sg___SWIG_2(jint count,boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > >(static_cast<std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceSubscriptionFilterNode_Sg__Sg__doSize(std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceSubscriptionFilterNode_Sg__Sg__doAdd__SWIG_0(std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > > *self,std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceSubscriptionFilterNode_Sg__Sg__doAdd__SWIG_1(std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceSubscriptionFilterNode_Sg__Sg__doRemove(std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > >::value_type const &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceSubscriptionFilterNode_Sg__Sg__doGet(std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > >::value_type std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceSubscriptionFilterNode_Sg__Sg__doSet(std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > > *self,jint index,std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_WrappedServiceSubscriptionFilterNode_Sg__Sg__doRemoveRange(std::vector< boost::shared_ptr< RobotRaconteur::WrappedServiceSubscriptionFilterNode > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceSubscriptionClientID > *new_std_vector_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sg___SWIG_2(jint count,RobotRaconteur::ServiceSubscriptionClientID const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< RobotRaconteur::ServiceSubscriptionClientID >(static_cast<std::vector< RobotRaconteur::ServiceSubscriptionClientID >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sg__doSize(std::vector< RobotRaconteur::ServiceSubscriptionClientID > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sg__doAdd__SWIG_0(std::vector< RobotRaconteur::ServiceSubscriptionClientID > *self,std::vector< RobotRaconteur::ServiceSubscriptionClientID >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sg__doAdd__SWIG_1(std::vector< RobotRaconteur::ServiceSubscriptionClientID > *self,jint index,std::vector< RobotRaconteur::ServiceSubscriptionClientID >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceSubscriptionClientID >::value_type std_vector_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sg__doRemove(std::vector< RobotRaconteur::ServiceSubscriptionClientID > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          RobotRaconteur::ServiceSubscriptionClientID const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceSubscriptionClientID >::value_type const &std_vector_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sg__doGet(std::vector< RobotRaconteur::ServiceSubscriptionClientID > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceSubscriptionClientID >::value_type std_vector_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sg__doSet(std::vector< RobotRaconteur::ServiceSubscriptionClientID > *self,jint index,std::vector< RobotRaconteur::ServiceSubscriptionClientID >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          RobotRaconteur::ServiceSubscriptionClientID const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServiceSubscriptionClientID_Sg__doRemoveRange(std::vector< RobotRaconteur::ServiceSubscriptionClientID > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails > *new_std_vector_Sl_RobotRaconteur_WrappedServiceSubscriptionManagerDetails_Sg___SWIG_2(jint count,RobotRaconteur::WrappedServiceSubscriptionManagerDetails const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails >(static_cast<std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_RobotRaconteur_WrappedServiceSubscriptionManagerDetails_Sg__doSize(std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_WrappedServiceSubscriptionManagerDetails_Sg__doAdd__SWIG_0(std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails > *self,std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_WrappedServiceSubscriptionManagerDetails_Sg__doAdd__SWIG_1(std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails > *self,jint index,std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails >::value_type std_vector_Sl_RobotRaconteur_WrappedServiceSubscriptionManagerDetails_Sg__doRemove(std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          RobotRaconteur::WrappedServiceSubscriptionManagerDetails const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails >::value_type const &std_vector_Sl_RobotRaconteur_WrappedServiceSubscriptionManagerDetails_Sg__doGet(std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails >::value_type std_vector_Sl_RobotRaconteur_WrappedServiceSubscriptionManagerDetails_Sg__doSet(std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails > *self,jint index,std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          RobotRaconteur::WrappedServiceSubscriptionManagerDetails const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_WrappedServiceSubscriptionManagerDetails_Sg__doRemoveRange(std::vector< RobotRaconteur::WrappedServiceSubscriptionManagerDetails > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute > *new_std_vector_Sl_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg___SWIG_2(jint count,RobotRaconteur::ServiceSubscriptionFilterAttribute const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute >(static_cast<std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__doSize(std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__doAdd__SWIG_0(std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute > *self,std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__doAdd__SWIG_1(std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute > *self,jint index,std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute >::value_type std_vector_Sl_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__doRemove(std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          RobotRaconteur::ServiceSubscriptionFilterAttribute const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute >::value_type const &std_vector_Sl_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__doGet(std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute >::value_type std_vector_Sl_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__doSet(std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute > *self,jint index,std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          RobotRaconteur::ServiceSubscriptionFilterAttribute const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__doRemoveRange(std::vector< RobotRaconteur::ServiceSubscriptionFilterAttribute > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute,std::less< std::string > >::iterator std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__iterator_getNextUnchecked(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute >::iterator *self){
          std::map< std::string, RobotRaconteur::ServiceSubscriptionFilterAttribute, std::less< std::string > >::iterator copy = (*self);
          return ++copy;
        }
SWIGINTERN bool std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__iterator_isNot(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute >::iterator const *self,std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute >::iterator other){
          return (*self != other);
        }
SWIGINTERN std::string std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__iterator_getKey(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute >::iterator const *self){
          return (*self)->first;
        }
SWIGINTERN RobotRaconteur::ServiceSubscriptionFilterAttribute std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__iterator_getValue(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute >::iterator const *self){
          return (*self)->second;
        }
SWIGINTERN void std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__iterator_setValue(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute >::iterator *self,RobotRaconteur::ServiceSubscriptionFilterAttribute const &newValue){
          (*self)->second = newValue;
        }
SWIGINTERN jint std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__sizeImpl(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute > const *self){
        return SWIG_MapSize(self->size());
      }
SWIGINTERN bool std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__containsImpl(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute > *self,std::string const &key){
        return (self->count(key) > 0);
      }
SWIGINTERN void std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__putUnchecked(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute > *self,std::string const &key,RobotRaconteur::ServiceSubscriptionFilterAttribute const &value){
        (*self)[key] = value;
      }
SWIGINTERN void std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttribute_Sg__removeUnchecked(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute > *self,std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttribute,std::less< std::string > >::iterator const itr){
        self->erase(itr);
      }
SWIGINTERN std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup,std::less< std::string > >::iterator std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttributeGroup_Sg__iterator_getNextUnchecked(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup >::iterator *self){
          std::map< std::string, RobotRaconteur::ServiceSubscriptionFilterAttributeGroup, std::less< std::string > >::iterator copy = (*self);
          return ++copy;
        }
SWIGINTERN bool std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttributeGroup_Sg__iterator_isNot(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup >::iterator const *self,std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup >::iterator other){
          return (*self != other);
        }
SWIGINTERN std::string std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttributeGroup_Sg__iterator_getKey(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup >::iterator const *self){
          return (*self)->first;
        }
SWIGINTERN RobotRaconteur::ServiceSubscriptionFilterAttributeGroup std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttributeGroup_Sg__iterator_getValue(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup >::iterator const *self){
          return (*self)->second;
        }
SWIGINTERN void std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttributeGroup_Sg__iterator_setValue(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup >::iterator *self,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup const &newValue){
          (*self)->second = newValue;
        }
SWIGINTERN jint std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttributeGroup_Sg__sizeImpl(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup > const *self){
        return SWIG_MapSize(self->size());
      }
SWIGINTERN bool std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttributeGroup_Sg__containsImpl(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup > *self,std::string const &key){
        return (self->count(key) > 0);
      }
SWIGINTERN void std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttributeGroup_Sg__putUnchecked(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup > *self,std::string const &key,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup const &value){
        (*self)[key] = value;
      }
SWIGINTERN void std_map_Sl_std_string_Sc_RobotRaconteur_ServiceSubscriptionFilterAttributeGroup_Sg__removeUnchecked(std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup > *self,std::map< std::string,RobotRaconteur::ServiceSubscriptionFilterAttributeGroup,std::less< std::string > >::iterator const itr){
        self->erase(itr);
      }
SWIGINTERN boost::shared_ptr< RobotRaconteur::RobotRaconteurNode > RobotRaconteur_RRLogRecord_GetNode(RobotRaconteur::RRLogRecord *self){
                return self->Node.lock();
            }
SWIGINTERN void RobotRaconteur_RRLogRecord_SetNode(RobotRaconteur::RRLogRecord *self,boost::shared_ptr< RobotRaconteur::RobotRaconteurNode > const &node){
                self->Node = node;
            }
SWIGINTERN std::string RobotRaconteur_RRLogRecord_ToString(RobotRaconteur::RRLogRecord *self){
                std::stringstream ss;
                ss << *self;
                return ss.str();
            }
SWIGINTERN RobotRaconteur::RobotRaconteurNodeSetup *new_RobotRaconteur_RobotRaconteurNodeSetup__SWIG_0(boost::shared_ptr< RobotRaconteur::RobotRaconteurNode > const &node,std::string const &node_name,uint16_t tcp_port,uint32_t flags){
				std::vector<RR_SHARED_PTR<ServiceFactory> > s;
				RobotRaconteurNodeSetup* n = new RobotRaconteurNodeSetup(node, s, node_name, tcp_port, flags);
				return n;
			}
SWIGINTERN RobotRaconteur::RobotRaconteurNodeSetup *new_RobotRaconteur_RobotRaconteurNodeSetup__SWIG_1(boost::shared_ptr< RobotRaconteur::RobotRaconteurNode > const &node,boost::shared_ptr< RobotRaconteur::CommandLineConfigParser > const &config){
				std::vector<RR_SHARED_PTR<ServiceFactory> > s;
				RobotRaconteurNodeSetup* n = new RobotRaconteurNodeSetup(node, s, config);
				return n;
			}
SWIGINTERN RobotRaconteur::RobotRaconteurNodeSetup *new_RobotRaconteur_RobotRaconteurNodeSetup__SWIG_2(boost::shared_ptr< RobotRaconteur::RobotRaconteurNode > const &node,std::string const &node_name,uint16_t tcp_port,uint32_t flags,uint32_t allowed_overrides,std::vector< std::string > const &args){
				std::vector<RR_SHARED_PTR<ServiceFactory> > s;
				RobotRaconteurNodeSetup* n = new RobotRaconteurNodeSetup(node, s, node_name, tcp_port, flags, allowed_overrides, args);
				return n;
			}


class RRMonitor
{
boost::recursive_timed_mutex mlock;
public:
	void lock()
	{
		mlock.lock();
	}

	bool tryLock(int timeout)
	{
		if (timeout==-1)
		{
			lock();
			return true;
		}
		return mlock.timed_lock(boost::posix_time::milliseconds(timeout));
	}

	void unlock()
	{
	mlock.unlock();
	}

};




class ClientServiceListenerDirector
{
public:

	int32_t objectheapid;

	ClientServiceListenerDirector()
	{
		objectheapid=0;
	}

	void OuterCallback(const boost::shared_ptr<RobotRaconteur::ClientContext>& c,ClientServiceListenerEventType code,const boost::shared_ptr<void>& p)
	{
		if (code == ClientServiceListenerEventType_ServicePathReleased)
		{
			std::string p1 = *RR_STATIC_POINTER_CAST<std::string>(p);
			DIRECTOR_CALL2(Callback2(code,p1));
		}
		else
		{
			DIRECTOR_CALL2(Callback(code));
		}
	}
	virtual void Callback(int32_t code) {};
	virtual void Callback2(int32_t code, const std::string& p) {};

	virtual ~ClientServiceListenerDirector()
	{

	}

};

SWIGINTERN boost::shared_ptr< RobotRaconteur::WrappedServiceStub > RobotRaconteur_RobotRaconteurNode_ConnectService__SWIG_0(RobotRaconteur::RobotRaconteurNode *self,std::string const &url,std::string const &username="",boost::intrusive_ptr< RobotRaconteur::MessageElementData > credentials=boost::intrusive_ptr< RobotRaconteur::MessageElementData >(),ClientServiceListenerDirector *listener=0,std::string const &objecttype=""){
		boost::shared_ptr<ClientServiceListenerDirector> listenerptr;
		if (listener)
		{
			listenerptr=boost::shared_ptr<ClientServiceListenerDirector>(listener,boost::bind(&ReleaseDirector<ClientServiceListenerDirector>,RR_BOOST_PLACEHOLDERS(_1),listener->objectheapid));
		}

		boost::intrusive_ptr<RRMap<std::string,RRValue> > credentials2;
		if (credentials) credentials2=rr_cast<RRMap<std::string,RRValue> >(self->UnpackMapType<std::string,RRValue>(rr_cast<MessageElementNestedElementList>(credentials)));
		boost::shared_ptr<WrappedServiceStub> stub;
		if (listener==0)
		{
			stub=rr_cast<WrappedServiceStub>(self->ConnectService(url,username,credentials2,RR_NULL_FN,objecttype));
		}
		else
		{

			stub=rr_cast<WrappedServiceStub>(self->ConnectService(url,username,credentials2,boost::bind(&ClientServiceListenerDirector::OuterCallback,listenerptr,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),RR_BOOST_PLACEHOLDERS(_3)),objecttype));
		}

		return stub;

	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::WrappedServiceStub > RobotRaconteur_RobotRaconteurNode_ConnectService__SWIG_5(RobotRaconteur::RobotRaconteurNode *self,std::vector< std::string > const &url,std::string const &username="",boost::intrusive_ptr< RobotRaconteur::MessageElementData > credentials=boost::intrusive_ptr< RobotRaconteur::MessageElementData >(),ClientServiceListenerDirector *listener=0,std::string const &objecttype=""){

		boost::shared_ptr<ClientServiceListenerDirector> listenerptr;
		if (listener)
		{
			listenerptr=boost::shared_ptr<ClientServiceListenerDirector>(listener,boost::bind(&ReleaseDirector<ClientServiceListenerDirector>,RR_BOOST_PLACEHOLDERS(_1),listener->objectheapid));
		}

		boost::intrusive_ptr<RRMap<std::string,RRValue> > credentials2;
		if (credentials) credentials2=rr_cast<RRMap<std::string,RRValue> >(self->UnpackMapType<std::string,RRValue>(rr_cast<MessageElementNestedElementList >(credentials)));
		boost::shared_ptr<WrappedServiceStub> stub;
		if (listener==0)
		{
			stub=rr_cast<WrappedServiceStub>(self->ConnectService(url,username,credentials2,RR_NULL_FN,objecttype));
		}
		else
		{

			stub=rr_cast<WrappedServiceStub>(self->ConnectService(url,username,credentials2,boost::bind(&ClientServiceListenerDirector::OuterCallback,listenerptr,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),RR_BOOST_PLACEHOLDERS(_3)),objecttype));
		}
		return stub;

	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_AsyncConnectService__SWIG_0(RobotRaconteur::RobotRaconteurNode *self,std::string const &url,std::string const &username,boost::intrusive_ptr< RobotRaconteur::MessageElementData > const &credentials,ClientServiceListenerDirector *listener,std::string const &objecttype,int32_t timeout,RobotRaconteur::AsyncStubReturnDirector *handler,int32_t id){

		boost::shared_ptr<AsyncStubReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncStubReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));

		boost::intrusive_ptr<RRMap<std::string,RRValue> > credentials2;
		if (credentials) credentials2=rr_cast<RRMap<std::string,RRValue> >(self->UnpackMapType<std::string,RRValue>(rr_cast<MessageElementNestedElementList >(credentials)));

		if (listener==0)
		{
			self->AsyncConnectService(url,username,credentials2,RR_NULL_FN,objecttype,boost::bind(&AsyncStubReturn_handler,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),sphandler),timeout);
		}
		else
		{
			boost::shared_ptr<ClientServiceListenerDirector> listenerptr=boost::shared_ptr<ClientServiceListenerDirector>(listener);
			self->AsyncConnectService(url,username,credentials2,boost::bind(&ClientServiceListenerDirector::OuterCallback,listenerptr,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),RR_BOOST_PLACEHOLDERS(_3)),objecttype,boost::bind(&AsyncStubReturn_handler,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),sphandler),timeout);
		}
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_AsyncConnectService__SWIG_1(RobotRaconteur::RobotRaconteurNode *self,std::vector< std::string > const &url,std::string const &username,boost::intrusive_ptr< RobotRaconteur::MessageElementData > const &credentials,ClientServiceListenerDirector *listener,std::string const &objecttype,int32_t timeout,RobotRaconteur::AsyncStubReturnDirector *handler,int32_t id){

		boost::shared_ptr<AsyncStubReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncStubReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));

		boost::intrusive_ptr<RRMap<std::string,RRValue> > credentials2;
		if (credentials) credentials2=rr_cast<RRMap<std::string,RRValue> >(self->UnpackMapType<std::string,RRValue>(rr_cast<MessageElementNestedElementList >(credentials)));

		if (listener==0)
		{
			self->AsyncConnectService(url,username,credentials2,RR_NULL_FN,objecttype,boost::bind(&AsyncStubReturn_handler,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),sphandler),timeout);
		}
		else
		{
			boost::shared_ptr<ClientServiceListenerDirector> listenerptr=boost::shared_ptr<ClientServiceListenerDirector>(listener);
			self->AsyncConnectService(url,username,credentials2,boost::bind(&ClientServiceListenerDirector::OuterCallback,listenerptr,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),RR_BOOST_PLACEHOLDERS(_3)),objecttype,boost::bind(&AsyncStubReturn_handler,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),sphandler),timeout);
		}
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_DisconnectService(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj){
		self->DisconnectService(obj);
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_AsyncDisconnectService(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj,RobotRaconteur::AsyncVoidNoErrReturnDirector *handler,int32_t id){
		boost::shared_ptr<AsyncVoidNoErrReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncVoidNoErrReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));
		self->AsyncDisconnectService(obj,boost::bind(&AsyncVoidNoErrReturn_handler,sphandler));
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_RegisterServiceType(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &def){











		self->RegisterServiceType(boost::make_shared<WrappedServiceFactory>(def));
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_RegisterServiceTypes(RobotRaconteur::RobotRaconteurNode *self,std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > const &defs){














		BOOST_FOREACH(const boost::shared_ptr<RobotRaconteur::ServiceDefinition>& def, defs)
		{
			self->RegisterServiceType(boost::make_shared<WrappedServiceFactory>(def));
		}
	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::ServiceDefinition > RobotRaconteur_RobotRaconteurNode_GetServiceType(RobotRaconteur::RobotRaconteurNode *self,std::string const &servicename){
		return rr_cast<WrappedServiceFactory>(self->GetServiceType(servicename))->ServiceDef();
	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::ServiceDefinition > RobotRaconteur_RobotRaconteurNode_GetPulledServiceType(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::RRObject > const &obj,std::string const &servicename){
		return rr_cast<WrappedServiceFactory>(self->GetPulledServiceType(obj,servicename))->ServiceDef();
	}
SWIGINTERN std::string RobotRaconteur_RobotRaconteurNode_RequestObjectLock(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj,RobotRaconteur::RobotRaconteurObjectLockFlags flags){
		return self->RequestObjectLock(obj,flags);
	}
SWIGINTERN std::string RobotRaconteur_RobotRaconteurNode_ReleaseObjectLock(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj){
		return self->ReleaseObjectLock(obj);
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_MonitorEnter__SWIG_0(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj,int32_t timeout=-1){
		self->MonitorEnter(obj,timeout);
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_MonitorExit(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj){
		self->MonitorExit(obj);
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_AsyncRequestObjectLock(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj,RobotRaconteur::RobotRaconteurObjectLockFlags flags,int32_t timeout,RobotRaconteur::AsyncStringReturnDirector *handler,int32_t id){
		boost::shared_ptr<AsyncStringReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncStringReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));
		return self->AsyncRequestObjectLock(obj,flags,boost::bind(&AsyncStringReturn_handler,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),sphandler),timeout);
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_AsyncReleaseObjectLock(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj,int32_t timeout,RobotRaconteur::AsyncStringReturnDirector *handler,int32_t id){
		boost::shared_ptr<AsyncStringReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncStringReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));
		return self->AsyncReleaseObjectLock(obj,boost::bind(&AsyncStringReturn_handler,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),sphandler),timeout);
	}
SWIGINTERN boost::intrusive_ptr< RobotRaconteur::MessageElement > RobotRaconteur_RobotRaconteurNode_GetServiceAttributes(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj){
			boost::intrusive_ptr<RRMap<std::string,RRValue> > map=AllocateEmptyRRMap<std::string,RRValue>();
			map->GetStorageContainer()=self->GetServiceAttributes(obj);
			boost::intrusive_ptr<MessageElementNestedElementList > mmap=self->PackMapType<std::string,RRValue>(map);
			return CreateMessageElement("value",mmap);
		}
SWIGINTERN RobotRaconteur::NodeID RobotRaconteur_RobotRaconteurNode_GetServiceNodeID(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj){
		return self->GetServiceNodeID(obj);
	}
SWIGINTERN std::string RobotRaconteur_RobotRaconteurNode_GetServiceNodeName(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj){
		return self->GetServiceNodeName(obj);
	}
SWIGINTERN std::string RobotRaconteur_RobotRaconteurNode_GetServiceName(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj){
		return self->GetServiceName(obj);
	}
SWIGINTERN std::string RobotRaconteur_RobotRaconteurNode_GetObjectServicePath(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj){
		return self->GetObjectServicePath(obj);
	}
SWIGINTERN std::string RobotRaconteur_RobotRaconteurNode_GetObjectType(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj){
		return self->GetObjectType(obj);
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_AsyncFindObjectType__SWIG_0(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj,std::string const &n,int32_t timeout,RobotRaconteur::AsyncStringReturnDirector *handler,int32_t id){
		boost::shared_ptr<AsyncStringReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncStringReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));
		return self->AsyncFindObjectType(obj,n,boost::bind(&AsyncStringReturn_handler,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),sphandler),timeout);
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_AsyncFindObjectType__SWIG_1(RobotRaconteur::RobotRaconteurNode *self,boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &obj,std::string const &n,std::string const &i,int32_t timeout,RobotRaconteur::AsyncStringReturnDirector *handler,int32_t id){
		boost::shared_ptr<AsyncStringReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncStringReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));
		return self->AsyncFindObjectType(obj,n,i,boost::bind(&AsyncStringReturn_handler,RR_BOOST_PLACEHOLDERS(_1),RR_BOOST_PLACEHOLDERS(_2),sphandler),timeout);
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_SetExceptionHandler(RobotRaconteur::RobotRaconteurNode *self,RobotRaconteur::AsyncVoidReturnDirector *handler,int32_t id){
		RR_SHARED_PTR<AsyncVoidReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncVoidReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));
		self->SetExceptionHandler(boost::bind(&WrappedExceptionHandler,RR_BOOST_PLACEHOLDERS(_1),sphandler));
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_ClearExceptionHandler(RobotRaconteur::RobotRaconteurNode *self){
		self->SetExceptionHandler(RR_NULL_FN);
	}
SWIGINTERN boost::shared_ptr< RobotRaconteur::Timer > RobotRaconteur_RobotRaconteurNode_CreateTimer(RobotRaconteur::RobotRaconteurNode *self,boost::posix_time::time_duration const &period,bool oneshot,RobotRaconteur::AsyncTimerEventReturnDirector *handler,int32_t id){
		boost::shared_ptr<AsyncTimerEventReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncTimerEventReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));
		return self->CreateTimer(period,boost::bind(&TimerHandlerFunc,RR_BOOST_PLACEHOLDERS(_1),sphandler),oneshot);
	}
SWIGINTERN void RobotRaconteur_RobotRaconteurNode_PostToThreadPool(RobotRaconteur::RobotRaconteurNode *self,RobotRaconteur::AsyncVoidNoErrReturnDirector *handler,int32_t id){
		boost::shared_ptr<AsyncVoidNoErrReturnDirector> sphandler(handler,boost::bind(&ReleaseDirector<AsyncVoidNoErrReturnDirector>,RR_BOOST_PLACEHOLDERS(_1),id));
		self->GetThreadPool()->Post(boost::bind(&AsyncVoidNoErrReturn_handler,sphandler));
	}


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "RobotRaconteurJavaJAVA_wrap.h"

SwigDirector_AsyncRequestDirector::SwigDirector_AsyncRequestDirector(JNIEnv *jenv) : RobotRaconteur::AsyncRequestDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncRequestDirector::~SwigDirector_AsyncRequestDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncRequestDirector::handler(boost::intrusive_ptr< RobotRaconteur::MessageElement > ret, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jret  ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncRequestDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    //jret = ret ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElement >(ret) : 0;
    if (ret) {
      intrusive_ptr_add_ref((&ret)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jret = new boost::shared_ptr< RobotRaconteur::MessageElement >((&ret)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElement >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jret = 0;
    }
    
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[0], swigjobj, jret, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncRequestDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncRequestDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/MessageElement;Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncRequestDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncVoidReturnDirector::SwigDirector_AsyncVoidReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncVoidReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncVoidReturnDirector::~SwigDirector_AsyncVoidReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncVoidReturnDirector::handler(RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncVoidReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[1], swigjobj, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncVoidReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncVoidReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncVoidReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncVoidNoErrReturnDirector::SwigDirector_AsyncVoidNoErrReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncVoidNoErrReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncVoidNoErrReturnDirector::~SwigDirector_AsyncVoidNoErrReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncVoidNoErrReturnDirector::handler() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncVoidNoErrReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[2], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncVoidNoErrReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncVoidNoErrReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "()V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncVoidNoErrReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncStringReturnDirector::SwigDirector_AsyncStringReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncStringReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncStringReturnDirector::~SwigDirector_AsyncStringReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncStringReturnDirector::handler(std::string const &ret, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jret = 0 ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncStringReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jret = jenv->NewStringUTF((&ret)->c_str());
    Swig::LocalRefGuard ret_refguard(jenv, jret); 
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[3], swigjobj, jret, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncStringReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncStringReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Ljava/lang/String;Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncStringReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncUInt32ReturnDirector::SwigDirector_AsyncUInt32ReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncUInt32ReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncUInt32ReturnDirector::~SwigDirector_AsyncUInt32ReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncUInt32ReturnDirector::handler(uint32_t ret, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jret  ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncUInt32ReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jret = (jlong) ret;
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[4], swigjobj, jret, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncUInt32ReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncUInt32ReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(JLcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncUInt32ReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncTimerEventReturnDirector::SwigDirector_AsyncTimerEventReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncTimerEventReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncTimerEventReturnDirector::~SwigDirector_AsyncTimerEventReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncTimerEventReturnDirector::handler(RobotRaconteur::TimerEvent const &ret, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jret = 0 ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncTimerEventReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(RobotRaconteur::TimerEvent **)&jret = (RobotRaconteur::TimerEvent *) &ret; 
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[5], swigjobj, jret, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncTimerEventReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncTimerEventReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/TimerEvent;Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncTimerEventReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedPipeEndpointDirector::SwigDirector_WrappedPipeEndpointDirector(JNIEnv *jenv) : RobotRaconteur::WrappedPipeEndpointDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedPipeEndpointDirector::~SwigDirector_WrappedPipeEndpointDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedPipeEndpointDirector::PipeEndpointClosedCallback() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPipeEndpointDirector::PipeEndpointClosedCallback.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[6], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPipeEndpointDirector::PipeEndpointClosedCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedPipeEndpointDirector::PacketReceivedEvent() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPipeEndpointDirector::PacketReceivedEvent.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[7], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPipeEndpointDirector::PacketReceivedEvent ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedPipeEndpointDirector::PacketAckReceivedEvent(uint32_t packetnum) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jpacketnum  ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPipeEndpointDirector::PacketAckReceivedEvent.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jpacketnum = (jlong) packetnum;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[8], swigjobj, jpacketnum);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPipeEndpointDirector::PacketAckReceivedEvent ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedPipeEndpointDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "pipeEndpointClosedCallback", "()V", NULL 
    },
    {
      "packetReceivedEvent", "()V", NULL 
    },
    {
      "packetAckReceivedEvent", "(J)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedPipeEndpointDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncPipeEndpointReturnDirector::SwigDirector_AsyncPipeEndpointReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncPipeEndpointReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncPipeEndpointReturnDirector::~SwigDirector_AsyncPipeEndpointReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncPipeEndpointReturnDirector::handler(boost::shared_ptr< RobotRaconteur::WrappedPipeEndpoint > const &ep, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jep = 0 ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncPipeEndpointReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jep = 0;
    if (ep) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedPipeEndpoint > **)&jep) = new boost::shared_ptr<  RobotRaconteur::WrappedPipeEndpoint >(ep);
    } 
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[9], swigjobj, jep, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncPipeEndpointReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncPipeEndpointReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/WrappedPipeEndpoint;Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncPipeEndpointReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedPipeServerConnectDirector::SwigDirector_WrappedPipeServerConnectDirector(JNIEnv *jenv) : RobotRaconteur::WrappedPipeServerConnectDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedPipeServerConnectDirector::~SwigDirector_WrappedPipeServerConnectDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedPipeServerConnectDirector::PipeConnectCallback(boost::shared_ptr< RobotRaconteur::WrappedPipeEndpoint > const &pipeendpoint) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jpipeendpoint = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPipeServerConnectDirector::PipeConnectCallback.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jpipeendpoint = 0;
    if (pipeendpoint) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedPipeEndpoint > **)&jpipeendpoint) = new boost::shared_ptr<  RobotRaconteur::WrappedPipeEndpoint >(pipeendpoint);
    } 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[10], swigjobj, jpipeendpoint);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPipeServerConnectDirector::PipeConnectCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedPipeServerConnectDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "pipeConnectCallback", "(Lcom/robotraconteur/WrappedPipeEndpoint;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedPipeServerConnectDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedPipeBroadcasterPredicateDirector::SwigDirector_WrappedPipeBroadcasterPredicateDirector(JNIEnv *jenv) : RobotRaconteur::WrappedPipeBroadcasterPredicateDirector(), Swig::Director(jenv) {
}

bool SwigDirector_WrappedPipeBroadcasterPredicateDirector::Predicate(uint32_t client_endpoint, int32_t index) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jclient_endpoint  ;
  jint jindex  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPipeBroadcasterPredicateDirector::Predicate.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclient_endpoint = (jlong) client_endpoint;
    jindex = (jint) index;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[11], swigjobj, jclient_endpoint, jindex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPipeBroadcasterPredicateDirector::Predicate ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_WrappedPipeBroadcasterPredicateDirector::~SwigDirector_WrappedPipeBroadcasterPredicateDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedPipeBroadcasterPredicateDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "predicate", "(JI)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedPipeBroadcasterPredicateDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedWireConnectionDirector::SwigDirector_WrappedWireConnectionDirector(JNIEnv *jenv) : RobotRaconteur::WrappedWireConnectionDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedWireConnectionDirector::~SwigDirector_WrappedWireConnectionDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedWireConnectionDirector::WireValueChanged(boost::intrusive_ptr< RobotRaconteur::MessageElement > value, RobotRaconteur::TimeSpec const &time) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvalue  ;
  jlong jtime = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedWireConnectionDirector::WireValueChanged.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    //jvalue = value ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElement >(value) : 0;
    if (value) {
      intrusive_ptr_add_ref((&value)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jvalue = new boost::shared_ptr< RobotRaconteur::MessageElement >((&value)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElement >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jvalue = 0;
    }
    
    *(RobotRaconteur::TimeSpec **)&jtime = (RobotRaconteur::TimeSpec *) &time; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[12], swigjobj, jvalue, jtime);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedWireConnectionDirector::WireValueChanged ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedWireConnectionDirector::WireConnectionClosedCallback() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedWireConnectionDirector::WireConnectionClosedCallback.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[13], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedWireConnectionDirector::WireConnectionClosedCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedWireConnectionDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "wireValueChanged", "(Lcom/robotraconteur/MessageElement;Lcom/robotraconteur/TimeSpec;)V", NULL 
    },
    {
      "wireConnectionClosedCallback", "()V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedWireConnectionDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncWireConnectionReturnDirector::SwigDirector_AsyncWireConnectionReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncWireConnectionReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncWireConnectionReturnDirector::~SwigDirector_AsyncWireConnectionReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncWireConnectionReturnDirector::handler(boost::shared_ptr< RobotRaconteur::WrappedWireConnection > const &ep, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jep = 0 ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncWireConnectionReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jep = 0;
    if (ep) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedWireConnection > **)&jep) = new boost::shared_ptr<  RobotRaconteur::WrappedWireConnection >(ep);
    } 
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[14], swigjobj, jep, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncWireConnectionReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncWireConnectionReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/WrappedWireConnection;Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncWireConnectionReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncWirePeekReturnDirector::SwigDirector_AsyncWirePeekReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncWirePeekReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncWirePeekReturnDirector::~SwigDirector_AsyncWirePeekReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncWirePeekReturnDirector::handler(boost::intrusive_ptr< RobotRaconteur::MessageElement > value, RobotRaconteur::TimeSpec const &ts, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvalue  ;
  jlong jts = 0 ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncWirePeekReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    //jvalue = value ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElement >(value) : 0;
    if (value) {
      intrusive_ptr_add_ref((&value)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jvalue = new boost::shared_ptr< RobotRaconteur::MessageElement >((&value)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElement >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jvalue = 0;
    }
    
    *(RobotRaconteur::TimeSpec **)&jts = (RobotRaconteur::TimeSpec *) &ts; 
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[15], swigjobj, jvalue, jts, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncWirePeekReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncWirePeekReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/MessageElement;Lcom/robotraconteur/TimeSpec;Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncWirePeekReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedWireServerConnectDirector::SwigDirector_WrappedWireServerConnectDirector(JNIEnv *jenv) : RobotRaconteur::WrappedWireServerConnectDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedWireServerConnectDirector::~SwigDirector_WrappedWireServerConnectDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedWireServerConnectDirector::WireConnectCallback(boost::shared_ptr< RobotRaconteur::WrappedWireConnection > const &c) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jc = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedWireServerConnectDirector::WireConnectCallback.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jc = 0;
    if (c) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedWireConnection > **)&jc) = new boost::shared_ptr<  RobotRaconteur::WrappedWireConnection >(c);
    } 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[16], swigjobj, jc);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedWireServerConnectDirector::WireConnectCallback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedWireServerConnectDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "wireConnectCallback", "(Lcom/robotraconteur/WrappedWireConnection;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedWireServerConnectDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedWireServerPeekValueDirector::SwigDirector_WrappedWireServerPeekValueDirector(JNIEnv *jenv) : RobotRaconteur::WrappedWireServerPeekValueDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedWireServerPeekValueDirector::~SwigDirector_WrappedWireServerPeekValueDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


boost::intrusive_ptr< RobotRaconteur::MessageElement > SwigDirector_WrappedWireServerPeekValueDirector::PeekValue(uint32_t const &ep) {
  boost::intrusive_ptr< RobotRaconteur::MessageElement > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jep = 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElement > *smartarg ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedWireServerPeekValueDirector::PeekValue.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jep = (jlong)ep;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[17], swigjobj, jep);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElement >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElement >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedWireServerPeekValueDirector::PeekValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedWireServerPeekValueDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "peekValue", "(J)Lcom/robotraconteur/MessageElement;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedWireServerPeekValueDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedWireServerPokeValueDirector::SwigDirector_WrappedWireServerPokeValueDirector(JNIEnv *jenv) : RobotRaconteur::WrappedWireServerPokeValueDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedWireServerPokeValueDirector::~SwigDirector_WrappedWireServerPokeValueDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedWireServerPokeValueDirector::PokeValue(boost::intrusive_ptr< RobotRaconteur::MessageElement > value, RobotRaconteur::TimeSpec const &ts, uint32_t const &ep) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvalue  ;
  jlong jts = 0 ;
  jlong jep = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedWireServerPokeValueDirector::PokeValue.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    //jvalue = value ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElement >(value) : 0;
    if (value) {
      intrusive_ptr_add_ref((&value)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jvalue = new boost::shared_ptr< RobotRaconteur::MessageElement >((&value)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElement >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jvalue = 0;
    }
    
    *(RobotRaconteur::TimeSpec **)&jts = (RobotRaconteur::TimeSpec *) &ts; 
    jep = (jlong)ep;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[18], swigjobj, jvalue, jts, jep);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedWireServerPokeValueDirector::PokeValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedWireServerPokeValueDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "pokeValue", "(Lcom/robotraconteur/MessageElement;Lcom/robotraconteur/TimeSpec;J)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedWireServerPokeValueDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedWireBroadcasterPredicateDirector::SwigDirector_WrappedWireBroadcasterPredicateDirector(JNIEnv *jenv) : RobotRaconteur::WrappedWireBroadcasterPredicateDirector(), Swig::Director(jenv) {
}

bool SwigDirector_WrappedWireBroadcasterPredicateDirector::Predicate(uint32_t client_endpoint) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jclient_endpoint  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedWireBroadcasterPredicateDirector::Predicate.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jclient_endpoint = (jlong) client_endpoint;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[19], swigjobj, jclient_endpoint);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedWireBroadcasterPredicateDirector::Predicate ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_WrappedWireBroadcasterPredicateDirector::~SwigDirector_WrappedWireBroadcasterPredicateDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedWireBroadcasterPredicateDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "predicate", "(J)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedWireBroadcasterPredicateDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedPodArrayMemoryClientBuffer::SwigDirector_WrappedPodArrayMemoryClientBuffer(JNIEnv *jenv) : RobotRaconteur::WrappedPodArrayMemoryClientBuffer(), Swig::Director(jenv) {
}

void SwigDirector_WrappedPodArrayMemoryClientBuffer::UnpackReadResult(boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > res, uint64_t bufferpos, uint64_t count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jres  ;
  jlong jbufferpos  ;
  jlong jcount  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodArrayMemoryClientBuffer::UnpackReadResult.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    //jres = res ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElementNestedElementList >(res) : 0;
    if (res) {
      intrusive_ptr_add_ref((&res)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jres = new boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >((&res)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElementNestedElementList >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jres = 0;
    }
    
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[20], swigjobj, jres, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodArrayMemoryClientBuffer::UnpackReadResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > SwigDirector_WrappedPodArrayMemoryClientBuffer::PackWriteRequest(uint64_t bufferpos, uint64_t count) {
  boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbufferpos  ;
  jlong jcount  ;
  boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > *smartarg ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodArrayMemoryClientBuffer::PackWriteRequest.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[21], swigjobj, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodArrayMemoryClientBuffer::PackWriteRequest ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

uint64_t SwigDirector_WrappedPodArrayMemoryClientBuffer::GetBufferLength() {
  uint64_t c_result = SwigValueInit< uint64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodArrayMemoryClientBuffer::GetBufferLength.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[22], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (uint64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodArrayMemoryClientBuffer::GetBufferLength ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_WrappedPodArrayMemoryClientBuffer::~SwigDirector_WrappedPodArrayMemoryClientBuffer() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedPodArrayMemoryClientBuffer::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "unpackReadResult", "(Lcom/robotraconteur/MessageElementNestedElementList;JJ)V", NULL 
    },
    {
      "packWriteRequest", "(JJ)Lcom/robotraconteur/MessageElementNestedElementList;", NULL 
    },
    {
      "getBufferLength", "()J", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedPodArrayMemoryClientBuffer");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedPodMultiDimArrayMemoryClientBuffer::SwigDirector_WrappedPodMultiDimArrayMemoryClientBuffer(JNIEnv *jenv) : RobotRaconteur::WrappedPodMultiDimArrayMemoryClientBuffer(), Swig::Director(jenv) {
}

void SwigDirector_WrappedPodMultiDimArrayMemoryClientBuffer::UnpackReadResult(boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > res, std::vector< uint64_t > const &bufferpos, std::vector< uint64_t > const &count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jres  ;
  jlong jbufferpos = 0 ;
  jlong jcount = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodMultiDimArrayMemoryClientBuffer::UnpackReadResult.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    //jres = res ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElementNestedElementList >(res) : 0;
    if (res) {
      intrusive_ptr_add_ref((&res)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jres = new boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >((&res)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElementNestedElementList >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jres = 0;
    }
    
    *(std::vector< uint64_t > **)&jbufferpos = (std::vector< uint64_t > *) &bufferpos; 
    *(std::vector< uint64_t > **)&jcount = (std::vector< uint64_t > *) &count; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[23], swigjobj, jres, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodMultiDimArrayMemoryClientBuffer::UnpackReadResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > SwigDirector_WrappedPodMultiDimArrayMemoryClientBuffer::PackWriteRequest(std::vector< uint64_t > const &bufferpos, std::vector< uint64_t > const &count) {
  boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbufferpos = 0 ;
  jlong jcount = 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > *smartarg ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodMultiDimArrayMemoryClientBuffer::PackWriteRequest.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< uint64_t > **)&jbufferpos = (std::vector< uint64_t > *) &bufferpos; 
    *(std::vector< uint64_t > **)&jcount = (std::vector< uint64_t > *) &count; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[24], swigjobj, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodMultiDimArrayMemoryClientBuffer::PackWriteRequest ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_WrappedPodMultiDimArrayMemoryClientBuffer::~SwigDirector_WrappedPodMultiDimArrayMemoryClientBuffer() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedPodMultiDimArrayMemoryClientBuffer::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "unpackReadResult", "(Lcom/robotraconteur/MessageElementNestedElementList;Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;)V", NULL 
    },
    {
      "packWriteRequest", "(Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;)Lcom/robotraconteur/MessageElementNestedElementList;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedPodMultiDimArrayMemoryClientBuffer");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedArrayMemoryDirector::SwigDirector_WrappedArrayMemoryDirector(JNIEnv *jenv) : RobotRaconteur::WrappedArrayMemoryDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedArrayMemoryDirector::~SwigDirector_WrappedArrayMemoryDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


uint64_t SwigDirector_WrappedArrayMemoryDirector::Length() {
  uint64_t c_result = SwigValueInit< uint64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedArrayMemoryDirector::Length.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[25], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (uint64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedArrayMemoryDirector::Length ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedArrayMemoryDirector::Read(uint64_t memorypos, boost::intrusive_ptr< RobotRaconteur::RRBaseArray > buffer, uint64_t bufferpos, uint64_t count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos  ;
  jlong jbuffer  ;
  jlong jbufferpos  ;
  jlong jcount  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedArrayMemoryDirector::Read.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmemorypos = (jlong) memorypos;
    
    //jbuffer = buffer ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::RRBaseArray >(buffer) : 0;
    if (buffer) {
      intrusive_ptr_add_ref((&buffer)->get());
      *(boost::shared_ptr< RobotRaconteur::RRBaseArray > **)&jbuffer = new boost::shared_ptr< RobotRaconteur::RRBaseArray >((&buffer)->get(), SWIG_intrusive_deleter< RobotRaconteur::RRBaseArray >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::RRBaseArray > **)&jbuffer = 0;
    }
    
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[26], swigjobj, jmemorypos, jbuffer, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedArrayMemoryDirector::Read ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedArrayMemoryDirector::Write(uint64_t memorypos, boost::intrusive_ptr< RobotRaconteur::RRBaseArray > buffer, uint64_t bufferpos, uint64_t count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos  ;
  jlong jbuffer  ;
  jlong jbufferpos  ;
  jlong jcount  ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedArrayMemoryDirector::Write.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmemorypos = (jlong) memorypos;
    
    //jbuffer = buffer ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::RRBaseArray >(buffer) : 0;
    if (buffer) {
      intrusive_ptr_add_ref((&buffer)->get());
      *(boost::shared_ptr< RobotRaconteur::RRBaseArray > **)&jbuffer = new boost::shared_ptr< RobotRaconteur::RRBaseArray >((&buffer)->get(), SWIG_intrusive_deleter< RobotRaconteur::RRBaseArray >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::RRBaseArray > **)&jbuffer = 0;
    }
    
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[27], swigjobj, jmemorypos, jbuffer, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedArrayMemoryDirector::Write ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedArrayMemoryDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "length", "()J", NULL 
    },
    {
      "read", "(JLcom/robotraconteur/RRBaseArray;JJ)V", NULL 
    },
    {
      "write", "(JLcom/robotraconteur/RRBaseArray;JJ)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedArrayMemoryDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedMultiDimArrayMemoryDirector::SwigDirector_WrappedMultiDimArrayMemoryDirector(JNIEnv *jenv) : RobotRaconteur::WrappedMultiDimArrayMemoryDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedMultiDimArrayMemoryDirector::~SwigDirector_WrappedMultiDimArrayMemoryDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::vector< uint64_t > SwigDirector_WrappedMultiDimArrayMemoryDirector::Dimensions() {
  std::vector< uint64_t > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  std::vector< uint64_t > *argp ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedMultiDimArrayMemoryDirector::Dimensions.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[28], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(std::vector< uint64_t > **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type std::vector< uint64_t >");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedMultiDimArrayMemoryDirector::Dimensions ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

uint64_t SwigDirector_WrappedMultiDimArrayMemoryDirector::DimCount() {
  uint64_t c_result = SwigValueInit< uint64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedMultiDimArrayMemoryDirector::DimCount.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[29], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (uint64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedMultiDimArrayMemoryDirector::DimCount ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedMultiDimArrayMemoryDirector::Read(RobotRaconteur::WrappedMultiDimArrayMemoryParams *p) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jp = 0 ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedMultiDimArrayMemoryDirector::Read.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((RobotRaconteur::WrappedMultiDimArrayMemoryParams **)&jp) = (RobotRaconteur::WrappedMultiDimArrayMemoryParams *) p; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[30], swigjobj, jp);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedMultiDimArrayMemoryDirector::Read ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedMultiDimArrayMemoryDirector::Write(RobotRaconteur::WrappedMultiDimArrayMemoryParams *p) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jp = 0 ;
  
  if (!swig_override[3]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedMultiDimArrayMemoryDirector::Write.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((RobotRaconteur::WrappedMultiDimArrayMemoryParams **)&jp) = (RobotRaconteur::WrappedMultiDimArrayMemoryParams *) p; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[31], swigjobj, jp);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedMultiDimArrayMemoryDirector::Write ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedMultiDimArrayMemoryDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "dimensions", "()Lcom/robotraconteur/vector_uint64_t;", NULL 
    },
    {
      "dimCount", "()J", NULL 
    },
    {
      "read", "(Lcom/robotraconteur/WrappedMultiDimArrayMemoryParams;)V", NULL 
    },
    {
      "write", "(Lcom/robotraconteur/WrappedMultiDimArrayMemoryParams;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedMultiDimArrayMemoryDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 4; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedPodArrayMemoryDirector::SwigDirector_WrappedPodArrayMemoryDirector(JNIEnv *jenv) : RobotRaconteur::WrappedPodArrayMemoryDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedPodArrayMemoryDirector::~SwigDirector_WrappedPodArrayMemoryDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


uint64_t SwigDirector_WrappedPodArrayMemoryDirector::Length() {
  uint64_t c_result = SwigValueInit< uint64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodArrayMemoryDirector::Length.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[32], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (uint64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodArrayMemoryDirector::Length ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > SwigDirector_WrappedPodArrayMemoryDirector::Read(uint64_t memorypos, uint64_t bufferpos, uint64_t count) {
  boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos  ;
  jlong jbufferpos  ;
  jlong jcount  ;
  boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > *smartarg ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodArrayMemoryDirector::Read.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmemorypos = (jlong) memorypos;
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[33], swigjobj, jmemorypos, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodArrayMemoryDirector::Read ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedPodArrayMemoryDirector::Write(uint64_t memorypos, boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > buffer, uint64_t bufferpos, uint64_t count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos  ;
  jlong jbuffer  ;
  jlong jbufferpos  ;
  jlong jcount  ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodArrayMemoryDirector::Write.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmemorypos = (jlong) memorypos;
    
    //jbuffer = buffer ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElementNestedElementList >(buffer) : 0;
    if (buffer) {
      intrusive_ptr_add_ref((&buffer)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jbuffer = new boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >((&buffer)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElementNestedElementList >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jbuffer = 0;
    }
    
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[34], swigjobj, jmemorypos, jbuffer, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodArrayMemoryDirector::Write ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedPodArrayMemoryDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "length", "()J", NULL 
    },
    {
      "read", "(JJJ)Lcom/robotraconteur/MessageElementNestedElementList;", NULL 
    },
    {
      "write", "(JLcom/robotraconteur/MessageElementNestedElementList;JJ)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedPodArrayMemoryDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedPodMultiDimArrayMemoryDirector::SwigDirector_WrappedPodMultiDimArrayMemoryDirector(JNIEnv *jenv) : RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedPodMultiDimArrayMemoryDirector::~SwigDirector_WrappedPodMultiDimArrayMemoryDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::vector< uint64_t > SwigDirector_WrappedPodMultiDimArrayMemoryDirector::Dimensions() {
  std::vector< uint64_t > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  std::vector< uint64_t > *argp ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector::Dimensions.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[35], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(std::vector< uint64_t > **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type std::vector< uint64_t >");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector::Dimensions ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

uint64_t SwigDirector_WrappedPodMultiDimArrayMemoryDirector::DimCount() {
  uint64_t c_result = SwigValueInit< uint64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector::DimCount.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[36], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (uint64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector::DimCount ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > SwigDirector_WrappedPodMultiDimArrayMemoryDirector::Read(std::vector< uint64_t > const &memorypos, std::vector< uint64_t > const &bufferpos, std::vector< uint64_t > const &count) {
  boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos = 0 ;
  jlong jbufferpos = 0 ;
  jlong jcount = 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > *smartarg ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector::Read.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< uint64_t > **)&jmemorypos = (std::vector< uint64_t > *) &memorypos; 
    *(std::vector< uint64_t > **)&jbufferpos = (std::vector< uint64_t > *) &bufferpos; 
    *(std::vector< uint64_t > **)&jcount = (std::vector< uint64_t > *) &count; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[37], swigjobj, jmemorypos, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector::Read ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedPodMultiDimArrayMemoryDirector::Write(std::vector< uint64_t > const &memorypos, boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > buffer, std::vector< uint64_t > const &bufferpos, std::vector< uint64_t > const &count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos = 0 ;
  jlong jbuffer  ;
  jlong jbufferpos = 0 ;
  jlong jcount = 0 ;
  
  if (!swig_override[3]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector::Write.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< uint64_t > **)&jmemorypos = (std::vector< uint64_t > *) &memorypos; 
    
    //jbuffer = buffer ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElementNestedElementList >(buffer) : 0;
    if (buffer) {
      intrusive_ptr_add_ref((&buffer)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jbuffer = new boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >((&buffer)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElementNestedElementList >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jbuffer = 0;
    }
    
    *(std::vector< uint64_t > **)&jbufferpos = (std::vector< uint64_t > *) &bufferpos; 
    *(std::vector< uint64_t > **)&jcount = (std::vector< uint64_t > *) &count; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[38], swigjobj, jmemorypos, jbuffer, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector::Write ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedPodMultiDimArrayMemoryDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "dimensions", "()Lcom/robotraconteur/vector_uint64_t;", NULL 
    },
    {
      "dimCount", "()J", NULL 
    },
    {
      "read", "(Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;)Lcom/robotraconteur/MessageElementNestedElementList;", NULL 
    },
    {
      "write", "(Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/MessageElementNestedElementList;Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedPodMultiDimArrayMemoryDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 4; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedNamedArrayMemoryClientBuffer::SwigDirector_WrappedNamedArrayMemoryClientBuffer(JNIEnv *jenv) : RobotRaconteur::WrappedNamedArrayMemoryClientBuffer(), Swig::Director(jenv) {
}

void SwigDirector_WrappedNamedArrayMemoryClientBuffer::UnpackReadResult(boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > res, uint64_t bufferpos, uint64_t count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jres  ;
  jlong jbufferpos  ;
  jlong jcount  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedArrayMemoryClientBuffer::UnpackReadResult.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    //jres = res ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElementNestedElementList >(res) : 0;
    if (res) {
      intrusive_ptr_add_ref((&res)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jres = new boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >((&res)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElementNestedElementList >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jres = 0;
    }
    
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[39], swigjobj, jres, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedArrayMemoryClientBuffer::UnpackReadResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > SwigDirector_WrappedNamedArrayMemoryClientBuffer::PackWriteRequest(uint64_t bufferpos, uint64_t count) {
  boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbufferpos  ;
  jlong jcount  ;
  boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > *smartarg ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedArrayMemoryClientBuffer::PackWriteRequest.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[40], swigjobj, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedArrayMemoryClientBuffer::PackWriteRequest ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

uint64_t SwigDirector_WrappedNamedArrayMemoryClientBuffer::GetBufferLength() {
  uint64_t c_result = SwigValueInit< uint64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedArrayMemoryClientBuffer::GetBufferLength.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[41], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (uint64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedArrayMemoryClientBuffer::GetBufferLength ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_WrappedNamedArrayMemoryClientBuffer::~SwigDirector_WrappedNamedArrayMemoryClientBuffer() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedNamedArrayMemoryClientBuffer::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "unpackReadResult", "(Lcom/robotraconteur/MessageElementNestedElementList;JJ)V", NULL 
    },
    {
      "packWriteRequest", "(JJ)Lcom/robotraconteur/MessageElementNestedElementList;", NULL 
    },
    {
      "getBufferLength", "()J", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedNamedArrayMemoryClientBuffer");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedNamedMultiDimArrayMemoryClientBuffer::SwigDirector_WrappedNamedMultiDimArrayMemoryClientBuffer(JNIEnv *jenv) : RobotRaconteur::WrappedNamedMultiDimArrayMemoryClientBuffer(), Swig::Director(jenv) {
}

void SwigDirector_WrappedNamedMultiDimArrayMemoryClientBuffer::UnpackReadResult(boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > res, std::vector< uint64_t > const &bufferpos, std::vector< uint64_t > const &count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jres  ;
  jlong jbufferpos = 0 ;
  jlong jcount = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedMultiDimArrayMemoryClientBuffer::UnpackReadResult.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    //jres = res ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElementNestedElementList >(res) : 0;
    if (res) {
      intrusive_ptr_add_ref((&res)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jres = new boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >((&res)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElementNestedElementList >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jres = 0;
    }
    
    *(std::vector< uint64_t > **)&jbufferpos = (std::vector< uint64_t > *) &bufferpos; 
    *(std::vector< uint64_t > **)&jcount = (std::vector< uint64_t > *) &count; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[42], swigjobj, jres, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedMultiDimArrayMemoryClientBuffer::UnpackReadResult ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > SwigDirector_WrappedNamedMultiDimArrayMemoryClientBuffer::PackWriteRequest(std::vector< uint64_t > const &bufferpos, std::vector< uint64_t > const &count) {
  boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbufferpos = 0 ;
  jlong jcount = 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > *smartarg ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedMultiDimArrayMemoryClientBuffer::PackWriteRequest.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< uint64_t > **)&jbufferpos = (std::vector< uint64_t > *) &bufferpos; 
    *(std::vector< uint64_t > **)&jcount = (std::vector< uint64_t > *) &count; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[43], swigjobj, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedMultiDimArrayMemoryClientBuffer::PackWriteRequest ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_WrappedNamedMultiDimArrayMemoryClientBuffer::~SwigDirector_WrappedNamedMultiDimArrayMemoryClientBuffer() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedNamedMultiDimArrayMemoryClientBuffer::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "unpackReadResult", "(Lcom/robotraconteur/MessageElementNestedElementList;Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;)V", NULL 
    },
    {
      "packWriteRequest", "(Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;)Lcom/robotraconteur/MessageElementNestedElementList;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedNamedMultiDimArrayMemoryClientBuffer");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedNamedArrayMemoryDirector::SwigDirector_WrappedNamedArrayMemoryDirector(JNIEnv *jenv) : RobotRaconteur::WrappedNamedArrayMemoryDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedNamedArrayMemoryDirector::~SwigDirector_WrappedNamedArrayMemoryDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


uint64_t SwigDirector_WrappedNamedArrayMemoryDirector::Length() {
  uint64_t c_result = SwigValueInit< uint64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedArrayMemoryDirector::Length.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[44], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (uint64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedArrayMemoryDirector::Length ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > SwigDirector_WrappedNamedArrayMemoryDirector::Read(uint64_t memorypos, uint64_t bufferpos, uint64_t count) {
  boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos  ;
  jlong jbufferpos  ;
  jlong jcount  ;
  boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > *smartarg ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedArrayMemoryDirector::Read.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmemorypos = (jlong) memorypos;
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[45], swigjobj, jmemorypos, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedArrayMemoryDirector::Read ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedNamedArrayMemoryDirector::Write(uint64_t memorypos, boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > buffer, uint64_t bufferpos, uint64_t count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos  ;
  jlong jbuffer  ;
  jlong jbufferpos  ;
  jlong jcount  ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedArrayMemoryDirector::Write.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmemorypos = (jlong) memorypos;
    
    //jbuffer = buffer ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElementNestedElementList >(buffer) : 0;
    if (buffer) {
      intrusive_ptr_add_ref((&buffer)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jbuffer = new boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >((&buffer)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElementNestedElementList >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jbuffer = 0;
    }
    
    jbufferpos = (jlong) bufferpos;
    jcount = (jlong) count;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[46], swigjobj, jmemorypos, jbuffer, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedArrayMemoryDirector::Write ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedNamedArrayMemoryDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "length", "()J", NULL 
    },
    {
      "read", "(JJJ)Lcom/robotraconteur/MessageElementNestedElementList;", NULL 
    },
    {
      "write", "(JLcom/robotraconteur/MessageElementNestedElementList;JJ)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedNamedArrayMemoryDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedNamedMultiDimArrayMemoryDirector::SwigDirector_WrappedNamedMultiDimArrayMemoryDirector(JNIEnv *jenv) : RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedNamedMultiDimArrayMemoryDirector::~SwigDirector_WrappedNamedMultiDimArrayMemoryDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::vector< uint64_t > SwigDirector_WrappedNamedMultiDimArrayMemoryDirector::Dimensions() {
  std::vector< uint64_t > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  std::vector< uint64_t > *argp ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector::Dimensions.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[47], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    argp = *(std::vector< uint64_t > **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type std::vector< uint64_t >");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector::Dimensions ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

uint64_t SwigDirector_WrappedNamedMultiDimArrayMemoryDirector::DimCount() {
  uint64_t c_result = SwigValueInit< uint64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector::DimCount.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[48], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (uint64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector::DimCount ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > SwigDirector_WrappedNamedMultiDimArrayMemoryDirector::Read(std::vector< uint64_t > const &memorypos, std::vector< uint64_t > const &bufferpos, std::vector< uint64_t > const &count) {
  boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos = 0 ;
  jlong jbufferpos = 0 ;
  jlong jcount = 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > *smartarg ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector::Read.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< uint64_t > **)&jmemorypos = (std::vector< uint64_t > *) &memorypos; 
    *(std::vector< uint64_t > **)&jbufferpos = (std::vector< uint64_t > *) &bufferpos; 
    *(std::vector< uint64_t > **)&jcount = (std::vector< uint64_t > *) &count; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[49], swigjobj, jmemorypos, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElementNestedElementList > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector::Read ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedNamedMultiDimArrayMemoryDirector::Write(std::vector< uint64_t > const &memorypos, boost::intrusive_ptr< RobotRaconteur::MessageElementNestedElementList > buffer, std::vector< uint64_t > const &bufferpos, std::vector< uint64_t > const &count) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmemorypos = 0 ;
  jlong jbuffer  ;
  jlong jbufferpos = 0 ;
  jlong jcount = 0 ;
  
  if (!swig_override[3]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector::Write.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< uint64_t > **)&jmemorypos = (std::vector< uint64_t > *) &memorypos; 
    
    //jbuffer = buffer ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElementNestedElementList >(buffer) : 0;
    if (buffer) {
      intrusive_ptr_add_ref((&buffer)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jbuffer = new boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList >((&buffer)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElementNestedElementList >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElementNestedElementList > **)&jbuffer = 0;
    }
    
    *(std::vector< uint64_t > **)&jbufferpos = (std::vector< uint64_t > *) &bufferpos; 
    *(std::vector< uint64_t > **)&jcount = (std::vector< uint64_t > *) &count; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[50], swigjobj, jmemorypos, jbuffer, jbufferpos, jcount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector::Write ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedNamedMultiDimArrayMemoryDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "dimensions", "()Lcom/robotraconteur/vector_uint64_t;", NULL 
    },
    {
      "dimCount", "()J", NULL 
    },
    {
      "read", "(Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;)Lcom/robotraconteur/MessageElementNestedElementList;", NULL 
    },
    {
      "write", "(Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/MessageElementNestedElementList;Lcom/robotraconteur/vector_uint64_t;Lcom/robotraconteur/vector_uint64_t;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedNamedMultiDimArrayMemoryDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 4; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncGeneratorClientReturnDirector::SwigDirector_AsyncGeneratorClientReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncGeneratorClientReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncGeneratorClientReturnDirector::~SwigDirector_AsyncGeneratorClientReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncGeneratorClientReturnDirector::handler(boost::shared_ptr< RobotRaconteur::WrappedGeneratorClient > const &ret, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jret = 0 ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncGeneratorClientReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jret = 0;
    if (ret) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedGeneratorClient > **)&jret) = new boost::shared_ptr<  RobotRaconteur::WrappedGeneratorClient >(ret);
    } 
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[51], swigjobj, jret, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncGeneratorClientReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncGeneratorClientReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/WrappedGeneratorClient;Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncGeneratorClientReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedGeneratorServerDirector::SwigDirector_WrappedGeneratorServerDirector(JNIEnv *jenv) : RobotRaconteur::WrappedGeneratorServerDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedGeneratorServerDirector::~SwigDirector_WrappedGeneratorServerDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


boost::intrusive_ptr< RobotRaconteur::MessageElement > SwigDirector_WrappedGeneratorServerDirector::Next(boost::intrusive_ptr< RobotRaconteur::MessageElement > m, boost::shared_ptr< RobotRaconteur::WrappedServiceSkelAsyncAdapter > const &async_adaptor) {
  boost::intrusive_ptr< RobotRaconteur::MessageElement > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jm  ;
  jlong jasync_adaptor = 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElement > *smartarg ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedGeneratorServerDirector::Next.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    //jm = m ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElement >(m) : 0;
    if (m) {
      intrusive_ptr_add_ref((&m)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jm = new boost::shared_ptr< RobotRaconteur::MessageElement >((&m)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElement >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jm = 0;
    }
    
    jasync_adaptor = 0;
    if (async_adaptor) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter > **)&jasync_adaptor) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter >(async_adaptor);
    } 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[52], swigjobj, jm, jasync_adaptor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElement >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElement >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedGeneratorServerDirector::Next ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedGeneratorServerDirector::Abort(boost::shared_ptr< RobotRaconteur::WrappedServiceSkelAsyncAdapter > const &async_adapter) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jasync_adapter = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedGeneratorServerDirector::Abort.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jasync_adapter = 0;
    if (async_adapter) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter > **)&jasync_adapter) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter >(async_adapter);
    } 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[53], swigjobj, jasync_adapter);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedGeneratorServerDirector::Abort ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedGeneratorServerDirector::Close(boost::shared_ptr< RobotRaconteur::WrappedServiceSkelAsyncAdapter > const &async_adapter) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jasync_adapter = 0 ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedGeneratorServerDirector::Close.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jasync_adapter = 0;
    if (async_adapter) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter > **)&jasync_adapter) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter >(async_adapter);
    } 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[54], swigjobj, jasync_adapter);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedGeneratorServerDirector::Close ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedGeneratorServerDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "next", "(Lcom/robotraconteur/MessageElement;Lcom/robotraconteur/WrappedServiceSkelAsyncAdapter;)Lcom/robotraconteur/MessageElement;", NULL 
    },
    {
      "abort", "(Lcom/robotraconteur/WrappedServiceSkelAsyncAdapter;)V", NULL 
    },
    {
      "close", "(Lcom/robotraconteur/WrappedServiceSkelAsyncAdapter;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedGeneratorServerDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedServiceStubDirector::SwigDirector_WrappedServiceStubDirector(JNIEnv *jenv) : RobotRaconteur::WrappedServiceStubDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedServiceStubDirector::~SwigDirector_WrappedServiceStubDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedServiceStubDirector::DispatchEvent(std::string const &EventName, std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > args) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jEventName = 0 ;
  jlong jargs  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceStubDirector::DispatchEvent.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jEventName = jenv->NewStringUTF((&EventName)->c_str());
    Swig::LocalRefGuard EventName_refguard(jenv, jEventName); 
    jargs = 0;
    *((std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > **)&jargs) = new std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >((const std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > &)args); 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[55], swigjobj, jEventName, jargs);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceStubDirector::DispatchEvent ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

boost::intrusive_ptr< RobotRaconteur::MessageElement > SwigDirector_WrappedServiceStubDirector::CallbackCall(std::string const &CallbackName, std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > args) {
  boost::intrusive_ptr< RobotRaconteur::MessageElement > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jCallbackName = 0 ;
  jlong jargs  ;
  boost::shared_ptr< RobotRaconteur::MessageElement > *smartarg ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceStubDirector::CallbackCall.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jCallbackName = jenv->NewStringUTF((&CallbackName)->c_str());
    Swig::LocalRefGuard CallbackName_refguard(jenv, jCallbackName); 
    jargs = 0;
    *((std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > **)&jargs) = new std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > >((const std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > &)args); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[56], swigjobj, jCallbackName, jargs);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElement >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElement >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceStubDirector::CallbackCall ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedServiceStubDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "dispatchEvent", "(Ljava/lang/String;Lcom/robotraconteur/vectorptr_messageelement;)V", NULL 
    },
    {
      "callbackCall", "(Ljava/lang/String;Lcom/robotraconteur/vectorptr_messageelement;)Lcom/robotraconteur/MessageElement;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedServiceStubDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncStubReturnDirector::SwigDirector_AsyncStubReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncStubReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncStubReturnDirector::~SwigDirector_AsyncStubReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncStubReturnDirector::handler(boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &stub, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jstub = 0 ;
  jlong jerror = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncStubReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jstub = 0;
    if (stub) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceStub > **)&jstub) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceStub >(stub);
    } 
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[57], swigjobj, jstub, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncStubReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncStubReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/WrappedServiceStub;Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncStubReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedServiceSkelDirector::SwigDirector_WrappedServiceSkelDirector(JNIEnv *jenv) : RobotRaconteur::WrappedServiceSkelDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedServiceSkelDirector::~SwigDirector_WrappedServiceSkelDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedServiceSkelDirector::Init(boost::shared_ptr< RobotRaconteur::WrappedServiceSkel > const &skel) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jskel = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::Init.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jskel = 0;
    if (skel) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSkel > **)&jskel) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSkel >(skel);
    } 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[58], swigjobj, jskel);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::Init ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

boost::intrusive_ptr< RobotRaconteur::MessageElement > SwigDirector_WrappedServiceSkelDirector::CallGetProperty(std::string const &name, boost::shared_ptr< RobotRaconteur::WrappedServiceSkelAsyncAdapter > const &async_adaptor) {
  boost::intrusive_ptr< RobotRaconteur::MessageElement > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  jlong jasync_adaptor = 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElement > *smartarg ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::CallGetProperty.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    jasync_adaptor = 0;
    if (async_adaptor) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter > **)&jasync_adaptor) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter >(async_adaptor);
    } 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[59], swigjobj, jname, jasync_adaptor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElement >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElement >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::CallGetProperty ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedServiceSkelDirector::CallSetProperty(std::string const &name, boost::intrusive_ptr< RobotRaconteur::MessageElement > m, boost::shared_ptr< RobotRaconteur::WrappedServiceSkelAsyncAdapter > const &async_adaptor) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  jlong jm  ;
  jlong jasync_adaptor = 0 ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::CallSetProperty.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    
    //jm = m ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElement >(m) : 0;
    if (m) {
      intrusive_ptr_add_ref((&m)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jm = new boost::shared_ptr< RobotRaconteur::MessageElement >((&m)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElement >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jm = 0;
    }
    
    jasync_adaptor = 0;
    if (async_adaptor) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter > **)&jasync_adaptor) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter >(async_adaptor);
    } 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[60], swigjobj, jname, jm, jasync_adaptor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::CallSetProperty ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

boost::intrusive_ptr< RobotRaconteur::MessageElement > SwigDirector_WrappedServiceSkelDirector::CallFunction(std::string const &name, std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > const &m, boost::shared_ptr< RobotRaconteur::WrappedServiceSkelAsyncAdapter > const &async_adaptor) {
  boost::intrusive_ptr< RobotRaconteur::MessageElement > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  jlong jm = 0 ;
  jlong jasync_adaptor = 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElement > *smartarg ;
  
  if (!swig_override[3]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::CallFunction.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    *(std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > **)&jm = (std::vector< boost::intrusive_ptr< RobotRaconteur::MessageElement > > *) &m; 
    jasync_adaptor = 0;
    if (async_adaptor) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter > **)&jasync_adaptor) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSkelAsyncAdapter >(async_adaptor);
    } 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[61], swigjobj, jname, jm, jasync_adaptor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    
    //if (jresult) {
    //    SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *smartarg = (SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< CONST RobotRaconteur::MessageElement > *)jresult;
    //    c_result = *smartarg;
    //  }
    smartarg = *(boost::shared_ptr< RobotRaconteur::MessageElement >**)&jresult;
    if (smartarg) {
      c_result = boost::intrusive_ptr< RobotRaconteur::MessageElement >(smartarg->get(), true);
    }
    
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::CallFunction ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

boost::shared_ptr< RobotRaconteur::WrappedRRObject > SwigDirector_WrappedServiceSkelDirector::GetSubObj(std::string const &name, std::string const &index) {
  boost::shared_ptr< RobotRaconteur::WrappedRRObject > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  jstring jindex = 0 ;
  
  if (!swig_override[4]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::GetSubObj.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    jindex = jenv->NewStringUTF((&index)->c_str());
    Swig::LocalRefGuard index_refguard(jenv, jindex); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[62], swigjobj, jname, jindex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if (jresult) {
      boost::shared_ptr< RobotRaconteur::WrappedRRObject > * smartarg = *(boost::shared_ptr<  RobotRaconteur::WrappedRRObject > **)&jresult;
      c_result = *smartarg;
    } 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::GetSubObj ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

RobotRaconteur::WrappedArrayMemoryDirector *SwigDirector_WrappedServiceSkelDirector::GetArrayMemory(std::string const &name) {
  RobotRaconteur::WrappedArrayMemoryDirector *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  
  if (!swig_override[5]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::GetArrayMemory.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[63], swigjobj, jname);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = *(RobotRaconteur::WrappedArrayMemoryDirector **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::GetArrayMemory ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

RobotRaconteur::WrappedMultiDimArrayMemoryDirector *SwigDirector_WrappedServiceSkelDirector::GetMultiDimArrayMemory(std::string const &name) {
  RobotRaconteur::WrappedMultiDimArrayMemoryDirector *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  
  if (!swig_override[6]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::GetMultiDimArrayMemory.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[64], swigjobj, jname);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = *(RobotRaconteur::WrappedMultiDimArrayMemoryDirector **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::GetMultiDimArrayMemory ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

RobotRaconteur::WrappedPodArrayMemoryDirector *SwigDirector_WrappedServiceSkelDirector::GetPodArrayMemory(std::string const &name) {
  RobotRaconteur::WrappedPodArrayMemoryDirector *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  
  if (!swig_override[7]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::GetPodArrayMemory.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[65], swigjobj, jname);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = *(RobotRaconteur::WrappedPodArrayMemoryDirector **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::GetPodArrayMemory ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector *SwigDirector_WrappedServiceSkelDirector::GetPodMultiDimArrayMemory(std::string const &name) {
  RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  
  if (!swig_override[8]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::GetPodMultiDimArrayMemory.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[66], swigjobj, jname);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = *(RobotRaconteur::WrappedPodMultiDimArrayMemoryDirector **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::GetPodMultiDimArrayMemory ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

RobotRaconteur::WrappedNamedArrayMemoryDirector *SwigDirector_WrappedServiceSkelDirector::GetNamedArrayMemory(std::string const &name) {
  RobotRaconteur::WrappedNamedArrayMemoryDirector *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  
  if (!swig_override[9]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::GetNamedArrayMemory.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[67], swigjobj, jname);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = *(RobotRaconteur::WrappedNamedArrayMemoryDirector **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::GetNamedArrayMemory ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector *SwigDirector_WrappedServiceSkelDirector::GetNamedMultiDimArrayMemory(std::string const &name) {
  RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  
  if (!swig_override[10]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::GetNamedMultiDimArrayMemory.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = jenv->NewStringUTF((&name)->c_str());
    Swig::LocalRefGuard name_refguard(jenv, jname); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[68], swigjobj, jname);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = *(RobotRaconteur::WrappedNamedMultiDimArrayMemoryDirector **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::GetNamedMultiDimArrayMemory ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedServiceSkelDirector::MonitorEnter(int32_t timeout) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jtimeout  ;
  
  if (!swig_override[11]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::MonitorEnter.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jtimeout = (jint) timeout;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[69], swigjobj, jtimeout);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::MonitorEnter ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedServiceSkelDirector::MonitorExit() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[12]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::MonitorExit.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[70], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::MonitorExit ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedServiceSkelDirector::ReleaseCastObject() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[13]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSkelDirector::ReleaseCastObject.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[71], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSkelDirector::ReleaseCastObject ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedServiceSkelDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "init", "(Lcom/robotraconteur/WrappedServiceSkel;)V", NULL 
    },
    {
      "_CallGetProperty", "(Ljava/lang/String;Lcom/robotraconteur/WrappedServiceSkelAsyncAdapter;)Lcom/robotraconteur/MessageElement;", NULL 
    },
    {
      "_CallSetProperty", "(Ljava/lang/String;Lcom/robotraconteur/MessageElement;Lcom/robotraconteur/WrappedServiceSkelAsyncAdapter;)V", NULL 
    },
    {
      "_CallFunction", "(Ljava/lang/String;Lcom/robotraconteur/vectorptr_messageelement;Lcom/robotraconteur/WrappedServiceSkelAsyncAdapter;)Lcom/robotraconteur/MessageElement;", NULL 
    },
    {
      "_GetSubObj", "(Ljava/lang/String;Ljava/lang/String;)Lcom/robotraconteur/WrappedRRObject;", NULL 
    },
    {
      "_GetArrayMemory", "(Ljava/lang/String;)Lcom/robotraconteur/WrappedArrayMemoryDirector;", NULL 
    },
    {
      "_GetMultiDimArrayMemory", "(Ljava/lang/String;)Lcom/robotraconteur/WrappedMultiDimArrayMemoryDirector;", NULL 
    },
    {
      "_GetPodArrayMemory", "(Ljava/lang/String;)Lcom/robotraconteur/WrappedPodArrayMemoryDirector;", NULL 
    },
    {
      "_GetPodMultiDimArrayMemory", "(Ljava/lang/String;)Lcom/robotraconteur/WrappedPodMultiDimArrayMemoryDirector;", NULL 
    },
    {
      "_GetNamedArrayMemory", "(Ljava/lang/String;)Lcom/robotraconteur/WrappedNamedArrayMemoryDirector;", NULL 
    },
    {
      "_GetNamedMultiDimArrayMemory", "(Ljava/lang/String;)Lcom/robotraconteur/WrappedNamedMultiDimArrayMemoryDirector;", NULL 
    },
    {
      "monitorEnter", "(I)V", NULL 
    },
    {
      "monitorExit", "()V", NULL 
    },
    {
      "releaseCastObject", "()V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedServiceSkelDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 14; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ServerServiceListenerDirector::SwigDirector_ServerServiceListenerDirector(JNIEnv *jenv) : ServerServiceListenerDirector(), Swig::Director(jenv) {
}

void SwigDirector_ServerServiceListenerDirector::Callback(int32_t code, uint32_t endpoint) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jcode  ;
  jlong jendpoint  ;
  
  if (!swig_override[0]) {
    ServerServiceListenerDirector::Callback(code,endpoint);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jcode = (jint) code;
    jendpoint = (jlong) endpoint;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[72], swigjobj, jcode, jendpoint);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ServerServiceListenerDirector::Callback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_ServerServiceListenerDirector::~SwigDirector_ServerServiceListenerDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_ServerServiceListenerDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "callback", "(IJ)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/ServerServiceListenerDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedUserAuthenticatorDirector::SwigDirector_WrappedUserAuthenticatorDirector(JNIEnv *jenv) : RobotRaconteur::WrappedUserAuthenticatorDirector(), Swig::Director(jenv) {
}

SwigDirector_WrappedUserAuthenticatorDirector::~SwigDirector_WrappedUserAuthenticatorDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


boost::shared_ptr< RobotRaconteur::AuthenticatedUser > SwigDirector_WrappedUserAuthenticatorDirector::AuthenticateUser(std::string const &username, boost::intrusive_ptr< RobotRaconteur::MessageElement > credentials, boost::shared_ptr< RobotRaconteur::ServerContext > const &context) {
  boost::shared_ptr< RobotRaconteur::AuthenticatedUser > c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jusername = 0 ;
  jlong jcredentials  ;
  jlong jcontext = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedUserAuthenticatorDirector::AuthenticateUser.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jusername = jenv->NewStringUTF((&username)->c_str());
    Swig::LocalRefGuard username_refguard(jenv, jusername); 
    
    //jcredentials = credentials ? new SWIG_SHARED_PTR_QNAMESPACE::shared_ptr< RobotRaconteur::MessageElement >(credentials) : 0;
    if (credentials) {
      intrusive_ptr_add_ref((&credentials)->get());
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jcredentials = new boost::shared_ptr< RobotRaconteur::MessageElement >((&credentials)->get(), SWIG_intrusive_deleter< RobotRaconteur::MessageElement >());
    } else {
      *(boost::shared_ptr< RobotRaconteur::MessageElement > **)&jcredentials = 0;
    }
    
    jcontext = 0;
    if (context) {
      *((boost::shared_ptr<  RobotRaconteur::ServerContext > **)&jcontext) = new boost::shared_ptr<  RobotRaconteur::ServerContext >(context);
    } 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[73], swigjobj, jusername, jcredentials, jcontext);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if (jresult) {
      boost::shared_ptr< RobotRaconteur::AuthenticatedUser > * smartarg = *(boost::shared_ptr<  RobotRaconteur::AuthenticatedUser > **)&jresult;
      c_result = *smartarg;
    } 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedUserAuthenticatorDirector::AuthenticateUser ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_WrappedUserAuthenticatorDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "authenticateUser", "(Ljava/lang/String;Lcom/robotraconteur/MessageElement;Lcom/robotraconteur/ServerContext;)Lcom/robotraconteur/AuthenticatedUser;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedUserAuthenticatorDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncServiceInfo2VectorReturnDirector::SwigDirector_AsyncServiceInfo2VectorReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncServiceInfo2VectorReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncServiceInfo2VectorReturnDirector::~SwigDirector_AsyncServiceInfo2VectorReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncServiceInfo2VectorReturnDirector::handler(std::vector< RobotRaconteur::ServiceInfo2Wrapped > const &ret) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jret = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncServiceInfo2VectorReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< RobotRaconteur::ServiceInfo2Wrapped > **)&jret = (std::vector< RobotRaconteur::ServiceInfo2Wrapped > *) &ret; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[74], swigjobj, jret);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncServiceInfo2VectorReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncServiceInfo2VectorReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/vectorserviceinfo2wrapped;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncServiceInfo2VectorReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_AsyncNodeInfo2VectorReturnDirector::SwigDirector_AsyncNodeInfo2VectorReturnDirector(JNIEnv *jenv) : RobotRaconteur::AsyncNodeInfo2VectorReturnDirector(), Swig::Director(jenv) {
}

SwigDirector_AsyncNodeInfo2VectorReturnDirector::~SwigDirector_AsyncNodeInfo2VectorReturnDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_AsyncNodeInfo2VectorReturnDirector::handler(std::vector< RobotRaconteur::NodeInfo2 > const &ret) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jret = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::AsyncNodeInfo2VectorReturnDirector::handler.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::vector< RobotRaconteur::NodeInfo2 > **)&jret = (std::vector< RobotRaconteur::NodeInfo2 > *) &ret; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[75], swigjobj, jret);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::AsyncNodeInfo2VectorReturnDirector::handler ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_AsyncNodeInfo2VectorReturnDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handler", "(Lcom/robotraconteur/vectornodeinfo2;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/AsyncNodeInfo2VectorReturnDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedServiceSubscriptionFilterPredicateDirector::SwigDirector_WrappedServiceSubscriptionFilterPredicateDirector(JNIEnv *jenv) : RobotRaconteur::WrappedServiceSubscriptionFilterPredicateDirector(), Swig::Director(jenv) {
}

bool SwigDirector_WrappedServiceSubscriptionFilterPredicateDirector::Predicate(RobotRaconteur::ServiceInfo2Wrapped const &info) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jinfo = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSubscriptionFilterPredicateDirector::Predicate.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(RobotRaconteur::ServiceInfo2Wrapped **)&jinfo = (RobotRaconteur::ServiceInfo2Wrapped *) &info; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[76], swigjobj, jinfo);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSubscriptionFilterPredicateDirector::Predicate ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_WrappedServiceSubscriptionFilterPredicateDirector::~SwigDirector_WrappedServiceSubscriptionFilterPredicateDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedServiceSubscriptionFilterPredicateDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "predicate", "(Lcom/robotraconteur/ServiceInfo2Wrapped;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedServiceSubscriptionFilterPredicateDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedServiceInfo2SubscriptionDirector::SwigDirector_WrappedServiceInfo2SubscriptionDirector(JNIEnv *jenv) : RobotRaconteur::WrappedServiceInfo2SubscriptionDirector(), Swig::Director(jenv) {
}

void SwigDirector_WrappedServiceInfo2SubscriptionDirector::ServiceDetected(boost::shared_ptr< RobotRaconteur::WrappedServiceInfo2Subscription > const &subscription, RobotRaconteur::ServiceSubscriptionClientID const &id, RobotRaconteur::ServiceInfo2Wrapped const &service) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jsubscription = 0 ;
  jlong jid = 0 ;
  jlong jservice = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceInfo2SubscriptionDirector::ServiceDetected.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jsubscription = 0;
    if (subscription) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceInfo2Subscription > **)&jsubscription) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceInfo2Subscription >(subscription);
    } 
    *(RobotRaconteur::ServiceSubscriptionClientID **)&jid = (RobotRaconteur::ServiceSubscriptionClientID *) &id; 
    *(RobotRaconteur::ServiceInfo2Wrapped **)&jservice = (RobotRaconteur::ServiceInfo2Wrapped *) &service; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[77], swigjobj, jsubscription, jid, jservice);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceInfo2SubscriptionDirector::ServiceDetected ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedServiceInfo2SubscriptionDirector::ServiceLost(boost::shared_ptr< RobotRaconteur::WrappedServiceInfo2Subscription > const &subscription, RobotRaconteur::ServiceSubscriptionClientID const &id, RobotRaconteur::ServiceInfo2Wrapped const &service) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jsubscription = 0 ;
  jlong jid = 0 ;
  jlong jservice = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceInfo2SubscriptionDirector::ServiceLost.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jsubscription = 0;
    if (subscription) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceInfo2Subscription > **)&jsubscription) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceInfo2Subscription >(subscription);
    } 
    *(RobotRaconteur::ServiceSubscriptionClientID **)&jid = (RobotRaconteur::ServiceSubscriptionClientID *) &id; 
    *(RobotRaconteur::ServiceInfo2Wrapped **)&jservice = (RobotRaconteur::ServiceInfo2Wrapped *) &service; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[78], swigjobj, jsubscription, jid, jservice);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceInfo2SubscriptionDirector::ServiceLost ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_WrappedServiceInfo2SubscriptionDirector::~SwigDirector_WrappedServiceInfo2SubscriptionDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedServiceInfo2SubscriptionDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "serviceDetected", "(Lcom/robotraconteur/WrappedServiceInfo2Subscription;Lcom/robotraconteur/WrappedServiceSubscriptionClientID;Lcom/robotraconteur/ServiceInfo2Wrapped;)V", NULL 
    },
    {
      "serviceLost", "(Lcom/robotraconteur/WrappedServiceInfo2Subscription;Lcom/robotraconteur/WrappedServiceSubscriptionClientID;Lcom/robotraconteur/ServiceInfo2Wrapped;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedServiceInfo2SubscriptionDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedServiceSubscriptionDirector::SwigDirector_WrappedServiceSubscriptionDirector(JNIEnv *jenv) : RobotRaconteur::WrappedServiceSubscriptionDirector(), Swig::Director(jenv) {
}

void SwigDirector_WrappedServiceSubscriptionDirector::ClientConnected(boost::shared_ptr< RobotRaconteur::WrappedServiceSubscription > const &subscription, RobotRaconteur::ServiceSubscriptionClientID const &id, boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &silent) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jsubscription = 0 ;
  jlong jid = 0 ;
  jlong jsilent = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSubscriptionDirector::ClientConnected.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jsubscription = 0;
    if (subscription) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSubscription > **)&jsubscription) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSubscription >(subscription);
    } 
    *(RobotRaconteur::ServiceSubscriptionClientID **)&jid = (RobotRaconteur::ServiceSubscriptionClientID *) &id; 
    jsilent = 0;
    if (silent) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceStub > **)&jsilent) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceStub >(silent);
    } 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[79], swigjobj, jsubscription, jid, jsilent);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSubscriptionDirector::ClientConnected ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedServiceSubscriptionDirector::ClientDisconnected(boost::shared_ptr< RobotRaconteur::WrappedServiceSubscription > const &subscription, RobotRaconteur::ServiceSubscriptionClientID const &id, boost::shared_ptr< RobotRaconteur::WrappedServiceStub > const &silent) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jsubscription = 0 ;
  jlong jid = 0 ;
  jlong jsilent = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSubscriptionDirector::ClientDisconnected.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jsubscription = 0;
    if (subscription) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSubscription > **)&jsubscription) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSubscription >(subscription);
    } 
    *(RobotRaconteur::ServiceSubscriptionClientID **)&jid = (RobotRaconteur::ServiceSubscriptionClientID *) &id; 
    jsilent = 0;
    if (silent) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceStub > **)&jsilent) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceStub >(silent);
    } 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[80], swigjobj, jsubscription, jid, jsilent);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSubscriptionDirector::ClientDisconnected ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_WrappedServiceSubscriptionDirector::ClientConnectFailed(boost::shared_ptr< RobotRaconteur::WrappedServiceSubscription > const &subscription, RobotRaconteur::ServiceSubscriptionClientID const &id, std::vector< std::string > const &url, RobotRaconteur::HandlerErrorInfo &error) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jsubscription = 0 ;
  jlong jid = 0 ;
  jlong jurl = 0 ;
  jlong jerror = 0 ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedServiceSubscriptionDirector::ClientConnectFailed.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jsubscription = 0;
    if (subscription) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedServiceSubscription > **)&jsubscription) = new boost::shared_ptr<  RobotRaconteur::WrappedServiceSubscription >(subscription);
    } 
    *(RobotRaconteur::ServiceSubscriptionClientID **)&jid = (RobotRaconteur::ServiceSubscriptionClientID *) &id; 
    *(std::vector< std::string > **)&jurl = (std::vector< std::string > *) &url; 
    *(RobotRaconteur::HandlerErrorInfo **)&jerror = (RobotRaconteur::HandlerErrorInfo *) &error; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[81], swigjobj, jsubscription, jid, jurl, jerror);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedServiceSubscriptionDirector::ClientConnectFailed ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_WrappedServiceSubscriptionDirector::~SwigDirector_WrappedServiceSubscriptionDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedServiceSubscriptionDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "clientConnected", "(Lcom/robotraconteur/WrappedServiceSubscription;Lcom/robotraconteur/WrappedServiceSubscriptionClientID;Lcom/robotraconteur/WrappedServiceStub;)V", NULL 
    },
    {
      "clientDisconnected", "(Lcom/robotraconteur/WrappedServiceSubscription;Lcom/robotraconteur/WrappedServiceSubscriptionClientID;Lcom/robotraconteur/WrappedServiceStub;)V", NULL 
    },
    {
      "clientConnectFailed", "(Lcom/robotraconteur/WrappedServiceSubscription;Lcom/robotraconteur/WrappedServiceSubscriptionClientID;Lcom/robotraconteur/vectorstring;Lcom/robotraconteur/HandlerErrorInfo;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedServiceSubscriptionDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedWireSubscriptionDirector::SwigDirector_WrappedWireSubscriptionDirector(JNIEnv *jenv) : RobotRaconteur::WrappedWireSubscriptionDirector(), Swig::Director(jenv) {
}

void SwigDirector_WrappedWireSubscriptionDirector::WireValueChanged(boost::shared_ptr< RobotRaconteur::WrappedWireSubscription > const &wire_subscription, RobotRaconteur::WrappedService_typed_packet &value, RobotRaconteur::TimeSpec const &time) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jwire_subscription = 0 ;
  jlong jvalue = 0 ;
  jlong jtime = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedWireSubscriptionDirector::WireValueChanged.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jwire_subscription = 0;
    if (wire_subscription) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedWireSubscription > **)&jwire_subscription) = new boost::shared_ptr<  RobotRaconteur::WrappedWireSubscription >(wire_subscription);
    } 
    *(RobotRaconteur::WrappedService_typed_packet **)&jvalue = (RobotRaconteur::WrappedService_typed_packet *) &value; 
    *(RobotRaconteur::TimeSpec **)&jtime = (RobotRaconteur::TimeSpec *) &time; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[82], swigjobj, jwire_subscription, jvalue, jtime);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedWireSubscriptionDirector::WireValueChanged ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_WrappedWireSubscriptionDirector::~SwigDirector_WrappedWireSubscriptionDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedWireSubscriptionDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "wireValueChanged", "(Lcom/robotraconteur/WrappedWireSubscription;Lcom/robotraconteur/WrappedService_typed_packet;Lcom/robotraconteur/TimeSpec;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedWireSubscriptionDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_WrappedPipeSubscriptionDirector::SwigDirector_WrappedPipeSubscriptionDirector(JNIEnv *jenv) : RobotRaconteur::WrappedPipeSubscriptionDirector(), Swig::Director(jenv) {
}

void SwigDirector_WrappedPipeSubscriptionDirector::PipePacketReceived(boost::shared_ptr< RobotRaconteur::WrappedPipeSubscription > const &pipe_subscription) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jpipe_subscription = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::WrappedPipeSubscriptionDirector::PipePacketReceived.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jpipe_subscription = 0;
    if (pipe_subscription) {
      *((boost::shared_ptr<  RobotRaconteur::WrappedPipeSubscription > **)&jpipe_subscription) = new boost::shared_ptr<  RobotRaconteur::WrappedPipeSubscription >(pipe_subscription);
    } 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[83], swigjobj, jpipe_subscription);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::WrappedPipeSubscriptionDirector::PipePacketReceived ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_WrappedPipeSubscriptionDirector::~SwigDirector_WrappedPipeSubscriptionDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_WrappedPipeSubscriptionDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "pipePacketReceived", "(Lcom/robotraconteur/WrappedPipeSubscription;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/WrappedPipeSubscriptionDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_UserLogRecordHandlerDirector::SwigDirector_UserLogRecordHandlerDirector(JNIEnv *jenv) : RobotRaconteur::UserLogRecordHandlerDirector(), Swig::Director(jenv) {
}

void SwigDirector_UserLogRecordHandlerDirector::HandleLogRecord(RobotRaconteur::RRLogRecord const &record) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jrecord = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::UserLogRecordHandlerDirector::HandleLogRecord.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(RobotRaconteur::RRLogRecord **)&jrecord = (RobotRaconteur::RRLogRecord *) &record; 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[84], swigjobj, jrecord);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::UserLogRecordHandlerDirector::HandleLogRecord ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_UserLogRecordHandlerDirector::~SwigDirector_UserLogRecordHandlerDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_UserLogRecordHandlerDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "handleLogRecord", "(Lcom/robotraconteur/RRLogRecord;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/UserLogRecordHandlerDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_RRNativeObjectHeapSupport::SwigDirector_RRNativeObjectHeapSupport(JNIEnv *jenv) : RobotRaconteur::RRNativeObjectHeapSupport(), Swig::Director(jenv) {
}

void SwigDirector_RRNativeObjectHeapSupport::DeleteObject_i(int32_t id) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jid  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method RobotRaconteur::RRNativeObjectHeapSupport::DeleteObject_i.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jid = (jint) id;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[85], swigjobj, jid);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in RobotRaconteur::RRNativeObjectHeapSupport::DeleteObject_i ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_RRNativeObjectHeapSupport::~SwigDirector_RRNativeObjectHeapSupport() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_RRNativeObjectHeapSupport::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "deleteObject_i", "(I)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/RRNativeObjectHeapSupport");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ClientServiceListenerDirector::SwigDirector_ClientServiceListenerDirector(JNIEnv *jenv) : ClientServiceListenerDirector(), Swig::Director(jenv) {
}

void SwigDirector_ClientServiceListenerDirector::Callback(int32_t code) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jcode  ;
  
  if (!swig_override[0]) {
    ClientServiceListenerDirector::Callback(code);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jcode = (jint) code;
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[86], swigjobj, jcode);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ClientServiceListenerDirector::Callback ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ClientServiceListenerDirector::Callback2(int32_t code, std::string const &p) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jcode  ;
  jstring jp = 0 ;
  
  if (!swig_override[1]) {
    ClientServiceListenerDirector::Callback2(code,p);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jcode = (jint) code;
    jp = jenv->NewStringUTF((&p)->c_str());
    Swig::LocalRefGuard p_refguard(jenv, jp); 
    jenv->CallStaticVoidMethod(Swig::jclass_RobotRaconteurJavaJNI, Swig::director_method_ids[87], swigjobj, jcode, jp);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in ClientServiceListenerDirector::Callback2 ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_ClientServiceListenerDirector::~SwigDirector_ClientServiceListenerDirector() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_ClientServiceListenerDirector::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "callback", "(I)V", NULL 
    },
    {
      "callback2", "(ILjava/lang/String;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/robotraconteur/ClientServiceListenerDirector");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageFlags_1ROUTING_1INFO_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageFlags_ROUTING_INFO;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageFlags_1ENDPOINT_1INFO_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageFlags_ENDPOINT_INFO;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageFlags_1PRIORITY_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageFlags_PRIORITY;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageFlags_1UNRELIABLE_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageFlags_UNRELIABLE;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageFlags_1META_1INFO_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageFlags_META_INFO;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageFlags_1STRING_1TABLE_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageFlags_STRING_TABLE;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageFlags_1MULTIPLE_1ENTRIES_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageFlags_MULTIPLE_ENTRIES;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageFlags_1EXTENDED_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageFlags_EXTENDED;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageFlags_1Version2Compat_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageFlags_Version2Compat;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageEntryFlags_1SERVICE_1PATH_1STR_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageEntryFlags_SERVICE_PATH_STR;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageEntryFlags_1SERVICE_1PATH_1CODE_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageEntryFlags_SERVICE_PATH_CODE;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageEntryFlags_1MEMBER_1NAME_1STR_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageEntryFlags_MEMBER_NAME_STR;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageEntryFlags_1MEMBER_1NAME_1CODE_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageEntryFlags_MEMBER_NAME_CODE;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageEntryFlags_1REQUEST_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageEntryFlags_REQUEST_ID;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageEntryFlags_1ERROR_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageEntryFlags_ERROR;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageEntryFlags_1META_1INFO_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageEntryFlags_META_INFO;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageEntryFlags_1EXTENDED_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageEntryFlags_EXTENDED;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageEntryFlags_1Version2Compat_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageEntryFlags_Version2Compat;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementFlags_1ELEMENT_1NAME_1STR_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageElementFlags_ELEMENT_NAME_STR;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementFlags_1ELEMENT_1NAME_1CODE_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageElementFlags_ELEMENT_NAME_CODE;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementFlags_1ELEMENT_1NUMBER_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageElementFlags_ELEMENT_NUMBER;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementFlags_1ELEMENT_1TYPE_1NAME_1STR_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageElementFlags_ELEMENT_TYPE_NAME_STR;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementFlags_1ELEMENT_1TYPE_1NAME_1CODE_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageElementFlags_ELEMENT_TYPE_NAME_CODE;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementFlags_1META_1INFO_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageElementFlags_META_INFO;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementFlags_1EXTENDED_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageElementFlags_EXTENDED;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementFlags_1Version2Compat_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8_t)(uint8_t)RobotRaconteur::MessageElementFlags_Version2Compat;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TranspartCapabilityCode_1PAGE_1MASK_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TranspartCapabilityCode_PAGE_MASK;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE2_1BASIC_1PAGE_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE2_BASIC_PAGE;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE2_1BASIC_1ENABLE_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE2_BASIC_ENABLE;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE2_1BASIC_1CONNECTCOMBINED_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE2_BASIC_CONNECTCOMBINED;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE4_1BASIC_1PAGE_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE4_BASIC_PAGE;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE4_1BASIC_1ENABLE_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE4_BASIC_ENABLE;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE4_1BASIC_1CONNECTCOMBINED_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE4_BASIC_CONNECTCOMBINED;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE4_1STRINGTABLE_1PAGE_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE4_STRINGTABLE_PAGE;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE4_1STRINGTABLE_1ENABLE_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE4_STRINGTABLE_ENABLE;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE4_1STRINGTABLE_1MESSAGE_1LOCAL_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE4_STRINGTABLE_MESSAGE_LOCAL;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_TransportCapabilityCode_1MESSAGE4_1STRINGTABLE_1STANDARD_1TABLE_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)RobotRaconteur::TransportCapabilityCode_MESSAGE4_STRINGTABLE_STANDARD_TABLE;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1FilesystemPath(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  boost::filesystem::path *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (boost::filesystem::path *)new boost::filesystem::path((std::string const &)*arg1);
  *(boost::filesystem::path **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_FilesystemPath_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  boost::filesystem::path *arg1 = (boost::filesystem::path *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::filesystem::path **)&jarg1; 
  result = (arg1)->string();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1FilesystemPath(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::filesystem::path *arg1 = (boost::filesystem::path *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::filesystem::path **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRDirectorExceptionHelper_1reset(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  {
    try
    {
      RobotRaconteur::RRDirectorExceptionHelper::Reset();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRDirectorExceptionHelper_1setError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  boost::intrusive_ptr< RobotRaconteur::MessageEntry > *arg1 = 0 ;
  std::string *arg2 = 0 ;
  boost::intrusive_ptr< RobotRaconteur::MessageEntry > tempnull1 ;
  boost::intrusive_ptr< RobotRaconteur::MessageEntry > temp1 ;
  boost::shared_ptr< RobotRaconteur::MessageEntry > *smartarg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  // intrusive_ptr by reference
  if ( jarg1 ) {
    smartarg1 = *(boost::shared_ptr<  RobotRaconteur::MessageEntry >**)&jarg1;
    temp1 = boost::intrusive_ptr<  RobotRaconteur::MessageEntry >(smartarg1->get(), true);
    arg1 = &temp1;
  } else {
    arg1 = &tempnull1;
  }
  
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try
    {
      RobotRaconteur::RRDirectorExceptionHelper::SetError((boost::intrusive_ptr< RobotRaconteur::MessageEntry > const &)*arg1,(std::string const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRDirectorExceptionHelper_1isErrorPending(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (bool)RobotRaconteur::RRDirectorExceptionHelper::IsErrorPending();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRDirectorExceptionHelper_1getError(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::intrusive_ptr< RobotRaconteur::MessageEntry > result;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = RobotRaconteur::RRDirectorExceptionHelper::GetError();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  
  if (result) {
    intrusive_ptr_add_ref(result.get());
    *(boost::shared_ptr<  RobotRaconteur::MessageEntry > **)&jresult = new boost::shared_ptr<  RobotRaconteur::MessageEntry >(result.get(), SWIG_intrusive_deleter<  RobotRaconteur::MessageEntry >());
  } else {
    *(boost::shared_ptr<  RobotRaconteur::MessageEntry > **)&jresult = 0;
  }
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1RRDirectorExceptionHelper(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RobotRaconteur::RRDirectorExceptionHelper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (RobotRaconteur::RRDirectorExceptionHelper *)new RobotRaconteur::RRDirectorExceptionHelper();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::RRDirectorExceptionHelper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1RRDirectorExceptionHelper(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RobotRaconteur::RRDirectorExceptionHelper *arg1 = (RobotRaconteur::RRDirectorExceptionHelper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RobotRaconteur::RRDirectorExceptionHelper **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorstring_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< std::string > *)new std::vector< std::string >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorstring_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< std::string > *)new std::vector< std::string >((std::vector< std::string > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< std::string > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = (std::vector< std::string >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< std::string > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorstring_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::string *arg2 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try
    {
      try {
        result = (std::vector< std::string > *)new_std_vector_Sl_std_string_Sg___SWIG_2(arg1,(std::string const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_std_string_Sg__doSize((std::vector< std::string > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::vector< std::string >::value_type arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try
    {
      std_vector_Sl_std_string_Sg__doAdd__SWIG_0(arg1,(std::string const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try
    {
      try {
        std_vector_Sl_std_string_Sg__doAdd__SWIG_1(arg1,arg2,(std::string const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_std_string_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< std::string >::value_type *) &std_vector_Sl_std_string_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  std::vector< std::string >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try
    {
      try {
        result = std_vector_Sl_std_string_Sg__doSet(arg1,arg2,(std::string const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorstring_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_std_string_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectorstring(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorint32_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< int32_t > *)new std::vector< int32_t >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< int32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorint32_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int32_t > *arg1 = 0 ;
  std::vector< int32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int32_t > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< int32_t > *)new std::vector< int32_t >((std::vector< int32_t > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< int32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  std::vector< int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< int32_t > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  std::vector< int >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = (std::vector< int >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< int32_t > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorint32_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  int *arg2 = 0 ;
  int temp2 ;
  std::vector< int32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      try {
        result = (std::vector< int32_t > *)new_std_vector_Sl_int32_t_Sg___SWIG_2(arg1,(int const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< int32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_int32_t_Sg__doSize((std::vector< int > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  std::vector< int >::value_type *arg2 = 0 ;
  std::vector< int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  temp2 = (std::vector< int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      std_vector_Sl_int32_t_Sg__doAdd__SWIG_0(arg1,(int const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        std_vector_Sl_int32_t_Sg__doAdd__SWIG_1(arg1,arg2,(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< int >::value_type)std_vector_Sl_int32_t_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< int >::value_type *) &std_vector_Sl_int32_t_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jint)*result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int >::value_type temp3 ;
  std::vector< int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        result = (std::vector< int >::value_type)std_vector_Sl_int32_t_Sg__doSet(arg1,arg2,(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorint32_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_int32_t_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectorint32(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int32_t > *arg1 = (std::vector< int32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectoruint32_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< uint32_t > *)new std::vector< uint32_t >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectoruint32_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< uint32_t > *)new std::vector< uint32_t >((std::vector< uint32_t > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  std::vector< unsigned int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< uint32_t > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  std::vector< unsigned int >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = (std::vector< unsigned int >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< uint32_t > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectoruint32_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  unsigned int *arg2 = 0 ;
  unsigned int temp2 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (unsigned int)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      try {
        result = (std::vector< uint32_t > *)new_std_vector_Sl_uint32_t_Sg___SWIG_2(arg1,(unsigned int const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_uint32_t_Sg__doSize((std::vector< unsigned int > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  std::vector< unsigned int >::value_type *arg2 = 0 ;
  std::vector< unsigned int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  temp2 = (std::vector< unsigned int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      std_vector_Sl_uint32_t_Sg__doAdd__SWIG_0(arg1,(unsigned int const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type *arg3 = 0 ;
  std::vector< unsigned int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        std_vector_Sl_uint32_t_Sg__doAdd__SWIG_1(arg1,arg2,(unsigned int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< unsigned int >::value_type)std_vector_Sl_uint32_t_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< unsigned int >::value_type *) &std_vector_Sl_uint32_t_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)*result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type *arg3 = 0 ;
  std::vector< unsigned int >::value_type temp3 ;
  std::vector< unsigned int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        result = (std::vector< unsigned int >::value_type)std_vector_Sl_uint32_t_Sg__doSet(arg1,arg2,(unsigned int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectoruint32_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_uint32_t_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectoruint32(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1int8_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< int8_t > *)new std::vector< int8_t >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< int8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1int8_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int8_t > *arg1 = 0 ;
  std::vector< int8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int8_t > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< int8_t > *)new std::vector< int8_t >((std::vector< int8_t > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< int8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  std::vector< signed char >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< int8_t > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  std::vector< signed char >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = (std::vector< signed char >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< int8_t > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1int8_1t_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jbyte jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  signed char *arg2 = 0 ;
  signed char temp2 ;
  std::vector< int8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (signed char)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      try {
        result = (std::vector< int8_t > *)new_std_vector_Sl_int8_t_Sg___SWIG_2(arg1,(signed char const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< int8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_int8_t_Sg__doSize((std::vector< signed char > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyte jarg2) {
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  std::vector< signed char >::value_type *arg2 = 0 ;
  std::vector< signed char >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  temp2 = (std::vector< signed char >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      std_vector_Sl_int8_t_Sg__doAdd__SWIG_0(arg1,(signed char const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jbyte jarg3) {
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  jint arg2 ;
  std::vector< signed char >::value_type *arg3 = 0 ;
  std::vector< signed char >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< signed char >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        std_vector_Sl_int8_t_Sg__doAdd__SWIG_1(arg1,arg2,(signed char const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jbyte JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jbyte jresult = 0 ;
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  jint arg2 ;
  std::vector< signed char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< signed char >::value_type)std_vector_Sl_int8_t_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jbyte)result; 
  return jresult;
}


SWIGEXPORT jbyte JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jbyte jresult = 0 ;
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  jint arg2 ;
  std::vector< signed char >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< signed char >::value_type *) &std_vector_Sl_int8_t_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jbyte)*result; 
  return jresult;
}


SWIGEXPORT jbyte JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jbyte jarg3) {
  jbyte jresult = 0 ;
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  jint arg2 ;
  std::vector< signed char >::value_type *arg3 = 0 ;
  std::vector< signed char >::value_type temp3 ;
  std::vector< signed char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< signed char >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        result = (std::vector< signed char >::value_type)std_vector_Sl_int8_t_Sg__doSet(arg1,arg2,(signed char const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jbyte)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1int8_1t_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_int8_t_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vector_1int8_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int8_t > *arg1 = (std::vector< int8_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1uint8_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< uint8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< uint8_t > *)new std::vector< uint8_t >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< uint8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1uint8_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint8_t > *arg1 = 0 ;
  std::vector< uint8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint8_t > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< uint8_t > *)new std::vector< uint8_t >((std::vector< uint8_t > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< uint8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  std::vector< unsigned char >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< uint8_t > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  std::vector< unsigned char >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = (std::vector< unsigned char >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< uint8_t > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1uint8_1t_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jshort jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  unsigned char *arg2 = 0 ;
  unsigned char temp2 ;
  std::vector< uint8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (unsigned char)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      try {
        result = (std::vector< uint8_t > *)new_std_vector_Sl_uint8_t_Sg___SWIG_2(arg1,(unsigned char const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< uint8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_uint8_t_Sg__doSize((std::vector< unsigned char > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  std::vector< unsigned char >::value_type *arg2 = 0 ;
  std::vector< unsigned char >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  temp2 = (std::vector< unsigned char >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      std_vector_Sl_uint8_t_Sg__doAdd__SWIG_0(arg1,(unsigned char const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jshort jarg3) {
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned char >::value_type *arg3 = 0 ;
  std::vector< unsigned char >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned char >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        std_vector_Sl_uint8_t_Sg__doAdd__SWIG_1(arg1,arg2,(unsigned char const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jshort jresult = 0 ;
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< unsigned char >::value_type)std_vector_Sl_uint8_t_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jshort jresult = 0 ;
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned char >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< unsigned char >::value_type *) &std_vector_Sl_uint8_t_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jshort)*result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jshort jarg3) {
  jshort jresult = 0 ;
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned char >::value_type *arg3 = 0 ;
  std::vector< unsigned char >::value_type temp3 ;
  std::vector< unsigned char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned char >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        result = (std::vector< unsigned char >::value_type)std_vector_Sl_uint8_t_Sg__doSet(arg1,arg2,(unsigned char const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint8_1t_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_uint8_t_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vector_1uint8_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< uint8_t > *arg1 = (std::vector< uint8_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1uint64_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< uint64_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< uint64_t > *)new std::vector< uint64_t >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< uint64_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1uint64_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint64_t > *arg1 = 0 ;
  std::vector< uint64_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint64_t > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< uint64_t > *)new std::vector< uint64_t >((std::vector< uint64_t > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< uint64_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  std::vector< unsigned long >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< uint64_t > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  std::vector< unsigned long >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = (std::vector< unsigned long >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< uint64_t > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1uint64_1t_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  unsigned long *arg2 = 0 ;
  unsigned long temp2 ;
  std::vector< uint64_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (unsigned long)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      try {
        result = (std::vector< uint64_t > *)new_std_vector_Sl_uint64_t_Sg___SWIG_2(arg1,(unsigned long const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< uint64_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_uint64_t_Sg__doSize((std::vector< unsigned long > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  std::vector< unsigned long >::value_type *arg2 = 0 ;
  std::vector< unsigned long >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  temp2 = (std::vector< unsigned long >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try
    {
      std_vector_Sl_uint64_t_Sg__doAdd__SWIG_0(arg1,(unsigned long const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned long >::value_type *arg3 = 0 ;
  std::vector< unsigned long >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned long >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        std_vector_Sl_uint64_t_Sg__doAdd__SWIG_1(arg1,arg2,(unsigned long const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned long >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< unsigned long >::value_type)std_vector_Sl_uint64_t_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned long >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< unsigned long >::value_type *) &std_vector_Sl_uint64_t_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)*result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  jint arg2 ;
  std::vector< unsigned long >::value_type *arg3 = 0 ;
  std::vector< unsigned long >::value_type temp3 ;
  std::vector< unsigned long >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned long >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try
    {
      try {
        result = (std::vector< unsigned long >::value_type)std_vector_Sl_uint64_t_Sg__doSet(arg1,arg2,(unsigned long const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1uint64_1t_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_uint64_t_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vector_1uint64_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< uint64_t > *arg1 = (std::vector< uint64_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1map_1strstr_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::map< std::string,std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::map< std::string,std::string > *)new std::map< std::string,std::string >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::map< std::string,std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1map_1strstr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< std::string,std::string > *arg1 = 0 ;
  std::map< std::string,std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::map< std::string,std::string > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::map< std::string,std::string > *)new std::map< std::string,std::string >((std::map< std::string,std::string > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::map< std::string,std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1Iterator_1getNextUnchecked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< std::string,std::string >::iterator *arg1 = (std::map< std::string,std::string >::iterator *) 0 ;
  std::map< std::string,std::string,std::less< std::string > >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string >::iterator **)&jarg1; 
  {
    try
    {
      result = std_map_Sl_std_string_Sc_std_string_Sg__iterator_getNextUnchecked(arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::map< std::string,std::string,std::less< std::string > >::iterator **)&jresult = new std::map< std::string,std::string,std::less< std::string > >::iterator((const std::map< std::string,std::string,std::less< std::string > >::iterator &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1Iterator_1isNot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  std::map< std::string,std::string >::iterator *arg1 = (std::map< std::string,std::string >::iterator *) 0 ;
  std::map< std::string,std::string >::iterator arg2 ;
  std::map< std::string,std::string >::iterator *argp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::map< std::string,std::string >::iterator **)&jarg1; 
  argp2 = *(std::map< std::string,std::string >::iterator **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::map< std::string,std::string >::iterator");
    return 0;
  }
  arg2 = *argp2; 
  {
    try
    {
      result = (bool)std_map_Sl_std_string_Sc_std_string_Sg__iterator_isNot((std::map< std::string,std::string >::iterator const *)arg1,arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1Iterator_1getKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  std::map< std::string,std::string >::iterator *arg1 = (std::map< std::string,std::string >::iterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string >::iterator **)&jarg1; 
  {
    try
    {
      result = std_map_Sl_std_string_Sc_std_string_Sg__iterator_getKey((std::map< std::string,std::string >::iterator const *)arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1Iterator_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  std::map< std::string,std::string >::iterator *arg1 = (std::map< std::string,std::string >::iterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string >::iterator **)&jarg1; 
  {
    try
    {
      result = std_map_Sl_std_string_Sc_std_string_Sg__iterator_getValue((std::map< std::string,std::string >::iterator const *)arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1Iterator_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::map< std::string,std::string >::iterator *arg1 = (std::map< std::string,std::string >::iterator *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string >::iterator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try
    {
      std_map_Sl_std_string_Sc_std_string_Sg__iterator_setValue(arg1,(std::string const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1map_1strstr_1Iterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::map< std::string,std::string >::iterator *arg1 = (std::map< std::string,std::string >::iterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::map< std::string,std::string >::iterator **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::map< std::string,std::string > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1find(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  std::string *arg2 = 0 ;
  std::map< std::string,std::string >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try
    {
      result = (arg1)->find((std::string const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::map< std::string,std::string >::iterator **)&jresult = new std::map< std::string,std::string >::iterator((const std::map< std::string,std::string >::iterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  std::map< std::string,std::string >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  {
    try
    {
      result = (arg1)->begin();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::map< std::string,std::string >::iterator **)&jresult = new std::map< std::string,std::string >::iterator((const std::map< std::string,std::string >::iterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  std::map< std::string,std::string >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  {
    try
    {
      result = (arg1)->end();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::map< std::string,std::string >::iterator **)&jresult = new std::map< std::string,std::string >::iterator((const std::map< std::string,std::string >::iterator &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1sizeImpl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  {
    try
    {
      try {
        result = std_map_Sl_std_string_Sc_std_string_Sg__sizeImpl((std::map< std::string,std::string > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1containsImpl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try
    {
      result = (bool)std_map_Sl_std_string_Sc_std_string_Sg__containsImpl(arg1,(std::string const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1putUnchecked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try
    {
      std_map_Sl_std_string_Sc_std_string_Sg__putUnchecked(arg1,(std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_map_1strstr_1removeUnchecked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  std::map< std::string,std::string,std::less< std::string > >::iterator arg2 ;
  std::map< std::string,std::string,std::less< std::string > >::iterator const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  argp2 = *(std::map< std::string,std::string,std::less< std::string > >::iterator **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::map< std::string,std::string,std::less< std::string > >::iterator const");
    return ;
  }
  arg2 = *argp2; 
  {
    try
    {
      std_map_Sl_std_string_Sc_std_string_Sg__removeUnchecked(arg1,arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1map_1strstr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::map< std::string,std::string > *arg1 = (std::map< std::string,std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::map< std::string,std::string > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_getRRDataTypeString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  RobotRaconteur::DataTypes arg1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (RobotRaconteur::DataTypes)jarg1; 
  {
    try
    {
      result = RobotRaconteur::GetRRDataTypeString(arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_isTypeRRArray(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  RobotRaconteur::DataTypes arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (RobotRaconteur::DataTypes)jarg1; 
  {
    try
    {
      result = (bool)RobotRaconteur::IsTypeRRArray(arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_isTypeNumeric(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  RobotRaconteur::DataTypes arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (RobotRaconteur::DataTypes)jarg1; 
  {
    try
    {
      result = (bool)RobotRaconteur::IsTypeNumeric(arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1RRObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RobotRaconteur::RRObject *arg1 = (RobotRaconteur::RRObject *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRObject > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRObject > **)&jarg1;
  arg1 = (RobotRaconteur::RRObject *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try
    {
      (void)arg1; delete smartarg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1RRValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RobotRaconteur::RRValue *arg1 = (RobotRaconteur::RRValue *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRValue > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRValue > **)&jarg1;
  arg1 = (RobotRaconteur::RRValue *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      (void)arg1; delete smartarg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementData_1getTypeString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  RobotRaconteur::MessageElementData *arg1 = (RobotRaconteur::MessageElementData *) 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElementData > *smartarg1 = 0 ;
  RobotRaconteur::MessageStringPtr result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::MessageElementData > **)&jarg1;
  arg1 = (RobotRaconteur::MessageElementData *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      result = (arg1)->GetTypeString();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  std::string temp_ret1 = (&result)->str().to_string(); jresult = jenv->NewStringUTF(temp_ret1.c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MessageElementData_1getTypeID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  RobotRaconteur::MessageElementData *arg1 = (RobotRaconteur::MessageElementData *) 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElementData > *smartarg1 = 0 ;
  RobotRaconteur::DataTypes result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::MessageElementData > **)&jarg1;
  arg1 = (RobotRaconteur::MessageElementData *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      result = (RobotRaconteur::DataTypes)(arg1)->GetTypeID();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1MessageElementData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RobotRaconteur::MessageElementData *arg1 = (RobotRaconteur::MessageElementData *) 0 ;
  boost::shared_ptr< RobotRaconteur::MessageElementData > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::MessageElementData > **)&jarg1;
  arg1 = (RobotRaconteur::MessageElementData *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      (void)arg1; delete smartarg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRBaseArray_1getTypeString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  RobotRaconteur::RRBaseArray *arg1 = (RobotRaconteur::RRBaseArray *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRBaseArray > *smartarg1 = 0 ;
  RobotRaconteur::MessageStringPtr result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jarg1;
  arg1 = (RobotRaconteur::RRBaseArray *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      result = (arg1)->GetTypeString();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  std::string temp_ret1 = (&result)->str().to_string(); jresult = jenv->NewStringUTF(temp_ret1.c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRBaseArray_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RobotRaconteur::RRBaseArray *arg1 = (RobotRaconteur::RRBaseArray *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRBaseArray > *smartarg1 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jarg1;
  arg1 = (RobotRaconteur::RRBaseArray *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      result = (arg1)->size();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRBaseArray_1void_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RobotRaconteur::RRBaseArray *arg1 = (RobotRaconteur::RRBaseArray *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRBaseArray > *smartarg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jarg1;
  arg1 = (RobotRaconteur::RRBaseArray *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      result = (void *)(arg1)->void_ptr();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRBaseArray_1elementSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RobotRaconteur::RRBaseArray *arg1 = (RobotRaconteur::RRBaseArray *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRBaseArray > *smartarg1 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jarg1;
  arg1 = (RobotRaconteur::RRBaseArray *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      result = (arg1)->ElementSize();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRBaseArray_1getTypeID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  RobotRaconteur::RRBaseArray *arg1 = (RobotRaconteur::RRBaseArray *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRBaseArray > *smartarg1 = 0 ;
  RobotRaconteur::DataTypes result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jarg1;
  arg1 = (RobotRaconteur::RRBaseArray *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      result = (RobotRaconteur::DataTypes)(arg1)->GetTypeID();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1RRBaseArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RobotRaconteur::RRBaseArray *arg1 = (RobotRaconteur::RRBaseArray *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRBaseArray > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  // plain pointer
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jarg1;
  arg1 = (RobotRaconteur::RRBaseArray *)(smartarg1 ? smartarg1->get() : 0);
  
  {
    try
    {
      (void)arg1; delete smartarg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_allocateRRArrayByType(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  RobotRaconteur::DataTypes arg1 ;
  size_t arg2 ;
  boost::intrusive_ptr< RobotRaconteur::RRBaseArray > result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (RobotRaconteur::DataTypes)jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try
    {
      result = RobotRaconteur::AllocateRRArrayByType(arg1,arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  
  if (result) {
    intrusive_ptr_add_ref(result.get());
    *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jresult = new boost::shared_ptr<  RobotRaconteur::RRBaseArray >(result.get(), SWIG_intrusive_deleter<  RobotRaconteur::RRBaseArray >());
  } else {
    *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jresult = 0;
  }
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRMultiDimArrayUntyped_1Dims_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  RobotRaconteur::RRMultiDimArrayUntyped *arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *) 0 ;
  boost::intrusive_ptr< RobotRaconteur::RRBaseArray > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::RRMultiDimArrayUntyped > *smartarg1 = 0 ;
  boost::intrusive_ptr< RobotRaconteur::RRBaseArray > tempnull2 ;
  boost::intrusive_ptr< RobotRaconteur::RRBaseArray > temp2 ;
  boost::shared_ptr< RobotRaconteur::RRBaseArray > *smartarg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRMultiDimArrayUntyped > **)&jarg1;
  arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *)(smartarg1 ? smartarg1->get() : 0); 
  
  // intrusive_ptr by reference
  if ( jarg2 ) {
    smartarg2 = *(boost::shared_ptr<  RobotRaconteur::RRBaseArray >**)&jarg2;
    temp2 = boost::intrusive_ptr<  RobotRaconteur::RRBaseArray >(smartarg2->get(), true);
    arg2 = &temp2;
  } else {
    arg2 = &tempnull2;
  }
  
  if (arg1) (arg1)->Dims = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRMultiDimArrayUntyped_1Dims_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RobotRaconteur::RRMultiDimArrayUntyped *arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRMultiDimArrayUntyped > *smartarg1 = 0 ;
  boost::intrusive_ptr< RobotRaconteur::RRBaseArray > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRMultiDimArrayUntyped > **)&jarg1;
  arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *)(smartarg1 ? smartarg1->get() : 0); 
  result = (boost::intrusive_ptr< RobotRaconteur::RRBaseArray > *) & ((arg1)->Dims);
  
  if (*result) {
    intrusive_ptr_add_ref(result->get());
    *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jresult = new boost::shared_ptr<  RobotRaconteur::RRBaseArray >(result->get(), SWIG_intrusive_deleter<  RobotRaconteur::RRBaseArray >());
  } else {
    *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jresult = 0;
  }
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRMultiDimArrayUntyped_1Array_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  RobotRaconteur::RRMultiDimArrayUntyped *arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *) 0 ;
  boost::intrusive_ptr< RobotRaconteur::RRBaseArray > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::RRMultiDimArrayUntyped > *smartarg1 = 0 ;
  boost::intrusive_ptr< RobotRaconteur::RRBaseArray > tempnull2 ;
  boost::intrusive_ptr< RobotRaconteur::RRBaseArray > temp2 ;
  boost::shared_ptr< RobotRaconteur::RRBaseArray > *smartarg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRMultiDimArrayUntyped > **)&jarg1;
  arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *)(smartarg1 ? smartarg1->get() : 0); 
  
  // intrusive_ptr by reference
  if ( jarg2 ) {
    smartarg2 = *(boost::shared_ptr<  RobotRaconteur::RRBaseArray >**)&jarg2;
    temp2 = boost::intrusive_ptr<  RobotRaconteur::RRBaseArray >(smartarg2->get(), true);
    arg2 = &temp2;
  } else {
    arg2 = &tempnull2;
  }
  
  if (arg1) (arg1)->Array = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RRMultiDimArrayUntyped_1Array_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RobotRaconteur::RRMultiDimArrayUntyped *arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRMultiDimArrayUntyped > *smartarg1 = 0 ;
  boost::intrusive_ptr< RobotRaconteur::RRBaseArray > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRMultiDimArrayUntyped > **)&jarg1;
  arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *)(smartarg1 ? smartarg1->get() : 0); 
  result = (boost::intrusive_ptr< RobotRaconteur::RRBaseArray > *) & ((arg1)->Array);
  
  if (*result) {
    intrusive_ptr_add_ref(result->get());
    *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jresult = new boost::shared_ptr<  RobotRaconteur::RRBaseArray >(result->get(), SWIG_intrusive_deleter<  RobotRaconteur::RRBaseArray >());
  } else {
    *(boost::shared_ptr<  RobotRaconteur::RRBaseArray > **)&jresult = 0;
  }
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1RRMultiDimArrayUntyped(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RobotRaconteur::RRMultiDimArrayUntyped *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (RobotRaconteur::RRMultiDimArrayUntyped *)new RobotRaconteur::RRMultiDimArrayUntyped();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  
  *(boost::shared_ptr<  RobotRaconteur::RRMultiDimArrayUntyped > **)&jresult = result ? new boost::shared_ptr<  RobotRaconteur::RRMultiDimArrayUntyped >(result SWIG_NO_NULL_DELETER_1) : 0;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1RRMultiDimArrayUntyped(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RobotRaconteur::RRMultiDimArrayUntyped *arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *) 0 ;
  boost::shared_ptr< RobotRaconteur::RRMultiDimArrayUntyped > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::RRMultiDimArrayUntyped > **)&jarg1;
  arg1 = (RobotRaconteur::RRMultiDimArrayUntyped *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try
    {
      (void)arg1; delete smartarg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1ServicePathSegment_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RobotRaconteur::ServicePathSegment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (RobotRaconteur::ServicePathSegment *)new RobotRaconteur::ServicePathSegment();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::ServicePathSegment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1ServicePathSegment_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  RobotRaconteur::ServicePathSegment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try
    {
      result = (RobotRaconteur::ServicePathSegment *)new RobotRaconteur::ServicePathSegment((std::string const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::ServicePathSegment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1ServicePathSegment_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  RobotRaconteur::ServicePathSegment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try
    {
      result = (RobotRaconteur::ServicePathSegment *)new RobotRaconteur::ServicePathSegment((std::string const &)*arg1,(std::string const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::ServicePathSegment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegment_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  RobotRaconteur::ServicePathSegment *arg1 = (RobotRaconteur::ServicePathSegment *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServicePathSegment **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->name = *arg2;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegment_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  RobotRaconteur::ServicePathSegment *arg1 = (RobotRaconteur::ServicePathSegment *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServicePathSegment **)&jarg1; 
  result = (std::string *) & ((arg1)->name);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegment_1index_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  RobotRaconteur::ServicePathSegment *arg1 = (RobotRaconteur::ServicePathSegment *) 0 ;
  boost::optional< std::string > *arg2 = (boost::optional< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServicePathSegment **)&jarg1; 
  arg2 = *(boost::optional< std::string > **)&jarg2; 
  if (arg1) (arg1)->index = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegment_1index_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RobotRaconteur::ServicePathSegment *arg1 = (RobotRaconteur::ServicePathSegment *) 0 ;
  boost::optional< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServicePathSegment **)&jarg1; 
  result = (boost::optional< std::string > *)& ((arg1)->index);
  *(boost::optional< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1ServicePathSegment(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RobotRaconteur::ServicePathSegment *arg1 = (RobotRaconteur::ServicePathSegment *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RobotRaconteur::ServicePathSegment **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1ServicePathSegments_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< RobotRaconteur::ServicePathSegment > *)new std::vector< RobotRaconteur::ServicePathSegment >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ServicePathSegment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1ServicePathSegments_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::ServicePathSegment > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< RobotRaconteur::ServicePathSegment > *)new std::vector< RobotRaconteur::ServicePathSegment >((std::vector< RobotRaconteur::ServicePathSegment > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ServicePathSegment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  std::vector< RobotRaconteur::ServicePathSegment >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< RobotRaconteur::ServicePathSegment > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  std::vector< RobotRaconteur::ServicePathSegment >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  arg2 = (std::vector< RobotRaconteur::ServicePathSegment >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< RobotRaconteur::ServicePathSegment > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1ServicePathSegments_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  RobotRaconteur::ServicePathSegment *arg2 = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(RobotRaconteur::ServicePathSegment **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "RobotRaconteur::ServicePathSegment const & reference is null");
    return 0;
  } 
  {
    try
    {
      try {
        result = (std::vector< RobotRaconteur::ServicePathSegment > *)new_std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg___SWIG_2(arg1,(RobotRaconteur::ServicePathSegment const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ServicePathSegment > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doSize((std::vector< RobotRaconteur::ServicePathSegment > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  std::vector< RobotRaconteur::ServicePathSegment >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  arg2 = *(std::vector< RobotRaconteur::ServicePathSegment >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::ServicePathSegment >::value_type const & reference is null");
    return ;
  } 
  {
    try
    {
      std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doAdd__SWIG_0(arg1,(RobotRaconteur::ServicePathSegment const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::ServicePathSegment >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< RobotRaconteur::ServicePathSegment >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::ServicePathSegment >::value_type const & reference is null");
    return ;
  } 
  {
    try
    {
      try {
        std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doAdd__SWIG_1(arg1,arg2,(RobotRaconteur::ServicePathSegment const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::ServicePathSegment >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ServicePathSegment >::value_type **)&jresult = new std::vector< RobotRaconteur::ServicePathSegment >::value_type((const std::vector< RobotRaconteur::ServicePathSegment >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::ServicePathSegment >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< RobotRaconteur::ServicePathSegment >::value_type *) &std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ServicePathSegment >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::ServicePathSegment >::value_type *arg3 = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< RobotRaconteur::ServicePathSegment >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::ServicePathSegment >::value_type const & reference is null");
    return 0;
  } 
  {
    try
    {
      try {
        result = std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doSet(arg1,arg2,(RobotRaconteur::ServicePathSegment const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ServicePathSegment >::value_type **)&jresult = new std::vector< RobotRaconteur::ServicePathSegment >::value_type((const std::vector< RobotRaconteur::ServicePathSegment >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServicePathSegments_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_RobotRaconteur_ServicePathSegment_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1ServicePathSegments(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = (std::vector< RobotRaconteur::ServicePathSegment > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_encodeServicePathIndex(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try
    {
      result = RobotRaconteur::EncodeServicePathIndex((std::string const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_decodeServicePathIndex(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try
    {
      result = RobotRaconteur::DecodeServicePathIndex((std::string const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_parseServicePath(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try
    {
      result = RobotRaconteur::ParseServicePath((std::string const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ServicePathSegment > **)&jresult = new std::vector< RobotRaconteur::ServicePathSegment >((const std::vector< RobotRaconteur::ServicePathSegment > &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_buildServicePath(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  std::vector< RobotRaconteur::ServicePathSegment > *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ServicePathSegment > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::ServicePathSegment > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = RobotRaconteur::BuildServicePath((std::vector< RobotRaconteur::ServicePathSegment > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_isStringName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  boost::string_ref arg1 ;
  boost::string_ref *argp1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(boost::string_ref **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null boost::string_ref");
    return 0;
  }
  arg1 = *argp1; 
  {
    try
    {
      result = (bool)RobotRaconteur::IsStringName(arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_isStringScopedName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  boost::string_ref arg1 ;
  boost::string_ref *argp1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(boost::string_ref **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null boost::string_ref");
    return 0;
  }
  arg1 = *argp1; 
  {
    try
    {
      result = (bool)RobotRaconteur::IsStringScopedName(arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_isStringUUID(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  boost::string_ref arg1 ;
  boost::string_ref *argp1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(boost::string_ref **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null boost::string_ref");
    return 0;
  }
  arg1 = *argp1; 
  {
    try
    {
      result = (bool)RobotRaconteur::IsStringUUID(arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_isStringIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  boost::string_ref arg1 ;
  boost::string_ref *argp1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(boost::string_ref **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null boost::string_ref");
    return 0;
  }
  arg1 = *argp1; 
  {
    try
    {
      result = (bool)RobotRaconteur::IsStringIdentifier(arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_MultiDimArray_1CalculateCopyIndicesIter_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2, jlongArray jarg3, jlongArray jarg4) {
  jboolean jresult = 0 ;
  RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter *arg1 = (RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter *) 0 ;
  uint32_t *arg2 = 0 ;
  uint32_t *arg3 = 0 ;
  uint32_t *arg4 = 0 ;
  boost::shared_ptr< RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter > *smartarg1 = 0 ;
  uint32_t temp2 ;
  uint32_t temp3 ;
  uint32_t temp4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter > **)&jarg1;
  arg1 = (RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter *)(smartarg1 ? smartarg1->get() : 0); 
  {
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg2) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp2 = (uint32_t)0;
    arg2 = &temp2; 
  }
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp3 = (uint32_t)0;
    arg3 = &temp3; 
  }
  {
    if (!jarg4) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg4) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp4 = (uint32_t)0;
    arg4 = &temp4; 
  }
  {
    try
    {
      result = (bool)(arg1)->Next(*arg2,*arg3,*arg4);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  {
    jlong jvalue = (jlong)temp2;
    jenv->SetLongArrayRegion(jarg2, 0, 1, &jvalue);
  }
  {
    jlong jvalue = (jlong)temp3;
    jenv->SetLongArrayRegion(jarg3, 0, 1, &jvalue);
  }
  {
    jlong jvalue = (jlong)temp4;
    jenv->SetLongArrayRegion(jarg4, 0, 1, &jvalue);
  }
  
  
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1MultiDimArray_1CalculateCopyIndicesIter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter *arg1 = (RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter *) 0 ;
  boost::shared_ptr< RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter > *smartarg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  smartarg1 = *(boost::shared_ptr<  RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter > **)&jarg1;
  arg1 = (RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter *)(smartarg1 ? smartarg1->get() : 0); 
  {
    try
    {
      (void)arg1; delete smartarg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_multiDimArray_1CalculateCopyIndicesBeginIter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< uint32_t > *arg3 = 0 ;
  std::vector< uint32_t > *arg4 = 0 ;
  std::vector< uint32_t > *arg5 = 0 ;
  boost::shared_ptr< RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(std::vector< uint32_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & reference is null");
    return 0;
  } 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & reference is null");
    return 0;
  } 
  arg3 = *(std::vector< uint32_t > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & reference is null");
    return 0;
  } 
  arg4 = *(std::vector< uint32_t > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & reference is null");
    return 0;
  } 
  arg5 = *(std::vector< uint32_t > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesBeginIter((std::vector< unsigned int > const &)*arg1,(std::vector< unsigned int > const &)*arg2,(std::vector< unsigned int > const &)*arg3,(std::vector< unsigned int > const &)*arg4,(std::vector< unsigned int > const &)*arg5);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(boost::shared_ptr< RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter > **)&jresult = result ? new boost::shared_ptr< RobotRaconteur::detail::MultiDimArray_CalculateCopyIndicesIter >(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1typedefinition_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1typedefinition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >((std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  arg2 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1typedefinition_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  boost::shared_ptr< RobotRaconteur::TypeDefinition > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::TypeDefinition > tempnull2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(boost::shared_ptr< RobotRaconteur::TypeDefinition > **)&jarg2 : &tempnull2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *)new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg___SWIG_2(arg1,(boost::shared_ptr< RobotRaconteur::TypeDefinition > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doSize((std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type *arg2 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type **)&jarg2 : &tempnull2; 
  {
    try
    {
      std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doAdd__SWIG_0(arg1,(boost::shared_ptr< RobotRaconteur::TypeDefinition > const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(boost::shared_ptr< RobotRaconteur::TypeDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type **)&jresult = *result ? new std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type tempnull3 ;
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doSet(arg1,arg2,(boost::shared_ptr< RobotRaconteur::TypeDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1typedefinition_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_TypeDefinition_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectorptr_1typedefinition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::TypeDefinition > > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1memberdefinition_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1memberdefinition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >((std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  arg2 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1memberdefinition_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  boost::shared_ptr< RobotRaconteur::MemberDefinition > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::MemberDefinition > tempnull2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(boost::shared_ptr< RobotRaconteur::MemberDefinition > **)&jarg2 : &tempnull2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *)new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg___SWIG_2(arg1,(boost::shared_ptr< RobotRaconteur::MemberDefinition > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doSize((std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type *arg2 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type **)&jarg2 : &tempnull2; 
  {
    try
    {
      std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doAdd__SWIG_0(arg1,(boost::shared_ptr< RobotRaconteur::MemberDefinition > const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(boost::shared_ptr< RobotRaconteur::MemberDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type **)&jresult = *result ? new std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type tempnull3 ;
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doSet(arg1,arg2,(boost::shared_ptr< RobotRaconteur::MemberDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1memberdefinition_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_MemberDefinition_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectorptr_1memberdefinition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::MemberDefinition > > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1serviceentrydefinition_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1serviceentrydefinition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >((std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  arg2 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1serviceentrydefinition_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > tempnull2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > **)&jarg2 : &tempnull2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *)new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg___SWIG_2(arg1,(boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doSize((std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type *arg2 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type **)&jarg2 : &tempnull2; 
  {
    try
    {
      std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doAdd__SWIG_0(arg1,(boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type **)&jresult = *result ? new std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type tempnull3 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doSet(arg1,arg2,(boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1serviceentrydefinition_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceEntryDefinition_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectorptr_1serviceentrydefinition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceEntryDefinition > > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1constantdefinition_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1constantdefinition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >((std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  arg2 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1constantdefinition_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  boost::shared_ptr< RobotRaconteur::ConstantDefinition > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::ConstantDefinition > tempnull2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(boost::shared_ptr< RobotRaconteur::ConstantDefinition > **)&jarg2 : &tempnull2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *)new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg___SWIG_2(arg1,(boost::shared_ptr< RobotRaconteur::ConstantDefinition > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doSize((std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type *arg2 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type **)&jarg2 : &tempnull2; 
  {
    try
    {
      std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doAdd__SWIG_0(arg1,(boost::shared_ptr< RobotRaconteur::ConstantDefinition > const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(boost::shared_ptr< RobotRaconteur::ConstantDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type **)&jresult = *result ? new std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type tempnull3 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doSet(arg1,arg2,(boost::shared_ptr< RobotRaconteur::ConstantDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1constantdefinition_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ConstantDefinition_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectorptr_1constantdefinition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ConstantDefinition > > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1enumdefinition_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1enumdefinition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >((std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  arg2 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1enumdefinition_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  boost::shared_ptr< RobotRaconteur::EnumDefinition > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::EnumDefinition > tempnull2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(boost::shared_ptr< RobotRaconteur::EnumDefinition > **)&jarg2 : &tempnull2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *)new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg___SWIG_2(arg1,(boost::shared_ptr< RobotRaconteur::EnumDefinition > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doSize((std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type *arg2 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type **)&jarg2 : &tempnull2; 
  {
    try
    {
      std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doAdd__SWIG_0(arg1,(boost::shared_ptr< RobotRaconteur::EnumDefinition > const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(boost::shared_ptr< RobotRaconteur::EnumDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type **)&jresult = *result ? new std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type tempnull3 ;
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doSet(arg1,arg2,(boost::shared_ptr< RobotRaconteur::EnumDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1enumdefinition_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_EnumDefinition_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectorptr_1enumdefinition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::EnumDefinition > > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1constantdefinition_1structfield_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *)new std::vector< RobotRaconteur::ConstantDefinition_StructField >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1constantdefinition_1structfield_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::ConstantDefinition_StructField > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *)new std::vector< RobotRaconteur::ConstantDefinition_StructField >((std::vector< RobotRaconteur::ConstantDefinition_StructField > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< RobotRaconteur::ConstantDefinition_StructField > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  arg2 = (std::vector< RobotRaconteur::ConstantDefinition_StructField >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< RobotRaconteur::ConstantDefinition_StructField > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1constantdefinition_1structfield_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  RobotRaconteur::ConstantDefinition_StructField *arg2 = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(RobotRaconteur::ConstantDefinition_StructField **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "RobotRaconteur::ConstantDefinition_StructField const & reference is null");
    return 0;
  } 
  {
    try
    {
      try {
        result = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *)new_std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg___SWIG_2(arg1,(RobotRaconteur::ConstantDefinition_StructField const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doSize((std::vector< RobotRaconteur::ConstantDefinition_StructField > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  arg2 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type const & reference is null");
    return ;
  } 
  {
    try
    {
      std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doAdd__SWIG_0(arg1,(RobotRaconteur::ConstantDefinition_StructField const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type const & reference is null");
    return ;
  } 
  {
    try
    {
      try {
        std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doAdd__SWIG_1(arg1,arg2,(RobotRaconteur::ConstantDefinition_StructField const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type **)&jresult = new std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type((const std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type *) &std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type *arg3 = 0 ;
  std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type const & reference is null");
    return 0;
  } 
  {
    try
    {
      try {
        result = std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doSet(arg1,arg2,(RobotRaconteur::ConstantDefinition_StructField const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type **)&jresult = new std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type((const std::vector< RobotRaconteur::ConstantDefinition_StructField >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1constantdefinition_1structfield_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_RobotRaconteur_ConstantDefinition_StructField_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vector_1constantdefinition_1structfield(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< RobotRaconteur::ConstantDefinition_StructField > *arg1 = (std::vector< RobotRaconteur::ConstantDefinition_StructField > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< RobotRaconteur::ConstantDefinition_StructField > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1enumdefinitionvalues_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< RobotRaconteur::EnumDefinitionValue > *)new std::vector< RobotRaconteur::EnumDefinitionValue >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1enumdefinitionvalues_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::EnumDefinitionValue > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< RobotRaconteur::EnumDefinitionValue > *)new std::vector< RobotRaconteur::EnumDefinitionValue >((std::vector< RobotRaconteur::EnumDefinitionValue > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< RobotRaconteur::EnumDefinitionValue > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  arg2 = (std::vector< RobotRaconteur::EnumDefinitionValue >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< RobotRaconteur::EnumDefinitionValue > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1enumdefinitionvalues_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  RobotRaconteur::EnumDefinitionValue *arg2 = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(RobotRaconteur::EnumDefinitionValue **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "RobotRaconteur::EnumDefinitionValue const & reference is null");
    return 0;
  } 
  {
    try
    {
      try {
        result = (std::vector< RobotRaconteur::EnumDefinitionValue > *)new_std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg___SWIG_2(arg1,(RobotRaconteur::EnumDefinitionValue const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doSize((std::vector< RobotRaconteur::EnumDefinitionValue > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  arg2 = *(std::vector< RobotRaconteur::EnumDefinitionValue >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::EnumDefinitionValue >::value_type const & reference is null");
    return ;
  } 
  {
    try
    {
      std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doAdd__SWIG_0(arg1,(RobotRaconteur::EnumDefinitionValue const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::EnumDefinitionValue >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< RobotRaconteur::EnumDefinitionValue >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::EnumDefinitionValue >::value_type const & reference is null");
    return ;
  } 
  {
    try
    {
      try {
        std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doAdd__SWIG_1(arg1,arg2,(RobotRaconteur::EnumDefinitionValue const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::EnumDefinitionValue >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::EnumDefinitionValue >::value_type **)&jresult = new std::vector< RobotRaconteur::EnumDefinitionValue >::value_type((const std::vector< RobotRaconteur::EnumDefinitionValue >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::EnumDefinitionValue >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< RobotRaconteur::EnumDefinitionValue >::value_type *) &std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::EnumDefinitionValue >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  jint arg2 ;
  std::vector< RobotRaconteur::EnumDefinitionValue >::value_type *arg3 = 0 ;
  std::vector< RobotRaconteur::EnumDefinitionValue >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< RobotRaconteur::EnumDefinitionValue >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< RobotRaconteur::EnumDefinitionValue >::value_type const & reference is null");
    return 0;
  } 
  {
    try
    {
      try {
        result = std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doSet(arg1,arg2,(RobotRaconteur::EnumDefinitionValue const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< RobotRaconteur::EnumDefinitionValue >::value_type **)&jresult = new std::vector< RobotRaconteur::EnumDefinitionValue >::value_type((const std::vector< RobotRaconteur::EnumDefinitionValue >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1enumdefinitionvalues_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_RobotRaconteur_EnumDefinitionValue_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vector_1enumdefinitionvalues(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< RobotRaconteur::EnumDefinitionValue > *arg1 = (std::vector< RobotRaconteur::EnumDefinitionValue > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< RobotRaconteur::EnumDefinitionValue > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1usingdefinition_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1usingdefinition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >((std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  arg2 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vector_1usingdefinition_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  boost::shared_ptr< RobotRaconteur::UsingDefinition > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::UsingDefinition > tempnull2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(boost::shared_ptr< RobotRaconteur::UsingDefinition > **)&jarg2 : &tempnull2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *)new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg___SWIG_2(arg1,(boost::shared_ptr< RobotRaconteur::UsingDefinition > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doSize((std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type *arg2 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type **)&jarg2 : &tempnull2; 
  {
    try
    {
      std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doAdd__SWIG_0(arg1,(boost::shared_ptr< RobotRaconteur::UsingDefinition > const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(boost::shared_ptr< RobotRaconteur::UsingDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type **)&jresult = *result ? new std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type tempnull3 ;
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doSet(arg1,arg2,(boost::shared_ptr< RobotRaconteur::UsingDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vector_1usingdefinition_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_UsingDefinition_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vector_1usingdefinition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::UsingDefinition > > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1exceptiondefinition_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1exceptiondefinition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >((std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  arg2 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1exceptiondefinition_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  boost::shared_ptr< RobotRaconteur::ExceptionDefinition > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::ExceptionDefinition > tempnull2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(boost::shared_ptr< RobotRaconteur::ExceptionDefinition > **)&jarg2 : &tempnull2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *)new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg___SWIG_2(arg1,(boost::shared_ptr< RobotRaconteur::ExceptionDefinition > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doSize((std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type *arg2 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type **)&jarg2 : &tempnull2; 
  {
    try
    {
      std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doAdd__SWIG_0(arg1,(boost::shared_ptr< RobotRaconteur::ExceptionDefinition > const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(boost::shared_ptr< RobotRaconteur::ExceptionDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type **)&jresult = *result ? new std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type tempnull3 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doSet(arg1,arg2,(boost::shared_ptr< RobotRaconteur::ExceptionDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1exceptiondefinition_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ExceptionDefinition_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectorptr_1exceptiondefinition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ExceptionDefinition > > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1servicedefinition_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1servicedefinition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > const & reference is null");
    return 0;
  } 
  {
    try
    {
      result = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *)new std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >((std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  {
    try
    {
      result = ((std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > const *)arg1)->capacity();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  arg2 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::size_type)jarg2; 
  {
    try
    {
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  {
    try
    {
      result = (bool)((std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > const *)arg1)->empty();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  {
    try
    {
      (arg1)->clear();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1vectorptr_1servicedefinition_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  boost::shared_ptr< RobotRaconteur::ServiceDefinition > *arg2 = 0 ;
  boost::shared_ptr< RobotRaconteur::ServiceDefinition > tempnull2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = jarg2 ? *(boost::shared_ptr< RobotRaconteur::ServiceDefinition > **)&jarg2 : &tempnull2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *)new_std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg___SWIG_2(arg1,(boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doSize((std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type *arg2 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type tempnull2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  arg2 = jarg2 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type **)&jarg2 : &tempnull2; 
  {
    try
    {
      std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doAdd__SWIG_0(arg1,(boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type tempnull3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try
    {
      try {
        result = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type *) &std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type **)&jresult = *result ? new std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type(*result) : 0; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  jint arg2 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type *arg3 = 0 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type tempnull3 ;
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3 ? *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type **)&jarg3 : &tempnull3; 
  {
    try
    {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doSet(arg1,arg2,(boost::shared_ptr< RobotRaconteur::ServiceDefinition > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type **)&jresult = result ? new std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > >::value_type(result) : 0; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_vectorptr_1servicedefinition_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try
    {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_RobotRaconteur_ServiceDefinition_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1vectorptr_1servicedefinition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *arg1 = (std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< boost::shared_ptr< RobotRaconteur::ServiceDefinition > > **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServiceDefinitionParseInfo_1ServiceName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->ServiceName = *arg2;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServiceDefinitionParseInfo_1ServiceName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  result = (std::string *) & ((arg1)->ServiceName);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServiceDefinitionParseInfo_1RobDefFilePath_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->RobDefFilePath = *arg2;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServiceDefinitionParseInfo_1RobDefFilePath_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  result = (std::string *) & ((arg1)->RobDefFilePath);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServiceDefinitionParseInfo_1Line_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->Line = *arg2;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServiceDefinitionParseInfo_1Line_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  result = (std::string *) & ((arg1)->Line);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServiceDefinitionParseInfo_1LineNumber_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  int32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  arg2 = (int32_t)jarg2; 
  if (arg1) (arg1)->LineNumber = arg2;
}


SWIGEXPORT jint JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServiceDefinitionParseInfo_1LineNumber_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  result = (int32_t) ((arg1)->LineNumber);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1ServiceDefinitionParseInfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RobotRaconteur::ServiceDefinitionParseInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (RobotRaconteur::ServiceDefinitionParseInfo *)new RobotRaconteur::ServiceDefinitionParseInfo();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::ServiceDefinitionParseInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_ServiceDefinitionParseInfo_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  {
    try
    {
      (arg1)->Reset();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_delete_1ServiceDefinitionParseInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RobotRaconteur::ServiceDefinitionParseInfo *arg1 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg1; 
  {
    try
    {
      delete arg1;
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1RobotRaconteurVersion_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RobotRaconteur::RobotRaconteurVersion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try
    {
      result = (RobotRaconteur::RobotRaconteurVersion *)new RobotRaconteur::RobotRaconteurVersion();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::RobotRaconteurVersion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1RobotRaconteurVersion_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  RobotRaconteur::RobotRaconteurVersion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  {
    try
    {
      result = (RobotRaconteur::RobotRaconteurVersion *)new RobotRaconteur::RobotRaconteurVersion(arg1,arg2,arg3,arg4);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::RobotRaconteurVersion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1RobotRaconteurVersion_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  RobotRaconteur::RobotRaconteurVersion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try
    {
      result = (RobotRaconteur::RobotRaconteurVersion *)new RobotRaconteur::RobotRaconteurVersion(arg1,arg2,arg3);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::RobotRaconteurVersion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1RobotRaconteurVersion_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t arg2 ;
  RobotRaconteur::RobotRaconteurVersion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try
    {
      result = (RobotRaconteur::RobotRaconteurVersion *)new RobotRaconteur::RobotRaconteurVersion(arg1,arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::RobotRaconteurVersion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_new_1RobotRaconteurVersion_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  RobotRaconteur::RobotRaconteurVersion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try
    {
      result = (RobotRaconteur::RobotRaconteurVersion *)new RobotRaconteur::RobotRaconteurVersion((std::string const &)*arg1);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  *(RobotRaconteur::RobotRaconteurVersion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  RobotRaconteur::RobotRaconteurVersion *arg1 = (RobotRaconteur::RobotRaconteurVersion *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::RobotRaconteurVersion **)&jarg1; 
  {
    try
    {
      result = ((RobotRaconteur::RobotRaconteurVersion const *)arg1)->ToString();
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return 0;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1fromString_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  RobotRaconteur::RobotRaconteurVersion *arg1 = (RobotRaconteur::RobotRaconteurVersion *) 0 ;
  std::string *arg2 = 0 ;
  RobotRaconteur::ServiceDefinitionParseInfo *arg3 = (RobotRaconteur::ServiceDefinitionParseInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(RobotRaconteur::RobotRaconteurVersion **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(RobotRaconteur::ServiceDefinitionParseInfo **)&jarg3; 
  {
    try
    {
      (arg1)->FromString((std::string const &)*arg2,(RobotRaconteur::ServiceDefinitionParseInfo const *)arg3);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1fromString_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  RobotRaconteur::RobotRaconteurVersion *arg1 = (RobotRaconteur::RobotRaconteurVersion *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::RobotRaconteurVersion **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try
    {
      (arg1)->FromString((std::string const &)*arg2);
    }
    catch (RobotRaconteur::RobotRaconteurException& e)
    {
      jclass clazz2;
      jmethodID mid2;
      jthrowable jexp;
      jlong error_info_ptr=0;
      RobotRaconteur::HandlerErrorInfo error_info(e);
      clazz2=jenv->FindClass("com/robotraconteur/RobotRaconteurExceptionUtil");
      if (!clazz2) goto rrerrfail;
      mid2 = jenv->GetStaticMethodID(clazz2, "errorInfoToException" ,"(J)Ljava/lang/RuntimeException;");
      if (!mid2) goto rrerrfail;
      error_info_ptr=(jlong)&error_info;
      jexp=(jthrowable)jenv->CallStaticObjectMethod(clazz2,mid2,error_info_ptr);
      jenv->Throw(jexp);
      return ;
      
    rrerrfail:
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
      
      
    }
    catch (std::exception& e) {
      jclass clazz = jenv->FindClass( "java/lang/RuntimeException");
      jenv->ThrowNew(clazz, e.what());
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1major_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  RobotRaconteur::RobotRaconteurVersion *arg1 = (RobotRaconteur::RobotRaconteurVersion *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::RobotRaconteurVersion **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->major = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1major_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RobotRaconteur::RobotRaconteurVersion *arg1 = (RobotRaconteur::RobotRaconteurVersion *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::RobotRaconteurVersion **)&jarg1; 
  result = (uint32_t) ((arg1)->major);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1minor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  RobotRaconteur::RobotRaconteurVersion *arg1 = (RobotRaconteur::RobotRaconteurVersion *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::RobotRaconteurVersion **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->minor = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1minor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RobotRaconteur::RobotRaconteurVersion *arg1 = (RobotRaconteur::RobotRaconteurVersion *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::RobotRaconteurVersion **)&jarg1; 
  result = (uint32_t) ((arg1)->minor);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1patch_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  RobotRaconteur::RobotRaconteurVersion *arg1 = (RobotRaconteur::RobotRaconteurVersion *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::RobotRaconteurVersion **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->patch = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1patch_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  RobotRaconteur::RobotRaconteurVersion *arg1 = (RobotRaconteur::RobotRaconteurVersion *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RobotRaconteur::RobotRaconteurVersion **)&jarg1; 
  result = (uint32_t) ((arg1)->patch);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_robotraconteur_RobotRaconteurJavaJNI_RobotRaconteurVersion_1tweak_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong 