
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDataStd_NamedData.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <StepRepr_RepresentationItem.hxx>
#include <Transfer_TransientProcess.hxx>
#include <StepBasic_NamedUnit.hxx>
#include <StepBasic_Product.hxx>
#include <StepShape_ConnectedFaceSet.hxx>
#include <StepShape_ShapeDefinitionRepresentation.hxx>
#include <StepRepr_NextAssemblyUsageOccurrence.hxx>
#include <StepRepr_PropertyDefinition.hxx>
#include <STEPConstruct_Tool.hxx>
#include <StepDimTol_Datum.hxx>
#include <Transfer_Binder.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>

// module includes
#include <STEPCAFControl_ActorWrite.hxx>
#include <STEPCAFControl_ConfigurationNode.hxx>
#include <STEPCAFControl_Controller.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfLabelExternFile.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfLabelShape.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfPDExternFile.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfSDRExternFile.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfShapePD.hxx>
#include <STEPCAFControl_DataMapIteratorOfDataMapOfShapeSDR.hxx>
#include <STEPCAFControl_DataMapOfLabelExternFile.hxx>
#include <STEPCAFControl_DataMapOfLabelShape.hxx>
#include <STEPCAFControl_DataMapOfPDExternFile.hxx>
#include <STEPCAFControl_DataMapOfSDRExternFile.hxx>
#include <STEPCAFControl_DataMapOfShapePD.hxx>
#include <STEPCAFControl_DataMapOfShapeSDR.hxx>
#include <STEPCAFControl_ExternFile.hxx>
#include <STEPCAFControl_GDTProperty.hxx>
#include <STEPCAFControl_Provider.hxx>
#include <STEPCAFControl_Reader.hxx>
#include <STEPCAFControl_Writer.hxx>

// template related includes

// ./opencascade/STEPCAFControl_DataMapOfLabelExternFile.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfLabelShape.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfLabelShape.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfPDExternFile.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfSDRExternFile.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfShapePD.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/STEPCAFControl_DataMapOfShapeSDR.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
        #include <istream>
        #include <ostream>

        using std::basic_ostream;
        using std::basic_istream;
        using std::char_traits;

        #include <DE_ConfigurationContext.hxx>
        #include <XCAFDoc_ShapeTool.hxx>
        #include <XSAlgo_ShapeProcessor.hxx>
        

// Module definiiton
void register_STEPCAFControl(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("STEPCAFControl"));
py::object klass;

//Python trampoline classes

// classes

    // Class STEPCAFControl_ActorWrite from ./opencascade/STEPCAFControl_ActorWrite.hxx
    klass = m.attr("STEPCAFControl_ActorWrite");


    // nested enums

    static_cast<py::class_<STEPCAFControl_ActorWrite ,opencascade::handle<STEPCAFControl_ActorWrite>  , STEPControl_ActorWrite >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsAssembly",
             (Standard_Boolean (STEPCAFControl_ActorWrite::*)(  const handle<StepData_StepModel> & ,  TopoDS_Shape &  ) const) static_cast<Standard_Boolean (STEPCAFControl_ActorWrite::*)(  const handle<StepData_StepModel> & ,  TopoDS_Shape &  ) const>(&STEPCAFControl_ActorWrite::IsAssembly),
             R"#(Check whether shape S is assembly Returns True if shape is registered in assemblies map)#"  , py::arg("theModel"),  py::arg("S")
          )
        .def("SetStdMode",
             (void (STEPCAFControl_ActorWrite::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_ActorWrite::*)(  const Standard_Boolean  ) >(&STEPCAFControl_ActorWrite::SetStdMode),
             R"#(Set standard mode of work In standard mode Actor (default) behaves exactly as its ancestor, also map is cleared)#"  , py::arg("stdmode")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("ClearMap",
             (void (STEPCAFControl_ActorWrite::*)() ) static_cast<void (STEPCAFControl_ActorWrite::*)() >(&STEPCAFControl_ActorWrite::ClearMap),
             R"#(Clears map of shapes registered as assemblies)#" 
          )
        .def("RegisterAssembly",
             (void (STEPCAFControl_ActorWrite::*)(  const TopoDS_Shape &  ) ) static_cast<void (STEPCAFControl_ActorWrite::*)(  const TopoDS_Shape &  ) >(&STEPCAFControl_ActorWrite::RegisterAssembly),
             R"#(Registers shape to be written as assembly The shape should be TopoDS_Compound (else does nothing))#"  , py::arg("S")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&STEPCAFControl_ActorWrite::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&STEPCAFControl_ActorWrite::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (STEPCAFControl_ActorWrite::*)() const) static_cast< const handle<Standard_Type> & (STEPCAFControl_ActorWrite::*)() const>(&STEPCAFControl_ActorWrite::DynamicType),
             R"#()#"
             
         )
;

    // Class STEPCAFControl_Controller from ./opencascade/STEPCAFControl_Controller.hxx
    klass = m.attr("STEPCAFControl_Controller");


    // nested enums

    static_cast<py::class_<STEPCAFControl_Controller ,opencascade::handle<STEPCAFControl_Controller>  , STEPControl_Controller >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Init_s",
                    (Standard_Boolean (*)() ) static_cast<Standard_Boolean (*)() >(&STEPCAFControl_Controller::Init),
                    R"#(Standard Initialisation. It creates a Controller for STEP-XCAF and records it to various names, available to select it later Returns True when done, False if could not be done)#" 
          )
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&STEPCAFControl_Controller::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&STEPCAFControl_Controller::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (STEPCAFControl_Controller::*)() const) static_cast< const handle<Standard_Type> & (STEPCAFControl_Controller::*)() const>(&STEPCAFControl_Controller::DynamicType),
             R"#()#"
             
         )
;

    // Class STEPCAFControl_ExternFile from ./opencascade/STEPCAFControl_ExternFile.hxx
    klass = m.attr("STEPCAFControl_ExternFile");


    // nested enums

    static_cast<py::class_<STEPCAFControl_ExternFile ,opencascade::handle<STEPCAFControl_ExternFile>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetWS",
             (void (STEPCAFControl_ExternFile::*)(  const handle<XSControl_WorkSession> &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const handle<XSControl_WorkSession> &  ) >(&STEPCAFControl_ExternFile::SetWS),
             R"#()#"  , py::arg("WS")
          )
        .def("GetWS",
             (handle<XSControl_WorkSession> (STEPCAFControl_ExternFile::*)() const) static_cast<handle<XSControl_WorkSession> (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetWS),
             R"#()#" 
          )
        .def("SetLoadStatus",
             (void (STEPCAFControl_ExternFile::*)(  const IFSelect_ReturnStatus  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const IFSelect_ReturnStatus  ) >(&STEPCAFControl_ExternFile::SetLoadStatus),
             R"#()#"  , py::arg("stat")
          )
        .def("GetLoadStatus",
             (IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const) static_cast<IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetLoadStatus),
             R"#()#" 
          )
        .def("SetTransferStatus",
             (void (STEPCAFControl_ExternFile::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const Standard_Boolean  ) >(&STEPCAFControl_ExternFile::SetTransferStatus),
             R"#()#"  , py::arg("isok")
          )
        .def("GetTransferStatus",
             (Standard_Boolean (STEPCAFControl_ExternFile::*)() const) static_cast<Standard_Boolean (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetTransferStatus),
             R"#()#" 
          )
        .def("SetWriteStatus",
             (void (STEPCAFControl_ExternFile::*)(  const IFSelect_ReturnStatus  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const IFSelect_ReturnStatus  ) >(&STEPCAFControl_ExternFile::SetWriteStatus),
             R"#()#"  , py::arg("stat")
          )
        .def("GetWriteStatus",
             (IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const) static_cast<IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetWriteStatus),
             R"#()#" 
          )
        .def("SetName",
             (void (STEPCAFControl_ExternFile::*)(  const handle<TCollection_HAsciiString> &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const handle<TCollection_HAsciiString> &  ) >(&STEPCAFControl_ExternFile::SetName),
             R"#()#"  , py::arg("name")
          )
        .def("GetName",
             (handle<TCollection_HAsciiString> (STEPCAFControl_ExternFile::*)() const) static_cast<handle<TCollection_HAsciiString> (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetName),
             R"#()#" 
          )
        .def("SetLabel",
             (void (STEPCAFControl_ExternFile::*)(  const TDF_Label &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const TDF_Label &  ) >(&STEPCAFControl_ExternFile::SetLabel),
             R"#()#"  , py::arg("L")
          )
        .def("GetLabel",
             (TDF_Label (STEPCAFControl_ExternFile::*)() const) static_cast<TDF_Label (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetLabel),
             R"#()#" 
          )
        .def("SetWS",
             (void (STEPCAFControl_ExternFile::*)(  const handle<XSControl_WorkSession> &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const handle<XSControl_WorkSession> &  ) >(&STEPCAFControl_ExternFile::SetWS),
             R"#()#"  , py::arg("WS")
          )
        .def("GetWS",
             (handle<XSControl_WorkSession> (STEPCAFControl_ExternFile::*)() const) static_cast<handle<XSControl_WorkSession> (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetWS),
             R"#()#" 
          )
        .def("SetLoadStatus",
             (void (STEPCAFControl_ExternFile::*)(  const IFSelect_ReturnStatus  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const IFSelect_ReturnStatus  ) >(&STEPCAFControl_ExternFile::SetLoadStatus),
             R"#()#"  , py::arg("stat")
          )
        .def("GetLoadStatus",
             (IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const) static_cast<IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetLoadStatus),
             R"#()#" 
          )
        .def("SetTransferStatus",
             (void (STEPCAFControl_ExternFile::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const Standard_Boolean  ) >(&STEPCAFControl_ExternFile::SetTransferStatus),
             R"#()#"  , py::arg("isok")
          )
        .def("GetTransferStatus",
             (Standard_Boolean (STEPCAFControl_ExternFile::*)() const) static_cast<Standard_Boolean (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetTransferStatus),
             R"#()#" 
          )
        .def("SetWriteStatus",
             (void (STEPCAFControl_ExternFile::*)(  const IFSelect_ReturnStatus  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const IFSelect_ReturnStatus  ) >(&STEPCAFControl_ExternFile::SetWriteStatus),
             R"#()#"  , py::arg("stat")
          )
        .def("GetWriteStatus",
             (IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const) static_cast<IFSelect_ReturnStatus (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetWriteStatus),
             R"#()#" 
          )
        .def("SetName",
             (void (STEPCAFControl_ExternFile::*)(  const handle<TCollection_HAsciiString> &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const handle<TCollection_HAsciiString> &  ) >(&STEPCAFControl_ExternFile::SetName),
             R"#()#"  , py::arg("name")
          )
        .def("GetName",
             (handle<TCollection_HAsciiString> (STEPCAFControl_ExternFile::*)() const) static_cast<handle<TCollection_HAsciiString> (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetName),
             R"#()#" 
          )
        .def("SetLabel",
             (void (STEPCAFControl_ExternFile::*)(  const TDF_Label &  ) ) static_cast<void (STEPCAFControl_ExternFile::*)(  const TDF_Label &  ) >(&STEPCAFControl_ExternFile::SetLabel),
             R"#()#"  , py::arg("Label")
          )
        .def("GetLabel",
             (TDF_Label (STEPCAFControl_ExternFile::*)() const) static_cast<TDF_Label (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::GetLabel),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&STEPCAFControl_ExternFile::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&STEPCAFControl_ExternFile::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (STEPCAFControl_ExternFile::*)() const) static_cast< const handle<Standard_Type> & (STEPCAFControl_ExternFile::*)() const>(&STEPCAFControl_ExternFile::DynamicType),
             R"#()#"
             
         )
;

    // Class STEPCAFControl_GDTProperty from ./opencascade/STEPCAFControl_GDTProperty.hxx
    klass = m.attr("STEPCAFControl_GDTProperty");


    // nested enums

    static_cast<py::class_<STEPCAFControl_GDTProperty , shared_ptr<STEPCAFControl_GDTProperty>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetDimModifiers_s",
                    (void (*)(  const handle<StepRepr_CompoundRepresentationItem> & ,  XCAFDimTolObjects_DimensionModifiersSequence &  ) ) static_cast<void (*)(  const handle<StepRepr_CompoundRepresentationItem> & ,  XCAFDimTolObjects_DimensionModifiersSequence &  ) >(&STEPCAFControl_GDTProperty::GetDimModifiers),
                    R"#()#"  , py::arg("theCRI"),  py::arg("theModifiers")
          )
        .def_static("GetDimType_s",
                    (Standard_Boolean (*)(  const handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DimensionType &  ) ) static_cast<Standard_Boolean (*)(  const handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DimensionType &  ) >(&STEPCAFControl_GDTProperty::GetDimType),
                    R"#()#"  , py::arg("theName"),  py::arg("theType")
          )
        .def_static("GetDatumTargetType_s",
                    (Standard_Boolean (*)(  const handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DatumTargetType &  ) ) static_cast<Standard_Boolean (*)(  const handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DatumTargetType &  ) >(&STEPCAFControl_GDTProperty::GetDatumTargetType),
                    R"#()#"  , py::arg("theDescription"),  py::arg("theType")
          )
        .def_static("GetDimQualifierType_s",
                    (Standard_Boolean (*)(  const handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DimensionQualifier &  ) ) static_cast<Standard_Boolean (*)(  const handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_DimensionQualifier &  ) >(&STEPCAFControl_GDTProperty::GetDimQualifierType),
                    R"#()#"  , py::arg("theDescription"),  py::arg("theType")
          )
        .def_static("GetTolValueType_s",
                    (Standard_Boolean (*)(  const handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_GeomToleranceTypeValue &  ) ) static_cast<Standard_Boolean (*)(  const handle<TCollection_HAsciiString> & ,  XCAFDimTolObjects_GeomToleranceTypeValue &  ) >(&STEPCAFControl_GDTProperty::GetTolValueType),
                    R"#()#"  , py::arg("theDescription"),  py::arg("theType")
          )
        .def_static("GetTolValueType_s",
                    (handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_GeomToleranceTypeValue &  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_GeomToleranceTypeValue &  ) >(&STEPCAFControl_GDTProperty::GetTolValueType),
                    R"#()#"  , py::arg("theType")
          )
        .def_static("GetDimTypeName_s",
                    (handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_DimensionType  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_DimensionType  ) >(&STEPCAFControl_GDTProperty::GetDimTypeName),
                    R"#()#"  , py::arg("theType")
          )
        .def_static("GetDimQualifierName_s",
                    (handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_DimensionQualifier  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_DimensionQualifier  ) >(&STEPCAFControl_GDTProperty::GetDimQualifierName),
                    R"#()#"  , py::arg("theQualifier")
          )
        .def_static("GetDimModifierName_s",
                    (handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_DimensionModif  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_DimensionModif  ) >(&STEPCAFControl_GDTProperty::GetDimModifierName),
                    R"#()#"  , py::arg("theModifier")
          )
        .def_static("GetLimitsAndFits_s",
                    (handle<StepShape_LimitsAndFits> (*)( Standard_Boolean ,  XCAFDimTolObjects_DimensionFormVariance ,  XCAFDimTolObjects_DimensionGrade  ) ) static_cast<handle<StepShape_LimitsAndFits> (*)( Standard_Boolean ,  XCAFDimTolObjects_DimensionFormVariance ,  XCAFDimTolObjects_DimensionGrade  ) >(&STEPCAFControl_GDTProperty::GetLimitsAndFits),
                    R"#()#"  , py::arg("theHole"),  py::arg("theFormVariance"),  py::arg("theGrade")
          )
        .def_static("GetDatumTargetName_s",
                    (handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_DatumTargetType  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const XCAFDimTolObjects_DatumTargetType  ) >(&STEPCAFControl_GDTProperty::GetDatumTargetName),
                    R"#()#"  , py::arg("theDatumType")
          )
        .def_static("IsDimensionalLocation_s",
                    (Standard_Boolean (*)(  const XCAFDimTolObjects_DimensionType  ) ) static_cast<Standard_Boolean (*)(  const XCAFDimTolObjects_DimensionType  ) >(&STEPCAFControl_GDTProperty::IsDimensionalLocation),
                    R"#()#"  , py::arg("theType")
          )
        .def_static("IsDimensionalSize_s",
                    (Standard_Boolean (*)(  const XCAFDimTolObjects_DimensionType  ) ) static_cast<Standard_Boolean (*)(  const XCAFDimTolObjects_DimensionType  ) >(&STEPCAFControl_GDTProperty::IsDimensionalSize),
                    R"#()#"  , py::arg("theType")
          )
        .def_static("GetGeomToleranceType_s",
                    (StepDimTol_GeometricToleranceType (*)(  const XCAFDimTolObjects_GeomToleranceType  ) ) static_cast<StepDimTol_GeometricToleranceType (*)(  const XCAFDimTolObjects_GeomToleranceType  ) >(&STEPCAFControl_GDTProperty::GetGeomToleranceType),
                    R"#()#"  , py::arg("theType")
          )
        .def_static("GetGeomToleranceType_s",
                    (XCAFDimTolObjects_GeomToleranceType (*)(  const StepDimTol_GeometricToleranceType  ) ) static_cast<XCAFDimTolObjects_GeomToleranceType (*)(  const StepDimTol_GeometricToleranceType  ) >(&STEPCAFControl_GDTProperty::GetGeomToleranceType),
                    R"#()#"  , py::arg("theType")
          )
        .def_static("GetGeomTolerance_s",
                    (handle<StepDimTol_GeometricTolerance> (*)(  const XCAFDimTolObjects_GeomToleranceType  ) ) static_cast<handle<StepDimTol_GeometricTolerance> (*)(  const XCAFDimTolObjects_GeomToleranceType  ) >(&STEPCAFControl_GDTProperty::GetGeomTolerance),
                    R"#()#"  , py::arg("theType")
          )
        .def_static("GetGeomToleranceModifier_s",
                    (StepDimTol_GeometricToleranceModifier (*)(  const XCAFDimTolObjects_GeomToleranceModif  ) ) static_cast<StepDimTol_GeometricToleranceModifier (*)(  const XCAFDimTolObjects_GeomToleranceModif  ) >(&STEPCAFControl_GDTProperty::GetGeomToleranceModifier),
                    R"#()#"  , py::arg("theModifier")
          )
        .def_static("GetDatumRefModifiers_s",
                    (handle<StepDimTol_HArray1OfDatumReferenceModifier> (*)(  const XCAFDimTolObjects_DatumModifiersSequence & ,   const XCAFDimTolObjects_DatumModifWithValue & ,   const Standard_Real ,   const StepBasic_Unit &  ) ) static_cast<handle<StepDimTol_HArray1OfDatumReferenceModifier> (*)(  const XCAFDimTolObjects_DatumModifiersSequence & ,   const XCAFDimTolObjects_DatumModifWithValue & ,   const Standard_Real ,   const StepBasic_Unit &  ) >(&STEPCAFControl_GDTProperty::GetDatumRefModifiers),
                    R"#()#"  , py::arg("theModifiers"),  py::arg("theModifWithVal"),  py::arg("theValue"),  py::arg("theUnit")
          )
        .def_static("GetTessellation_s",
                    (handle<StepVisual_TessellatedGeometricSet> (*)(  const TopoDS_Shape &  ) ) static_cast<handle<StepVisual_TessellatedGeometricSet> (*)(  const TopoDS_Shape &  ) >(&STEPCAFControl_GDTProperty::GetTessellation),
                    R"#()#"  , py::arg("theShape")
          )
    // static methods using call by reference i.s.o. return
        .def_static("GetDimClassOfTolerance_s",
            []( const handle<StepShape_LimitsAndFits> & theLAF,XCAFDimTolObjects_DimensionFormVariance & theFV,XCAFDimTolObjects_DimensionGrade & theG ){
                Standard_Boolean  theHolle;

                STEPCAFControl_GDTProperty::GetDimClassOfTolerance(theLAF,theHolle,theFV,theG);
                
return std::make_tuple(theHolle); },
            R"#()#"  , py::arg("theLAF"),  py::arg("theFV"),  py::arg("theG")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class STEPCAFControl_Reader from ./opencascade/STEPCAFControl_Reader.hxx
    klass = m.attr("STEPCAFControl_Reader");


    // nested enums

    static_cast<py::class_<STEPCAFControl_Reader , shared_ptr<STEPCAFControl_Reader>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<XSControl_WorkSession> &, const Standard_Boolean >()  , py::arg("WS"),  py::arg("scratch")=static_cast< const Standard_Boolean>(Standard_True) )
    // custom constructors
    // methods
        .def("Init",
             (void (STEPCAFControl_Reader::*)(  const handle<XSControl_WorkSession> & ,   const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const handle<XSControl_WorkSession> & ,   const Standard_Boolean  ) >(&STEPCAFControl_Reader::Init),
             R"#(Clears the internal data structures and attaches to a new session Clears the session if it was not yet set for STEP)#"  , py::arg("WS"),  py::arg("scratch")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("ReadFile",
             (IFSelect_ReturnStatus (STEPCAFControl_Reader::*)(  const Standard_CString  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Reader::*)(  const Standard_CString  ) >(&STEPCAFControl_Reader::ReadFile),
             R"#(Loads a file and returns the read status Provided for use like single-file reader.)#"  , py::arg("theFileName")
          )
        .def("ReadFile",
             (IFSelect_ReturnStatus (STEPCAFControl_Reader::*)(  const Standard_CString ,   const DESTEP_Parameters &  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Reader::*)(  const Standard_CString ,   const DESTEP_Parameters &  ) >(&STEPCAFControl_Reader::ReadFile),
             R"#(Loads a file and returns the read status Provided for use like single-file reader.)#"  , py::arg("theFileName"),  py::arg("theParams")
          )
        .def("ReadStream",
             (IFSelect_ReturnStatus (STEPCAFControl_Reader::*)(  const Standard_CString ,  typename std::istream &  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Reader::*)(  const Standard_CString ,  typename std::istream &  ) >(&STEPCAFControl_Reader::ReadStream),
             R"#(Loads a file from stream and returns the read status.)#"  , py::arg("theName"),  py::arg("theIStream")
          )
        .def("NbRootsForTransfer",
             (Standard_Integer (STEPCAFControl_Reader::*)() ) static_cast<Standard_Integer (STEPCAFControl_Reader::*)() >(&STEPCAFControl_Reader::NbRootsForTransfer),
             R"#(Returns number of roots recognized for transfer Shortcut for Reader().NbRootsForTransfer())#" 
          )
        .def("TransferOneRoot",
             (Standard_Boolean (STEPCAFControl_Reader::*)(  const Standard_Integer ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)(  const Standard_Integer ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::TransferOneRoot),
             R"#(Translates currently loaded STEP file into the document Returns True if succeeded, and False in case of fail Provided for use like single-file reader)#"  , py::arg("num"),  py::arg("doc"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Reader::*)(  const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)(  const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Transfer),
             R"#(Translates currently loaded STEP file into the document Returns True if succeeded, and False in case of fail Provided for use like single-file reader)#"  , py::arg("doc"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Reader::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Perform),
             R"#()#"  , py::arg("filename"),  py::arg("doc"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Reader::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const DESTEP_Parameters & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const DESTEP_Parameters & ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Perform),
             R"#()#"  , py::arg("filename"),  py::arg("doc"),  py::arg("theParams"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Reader::*)(  const Standard_CString ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)(  const Standard_CString ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Perform),
             R"#(Translate STEP file given by filename into the document Return True if succeeded, and False in case of fail)#"  , py::arg("filename"),  py::arg("doc"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Reader::*)(  const Standard_CString ,   const handle<TDocStd_Document> & ,   const DESTEP_Parameters & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)(  const Standard_CString ,   const handle<TDocStd_Document> & ,   const DESTEP_Parameters & ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Reader::Perform),
             R"#(Translate STEP file given by filename into the document Return True if succeeded, and False in case of fail)#"  , py::arg("filename"),  py::arg("doc"),  py::arg("theParams"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ExternFile",
             (Standard_Boolean (STEPCAFControl_Reader::*)(  const Standard_CString ,  handle<STEPCAFControl_ExternFile> &  ) const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)(  const Standard_CString ,  handle<STEPCAFControl_ExternFile> &  ) const>(&STEPCAFControl_Reader::ExternFile),
             R"#(Returns data on external file by its name Returns False if no external file with given name is read)#"  , py::arg("name"),  py::arg("ef")
          )
        .def("SetColorMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetColorMode),
             R"#(Set ColorMode for indicate read Colors or not.)#"  , py::arg("colormode")
          )
        .def("GetColorMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetColorMode),
             R"#()#" 
          )
        .def("SetNameMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetNameMode),
             R"#(Set NameMode for indicate read Name or not.)#"  , py::arg("namemode")
          )
        .def("GetNameMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetNameMode),
             R"#()#" 
          )
        .def("SetLayerMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetLayerMode),
             R"#(Set LayerMode for indicate read Layers or not.)#"  , py::arg("layermode")
          )
        .def("GetLayerMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetLayerMode),
             R"#()#" 
          )
        .def("SetPropsMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetPropsMode),
             R"#(PropsMode for indicate read Validation properties or not.)#"  , py::arg("propsmode")
          )
        .def("GetPropsMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetPropsMode),
             R"#()#" 
          )
        .def("SetMetaMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetMetaMode),
             R"#(MetaMode for indicate read Metadata or not.)#"  , py::arg("theMetaMode")
          )
        .def("GetMetaMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetMetaMode),
             R"#()#" 
          )
        .def("SetProductMetaMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetProductMetaMode),
             R"#(MetaMode for indicate whether to read Product Metadata or not.)#"  , py::arg("theProductMetaMode")
          )
        .def("GetProductMetaMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetProductMetaMode),
             R"#()#" 
          )
        .def("SetSHUOMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetSHUOMode),
             R"#(Set SHUO mode for indicate write SHUO or not.)#"  , py::arg("shuomode")
          )
        .def("GetSHUOMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetSHUOMode),
             R"#()#" 
          )
        .def("SetGDTMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetGDTMode),
             R"#(Set GDT mode for indicate write GDT or not.)#"  , py::arg("gdtmode")
          )
        .def("GetGDTMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetGDTMode),
             R"#()#" 
          )
        .def("SetMatMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetMatMode),
             R"#(Set Material mode)#"  , py::arg("matmode")
          )
        .def("GetMatMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetMatMode),
             R"#()#" 
          )
        .def("SetViewMode",
             (void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Reader::SetViewMode),
             R"#(Set View mode)#"  , py::arg("viewmode")
          )
        .def("GetViewMode",
             (Standard_Boolean (STEPCAFControl_Reader::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetViewMode),
             R"#(Get View mode)#" 
          )
        .def("SetShapeFixParameters",
             (void (STEPCAFControl_Reader::*)(  const typename XSAlgo_ShapeProcessor::ParameterMap &  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const typename XSAlgo_ShapeProcessor::ParameterMap &  ) >(&STEPCAFControl_Reader::SetShapeFixParameters),
             R"#(Sets parameters for shape processing.)#"  , py::arg("theParameters")
          )
        .def("SetShapeFixParameters",
             (void (STEPCAFControl_Reader::*)(  const DE_ShapeFixParameters & ,   const typename XSAlgo_ShapeProcessor::ParameterMap &  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const DE_ShapeFixParameters & ,   const typename XSAlgo_ShapeProcessor::ParameterMap &  ) >(&STEPCAFControl_Reader::SetShapeFixParameters),
             R"#(Sets parameters for shape processing. Parameters from theParameters are copied to the internal map. Parameters from theAdditionalParameters are copied to the internal map if they are not present in theParameters.)#"  , py::arg("theParameters"),  py::arg("theAdditionalParameters")=static_cast< const typename XSAlgo_ShapeProcessor::ParameterMap &>(XSAlgo_ShapeProcessor::ParameterMap{ })
          )
        .def("SetShapeProcessFlags",
             (void (STEPCAFControl_Reader::*)(  const typename ShapeProcess::OperationsFlags &  ) ) static_cast<void (STEPCAFControl_Reader::*)(  const typename ShapeProcess::OperationsFlags &  ) >(&STEPCAFControl_Reader::SetShapeProcessFlags),
             R"#(Sets flags defining operations to be performed on shapes.)#"  , py::arg("theFlags")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("FindInstance_s",
                    (TDF_Label (*)(  const handle<StepRepr_NextAssemblyUsageOccurrence> & ,   const handle<XCAFDoc_ShapeTool> & ,   const STEPConstruct_Tool & ,   const XCAFDoc_DataMapOfShapeLabel &  ) ) static_cast<TDF_Label (*)(  const handle<StepRepr_NextAssemblyUsageOccurrence> & ,   const handle<XCAFDoc_ShapeTool> & ,   const STEPConstruct_Tool & ,   const XCAFDoc_DataMapOfShapeLabel &  ) >(&STEPCAFControl_Reader::FindInstance),
                    R"#(Returns label of instance of an assembly component corresponding to a given NAUO)#"  , py::arg("NAUO"),  py::arg("STool"),  py::arg("Tool"),  py::arg("ShapeLabelMap")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ExternFiles",
             ( const NCollection_DataMap<TCollection_AsciiString, handle<STEPCAFControl_ExternFile>> & (STEPCAFControl_Reader::*)() const) static_cast< const NCollection_DataMap<TCollection_AsciiString, handle<STEPCAFControl_ExternFile>> & (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::ExternFiles),
             R"#(Returns data on external files Returns Null handle if no external files are read)#"
             
         )
       .def("ChangeReader",
             (STEPControl_Reader & (STEPCAFControl_Reader::*)() ) static_cast<STEPControl_Reader & (STEPCAFControl_Reader::*)() >(&STEPCAFControl_Reader::ChangeReader),
             R"#(Returns basic reader)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("Reader",
             ( const STEPControl_Reader & (STEPCAFControl_Reader::*)() const) static_cast< const STEPControl_Reader & (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::Reader),
             R"#(Returns basic reader as const)#"
             
         )
       .def("GetShapeLabelMap",
             ( const XCAFDoc_DataMapOfShapeLabel & (STEPCAFControl_Reader::*)() const) static_cast< const XCAFDoc_DataMapOfShapeLabel & (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetShapeLabelMap),
             R"#()#"
             
         )
       .def("GetShapeFixParameters",
             ( const typename XSAlgo_ShapeProcessor::ParameterMap & (STEPCAFControl_Reader::*)() const) static_cast< const typename XSAlgo_ShapeProcessor::ParameterMap & (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetShapeFixParameters),
             R"#(Returns parameters for shape processing that was set by SetParameters() method.)#"
             
         )
       .def("GetShapeProcessFlags",
             ( const typename XSAlgo_ShapeProcessor::ProcessingFlags & (STEPCAFControl_Reader::*)() const) static_cast< const typename XSAlgo_ShapeProcessor::ProcessingFlags & (STEPCAFControl_Reader::*)() const>(&STEPCAFControl_Reader::GetShapeProcessFlags),
             R"#(Returns flags defining operations to be performed on shapes.)#"
             
         )
;

    // Class STEPCAFControl_Writer from ./opencascade/STEPCAFControl_Writer.hxx
    klass = m.attr("STEPCAFControl_Writer");


    // nested enums

    static_cast<py::class_<STEPCAFControl_Writer , shared_ptr<STEPCAFControl_Writer>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<XSControl_WorkSession> &, const Standard_Boolean >()  , py::arg("theWS"),  py::arg("theScratch")=static_cast< const Standard_Boolean>(Standard_True) )
    // custom constructors
    // methods
        .def("Init",
             (void (STEPCAFControl_Writer::*)(  const handle<XSControl_WorkSession> & ,   const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const handle<XSControl_WorkSession> & ,   const Standard_Boolean  ) >(&STEPCAFControl_Writer::Init),
             R"#(Clears the internal data structures and attaches to a new session Clears the session if it was not yet set for STEP)#"  , py::arg("theWS"),  py::arg("theScratch")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("Write",
             (IFSelect_ReturnStatus (STEPCAFControl_Writer::*)(  const Standard_CString  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Writer::*)(  const Standard_CString  ) >(&STEPCAFControl_Writer::Write),
             R"#(Writes all the produced models into file In case of multimodel with extern references, filename will be a name of root file, all other files have names of corresponding parts Provided for use like single-file writer)#"  , py::arg("theFileName")
          )
        .def("WriteStream",
             (IFSelect_ReturnStatus (STEPCAFControl_Writer::*)( typename std::ostream &  ) ) static_cast<IFSelect_ReturnStatus (STEPCAFControl_Writer::*)( typename std::ostream &  ) >(&STEPCAFControl_Writer::WriteStream),
             R"#(Writes all the produced models into the stream. Provided for use like single-file writer)#"  , py::arg("theStream")
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Transfers a document (or single label) to a STEP model The mode of translation of shape is AsIs If multi is not null pointer, it switches to multifile mode (with external refs), and string pointed by <multi> gives prefix for names of extern files (can be empty string) Returns True if translation is OK)#"  , py::arg("theDoc"),  py::arg("theMode")=static_cast< const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast< const Standard_CString>(0),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const DESTEP_Parameters & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const DESTEP_Parameters & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Transfers a document (or single label) to a STEP model This method uses if need to set parameters avoiding initialization from Interface_Static)#"  , py::arg("theDoc"),  py::arg("theParams"),  py::arg("theMode")=static_cast< const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast< const Standard_CString>(0),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_Label & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_Label & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Method to transfer part of the document specified by label)#"  , py::arg("theLabel"),  py::arg("theMode")=static_cast< const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast< const Standard_CString>(0),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_Label & ,   const DESTEP_Parameters & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_Label & ,   const DESTEP_Parameters & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Method to transfer part of the document specified by label This method uses if need to set parameters avoiding initialization from Interface_Static)#"  , py::arg("theLabel"),  py::arg("theParams"),  py::arg("theMode")=static_cast< const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast< const Standard_CString>(0),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_LabelSequence & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_LabelSequence & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Method to writing sequence of root assemblies or part of the file specified by use by one label)#"  , py::arg("theLabelSeq"),  py::arg("theMode")=static_cast< const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast< const Standard_CString>(0),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_LabelSequence & ,   const DESTEP_Parameters & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_LabelSequence & ,   const DESTEP_Parameters & ,   const STEPControl_StepModelType ,   const Standard_CString ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Transfer),
             R"#(Method to writing sequence of root assemblies or part of the file specified by use by one label. This method is utilized if there's a need to set parameters avoiding initialization from Interface_Static)#"  , py::arg("theLabelSeq"),  py::arg("theParams"),  py::arg("theMode")=static_cast< const STEPControl_StepModelType>(STEPControl_AsIs),  py::arg("theIsMulti")=static_cast< const Standard_CString>(0),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const TCollection_AsciiString & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const TCollection_AsciiString & ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Perform),
             R"#()#"  , py::arg("theDoc"),  py::arg("theFileName"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const Standard_CString ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const Standard_CString ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Perform),
             R"#(Transfers a document and writes it to a STEP file Returns True if translation is OK)#"  , py::arg("theDoc"),  py::arg("theFileName"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const Standard_CString ,   const DESTEP_Parameters & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const Standard_CString ,   const DESTEP_Parameters & ,   const Message_ProgressRange &  ) >(&STEPCAFControl_Writer::Perform),
             R"#(Transfers a document and writes it to a STEP file This method is utilized if there's a need to set parameters avoiding initialization from Interface_Static Returns True if translation is OK)#"  , py::arg("theDoc"),  py::arg("theFileName"),  py::arg("theParams"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ExternFile",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_Label & ,  handle<STEPCAFControl_ExternFile> &  ) const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const TDF_Label & ,  handle<STEPCAFControl_ExternFile> &  ) const>(&STEPCAFControl_Writer::ExternFile),
             R"#(Returns data on external file by its original label Returns False if no external file with given name is read)#"  , py::arg("theLabel"),  py::arg("theExtFile")
          )
        .def("ExternFile",
             (Standard_Boolean (STEPCAFControl_Writer::*)(  const Standard_CString ,  handle<STEPCAFControl_ExternFile> &  ) const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)(  const Standard_CString ,  handle<STEPCAFControl_ExternFile> &  ) const>(&STEPCAFControl_Writer::ExternFile),
             R"#(Returns data on external file by its name Returns False if no external file with given name is read)#"  , py::arg("theName"),  py::arg("theExtFile")
          )
        .def("SetColorMode",
             (void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetColorMode),
             R"#(Set ColorMode for indicate write Colors or not.)#"  , py::arg("theColorMode")
          )
        .def("GetColorMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetColorMode),
             R"#()#" 
          )
        .def("SetNameMode",
             (void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetNameMode),
             R"#(Set NameMode for indicate write Name or not.)#"  , py::arg("theNameMode")
          )
        .def("GetNameMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetNameMode),
             R"#()#" 
          )
        .def("SetLayerMode",
             (void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetLayerMode),
             R"#(Set LayerMode for indicate write Layers or not.)#"  , py::arg("theLayerMode")
          )
        .def("GetLayerMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetLayerMode),
             R"#()#" 
          )
        .def("SetPropsMode",
             (void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetPropsMode),
             R"#(PropsMode for indicate write Validation properties or not.)#"  , py::arg("thePropsMode")
          )
        .def("GetPropsMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetPropsMode),
             R"#()#" 
          )
        .def("SetSHUOMode",
             (void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetSHUOMode),
             R"#(Set SHUO mode for indicate write SHUO or not.)#"  , py::arg("theSHUOMode")
          )
        .def("GetSHUOMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetSHUOMode),
             R"#()#" 
          )
        .def("SetDimTolMode",
             (void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetDimTolMode),
             R"#(Set dimtolmode for indicate write D&GTs or not.)#"  , py::arg("theDimTolMode")
          )
        .def("GetDimTolMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetDimTolMode),
             R"#()#" 
          )
        .def("SetMaterialMode",
             (void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const Standard_Boolean  ) >(&STEPCAFControl_Writer::SetMaterialMode),
             R"#(Set dimtolmode for indicate write D&GTs or not.)#"  , py::arg("theMaterialMode")
          )
        .def("GetMaterialMode",
             (Standard_Boolean (STEPCAFControl_Writer::*)() const) static_cast<Standard_Boolean (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetMaterialMode),
             R"#()#" 
          )
        .def("SetShapeFixParameters",
             (void (STEPCAFControl_Writer::*)(  const typename XSAlgo_ShapeProcessor::ParameterMap &  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const typename XSAlgo_ShapeProcessor::ParameterMap &  ) >(&STEPCAFControl_Writer::SetShapeFixParameters),
             R"#(Sets parameters for shape processing.)#"  , py::arg("theParameters")
          )
        .def("SetShapeFixParameters",
             (void (STEPCAFControl_Writer::*)(  const DE_ShapeFixParameters & ,   const typename XSAlgo_ShapeProcessor::ParameterMap &  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const DE_ShapeFixParameters & ,   const typename XSAlgo_ShapeProcessor::ParameterMap &  ) >(&STEPCAFControl_Writer::SetShapeFixParameters),
             R"#(Sets parameters for shape processing. Parameters from theParameters are copied to the internal map. Parameters from theAdditionalParameters are copied to the internal map if they are not present in theParameters.)#"  , py::arg("theParameters"),  py::arg("theAdditionalParameters")=static_cast< const typename XSAlgo_ShapeProcessor::ParameterMap &>(XSAlgo_ShapeProcessor::ParameterMap{ })
          )
        .def("SetShapeProcessFlags",
             (void (STEPCAFControl_Writer::*)(  const typename ShapeProcess::OperationsFlags &  ) ) static_cast<void (STEPCAFControl_Writer::*)(  const typename ShapeProcess::OperationsFlags &  ) >(&STEPCAFControl_Writer::SetShapeProcessFlags),
             R"#(Sets flags defining operations to be performed on shapes.)#"  , py::arg("theFlags")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ExternFiles",
             ( const NCollection_DataMap<TCollection_AsciiString, handle<STEPCAFControl_ExternFile>> & (STEPCAFControl_Writer::*)() const) static_cast< const NCollection_DataMap<TCollection_AsciiString, handle<STEPCAFControl_ExternFile>> & (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::ExternFiles),
             R"#(Returns data on external files Returns Null handle if no external files are read)#"
             
         )
       .def("ChangeWriter",
             (STEPControl_Writer & (STEPCAFControl_Writer::*)() ) static_cast<STEPControl_Writer & (STEPCAFControl_Writer::*)() >(&STEPCAFControl_Writer::ChangeWriter),
             R"#(Returns basic reader for root file)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("Writer",
             ( const STEPControl_Writer & (STEPCAFControl_Writer::*)() const) static_cast< const STEPControl_Writer & (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::Writer),
             R"#(Returns basic reader as const)#"
             
         )
       .def("GetShapeFixParameters",
             ( const typename XSAlgo_ShapeProcessor::ParameterMap & (STEPCAFControl_Writer::*)() const) static_cast< const typename XSAlgo_ShapeProcessor::ParameterMap & (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetShapeFixParameters),
             R"#(Returns parameters for shape processing that was set by SetParameters() method.)#"
             
         )
       .def("GetShapeProcessFlags",
             ( const typename XSAlgo_ShapeProcessor::ProcessingFlags & (STEPCAFControl_Writer::*)() const) static_cast< const typename XSAlgo_ShapeProcessor::ProcessingFlags & (STEPCAFControl_Writer::*)() const>(&STEPCAFControl_Writer::GetShapeProcessFlags),
             R"#(Returns flags defining operations to be performed on shapes.)#"
             
         )
;

// functions

// ./opencascade/STEPCAFControl_ActorWrite.hxx
// ./opencascade/STEPCAFControl_ConfigurationNode.hxx
// ./opencascade/STEPCAFControl_Controller.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfLabelExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfLabelShape.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfPDExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfSDRExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfShapePD.hxx
// ./opencascade/STEPCAFControl_DataMapIteratorOfDataMapOfShapeSDR.hxx
// ./opencascade/STEPCAFControl_DataMapOfLabelExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapOfLabelShape.hxx
// ./opencascade/STEPCAFControl_DataMapOfPDExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapOfSDRExternFile.hxx
// ./opencascade/STEPCAFControl_DataMapOfShapePD.hxx
// ./opencascade/STEPCAFControl_DataMapOfShapeSDR.hxx
// ./opencascade/STEPCAFControl_ExternFile.hxx
// ./opencascade/STEPCAFControl_GDTProperty.hxx
// ./opencascade/STEPCAFControl_Provider.hxx
// ./opencascade/STEPCAFControl_Reader.hxx
// ./opencascade/STEPCAFControl_Writer.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_DataMap<TDF_Label, TopoDS_Shape>(m,"STEPCAFControl_DataMapOfLabelShape");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
