import OCP.IGESCAFControl
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.TCollection
import io
import OCP.Quantity
import OCP.Resource
import OCP.TColStd
import OCP.XSControl
import OCP.TopoDS
import OCP.TDocStd
import OCP.Interface
import OCP.IFSelect
import OCP.IGESControl
import OCP.Standard
import OCP.DE
import OCP.TDF
import OCP.IGESData
import OCP.Transfer
__all__  = [
"IGESCAFControl",
"IGESCAFControl_Reader",
"IGESCAFControl_Writer"
]
class IGESCAFControl():
    """
    Provides high-level API to translate IGES file to and from DECAF document
    """
    @staticmethod
    def DecodeColor_s(col : int) -> OCP.Quantity.Quantity_Color: 
        """
        Provides a tool for writing IGES file Converts IGES color index to CASCADE color
        """
    @staticmethod
    def EncodeColor_s(col : OCP.Quantity.Quantity_Color) -> int: 
        """
        Tries to Convert CASCADE color to IGES color index If no corresponding color defined in IGES, returns 0
        """
    def __init__(self) -> None: ...
    pass
class IGESCAFControl_Reader(OCP.IGESControl.IGESControl_Reader, OCP.XSControl.XSControl_Reader):
    """
    Provides a tool to read IGES file and put it into DECAF document. Besides transfer of shapes (including assemblies) provided by IGESControl, supports also colors and part names IGESCAFControl_Reader reader; Methods for translation of an IGES file: reader.ReadFile("filename"); reader.Transfer(Document); or reader.Perform("filename",doc); Methods for managing reading attributes. Colors reader.SetColorMode(colormode); Standard_Boolean colormode = reader.GetColorMode(); Layers reader.SetLayerMode(layermode); Standard_Boolean layermode = reader.GetLayerMode(); Names reader.SetNameMode(namemode); Standard_Boolean namemode = reader.GetNameMode();
    """
    def ClearShapes(self) -> None: 
        """
        Clears the list of shapes that may have accumulated in calls to TransferOne or TransferRoot.C
        """
    def GetColorMode(self) -> bool: ...
    def GetLayerMode(self) -> bool: ...
    def GetNameMode(self) -> bool: ...
    def GetReadVisible(self) -> bool: ...
    def GetShapeFixParameters(self) -> OCP.Resource.Resource_DataMapOfAsciiStringAsciiString: 
        """
        Returns parameters for shape processing that was set by SetParameters() method.
        """
    def GetShapeProcessFlags(self) -> Any: 
        """
        Returns flags defining operations to be performed on shapes.
        """
    def GetStatsTransfer(self,list : OCP.TColStd.TColStd_HSequenceOfTransient) -> tuple[int, int, int]: 
        """
        Gives statistics about Transfer
        """
    @overload
    def GiveList(self,first : str='',second : str='') -> OCP.TColStd.TColStd_HSequenceOfTransient: 
        """
        Returns a list of entities from the IGES or STEP file according to the following rules: - if first and second are empty strings, the whole file is selected. - if first is an entity number or label, the entity referred to is selected. - if first is a list of entity numbers/labels separated by commas, the entities referred to are selected, - if first is the name of a selection in the worksession and second is not defined, the list contains the standard output for that selection. - if first is the name of a selection and second is defined, the criterion defined by second is applied to the result of the first selection. A selection is an operator which computes a list of entities from a list given in input according to its type. If no list is specified, the selection computes its list of entities from the whole model. A selection can be: - A predefined selection (xst-transferrable-mode) - A filter based on a signature A Signature is an operator which returns a string from an entity according to its type. For example: - "xst-type" (CDL) - "iges-level" - "step-type". For example, if you wanted to select only the advanced_faces in a STEP file you would use the following code: Example Reader.GiveList("xst-transferrable-roots","step-type(ADVANCED_FACE)"); Warning If the value given to second is incorrect, it will simply be ignored.

        Computes a List of entities from the model as follows <first> being a Selection, <ent> being an entity or a list of entities (as a HSequenceOfTransient) : the standard result of this selection applied to this list if <first> is erroneous, a null handle is returned
        """
    @overload
    def GiveList(self,first : str,ent : OCP.Standard.Standard_Transient) -> OCP.TColStd.TColStd_HSequenceOfTransient: ...
    def IGESModel(self) -> OCP.IGESData.IGESData_IGESModel: 
        """
        Returns the model as a IGESModel. It can then be consulted (header, product)
        """
    def Model(self) -> OCP.Interface.Interface_InterfaceModel: 
        """
        Returns the model. It can then be consulted (header, product)
        """
    def NbRootsForTransfer(self) -> int: 
        """
        Determines the list of root entities from Model which are candidate for a transfer to a Shape (type of entities is PRODUCT) <theReadOnlyVisible> is taken into account to define roots
        """
    def NbShapes(self) -> int: 
        """
        Returns the number of shapes produced by translation.
        """
    def OneShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns all of the results in a single shape which is: - a null shape if there are no results, - a shape if there is one result, - a compound containing the resulting shapes if there are more than one.
        """
    @overload
    def Perform(self,theFileName : OCP.TCollection.TCollection_AsciiString,theDoc : OCP.TDocStd.TDocStd_Document,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Translate IGES file given by filename into the document Return True if succeeded, and False in case of fail
        """
    @overload
    def Perform(self,theFileName : str,theDoc : OCP.TDocStd.TDocStd_Document,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def PrintCheckLoad(self,failsonly : bool,mode : OCP.IFSelect.IFSelect_PrintCount) -> None: 
        """
        Prints the check list attached to loaded data, on the Standard Trace File (starts at std::cout) All messages or fails only, according to <failsonly> mode = 0 : per entity, prints messages mode = 1 : per message, just gives count of entities per check mode = 2 : also gives entity numbers

        Prints the check list attached to loaded data.
        """
    @overload
    def PrintCheckLoad(self,theStream : io.BytesIO,failsonly : bool,mode : OCP.IFSelect.IFSelect_PrintCount) -> None: ...
    @overload
    def PrintCheckTransfer(self,failsonly : bool,mode : OCP.IFSelect.IFSelect_PrintCount) -> None: 
        """
        Displays check results for the last translation of IGES or STEP entities to Open CASCADE entities. Only fail messages are displayed if failsonly is true. All messages are displayed if failsonly is false. mode determines the contents and the order of the messages according to the terms of the IFSelect_PrintCount enumeration.

        Displays check results for the last translation of IGES or STEP entities to Open CASCADE entities.
        """
    @overload
    def PrintCheckTransfer(self,theStream : io.BytesIO,failsonly : bool,mode : OCP.IFSelect.IFSelect_PrintCount) -> None: ...
    @overload
    def PrintStatsTransfer(self,what : int,mode : int=0) -> None: 
        """
        Displays the statistics for the last translation. what defines the kind of statistics that are displayed as follows: - 0 gives general statistics (number of translated roots, number of warnings, number of fail messages), - 1 gives root results, - 2 gives statistics for all checked entities, - 3 gives the list of translated entities, - 4 gives warning and fail messages, - 5 gives fail messages only. The use of mode depends on the value of what. If what is 0, mode is ignored. If what is 1, 2 or 3, mode defines the following: - 0 lists the numbers of IGES or STEP entities in the respective model - 1 gives the number, identifier, type and result type for each IGES or STEP entity and/or its status (fail, warning, etc.) - 2 gives maximum information for each IGES or STEP entity (i.e. checks) - 3 gives the number of entities per type of IGES or STEP entity - 4 gives the number of IGES or STEP entities per result type and/or status - 5 gives the number of pairs (IGES or STEP or result type and status) - 6 gives the number of pairs (IGES or STEP or result type and status) AND the list of entity numbers in the IGES or STEP model. If what is 4 or 5, mode defines the warning and fail messages as follows: - if mode is 0 all warnings and checks per entity are returned - if mode is 2 the list of entities per warning is returned. If mode is not set, only the list of all entities per warning is given.

        Displays the statistics for the last translation.
        """
    @overload
    def PrintStatsTransfer(self,theStream : io.BytesIO,what : int,mode : int=0) -> None: ...
    def PrintTransferInfo(self,failwarn : OCP.IFSelect.IFSelect_PrintFail,mode : OCP.IFSelect.IFSelect_PrintCount) -> None: 
        """
        Prints Statistics and check list for Transfer
        """
    def ReadFile(self,filename : str) -> OCP.IFSelect.IFSelect_ReturnStatus: 
        """
        Loads a file and returns the read status Zero for a Model which complies with the Controller
        """
    def ReadStream(self,theName : str,theIStream : io.BytesIO) -> OCP.IFSelect.IFSelect_ReturnStatus: 
        """
        Loads a file from stream and returns the read status
        """
    def RootForTransfer(self,num : int=1) -> OCP.Standard.Standard_Transient: 
        """
        Returns an IGES or STEP root entity for translation. The entity is identified by its rank in a list.
        """
    def SetColorMode(self,theMode : bool) -> None: 
        """
        Set ColorMode for indicate read Colors or not.
        """
    def SetLayerMode(self,theMode : bool) -> None: 
        """
        Set LayerMode for indicate read Layers or not.
        """
    def SetNameMode(self,theMode : bool) -> None: 
        """
        Set NameMode for indicate read Name or not.
        """
    def SetNorm(self,norm : str) -> bool: 
        """
        Sets a specific norm to <me> Returns True if done, False if <norm> is not available
        """
    def SetReadVisible(self,ReadRoot : bool) -> None: 
        """
        Set the transion of ALL Roots (if theReadOnlyVisible is False) or of Visible Roots (if theReadOnlyVisible is True)

        Set the transion of ALL Roots (if theReadOnlyVisible is False) or of Visible Roots (if theReadOnlyVisible is True)
        """
    @overload
    def SetShapeFixParameters(self,theParameters : OCP.Resource.Resource_DataMapOfAsciiStringAsciiString) -> None: 
        """
        Sets parameters for shape processing.

        Sets parameters for shape processing. Parameters from theParameters are copied to the internal map. Parameters from theAdditionalParameters are copied to the internal map if they are not present in theParameters.
        """
    @overload
    def SetShapeFixParameters(self,theParameters : OCP.DE.DE_ShapeFixParameters,theAdditionalParameters : OCP.Resource.Resource_DataMapOfAsciiStringAsciiString=OCP.Resource.Resource_DataMapOfAsciiStringAsciiString) -> None: ...
    def SetShapeProcessFlags(self,theFlags : Any) -> None: 
        """
        Sets flags defining operations to be performed on shapes.
        """
    def SetWS(self,WS : OCP.XSControl.XSControl_WorkSession,scratch : bool=True) -> None: 
        """
        Sets a specific session to <me>
        """
    def Shape(self,num : int=1) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the shape resulting from a translation and identified by the rank num. num equals 1 by default. In other words, the first shape resulting from the translation is returned.
        """
    def Transfer(self,theDoc : OCP.TDocStd.TDocStd_Document,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Translates currently loaded IGES file into the document Returns True if succeeded, and False in case of fail
        """
    def TransferEntity(self,start : OCP.Standard.Standard_Transient,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Translates an IGES or STEP entity in the model. true is returned if a shape is produced; otherwise, false is returned.
        """
    def TransferList(self,list : OCP.TColStd.TColStd_HSequenceOfTransient,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> int: 
        """
        Translates a list of entities. Returns the number of IGES or STEP entities that were successfully translated. The list can be produced with GiveList. Warning - This function does not clear the existing output shapes.
        """
    def TransferOne(self,num : int,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Translates an IGES or STEP entity identified by the rank num in the model. false is returned if no shape is produced.
        """
    def TransferOneRoot(self,num : int=1,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Translates a root identified by the rank num in the model. false is returned if no shape is produced.
        """
    def TransferRoots(self,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> int: 
        """
        Translates all translatable roots and returns the number of successful translations. Warning - This function clears existing output shapes first.
        """
    def WS(self) -> OCP.XSControl.XSControl_WorkSession: 
        """
        Returns the session used in <me>
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theWS : OCP.XSControl.XSControl_WorkSession,FromScratch : bool=True) -> None: ...
    pass
class IGESCAFControl_Writer(OCP.IGESControl.IGESControl_Writer):
    """
    Provides a tool to write DECAF document to the IGES file. Besides transfer of shapes (including assemblies) provided by IGESControl, supports also colors and part names IGESCAFControl_Writer writer(); Methods for writing IGES file: writer.Transfer (Document); writer.Write("filename") or writer.Write(OStream) or writer.Perform(Document,"filename"); Methods for managing the writing of attributes. Colors writer.SetColorMode(colormode); Standard_Boolean colormode = writer.GetColorMode(); Layers writer.SetLayerMode(layermode); Standard_Boolean layermode = writer.GetLayerMode(); Names writer.SetNameMode(namemode); Standard_Boolean namemode = writer.GetNameMode();
    """
    def AddEntity(self,ent : OCP.IGESData.IGESData_IGESEntity) -> bool: 
        """
        Adds an IGES entity (and the ones it references) to the model
        """
    def AddGeom(self,geom : OCP.Standard.Standard_Transient) -> bool: 
        """
        Translates a Geometry (Surface or Curve) to IGES Entities and adds them to the model Returns True if done, False if geom is neither a Surface or a Curve suitable for IGES or is null
        """
    def AddShape(self,sh : OCP.TopoDS.TopoDS_Shape,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Translates a Shape to IGES Entities and adds them to the model Returns True if done, False if Shape not suitable for IGES or null
        """
    def ComputeModel(self) -> None: 
        """
        Computes the entities found in the model, which is ready to be written. This contrasts with the default computation of headers only.
        """
    def GetColorMode(self) -> bool: ...
    def GetLayerMode(self) -> bool: ...
    def GetNameMode(self) -> bool: ...
    def GetShapeFixParameters(self) -> OCP.Resource.Resource_DataMapOfAsciiStringAsciiString: 
        """
        Returns parameters for shape processing that was set by SetParameters() method.
        """
    def GetShapeProcessFlags(self) -> Any: 
        """
        Returns flags defining operations to be performed on shapes.
        """
    def Model(self) -> OCP.IGESData.IGESData_IGESModel: 
        """
        Returns the IGES model to be written in output.
        """
    @overload
    def Perform(self,doc : OCP.TDocStd.TDocStd_Document,filename : OCP.TCollection.TCollection_AsciiString,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Transfers a document and writes it to a IGES file Returns True if translation is OK
        """
    @overload
    def Perform(self,doc : OCP.TDocStd.TDocStd_Document,filename : str,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    def SetColorMode(self,colormode : bool) -> None: 
        """
        Set ColorMode for indicate write Colors or not.
        """
    def SetLayerMode(self,layermode : bool) -> None: 
        """
        Set LayerMode for indicate write Layers or not.
        """
    def SetNameMode(self,namemode : bool) -> None: 
        """
        Set NameMode for indicate write Name or not.
        """
    @overload
    def SetShapeFixParameters(self,theParameters : OCP.Resource.Resource_DataMapOfAsciiStringAsciiString) -> None: 
        """
        Sets parameters for shape processing.

        Sets parameters for shape processing. Parameters from theParameters are copied to the internal map. Parameters from theAdditionalParameters are copied to the internal map if they are not present in theParameters.
        """
    @overload
    def SetShapeFixParameters(self,theParameters : OCP.DE.DE_ShapeFixParameters,theAdditionalParameters : OCP.Resource.Resource_DataMapOfAsciiStringAsciiString=OCP.Resource.Resource_DataMapOfAsciiStringAsciiString) -> None: ...
    def SetShapeProcessFlags(self,theFlags : Any) -> None: 
        """
        Sets flags defining operations to be performed on shapes.
        """
    def SetTransferProcess(self,TP : OCP.Transfer.Transfer_FinderProcess) -> None: 
        """
        Returns/Sets the TransferProcess : it contains final results and if some, check messages
        """
    @overload
    def Transfer(self,doc : OCP.TDocStd.TDocStd_Document,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Transfers a document to a IGES model Returns True if translation is OK

        Transfers labels to a IGES model Returns True if translation is OK

        Transfers label to a IGES model Returns True if translation is OK
        """
    @overload
    def Transfer(self,labels : OCP.TDF.TDF_LabelSequence,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    @overload
    def Transfer(self,label : OCP.TDF.TDF_Label,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    def TransferProcess(self) -> OCP.Transfer.Transfer_FinderProcess: ...
    @overload
    def Write(self,S : io.BytesIO,fnes : bool=False) -> bool: 
        """
        Computes then writes the model to an OStream Returns True when done, false in case of error

        Prepares and writes an IGES model either to an OStream, S or to a file name,CString. Returns True if the operation was performed correctly and False if an error occurred (for instance, if the processor could not create the file).
        """
    @overload
    def Write(self,file : str,fnes : bool=False) -> bool: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,WS : OCP.XSControl.XSControl_WorkSession,scratch : bool=True) -> None: ...
    @overload
    def __init__(self,theWS : OCP.XSControl.XSControl_WorkSession,theUnit : str) -> None: ...
    pass
