/* Tables for conversion from and to IBM943.
   Copyright (C) 2000-2025 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#ifndef _IBM943_H
#define _IBM943_H 1

#include <gconv.h>
#include <stdint.h>

struct gap
{
  uint16_t start;
  uint16_t end;
  int32_t idx;
};

static const uint16_t __ibm943sb_to_ucs4[] =
{
  0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
  0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
  0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
  0x0018, 0x0019, 0x001c, 0x001b, 0x007f, 0x001d, 0x001e, 0x001f,
  0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
  0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
  0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
  0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
  0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
  0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
  0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
  0x0058, 0x0059, 0x005a, 0x005b, 0x00a5, 0x005d, 0x005e, 0x005f,
  0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
  0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
  0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
  0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x203e, 0x001a,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff61, 0xff62, 0xff63, 0xff64, 0xff65, 0xff66, 0xff67,
  0xff68, 0xff69, 0xff6a, 0xff6b, 0xff6c, 0xff6d, 0xff6e, 0xff6f,
  0xff70, 0xff71, 0xff72, 0xff73, 0xff74, 0xff75, 0xff76, 0xff77,
  0xff78, 0xff79, 0xff7a, 0xff7b, 0xff7c, 0xff7d, 0xff7e, 0xff7f,
  0xff80, 0xff81, 0xff82, 0xff83, 0xff84, 0xff85, 0xff86, 0xff87,
  0xff88, 0xff89, 0xff8a, 0xff8b, 0xff8c, 0xff8d, 0xff8e, 0xff8f,
  0xff90, 0xff91, 0xff92, 0xff93, 0xff94, 0xff95, 0xff96, 0xff97,
  0xff98, 0xff99, 0xff9a, 0xff9b, 0xff9c, 0xff9d, 0xff9e, 0xff9f
};

static const struct gap __ibm943db_to_ucs4_idx[] =
{
  { .start = 0x8140, .end = 0x81fc, .idx = -33088 },
  { .start = 0x824f, .end = 0x82f1, .idx = -33170 },
  { .start = 0x8340, .end = 0x83d6, .idx = -33248 },
  { .start = 0x8440, .end = 0x84be, .idx = -33353 },
  { .start = 0x8740, .end = 0x879c, .idx = -33994 },
  { .start = 0x889f, .end = 0x88fc, .idx = -34252 },
  { .start = 0x8940, .end = 0x89fc, .idx = -34319 },
  { .start = 0x8a40, .end = 0x8afc, .idx = -34386 },
  { .start = 0x8b40, .end = 0x8bfc, .idx = -34453 },
  { .start = 0x8c40, .end = 0x8cfc, .idx = -34520 },
  { .start = 0x8d40, .end = 0x8dfc, .idx = -34587 },
  { .start = 0x8e40, .end = 0x8efc, .idx = -34654 },
  { .start = 0x8f40, .end = 0x8ffc, .idx = -34721 },
  { .start = 0x9040, .end = 0x90fc, .idx = -34788 },
  { .start = 0x9140, .end = 0x91fc, .idx = -34855 },
  { .start = 0x9240, .end = 0x92fc, .idx = -34922 },
  { .start = 0x9340, .end = 0x93fc, .idx = -34989 },
  { .start = 0x9440, .end = 0x94fc, .idx = -35056 },
  { .start = 0x9540, .end = 0x95fc, .idx = -35123 },
  { .start = 0x9640, .end = 0x96fc, .idx = -35190 },
  { .start = 0x9740, .end = 0x97fc, .idx = -35257 },
  { .start = 0x9840, .end = 0x98fc, .idx = -35324 },
  { .start = 0x9940, .end = 0x99fc, .idx = -35391 },
  { .start = 0x9a40, .end = 0x9afc, .idx = -35458 },
  { .start = 0x9b40, .end = 0x9bfc, .idx = -35525 },
  { .start = 0x9c40, .end = 0x9cfc, .idx = -35592 },
  { .start = 0x9d40, .end = 0x9dfc, .idx = -35659 },
  { .start = 0x9e40, .end = 0x9efc, .idx = -35726 },
  { .start = 0x9f40, .end = 0x9ffc, .idx = -35793 },
  { .start = 0xe040, .end = 0xe0fc, .idx = -52244 },
  { .start = 0xe140, .end = 0xe1fc, .idx = -52311 },
  { .start = 0xe240, .end = 0xe2fc, .idx = -52378 },
  { .start = 0xe340, .end = 0xe3fc, .idx = -52445 },
  { .start = 0xe440, .end = 0xe4fc, .idx = -52512 },
  { .start = 0xe540, .end = 0xe5fc, .idx = -52579 },
  { .start = 0xe640, .end = 0xe6fc, .idx = -52646 },
  { .start = 0xe740, .end = 0xe7fc, .idx = -52713 },
  { .start = 0xe840, .end = 0xe8fc, .idx = -52780 },
  { .start = 0xe940, .end = 0xe9fc, .idx = -52847 },
  { .start = 0xea40, .end = 0xeaa4, .idx = -52914 },
  { .start = 0xed40, .end = 0xedfc, .idx = -53581 },
  { .start = 0xee40, .end = 0xeefc, .idx = -53648 },
  { .start = 0xf040, .end = 0xf0fc, .idx = -53971 },
  { .start = 0xf140, .end = 0xf1fc, .idx = -54038 },
  { .start = 0xf240, .end = 0xf2fc, .idx = -54105 },
  { .start = 0xf340, .end = 0xf3fc, .idx = -54172 },
  { .start = 0xf440, .end = 0xf4fc, .idx = -54239 },
  { .start = 0xf540, .end = 0xf5fc, .idx = -54306 },
  { .start = 0xf640, .end = 0xf6fc, .idx = -54373 },
  { .start = 0xf740, .end = 0xf7fc, .idx = -54440 },
  { .start = 0xf840, .end = 0xf8fc, .idx = -54507 },
  { .start = 0xf940, .end = 0xf9fc, .idx = -54574 },
  { .start = 0xfa40, .end = 0xfafc, .idx = -54641 },
  { .start = 0xfb40, .end = 0xfbfc, .idx = -54708 },
  { .start = 0xfc40, .end = 0xfc4b, .idx = -54775 },
  { .start = 0xffff, .end = 0xffff, .idx =      0 }
};

static const uint16_t __ibm943db_to_ucs4[] =
{
  0x3000, 0x3001, 0x3002, 0xff0c, 0xff0e, 0x30fb, 0xff1a, 0xff1b,
  0xff1f, 0xff01, 0x309b, 0x309c, 0x00b4, 0xff40, 0x00a8, 0xff3e,
  0xffe3, 0xff3f, 0x30fd, 0x30fe, 0x309d, 0x309e, 0x3003, 0x4edd,
  0x3005, 0x3006, 0x3007, 0x30fc, 0x2014, 0x2010, 0xff0f, 0xff3c,
  0x301c, 0x2016, 0xff5c, 0x2026, 0x2025, 0x2018, 0x2019, 0x201c,
  0x201d, 0xff08, 0xff09, 0x3014, 0x3015, 0xff3b, 0xff3d, 0xff5b,
  0xff5d, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c, 0x300d, 0x300e,
  0x300f, 0x3010, 0x3011, 0xff0b, 0x2212, 0x00b1, 0x00d7, 0x0000,
  0x00f7, 0xff1d, 0x2260, 0xff1c, 0xff1e, 0x2266, 0x2267, 0x221e,
  0x2234, 0x2642, 0x2640, 0x00b0, 0x2032, 0x2033, 0x2103, 0xffe5,
  0xff04, 0xffe0, 0xffe1, 0xff05, 0xff03, 0xff06, 0xff0a, 0xff20,
  0x00a7, 0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7, 0x25c6,
  0x25a1, 0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x203b, 0x3012,
  0x2192, 0x2190, 0x2191, 0x2193, 0x3013, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2208, 0x220b, 0x2286, 0x2287, 0x2282, 0x2283, 0x222a, 0x2229,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2227, 0x2228, 0xffe2, 0x21d2, 0x21d4, 0x2200, 0x2203, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2220, 0x22a5, 0x2312, 0x2202, 0x2207, 0x2261,
  0x2252, 0x226a, 0x226b, 0x221a, 0x223d, 0x221d, 0x2235, 0x222b,
  0x222c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x212b, 0x2030, 0x266f, 0x266d, 0x266a, 0x2020, 0x2021, 0x00b6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x25ef, 0xff10, 0xff11, 0xff12,
  0xff13, 0xff14, 0xff15, 0xff16, 0xff17, 0xff18, 0xff19, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xff21, 0xff22,
  0xff23, 0xff24, 0xff25, 0xff26, 0xff27, 0xff28, 0xff29, 0xff2a,
  0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f, 0xff30, 0xff31, 0xff32,
  0xff33, 0xff34, 0xff35, 0xff36, 0xff37, 0xff38, 0xff39, 0xff3a,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xff41,
  0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47, 0xff48, 0xff49,
  0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f, 0xff50, 0xff51,
  0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57, 0xff58, 0xff59,
  0xff5a, 0x0000, 0x0000, 0x0000, 0x0000, 0x3041, 0x3042, 0x3043,
  0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049, 0x304a, 0x304b,
  0x304c, 0x304d, 0x304e, 0x304f, 0x3050, 0x3051, 0x3052, 0x3053,
  0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059, 0x305a, 0x305b,
  0x305c, 0x305d, 0x305e, 0x305f, 0x3060, 0x3061, 0x3062, 0x3063,
  0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069, 0x306a, 0x306b,
  0x306c, 0x306d, 0x306e, 0x306f, 0x3070, 0x3071, 0x3072, 0x3073,
  0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079, 0x307a, 0x307b,
  0x307c, 0x307d, 0x307e, 0x307f, 0x3080, 0x3081, 0x3082, 0x3083,
  0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089, 0x308a, 0x308b,
  0x308c, 0x308d, 0x308e, 0x308f, 0x3090, 0x3091, 0x3092, 0x3093,
  0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7, 0x30a8,
  0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af, 0x30b0,
  0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8,
  0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0,
  0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8,
  0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf, 0x30d0,
  0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8,
  0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df, 0x0000,
  0x30e0, 0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7,
  0x30e8, 0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef,
  0x30f0, 0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0391,
  0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399,
  0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0, 0x03a1,
  0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03b1,
  0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9,
  0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 0x03c1,
  0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 0x0410,
  0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416, 0x0417,
  0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
  0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
  0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0430,
  0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 0x0436, 0x0437,
  0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x0000, 0x043e,
  0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446,
  0x0447, 0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e,
  0x044f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2500, 0x2502,
  0x250c, 0x2510, 0x2518, 0x2514, 0x251c, 0x252c, 0x2524, 0x2534,
  0x253c, 0x2501, 0x2503, 0x250f, 0x2513, 0x251b, 0x2517, 0x2523,
  0x2533, 0x252b, 0x253b, 0x254b, 0x2520, 0x252f, 0x2528, 0x2537,
  0x253f, 0x251d, 0x2530, 0x2525, 0x2538, 0x2542, 0x2460, 0x2461,
  0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469,
  0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x246f, 0x2470, 0x2471,
  0x2472, 0x2473, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165,
  0x2166, 0x2167, 0x2168, 0x2169, 0x0000, 0x3349, 0x3314, 0x3322,
  0x334d, 0x3318, 0x3327, 0x3303, 0x3336, 0x3351, 0x3357, 0x330d,
  0x3326, 0x3323, 0x332b, 0x334a, 0x333b, 0x339c, 0x339d, 0x339e,
  0x338e, 0x338f, 0x33c4, 0x33a1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x337b, 0x0000, 0x301d, 0x301f,
  0x2116, 0x33cd, 0x2121, 0x32a4, 0x32a5, 0x32a6, 0x32a7, 0x32a8,
  0x3231, 0x3232, 0x3239, 0x337e, 0x337d, 0x337c, 0x2252, 0x2261,
  0x222b, 0x222e, 0x2211, 0x221a, 0x22a5, 0x2220, 0x221f, 0x22bf,
  0x2235, 0x2229, 0x222a, 0x4e9c, 0x5516, 0x5a03, 0x963f, 0x54c0,
  0x611b, 0x6328, 0x59f6, 0x9022, 0x8475, 0x831c, 0x7a50, 0x60aa,
  0x63e1, 0x6e25, 0x65ed, 0x8466, 0x82a6, 0x9bf5, 0x6893, 0x5727,
  0x65a1, 0x6271, 0x5b9b, 0x59d0, 0x867b, 0x98f4, 0x7d62, 0x7dbe,
  0x9b8e, 0x6216, 0x7c9f, 0x88b7, 0x5b89, 0x5eb5, 0x6309, 0x6697,
  0x6848, 0x95c7, 0x978d, 0x674f, 0x4ee5, 0x4f0a, 0x4f4d, 0x4f9d,
  0x5049, 0x56f2, 0x5937, 0x59d4, 0x5a01, 0x5c09, 0x60df, 0x610f,
  0x6170, 0x6613, 0x6905, 0x70ba, 0x754f, 0x7570, 0x79fb, 0x7dad,
  0x7def, 0x80c3, 0x840e, 0x8863, 0x8b02, 0x9055, 0x907a, 0x533b,
  0x4e95, 0x4ea5, 0x57df, 0x80b2, 0x90c1, 0x78ef, 0x4e00, 0x58f1,
  0x6ea2, 0x9038, 0x7a32, 0x8328, 0x828b, 0x9c2f, 0x5141, 0x5370,
  0x54bd, 0x54e1, 0x56e0, 0x59fb, 0x5f15, 0x98f2, 0x6deb, 0x80e4,
  0x852d, 0x9662, 0x9670, 0x96a0, 0x97fb, 0x540b, 0x53f3, 0x5b87,
  0x70cf, 0x7fbd, 0x8fc2, 0x96e8, 0x536f, 0x9d5c, 0x7aba, 0x4e11,
  0x7893, 0x81fc, 0x6e26, 0x5618, 0x5504, 0x6b1d, 0x851a, 0x9c3b,
  0x59e5, 0x53a9, 0x6d66, 0x74dc, 0x958f, 0x5642, 0x4e91, 0x904b,
  0x96f2, 0x834f, 0x990c, 0x53e1, 0x55b6, 0x5b30, 0x5f71, 0x6620,
  0x66f3, 0x6804, 0x6c38, 0x6cf3, 0x6d29, 0x745b, 0x76c8, 0x7a4e,
  0x9834, 0x82f1, 0x885b, 0x8a60, 0x92ed, 0x6db2, 0x75ab, 0x76ca,
  0x99c5, 0x60a6, 0x8b01, 0x8d8a, 0x95b2, 0x698e, 0x53ad, 0x5186,
  0x0000, 0x5712, 0x5830, 0x5944, 0x5bb4, 0x5ef6, 0x6028, 0x63a9,
  0x63f4, 0x6cbf, 0x6f14, 0x708e, 0x7114, 0x7159, 0x71d5, 0x733f,
  0x7e01, 0x8276, 0x82d1, 0x8597, 0x9060, 0x925b, 0x9d1b, 0x5869,
  0x65bc, 0x6c5a, 0x7525, 0x51f9, 0x592e, 0x5965, 0x5f80, 0x5fdc,
  0x62bc, 0x65fa, 0x6a2a, 0x6b27, 0x6bb4, 0x738b, 0x7fc1, 0x8956,
  0x9d2c, 0x9d0e, 0x9ec4, 0x5ca1, 0x6c96, 0x837b, 0x5104, 0x5c4b,
  0x61b6, 0x81c6, 0x6876, 0x7261, 0x4e59, 0x4ffa, 0x5378, 0x6069,
  0x6e29, 0x7a4f, 0x97f3, 0x4e0b, 0x5316, 0x4eee, 0x4f55, 0x4f3d,
  0x4fa1, 0x4f73, 0x52a0, 0x53ef, 0x5609, 0x590f, 0x5ac1, 0x5bb6,
  0x5be1, 0x79d1, 0x6687, 0x679c, 0x67b6, 0x6b4c, 0x6cb3, 0x706b,
  0x73c2, 0x798d, 0x79be, 0x7a3c, 0x7b87, 0x82b1, 0x82db, 0x8304,
  0x8377, 0x83ef, 0x83d3, 0x8766, 0x8ab2, 0x5629, 0x8ca8, 0x8fe6,
  0x904e, 0x971e, 0x868a, 0x4fc4, 0x5ce8, 0x6211, 0x7259, 0x753b,
  0x81e5, 0x82bd, 0x86fe, 0x8cc0, 0x96c5, 0x9913, 0x99d5, 0x4ecb,
  0x4f1a, 0x89e3, 0x56de, 0x584a, 0x58ca, 0x5efb, 0x5feb, 0x602a,
  0x6094, 0x6062, 0x61d0, 0x6212, 0x62d0, 0x6539, 0x9b41, 0x6666,
  0x68b0, 0x6d77, 0x7070, 0x754c, 0x7686, 0x7d75, 0x82a5, 0x87f9,
  0x958b, 0x968e, 0x8c9d, 0x51f1, 0x52be, 0x5916, 0x54b3, 0x5bb3,
  0x5d16, 0x6168, 0x6982, 0x6daf, 0x788d, 0x84cb, 0x8857, 0x8a72,
  0x93a7, 0x9ab8, 0x6d6c, 0x99a8, 0x86d9, 0x57a3, 0x67ff, 0x86ce,
  0x920e, 0x5283, 0x5687, 0x5404, 0x5ed3, 0x62e1, 0x64b9, 0x683c,
  0x6838, 0x6bbb, 0x7372, 0x78ba, 0x7a6b, 0x899a, 0x89d2, 0x8d6b,
  0x8f03, 0x90ed, 0x95a3, 0x9694, 0x9769, 0x5b66, 0x5cb3, 0x697d,
  0x984d, 0x984e, 0x639b, 0x7b20, 0x6a2b, 0x0000, 0x6a7f, 0x68b6,
  0x9c0d, 0x6f5f, 0x5272, 0x559d, 0x6070, 0x62ec, 0x6d3b, 0x6e07,
  0x6ed1, 0x845b, 0x8910, 0x8f44, 0x4e14, 0x9c39, 0x53f6, 0x691b,
  0x6a3a, 0x9784, 0x682a, 0x515c, 0x7ac3, 0x84b2, 0x91dc, 0x938c,
  0x565b, 0x9d28, 0x6822, 0x8305, 0x8431, 0x7ca5, 0x5208, 0x82c5,
  0x74e6, 0x4e7e, 0x4f83, 0x51a0, 0x5bd2, 0x520a, 0x52d8, 0x52e7,
  0x5dfb, 0x559a, 0x582a, 0x59e6, 0x5b8c, 0x5b98, 0x5bdb, 0x5e72,
  0x5e79, 0x60a3, 0x611f, 0x6163, 0x61be, 0x63db, 0x6562, 0x67d1,
  0x6853, 0x68fa, 0x6b3e, 0x6b53, 0x6c57, 0x6f22, 0x6f97, 0x6f45,
  0x74b0, 0x7518, 0x76e3, 0x770b, 0x7aff, 0x7ba1, 0x7c21, 0x7de9,
  0x7f36, 0x7ff0, 0x809d, 0x8266, 0x839e, 0x89b3, 0x8acc, 0x8cab,
  0x9084, 0x9451, 0x9593, 0x9591, 0x95a2, 0x9665, 0x97d3, 0x9928,
  0x8218, 0x4e38, 0x542b, 0x5cb8, 0x5dcc, 0x73a9, 0x764c, 0x773c,
  0x5ca9, 0x7feb, 0x8d0b, 0x96c1, 0x9811, 0x9854, 0x9858, 0x4f01,
  0x4f0e, 0x5371, 0x559c, 0x5668, 0x57fa, 0x5947, 0x5b09, 0x5bc4,
  0x5c90, 0x5e0c, 0x5e7e, 0x5fcc, 0x63ee, 0x673a, 0x65d7, 0x65e2,
  0x671f, 0x68cb, 0x68c4, 0x6a5f, 0x5e30, 0x6bc5, 0x6c17, 0x6c7d,
  0x757f, 0x7948, 0x5b63, 0x7a00, 0x7d00, 0x5fbd, 0x898f, 0x8a18,
  0x8cb4, 0x8d77, 0x8ecc, 0x8f1d, 0x98e2, 0x9a0e, 0x9b3c, 0x4e80,
  0x507d, 0x5100, 0x5993, 0x5b9c, 0x622f, 0x6280, 0x64ec, 0x6b3a,
  0x72a0, 0x7591, 0x7947, 0x7fa9, 0x87fb, 0x8abc, 0x8b70, 0x63ac,
  0x83ca, 0x97a0, 0x5409, 0x5403, 0x55ab, 0x6854, 0x6a58, 0x8a70,
  0x7827, 0x6775, 0x9ecd, 0x5374, 0x5ba2, 0x811a, 0x8650, 0x9006,
  0x4e18, 0x4e45, 0x4ec7, 0x4f11, 0x53ca, 0x5438, 0x5bae, 0x5f13,
  0x6025, 0x6551, 0x0000, 0x673d, 0x6c42, 0x6c72, 0x6ce3, 0x7078,
  0x7403, 0x7a76, 0x7aae, 0x7b08, 0x7d1a, 0x7cfe, 0x7d66, 0x65e7,
  0x725b, 0x53bb, 0x5c45, 0x5de8, 0x62d2, 0x62e0, 0x6319, 0x6e20,
  0x865a, 0x8a31, 0x8ddd, 0x92f8, 0x6f01, 0x79a6, 0x9b5a, 0x4ea8,
  0x4eab, 0x4eac, 0x4f9b, 0x4fa0, 0x50d1, 0x5147, 0x7af6, 0x5171,
  0x51f6, 0x5354, 0x5321, 0x537f, 0x53eb, 0x55ac, 0x5883, 0x5ce1,
  0x5f37, 0x5f4a, 0x602f, 0x6050, 0x606d, 0x631f, 0x6559, 0x6a4b,
  0x6cc1, 0x72c2, 0x72ed, 0x77ef, 0x80f8, 0x8105, 0x8208, 0x854e,
  0x90f7, 0x93e1, 0x97ff, 0x9957, 0x9a5a, 0x4ef0, 0x51dd, 0x5c2d,
  0x6681, 0x696d, 0x5c40, 0x66f2, 0x6975, 0x7389, 0x6850, 0x7c81,
  0x50c5, 0x52e4, 0x5747, 0x5dfe, 0x9326, 0x65a4, 0x6b23, 0x6b3d,
  0x7434, 0x7981, 0x79bd, 0x7b4b, 0x7dca, 0x82b9, 0x83cc, 0x887f,
  0x895f, 0x8b39, 0x8fd1, 0x91d1, 0x541f, 0x9280, 0x4e5d, 0x5036,
  0x53e5, 0x533a, 0x72d7, 0x7396, 0x77e9, 0x82e6, 0x8eaf, 0x99c6,
  0x99c8, 0x99d2, 0x5177, 0x611a, 0x865e, 0x55b0, 0x7a7a, 0x5076,
  0x5bd3, 0x9047, 0x9685, 0x4e32, 0x6adb, 0x91e7, 0x5c51, 0x5c48,
  0x6398, 0x7a9f, 0x6c93, 0x9774, 0x8f61, 0x7aaa, 0x718a, 0x9688,
  0x7c82, 0x6817, 0x7e70, 0x6851, 0x936c, 0x52f2, 0x541b, 0x85ab,
  0x8a13, 0x7fa4, 0x8ecd, 0x90e1, 0x5366, 0x8888, 0x7941, 0x4fc2,
  0x50be, 0x5211, 0x5144, 0x5553, 0x572d, 0x73ea, 0x578b, 0x5951,
  0x5f62, 0x5f84, 0x6075, 0x6176, 0x6167, 0x61a9, 0x63b2, 0x643a,
  0x656c, 0x666f, 0x6842, 0x6e13, 0x7566, 0x7a3d, 0x7cfb, 0x7d4c,
  0x7d99, 0x7e4b, 0x7f6b, 0x830e, 0x834a, 0x86cd, 0x8a08, 0x8a63,
  0x8b66, 0x8efd, 0x981a, 0x9d8f, 0x82b8, 0x8fce, 0x9be8, 0x0000,
  0x5287, 0x621f, 0x6483, 0x6fc0, 0x9699, 0x6841, 0x5091, 0x6b20,
  0x6c7a, 0x6f54, 0x7a74, 0x7d50, 0x8840, 0x8a23, 0x6708, 0x4ef6,
  0x5039, 0x5026, 0x5065, 0x517c, 0x5238, 0x5263, 0x55a7, 0x570f,
  0x5805, 0x5acc, 0x5efa, 0x61b2, 0x61f8, 0x62f3, 0x6372, 0x691c,
  0x6a29, 0x727d, 0x72ac, 0x732e, 0x7814, 0x786f, 0x7d79, 0x770c,
  0x80a9, 0x898b, 0x8b19, 0x8ce2, 0x8ed2, 0x9063, 0x9375, 0x967a,
  0x9855, 0x9a13, 0x9e78, 0x5143, 0x539f, 0x53b3, 0x5e7b, 0x5f26,
  0x6e1b, 0x6e90, 0x7384, 0x73fe, 0x7d43, 0x8237, 0x8a00, 0x8afa,
  0x9650, 0x4e4e, 0x500b, 0x53e4, 0x547c, 0x56fa, 0x59d1, 0x5b64,
  0x5df1, 0x5eab, 0x5f27, 0x6238, 0x6545, 0x67af, 0x6e56, 0x72d0,
  0x7cca, 0x88b4, 0x80a1, 0x80e1, 0x83f0, 0x864e, 0x8a87, 0x8de8,
  0x9237, 0x96c7, 0x9867, 0x9f13, 0x4e94, 0x4e92, 0x4f0d, 0x5348,
  0x5449, 0x543e, 0x5a2f, 0x5f8c, 0x5fa1, 0x609f, 0x68a7, 0x6a8e,
  0x745a, 0x7881, 0x8a9e, 0x8aa4, 0x8b77, 0x9190, 0x4e5e, 0x9bc9,
  0x4ea4, 0x4f7c, 0x4faf, 0x5019, 0x5016, 0x5149, 0x516c, 0x529f,
  0x52b9, 0x52fe, 0x539a, 0x53e3, 0x5411, 0x540e, 0x5589, 0x5751,
  0x57a2, 0x597d, 0x5b54, 0x5b5d, 0x5b8f, 0x5de5, 0x5de7, 0x5df7,
  0x5e78, 0x5e83, 0x5e9a, 0x5eb7, 0x5f18, 0x6052, 0x614c, 0x6297,
  0x62d8, 0x63a7, 0x653b, 0x6602, 0x6643, 0x66f4, 0x676d, 0x6821,
  0x6897, 0x69cb, 0x6c5f, 0x6d2a, 0x6d69, 0x6e2f, 0x6e9d, 0x7532,
  0x7687, 0x786c, 0x7a3f, 0x7ce0, 0x7d05, 0x7d18, 0x7d5e, 0x7db1,
  0x8015, 0x8003, 0x80af, 0x80b1, 0x8154, 0x818f, 0x822a, 0x8352,
  0x884c, 0x8861, 0x8b1b, 0x8ca2, 0x8cfc, 0x90ca, 0x9175, 0x9271,
  0x783f, 0x92fc, 0x95a4, 0x964d, 0x0000, 0x9805, 0x9999, 0x9ad8,
  0x9d3b, 0x525b, 0x52ab, 0x53f7, 0x5408, 0x58d5, 0x62f7, 0x6fe0,
  0x8c6a, 0x8f5f, 0x9eb9, 0x514b, 0x523b, 0x544a, 0x56fd, 0x7a40,
  0x9177, 0x9d60, 0x9ed2, 0x7344, 0x6f09, 0x8170, 0x7511, 0x5ffd,
  0x60da, 0x9aa8, 0x72db, 0x8fbc, 0x6b64, 0x9803, 0x4eca, 0x56f0,
  0x5764, 0x58be, 0x5a5a, 0x6068, 0x61c7, 0x660f, 0x6606, 0x6839,
  0x68b1, 0x6df7, 0x75d5, 0x7d3a, 0x826e, 0x9b42, 0x4e9b, 0x4f50,
  0x53c9, 0x5506, 0x5d6f, 0x5de6, 0x5dee, 0x67fb, 0x6c99, 0x7473,
  0x7802, 0x8a50, 0x9396, 0x88df, 0x5750, 0x5ea7, 0x632b, 0x50b5,
  0x50ac, 0x518d, 0x6700, 0x54c9, 0x585e, 0x59bb, 0x5bb0, 0x5f69,
  0x624d, 0x63a1, 0x683d, 0x6b73, 0x6e08, 0x707d, 0x91c7, 0x7280,
  0x7815, 0x7826, 0x796d, 0x658e, 0x7d30, 0x83dc, 0x88c1, 0x8f09,
  0x969b, 0x5264, 0x5728, 0x6750, 0x7f6a, 0x8ca1, 0x51b4, 0x5742,
  0x962a, 0x583a, 0x698a, 0x80b4, 0x54b2, 0x5d0e, 0x57fc, 0x7895,
  0x9dfa, 0x4f5c, 0x524a, 0x548b, 0x643e, 0x6628, 0x6714, 0x67f5,
  0x7a84, 0x7b56, 0x7d22, 0x932f, 0x685c, 0x9bad, 0x7b39, 0x5319,
  0x518a, 0x5237, 0x5bdf, 0x62f6, 0x64ae, 0x64e6, 0x672d, 0x6bba,
  0x85a9, 0x96d1, 0x7690, 0x9bd6, 0x634c, 0x9306, 0x9bab, 0x76bf,
  0x6652, 0x4e09, 0x5098, 0x53c2, 0x5c71, 0x60e8, 0x6492, 0x6563,
  0x685f, 0x71e6, 0x73ca, 0x7523, 0x7b97, 0x7e82, 0x8695, 0x8b83,
  0x8cdb, 0x9178, 0x9910, 0x65ac, 0x66ab, 0x6b8b, 0x4ed5, 0x4ed4,
  0x4f3a, 0x4f7f, 0x523a, 0x53f8, 0x53f2, 0x55e3, 0x56db, 0x58eb,
  0x59cb, 0x59c9, 0x59ff, 0x5b50, 0x5c4d, 0x5e02, 0x5e2b, 0x5fd7,
  0x601d, 0x6307, 0x652f, 0x5b5c, 0x65af, 0x65bd, 0x65e8, 0x679d,
  0x6b62, 0x0000, 0x6b7b, 0x6c0f, 0x7345, 0x7949, 0x79c1, 0x7cf8,
  0x7d19, 0x7d2b, 0x80a2, 0x8102, 0x81f3, 0x8996, 0x8a5e, 0x8a69,
  0x8a66, 0x8a8c, 0x8aee, 0x8cc7, 0x8cdc, 0x96cc, 0x98fc, 0x6b6f,
  0x4e8b, 0x4f3c, 0x4f8d, 0x5150, 0x5b57, 0x5bfa, 0x6148, 0x6301,
  0x6642, 0x6b21, 0x6ecb, 0x6cbb, 0x723e, 0x74bd, 0x75d4, 0x78c1,
  0x793a, 0x800c, 0x8033, 0x81ea, 0x8494, 0x8f9e, 0x6c50, 0x9e7f,
  0x5f0f, 0x8b58, 0x9d2b, 0x7afa, 0x8ef8, 0x5b8d, 0x96eb, 0x4e03,
  0x53f1, 0x57f7, 0x5931, 0x5ac9, 0x5ba4, 0x6089, 0x6e7f, 0x6f06,
  0x75be, 0x8cea, 0x5b9f, 0x8500, 0x7be0, 0x5072, 0x67f4, 0x829d,
  0x5c61, 0x854a, 0x7e1e, 0x820e, 0x5199, 0x5c04, 0x6368, 0x8d66,
  0x659c, 0x716e, 0x793e, 0x7d17, 0x8005, 0x8b1d, 0x8eca, 0x906e,
  0x86c7, 0x90aa, 0x501f, 0x52fa, 0x5c3a, 0x6753, 0x707c, 0x7235,
  0x914c, 0x91c8, 0x932b, 0x82e5, 0x5bc2, 0x5f31, 0x60f9, 0x4e3b,
  0x53d6, 0x5b88, 0x624b, 0x6731, 0x6b8a, 0x72e9, 0x73e0, 0x7a2e,
  0x816b, 0x8da3, 0x9152, 0x9996, 0x5112, 0x53d7, 0x546a, 0x5bff,
  0x6388, 0x6a39, 0x7dac, 0x9700, 0x56da, 0x53ce, 0x5468, 0x5b97,
  0x5c31, 0x5dde, 0x4fee, 0x6101, 0x62fe, 0x6d32, 0x79c0, 0x79cb,
  0x7d42, 0x7e4d, 0x7fd2, 0x81ed, 0x821f, 0x8490, 0x8846, 0x8972,
  0x8b90, 0x8e74, 0x8f2f, 0x9031, 0x914b, 0x916c, 0x96c6, 0x919c,
  0x4ec0, 0x4f4f, 0x5145, 0x5341, 0x5f93, 0x620e, 0x67d4, 0x6c41,
  0x6e0b, 0x7363, 0x7e26, 0x91cd, 0x9283, 0x53d4, 0x5919, 0x5bbf,
  0x6dd1, 0x795d, 0x7e2e, 0x7c9b, 0x587e, 0x719f, 0x51fa, 0x8853,
  0x8ff0, 0x4fca, 0x5cfb, 0x6625, 0x77ac, 0x7ae3, 0x821c, 0x99ff,
  0x51c6, 0x5faa, 0x65ec, 0x696f, 0x6b89, 0x6df3, 0x0000, 0x6e96,
  0x6f64, 0x76fe, 0x7d14, 0x5de1, 0x9075, 0x9187, 0x9806, 0x51e6,
  0x521d, 0x6240, 0x6691, 0x66d9, 0x6e1a, 0x5eb6, 0x7dd2, 0x7f72,
  0x66f8, 0x85af, 0x85f7, 0x8af8, 0x52a9, 0x53d9, 0x5973, 0x5e8f,
  0x5f90, 0x6055, 0x92e4, 0x9664, 0x50b7, 0x511f, 0x52dd, 0x5320,
  0x5347, 0x53ec, 0x54e8, 0x5546, 0x5531, 0x5617, 0x5968, 0x59be,
  0x5a3c, 0x5bb5, 0x5c06, 0x5c0f, 0x5c11, 0x5c1a, 0x5e84, 0x5e8a,
  0x5ee0, 0x5f70, 0x627f, 0x6284, 0x62db, 0x638c, 0x6377, 0x6607,
  0x660c, 0x662d, 0x6676, 0x677e, 0x68a2, 0x6a1f, 0x6a35, 0x6cbc,
  0x6d88, 0x6e09, 0x6e58, 0x713c, 0x7126, 0x7167, 0x75c7, 0x7701,
  0x785d, 0x7901, 0x7965, 0x79f0, 0x7ae0, 0x7b11, 0x7ca7, 0x7d39,
  0x8096, 0x83d6, 0x848b, 0x8549, 0x885d, 0x88f3, 0x8a1f, 0x8a3c,
  0x8a54, 0x8a73, 0x8c61, 0x8cde, 0x91a4, 0x9266, 0x937e, 0x9418,
  0x969c, 0x9798, 0x4e0a, 0x4e08, 0x4e1e, 0x4e57, 0x5197, 0x5270,
  0x57ce, 0x5834, 0x58cc, 0x5b22, 0x5e38, 0x60c5, 0x64fe, 0x6761,
  0x6756, 0x6d44, 0x72b6, 0x7573, 0x7a63, 0x84b8, 0x8b72, 0x91b8,
  0x9320, 0x5631, 0x57f4, 0x98fe, 0x62ed, 0x690d, 0x6b96, 0x71ed,
  0x7e54, 0x8077, 0x8272, 0x89e6, 0x98df, 0x8755, 0x8fb1, 0x5c3b,
  0x4f38, 0x4fe1, 0x4fb5, 0x5507, 0x5a20, 0x5bdd, 0x5be9, 0x5fc3,
  0x614e, 0x632f, 0x65b0, 0x664b, 0x68ee, 0x699b, 0x6d78, 0x6df1,
  0x7533, 0x75b9, 0x771f, 0x795e, 0x79e6, 0x7d33, 0x81e3, 0x82af,
  0x85aa, 0x89aa, 0x8a3a, 0x8eab, 0x8f9b, 0x9032, 0x91dd, 0x9707,
  0x4eba, 0x4ec1, 0x5203, 0x5875, 0x58ec, 0x5c0b, 0x751a, 0x5c3d,
  0x814e, 0x8a0a, 0x8fc5, 0x9663, 0x976d, 0x7b25, 0x8acf, 0x9808,
  0x9162, 0x56f3, 0x53a8, 0x0000, 0x9017, 0x5439, 0x5782, 0x5e25,
  0x63a8, 0x6c34, 0x708a, 0x7761, 0x7c8b, 0x7fe0, 0x8870, 0x9042,
  0x9154, 0x9310, 0x9318, 0x968f, 0x745e, 0x9ac4, 0x5d07, 0x5d69,
  0x6570, 0x67a2, 0x8da8, 0x96db, 0x636e, 0x6749, 0x6919, 0x83c5,
  0x9817, 0x96c0, 0x88fe, 0x6f84, 0x647a, 0x5bf8, 0x4e16, 0x702c,
  0x755d, 0x662f, 0x51c4, 0x5236, 0x52e2, 0x59d3, 0x5f81, 0x6027,
  0x6210, 0x653f, 0x6574, 0x661f, 0x6674, 0x68f2, 0x6816, 0x6b63,
  0x6e05, 0x7272, 0x751f, 0x76db, 0x7cbe, 0x8056, 0x58f0, 0x88fd,
  0x897f, 0x8aa0, 0x8a93, 0x8acb, 0x901d, 0x9192, 0x9752, 0x9759,
  0x6589, 0x7a0e, 0x8106, 0x96bb, 0x5e2d, 0x60dc, 0x621a, 0x65a5,
  0x6614, 0x6790, 0x77f3, 0x7a4d, 0x7c4d, 0x7e3e, 0x810a, 0x8cac,
  0x8d64, 0x8de1, 0x8e5f, 0x78a9, 0x5207, 0x62d9, 0x63a5, 0x6442,
  0x6298, 0x8a2d, 0x7a83, 0x7bc0, 0x8aac, 0x96ea, 0x7d76, 0x820c,
  0x8749, 0x4ed9, 0x5148, 0x5343, 0x5360, 0x5ba3, 0x5c02, 0x5c16,
  0x5ddd, 0x6226, 0x6247, 0x64b0, 0x6813, 0x6834, 0x6cc9, 0x6d45,
  0x6d17, 0x67d3, 0x6f5c, 0x714e, 0x717d, 0x65cb, 0x7a7f, 0x7bad,
  0x7dda, 0x7e4a, 0x7fa8, 0x817a, 0x821b, 0x8239, 0x85a6, 0x8a6e,
  0x8cce, 0x8df5, 0x9078, 0x9077, 0x92ad, 0x9291, 0x9583, 0x9bae,
  0x524d, 0x5584, 0x6f38, 0x7136, 0x5168, 0x7985, 0x7e55, 0x81b3,
  0x7cce, 0x564c, 0x5851, 0x5ca8, 0x63aa, 0x66fe, 0x66fd, 0x695a,
  0x72d9, 0x758f, 0x758e, 0x790e, 0x7956, 0x79df, 0x7c97, 0x7d20,
  0x7d44, 0x8607, 0x8a34, 0x963b, 0x9061, 0x9f20, 0x50e7, 0x5275,
  0x53cc, 0x53e2, 0x5009, 0x55aa, 0x58ee, 0x594f, 0x723d, 0x5b8b,
  0x5c64, 0x531d, 0x60e3, 0x60f3, 0x635c, 0x6383, 0x633f, 0x63bb,
  0x0000, 0x64cd, 0x65e9, 0x66f9, 0x5de3, 0x69cd, 0x69fd, 0x6f15,
  0x71e5, 0x4e89, 0x75e9, 0x76f8, 0x7a93, 0x7cdf, 0x7dcf, 0x7d9c,
  0x8061, 0x8349, 0x8358, 0x846c, 0x84bc, 0x85fb, 0x88c5, 0x8d70,
  0x9001, 0x906d, 0x9397, 0x971c, 0x9a12, 0x50cf, 0x5897, 0x618e,
  0x81d3, 0x8535, 0x8d08, 0x9020, 0x4fc3, 0x5074, 0x5247, 0x5373,
  0x606f, 0x6349, 0x675f, 0x6e2c, 0x8db3, 0x901f, 0x4fd7, 0x5c5e,
  0x8cca, 0x65cf, 0x7d9a, 0x5352, 0x8896, 0x5176, 0x63c3, 0x5b58,
  0x5b6b, 0x5c0a, 0x640d, 0x6751, 0x905c, 0x4ed6, 0x591a, 0x592a,
  0x6c70, 0x8a51, 0x553e, 0x5815, 0x59a5, 0x60f0, 0x6253, 0x67c1,
  0x8235, 0x6955, 0x9640, 0x99c4, 0x9a28, 0x4f53, 0x5806, 0x5bfe,
  0x8010, 0x5cb1, 0x5e2f, 0x5f85, 0x6020, 0x614b, 0x6234, 0x66ff,
  0x6cf0, 0x6ede, 0x80ce, 0x817f, 0x82d4, 0x888b, 0x8cb8, 0x9000,
  0x902e, 0x968a, 0x9edb, 0x9bdb, 0x4ee3, 0x53f0, 0x5927, 0x7b2c,
  0x918d, 0x984c, 0x9df9, 0x6edd, 0x7027, 0x5353, 0x5544, 0x5b85,
  0x6258, 0x629e, 0x62d3, 0x6ca2, 0x6fef, 0x7422, 0x8a17, 0x9438,
  0x6fc1, 0x8afe, 0x8338, 0x51e7, 0x86f8, 0x53ea, 0x53e9, 0x4f46,
  0x9054, 0x8fb0, 0x596a, 0x8131, 0x5dfd, 0x7aea, 0x8fbf, 0x68da,
  0x8c37, 0x72f8, 0x9c48, 0x6a3d, 0x8ab0, 0x4e39, 0x5358, 0x5606,
  0x5766, 0x62c5, 0x63a2, 0x65e6, 0x6b4e, 0x6de1, 0x6e5b, 0x70ad,
  0x77ed, 0x7aef, 0x7baa, 0x7dbb, 0x803d, 0x80c6, 0x86cb, 0x8a95,
  0x935b, 0x56e3, 0x58c7, 0x5f3e, 0x65ad, 0x6696, 0x6a80, 0x6bb5,
  0x7537, 0x8ac7, 0x5024, 0x77e5, 0x5730, 0x5f1b, 0x6065, 0x667a,
  0x6c60, 0x75f4, 0x7a1a, 0x7f6e, 0x81f4, 0x8718, 0x9045, 0x99b3,
  0x7bc9, 0x755c, 0x7af9, 0x7b51, 0x84c4, 0x0000, 0x9010, 0x79e9,
  0x7a92, 0x8336, 0x5ae1, 0x7740, 0x4e2d, 0x4ef2, 0x5b99, 0x5fe0,
  0x62bd, 0x663c, 0x67f1, 0x6ce8, 0x866b, 0x8877, 0x8a3b, 0x914e,
  0x92f3, 0x99d0, 0x6a17, 0x7026, 0x732a, 0x82e7, 0x8457, 0x8caf,
  0x4e01, 0x5146, 0x51cb, 0x558b, 0x5bf5, 0x5e16, 0x5e33, 0x5e81,
  0x5f14, 0x5f35, 0x5f6b, 0x5fb4, 0x61f2, 0x6311, 0x66a2, 0x671d,
  0x6f6e, 0x7252, 0x753a, 0x773a, 0x8074, 0x8139, 0x8178, 0x8776,
  0x8abf, 0x8adc, 0x8d85, 0x8df3, 0x929a, 0x9577, 0x9802, 0x9ce5,
  0x52c5, 0x6357, 0x76f4, 0x6715, 0x6c88, 0x73cd, 0x8cc3, 0x93ae,
  0x9673, 0x6d25, 0x589c, 0x690e, 0x69cc, 0x8ffd, 0x939a, 0x75db,
  0x901a, 0x585a, 0x6802, 0x63b4, 0x69fb, 0x4f43, 0x6f2c, 0x67d8,
  0x8fbb, 0x8526, 0x7db4, 0x9354, 0x693f, 0x6f70, 0x576a, 0x58f7,
  0x5b2c, 0x7d2c, 0x722a, 0x540a, 0x91e3, 0x9db4, 0x4ead, 0x4f4e,
  0x505c, 0x5075, 0x5243, 0x8c9e, 0x5448, 0x5824, 0x5b9a, 0x5e1d,
  0x5e95, 0x5ead, 0x5ef7, 0x5f1f, 0x608c, 0x62b5, 0x633a, 0x63d0,
  0x68af, 0x6c40, 0x7887, 0x798e, 0x7a0b, 0x7de0, 0x8247, 0x8a02,
  0x8ae6, 0x8e44, 0x9013, 0x90b8, 0x912d, 0x91d8, 0x9f0e, 0x6ce5,
  0x6458, 0x64e2, 0x6575, 0x6ef4, 0x7684, 0x7b1b, 0x9069, 0x93d1,
  0x6eba, 0x54f2, 0x5fb9, 0x64a4, 0x8f4d, 0x8fed, 0x9244, 0x5178,
  0x586b, 0x5929, 0x5c55, 0x5e97, 0x6dfb, 0x7e8f, 0x751c, 0x8cbc,
  0x8ee2, 0x985b, 0x70b9, 0x4f1d, 0x6bbf, 0x6fb1, 0x7530, 0x96fb,
  0x514e, 0x5410, 0x5835, 0x5857, 0x59ac, 0x5c60, 0x5f92, 0x6597,
  0x675c, 0x6e21, 0x767b, 0x83df, 0x8ced, 0x9014, 0x90fd, 0x934d,
  0x7825, 0x783a, 0x52aa, 0x5ea6, 0x571f, 0x5974, 0x6012, 0x5012,
  0x515a, 0x51ac, 0x0000, 0x51cd, 0x5200, 0x5510, 0x5854, 0x5858,
  0x5957, 0x5b95, 0x5cf6, 0x5d8b, 0x60bc, 0x6295, 0x642d, 0x6771,
  0x6843, 0x68bc, 0x68df, 0x76d7, 0x6dd8, 0x6e6f, 0x6d9b, 0x706f,
  0x71c8, 0x5f53, 0x75d8, 0x7977, 0x7b49, 0x7b54, 0x7b52, 0x7cd6,
  0x7d71, 0x5230, 0x8463, 0x8569, 0x85e4, 0x8a0e, 0x8b04, 0x8c46,
  0x8e0f, 0x9003, 0x900f, 0x9419, 0x9676, 0x982d, 0x9a30, 0x95d8,
  0x50cd, 0x52d5, 0x540c, 0x5802, 0x5c0e, 0x61a7, 0x649e, 0x6d1e,
  0x77b3, 0x7ae5, 0x80f4, 0x8404, 0x9053, 0x9285, 0x5ce0, 0x9d07,
  0x533f, 0x5f97, 0x5fb3, 0x6d9c, 0x7279, 0x7763, 0x79bf, 0x7be4,
  0x6bd2, 0x72ec, 0x8aad, 0x6803, 0x6a61, 0x51f8, 0x7a81, 0x6934,
  0x5c4a, 0x9cf6, 0x82eb, 0x5bc5, 0x9149, 0x701e, 0x5678, 0x5c6f,
  0x60c7, 0x6566, 0x6c8c, 0x8c5a, 0x9041, 0x9813, 0x5451, 0x66c7,
  0x920d, 0x5948, 0x90a3, 0x5185, 0x4e4d, 0x51ea, 0x8599, 0x8b0e,
  0x7058, 0x637a, 0x934b, 0x6962, 0x99b4, 0x7e04, 0x7577, 0x5357,
  0x6960, 0x8edf, 0x96e3, 0x6c5d, 0x4e8c, 0x5c3c, 0x5f10, 0x8fe9,
  0x5302, 0x8cd1, 0x8089, 0x8679, 0x5eff, 0x65e5, 0x4e73, 0x5165,
  0x5982, 0x5c3f, 0x97ee, 0x4efb, 0x598a, 0x5fcd, 0x8a8d, 0x6fe1,
  0x79b0, 0x7962, 0x5be7, 0x8471, 0x732b, 0x71b1, 0x5e74, 0x5ff5,
  0x637b, 0x649a, 0x71c3, 0x7c98, 0x4e43, 0x5efc, 0x4e4b, 0x57dc,
  0x56a2, 0x60a9, 0x6fc3, 0x7d0d, 0x80fd, 0x8133, 0x81bf, 0x8fb2,
  0x8997, 0x86a4, 0x5df4, 0x628a, 0x64ad, 0x8987, 0x6777, 0x6ce2,
  0x6d3e, 0x7436, 0x7834, 0x5a46, 0x7f75, 0x82ad, 0x99ac, 0x4ff3,
  0x5ec3, 0x62dd, 0x6392, 0x6557, 0x676f, 0x76c3, 0x724c, 0x80cc,
  0x80ba, 0x8f29, 0x914d, 0x500d, 0x57f9, 0x5a92, 0x6885, 0x0000,
  0x6973, 0x7164, 0x72fd, 0x8cb7, 0x58f2, 0x8ce0, 0x966a, 0x9019,
  0x877f, 0x79e4, 0x77e7, 0x8429, 0x4f2f, 0x5265, 0x535a, 0x62cd,
  0x67cf, 0x6cca, 0x767d, 0x7b94, 0x7c95, 0x8236, 0x8584, 0x8feb,
  0x66dd, 0x6f20, 0x7206, 0x7e1b, 0x83ab, 0x99c1, 0x9ea6, 0x51fd,
  0x7bb1, 0x7872, 0x7bb8, 0x8087, 0x7b48, 0x6ae8, 0x5e61, 0x808c,
  0x7551, 0x7560, 0x516b, 0x9262, 0x6e8c, 0x767a, 0x9197, 0x9aea,
  0x4f10, 0x7f70, 0x629c, 0x7b4f, 0x95a5, 0x9ce9, 0x567a, 0x5859,
  0x86e4, 0x96bc, 0x4f34, 0x5224, 0x534a, 0x53cd, 0x53db, 0x5e06,
  0x642c, 0x6591, 0x677f, 0x6c3e, 0x6c4e, 0x7248, 0x72af, 0x73ed,
  0x7554, 0x7e41, 0x822c, 0x85e9, 0x8ca9, 0x7bc4, 0x91c6, 0x7169,
  0x9812, 0x98ef, 0x633d, 0x6669, 0x756a, 0x76e4, 0x78d0, 0x8543,
  0x86ee, 0x532a, 0x5351, 0x5426, 0x5983, 0x5e87, 0x5f7c, 0x60b2,
  0x6249, 0x6279, 0x62ab, 0x6590, 0x6bd4, 0x6ccc, 0x75b2, 0x76ae,
  0x7891, 0x79d8, 0x7dcb, 0x7f77, 0x80a5, 0x88ab, 0x8ab9, 0x8cbb,
  0x907f, 0x975e, 0x98db, 0x6a0b, 0x7c38, 0x5099, 0x5c3e, 0x5fae,
  0x6787, 0x6bd8, 0x7435, 0x7709, 0x7f8e, 0x9f3b, 0x67ca, 0x7a17,
  0x5339, 0x758b, 0x9aed, 0x5f66, 0x819d, 0x83f1, 0x8098, 0x5f3c,
  0x5fc5, 0x7562, 0x7b46, 0x903c, 0x6867, 0x59eb, 0x5a9b, 0x7d10,
  0x767e, 0x8b2c, 0x4ff5, 0x5f6a, 0x6a19, 0x6c37, 0x6f02, 0x74e2,
  0x7968, 0x8868, 0x8a55, 0x8c79, 0x5edf, 0x63cf, 0x75c5, 0x79d2,
  0x82d7, 0x9328, 0x92f2, 0x849c, 0x86ed, 0x9c2d, 0x54c1, 0x5f6c,
  0x658c, 0x6d5c, 0x7015, 0x8ca7, 0x8cd3, 0x983b, 0x654f, 0x74f6,
  0x4e0d, 0x4ed8, 0x57e0, 0x592b, 0x5a66, 0x5bcc, 0x51a8, 0x5e03,
  0x5e9c, 0x6016, 0x6276, 0x6577, 0x0000, 0x65a7, 0x666e, 0x6d6e,
  0x7236, 0x7b26, 0x8150, 0x819a, 0x8299, 0x8b5c, 0x8ca0, 0x8ce6,
  0x8d74, 0x961c, 0x9644, 0x4fae, 0x64ab, 0x6b66, 0x821e, 0x8461,
  0x856a, 0x90e8, 0x5c01, 0x6953, 0x98a8, 0x847a, 0x8557, 0x4f0f,
  0x526f, 0x5fa9, 0x5e45, 0x670d, 0x798f, 0x8179, 0x8907, 0x8986,
  0x6df5, 0x5f17, 0x6255, 0x6cb8, 0x4ecf, 0x7269, 0x9b92, 0x5206,
  0x543b, 0x5674, 0x58b3, 0x61a4, 0x626e, 0x711a, 0x596e, 0x7c89,
  0x7cde, 0x7d1b, 0x96f0, 0x6587, 0x805e, 0x4e19, 0x4f75, 0x5175,
  0x5840, 0x5e63, 0x5e73, 0x5f0a, 0x67c4, 0x4e26, 0x853d, 0x9589,
  0x965b, 0x7c73, 0x9801, 0x50fb, 0x58c1, 0x7656, 0x78a7, 0x5225,
  0x77a5, 0x8511, 0x7b86, 0x504f, 0x5909, 0x7247, 0x7bc7, 0x7de8,
  0x8fba, 0x8fd4, 0x904d, 0x4fbf, 0x52c9, 0x5a29, 0x5f01, 0x97ad,
  0x4fdd, 0x8217, 0x92ea, 0x5703, 0x6355, 0x6b69, 0x752b, 0x88dc,
  0x8f14, 0x7a42, 0x52df, 0x5893, 0x6155, 0x620a, 0x66ae, 0x6bcd,
  0x7c3f, 0x83e9, 0x5023, 0x4ff8, 0x5305, 0x5446, 0x5831, 0x5949,
  0x5b9d, 0x5cf0, 0x5cef, 0x5d29, 0x5e96, 0x62b1, 0x6367, 0x653e,
  0x65b9, 0x670b, 0x6cd5, 0x6ce1, 0x70f9, 0x7832, 0x7e2b, 0x80de,
  0x82b3, 0x840c, 0x84ec, 0x8702, 0x8912, 0x8a2a, 0x8c4a, 0x90a6,
  0x92d2, 0x98fd, 0x9cf3, 0x9d6c, 0x4e4f, 0x4ea1, 0x508d, 0x5256,
  0x574a, 0x59a8, 0x5e3d, 0x5fd8, 0x5fd9, 0x623f, 0x66b4, 0x671b,
  0x67d0, 0x68d2, 0x5192, 0x7d21, 0x80aa, 0x81a8, 0x8b00, 0x8c8c,
  0x8cbf, 0x927e, 0x9632, 0x5420, 0x982c, 0x5317, 0x50d5, 0x535c,
  0x58a8, 0x64b2, 0x6734, 0x7267, 0x7766, 0x7a46, 0x91e6, 0x52c3,
  0x6ca1, 0x6b86, 0x5800, 0x5e4c, 0x5954, 0x672c, 0x7ffb, 0x51e1,
  0x76c6, 0x0000, 0x6469, 0x78e8, 0x9b54, 0x9ebb, 0x57cb, 0x59b9,
  0x6627, 0x679a, 0x6bce, 0x54e9, 0x69d9, 0x5e55, 0x819c, 0x6795,
  0x9baa, 0x67fe, 0x9c52, 0x685d, 0x4ea6, 0x4fe3, 0x53c8, 0x62b9,
  0x672b, 0x6cab, 0x8fc4, 0x4fad, 0x7e6d, 0x9ebf, 0x4e07, 0x6162,
  0x6e80, 0x6f2b, 0x8513, 0x5473, 0x672a, 0x9b45, 0x5df3, 0x7b95,
  0x5cac, 0x5bc6, 0x871c, 0x6e4a, 0x84d1, 0x7a14, 0x8108, 0x5999,
  0x7c8d, 0x6c11, 0x7720, 0x52d9, 0x5922, 0x7121, 0x725f, 0x77db,
  0x9727, 0x9d61, 0x690b, 0x5a7f, 0x5a18, 0x51a5, 0x540d, 0x547d,
  0x660e, 0x76df, 0x8ff7, 0x9298, 0x9cf4, 0x59ea, 0x725d, 0x6ec5,
  0x514d, 0x68c9, 0x7dbf, 0x7dec, 0x9762, 0x9eba, 0x6478, 0x6a21,
  0x8302, 0x5984, 0x5b5f, 0x6bdb, 0x731b, 0x76f2, 0x7db2, 0x8017,
  0x8499, 0x5132, 0x6728, 0x9ed9, 0x76ee, 0x6762, 0x52ff, 0x9905,
  0x5c24, 0x623b, 0x7c7e, 0x8cb0, 0x554f, 0x60b6, 0x7d0b, 0x9580,
  0x5301, 0x4e5f, 0x51b6, 0x591c, 0x723a, 0x8036, 0x91ce, 0x5f25,
  0x77e2, 0x5384, 0x5f79, 0x7d04, 0x85ac, 0x8a33, 0x8e8d, 0x9756,
  0x67f3, 0x85ae, 0x9453, 0x6109, 0x6108, 0x6cb9, 0x7652, 0x8aed,
  0x8f38, 0x552f, 0x4f51, 0x512a, 0x52c7, 0x53cb, 0x5ba5, 0x5e7d,
  0x60a0, 0x6182, 0x63d6, 0x6709, 0x67da, 0x6e67, 0x6d8c, 0x7336,
  0x7337, 0x7531, 0x7950, 0x88d5, 0x8a98, 0x904a, 0x9091, 0x90f5,
  0x96c4, 0x878d, 0x5915, 0x4e88, 0x4f59, 0x4e0e, 0x8a89, 0x8f3f,
  0x9810, 0x50ad, 0x5e7c, 0x5996, 0x5bb9, 0x5eb8, 0x63da, 0x63fa,
  0x64c1, 0x66dc, 0x694a, 0x69d8, 0x6d0b, 0x6eb6, 0x7194, 0x7528,
  0x7aaf, 0x7f8a, 0x8000, 0x8449, 0x84c9, 0x8981, 0x8b21, 0x8e0a,
  0x9065, 0x967d, 0x990a, 0x617e, 0x6291, 0x6b32, 0x0000, 0x6c83,
  0x6d74, 0x7fcc, 0x7ffc, 0x6dc0, 0x7f85, 0x87ba, 0x88f8, 0x6765,
  0x83b1, 0x983c, 0x96f7, 0x6d1b, 0x7d61, 0x843d, 0x916a, 0x4e71,
  0x5375, 0x5d50, 0x6b04, 0x6feb, 0x85cd, 0x862d, 0x89a7, 0x5229,
  0x540f, 0x5c65, 0x674e, 0x68a8, 0x7406, 0x7483, 0x75e2, 0x88cf,
  0x88e1, 0x91cc, 0x96e2, 0x9678, 0x5f8b, 0x7387, 0x7acb, 0x844e,
  0x63a0, 0x7565, 0x5289, 0x6d41, 0x6e9c, 0x7409, 0x7559, 0x786b,
  0x7c92, 0x9686, 0x7adc, 0x9f8d, 0x4fb6, 0x616e, 0x65c5, 0x865c,
  0x4e86, 0x4eae, 0x50da, 0x4e21, 0x51cc, 0x5bee, 0x6599, 0x6881,
  0x6dbc, 0x731f, 0x7642, 0x77ad, 0x7a1c, 0x7ce7, 0x826f, 0x8ad2,
  0x907c, 0x91cf, 0x9675, 0x9818, 0x529b, 0x7dd1, 0x502b, 0x5398,
  0x6797, 0x6dcb, 0x71d0, 0x7433, 0x81e8, 0x8f2a, 0x96a3, 0x9c57,
  0x9e9f, 0x7460, 0x5841, 0x6d99, 0x7d2f, 0x985e, 0x4ee4, 0x4f36,
  0x4f8b, 0x51b7, 0x52b1, 0x5dba, 0x601c, 0x73b2, 0x793c, 0x82d3,
  0x9234, 0x96b7, 0x96f6, 0x970a, 0x9e97, 0x9f62, 0x66a6, 0x6b74,
  0x5217, 0x52a3, 0x70c8, 0x88c2, 0x5ec9, 0x604b, 0x6190, 0x6f23,
  0x7149, 0x7c3e, 0x7df4, 0x806f, 0x84ee, 0x9023, 0x932c, 0x5442,
  0x9b6f, 0x6ad3, 0x7089, 0x8cc2, 0x8def, 0x9732, 0x52b4, 0x5a41,
  0x5eca, 0x5f04, 0x6717, 0x697c, 0x6994, 0x6d6a, 0x6f0f, 0x7262,
  0x72fc, 0x7bed, 0x8001, 0x807e, 0x874b, 0x90ce, 0x516d, 0x9e93,
  0x7984, 0x808b, 0x9332, 0x8ad6, 0x502d, 0x548c, 0x8a71, 0x6b6a,
  0x8cc4, 0x8107, 0x60d1, 0x67a0, 0x9df2, 0x4e99, 0x4e98, 0x9c10,
  0x8a6b, 0x85c1, 0x8568, 0x6900, 0x6e7e, 0x7897, 0x8155, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5f0c, 0x4e10, 0x4e15, 0x4e2a, 0x4e31,
  0x4e36, 0x4e3c, 0x4e3f, 0x4e42, 0x4e56, 0x4e58, 0x4e82, 0x4e85,
  0x8c6b, 0x4e8a, 0x8212, 0x5f0d, 0x4e8e, 0x4e9e, 0x4e9f, 0x4ea0,
  0x4ea2, 0x4eb0, 0x4eb3, 0x4eb6, 0x4ece, 0x4ecd, 0x4ec4, 0x4ec6,
  0x4ec2, 0x4ed7, 0x4ede, 0x4eed, 0x4edf, 0x4ef7, 0x4f09, 0x4f5a,
  0x4f30, 0x4f5b, 0x4f5d, 0x4f57, 0x4f47, 0x4f76, 0x4f88, 0x4f8f,
  0x4f98, 0x4f7b, 0x4f69, 0x4f70, 0x4f91, 0x4f6f, 0x4f86, 0x4f96,
  0x5118, 0x4fd4, 0x4fdf, 0x4fce, 0x4fd8, 0x4fdb, 0x4fd1, 0x4fda,
  0x4fd0, 0x4fe4, 0x4fe5, 0x501a, 0x5028, 0x5014, 0x502a, 0x5025,
  0x5005, 0x4f1c, 0x4ff6, 0x5021, 0x5029, 0x502c, 0x4ffe, 0x4fef,
  0x5011, 0x5006, 0x5043, 0x5047, 0x6703, 0x5055, 0x5050, 0x5048,
  0x505a, 0x5056, 0x506c, 0x5078, 0x5080, 0x509a, 0x5085, 0x50b4,
  0x50b2, 0x50c9, 0x50ca, 0x50b3, 0x50c2, 0x50d6, 0x50de, 0x50e5,
  0x50ed, 0x50e3, 0x50ee, 0x50f9, 0x50f5, 0x5109, 0x5101, 0x5102,
  0x5116, 0x5115, 0x5114, 0x511a, 0x5121, 0x513a, 0x5137, 0x513c,
  0x513b, 0x513f, 0x5140, 0x5152, 0x514c, 0x5154, 0x5162, 0x7af8,
  0x5169, 0x516a, 0x516e, 0x5180, 0x5182, 0x56d8, 0x518c, 0x5189,
  0x518f, 0x5191, 0x5193, 0x5195, 0x5196, 0x51a4, 0x51a6, 0x51a2,
  0x51a9, 0x51aa, 0x51ab, 0x51b3, 0x51b1, 0x51b2, 0x51b0, 0x51b5,
  0x51bd, 0x51c5, 0x51c9, 0x51db, 0x51e0, 0x8655, 0x51e9, 0x51ed,
  0x0000, 0x51f0, 0x51f5, 0x51fe, 0x5204, 0x520b, 0x5214, 0x520e,
  0x5227, 0x522a, 0x522e, 0x5233, 0x5239, 0x524f, 0x5244, 0x524b,
  0x524c, 0x525e, 0x5254, 0x526a, 0x5274, 0x5269, 0x5273, 0x527f,
  0x527d, 0x528d, 0x5294, 0x5292, 0x5271, 0x5288, 0x5291, 0x8fa8,
  0x8fa7, 0x52ac, 0x52ad, 0x52bc, 0x52b5, 0x52c1, 0x52cd, 0x52d7,
  0x52de, 0x52e3, 0x52e6, 0x98ed, 0x52e0, 0x52f3, 0x52f5, 0x52f8,
  0x52f9, 0x5306, 0x5308, 0x7538, 0x530d, 0x5310, 0x530f, 0x5315,
  0x531a, 0x5323, 0x532f, 0x5331, 0x5333, 0x5338, 0x5340, 0x5346,
  0x5345, 0x4e17, 0x5349, 0x534d, 0x51d6, 0x535e, 0x5369, 0x536e,
  0x5918, 0x537b, 0x5377, 0x5382, 0x5396, 0x53a0, 0x53a6, 0x53a5,
  0x53ae, 0x53b0, 0x53b6, 0x53c3, 0x7c12, 0x96d9, 0x53df, 0x66fc,
  0x71ee, 0x53ee, 0x53e8, 0x53ed, 0x53fa, 0x5401, 0x543d, 0x5440,
  0x542c, 0x542d, 0x543c, 0x542e, 0x5436, 0x5429, 0x541d, 0x544e,
  0x548f, 0x5475, 0x548e, 0x545f, 0x5471, 0x5477, 0x5470, 0x5492,
  0x547b, 0x5480, 0x5476, 0x5484, 0x5490, 0x5486, 0x54c7, 0x54a2,
  0x54b8, 0x54a5, 0x54ac, 0x54c4, 0x54c8, 0x54a8, 0x54ab, 0x54c2,
  0x54a4, 0x54be, 0x54bc, 0x54d8, 0x54e5, 0x54e6, 0x550f, 0x5514,
  0x54fd, 0x54ee, 0x54ed, 0x54fa, 0x54e2, 0x5539, 0x5540, 0x5563,
  0x554c, 0x552e, 0x555c, 0x5545, 0x5556, 0x5557, 0x5538, 0x5533,
  0x555d, 0x5599, 0x5580, 0x54af, 0x558a, 0x559f, 0x557b, 0x557e,
  0x5598, 0x559e, 0x55ae, 0x557c, 0x5583, 0x55a9, 0x5587, 0x55a8,
  0x55da, 0x55c5, 0x55df, 0x55c4, 0x55dc, 0x55e4, 0x55d4, 0x5614,
  0x55f7, 0x5616, 0x55fe, 0x55fd, 0x561b, 0x55f9, 0x564e, 0x5650,
  0x71df, 0x5634, 0x5636, 0x5632, 0x5638, 0x0000, 0x566b, 0x5664,
  0x562f, 0x566c, 0x566a, 0x5686, 0x5680, 0x568a, 0x56a0, 0x5694,
  0x568f, 0x56a5, 0x56ae, 0x56b6, 0x56b4, 0x56c2, 0x56bc, 0x56c1,
  0x56c3, 0x56c0, 0x56c8, 0x56ce, 0x56d1, 0x56d3, 0x56d7, 0x56ee,
  0x56f9, 0x5700, 0x56ff, 0x5704, 0x5709, 0x5708, 0x570b, 0x570d,
  0x5713, 0x5718, 0x5716, 0x55c7, 0x571c, 0x5726, 0x5737, 0x5738,
  0x574e, 0x573b, 0x5740, 0x574f, 0x5769, 0x57c0, 0x5788, 0x5761,
  0x577f, 0x5789, 0x5793, 0x57a0, 0x57b3, 0x57a4, 0x57aa, 0x57b0,
  0x57c3, 0x57c6, 0x57d4, 0x57d2, 0x57d3, 0x580a, 0x57d6, 0x57e3,
  0x580b, 0x5819, 0x581d, 0x5872, 0x5821, 0x5862, 0x584b, 0x5870,
  0x6bc0, 0x5852, 0x583d, 0x5879, 0x5885, 0x58b9, 0x589f, 0x58ab,
  0x58ba, 0x58de, 0x58bb, 0x58b8, 0x58ae, 0x58c5, 0x58d3, 0x58d1,
  0x58d7, 0x58d9, 0x58d8, 0x58e5, 0x58dc, 0x58e4, 0x58df, 0x58ef,
  0x58fa, 0x58f9, 0x58fb, 0x58fc, 0x58fd, 0x5902, 0x590a, 0x5910,
  0x591b, 0x68a6, 0x5925, 0x592c, 0x592d, 0x5932, 0x5938, 0x593e,
  0x7ad2, 0x5955, 0x5950, 0x594e, 0x595a, 0x5958, 0x5962, 0x5960,
  0x5967, 0x596c, 0x5969, 0x5978, 0x5981, 0x599d, 0x4f5e, 0x4fab,
  0x59a3, 0x59b2, 0x59c6, 0x59e8, 0x59dc, 0x598d, 0x59d9, 0x59da,
  0x5a25, 0x5a1f, 0x5a11, 0x5a1c, 0x5a09, 0x5a1a, 0x5a40, 0x5a6c,
  0x5a49, 0x5a35, 0x5a36, 0x5a62, 0x5a6a, 0x5a9a, 0x5abc, 0x5abe,
  0x5acb, 0x5ac2, 0x5abd, 0x5ae3, 0x5ad7, 0x5ae6, 0x5ae9, 0x5ad6,
  0x5afa, 0x5afb, 0x5b0c, 0x5b0b, 0x5b16, 0x5b32, 0x5ad0, 0x5b2a,
  0x5b36, 0x5b3e, 0x5b43, 0x5b45, 0x5b40, 0x5b51, 0x5b55, 0x5b5a,
  0x5b5b, 0x5b65, 0x5b69, 0x5b70, 0x5b73, 0x5b75, 0x5b78, 0x6588,
  0x5b7a, 0x5b80, 0x0000, 0x5b83, 0x5ba6, 0x5bb8, 0x5bc3, 0x5bc7,
  0x5bc9, 0x5bd4, 0x5bd0, 0x5be4, 0x5be6, 0x5be2, 0x5bde, 0x5be5,
  0x5beb, 0x5bf0, 0x5bf6, 0x5bf3, 0x5c05, 0x5c07, 0x5c08, 0x5c0d,
  0x5c13, 0x5c20, 0x5c22, 0x5c28, 0x5c38, 0x5c39, 0x5c41, 0x5c46,
  0x5c4e, 0x5c53, 0x5c50, 0x5c4f, 0x5b71, 0x5c6c, 0x5c6e, 0x4e62,
  0x5c76, 0x5c79, 0x5c8c, 0x5c91, 0x5c94, 0x599b, 0x5cab, 0x5cbb,
  0x5cb6, 0x5cbc, 0x5cb7, 0x5cc5, 0x5cbe, 0x5cc7, 0x5cd9, 0x5ce9,
  0x5cfd, 0x5cfa, 0x5ced, 0x5d8c, 0x5cea, 0x5d0b, 0x5d15, 0x5d17,
  0x5d5c, 0x5d1f, 0x5d1b, 0x5d11, 0x5d14, 0x5d22, 0x5d1a, 0x5d19,
  0x5d18, 0x5d4c, 0x5d52, 0x5d4e, 0x5d4b, 0x5d6c, 0x5d73, 0x5d76,
  0x5d87, 0x5d84, 0x5d82, 0x5da2, 0x5d9d, 0x5dac, 0x5dae, 0x5dbd,
  0x5d90, 0x5db7, 0x5dbc, 0x5dc9, 0x5dcd, 0x5dd3, 0x5dd2, 0x5dd6,
  0x5ddb, 0x5deb, 0x5df2, 0x5df5, 0x5e0b, 0x5e1a, 0x5e19, 0x5e11,
  0x5e1b, 0x5e36, 0x5e37, 0x5e44, 0x5e43, 0x5e40, 0x5e4e, 0x5e57,
  0x5e54, 0x5e5f, 0x5e62, 0x5e64, 0x5e47, 0x5e75, 0x5e76, 0x5e7a,
  0x9ebc, 0x5e7f, 0x5ea0, 0x5ec1, 0x5ec2, 0x5ec8, 0x5ed0, 0x5ecf,
  0x5ed6, 0x5ee3, 0x5edd, 0x5eda, 0x5edb, 0x5ee2, 0x5ee1, 0x5ee8,
  0x5ee9, 0x5eec, 0x5ef1, 0x5ef3, 0x5ef0, 0x5ef4, 0x5ef8, 0x5efe,
  0x5f03, 0x5f09, 0x5f5d, 0x5f5c, 0x5f0b, 0x5f11, 0x5f16, 0x5f29,
  0x5f2d, 0x5f38, 0x5f41, 0x5f48, 0x5f4c, 0x5f4e, 0x5f2f, 0x5f51,
  0x5f56, 0x5f57, 0x5f59, 0x5f61, 0x5f6d, 0x5f73, 0x5f77, 0x5f83,
  0x5f82, 0x5f7f, 0x5f8a, 0x5f88, 0x5f91, 0x5f87, 0x5f9e, 0x5f99,
  0x5f98, 0x5fa0, 0x5fa8, 0x5fad, 0x5fbc, 0x5fd6, 0x5ffb, 0x5fe4,
  0x5ff8, 0x5ff1, 0x5fdd, 0x60b3, 0x5fff, 0x6021, 0x6060, 0x0000,
  0x6019, 0x6010, 0x6029, 0x600e, 0x6031, 0x601b, 0x6015, 0x602b,
  0x6026, 0x600f, 0x603a, 0x605a, 0x6041, 0x606a, 0x6077, 0x605f,
  0x604a, 0x6046, 0x604d, 0x6063, 0x6043, 0x6064, 0x6042, 0x606c,
  0x606b, 0x6059, 0x6081, 0x608d, 0x60e7, 0x6083, 0x609a, 0x6084,
  0x609b, 0x6096, 0x6097, 0x6092, 0x60a7, 0x608b, 0x60e1, 0x60b8,
  0x60e0, 0x60d3, 0x60b4, 0x5ff0, 0x60bd, 0x60c6, 0x60b5, 0x60d8,
  0x614d, 0x6115, 0x6106, 0x60f6, 0x60f7, 0x6100, 0x60f4, 0x60fa,
  0x6103, 0x6121, 0x60fb, 0x60f1, 0x610d, 0x610e, 0x6147, 0x613e,
  0x6128, 0x6127, 0x614a, 0x613f, 0x613c, 0x612c, 0x6134, 0x613d,
  0x6142, 0x6144, 0x6173, 0x6177, 0x6158, 0x6159, 0x615a, 0x616b,
  0x6174, 0x616f, 0x6165, 0x6171, 0x615f, 0x615d, 0x6153, 0x6175,
  0x6199, 0x6196, 0x6187, 0x61ac, 0x6194, 0x619a, 0x618a, 0x6191,
  0x61ab, 0x61ae, 0x61cc, 0x61ca, 0x61c9, 0x61f7, 0x61c8, 0x61c3,
  0x61c6, 0x61ba, 0x61cb, 0x7f79, 0x61cd, 0x61e6, 0x61e3, 0x61f6,
  0x61fa, 0x61f4, 0x61ff, 0x61fd, 0x61fc, 0x61fe, 0x6200, 0x6208,
  0x6209, 0x620d, 0x620c, 0x6214, 0x621b, 0x621e, 0x6221, 0x622a,
  0x622e, 0x6230, 0x6232, 0x6233, 0x6241, 0x624e, 0x625e, 0x6263,
  0x625b, 0x6260, 0x6268, 0x627c, 0x6282, 0x6289, 0x627e, 0x6292,
  0x6293, 0x6296, 0x62d4, 0x6283, 0x6294, 0x62d7, 0x62d1, 0x62bb,
  0x62cf, 0x62ff, 0x62c6, 0x64d4, 0x62c8, 0x62dc, 0x62cc, 0x62ca,
  0x62c2, 0x62c7, 0x629b, 0x62c9, 0x630c, 0x62ee, 0x62f1, 0x6327,
  0x6302, 0x6308, 0x62ef, 0x62f5, 0x6350, 0x633e, 0x634d, 0x641c,
  0x634f, 0x6396, 0x638e, 0x6380, 0x63ab, 0x6376, 0x63a3, 0x638f,
  0x6389, 0x639f, 0x63b5, 0x636b, 0x0000, 0x6369, 0x63be, 0x63e9,
  0x63c0, 0x63c6, 0x63e3, 0x63c9, 0x63d2, 0x63f6, 0x63c4, 0x6416,
  0x6434, 0x6406, 0x6413, 0x6426, 0x6436, 0x651d, 0x6417, 0x6428,
  0x640f, 0x6467, 0x646f, 0x6476, 0x644e, 0x652a, 0x6495, 0x6493,
  0x64a5, 0x64a9, 0x6488, 0x64bc, 0x64da, 0x64d2, 0x64c5, 0x64c7,
  0x64bb, 0x64d8, 0x64c2, 0x64f1, 0x64e7, 0x8209, 0x64e0, 0x64e1,
  0x62ac, 0x64e3, 0x64ef, 0x652c, 0x64f6, 0x64f4, 0x64f2, 0x64fa,
  0x6500, 0x64fd, 0x6518, 0x651c, 0x6505, 0x6524, 0x6523, 0x652b,
  0x6534, 0x6535, 0x6537, 0x6536, 0x6538, 0x754b, 0x6548, 0x6556,
  0x6555, 0x654d, 0x6558, 0x655e, 0x655d, 0x6572, 0x6578, 0x6582,
  0x6583, 0x8b8a, 0x659b, 0x659f, 0x65ab, 0x65b7, 0x65c3, 0x65c6,
  0x65c1, 0x65c4, 0x65cc, 0x65d2, 0x65db, 0x65d9, 0x65e0, 0x65e1,
  0x65f1, 0x6772, 0x660a, 0x6603, 0x65fb, 0x6773, 0x6635, 0x6636,
  0x6634, 0x661c, 0x664f, 0x6644, 0x6649, 0x6641, 0x665e, 0x665d,
  0x6664, 0x6667, 0x6668, 0x665f, 0x6662, 0x6670, 0x6683, 0x6688,
  0x668e, 0x6689, 0x6684, 0x6698, 0x669d, 0x66c1, 0x66b9, 0x66c9,
  0x66be, 0x66bc, 0x66c4, 0x66b8, 0x66d6, 0x66da, 0x66e0, 0x663f,
  0x66e6, 0x66e9, 0x66f0, 0x66f5, 0x66f7, 0x670f, 0x6716, 0x671e,
  0x6726, 0x6727, 0x9738, 0x672e, 0x673f, 0x6736, 0x6741, 0x6738,
  0x6737, 0x6746, 0x675e, 0x6760, 0x6759, 0x6763, 0x6764, 0x6789,
  0x6770, 0x67a9, 0x677c, 0x676a, 0x678c, 0x678b, 0x67a6, 0x67a1,
  0x6785, 0x67b7, 0x67ef, 0x67b4, 0x67ec, 0x67b3, 0x67e9, 0x67b8,
  0x67e4, 0x67de, 0x67dd, 0x67e2, 0x67ee, 0x67b9, 0x67ce, 0x67c6,
  0x67e7, 0x6a9c, 0x681e, 0x6846, 0x6829, 0x6840, 0x684d, 0x6832,
  0x684e, 0x0000, 0x68b3, 0x682b, 0x6859, 0x6863, 0x6877, 0x687f,
  0x689f, 0x688f, 0x68ad, 0x6894, 0x689d, 0x689b, 0x6883, 0x6aae,
  0x68b9, 0x6874, 0x68b5, 0x68a0, 0x68ba, 0x690f, 0x688d, 0x687e,
  0x6901, 0x68ca, 0x6908, 0x68d8, 0x6922, 0x6926, 0x68e1, 0x690c,
  0x68cd, 0x68d4, 0x68e7, 0x68d5, 0x6936, 0x6912, 0x6904, 0x68d7,
  0x68e3, 0x6925, 0x68f9, 0x68e0, 0x68ef, 0x6928, 0x692a, 0x691a,
  0x6923, 0x6921, 0x68c6, 0x6979, 0x6977, 0x695c, 0x6978, 0x696b,
  0x6954, 0x697e, 0x696e, 0x6939, 0x6974, 0x693d, 0x6959, 0x6930,
  0x6961, 0x695e, 0x695d, 0x6981, 0x696a, 0x69b2, 0x69ae, 0x69d0,
  0x69bf, 0x69c1, 0x69d3, 0x69be, 0x69ce, 0x5be8, 0x69ca, 0x69dd,
  0x69bb, 0x69c3, 0x69a7, 0x6a2e, 0x6991, 0x69a0, 0x699c, 0x6995,
  0x69b4, 0x69de, 0x69e8, 0x6a02, 0x6a1b, 0x69ff, 0x6b0a, 0x69f9,
  0x69f2, 0x69e7, 0x6a05, 0x69b1, 0x6a1e, 0x69ed, 0x6a14, 0x69eb,
  0x6a0a, 0x6a12, 0x6ac1, 0x6a23, 0x6a13, 0x6a44, 0x6a0c, 0x6a72,
  0x6a36, 0x6a78, 0x6a47, 0x6a62, 0x6a59, 0x6a66, 0x6a48, 0x6a38,
  0x6a22, 0x6a90, 0x6a8d, 0x6aa0, 0x6a84, 0x6aa2, 0x6aa3, 0x6a97,
  0x8617, 0x6abb, 0x6ac3, 0x6ac2, 0x6ab8, 0x6ab3, 0x6aac, 0x6ade,
  0x6ad1, 0x6adf, 0x6aaa, 0x6ada, 0x6aea, 0x6afb, 0x6b05, 0x8616,
  0x6afa, 0x6b12, 0x6b16, 0x9b31, 0x6b1f, 0x6b38, 0x6b37, 0x76dc,
  0x6b39, 0x98ee, 0x6b47, 0x6b43, 0x6b49, 0x6b50, 0x6b59, 0x6b54,
  0x6b5b, 0x6b5f, 0x6b61, 0x6b78, 0x6b79, 0x6b7f, 0x6b80, 0x6b84,
  0x6b83, 0x6b8d, 0x6b98, 0x6b95, 0x6b9e, 0x6ba4, 0x6baa, 0x6bab,
  0x6baf, 0x6bb2, 0x6bb1, 0x6bb3, 0x6bb7, 0x6bbc, 0x6bc6, 0x6bcb,
  0x6bd3, 0x6bdf, 0x6bec, 0x6beb, 0x6bf3, 0x6bef, 0x0000, 0x9ebe,
  0x6c08, 0x6c13, 0x6c14, 0x6c1b, 0x6c24, 0x6c23, 0x6c5e, 0x6c55,
  0x6c62, 0x6c6a, 0x6c82, 0x6c8d, 0x6c9a, 0x6c81, 0x6c9b, 0x6c7e,
  0x6c68, 0x6c73, 0x6c92, 0x6c90, 0x6cc4, 0x6cf1, 0x6cd3, 0x6cbd,
  0x6cd7, 0x6cc5, 0x6cdd, 0x6cae, 0x6cb1, 0x6cbe, 0x6cba, 0x6cdb,
  0x6cef, 0x6cd9, 0x6cea, 0x6d1f, 0x884d, 0x6d36, 0x6d2b, 0x6d3d,
  0x6d38, 0x6d19, 0x6d35, 0x6d33, 0x6d12, 0x6d0c, 0x6d63, 0x6d93,
  0x6d64, 0x6d5a, 0x6d79, 0x6d59, 0x6d8e, 0x6d95, 0x6fe4, 0x6d85,
  0x6df9, 0x6e15, 0x6e0a, 0x6db5, 0x6dc7, 0x6de6, 0x6db8, 0x6dc6,
  0x6dec, 0x6dde, 0x6dcc, 0x6de8, 0x6dd2, 0x6dc5, 0x6dfa, 0x6dd9,
  0x6de4, 0x6dd5, 0x6dea, 0x6dee, 0x6e2d, 0x6e6e, 0x6e2e, 0x6e19,
  0x6e72, 0x6e5f, 0x6e3e, 0x6e23, 0x6e6b, 0x6e2b, 0x6e76, 0x6e4d,
  0x6e1f, 0x6e43, 0x6e3a, 0x6e4e, 0x6e24, 0x6eff, 0x6e1d, 0x6e38,
  0x6e82, 0x6eaa, 0x6e98, 0x6ec9, 0x6eb7, 0x6ed3, 0x6ebd, 0x6eaf,
  0x6ec4, 0x6eb2, 0x6ed4, 0x6ed5, 0x6e8f, 0x6ea5, 0x6ec2, 0x6e9f,
  0x6f41, 0x6f11, 0x704c, 0x6eec, 0x6ef8, 0x6efe, 0x6f3f, 0x6ef2,
  0x6f31, 0x6eef, 0x6f32, 0x6ecc, 0x6f3e, 0x6f13, 0x6ef7, 0x6f86,
  0x6f7a, 0x6f78, 0x6f81, 0x6f80, 0x6f6f, 0x6f5b, 0x6ff3, 0x6f6d,
  0x6f82, 0x6f7c, 0x6f58, 0x6f8e, 0x6f91, 0x6fc2, 0x6f66, 0x6fb3,
  0x6fa3, 0x6fa1, 0x6fa4, 0x6fb9, 0x6fc6, 0x6faa, 0x6fdf, 0x6fd5,
  0x6fec, 0x6fd4, 0x6fd8, 0x6ff1, 0x6fee, 0x6fdb, 0x7009, 0x700b,
  0x6ffa, 0x7011, 0x7001, 0x700f, 0x6ffe, 0x701b, 0x701a, 0x6f74,
  0x701d, 0x7018, 0x701f, 0x7030, 0x703e, 0x7032, 0x7051, 0x7063,
  0x7099, 0x7092, 0x70af, 0x70f1, 0x70ac, 0x70b8, 0x70b3, 0x70ae,
  0x70df, 0x70cb, 0x70dd, 0x0000, 0x70d9, 0x7109, 0x70fd, 0x711c,
  0x7119, 0x7165, 0x7155, 0x7188, 0x7166, 0x7162, 0x714c, 0x7156,
  0x716c, 0x718f, 0x71fb, 0x7184, 0x7195, 0x71a8, 0x71ac, 0x71d7,
  0x71b9, 0x71be, 0x71d2, 0x71c9, 0x71d4, 0x71ce, 0x71e0, 0x71ec,
  0x71e7, 0x71f5, 0x71fc, 0x71f9, 0x71ff, 0x720d, 0x7210, 0x721b,
  0x7228, 0x722d, 0x722c, 0x7230, 0x7232, 0x723b, 0x723c, 0x723f,
  0x7240, 0x7246, 0x724b, 0x7258, 0x7274, 0x727e, 0x7282, 0x7281,
  0x7287, 0x7292, 0x7296, 0x72a2, 0x72a7, 0x72b9, 0x72b2, 0x72c3,
  0x72c6, 0x72c4, 0x72ce, 0x72d2, 0x72e2, 0x72e0, 0x72e1, 0x72f9,
  0x72f7, 0x500f, 0x7317, 0x730a, 0x731c, 0x7316, 0x731d, 0x7334,
  0x732f, 0x7329, 0x7325, 0x733e, 0x734e, 0x734f, 0x9ed8, 0x7357,
  0x736a, 0x7368, 0x7370, 0x7378, 0x7375, 0x737b, 0x737a, 0x73c8,
  0x73b3, 0x73ce, 0x73bb, 0x73c0, 0x73e5, 0x73ee, 0x73de, 0x74a2,
  0x7405, 0x746f, 0x7425, 0x73f8, 0x7432, 0x743a, 0x7455, 0x743f,
  0x745f, 0x7459, 0x7441, 0x745c, 0x7469, 0x7470, 0x7463, 0x746a,
  0x7476, 0x747e, 0x748b, 0x749e, 0x74a7, 0x74ca, 0x74cf, 0x74d4,
  0x73f1, 0x74e0, 0x74e3, 0x74e7, 0x74e9, 0x74ee, 0x74f2, 0x74f0,
  0x74f1, 0x74f8, 0x74f7, 0x7504, 0x7503, 0x7505, 0x750c, 0x750e,
  0x750d, 0x7515, 0x7513, 0x751e, 0x7526, 0x752c, 0x753c, 0x7544,
  0x754d, 0x754a, 0x7549, 0x755b, 0x7546, 0x755a, 0x7569, 0x7564,
  0x7567, 0x756b, 0x756d, 0x7578, 0x7576, 0x7586, 0x7587, 0x7574,
  0x758a, 0x7589, 0x7582, 0x7594, 0x759a, 0x759d, 0x75a5, 0x75a3,
  0x75c2, 0x75b3, 0x75c3, 0x75b5, 0x75bd, 0x75b8, 0x75bc, 0x75b1,
  0x75cd, 0x75ca, 0x75d2, 0x75d9, 0x75e3, 0x75de, 0x75fe, 0x75ff,
  0x0000, 0x75fc, 0x7601, 0x75f0, 0x75fa, 0x75f2, 0x75f3, 0x760b,
  0x760d, 0x7609, 0x761f, 0x7627, 0x7620, 0x7621, 0x7622, 0x7624,
  0x7634, 0x7630, 0x763b, 0x7647, 0x7648, 0x7646, 0x765c, 0x7658,
  0x7661, 0x7662, 0x7668, 0x7669, 0x766a, 0x7667, 0x766c, 0x7670,
  0x7672, 0x7676, 0x7678, 0x767c, 0x7680, 0x7683, 0x7688, 0x768b,
  0x768e, 0x7696, 0x7693, 0x7699, 0x769a, 0x76b0, 0x76b4, 0x76b8,
  0x76b9, 0x76ba, 0x76c2, 0x76cd, 0x76d6, 0x76d2, 0x76de, 0x76e1,
  0x76e5, 0x76e7, 0x76ea, 0x862f, 0x76fb, 0x7708, 0x7707, 0x7704,
  0x7729, 0x7724, 0x771e, 0x7725, 0x7726, 0x771b, 0x7737, 0x7738,
  0x7747, 0x775a, 0x7768, 0x776b, 0x775b, 0x7765, 0x777f, 0x777e,
  0x7779, 0x778e, 0x778b, 0x7791, 0x77a0, 0x779e, 0x77b0, 0x77b6,
  0x77b9, 0x77bf, 0x77bc, 0x77bd, 0x77bb, 0x77c7, 0x77cd, 0x77d7,
  0x77da, 0x77dc, 0x77e3, 0x77ee, 0x77fc, 0x780c, 0x7812, 0x7926,
  0x7820, 0x792a, 0x7845, 0x788e, 0x7874, 0x7886, 0x787c, 0x789a,
  0x788c, 0x78a3, 0x78b5, 0x78aa, 0x78af, 0x78d1, 0x78c6, 0x78cb,
  0x78d4, 0x78be, 0x78bc, 0x78c5, 0x78ca, 0x78ec, 0x78e7, 0x78da,
  0x78fd, 0x78f4, 0x7907, 0x7912, 0x7911, 0x7919, 0x792c, 0x792b,
  0x7940, 0x7960, 0x7957, 0x795f, 0x795a, 0x7955, 0x7953, 0x797a,
  0x797f, 0x798a, 0x799d, 0x79a7, 0x9f4b, 0x79aa, 0x79ae, 0x79b3,
  0x79b9, 0x79ba, 0x79c9, 0x79d5, 0x79e7, 0x79ec, 0x79e1, 0x79e3,
  0x7a08, 0x7a0d, 0x7a18, 0x7a19, 0x7a20, 0x7a1f, 0x7980, 0x7a31,
  0x7a3b, 0x7a3e, 0x7a37, 0x7a43, 0x7a57, 0x7a49, 0x7a61, 0x7a62,
  0x7a69, 0x9f9d, 0x7a70, 0x7a79, 0x7a7d, 0x7a88, 0x7a97, 0x7a95,
  0x7a98, 0x7a96, 0x7aa9, 0x7ac8, 0x7ab0, 0x0000, 0x7ab6, 0x7ac5,
  0x7ac4, 0x7abf, 0x9083, 0x7ac7, 0x7aca, 0x7acd, 0x7acf, 0x7ad5,
  0x7ad3, 0x7ad9, 0x7ada, 0x7add, 0x7ae1, 0x7ae2, 0x7ae6, 0x7aed,
  0x7af0, 0x7b02, 0x7b0f, 0x7b0a, 0x7b06, 0x7b33, 0x7b18, 0x7b19,
  0x7b1e, 0x7b35, 0x7b28, 0x7b36, 0x7b50, 0x7b7a, 0x7b04, 0x7b4d,
  0x7b0b, 0x7b4c, 0x7b45, 0x7b75, 0x7b65, 0x7b74, 0x7b67, 0x7b70,
  0x7b71, 0x7b6c, 0x7b6e, 0x7b9d, 0x7b98, 0x7b9f, 0x7b8d, 0x7b9c,
  0x7b9a, 0x7b8b, 0x7b92, 0x7b8f, 0x7b5d, 0x7b99, 0x7bcb, 0x7bc1,
  0x7bcc, 0x7bcf, 0x7bb4, 0x7bc6, 0x7bdd, 0x7be9, 0x7c11, 0x7c14,
  0x7be6, 0x7be5, 0x7c60, 0x7c00, 0x7c07, 0x7c13, 0x7bf3, 0x7bf7,
  0x7c17, 0x7c0d, 0x7bf6, 0x7c23, 0x7c27, 0x7c2a, 0x7c1f, 0x7c37,
  0x7c2b, 0x7c3d, 0x7c4c, 0x7c43, 0x7c54, 0x7c4f, 0x7c40, 0x7c50,
  0x7c58, 0x7c5f, 0x7c64, 0x7c56, 0x7c65, 0x7c6c, 0x7c75, 0x7c83,
  0x7c90, 0x7ca4, 0x7cad, 0x7ca2, 0x7cab, 0x7ca1, 0x7ca8, 0x7cb3,
  0x7cb2, 0x7cb1, 0x7cae, 0x7cb9, 0x7cbd, 0x7cc0, 0x7cc5, 0x7cc2,
  0x7cd8, 0x7cd2, 0x7cdc, 0x7ce2, 0x9b3b, 0x7cef, 0x7cf2, 0x7cf4,
  0x7cf6, 0x7cfa, 0x7d06, 0x7d02, 0x7d1c, 0x7d15, 0x7d0a, 0x7d45,
  0x7d4b, 0x7d2e, 0x7d32, 0x7d3f, 0x7d35, 0x7d46, 0x7d73, 0x7d56,
  0x7d4e, 0x7d72, 0x7d68, 0x7d6e, 0x7d4f, 0x7d63, 0x7d93, 0x7d89,
  0x7d5b, 0x7d8f, 0x7d7d, 0x7d9b, 0x7dba, 0x7dae, 0x7da3, 0x7db5,
  0x7dc7, 0x7dbd, 0x7dab, 0x7e3d, 0x7da2, 0x7daf, 0x7ddc, 0x7db8,
  0x7d9f, 0x7db0, 0x7dd8, 0x7ddd, 0x7de4, 0x7dde, 0x7dfb, 0x7df2,
  0x7de1, 0x7e05, 0x7e0a, 0x7e23, 0x7e21, 0x7e12, 0x7e31, 0x7e1f,
  0x7e09, 0x7e0b, 0x7e22, 0x7e46, 0x7e66, 0x7e3b, 0x7e35, 0x7e39,
  0x7e43, 0x7e37, 0x0000, 0x7e32, 0x7e3a, 0x7e67, 0x7e5d, 0x7e56,
  0x7e5e, 0x7e59, 0x7e5a, 0x7e79, 0x7e6a, 0x7e69, 0x7e7c, 0x7e7b,
  0x7e83, 0x7dd5, 0x7e7d, 0x8fae, 0x7e7f, 0x7e88, 0x7e89, 0x7e8c,
  0x7e92, 0x7e90, 0x7e93, 0x7e94, 0x7e96, 0x7e8e, 0x7e9b, 0x7e9c,
  0x7f38, 0x7f3a, 0x7f45, 0x7f4c, 0x7f4d, 0x7f4e, 0x7f50, 0x7f51,
  0x7f55, 0x7f54, 0x7f58, 0x7f5f, 0x7f60, 0x7f68, 0x7f69, 0x7f67,
  0x7f78, 0x7f82, 0x7f86, 0x7f83, 0x7f88, 0x7f87, 0x7f8c, 0x7f94,
  0x7f9e, 0x7f9d, 0x7f9a, 0x7fa3, 0x7faf, 0x7fb2, 0x7fb9, 0x7fae,
  0x7fb6, 0x7fb8, 0x8b71, 0x7fc5, 0x7fc6, 0x7fca, 0x7fd5, 0x7fd4,
  0x7fe1, 0x7fe6, 0x7fe9, 0x7ff3, 0x7ff9, 0x98dc, 0x8006, 0x8004,
  0x800b, 0x8012, 0x8018, 0x8019, 0x801c, 0x8021, 0x8028, 0x803f,
  0x803b, 0x804a, 0x8046, 0x8052, 0x8058, 0x805a, 0x805f, 0x8062,
  0x8068, 0x8073, 0x8072, 0x8070, 0x8076, 0x8079, 0x807d, 0x807f,
  0x8084, 0x8086, 0x8085, 0x809b, 0x8093, 0x809a, 0x80ad, 0x5190,
  0x80ac, 0x80db, 0x80e5, 0x80d9, 0x80dd, 0x80c4, 0x80da, 0x80d6,
  0x8109, 0x80ef, 0x80f1, 0x811b, 0x8129, 0x8123, 0x812f, 0x814b,
  0x968b, 0x8146, 0x813e, 0x8153, 0x8151, 0x80fc, 0x8171, 0x816e,
  0x8165, 0x8166, 0x8174, 0x8183, 0x8188, 0x818a, 0x8180, 0x8182,
  0x81a0, 0x8195, 0x81a4, 0x81a3, 0x815f, 0x8193, 0x81a9, 0x81b0,
  0x81b5, 0x81be, 0x81b8, 0x81bd, 0x81c0, 0x81c2, 0x81ba, 0x81c9,
  0x81cd, 0x81d1, 0x81d9, 0x81d8, 0x81c8, 0x81da, 0x81df, 0x81e0,
  0x81e7, 0x81fa, 0x81fb, 0x81fe, 0x8201, 0x8202, 0x8205, 0x8207,
  0x820a, 0x820d, 0x8210, 0x8216, 0x8229, 0x822b, 0x8238, 0x8233,
  0x8240, 0x8259, 0x8258, 0x825d, 0x825a, 0x825f, 0x8264, 0x0000,
  0x8262, 0x8268, 0x826a, 0x826b, 0x822e, 0x8271, 0x8277, 0x8278,
  0x827e, 0x828d, 0x8292, 0x82ab, 0x829f, 0x82bb, 0x82ac, 0x82e1,
  0x82e3, 0x82df, 0x82d2, 0x82f4, 0x82f3, 0x82fa, 0x8393, 0x8303,
  0x82fb, 0x82f9, 0x82de, 0x8306, 0x82dc, 0x8309, 0x82d9, 0x8335,
  0x8334, 0x8316, 0x8332, 0x8331, 0x8340, 0x8339, 0x8350, 0x8345,
  0x832f, 0x832b, 0x8317, 0x8318, 0x8385, 0x839a, 0x83aa, 0x839f,
  0x83a2, 0x8396, 0x8323, 0x838e, 0x8387, 0x838a, 0x837c, 0x83b5,
  0x8373, 0x8375, 0x83a0, 0x8389, 0x83a8, 0x83f4, 0x8413, 0x83eb,
  0x83ce, 0x83fd, 0x8403, 0x83d8, 0x840b, 0x83c1, 0x83f7, 0x8407,
  0x83e0, 0x83f2, 0x840d, 0x8422, 0x8420, 0x83bd, 0x8438, 0x8506,
  0x83fb, 0x846d, 0x842a, 0x843c, 0x855a, 0x8484, 0x8477, 0x846b,
  0x84ad, 0x846e, 0x8482, 0x8469, 0x8446, 0x842c, 0x846f, 0x8479,
  0x8435, 0x84ca, 0x8462, 0x84b9, 0x84bf, 0x849f, 0x84d9, 0x84cd,
  0x84bb, 0x84da, 0x84d0, 0x84c1, 0x84c6, 0x84d6, 0x84a1, 0x8521,
  0x84ff, 0x84f4, 0x8517, 0x8518, 0x852c, 0x851f, 0x8515, 0x8514,
  0x84fc, 0x8540, 0x8563, 0x8558, 0x8548, 0x8541, 0x8602, 0x854b,
  0x8555, 0x8580, 0x85a4, 0x8588, 0x8591, 0x858a, 0x85a8, 0x856d,
  0x8594, 0x859b, 0x85ea, 0x8587, 0x859c, 0x8577, 0x857e, 0x8590,
  0x85c9, 0x85ba, 0x85cf, 0x85b9, 0x85d0, 0x85d5, 0x85dd, 0x85e5,
  0x85dc, 0x85f9, 0x860a, 0x8613, 0x860b, 0x85fe, 0x85fa, 0x8606,
  0x8622, 0x861a, 0x8630, 0x863f, 0x864d, 0x4e55, 0x8654, 0x865f,
  0x8667, 0x8671, 0x8693, 0x86a3, 0x86a9, 0x86aa, 0x868b, 0x868c,
  0x86b6, 0x86af, 0x86c4, 0x86c6, 0x86b0, 0x86c9, 0x8823, 0x86ab,
  0x86d4, 0x86de, 0x86e9, 0x86ec, 0x0000, 0x86df, 0x86db, 0x86ef,
  0x8712, 0x8706, 0x8708, 0x8700, 0x8703, 0x86fb, 0x8711, 0x8709,
  0x870d, 0x86f9, 0x870a, 0x8734, 0x873f, 0x8737, 0x873b, 0x8725,
  0x8729, 0x871a, 0x8760, 0x875f, 0x8778, 0x874c, 0x874e, 0x8774,
  0x8757, 0x8768, 0x876e, 0x8759, 0x8753, 0x8763, 0x876a, 0x8805,
  0x87a2, 0x879f, 0x8782, 0x87af, 0x87cb, 0x87bd, 0x87c0, 0x87d0,
  0x96d6, 0x87ab, 0x87c4, 0x87b3, 0x87c7, 0x87c6, 0x87bb, 0x87ef,
  0x87f2, 0x87e0, 0x880f, 0x880d, 0x87fe, 0x87f6, 0x87f7, 0x880e,
  0x87d2, 0x8811, 0x8816, 0x8815, 0x8822, 0x8821, 0x8831, 0x8836,
  0x8839, 0x8827, 0x883b, 0x8844, 0x8842, 0x8852, 0x8859, 0x885e,
  0x8862, 0x886b, 0x8881, 0x887e, 0x889e, 0x8875, 0x887d, 0x88b5,
  0x8872, 0x8882, 0x8897, 0x8892, 0x88ae, 0x8899, 0x88a2, 0x888d,
  0x88a4, 0x88b0, 0x88bf, 0x88b1, 0x88c3, 0x88c4, 0x88d4, 0x88d8,
  0x88d9, 0x88dd, 0x88f9, 0x8902, 0x88fc, 0x88f4, 0x88e8, 0x88f2,
  0x8904, 0x890c, 0x890a, 0x8913, 0x8943, 0x891e, 0x8925, 0x892a,
  0x892b, 0x8941, 0x8944, 0x893b, 0x8936, 0x8938, 0x894c, 0x891d,
  0x8960, 0x895e, 0x8966, 0x8964, 0x896d, 0x896a, 0x896f, 0x8974,
  0x8977, 0x897e, 0x8983, 0x8988, 0x898a, 0x8993, 0x8998, 0x89a1,
  0x89a9, 0x89a6, 0x89ac, 0x89af, 0x89b2, 0x89ba, 0x89bd, 0x89bf,
  0x89c0, 0x89da, 0x89dc, 0x89dd, 0x89e7, 0x89f4, 0x89f8, 0x8a03,
  0x8a16, 0x8a10, 0x8a0c, 0x8a1b, 0x8a1d, 0x8a25, 0x8a36, 0x8a41,
  0x8a5b, 0x8a52, 0x8a46, 0x8a48, 0x8a7c, 0x8a6d, 0x8a6c, 0x8a62,
  0x8a85, 0x8a82, 0x8a84, 0x8aa8, 0x8aa1, 0x8a91, 0x8aa5, 0x8aa6,
  0x8a9a, 0x8aa3, 0x8ac4, 0x8acd, 0x8ac2, 0x8ada, 0x8aeb, 0x8af3,
  0x8ae7, 0x0000, 0x8ae4, 0x8af1, 0x8b14, 0x8ae0, 0x8ae2, 0x8af7,
  0x8ade, 0x8adb, 0x8b0c, 0x8b07, 0x8b1a, 0x8ae1, 0x8b16, 0x8b10,
  0x8b17, 0x8b20, 0x8b33, 0x97ab, 0x8b26, 0x8b2b, 0x8b3e, 0x8b28,
  0x8b41, 0x8b4c, 0x8b4f, 0x8b4e, 0x8b49, 0x8b56, 0x8b5b, 0x8b5a,
  0x8b6b, 0x8b5f, 0x8b6c, 0x8b6f, 0x8b74, 0x8b7d, 0x8b80, 0x8b8c,
  0x8b8e, 0x8b92, 0x8b93, 0x8b96, 0x8b99, 0x8b9a, 0x8c3a, 0x8c41,
  0x8c3f, 0x8c48, 0x8c4c, 0x8c4e, 0x8c50, 0x8c55, 0x8c62, 0x8c6c,
  0x8c78, 0x8c7a, 0x8c82, 0x8c89, 0x8c85, 0x8c8a, 0x8c8d, 0x8c8e,
  0x8c94, 0x8c7c, 0x8c98, 0x621d, 0x8cad, 0x8caa, 0x8cbd, 0x8cb2,
  0x8cb3, 0x8cae, 0x8cb6, 0x8cc8, 0x8cc1, 0x8ce4, 0x8ce3, 0x8cda,
  0x8cfd, 0x8cfa, 0x8cfb, 0x8d04, 0x8d05, 0x8d0a, 0x8d07, 0x8d0f,
  0x8d0d, 0x8d10, 0x9f4e, 0x8d13, 0x8ccd, 0x8d14, 0x8d16, 0x8d67,
  0x8d6d, 0x8d71, 0x8d73, 0x8d81, 0x8d99, 0x8dc2, 0x8dbe, 0x8dba,
  0x8dcf, 0x8dda, 0x8dd6, 0x8dcc, 0x8ddb, 0x8dcb, 0x8dea, 0x8deb,
  0x8ddf, 0x8de3, 0x8dfc, 0x8e08, 0x8e09, 0x8dff, 0x8e1d, 0x8e1e,
  0x8e10, 0x8e1f, 0x8e42, 0x8e35, 0x8e30, 0x8e34, 0x8e4a, 0x8e47,
  0x8e49, 0x8e4c, 0x8e50, 0x8e48, 0x8e59, 0x8e64, 0x8e60, 0x8e2a,
  0x8e63, 0x8e55, 0x8e76, 0x8e72, 0x8e7c, 0x8e81, 0x8e87, 0x8e85,
  0x8e84, 0x8e8b, 0x8e8a, 0x8e93, 0x8e91, 0x8e94, 0x8e99, 0x8eaa,
  0x8ea1, 0x8eac, 0x8eb0, 0x8ec6, 0x8eb1, 0x8ebe, 0x8ec5, 0x8ec8,
  0x8ecb, 0x8edb, 0x8ee3, 0x8efc, 0x8efb, 0x8eeb, 0x8efe, 0x8f0a,
  0x8f05, 0x8f15, 0x8f12, 0x8f19, 0x8f13, 0x8f1c, 0x8f1f, 0x8f1b,
  0x8f0c, 0x8f26, 0x8f33, 0x8f3b, 0x8f39, 0x8f45, 0x8f42, 0x8f3e,
  0x8f4c, 0x8f49, 0x8f46, 0x8f4e, 0x8f57, 0x8f5c, 0x0000, 0x8f62,
  0x8f63, 0x8f64, 0x8f9c, 0x8f9f, 0x8fa3, 0x8fad, 0x8faf, 0x8fb7,
  0x8fda, 0x8fe5, 0x8fe2, 0x8fea, 0x8fef, 0x9087, 0x8ff4, 0x9005,
  0x8ff9, 0x8ffa, 0x9011, 0x9015, 0x9021, 0x900d, 0x901e, 0x9016,
  0x900b, 0x9027, 0x9036, 0x9035, 0x9039, 0x8ff8, 0x904f, 0x9050,
  0x9051, 0x9052, 0x900e, 0x9049, 0x903e, 0x9056, 0x9058, 0x905e,
  0x9068, 0x906f, 0x9076, 0x96a8, 0x9072, 0x9082, 0x907d, 0x9081,
  0x9080, 0x908a, 0x9089, 0x908f, 0x90a8, 0x90af, 0x90b1, 0x90b5,
  0x90e2, 0x90e4, 0x6248, 0x90db, 0x9102, 0x9112, 0x9119, 0x9132,
  0x9130, 0x914a, 0x9156, 0x9158, 0x9163, 0x9165, 0x9169, 0x9173,
  0x9172, 0x918b, 0x9189, 0x9182, 0x91a2, 0x91ab, 0x91af, 0x91aa,
  0x91b5, 0x91b4, 0x91ba, 0x91c0, 0x91c1, 0x91c9, 0x91cb, 0x91d0,
  0x91d6, 0x91df, 0x91e1, 0x91db, 0x91fc, 0x91f5, 0x91f6, 0x921e,
  0x91ff, 0x9214, 0x922c, 0x9215, 0x9211, 0x925e, 0x9257, 0x9245,
  0x9249, 0x9264, 0x9248, 0x9295, 0x923f, 0x924b, 0x9250, 0x929c,
  0x9296, 0x9293, 0x929b, 0x925a, 0x92cf, 0x92b9, 0x92b7, 0x92e9,
  0x930f, 0x92fa, 0x9344, 0x932e, 0x9319, 0x9322, 0x931a, 0x9323,
  0x933a, 0x9335, 0x933b, 0x935c, 0x9360, 0x937c, 0x936e, 0x9356,
  0x93b0, 0x93ac, 0x93ad, 0x9394, 0x93b9, 0x93d6, 0x93d7, 0x93e8,
  0x93e5, 0x93d8, 0x93c3, 0x93dd, 0x93d0, 0x93c8, 0x93e4, 0x941a,
  0x9414, 0x9413, 0x9403, 0x9407, 0x9410, 0x9436, 0x942b, 0x9435,
  0x9421, 0x943a, 0x9441, 0x9452, 0x9444, 0x945b, 0x9460, 0x9462,
  0x945e, 0x946a, 0x9229, 0x9470, 0x9475, 0x9477, 0x947d, 0x945a,
  0x947c, 0x947e, 0x9481, 0x947f, 0x9582, 0x9587, 0x958a, 0x9594,
  0x9596, 0x9598, 0x9599, 0x0000, 0x95a0, 0x95a8, 0x95a7, 0x95ad,
  0x95bc, 0x95bb, 0x95b9, 0x95be, 0x95ca, 0x6ff6, 0x95c3, 0x95cd,
  0x95cc, 0x95d5, 0x95d4, 0x95d6, 0x95dc, 0x95e1, 0x95e5, 0x95e2,
  0x9621, 0x9628, 0x962e, 0x962f, 0x9642, 0x964c, 0x964f, 0x964b,
  0x9677, 0x965c, 0x965e, 0x965d, 0x965f, 0x9666, 0x9672, 0x966c,
  0x968d, 0x9698, 0x9695, 0x9697, 0x96aa, 0x96a7, 0x96b1, 0x96b2,
  0x96b0, 0x96b4, 0x96b6, 0x96b8, 0x96b9, 0x96ce, 0x96cb, 0x96c9,
  0x96cd, 0x894d, 0x96dc, 0x970d, 0x96d5, 0x96f9, 0x9704, 0x9706,
  0x9708, 0x9713, 0x970e, 0x9711, 0x970f, 0x9716, 0x9719, 0x9724,
  0x972a, 0x9730, 0x9739, 0x973d, 0x973e, 0x9744, 0x9746, 0x9748,
  0x9742, 0x9749, 0x975c, 0x9760, 0x9764, 0x9766, 0x9768, 0x52d2,
  0x976b, 0x9771, 0x9779, 0x9785, 0x977c, 0x9781, 0x977a, 0x9786,
  0x978b, 0x978f, 0x9790, 0x979c, 0x97a8, 0x97a6, 0x97a3, 0x97b3,
  0x97b4, 0x97c3, 0x97c6, 0x97c8, 0x97cb, 0x97dc, 0x97ed, 0x9f4f,
  0x97f2, 0x7adf, 0x97f6, 0x97f5, 0x980f, 0x980c, 0x9838, 0x9824,
  0x9821, 0x9837, 0x983d, 0x9846, 0x984f, 0x984b, 0x986b, 0x986f,
  0x9870, 0x9871, 0x9874, 0x9873, 0x98aa, 0x98af, 0x98b1, 0x98b6,
  0x98c4, 0x98c3, 0x98c6, 0x98e9, 0x98eb, 0x9903, 0x9909, 0x9912,
  0x9914, 0x9918, 0x9921, 0x991d, 0x991e, 0x9924, 0x9920, 0x992c,
  0x992e, 0x993d, 0x993e, 0x9942, 0x9949, 0x9945, 0x9950, 0x994b,
  0x9951, 0x9952, 0x994c, 0x9955, 0x9997, 0x9998, 0x99a5, 0x99ad,
  0x99ae, 0x99bc, 0x99df, 0x99db, 0x99dd, 0x99d8, 0x99d1, 0x99ed,
  0x99ee, 0x99f1, 0x99f2, 0x99fb, 0x99f8, 0x9a01, 0x9a0f, 0x9a05,
  0x99e2, 0x9a19, 0x9a2b, 0x9a37, 0x9a45, 0x9a42, 0x9a40, 0x9a43,
  0x0000, 0x9a3e, 0x9a55, 0x9a4d, 0x9a5b, 0x9a57, 0x9a5f, 0x9a62,
  0x9a65, 0x9a64, 0x9a69, 0x9a6b, 0x9a6a, 0x9aad, 0x9ab0, 0x9abc,
  0x9ac0, 0x9acf, 0x9ad1, 0x9ad3, 0x9ad4, 0x9ade, 0x9adf, 0x9ae2,
  0x9ae3, 0x9ae6, 0x9aef, 0x9aeb, 0x9aee, 0x9af4, 0x9af1, 0x9af7,
  0x9afb, 0x9b06, 0x9b18, 0x9b1a, 0x9b1f, 0x9b22, 0x9b23, 0x9b25,
  0x9b27, 0x9b28, 0x9b29, 0x9b2a, 0x9b2e, 0x9b2f, 0x9b32, 0x9b44,
  0x9b43, 0x9b4f, 0x9b4d, 0x9b4e, 0x9b51, 0x9b58, 0x9b74, 0x9b93,
  0x9b83, 0x9b91, 0x9b96, 0x9b97, 0x9b9f, 0x9ba0, 0x9ba8, 0x9bb4,
  0x9bc0, 0x9bca, 0x9bb9, 0x9bc6, 0x9bcf, 0x9bd1, 0x9bd2, 0x9be3,
  0x9be2, 0x9be4, 0x9bd4, 0x9be1, 0x9c3a, 0x9bf2, 0x9bf1, 0x9bf0,
  0x9c15, 0x9c14, 0x9c09, 0x9c13, 0x9c0c, 0x9c06, 0x9c08, 0x9c12,
  0x9c0a, 0x9c04, 0x9c2e, 0x9c1b, 0x9c25, 0x9c24, 0x9c21, 0x9c30,
  0x9c47, 0x9c32, 0x9c46, 0x9c3e, 0x9c5a, 0x9c60, 0x9c67, 0x9c76,
  0x9c78, 0x9ce7, 0x9cec, 0x9cf0, 0x9d09, 0x9d08, 0x9ceb, 0x9d03,
  0x9d06, 0x9d2a, 0x9d26, 0x9daf, 0x9d23, 0x9d1f, 0x9d44, 0x9d15,
  0x9d12, 0x9d41, 0x9d3f, 0x9d3e, 0x9d46, 0x9d48, 0x9d5d, 0x9d5e,
  0x9d64, 0x9d51, 0x9d50, 0x9d59, 0x9d72, 0x9d89, 0x9d87, 0x9dab,
  0x9d6f, 0x9d7a, 0x9d9a, 0x9da4, 0x9da9, 0x9db2, 0x9dc4, 0x9dc1,
  0x9dbb, 0x9db8, 0x9dba, 0x9dc6, 0x9dcf, 0x9dc2, 0x9dd9, 0x9dd3,
  0x9df8, 0x9de6, 0x9ded, 0x9def, 0x9dfd, 0x9e1a, 0x9e1b, 0x9e1e,
  0x9e75, 0x9e79, 0x9e7d, 0x9e81, 0x9e88, 0x9e8b, 0x9e8c, 0x9e92,
  0x9e95, 0x9e91, 0x9e9d, 0x9ea5, 0x9ea9, 0x9eb8, 0x9eaa, 0x9ead,
  0x9761, 0x9ecc, 0x9ece, 0x9ecf, 0x9ed0, 0x9ed4, 0x9edc, 0x9ede,
  0x9edd, 0x9ee0, 0x9ee5, 0x9ee8, 0x9eef, 0x0000, 0x9ef4, 0x9ef6,
  0x9ef7, 0x9ef9, 0x9efb, 0x9efc, 0x9efd, 0x9f07, 0x9f08, 0x76b7,
  0x9f15, 0x9f21, 0x9f2c, 0x9f3e, 0x9f4a, 0x9f52, 0x9f54, 0x9f63,
  0x9f5f, 0x9f60, 0x9f61, 0x9f66, 0x9f67, 0x9f6c, 0x9f6a, 0x9f77,
  0x9f72, 0x9f76, 0x9f95, 0x9f9c, 0x9fa0, 0x582f, 0x69c7, 0x9059,
  0x7464, 0x51dc, 0x7199, 0x7e8a, 0x891c, 0x9348, 0x9288, 0x84dc,
  0x4fc9, 0x70bb, 0x6631, 0x68c8, 0x92f9, 0x66fb, 0x5f45, 0x4e28,
  0x4ee1, 0x4efc, 0x4f00, 0x4f03, 0x4f39, 0x4f56, 0x4f92, 0x4f8a,
  0x4f9a, 0x4f94, 0x4fcd, 0x5040, 0x5022, 0x4fff, 0x501e, 0x5046,
  0x5070, 0x5042, 0x5094, 0x50f4, 0x50d8, 0x514a, 0x5164, 0x519d,
  0x51be, 0x51ec, 0x5215, 0x529c, 0x52a6, 0x52c0, 0x52db, 0x5300,
  0x5307, 0x5324, 0x5372, 0x5393, 0x53b2, 0x53dd, 0xfa0e, 0x549c,
  0x548a, 0x54a9, 0x54ff, 0x5586, 0x5759, 0x5765, 0x57ac, 0x57c8,
  0x57c7, 0xfa0f, 0x0000, 0xfa10, 0x589e, 0x58b2, 0x590b, 0x5953,
  0x595b, 0x595d, 0x5963, 0x59a4, 0x59ba, 0x5b56, 0x5bc0, 0x752f,
  0x5bd8, 0x5bec, 0x5c1e, 0x5ca6, 0x5cba, 0x5cf5, 0x5d27, 0x5d53,
  0xfa11, 0x5d42, 0x5d6d, 0x5db8, 0x5db9, 0x5dd0, 0x5f21, 0x5f34,
  0x5f67, 0x5fb7, 0x5fde, 0x605d, 0x6085, 0x608a, 0x60de, 0x60d5,
  0x6120, 0x60f2, 0x6111, 0x6137, 0x6130, 0x6198, 0x6213, 0x62a6,
  0x63f5, 0x6460, 0x649d, 0x64ce, 0x654e, 0x6600, 0x6615, 0x663b,
  0x6609, 0x662e, 0x661e, 0x6624, 0x6665, 0x6657, 0x6659, 0xfa12,
  0x6673, 0x6699, 0x66a0, 0x66b2, 0x66bf, 0x66fa, 0x670e, 0xf929,
  0x6766, 0x67bb, 0x6852, 0x67c0, 0x6801, 0x6844, 0x68cf, 0xfa13,
  0x6968, 0xfa14, 0x6998, 0x69e2, 0x6a30, 0x6a6b, 0x6a46, 0x6a73,
  0x6a7e, 0x6ae2, 0x6ae4, 0x6bd6, 0x6c3f, 0x6c5c, 0x6c86, 0x6c6f,
  0x6cda, 0x6d04, 0x6d87, 0x6d6f, 0x6d96, 0x6dac, 0x6dcf, 0x6df8,
  0x6df2, 0x6dfc, 0x6e39, 0x6e5c, 0x6e27, 0x6e3c, 0x6ebf, 0x6f88,
  0x6fb5, 0x6ff5, 0x7005, 0x7007, 0x7028, 0x7085, 0x70ab, 0x710f,
  0x7104, 0x715c, 0x7146, 0x7147, 0xfa15, 0x71c1, 0x71fe, 0x72b1,
  0x72be, 0x7324, 0xfa16, 0x7377, 0x73bd, 0x73c9, 0x73d6, 0x73e3,
  0x73d2, 0x7407, 0x73f5, 0x7426, 0x742a, 0x7429, 0x742e, 0x7462,
  0x7489, 0x749f, 0x7501, 0x756f, 0x7682, 0x769c, 0x769e, 0x769b,
  0x76a6, 0xfa17, 0x7746, 0x52af, 0x7821, 0x784e, 0x7864, 0x787a,
  0x7930, 0xfa18, 0xfa19, 0xfa1a, 0x7994, 0xfa1b, 0x799b, 0x7ad1,
  0x7ae7, 0xfa1c, 0x7aeb, 0x7b9e, 0xfa1d, 0x7d48, 0x7d5c, 0x7db7,
  0x7da0, 0x7dd6, 0x7e52, 0x7f47, 0x7fa1, 0xfa1e, 0x8301, 0x8362,
  0x837f, 0x83c7, 0x83f6, 0x8448, 0x84b4, 0x8553, 0x8559, 0x0000,
  0x856b, 0xfa1f, 0x85b0, 0xfa20, 0xfa21, 0x8807, 0x88f5, 0x8a12,
  0x8a37, 0x8a79, 0x8aa7, 0x8abe, 0x8adf, 0xfa22, 0x8af6, 0x8b53,
  0x8b7f, 0x8cf0, 0x8cf4, 0x8d12, 0x8d76, 0xfa23, 0x8ecf, 0xfa24,
  0xfa25, 0x9067, 0x90de, 0xfa26, 0x9115, 0x9127, 0x91da, 0x91d7,
  0x91de, 0x91ed, 0x91ee, 0x91e4, 0x91e5, 0x9206, 0x9210, 0x920a,
  0x923a, 0x9240, 0x923c, 0x924e, 0x9259, 0x9251, 0x9239, 0x9267,
  0x92a7, 0x9277, 0x9278, 0x92e7, 0x92d7, 0x92d9, 0x92d0, 0xfa27,
  0x92d5, 0x92e0, 0x92d3, 0x9325, 0x9321, 0x92fb, 0xfa28, 0x931e,
  0x92ff, 0x931d, 0x9302, 0x9370, 0x9357, 0x93a4, 0x93c6, 0x93de,
  0x93f8, 0x9431, 0x9445, 0x9448, 0x9592, 0xf9dc, 0xfa29, 0x969d,
  0x96af, 0x9733, 0x973b, 0x9743, 0x974d, 0x974f, 0x9751, 0x9755,
  0x9857, 0x9865, 0xfa2a, 0xfa2b, 0x9927, 0xfa2c, 0x999e, 0x9a4e,
  0x9ad9, 0x9adc, 0x9b75, 0x9b72, 0x9b8f, 0x9bb1, 0x9bbb, 0x9c00,
  0x9d70, 0x9d6b, 0xfa2d, 0x9e19, 0x9ed1, 0x0000, 0x0000, 0x2170,
  0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178,
  0x2179, 0xffe2, 0x00a6, 0xff07, 0xff02, 0xe000, 0xe001, 0xe002,
  0xe003, 0xe004, 0xe005, 0xe006, 0xe007, 0xe008, 0xe009, 0xe00a,
  0xe00b, 0xe00c, 0xe00d, 0xe00e, 0xe00f, 0xe010, 0xe011, 0xe012,
  0xe013, 0xe014, 0xe015, 0xe016, 0xe017, 0xe018, 0xe019, 0xe01a,
  0xe01b, 0xe01c, 0xe01d, 0xe01e, 0xe01f, 0xe020, 0xe021, 0xe022,
  0xe023, 0xe024, 0xe025, 0xe026, 0xe027, 0xe028, 0xe029, 0xe02a,
  0xe02b, 0xe02c, 0xe02d, 0xe02e, 0xe02f, 0xe030, 0xe031, 0xe032,
  0xe033, 0xe034, 0xe035, 0xe036, 0xe037, 0xe038, 0xe039, 0xe03a,
  0xe03b, 0xe03c, 0xe03d, 0xe03e, 0x0000, 0xe03f, 0xe040, 0xe041,
  0xe042, 0xe043, 0xe044, 0xe045, 0xe046, 0xe047, 0xe048, 0xe049,
  0xe04a, 0xe04b, 0xe04c, 0xe04d, 0xe04e, 0xe04f, 0xe050, 0xe051,
  0xe052, 0xe053, 0xe054, 0xe055, 0xe056, 0xe057, 0xe058, 0xe059,
  0xe05a, 0xe05b, 0xe05c, 0xe05d, 0xe05e, 0xe05f, 0xe060, 0xe061,
  0xe062, 0xe063, 0xe064, 0xe065, 0xe066, 0xe067, 0xe068, 0xe069,
  0xe06a, 0xe06b, 0xe06c, 0xe06d, 0xe06e, 0xe06f, 0xe070, 0xe071,
  0xe072, 0xe073, 0xe074, 0xe075, 0xe076, 0xe077, 0xe078, 0xe079,
  0xe07a, 0xe07b, 0xe07c, 0xe07d, 0xe07e, 0xe07f, 0xe080, 0xe081,
  0xe082, 0xe083, 0xe084, 0xe085, 0xe086, 0xe087, 0xe088, 0xe089,
  0xe08a, 0xe08b, 0xe08c, 0xe08d, 0xe08e, 0xe08f, 0xe090, 0xe091,
  0xe092, 0xe093, 0xe094, 0xe095, 0xe096, 0xe097, 0xe098, 0xe099,
  0xe09a, 0xe09b, 0xe09c, 0xe09d, 0xe09e, 0xe09f, 0xe0a0, 0xe0a1,
  0xe0a2, 0xe0a3, 0xe0a4, 0xe0a5, 0xe0a6, 0xe0a7, 0xe0a8, 0xe0a9,
  0xe0aa, 0xe0ab, 0xe0ac, 0xe0ad, 0xe0ae, 0xe0af, 0xe0b0, 0xe0b1,
  0xe0b2, 0xe0b3, 0xe0b4, 0xe0b5, 0xe0b6, 0xe0b7, 0xe0b8, 0xe0b9,
  0xe0ba, 0xe0bb, 0xe0bc, 0xe0bd, 0xe0be, 0xe0bf, 0xe0c0, 0xe0c1,
  0xe0c2, 0xe0c3, 0xe0c4, 0xe0c5, 0xe0c6, 0xe0c7, 0xe0c8, 0xe0c9,
  0xe0ca, 0xe0cb, 0xe0cc, 0xe0cd, 0xe0ce, 0xe0cf, 0xe0d0, 0xe0d1,
  0xe0d2, 0xe0d3, 0xe0d4, 0xe0d5, 0xe0d6, 0xe0d7, 0xe0d8, 0xe0d9,
  0xe0da, 0xe0db, 0xe0dc, 0xe0dd, 0xe0de, 0xe0df, 0xe0e0, 0xe0e1,
  0xe0e2, 0xe0e3, 0xe0e4, 0xe0e5, 0xe0e6, 0xe0e7, 0xe0e8, 0xe0e9,
  0xe0ea, 0xe0eb, 0xe0ec, 0xe0ed, 0xe0ee, 0xe0ef, 0xe0f0, 0xe0f1,
  0xe0f2, 0xe0f3, 0xe0f4, 0xe0f5, 0xe0f6, 0xe0f7, 0xe0f8, 0xe0f9,
  0xe0fa, 0x0000, 0xe0fb, 0xe0fc, 0xe0fd, 0xe0fe, 0xe0ff, 0xe100,
  0xe101, 0xe102, 0xe103, 0xe104, 0xe105, 0xe106, 0xe107, 0xe108,
  0xe109, 0xe10a, 0xe10b, 0xe10c, 0xe10d, 0xe10e, 0xe10f, 0xe110,
  0xe111, 0xe112, 0xe113, 0xe114, 0xe115, 0xe116, 0xe117, 0xe118,
  0xe119, 0xe11a, 0xe11b, 0xe11c, 0xe11d, 0xe11e, 0xe11f, 0xe120,
  0xe121, 0xe122, 0xe123, 0xe124, 0xe125, 0xe126, 0xe127, 0xe128,
  0xe129, 0xe12a, 0xe12b, 0xe12c, 0xe12d, 0xe12e, 0xe12f, 0xe130,
  0xe131, 0xe132, 0xe133, 0xe134, 0xe135, 0xe136, 0xe137, 0xe138,
  0xe139, 0xe13a, 0xe13b, 0xe13c, 0xe13d, 0xe13e, 0xe13f, 0xe140,
  0xe141, 0xe142, 0xe143, 0xe144, 0xe145, 0xe146, 0xe147, 0xe148,
  0xe149, 0xe14a, 0xe14b, 0xe14c, 0xe14d, 0xe14e, 0xe14f, 0xe150,
  0xe151, 0xe152, 0xe153, 0xe154, 0xe155, 0xe156, 0xe157, 0xe158,
  0xe159, 0xe15a, 0xe15b, 0xe15c, 0xe15d, 0xe15e, 0xe15f, 0xe160,
  0xe161, 0xe162, 0xe163, 0xe164, 0xe165, 0xe166, 0xe167, 0xe168,
  0xe169, 0xe16a, 0xe16b, 0xe16c, 0xe16d, 0xe16e, 0xe16f, 0xe170,
  0xe171, 0xe172, 0xe173, 0xe174, 0xe175, 0xe176, 0xe177, 0xe178,
  0xe179, 0xe17a, 0xe17b, 0xe17c, 0xe17d, 0xe17e, 0xe17f, 0xe180,
  0xe181, 0xe182, 0xe183, 0xe184, 0xe185, 0xe186, 0xe187, 0xe188,
  0xe189, 0xe18a, 0xe18b, 0xe18c, 0xe18d, 0xe18e, 0xe18f, 0xe190,
  0xe191, 0xe192, 0xe193, 0xe194, 0xe195, 0xe196, 0xe197, 0xe198,
  0xe199, 0xe19a, 0xe19b, 0xe19c, 0xe19d, 0xe19e, 0xe19f, 0xe1a0,
  0xe1a1, 0xe1a2, 0xe1a3, 0xe1a4, 0xe1a5, 0xe1a6, 0xe1a7, 0xe1a8,
  0xe1a9, 0xe1aa, 0xe1ab, 0xe1ac, 0xe1ad, 0xe1ae, 0xe1af, 0xe1b0,
  0xe1b1, 0xe1b2, 0xe1b3, 0xe1b4, 0xe1b5, 0xe1b6, 0x0000, 0xe1b7,
  0xe1b8, 0xe1b9, 0xe1ba, 0xe1bb, 0xe1bc, 0xe1bd, 0xe1be, 0xe1bf,
  0xe1c0, 0xe1c1, 0xe1c2, 0xe1c3, 0xe1c4, 0xe1c5, 0xe1c6, 0xe1c7,
  0xe1c8, 0xe1c9, 0xe1ca, 0xe1cb, 0xe1cc, 0xe1cd, 0xe1ce, 0xe1cf,
  0xe1d0, 0xe1d1, 0xe1d2, 0xe1d3, 0xe1d4, 0xe1d5, 0xe1d6, 0xe1d7,
  0xe1d8, 0xe1d9, 0xe1da, 0xe1db, 0xe1dc, 0xe1dd, 0xe1de, 0xe1df,
  0xe1e0, 0xe1e1, 0xe1e2, 0xe1e3, 0xe1e4, 0xe1e5, 0xe1e6, 0xe1e7,
  0xe1e8, 0xe1e9, 0xe1ea, 0xe1eb, 0xe1ec, 0xe1ed, 0xe1ee, 0xe1ef,
  0xe1f0, 0xe1f1, 0xe1f2, 0xe1f3, 0xe1f4, 0xe1f5, 0xe1f6, 0xe1f7,
  0xe1f8, 0xe1f9, 0xe1fa, 0xe1fb, 0xe1fc, 0xe1fd, 0xe1fe, 0xe1ff,
  0xe200, 0xe201, 0xe202, 0xe203, 0xe204, 0xe205, 0xe206, 0xe207,
  0xe208, 0xe209, 0xe20a, 0xe20b, 0xe20c, 0xe20d, 0xe20e, 0xe20f,
  0xe210, 0xe211, 0xe212, 0xe213, 0xe214, 0xe215, 0xe216, 0xe217,
  0xe218, 0xe219, 0xe21a, 0xe21b, 0xe21c, 0xe21d, 0xe21e, 0xe21f,
  0xe220, 0xe221, 0xe222, 0xe223, 0xe224, 0xe225, 0xe226, 0xe227,
  0xe228, 0xe229, 0xe22a, 0xe22b, 0xe22c, 0xe22d, 0xe22e, 0xe22f,
  0xe230, 0xe231, 0xe232, 0xe233, 0xe234, 0xe235, 0xe236, 0xe237,
  0xe238, 0xe239, 0xe23a, 0xe23b, 0xe23c, 0xe23d, 0xe23e, 0xe23f,
  0xe240, 0xe241, 0xe242, 0xe243, 0xe244, 0xe245, 0xe246, 0xe247,
  0xe248, 0xe249, 0xe24a, 0xe24b, 0xe24c, 0xe24d, 0xe24e, 0xe24f,
  0xe250, 0xe251, 0xe252, 0xe253, 0xe254, 0xe255, 0xe256, 0xe257,
  0xe258, 0xe259, 0xe25a, 0xe25b, 0xe25c, 0xe25d, 0xe25e, 0xe25f,
  0xe260, 0xe261, 0xe262, 0xe263, 0xe264, 0xe265, 0xe266, 0xe267,
  0xe268, 0xe269, 0xe26a, 0xe26b, 0xe26c, 0xe26d, 0xe26e, 0xe26f,
  0xe270, 0xe271, 0xe272, 0x0000, 0xe273, 0xe274, 0xe275, 0xe276,
  0xe277, 0xe278, 0xe279, 0xe27a, 0xe27b, 0xe27c, 0xe27d, 0xe27e,
  0xe27f, 0xe280, 0xe281, 0xe282, 0xe283, 0xe284, 0xe285, 0xe286,
  0xe287, 0xe288, 0xe289, 0xe28a, 0xe28b, 0xe28c, 0xe28d, 0xe28e,
  0xe28f, 0xe290, 0xe291, 0xe292, 0xe293, 0xe294, 0xe295, 0xe296,
  0xe297, 0xe298, 0xe299, 0xe29a, 0xe29b, 0xe29c, 0xe29d, 0xe29e,
  0xe29f, 0xe2a0, 0xe2a1, 0xe2a2, 0xe2a3, 0xe2a4, 0xe2a5, 0xe2a6,
  0xe2a7, 0xe2a8, 0xe2a9, 0xe2aa, 0xe2ab, 0xe2ac, 0xe2ad, 0xe2ae,
  0xe2af, 0xe2b0, 0xe2b1, 0xe2b2, 0xe2b3, 0xe2b4, 0xe2b5, 0xe2b6,
  0xe2b7, 0xe2b8, 0xe2b9, 0xe2ba, 0xe2bb, 0xe2bc, 0xe2bd, 0xe2be,
  0xe2bf, 0xe2c0, 0xe2c1, 0xe2c2, 0xe2c3, 0xe2c4, 0xe2c5, 0xe2c6,
  0xe2c7, 0xe2c8, 0xe2c9, 0xe2ca, 0xe2cb, 0xe2cc, 0xe2cd, 0xe2ce,
  0xe2cf, 0xe2d0, 0xe2d1, 0xe2d2, 0xe2d3, 0xe2d4, 0xe2d5, 0xe2d6,
  0xe2d7, 0xe2d8, 0xe2d9, 0xe2da, 0xe2db, 0xe2dc, 0xe2dd, 0xe2de,
  0xe2df, 0xe2e0, 0xe2e1, 0xe2e2, 0xe2e3, 0xe2e4, 0xe2e5, 0xe2e6,
  0xe2e7, 0xe2e8, 0xe2e9, 0xe2ea, 0xe2eb, 0xe2ec, 0xe2ed, 0xe2ee,
  0xe2ef, 0xe2f0, 0xe2f1, 0xe2f2, 0xe2f3, 0xe2f4, 0xe2f5, 0xe2f6,
  0xe2f7, 0xe2f8, 0xe2f9, 0xe2fa, 0xe2fb, 0xe2fc, 0xe2fd, 0xe2fe,
  0xe2ff, 0xe300, 0xe301, 0xe302, 0xe303, 0xe304, 0xe305, 0xe306,
  0xe307, 0xe308, 0xe309, 0xe30a, 0xe30b, 0xe30c, 0xe30d, 0xe30e,
  0xe30f, 0xe310, 0xe311, 0xe312, 0xe313, 0xe314, 0xe315, 0xe316,
  0xe317, 0xe318, 0xe319, 0xe31a, 0xe31b, 0xe31c, 0xe31d, 0xe31e,
  0xe31f, 0xe320, 0xe321, 0xe322, 0xe323, 0xe324, 0xe325, 0xe326,
  0xe327, 0xe328, 0xe329, 0xe32a, 0xe32b, 0xe32c, 0xe32d, 0xe32e,
  0x0000, 0xe32f, 0xe330, 0xe331, 0xe332, 0xe333, 0xe334, 0xe335,
  0xe336, 0xe337, 0xe338, 0xe339, 0xe33a, 0xe33b, 0xe33c, 0xe33d,
  0xe33e, 0xe33f, 0xe340, 0xe341, 0xe342, 0xe343, 0xe344, 0xe345,
  0xe346, 0xe347, 0xe348, 0xe349, 0xe34a, 0xe34b, 0xe34c, 0xe34d,
  0xe34e, 0xe34f, 0xe350, 0xe351, 0xe352, 0xe353, 0xe354, 0xe355,
  0xe356, 0xe357, 0xe358, 0xe359, 0xe35a, 0xe35b, 0xe35c, 0xe35d,
  0xe35e, 0xe35f, 0xe360, 0xe361, 0xe362, 0xe363, 0xe364, 0xe365,
  0xe366, 0xe367, 0xe368, 0xe369, 0xe36a, 0xe36b, 0xe36c, 0xe36d,
  0xe36e, 0xe36f, 0xe370, 0xe371, 0xe372, 0xe373, 0xe374, 0xe375,
  0xe376, 0xe377, 0xe378, 0xe379, 0xe37a, 0xe37b, 0xe37c, 0xe37d,
  0xe37e, 0xe37f, 0xe380, 0xe381, 0xe382, 0xe383, 0xe384, 0xe385,
  0xe386, 0xe387, 0xe388, 0xe389, 0xe38a, 0xe38b, 0xe38c, 0xe38d,
  0xe38e, 0xe38f, 0xe390, 0xe391, 0xe392, 0xe393, 0xe394, 0xe395,
  0xe396, 0xe397, 0xe398, 0xe399, 0xe39a, 0xe39b, 0xe39c, 0xe39d,
  0xe39e, 0xe39f, 0xe3a0, 0xe3a1, 0xe3a2, 0xe3a3, 0xe3a4, 0xe3a5,
  0xe3a6, 0xe3a7, 0xe3a8, 0xe3a9, 0xe3aa, 0xe3ab, 0xe3ac, 0xe3ad,
  0xe3ae, 0xe3af, 0xe3b0, 0xe3b1, 0xe3b2, 0xe3b3, 0xe3b4, 0xe3b5,
  0xe3b6, 0xe3b7, 0xe3b8, 0xe3b9, 0xe3ba, 0xe3bb, 0xe3bc, 0xe3bd,
  0xe3be, 0xe3bf, 0xe3c0, 0xe3c1, 0xe3c2, 0xe3c3, 0xe3c4, 0xe3c5,
  0xe3c6, 0xe3c7, 0xe3c8, 0xe3c9, 0xe3ca, 0xe3cb, 0xe3cc, 0xe3cd,
  0xe3ce, 0xe3cf, 0xe3d0, 0xe3d1, 0xe3d2, 0xe3d3, 0xe3d4, 0xe3d5,
  0xe3d6, 0xe3d7, 0xe3d8, 0xe3d9, 0xe3da, 0xe3db, 0xe3dc, 0xe3dd,
  0xe3de, 0xe3df, 0xe3e0, 0xe3e1, 0xe3e2, 0xe3e3, 0xe3e4, 0xe3e5,
  0xe3e6, 0xe3e7, 0xe3e8, 0xe3e9, 0xe3ea, 0x0000, 0xe3eb, 0xe3ec,
  0xe3ed, 0xe3ee, 0xe3ef, 0xe3f0, 0xe3f1, 0xe3f2, 0xe3f3, 0xe3f4,
  0xe3f5, 0xe3f6, 0xe3f7, 0xe3f8, 0xe3f9, 0xe3fa, 0xe3fb, 0xe3fc,
  0xe3fd, 0xe3fe, 0xe3ff, 0xe400, 0xe401, 0xe402, 0xe403, 0xe404,
  0xe405, 0xe406, 0xe407, 0xe408, 0xe409, 0xe40a, 0xe40b, 0xe40c,
  0xe40d, 0xe40e, 0xe40f, 0xe410, 0xe411, 0xe412, 0xe413, 0xe414,
  0xe415, 0xe416, 0xe417, 0xe418, 0xe419, 0xe41a, 0xe41b, 0xe41c,
  0xe41d, 0xe41e, 0xe41f, 0xe420, 0xe421, 0xe422, 0xe423, 0xe424,
  0xe425, 0xe426, 0xe427, 0xe428, 0xe429, 0xe42a, 0xe42b, 0xe42c,
  0xe42d, 0xe42e, 0xe42f, 0xe430, 0xe431, 0xe432, 0xe433, 0xe434,
  0xe435, 0xe436, 0xe437, 0xe438, 0xe439, 0xe43a, 0xe43b, 0xe43c,
  0xe43d, 0xe43e, 0xe43f, 0xe440, 0xe441, 0xe442, 0xe443, 0xe444,
  0xe445, 0xe446, 0xe447, 0xe448, 0xe449, 0xe44a, 0xe44b, 0xe44c,
  0xe44d, 0xe44e, 0xe44f, 0xe450, 0xe451, 0xe452, 0xe453, 0xe454,
  0xe455, 0xe456, 0xe457, 0xe458, 0xe459, 0xe45a, 0xe45b, 0xe45c,
  0xe45d, 0xe45e, 0xe45f, 0xe460, 0xe461, 0xe462, 0xe463, 0xe464,
  0xe465, 0xe466, 0xe467, 0xe468, 0xe469, 0xe46a, 0xe46b, 0xe46c,
  0xe46d, 0xe46e, 0xe46f, 0xe470, 0xe471, 0xe472, 0xe473, 0xe474,
  0xe475, 0xe476, 0xe477, 0xe478, 0xe479, 0xe47a, 0xe47b, 0xe47c,
  0xe47d, 0xe47e, 0xe47f, 0xe480, 0xe481, 0xe482, 0xe483, 0xe484,
  0xe485, 0xe486, 0xe487, 0xe488, 0xe489, 0xe48a, 0xe48b, 0xe48c,
  0xe48d, 0xe48e, 0xe48f, 0xe490, 0xe491, 0xe492, 0xe493, 0xe494,
  0xe495, 0xe496, 0xe497, 0xe498, 0xe499, 0xe49a, 0xe49b, 0xe49c,
  0xe49d, 0xe49e, 0xe49f, 0xe4a0, 0xe4a1, 0xe4a2, 0xe4a3, 0xe4a4,
  0xe4a5, 0xe4a6, 0x0000, 0xe4a7, 0xe4a8, 0xe4a9, 0xe4aa, 0xe4ab,
  0xe4ac, 0xe4ad, 0xe4ae, 0xe4af, 0xe4b0, 0xe4b1, 0xe4b2, 0xe4b3,
  0xe4b4, 0xe4b5, 0xe4b6, 0xe4b7, 0xe4b8, 0xe4b9, 0xe4ba, 0xe4bb,
  0xe4bc, 0xe4bd, 0xe4be, 0xe4bf, 0xe4c0, 0xe4c1, 0xe4c2, 0xe4c3,
  0xe4c4, 0xe4c5, 0xe4c6, 0xe4c7, 0xe4c8, 0xe4c9, 0xe4ca, 0xe4cb,
  0xe4cc, 0xe4cd, 0xe4ce, 0xe4cf, 0xe4d0, 0xe4d1, 0xe4d2, 0xe4d3,
  0xe4d4, 0xe4d5, 0xe4d6, 0xe4d7, 0xe4d8, 0xe4d9, 0xe4da, 0xe4db,
  0xe4dc, 0xe4dd, 0xe4de, 0xe4df, 0xe4e0, 0xe4e1, 0xe4e2, 0xe4e3,
  0xe4e4, 0xe4e5, 0xe4e6, 0xe4e7, 0xe4e8, 0xe4e9, 0xe4ea, 0xe4eb,
  0xe4ec, 0xe4ed, 0xe4ee, 0xe4ef, 0xe4f0, 0xe4f1, 0xe4f2, 0xe4f3,
  0xe4f4, 0xe4f5, 0xe4f6, 0xe4f7, 0xe4f8, 0xe4f9, 0xe4fa, 0xe4fb,
  0xe4fc, 0xe4fd, 0xe4fe, 0xe4ff, 0xe500, 0xe501, 0xe502, 0xe503,
  0xe504, 0xe505, 0xe506, 0xe507, 0xe508, 0xe509, 0xe50a, 0xe50b,
  0xe50c, 0xe50d, 0xe50e, 0xe50f, 0xe510, 0xe511, 0xe512, 0xe513,
  0xe514, 0xe515, 0xe516, 0xe517, 0xe518, 0xe519, 0xe51a, 0xe51b,
  0xe51c, 0xe51d, 0xe51e, 0xe51f, 0xe520, 0xe521, 0xe522, 0xe523,
  0xe524, 0xe525, 0xe526, 0xe527, 0xe528, 0xe529, 0xe52a, 0xe52b,
  0xe52c, 0xe52d, 0xe52e, 0xe52f, 0xe530, 0xe531, 0xe532, 0xe533,
  0xe534, 0xe535, 0xe536, 0xe537, 0xe538, 0xe539, 0xe53a, 0xe53b,
  0xe53c, 0xe53d, 0xe53e, 0xe53f, 0xe540, 0xe541, 0xe542, 0xe543,
  0xe544, 0xe545, 0xe546, 0xe547, 0xe548, 0xe549, 0xe54a, 0xe54b,
  0xe54c, 0xe54d, 0xe54e, 0xe54f, 0xe550, 0xe551, 0xe552, 0xe553,
  0xe554, 0xe555, 0xe556, 0xe557, 0xe558, 0xe559, 0xe55a, 0xe55b,
  0xe55c, 0xe55d, 0xe55e, 0xe55f, 0xe560, 0xe561, 0xe562, 0x0000,
  0xe563, 0xe564, 0xe565, 0xe566, 0xe567, 0xe568, 0xe569, 0xe56a,
  0xe56b, 0xe56c, 0xe56d, 0xe56e, 0xe56f, 0xe570, 0xe571, 0xe572,
  0xe573, 0xe574, 0xe575, 0xe576, 0xe577, 0xe578, 0xe579, 0xe57a,
  0xe57b, 0xe57c, 0xe57d, 0xe57e, 0xe57f, 0xe580, 0xe581, 0xe582,
  0xe583, 0xe584, 0xe585, 0xe586, 0xe587, 0xe588, 0xe589, 0xe58a,
  0xe58b, 0xe58c, 0xe58d, 0xe58e, 0xe58f, 0xe590, 0xe591, 0xe592,
  0xe593, 0xe594, 0xe595, 0xe596, 0xe597, 0xe598, 0xe599, 0xe59a,
  0xe59b, 0xe59c, 0xe59d, 0xe59e, 0xe59f, 0xe5a0, 0xe5a1, 0xe5a2,
  0xe5a3, 0xe5a4, 0xe5a5, 0xe5a6, 0xe5a7, 0xe5a8, 0xe5a9, 0xe5aa,
  0xe5ab, 0xe5ac, 0xe5ad, 0xe5ae, 0xe5af, 0xe5b0, 0xe5b1, 0xe5b2,
  0xe5b3, 0xe5b4, 0xe5b5, 0xe5b6, 0xe5b7, 0xe5b8, 0xe5b9, 0xe5ba,
  0xe5bb, 0xe5bc, 0xe5bd, 0xe5be, 0xe5bf, 0xe5c0, 0xe5c1, 0xe5c2,
  0xe5c3, 0xe5c4, 0xe5c5, 0xe5c6, 0xe5c7, 0xe5c8, 0xe5c9, 0xe5ca,
  0xe5cb, 0xe5cc, 0xe5cd, 0xe5ce, 0xe5cf, 0xe5d0, 0xe5d1, 0xe5d2,
  0xe5d3, 0xe5d4, 0xe5d5, 0xe5d6, 0xe5d7, 0xe5d8, 0xe5d9, 0xe5da,
  0xe5db, 0xe5dc, 0xe5dd, 0xe5de, 0xe5df, 0xe5e0, 0xe5e1, 0xe5e2,
  0xe5e3, 0xe5e4, 0xe5e5, 0xe5e6, 0xe5e7, 0xe5e8, 0xe5e9, 0xe5ea,
  0xe5eb, 0xe5ec, 0xe5ed, 0xe5ee, 0xe5ef, 0xe5f0, 0xe5f1, 0xe5f2,
  0xe5f3, 0xe5f4, 0xe5f5, 0xe5f6, 0xe5f7, 0xe5f8, 0xe5f9, 0xe5fa,
  0xe5fb, 0xe5fc, 0xe5fd, 0xe5fe, 0xe5ff, 0xe600, 0xe601, 0xe602,
  0xe603, 0xe604, 0xe605, 0xe606, 0xe607, 0xe608, 0xe609, 0xe60a,
  0xe60b, 0xe60c, 0xe60d, 0xe60e, 0xe60f, 0xe610, 0xe611, 0xe612,
  0xe613, 0xe614, 0xe615, 0xe616, 0xe617, 0xe618, 0xe619, 0xe61a,
  0xe61b, 0xe61c, 0xe61d, 0xe61e, 0x0000, 0xe61f, 0xe620, 0xe621,
  0xe622, 0xe623, 0xe624, 0xe625, 0xe626, 0xe627, 0xe628, 0xe629,
  0xe62a, 0xe62b, 0xe62c, 0xe62d, 0xe62e, 0xe62f, 0xe630, 0xe631,
  0xe632, 0xe633, 0xe634, 0xe635, 0xe636, 0xe637, 0xe638, 0xe639,
  0xe63a, 0xe63b, 0xe63c, 0xe63d, 0xe63e, 0xe63f, 0xe640, 0xe641,
  0xe642, 0xe643, 0xe644, 0xe645, 0xe646, 0xe647, 0xe648, 0xe649,
  0xe64a, 0xe64b, 0xe64c, 0xe64d, 0xe64e, 0xe64f, 0xe650, 0xe651,
  0xe652, 0xe653, 0xe654, 0xe655, 0xe656, 0xe657, 0xe658, 0xe659,
  0xe65a, 0xe65b, 0xe65c, 0xe65d, 0xe65e, 0xe65f, 0xe660, 0xe661,
  0xe662, 0xe663, 0xe664, 0xe665, 0xe666, 0xe667, 0xe668, 0xe669,
  0xe66a, 0xe66b, 0xe66c, 0xe66d, 0xe66e, 0xe66f, 0xe670, 0xe671,
  0xe672, 0xe673, 0xe674, 0xe675, 0xe676, 0xe677, 0xe678, 0xe679,
  0xe67a, 0xe67b, 0xe67c, 0xe67d, 0xe67e, 0xe67f, 0xe680, 0xe681,
  0xe682, 0xe683, 0xe684, 0xe685, 0xe686, 0xe687, 0xe688, 0xe689,
  0xe68a, 0xe68b, 0xe68c, 0xe68d, 0xe68e, 0xe68f, 0xe690, 0xe691,
  0xe692, 0xe693, 0xe694, 0xe695, 0xe696, 0xe697, 0xe698, 0xe699,
  0xe69a, 0xe69b, 0xe69c, 0xe69d, 0xe69e, 0xe69f, 0xe6a0, 0xe6a1,
  0xe6a2, 0xe6a3, 0xe6a4, 0xe6a5, 0xe6a6, 0xe6a7, 0xe6a8, 0xe6a9,
  0xe6aa, 0xe6ab, 0xe6ac, 0xe6ad, 0xe6ae, 0xe6af, 0xe6b0, 0xe6b1,
  0xe6b2, 0xe6b3, 0xe6b4, 0xe6b5, 0xe6b6, 0xe6b7, 0xe6b8, 0xe6b9,
  0xe6ba, 0xe6bb, 0xe6bc, 0xe6bd, 0xe6be, 0xe6bf, 0xe6c0, 0xe6c1,
  0xe6c2, 0xe6c3, 0xe6c4, 0xe6c5, 0xe6c6, 0xe6c7, 0xe6c8, 0xe6c9,
  0xe6ca, 0xe6cb, 0xe6cc, 0xe6cd, 0xe6ce, 0xe6cf, 0xe6d0, 0xe6d1,
  0xe6d2, 0xe6d3, 0xe6d4, 0xe6d5, 0xe6d6, 0xe6d7, 0xe6d8, 0xe6d9,
  0xe6da, 0x0000, 0xe6db, 0xe6dc, 0xe6dd, 0xe6de, 0xe6df, 0xe6e0,
  0xe6e1, 0xe6e2, 0xe6e3, 0xe6e4, 0xe6e5, 0xe6e6, 0xe6e7, 0xe6e8,
  0xe6e9, 0xe6ea, 0xe6eb, 0xe6ec, 0xe6ed, 0xe6ee, 0xe6ef, 0xe6f0,
  0xe6f1, 0xe6f2, 0xe6f3, 0xe6f4, 0xe6f5, 0xe6f6, 0xe6f7, 0xe6f8,
  0xe6f9, 0xe6fa, 0xe6fb, 0xe6fc, 0xe6fd, 0xe6fe, 0xe6ff, 0xe700,
  0xe701, 0xe702, 0xe703, 0xe704, 0xe705, 0xe706, 0xe707, 0xe708,
  0xe709, 0xe70a, 0xe70b, 0xe70c, 0xe70d, 0xe70e, 0xe70f, 0xe710,
  0xe711, 0xe712, 0xe713, 0xe714, 0xe715, 0xe716, 0xe717, 0xe718,
  0xe719, 0xe71a, 0xe71b, 0xe71c, 0xe71d, 0xe71e, 0xe71f, 0xe720,
  0xe721, 0xe722, 0xe723, 0xe724, 0xe725, 0xe726, 0xe727, 0xe728,
  0xe729, 0xe72a, 0xe72b, 0xe72c, 0xe72d, 0xe72e, 0xe72f, 0xe730,
  0xe731, 0xe732, 0xe733, 0xe734, 0xe735, 0xe736, 0xe737, 0xe738,
  0xe739, 0xe73a, 0xe73b, 0xe73c, 0xe73d, 0xe73e, 0xe73f, 0xe740,
  0xe741, 0xe742, 0xe743, 0xe744, 0xe745, 0xe746, 0xe747, 0xe748,
  0xe749, 0xe74a, 0xe74b, 0xe74c, 0xe74d, 0xe74e, 0xe74f, 0xe750,
  0xe751, 0xe752, 0xe753, 0xe754, 0xe755, 0xe756, 0xe757, 0x2170,
  0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178,
  0x2179, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166,
  0x2167, 0x2168, 0x2169, 0xffe2, 0x00a6, 0xff07, 0xff02, 0x3231,
  0x2116, 0x2121, 0x2235, 0x7e8a, 0x891c, 0x9348, 0x9288, 0x84dc,
  0x4fc9, 0x70bb, 0x6631, 0x68c8, 0x92f9, 0x66fb, 0x5f45, 0x4e28,
  0x4ee1, 0x4efc, 0x4f00, 0x4f03, 0x4f39, 0x4f56, 0x4f92, 0x4f8a,
  0x4f9a, 0x4f94, 0x4fcd, 0x5040, 0x5022, 0x4fff, 0x501e, 0x5046,
  0x5070, 0x5042, 0x5094, 0x50f4, 0x50d8, 0x514a, 0x0000, 0x5164,
  0x519d, 0x51be, 0x51ec, 0x5215, 0x529c, 0x52a6, 0x52c0, 0x52db,
  0x5300, 0x5307, 0x5324, 0x5372, 0x5393, 0x53b2, 0x53dd, 0xfa0e,
  0x549c, 0x548a, 0x54a9, 0x54ff, 0x5586, 0x5759, 0x5765, 0x57ac,
  0x57c8, 0x57c7, 0xfa0f, 0xfa10, 0x589e, 0x58b2, 0x590b, 0x5953,
  0x595b, 0x595d, 0x5963, 0x59a4, 0x59ba, 0x5b56, 0x5bc0, 0x752f,
  0x5bd8, 0x5bec, 0x5c1e, 0x5ca6, 0x5cba, 0x5cf5, 0x5d27, 0x5d53,
  0xfa11, 0x5d42, 0x5d6d, 0x5db8, 0x5db9, 0x5dd0, 0x5f21, 0x5f34,
  0x5f67, 0x5fb7, 0x5fde, 0x605d, 0x6085, 0x608a, 0x60de, 0x60d5,
  0x6120, 0x60f2, 0x6111, 0x6137, 0x6130, 0x6198, 0x6213, 0x62a6,
  0x63f5, 0x6460, 0x649d, 0x64ce, 0x654e, 0x6600, 0x6615, 0x663b,
  0x6609, 0x662e, 0x661e, 0x6624, 0x6665, 0x6657, 0x6659, 0xfa12,
  0x6673, 0x6699, 0x66a0, 0x66b2, 0x66bf, 0x66fa, 0x670e, 0xf929,
  0x6766, 0x67bb, 0x6852, 0x67c0, 0x6801, 0x6844, 0x68cf, 0xfa13,
  0x6968, 0xfa14, 0x6998, 0x69e2, 0x6a30, 0x6a6b, 0x6a46, 0x6a73,
  0x6a7e, 0x6ae2, 0x6ae4, 0x6bd6, 0x6c3f, 0x6c5c, 0x6c86, 0x6c6f,
  0x6cda, 0x6d04, 0x6d87, 0x6d6f, 0x6d96, 0x6dac, 0x6dcf, 0x6df8,
  0x6df2, 0x6dfc, 0x6e39, 0x6e5c, 0x6e27, 0x6e3c, 0x6ebf, 0x6f88,
  0x6fb5, 0x6ff5, 0x7005, 0x7007, 0x7028, 0x7085, 0x70ab, 0x710f,
  0x7104, 0x715c, 0x7146, 0x7147, 0xfa15, 0x71c1, 0x71fe, 0x72b1,
  0x72be, 0x7324, 0xfa16, 0x7377, 0x73bd, 0x73c9, 0x73d6, 0x73e3,
  0x73d2, 0x7407, 0x73f5, 0x7426, 0x742a, 0x7429, 0x742e, 0x7462,
  0x7489, 0x749f, 0x7501, 0x756f, 0x7682, 0x769c, 0x769e, 0x769b,
  0x76a6, 0xfa17, 0x7746, 0x52af, 0x7821, 0x784e, 0x7864, 0x787a,
  0x7930, 0xfa18, 0xfa19, 0x0000, 0xfa1a, 0x7994, 0xfa1b, 0x799b,
  0x7ad1, 0x7ae7, 0xfa1c, 0x7aeb, 0x7b9e, 0xfa1d, 0x7d48, 0x7d5c,
  0x7db7, 0x7da0, 0x7dd6, 0x7e52, 0x7f47, 0x7fa1, 0xfa1e, 0x8301,
  0x8362, 0x837f, 0x83c7, 0x83f6, 0x8448, 0x84b4, 0x8553, 0x8559,
  0x856b, 0xfa1f, 0x85b0, 0xfa20, 0xfa21, 0x8807, 0x88f5, 0x8a12,
  0x8a37, 0x8a79, 0x8aa7, 0x8abe, 0x8adf, 0xfa22, 0x8af6, 0x8b53,
  0x8b7f, 0x8cf0, 0x8cf4, 0x8d12, 0x8d76, 0xfa23, 0x8ecf, 0xfa24,
  0xfa25, 0x9067, 0x90de, 0xfa26, 0x9115, 0x9127, 0x91da, 0x91d7,
  0x91de, 0x91ed, 0x91ee, 0x91e4, 0x91e5, 0x9206, 0x9210, 0x920a,
  0x923a, 0x9240, 0x923c, 0x924e, 0x9259, 0x9251, 0x9239, 0x9267,
  0x92a7, 0x9277, 0x9278, 0x92e7, 0x92d7, 0x92d9, 0x92d0, 0xfa27,
  0x92d5, 0x92e0, 0x92d3, 0x9325, 0x9321, 0x92fb, 0xfa28, 0x931e,
  0x92ff, 0x931d, 0x9302, 0x9370, 0x9357, 0x93a4, 0x93c6, 0x93de,
  0x93f8, 0x9431, 0x9445, 0x9448, 0x9592, 0xf9dc, 0xfa29, 0x969d,
  0x96af, 0x9733, 0x973b, 0x9743, 0x974d, 0x974f, 0x9751, 0x9755,
  0x9857, 0x9865, 0xfa2a, 0xfa2b, 0x9927, 0xfa2c, 0x999e, 0x9a4e,
  0x9ad9, 0x9adc, 0x9b75, 0x9b72, 0x9b8f, 0x9bb1, 0x9bbb, 0x9c00,
  0x9d70, 0x9d6b, 0xfa2d, 0x9e19, 0x9ed1
};

static const struct gap __ucs4_to_ibm943sb_idx[] =
{
  { .start = 0x0000, .end = 0x00ff, .idx =      0 },
  { .start = 0x203e, .end = 0x203e, .idx =  -7998 },
  { .start = 0xff61, .end = 0xff9f, .idx = -65120 },
  { .start = 0xffff, .end = 0xffff, .idx =      0 }
};

static const char __ucs4_to_ibm943sb[] =
{
  '\x00', '\x01', '\x02', '\x03', '\x04', '\x05', '\x06', '\x07',
  '\x08', '\x09', '\x0a', '\x0b', '\x0c', '\x0d', '\x0e', '\x0f',
  '\x10', '\x11', '\x12', '\x13', '\x14', '\x15', '\x16', '\x17',
  '\x18', '\x19', '\x7f', '\x1b', '\x1a', '\x1d', '\x1e', '\x1f',
  '\x20', '\x21', '\x22', '\x23', '\x24', '\x25', '\x26', '\x27',
  '\x28', '\x29', '\x2a', '\x2b', '\x2c', '\x2d', '\x2e', '\x2f',
  '\x30', '\x31', '\x32', '\x33', '\x34', '\x35', '\x36', '\x37',
  '\x38', '\x39', '\x3a', '\x3b', '\x3c', '\x3d', '\x3e', '\x3f',
  '\x40', '\x41', '\x42', '\x43', '\x44', '\x45', '\x46', '\x47',
  '\x48', '\x49', '\x4a', '\x4b', '\x4c', '\x4d', '\x4e', '\x4f',
  '\x50', '\x51', '\x52', '\x53', '\x54', '\x55', '\x56', '\x57',
  '\x58', '\x59', '\x5a', '\x5b', '\x7f', '\x5d', '\x5e', '\x5f',
  '\x60', '\x61', '\x62', '\x63', '\x64', '\x65', '\x66', '\x67',
  '\x68', '\x69', '\x6a', '\x6b', '\x6c', '\x6d', '\x6e', '\x6f',
  '\x70', '\x71', '\x72', '\x73', '\x74', '\x75', '\x76', '\x77',
  '\x78', '\x79', '\x7a', '\x7b', '\x7c', '\x7d', '\x7f', '\x1c',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x5c', '\x00', '\x00',
  '\x00', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x00', '\x00', '\x7f', '\x7f', '\x00', '\x7f', '\x00', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x00',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x00',
  '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f', '\x7f',
  '\x7e', '\xa1', '\xa2', '\xa3', '\xa4', '\xa5', '\xa6', '\xa7',
  '\xa8', '\xa9', '\xaa', '\xab', '\xac', '\xad', '\xae', '\xaf',
  '\xb0', '\xb1', '\xb2', '\xb3', '\xb4', '\xb5', '\xb6', '\xb7',
  '\xb8', '\xb9', '\xba', '\xbb', '\xbc', '\xbd', '\xbe', '\xbf',
  '\xc0', '\xc1', '\xc2', '\xc3', '\xc4', '\xc5', '\xc6', '\xc7',
  '\xc8', '\xc9', '\xca', '\xcb', '\xcc', '\xcd', '\xce', '\xcf',
  '\xd0', '\xd1', '\xd2', '\xd3', '\xd4', '\xd5', '\xd6', '\xd7',
  '\xd8', '\xd9', '\xda', '\xdb', '\xdc', '\xdd', '\xde', '\xdf'
};

static const unsigned short int __ucs4_to_ibm943db[][2] =
{
    {0x00a6, 0xfa55}, {0x00a7, 0x8198}, {0x00a8, 0x814e}, {0x00b0, 0x818b},
    {0x00b1, 0x817d}, {0x00b4, 0x814c}, {0x00b6, 0x81f7}, {0x00d7, 0x817e},
    {0x00f7, 0x8180}, {0x0391, 0x839f}, {0x0392, 0x83a0}, {0x0393, 0x83a1},
    {0x0394, 0x83a2}, {0x0395, 0x83a3}, {0x0396, 0x83a4}, {0x0397, 0x83a5},
    {0x0398, 0x83a6}, {0x0399, 0x83a7}, {0x039a, 0x83a8}, {0x039b, 0x83a9},
    {0x039c, 0x83aa}, {0x039d, 0x83ab}, {0x039e, 0x83ac}, {0x039f, 0x83ad},
    {0x03a0, 0x83ae}, {0x03a1, 0x83af}, {0x03a3, 0x83b0}, {0x03a4, 0x83b1},
    {0x03a5, 0x83b2}, {0x03a6, 0x83b3}, {0x03a7, 0x83b4}, {0x03a8, 0x83b5},
    {0x03a9, 0x83b6}, {0x03b1, 0x83bf}, {0x03b2, 0x83c0}, {0x03b3, 0x83c1},
    {0x03b4, 0x83c2}, {0x03b5, 0x83c3}, {0x03b6, 0x83c4}, {0x03b7, 0x83c5},
    {0x03b8, 0x83c6}, {0x03b9, 0x83c7}, {0x03ba, 0x83c8}, {0x03bb, 0x83c9},
    {0x03bc, 0x83ca}, {0x03bd, 0x83cb}, {0x03be, 0x83cc}, {0x03bf, 0x83cd},
    {0x03c0, 0x83ce}, {0x03c1, 0x83cf}, {0x03c3, 0x83d0}, {0x03c4, 0x83d1},
    {0x03c5, 0x83d2}, {0x03c6, 0x83d3}, {0x03c7, 0x83d4}, {0x03c8, 0x83d5},
    {0x03c9, 0x83d6}, {0x0401, 0x8446}, {0x0410, 0x8440}, {0x0411, 0x8441},
    {0x0412, 0x8442}, {0x0413, 0x8443}, {0x0414, 0x8444}, {0x0415, 0x8445},
    {0x0416, 0x8447}, {0x0417, 0x8448}, {0x0418, 0x8449}, {0x0419, 0x844a},
    {0x041a, 0x844b}, {0x041b, 0x844c}, {0x041c, 0x844d}, {0x041d, 0x844e},
    {0x041e, 0x844f}, {0x041f, 0x8450}, {0x0420, 0x8451}, {0x0421, 0x8452},
    {0x0422, 0x8453}, {0x0423, 0x8454}, {0x0424, 0x8455}, {0x0425, 0x8456},
    {0x0426, 0x8457}, {0x0427, 0x8458}, {0x0428, 0x8459}, {0x0429, 0x845a},
    {0x042a, 0x845b}, {0x042b, 0x845c}, {0x042c, 0x845d}, {0x042d, 0x845e},
    {0x042e, 0x845f}, {0x042f, 0x8460}, {0x0430, 0x8470}, {0x0431, 0x8471},
    {0x0432, 0x8472}, {0x0433, 0x8473}, {0x0434, 0x8474}, {0x0435, 0x8475},
    {0x0436, 0x8477}, {0x0437, 0x8478}, {0x0438, 0x8479}, {0x0439, 0x847a},
    {0x043a, 0x847b}, {0x043b, 0x847c}, {0x043c, 0x847d}, {0x043d, 0x847e},
    {0x043e, 0x8480}, {0x043f, 0x8481}, {0x0440, 0x8482}, {0x0441, 0x8483},
    {0x0442, 0x8484}, {0x0443, 0x8485}, {0x0444, 0x8486}, {0x0445, 0x8487},
    {0x0446, 0x8488}, {0x0447, 0x8489}, {0x0448, 0x848a}, {0x0449, 0x848b},
    {0x044a, 0x848c}, {0x044b, 0x848d}, {0x044c, 0x848e}, {0x044d, 0x848f},
    {0x044e, 0x8490}, {0x044f, 0x8491}, {0x0451, 0x8476}, {0x2010, 0x815d},
    {0x2014, 0x815c}, {0x2015, 0x815c}, {0x2016, 0x8161}, {0x2018, 0x8165},
    {0x2019, 0x8166}, {0x201c, 0x8167}, {0x201d, 0x8168}, {0x2020, 0x81f5},
    {0x2021, 0x81f6}, {0x2025, 0x8164}, {0x2026, 0x8163}, {0x2030, 0x81f1},
    {0x2032, 0x818c}, {0x2033, 0x818d}, {0x203b, 0x81a6}, {0x2103, 0x818e},
    {0x2116, 0xfa59}, {0x2121, 0xfa5a}, {0x212b, 0x81f0}, {0x2160, 0xfa4a},
    {0x2161, 0xfa4b}, {0x2162, 0xfa4c}, {0x2163, 0xfa4d}, {0x2164, 0xfa4e},
    {0x2165, 0xfa4f}, {0x2166, 0xfa50}, {0x2167, 0xfa51}, {0x2168, 0xfa52},
    {0x2169, 0xfa53}, {0x2170, 0xfa40}, {0x2171, 0xfa41}, {0x2172, 0xfa42},
    {0x2173, 0xfa43}, {0x2174, 0xfa44}, {0x2175, 0xfa45}, {0x2176, 0xfa46},
    {0x2177, 0xfa47}, {0x2178, 0xfa48}, {0x2179, 0xfa49}, {0x2190, 0x81a9},
    {0x2191, 0x81aa}, {0x2192, 0x81a8}, {0x2193, 0x81ab}, {0x21d2, 0x81cb},
    {0x21d4, 0x81cc}, {0x2200, 0x81cd}, {0x2202, 0x81dd}, {0x2203, 0x81ce},
    {0x2207, 0x81de}, {0x2208, 0x81b8}, {0x220b, 0x81b9}, {0x2211, 0x8794},
    {0x2212, 0x817c}, {0x221a, 0x81e3}, {0x221d, 0x81e5}, {0x221e, 0x8187},
    {0x221f, 0x8798}, {0x2220, 0x81da}, {0x2225, 0x8161}, {0x2227, 0x81c8},
    {0x2228, 0x81c9}, {0x2229, 0x81bf}, {0x222a, 0x81be}, {0x222b, 0x81e7},
    {0x222c, 0x81e8}, {0x222e, 0x8793}, {0x2234, 0x8188}, {0x2235, 0x81e6},
    {0x223d, 0x81e4}, {0x2252, 0x81e0}, {0x2260, 0x8182}, {0x2261, 0x81df},
    {0x2266, 0x8185}, {0x2267, 0x8186}, {0x226a, 0x81e1}, {0x226b, 0x81e2},
    {0x2282, 0x81bc}, {0x2283, 0x81bd}, {0x2286, 0x81ba}, {0x2287, 0x81bb},
    {0x22a5, 0x81db}, {0x22bf, 0x8799}, {0x2312, 0x81dc}, {0x2460, 0x8740},
    {0x2461, 0x8741}, {0x2462, 0x8742}, {0x2463, 0x8743}, {0x2464, 0x8744},
    {0x2465, 0x8745}, {0x2466, 0x8746}, {0x2467, 0x8747}, {0x2468, 0x8748},
    {0x2469, 0x8749}, {0x246a, 0x874a}, {0x246b, 0x874b}, {0x246c, 0x874c},
    {0x246d, 0x874d}, {0x246e, 0x874e}, {0x246f, 0x874f}, {0x2470, 0x8750},
    {0x2471, 0x8751}, {0x2472, 0x8752}, {0x2473, 0x8753}, {0x2500, 0x849f},
    {0x2501, 0x84aa}, {0x2502, 0x84a0}, {0x2503, 0x84ab}, {0x250c, 0x84a1},
    {0x250f, 0x84ac}, {0x2510, 0x84a2}, {0x2513, 0x84ad}, {0x2514, 0x84a4},
    {0x2517, 0x84af}, {0x2518, 0x84a3}, {0x251b, 0x84ae}, {0x251c, 0x84a5},
    {0x251d, 0x84ba}, {0x2520, 0x84b5}, {0x2523, 0x84b0}, {0x2524, 0x84a7},
    {0x2525, 0x84bc}, {0x2528, 0x84b7}, {0x252b, 0x84b2}, {0x252c, 0x84a6},
    {0x252f, 0x84b6}, {0x2530, 0x84bb}, {0x2533, 0x84b1}, {0x2534, 0x84a8},
    {0x2537, 0x84b8}, {0x2538, 0x84bd}, {0x253b, 0x84b3}, {0x253c, 0x84a9},
    {0x253f, 0x84b9}, {0x2542, 0x84be}, {0x254b, 0x84b4}, {0x25a0, 0x81a1},
    {0x25a1, 0x81a0}, {0x25b2, 0x81a3}, {0x25b3, 0x81a2}, {0x25bc, 0x81a5},
    {0x25bd, 0x81a4}, {0x25c6, 0x819f}, {0x25c7, 0x819e}, {0x25cb, 0x819b},
    {0x25ce, 0x819d}, {0x25cf, 0x819c}, {0x25ef, 0x81fc}, {0x2605, 0x819a},
    {0x2606, 0x8199}, {0x2640, 0x818a}, {0x2642, 0x8189}, {0x266a, 0x81f4},
    {0x266d, 0x81f3}, {0x266f, 0x81f2}, {0x3000, 0x8140}, {0x3001, 0x8141},
    {0x3002, 0x8142}, {0x3003, 0x8156}, {0x3005, 0x8158}, {0x3006, 0x8159},
    {0x3007, 0x815a}, {0x3008, 0x8171}, {0x3009, 0x8172}, {0x300a, 0x8173},
    {0x300b, 0x8174}, {0x300c, 0x8175}, {0x300d, 0x8176}, {0x300e, 0x8177},
    {0x300f, 0x8178}, {0x3010, 0x8179}, {0x3011, 0x817a}, {0x3012, 0x81a7},
    {0x3013, 0x81ac}, {0x3014, 0x816b}, {0x3015, 0x816c}, {0x301c, 0x8160},
    {0x301d, 0x8780}, {0x301f, 0x8781}, {0x3041, 0x829f}, {0x3042, 0x82a0},
    {0x3043, 0x82a1}, {0x3044, 0x82a2}, {0x3045, 0x82a3}, {0x3046, 0x82a4},
    {0x3047, 0x82a5}, {0x3048, 0x82a6}, {0x3049, 0x82a7}, {0x304a, 0x82a8},
    {0x304b, 0x82a9}, {0x304c, 0x82aa}, {0x304d, 0x82ab}, {0x304e, 0x82ac},
    {0x304f, 0x82ad}, {0x3050, 0x82ae}, {0x3051, 0x82af}, {0x3052, 0x82b0},
    {0x3053, 0x82b1}, {0x3054, 0x82b2}, {0x3055, 0x82b3}, {0x3056, 0x82b4},
    {0x3057, 0x82b5}, {0x3058, 0x82b6}, {0x3059, 0x82b7}, {0x305a, 0x82b8},
    {0x305b, 0x82b9}, {0x305c, 0x82ba}, {0x305d, 0x82bb}, {0x305e, 0x82bc},
    {0x305f, 0x82bd}, {0x3060, 0x82be}, {0x3061, 0x82bf}, {0x3062, 0x82c0},
    {0x3063, 0x82c1}, {0x3064, 0x82c2}, {0x3065, 0x82c3}, {0x3066, 0x82c4},
    {0x3067, 0x82c5}, {0x3068, 0x82c6}, {0x3069, 0x82c7}, {0x306a, 0x82c8},
    {0x306b, 0x82c9}, {0x306c, 0x82ca}, {0x306d, 0x82cb}, {0x306e, 0x82cc},
    {0x306f, 0x82cd}, {0x3070, 0x82ce}, {0x3071, 0x82cf}, {0x3072, 0x82d0},
    {0x3073, 0x82d1}, {0x3074, 0x82d2}, {0x3075, 0x82d3}, {0x3076, 0x82d4},
    {0x3077, 0x82d5}, {0x3078, 0x82d6}, {0x3079, 0x82d7}, {0x307a, 0x82d8},
    {0x307b, 0x82d9}, {0x307c, 0x82da}, {0x307d, 0x82db}, {0x307e, 0x82dc},
    {0x307f, 0x82dd}, {0x3080, 0x82de}, {0x3081, 0x82df}, {0x3082, 0x82e0},
    {0x3083, 0x82e1}, {0x3084, 0x82e2}, {0x3085, 0x82e3}, {0x3086, 0x82e4},
    {0x3087, 0x82e5}, {0x3088, 0x82e6}, {0x3089, 0x82e7}, {0x308a, 0x82e8},
    {0x308b, 0x82e9}, {0x308c, 0x82ea}, {0x308d, 0x82eb}, {0x308e, 0x82ec},
    {0x308f, 0x82ed}, {0x3090, 0x82ee}, {0x3091, 0x82ef}, {0x3092, 0x82f0},
    {0x3093, 0x82f1}, {0x309b, 0x814a}, {0x309c, 0x814b}, {0x309d, 0x8154},
    {0x309e, 0x8155}, {0x30a1, 0x8340}, {0x30a2, 0x8341}, {0x30a3, 0x8342},
    {0x30a4, 0x8343}, {0x30a5, 0x8344}, {0x30a6, 0x8345}, {0x30a7, 0x8346},
    {0x30a8, 0x8347}, {0x30a9, 0x8348}, {0x30aa, 0x8349}, {0x30ab, 0x834a},
    {0x30ac, 0x834b}, {0x30ad, 0x834c}, {0x30ae, 0x834d}, {0x30af, 0x834e},
    {0x30b0, 0x834f}, {0x30b1, 0x8350}, {0x30b2, 0x8351}, {0x30b3, 0x8352},
    {0x30b4, 0x8353}, {0x30b5, 0x8354}, {0x30b6, 0x8355}, {0x30b7, 0x8356},
    {0x30b8, 0x8357}, {0x30b9, 0x8358}, {0x30ba, 0x8359}, {0x30bb, 0x835a},
    {0x30bc, 0x835b}, {0x30bd, 0x835c}, {0x30be, 0x835d}, {0x30bf, 0x835e},
    {0x30c0, 0x835f}, {0x30c1, 0x8360}, {0x30c2, 0x8361}, {0x30c3, 0x8362},
    {0x30c4, 0x8363}, {0x30c5, 0x8364}, {0x30c6, 0x8365}, {0x30c7, 0x8366},
    {0x30c8, 0x8367}, {0x30c9, 0x8368}, {0x30ca, 0x8369}, {0x30cb, 0x836a},
    {0x30cc, 0x836b}, {0x30cd, 0x836c}, {0x30ce, 0x836d}, {0x30cf, 0x836e},
    {0x30d0, 0x836f}, {0x30d1, 0x8370}, {0x30d2, 0x8371}, {0x30d3, 0x8372},
    {0x30d4, 0x8373}, {0x30d5, 0x8374}, {0x30d6, 0x8375}, {0x30d7, 0x8376},
    {0x30d8, 0x8377}, {0x30d9, 0x8378}, {0x30da, 0x8379}, {0x30db, 0x837a},
    {0x30dc, 0x837b}, {0x30dd, 0x837c}, {0x30de, 0x837d}, {0x30df, 0x837e},
    {0x30e0, 0x8380}, {0x30e1, 0x8381}, {0x30e2, 0x8382}, {0x30e3, 0x8383},
    {0x30e4, 0x8384}, {0x30e5, 0x8385}, {0x30e6, 0x8386}, {0x30e7, 0x8387},
    {0x30e8, 0x8388}, {0x30e9, 0x8389}, {0x30ea, 0x838a}, {0x30eb, 0x838b},
    {0x30ec, 0x838c}, {0x30ed, 0x838d}, {0x30ee, 0x838e}, {0x30ef, 0x838f},
    {0x30f0, 0x8390}, {0x30f1, 0x8391}, {0x30f2, 0x8392}, {0x30f3, 0x8393},
    {0x30f4, 0x8394}, {0x30f5, 0x8395}, {0x30f6, 0x8396}, {0x30fb, 0x8145},
    {0x30fc, 0x815b}, {0x30fd, 0x8152}, {0x30fe, 0x8153}, {0x3231, 0xfa58},
    {0x3232, 0x878b}, {0x3239, 0x878c}, {0x32a4, 0x8785}, {0x32a5, 0x8786},
    {0x32a6, 0x8787}, {0x32a7, 0x8788}, {0x32a8, 0x8789}, {0x3303, 0x8765},
    {0x330d, 0x8769}, {0x3314, 0x8760}, {0x3318, 0x8763}, {0x3322, 0x8761},
    {0x3323, 0x876b}, {0x3326, 0x876a}, {0x3327, 0x8764}, {0x332b, 0x876c},
    {0x3336, 0x8766}, {0x333b, 0x876e}, {0x3349, 0x875f}, {0x334a, 0x876d},
    {0x334d, 0x8762}, {0x3351, 0x8767}, {0x3357, 0x8768}, {0x337b, 0x877e},
    {0x337c, 0x878f}, {0x337d, 0x878e}, {0x337e, 0x878d}, {0x338e, 0x8772},
    {0x338f, 0x8773}, {0x339c, 0x876f}, {0x339d, 0x8770}, {0x339e, 0x8771},
    {0x33a1, 0x8775}, {0x33c4, 0x8774}, {0x33cd, 0x8783}, {0x4e00, 0x88ea},
    {0x4e01, 0x929a}, {0x4e03, 0x8eb5}, {0x4e07, 0x969c}, {0x4e08, 0x8fe4},
    {0x4e09, 0x8e4f}, {0x4e0a, 0x8fe3}, {0x4e0b, 0x89ba}, {0x4e0d, 0x9573},
    {0x4e0e, 0x975e}, {0x4e10, 0x98a0}, {0x4e11, 0x894e}, {0x4e14, 0x8a8e},
    {0x4e15, 0x98a1}, {0x4e16, 0x90a2}, {0x4e17, 0x99c0}, {0x4e18, 0x8b75},
    {0x4e19, 0x95b8}, {0x4e1e, 0x8fe5}, {0x4e21, 0x97bc}, {0x4e26, 0x95c0},
    {0x4e28, 0xfa68}, {0x4e2a, 0x98a2}, {0x4e2d, 0x9286}, {0x4e31, 0x98a3},
    {0x4e32, 0x8bf8}, {0x4e36, 0x98a4}, {0x4e38, 0x8adb}, {0x4e39, 0x924f},
    {0x4e3b, 0x8ee5}, {0x4e3c, 0x98a5}, {0x4e3f, 0x98a6}, {0x4e42, 0x98a7},
    {0x4e43, 0x9454}, {0x4e45, 0x8b76}, {0x4e4b, 0x9456}, {0x4e4d, 0x93e1},
    {0x4e4e, 0x8cc1}, {0x4e4f, 0x9652}, {0x4e55, 0xe568}, {0x4e56, 0x98a8},
    {0x4e57, 0x8fe6}, {0x4e58, 0x98a9}, {0x4e59, 0x89b3}, {0x4e5d, 0x8be3},
    {0x4e5e, 0x8cee}, {0x4e5f, 0x96e7}, {0x4e62, 0x9ba4}, {0x4e71, 0x9790},
    {0x4e73, 0x93fb}, {0x4e7e, 0x8aa3}, {0x4e80, 0x8b54}, {0x4e82, 0x98aa},
    {0x4e85, 0x98ab}, {0x4e86, 0x97b9}, {0x4e88, 0x975c}, {0x4e89, 0x9188},
    {0x4e8a, 0x98ad}, {0x4e8b, 0x8e96}, {0x4e8c, 0x93f1}, {0x4e8e, 0x98b0},
    {0x4e91, 0x895d}, {0x4e92, 0x8cdd}, {0x4e94, 0x8cdc}, {0x4e95, 0x88e4},
    {0x4e98, 0x986a}, {0x4e99, 0x9869}, {0x4e9b, 0x8db1}, {0x4e9c, 0x889f},
    {0x4e9e, 0x98b1}, {0x4e9f, 0x98b2}, {0x4ea0, 0x98b3}, {0x4ea1, 0x9653},
    {0x4ea2, 0x98b4}, {0x4ea4, 0x8cf0}, {0x4ea5, 0x88e5}, {0x4ea6, 0x9692},
    {0x4ea8, 0x8b9c}, {0x4eab, 0x8b9d}, {0x4eac, 0x8b9e}, {0x4ead, 0x92e0},
    {0x4eae, 0x97ba}, {0x4eb0, 0x98b5}, {0x4eb3, 0x98b6}, {0x4eb6, 0x98b7},
    {0x4eba, 0x906c}, {0x4ec0, 0x8f59}, {0x4ec1, 0x906d}, {0x4ec2, 0x98bc},
    {0x4ec4, 0x98ba}, {0x4ec6, 0x98bb}, {0x4ec7, 0x8b77}, {0x4eca, 0x8da1},
    {0x4ecb, 0x89ee}, {0x4ecd, 0x98b9}, {0x4ece, 0x98b8}, {0x4ecf, 0x95a7},
    {0x4ed4, 0x8e65}, {0x4ed5, 0x8e64}, {0x4ed6, 0x91bc}, {0x4ed7, 0x98bd},
    {0x4ed8, 0x9574}, {0x4ed9, 0x90e5}, {0x4edd, 0x8157}, {0x4ede, 0x98be},
    {0x4edf, 0x98c0}, {0x4ee1, 0xfa69}, {0x4ee3, 0x91e3}, {0x4ee4, 0x97df},
    {0x4ee5, 0x88c8}, {0x4eed, 0x98bf}, {0x4eee, 0x89bc}, {0x4ef0, 0x8bc2},
    {0x4ef2, 0x9287}, {0x4ef6, 0x8c8f}, {0x4ef7, 0x98c1}, {0x4efb, 0x9443},
    {0x4efc, 0xfa6a}, {0x4f00, 0xfa6b}, {0x4f01, 0x8ae9}, {0x4f03, 0xfa6c},
    {0x4f09, 0x98c2}, {0x4f0a, 0x88c9}, {0x4f0d, 0x8cde}, {0x4f0e, 0x8aea},
    {0x4f0f, 0x959a}, {0x4f10, 0x94b0}, {0x4f11, 0x8b78}, {0x4f1a, 0x89ef},
    {0x4f1c, 0x98e5}, {0x4f1d, 0x9360}, {0x4f2f, 0x948c}, {0x4f30, 0x98c4},
    {0x4f34, 0x94ba}, {0x4f36, 0x97e0}, {0x4f38, 0x904c}, {0x4f39, 0xfa6d},
    {0x4f3a, 0x8e66}, {0x4f3c, 0x8e97}, {0x4f3d, 0x89be}, {0x4f43, 0x92cf},
    {0x4f46, 0x9241}, {0x4f47, 0x98c8}, {0x4f4d, 0x88ca}, {0x4f4e, 0x92e1},
    {0x4f4f, 0x8f5a}, {0x4f50, 0x8db2}, {0x4f51, 0x9743}, {0x4f53, 0x91cc},
    {0x4f55, 0x89bd}, {0x4f56, 0xfa6e}, {0x4f57, 0x98c7}, {0x4f59, 0x975d},
    {0x4f5a, 0x98c3}, {0x4f5b, 0x98c5}, {0x4f5c, 0x8dec}, {0x4f5d, 0x98c6},
    {0x4f5e, 0x9b43}, {0x4f69, 0x98ce}, {0x4f6f, 0x98d1}, {0x4f70, 0x98cf},
    {0x4f73, 0x89c0}, {0x4f75, 0x95b9}, {0x4f76, 0x98c9}, {0x4f7b, 0x98cd},
    {0x4f7c, 0x8cf1}, {0x4f7f, 0x8e67}, {0x4f83, 0x8aa4}, {0x4f86, 0x98d2},
    {0x4f88, 0x98ca}, {0x4f8a, 0xfa70}, {0x4f8b, 0x97e1}, {0x4f8d, 0x8e98},
    {0x4f8f, 0x98cb}, {0x4f91, 0x98d0}, {0x4f92, 0xfa6f}, {0x4f94, 0xfa72},
    {0x4f96, 0x98d3}, {0x4f98, 0x98cc}, {0x4f9a, 0xfa71}, {0x4f9b, 0x8b9f},
    {0x4f9d, 0x88cb}, {0x4fa0, 0x8ba0}, {0x4fa1, 0x89bf}, {0x4fab, 0x9b44},
    {0x4fad, 0x9699}, {0x4fae, 0x958e}, {0x4faf, 0x8cf2}, {0x4fb5, 0x904e},
    {0x4fb6, 0x97b5}, {0x4fbf, 0x95d6}, {0x4fc2, 0x8c57}, {0x4fc3, 0x91a3},
    {0x4fc4, 0x89e2}, {0x4fc9, 0xfa61}, {0x4fca, 0x8f72}, {0x4fcd, 0xfa73},
    {0x4fce, 0x98d7}, {0x4fd0, 0x98dc}, {0x4fd1, 0x98da}, {0x4fd4, 0x98d5},
    {0x4fd7, 0x91ad}, {0x4fd8, 0x98d8}, {0x4fda, 0x98db}, {0x4fdb, 0x98d9},
    {0x4fdd, 0x95db}, {0x4fdf, 0x98d6}, {0x4fe0, 0x8ba0}, {0x4fe1, 0x904d},
    {0x4fe3, 0x9693}, {0x4fe4, 0x98dd}, {0x4fe5, 0x98de}, {0x4fee, 0x8f43},
    {0x4fef, 0x98eb}, {0x4ff3, 0x946f}, {0x4ff5, 0x9555}, {0x4ff6, 0x98e6},
    {0x4ff8, 0x95ee}, {0x4ffa, 0x89b4}, {0x4ffe, 0x98ea}, {0x4fff, 0xfa76},
    {0x5005, 0x98e4}, {0x5006, 0x98ed}, {0x5009, 0x9171}, {0x500b, 0x8cc2},
    {0x500d, 0x947b}, {0x500f, 0xe0c5}, {0x5011, 0x98ec}, {0x5012, 0x937c},
    {0x5014, 0x98e1}, {0x5016, 0x8cf4}, {0x5019, 0x8cf3}, {0x501a, 0x98df},
    {0x501e, 0xfa77}, {0x501f, 0x8ed8}, {0x5021, 0x98e7}, {0x5022, 0xfa75},
    {0x5023, 0x95ed}, {0x5024, 0x926c}, {0x5025, 0x98e3}, {0x5026, 0x8c91},
    {0x5028, 0x98e0}, {0x5029, 0x98e8}, {0x502a, 0x98e2}, {0x502b, 0x97cf},
    {0x502c, 0x98e9}, {0x502d, 0x9860}, {0x5036, 0x8be4}, {0x5039, 0x8c90},
    {0x5040, 0xfa74}, {0x5042, 0xfa7a}, {0x5043, 0x98ee}, {0x5046, 0xfa78},
    {0x5047, 0x98ef}, {0x5048, 0x98f3}, {0x5049, 0x88cc}, {0x504f, 0x95ce},
    {0x5050, 0x98f2}, {0x5055, 0x98f1}, {0x5056, 0x98f5}, {0x505a, 0x98f4},
    {0x505c, 0x92e2}, {0x5065, 0x8c92}, {0x506c, 0x98f6}, {0x5070, 0xfa79},
    {0x5072, 0x8ec3}, {0x5074, 0x91a4}, {0x5075, 0x92e3}, {0x5076, 0x8bf4},
    {0x5078, 0x98f7}, {0x507d, 0x8b55}, {0x5080, 0x98f8}, {0x5085, 0x98fa},
    {0x508d, 0x9654}, {0x5091, 0x8c86}, {0x5094, 0xfa7b}, {0x5098, 0x8e50},
    {0x5099, 0x94f5}, {0x509a, 0x98f9}, {0x50ac, 0x8dc3}, {0x50ad, 0x9762},
    {0x50b2, 0x98fc}, {0x50b3, 0x9942}, {0x50b4, 0x98fb}, {0x50b5, 0x8dc2},
    {0x50b7, 0x8f9d}, {0x50be, 0x8c58}, {0x50c2, 0x9943}, {0x50c5, 0x8bcd},
    {0x50c9, 0x9940}, {0x50ca, 0x9941}, {0x50cd, 0x93ad}, {0x50cf, 0x919c},
    {0x50d1, 0x8ba1}, {0x50d5, 0x966c}, {0x50d6, 0x9944}, {0x50d8, 0xfa7d},
    {0x50da, 0x97bb}, {0x50de, 0x9945}, {0x50e3, 0x9948}, {0x50e5, 0x9946},
    {0x50e7, 0x916d}, {0x50ed, 0x9947}, {0x50ee, 0x9949}, {0x50f4, 0xfa7c},
    {0x50f5, 0x994b}, {0x50f9, 0x994a}, {0x50fb, 0x95c6}, {0x5100, 0x8b56},
    {0x5101, 0x994d}, {0x5102, 0x994e}, {0x5104, 0x89ad}, {0x5109, 0x994c},
    {0x5112, 0x8ef2}, {0x5114, 0x9951}, {0x5115, 0x9950}, {0x5116, 0x994f},
    {0x5118, 0x98d4}, {0x511a, 0x9952}, {0x511f, 0x8f9e}, {0x5121, 0x9953},
    {0x512a, 0x9744}, {0x5132, 0x96d7}, {0x5137, 0x9955}, {0x513a, 0x9954},
    {0x513b, 0x9957}, {0x513c, 0x9956}, {0x513f, 0x9958}, {0x5140, 0x9959},
    {0x5141, 0x88f2}, {0x5143, 0x8cb3}, {0x5144, 0x8c5a}, {0x5145, 0x8f5b},
    {0x5146, 0x929b}, {0x5147, 0x8ba2}, {0x5148, 0x90e6}, {0x5149, 0x8cf5},
    {0x514a, 0xfa7e}, {0x514b, 0x8d8e}, {0x514c, 0x995b}, {0x514d, 0x96c6},
    {0x514e, 0x9365}, {0x5150, 0x8e99}, {0x5152, 0x995a}, {0x5154, 0x995c},
    {0x515a, 0x937d}, {0x515c, 0x8a95}, {0x5162, 0x995d}, {0x5164, 0xfa80},
    {0x5165, 0x93fc}, {0x5168, 0x9153}, {0x5169, 0x995f}, {0x516a, 0x9960},
    {0x516b, 0x94aa}, {0x516c, 0x8cf6}, {0x516d, 0x985a}, {0x516e, 0x9961},
    {0x5171, 0x8ba4}, {0x5175, 0x95ba}, {0x5176, 0x91b4}, {0x5177, 0x8bef},
    {0x5178, 0x9354}, {0x517c, 0x8c93}, {0x5180, 0x9962}, {0x5182, 0x9963},
    {0x5185, 0x93e0}, {0x5186, 0x897e}, {0x5189, 0x9966}, {0x518a, 0x8dfb},
    {0x518c, 0x9965}, {0x518d, 0x8dc4}, {0x518f, 0x9967}, {0x5190, 0xe3ec},
    {0x5191, 0x9968}, {0x5192, 0x9660}, {0x5193, 0x9969}, {0x5195, 0x996a},
    {0x5196, 0x996b}, {0x5197, 0x8fe7}, {0x5199, 0x8eca}, {0x519d, 0xfa81},
    {0x51a0, 0x8aa5}, {0x51a2, 0x996e}, {0x51a4, 0x996c}, {0x51a5, 0x96bb},
    {0x51a6, 0x996d}, {0x51a8, 0x9579}, {0x51a9, 0x996f}, {0x51aa, 0x9970},
    {0x51ab, 0x9971}, {0x51ac, 0x937e}, {0x51b0, 0x9975}, {0x51b1, 0x9973},
    {0x51b2, 0x9974}, {0x51b3, 0x9972}, {0x51b4, 0x8de1}, {0x51b5, 0x9976},
    {0x51b6, 0x96e8}, {0x51b7, 0x97e2}, {0x51bd, 0x9977}, {0x51be, 0xfa82},
    {0x51c4, 0x90a6}, {0x51c5, 0x9978}, {0x51c6, 0x8f79}, {0x51c9, 0x9979},
    {0x51cb, 0x929c}, {0x51cc, 0x97bd}, {0x51cd, 0x9380}, {0x51d6, 0x99c3},
    {0x51db, 0x997a}, {0x51dc, 0xeaa3}, {0x51dd, 0x8bc3}, {0x51e0, 0x997b},
    {0x51e1, 0x967d}, {0x51e6, 0x8f88}, {0x51e7, 0x91fa}, {0x51e9, 0x997d},
    {0x51ea, 0x93e2}, {0x51ec, 0xfa83}, {0x51ed, 0x997e}, {0x51f0, 0x9980},
    {0x51f1, 0x8a4d}, {0x51f5, 0x9981}, {0x51f6, 0x8ba5}, {0x51f8, 0x93ca},
    {0x51f9, 0x899a}, {0x51fa, 0x8f6f}, {0x51fd, 0x949f}, {0x51fe, 0x9982},
    {0x5200, 0x9381}, {0x5203, 0x906e}, {0x5204, 0x9983}, {0x5206, 0x95aa},
    {0x5207, 0x90d8}, {0x5208, 0x8aa0}, {0x520a, 0x8aa7}, {0x520b, 0x9984},
    {0x520e, 0x9986}, {0x5211, 0x8c59}, {0x5214, 0x9985}, {0x5215, 0xfa84},
    {0x5217, 0x97f1}, {0x521d, 0x8f89}, {0x5224, 0x94bb}, {0x5225, 0x95ca},
    {0x5227, 0x9987}, {0x5229, 0x9798}, {0x522a, 0x9988}, {0x522e, 0x9989},
    {0x5230, 0x939e}, {0x5233, 0x998a}, {0x5236, 0x90a7}, {0x5237, 0x8dfc},
    {0x5238, 0x8c94}, {0x5239, 0x998b}, {0x523a, 0x8e68}, {0x523b, 0x8d8f},
    {0x5243, 0x92e4}, {0x5244, 0x998d}, {0x5247, 0x91a5}, {0x524a, 0x8ded},
    {0x524b, 0x998e}, {0x524c, 0x998f}, {0x524d, 0x914f}, {0x524f, 0x998c},
    {0x5254, 0x9991}, {0x5256, 0x9655}, {0x525b, 0x8d84}, {0x525d, 0x948d},
    {0x525e, 0x9990}, {0x5263, 0x8c95}, {0x5264, 0x8ddc}, {0x5265, 0x948d},
    {0x5269, 0x9994}, {0x526a, 0x9992}, {0x526f, 0x959b}, {0x5270, 0x8fe8},
    {0x5271, 0x999b}, {0x5272, 0x8a84}, {0x5273, 0x9995}, {0x5274, 0x9993},
    {0x5275, 0x916e}, {0x527d, 0x9997}, {0x527f, 0x9996}, {0x5283, 0x8a63},
    {0x5287, 0x8c80}, {0x5288, 0x999c}, {0x5289, 0x97ab}, {0x528d, 0x9998},
    {0x5291, 0x999d}, {0x5292, 0x999a}, {0x5294, 0x9999}, {0x529b, 0x97cd},
    {0x529c, 0xfa85}, {0x529f, 0x8cf7}, {0x52a0, 0x89c1}, {0x52a3, 0x97f2},
    {0x52a6, 0xfa86}, {0x52a9, 0x8f95}, {0x52aa, 0x9377}, {0x52ab, 0x8d85},
    {0x52ac, 0x99a0}, {0x52ad, 0x99a1}, {0x52af, 0xfb77}, {0x52b1, 0x97e3},
    {0x52b4, 0x984a}, {0x52b5, 0x99a3}, {0x52b9, 0x8cf8}, {0x52bc, 0x99a2},
    {0x52be, 0x8a4e}, {0x52c0, 0xfa87}, {0x52c1, 0x99a4}, {0x52c3, 0x9675},
    {0x52c5, 0x92ba}, {0x52c7, 0x9745}, {0x52c9, 0x95d7}, {0x52cd, 0x99a5},
    {0x52d2, 0xe8d3}, {0x52d5, 0x93ae}, {0x52d7, 0x99a6}, {0x52d8, 0x8aa8},
    {0x52d9, 0x96b1}, {0x52db, 0xfa88}, {0x52dd, 0x8f9f}, {0x52de, 0x99a7},
    {0x52df, 0x95e5}, {0x52e0, 0x99ab}, {0x52e2, 0x90a8}, {0x52e3, 0x99a8},
    {0x52e4, 0x8bce}, {0x52e6, 0x99a9}, {0x52e7, 0x8aa9}, {0x52f2, 0x8c4d},
    {0x52f3, 0x99ac}, {0x52f5, 0x99ad}, {0x52f8, 0x99ae}, {0x52f9, 0x99af},
    {0x52fa, 0x8ed9}, {0x52fe, 0x8cf9}, {0x52ff, 0x96dc}, {0x5300, 0xfa89},
    {0x5301, 0x96e6}, {0x5302, 0x93f5}, {0x5305, 0x95ef}, {0x5306, 0x99b0},
    {0x5307, 0xfa8a}, {0x5308, 0x99b1}, {0x530d, 0x99b3}, {0x530f, 0x99b5},
    {0x5310, 0x99b4}, {0x5315, 0x99b6}, {0x5316, 0x89bb}, {0x5317, 0x966b},
    {0x5319, 0x8dfa}, {0x531a, 0x99b7}, {0x531d, 0x9178}, {0x5320, 0x8fa0},
    {0x5321, 0x8ba7}, {0x5323, 0x99b8}, {0x5324, 0xfa8b}, {0x532a, 0x94d9},
    {0x532f, 0x99b9}, {0x5331, 0x99ba}, {0x5333, 0x99bb}, {0x5338, 0x99bc},
    {0x5339, 0x9543}, {0x533a, 0x8be6}, {0x533b, 0x88e3}, {0x533f, 0x93bd},
    {0x5340, 0x99bd}, {0x5341, 0x8f5c}, {0x5343, 0x90e7}, {0x5345, 0x99bf},
    {0x5346, 0x99be}, {0x5347, 0x8fa1}, {0x5348, 0x8cdf}, {0x5349, 0x99c1},
    {0x534a, 0x94bc}, {0x534d, 0x99c2}, {0x5351, 0x94da}, {0x5352, 0x91b2},
    {0x5353, 0x91ec}, {0x5354, 0x8ba6}, {0x5357, 0x93ec}, {0x5358, 0x9250},
    {0x535a, 0x948e}, {0x535c, 0x966d}, {0x535e, 0x99c4}, {0x5360, 0x90e8},
    {0x5366, 0x8c54}, {0x5369, 0x99c5}, {0x536e, 0x99c6}, {0x536f, 0x894b},
    {0x5370, 0x88f3}, {0x5371, 0x8aeb}, {0x5372, 0xfa8c}, {0x5373, 0x91a6},
    {0x5374, 0x8b70}, {0x5375, 0x9791}, {0x5377, 0x99c9}, {0x5378, 0x89b5},
    {0x537b, 0x99c8}, {0x537f, 0x8ba8}, {0x5382, 0x99ca}, {0x5384, 0x96ef},
    {0x5393, 0xfa8d}, {0x5396, 0x99cb}, {0x5398, 0x97d0}, {0x539a, 0x8cfa},
    {0x539f, 0x8cb4}, {0x53a0, 0x99cc}, {0x53a5, 0x99ce}, {0x53a6, 0x99cd},
    {0x53a8, 0x907e}, {0x53a9, 0x8958}, {0x53ad, 0x897d}, {0x53ae, 0x99cf},
    {0x53b0, 0x99d0}, {0x53b2, 0xfa8e}, {0x53b3, 0x8cb5}, {0x53b6, 0x99d1},
    {0x53bb, 0x8b8e}, {0x53c2, 0x8e51}, {0x53c3, 0x99d2}, {0x53c8, 0x9694},
    {0x53c9, 0x8db3}, {0x53ca, 0x8b79}, {0x53cb, 0x9746}, {0x53cc, 0x916f},
    {0x53cd, 0x94bd}, {0x53ce, 0x8efb}, {0x53d4, 0x8f66}, {0x53d6, 0x8ee6},
    {0x53d7, 0x8ef3}, {0x53d9, 0x8f96}, {0x53db, 0x94be}, {0x53dd, 0xfa8f},
    {0x53df, 0x99d5}, {0x53e1, 0x8962}, {0x53e2, 0x9170}, {0x53e3, 0x8cfb},
    {0x53e4, 0x8cc3}, {0x53e5, 0x8be5}, {0x53e8, 0x99d9}, {0x53e9, 0x9240},
    {0x53ea, 0x91fc}, {0x53eb, 0x8ba9}, {0x53ec, 0x8fa2}, {0x53ed, 0x99da},
    {0x53ee, 0x99d8}, {0x53ef, 0x89c2}, {0x53f0, 0x91e4}, {0x53f1, 0x8eb6},
    {0x53f2, 0x8e6a}, {0x53f3, 0x8945}, {0x53f6, 0x8a90}, {0x53f7, 0x8d86},
    {0x53f8, 0x8e69}, {0x53fa, 0x99db}, {0x5401, 0x99dc}, {0x5403, 0x8b68},
    {0x5404, 0x8a65}, {0x5408, 0x8d87}, {0x5409, 0x8b67}, {0x540a, 0x92dd},
    {0x540b, 0x8944}, {0x540c, 0x93af}, {0x540d, 0x96bc}, {0x540e, 0x8d40},
    {0x540f, 0x9799}, {0x5410, 0x9366}, {0x5411, 0x8cfc}, {0x541b, 0x8c4e},
    {0x541d, 0x99e5}, {0x541f, 0x8be1}, {0x5420, 0x9669}, {0x5426, 0x94db},
    {0x5429, 0x99e4}, {0x542b, 0x8adc}, {0x542c, 0x99df}, {0x542d, 0x99e0},
    {0x542e, 0x99e2}, {0x5436, 0x99e3}, {0x5438, 0x8b7a}, {0x5439, 0x9081},
    {0x543b, 0x95ab}, {0x543c, 0x99e1}, {0x543d, 0x99dd}, {0x543e, 0x8ce1},
    {0x5440, 0x99de}, {0x5442, 0x9843}, {0x5446, 0x95f0}, {0x5448, 0x92e6},
    {0x5449, 0x8ce0}, {0x544a, 0x8d90}, {0x544e, 0x99e6}, {0x5451, 0x93db},
    {0x545f, 0x99ea}, {0x5468, 0x8efc}, {0x546a, 0x8ef4}, {0x5470, 0x99ed},
    {0x5471, 0x99eb}, {0x5473, 0x96a1}, {0x5475, 0x99e8}, {0x5476, 0x99f1},
    {0x5477, 0x99ec}, {0x547b, 0x99ef}, {0x547c, 0x8cc4}, {0x547d, 0x96bd},
    {0x5480, 0x99f0}, {0x5484, 0x99f2}, {0x5486, 0x99f4}, {0x548a, 0xfa92},
    {0x548b, 0x8dee}, {0x548c, 0x9861}, {0x548e, 0x99e9}, {0x548f, 0x99e7},
    {0x5490, 0x99f3}, {0x5492, 0x99ee}, {0x549c, 0xfa91}, {0x54a2, 0x99f6},
    {0x54a4, 0x9a42}, {0x54a5, 0x99f8}, {0x54a8, 0x99fc}, {0x54a9, 0xfa93},
    {0x54ab, 0x9a40}, {0x54ac, 0x99f9}, {0x54af, 0x9a5d}, {0x54b2, 0x8de7},
    {0x54b3, 0x8a50}, {0x54b8, 0x99f7}, {0x54bc, 0x9a44}, {0x54bd, 0x88f4},
    {0x54be, 0x9a43}, {0x54c0, 0x88a3}, {0x54c1, 0x9569}, {0x54c2, 0x9a41},
    {0x54c4, 0x99fa}, {0x54c7, 0x99f5}, {0x54c8, 0x99fb}, {0x54c9, 0x8dc6},
    {0x54d8, 0x9a45}, {0x54e1, 0x88f5}, {0x54e2, 0x9a4e}, {0x54e5, 0x9a46},
    {0x54e6, 0x9a47}, {0x54e8, 0x8fa3}, {0x54e9, 0x9689}, {0x54ed, 0x9a4c},
    {0x54ee, 0x9a4b}, {0x54f2, 0x934e}, {0x54fa, 0x9a4d}, {0x54fd, 0x9a4a},
    {0x54ff, 0xfa94}, {0x5504, 0x8953}, {0x5506, 0x8db4}, {0x5507, 0x904f},
    {0x550f, 0x9a48}, {0x5510, 0x9382}, {0x5514, 0x9a49}, {0x5516, 0x88a0},
    {0x552e, 0x9a53}, {0x552f, 0x9742}, {0x5531, 0x8fa5}, {0x5533, 0x9a59},
    {0x5538, 0x9a58}, {0x5539, 0x9a4f}, {0x553e, 0x91c1}, {0x5540, 0x9a50},
    {0x5544, 0x91ed}, {0x5545, 0x9a55}, {0x5546, 0x8fa4}, {0x554c, 0x9a52},
    {0x554f, 0x96e2}, {0x5553, 0x8c5b}, {0x5556, 0x9a56}, {0x5557, 0x9a57},
    {0x555c, 0x9a54}, {0x555d, 0x9a5a}, {0x555e, 0x88a0}, {0x5563, 0x9a51},
    {0x557b, 0x9a60}, {0x557c, 0x9a65}, {0x557e, 0x9a61}, {0x5580, 0x9a5c},
    {0x5583, 0x9a66}, {0x5584, 0x9150}, {0x5586, 0xfa95}, {0x5587, 0x9a68},
    {0x5589, 0x8d41}, {0x558a, 0x9a5e}, {0x558b, 0x929d}, {0x5598, 0x9a62},
    {0x5599, 0x9a5b}, {0x559a, 0x8aab}, {0x559c, 0x8aec}, {0x559d, 0x8a85},
    {0x559e, 0x9a63}, {0x559f, 0x9a5f}, {0x55a7, 0x8c96}, {0x55a8, 0x9a69},
    {0x55a9, 0x9a67}, {0x55aa, 0x9172}, {0x55ab, 0x8b69}, {0x55ac, 0x8baa},
    {0x55ae, 0x9a64}, {0x55b0, 0x8bf2}, {0x55b6, 0x8963}, {0x55c4, 0x9a6d},
    {0x55c5, 0x9a6b}, {0x55c7, 0x9aa5}, {0x55d4, 0x9a70}, {0x55da, 0x9a6a},
    {0x55dc, 0x9a6e}, {0x55df, 0x9a6c}, {0x55e3, 0x8e6b}, {0x55e4, 0x9a6f},
    {0x55f7, 0x9a72}, {0x55f9, 0x9a77}, {0x55fd, 0x9a75}, {0x55fe, 0x9a74},
    {0x5606, 0x9251}, {0x5609, 0x89c3}, {0x5614, 0x9a71}, {0x5616, 0x9a73},
    {0x5617, 0x8fa6}, {0x5618, 0x8952}, {0x561b, 0x9a76}, {0x5629, 0x89dc},
    {0x562f, 0x9a82}, {0x5631, 0x8ffa}, {0x5632, 0x9a7d}, {0x5634, 0x9a7b},
    {0x5636, 0x9a7c}, {0x5638, 0x9a7e}, {0x5642, 0x895c}, {0x564c, 0x9158},
    {0x564e, 0x9a78}, {0x5650, 0x9a79}, {0x565b, 0x8a9a}, {0x5664, 0x9a81},
    {0x5668, 0x8aed}, {0x566a, 0x9a84}, {0x566b, 0x9a80}, {0x566c, 0x9a83},
    {0x5674, 0x95ac}, {0x5678, 0x93d3}, {0x567a, 0x94b6}, {0x5680, 0x9a86},
    {0x5686, 0x9a85}, {0x5687, 0x8a64}, {0x568a, 0x9a87}, {0x568f, 0x9a8a},
    {0x5694, 0x9a89}, {0x5699, 0x8a9a}, {0x56a0, 0x9a88}, {0x56a2, 0x9458},
    {0x56a5, 0x9a8b}, {0x56ae, 0x9a8c}, {0x56b4, 0x9a8e}, {0x56b6, 0x9a8d},
    {0x56bc, 0x9a90}, {0x56c0, 0x9a93}, {0x56c1, 0x9a91}, {0x56c2, 0x9a8f},
    {0x56c3, 0x9a92}, {0x56c8, 0x9a94}, {0x56ca, 0x9458}, {0x56ce, 0x9a95},
    {0x56d1, 0x9a96}, {0x56d3, 0x9a97}, {0x56d7, 0x9a98}, {0x56d8, 0x9964},
    {0x56da, 0x8efa}, {0x56db, 0x8e6c}, {0x56de, 0x89f1}, {0x56e0, 0x88f6},
    {0x56e3, 0x9263}, {0x56ee, 0x9a99}, {0x56f0, 0x8da2}, {0x56f2, 0x88cd},
    {0x56f3, 0x907d}, {0x56f9, 0x9a9a}, {0x56fa, 0x8cc5}, {0x56fd, 0x8d91},
    {0x56ff, 0x9a9c}, {0x5700, 0x9a9b}, {0x5703, 0x95de}, {0x5704, 0x9a9d},
    {0x5708, 0x9a9f}, {0x5709, 0x9a9e}, {0x570b, 0x9aa0}, {0x570d, 0x9aa1},
    {0x570f, 0x8c97}, {0x5712, 0x8980}, {0x5713, 0x9aa2}, {0x5716, 0x9aa4},
    {0x5718, 0x9aa3}, {0x571c, 0x9aa6}, {0x571f, 0x9379}, {0x5726, 0x9aa7},
    {0x5727, 0x88b3}, {0x5728, 0x8ddd}, {0x572d, 0x8c5c}, {0x5730, 0x926e},
    {0x5737, 0x9aa8}, {0x5738, 0x9aa9}, {0x573b, 0x9aab}, {0x5740, 0x9aac},
    {0x5742, 0x8de2}, {0x5747, 0x8bcf}, {0x574a, 0x9656}, {0x574e, 0x9aaa},
    {0x574f, 0x9aad}, {0x5750, 0x8dbf}, {0x5751, 0x8d42}, {0x5759, 0xfa96},
    {0x5761, 0x9ab1}, {0x5764, 0x8da3}, {0x5765, 0xfa97}, {0x5766, 0x9252},
    {0x5769, 0x9aae}, {0x576a, 0x92d8}, {0x577f, 0x9ab2}, {0x5782, 0x9082},
    {0x5788, 0x9ab0}, {0x5789, 0x9ab3}, {0x578b, 0x8c5e}, {0x5793, 0x9ab4},
    {0x57a0, 0x9ab5}, {0x57a2, 0x8d43}, {0x57a3, 0x8a5f}, {0x57a4, 0x9ab7},
    {0x57aa, 0x9ab8}, {0x57ac, 0xfa98}, {0x57b0, 0x9ab9}, {0x57b3, 0x9ab6},
    {0x57c0, 0x9aaf}, {0x57c3, 0x9aba}, {0x57c6, 0x9abb}, {0x57c7, 0xfa9a},
    {0x57c8, 0xfa99}, {0x57cb, 0x9684}, {0x57ce, 0x8fe9}, {0x57d2, 0x9abd},
    {0x57d3, 0x9abe}, {0x57d4, 0x9abc}, {0x57d6, 0x9ac0}, {0x57dc, 0x9457},
    {0x57df, 0x88e6}, {0x57e0, 0x9575}, {0x57e3, 0x9ac1}, {0x57f4, 0x8ffb},
    {0x57f7, 0x8eb7}, {0x57f9, 0x947c}, {0x57fa, 0x8aee}, {0x57fc, 0x8de9},
    {0x5800, 0x9678}, {0x5802, 0x93b0}, {0x5805, 0x8c98}, {0x5806, 0x91cd},
    {0x580a, 0x9abf}, {0x580b, 0x9ac2}, {0x5815, 0x91c2}, {0x5819, 0x9ac3},
    {0x581d, 0x9ac4}, {0x5821, 0x9ac6}, {0x5824, 0x92e7}, {0x582a, 0x8aac},
    {0x582f, 0xea9f}, {0x5830, 0x8981}, {0x5831, 0x95f1}, {0x5834, 0x8fea},
    {0x5835, 0x9367}, {0x583a, 0x8de4}, {0x583d, 0x9acc}, {0x5840, 0x95bb},
    {0x5841, 0x97db}, {0x584a, 0x89f2}, {0x584b, 0x9ac8}, {0x5851, 0x9159},
    {0x5852, 0x9acb}, {0x5854, 0x9383}, {0x5857, 0x9368}, {0x5858, 0x9384},
    {0x5859, 0x94b7}, {0x585a, 0x92cb}, {0x585e, 0x8dc7}, {0x5861, 0x9355},
    {0x5862, 0x9ac7}, {0x5869, 0x8996}, {0x586b, 0x9355}, {0x5870, 0x9ac9},
    {0x5872, 0x9ac5}, {0x5875, 0x906f}, {0x5879, 0x9acd}, {0x587e, 0x8f6d},
    {0x5883, 0x8bab}, {0x5885, 0x9ace}, {0x5893, 0x95e6}, {0x5897, 0x919d},
    {0x589c, 0x92c4}, {0x589e, 0xfa9d}, {0x589f, 0x9ad0}, {0x58a8, 0x966e},
    {0x58ab, 0x9ad1}, {0x58ae, 0x9ad6}, {0x58b2, 0xfa9e}, {0x58b3, 0x95ad},
    {0x58b8, 0x9ad5}, {0x58b9, 0x9acf}, {0x58ba, 0x9ad2}, {0x58bb, 0x9ad4},
    {0x58be, 0x8da4}, {0x58c1, 0x95c7}, {0x58c5, 0x9ad7}, {0x58c7, 0x9264},
    {0x58ca, 0x89f3}, {0x58cc, 0x8feb}, {0x58d1, 0x9ad9}, {0x58d3, 0x9ad8},
    {0x58d5, 0x8d88}, {0x58d7, 0x9ada}, {0x58d8, 0x9adc}, {0x58d9, 0x9adb},
    {0x58dc, 0x9ade}, {0x58de, 0x9ad3}, {0x58df, 0x9ae0}, {0x58e4, 0x9adf},
    {0x58e5, 0x9add}, {0x58eb, 0x8e6d}, {0x58ec, 0x9070}, {0x58ee, 0x9173},
    {0x58ef, 0x9ae1}, {0x58f0, 0x90ba}, {0x58f1, 0x88eb}, {0x58f2, 0x9484},
    {0x58f7, 0x92d9}, {0x58f9, 0x9ae3}, {0x58fa, 0x9ae2}, {0x58fb, 0x9ae4},
    {0x58fc, 0x9ae5}, {0x58fd, 0x9ae6}, {0x5902, 0x9ae7}, {0x5909, 0x95cf},
    {0x590a, 0x9ae8}, {0x590b, 0xfa9f}, {0x590f, 0x89c4}, {0x5910, 0x9ae9},
    {0x5915, 0x975b}, {0x5916, 0x8a4f}, {0x5918, 0x99c7}, {0x5919, 0x8f67},
    {0x591a, 0x91bd}, {0x591b, 0x9aea}, {0x591c, 0x96e9}, {0x5922, 0x96b2},
    {0x5925, 0x9aec}, {0x5927, 0x91e5}, {0x5929, 0x9356}, {0x592a, 0x91be},
    {0x592b, 0x9576}, {0x592c, 0x9aed}, {0x592d, 0x9aee}, {0x592e, 0x899b},
    {0x5931, 0x8eb8}, {0x5932, 0x9aef}, {0x5937, 0x88ce}, {0x5938, 0x9af0},
    {0x593e, 0x9af1}, {0x5944, 0x8982}, {0x5947, 0x8aef}, {0x5948, 0x93de},
    {0x5949, 0x95f2}, {0x594e, 0x9af5}, {0x594f, 0x9174}, {0x5950, 0x9af4},
    {0x5951, 0x8c5f}, {0x5953, 0xfaa0}, {0x5954, 0x967a}, {0x5955, 0x9af3},
    {0x5957, 0x9385}, {0x5958, 0x9af7}, {0x595a, 0x9af6}, {0x595b, 0xfaa1},
    {0x595d, 0xfaa2}, {0x5960, 0x9af9}, {0x5962, 0x9af8}, {0x5963, 0xfaa3},
    {0x5965, 0x899c}, {0x5967, 0x9afa}, {0x5968, 0x8fa7}, {0x5969, 0x9afc},
    {0x596a, 0x9244}, {0x596c, 0x9afb}, {0x596e, 0x95b1}, {0x5973, 0x8f97},
    {0x5974, 0x937a}, {0x5978, 0x9b40}, {0x597d, 0x8d44}, {0x5981, 0x9b41},
    {0x5982, 0x9440}, {0x5983, 0x94dc}, {0x5984, 0x96cf}, {0x598a, 0x9444},
    {0x598d, 0x9b4a}, {0x5993, 0x8b57}, {0x5996, 0x9764}, {0x5999, 0x96ad},
    {0x599b, 0x9baa}, {0x599d, 0x9b42}, {0x59a3, 0x9b45}, {0x59a4, 0xfaa4},
    {0x59a5, 0x91c3}, {0x59a8, 0x9657}, {0x59ac, 0x9369}, {0x59b2, 0x9b46},
    {0x59b9, 0x9685}, {0x59ba, 0xfaa5}, {0x59bb, 0x8dc8}, {0x59be, 0x8fa8},
    {0x59c6, 0x9b47}, {0x59c9, 0x8e6f}, {0x59cb, 0x8e6e}, {0x59d0, 0x88b7},
    {0x59d1, 0x8cc6}, {0x59d3, 0x90a9}, {0x59d4, 0x88cf}, {0x59d9, 0x9b4b},
    {0x59da, 0x9b4c}, {0x59dc, 0x9b49}, {0x59e5, 0x8957}, {0x59e6, 0x8aad},
    {0x59e8, 0x9b48}, {0x59ea, 0x96c3}, {0x59eb, 0x9550}, {0x59f6, 0x88a6},
    {0x59fb, 0x88f7}, {0x59ff, 0x8e70}, {0x5a01, 0x88d0}, {0x5a03, 0x88a1},
    {0x5a09, 0x9b51}, {0x5a11, 0x9b4f}, {0x5a18, 0x96ba}, {0x5a1a, 0x9b52},
    {0x5a1c, 0x9b50}, {0x5a1f, 0x9b4e}, {0x5a20, 0x9050}, {0x5a25, 0x9b4d},
    {0x5a29, 0x95d8}, {0x5a2f, 0x8ce2}, {0x5a35, 0x9b56}, {0x5a36, 0x9b57},
    {0x5a3c, 0x8fa9}, {0x5a40, 0x9b53}, {0x5a41, 0x984b}, {0x5a46, 0x946b},
    {0x5a49, 0x9b55}, {0x5a5a, 0x8da5}, {0x5a62, 0x9b58}, {0x5a66, 0x9577},
    {0x5a6a, 0x9b59}, {0x5a6c, 0x9b54}, {0x5a7f, 0x96b9}, {0x5a92, 0x947d},
    {0x5a9a, 0x9b5a}, {0x5a9b, 0x9551}, {0x5abc, 0x9b5b}, {0x5abd, 0x9b5f},
    {0x5abe, 0x9b5c}, {0x5ac1, 0x89c5}, {0x5ac2, 0x9b5e}, {0x5ac9, 0x8eb9},
    {0x5acb, 0x9b5d}, {0x5acc, 0x8c99}, {0x5ad0, 0x9b6b}, {0x5ad6, 0x9b64},
    {0x5ad7, 0x9b61}, {0x5ae1, 0x9284}, {0x5ae3, 0x9b60}, {0x5ae6, 0x9b62},
    {0x5ae9, 0x9b63}, {0x5afa, 0x9b65}, {0x5afb, 0x9b66}, {0x5b09, 0x8af0},
    {0x5b0b, 0x9b68}, {0x5b0c, 0x9b67}, {0x5b16, 0x9b69}, {0x5b22, 0x8fec},
    {0x5b2a, 0x9b6c}, {0x5b2c, 0x92da}, {0x5b30, 0x8964}, {0x5b32, 0x9b6a},
    {0x5b36, 0x9b6d}, {0x5b3e, 0x9b6e}, {0x5b40, 0x9b71}, {0x5b43, 0x9b6f},
    {0x5b45, 0x9b70}, {0x5b50, 0x8e71}, {0x5b51, 0x9b72}, {0x5b54, 0x8d45},
    {0x5b55, 0x9b73}, {0x5b56, 0xfaa6}, {0x5b57, 0x8e9a}, {0x5b58, 0x91b6},
    {0x5b5a, 0x9b74}, {0x5b5b, 0x9b75}, {0x5b5c, 0x8e79}, {0x5b5d, 0x8d46},
    {0x5b5f, 0x96d0}, {0x5b63, 0x8b47}, {0x5b64, 0x8cc7}, {0x5b65, 0x9b76},
    {0x5b66, 0x8a77}, {0x5b69, 0x9b77}, {0x5b6b, 0x91b7}, {0x5b70, 0x9b78},
    {0x5b71, 0x9ba1}, {0x5b73, 0x9b79}, {0x5b75, 0x9b7a}, {0x5b78, 0x9b7b},
    {0x5b7a, 0x9b7d}, {0x5b80, 0x9b7e}, {0x5b83, 0x9b80}, {0x5b85, 0x91ee},
    {0x5b87, 0x8946}, {0x5b88, 0x8ee7}, {0x5b89, 0x88c0}, {0x5b8b, 0x9176},
    {0x5b8c, 0x8aae}, {0x5b8d, 0x8eb3}, {0x5b8f, 0x8d47}, {0x5b95, 0x9386},
    {0x5b97, 0x8f40}, {0x5b98, 0x8aaf}, {0x5b99, 0x9288}, {0x5b9a, 0x92e8},
    {0x5b9b, 0x88b6}, {0x5b9c, 0x8b58}, {0x5b9d, 0x95f3}, {0x5b9f, 0x8ec0},
    {0x5ba2, 0x8b71}, {0x5ba3, 0x90e9}, {0x5ba4, 0x8eba}, {0x5ba5, 0x9747},
    {0x5ba6, 0x9b81}, {0x5bae, 0x8b7b}, {0x5bb0, 0x8dc9}, {0x5bb3, 0x8a51},
    {0x5bb4, 0x8983}, {0x5bb5, 0x8faa}, {0x5bb6, 0x89c6}, {0x5bb8, 0x9b82},
    {0x5bb9, 0x9765}, {0x5bbf, 0x8f68}, {0x5bc0, 0xfaa7}, {0x5bc2, 0x8ee2},
    {0x5bc3, 0x9b83}, {0x5bc4, 0x8af1}, {0x5bc5, 0x93d0}, {0x5bc6, 0x96a7},
    {0x5bc7, 0x9b84}, {0x5bc9, 0x9b85}, {0x5bcc, 0x9578}, {0x5bd0, 0x9b87},
    {0x5bd2, 0x8aa6}, {0x5bd3, 0x8bf5}, {0x5bd4, 0x9b86}, {0x5bd8, 0xfaa9},
    {0x5bdb, 0x8ab0}, {0x5bdd, 0x9051}, {0x5bde, 0x9b8b}, {0x5bdf, 0x8e40},
    {0x5be1, 0x89c7}, {0x5be2, 0x9b8a}, {0x5be4, 0x9b88}, {0x5be5, 0x9b8c},
    {0x5be6, 0x9b89}, {0x5be7, 0x944a}, {0x5be8, 0x9ecb}, {0x5be9, 0x9052},
    {0x5beb, 0x9b8d}, {0x5bec, 0xfaaa}, {0x5bee, 0x97be}, {0x5bf0, 0x9b8e},
    {0x5bf3, 0x9b90}, {0x5bf5, 0x929e}, {0x5bf6, 0x9b8f}, {0x5bf8, 0x90a1},
    {0x5bfa, 0x8e9b}, {0x5bfe, 0x91ce}, {0x5bff, 0x8ef5}, {0x5c01, 0x9595},
    {0x5c02, 0x90ea}, {0x5c04, 0x8ecb}, {0x5c05, 0x9b91}, {0x5c06, 0x8fab},
    {0x5c07, 0x9b92}, {0x5c08, 0x9b93}, {0x5c09, 0x88d1}, {0x5c0a, 0x91b8},
    {0x5c0b, 0x9071}, {0x5c0d, 0x9b94}, {0x5c0e, 0x93b1}, {0x5c0f, 0x8fac},
    {0x5c11, 0x8fad}, {0x5c13, 0x9b95}, {0x5c16, 0x90eb}, {0x5c1a, 0x8fae},
    {0x5c1e, 0xfaab}, {0x5c20, 0x9b96}, {0x5c22, 0x9b97}, {0x5c24, 0x96de},
    {0x5c28, 0x9b98}, {0x5c2d, 0x8bc4}, {0x5c31, 0x8f41}, {0x5c38, 0x9b99},
    {0x5c39, 0x9b9a}, {0x5c3a, 0x8eda}, {0x5c3b, 0x904b}, {0x5c3c, 0x93f2},
    {0x5c3d, 0x9073}, {0x5c3e, 0x94f6}, {0x5c3f, 0x9441}, {0x5c40, 0x8bc7},
    {0x5c41, 0x9b9b}, {0x5c45, 0x8b8f}, {0x5c46, 0x9b9c}, {0x5c48, 0x8bfc},
    {0x5c4a, 0x93cd}, {0x5c4b, 0x89ae}, {0x5c4d, 0x8e72}, {0x5c4e, 0x9b9d},
    {0x5c4f, 0x9ba0}, {0x5c50, 0x9b9f}, {0x5c51, 0x8bfb}, {0x5c53, 0x9b9e},
    {0x5c55, 0x9357}, {0x5c5b, 0x9ba0}, {0x5c5e, 0x91ae}, {0x5c60, 0x936a},
    {0x5c61, 0x8ec6}, {0x5c62, 0x8ec6}, {0x5c64, 0x9177}, {0x5c65, 0x979a},
    {0x5c6c, 0x9ba2}, {0x5c6e, 0x9ba3}, {0x5c6f, 0x93d4}, {0x5c71, 0x8e52},
    {0x5c76, 0x9ba5}, {0x5c79, 0x9ba6}, {0x5c8c, 0x9ba7}, {0x5c90, 0x8af2},
    {0x5c91, 0x9ba8}, {0x5c94, 0x9ba9}, {0x5ca1, 0x89aa}, {0x5ca6, 0xfaac},
    {0x5ca8, 0x915a}, {0x5ca9, 0x8ae2}, {0x5cab, 0x9bab}, {0x5cac, 0x96a6},
    {0x5cb1, 0x91d0}, {0x5cb3, 0x8a78}, {0x5cb6, 0x9bad}, {0x5cb7, 0x9baf},
    {0x5cb8, 0x8add}, {0x5cba, 0xfaad}, {0x5cbb, 0x9bac}, {0x5cbc, 0x9bae},
    {0x5cbe, 0x9bb1}, {0x5cc5, 0x9bb0}, {0x5cc7, 0x9bb2}, {0x5cd9, 0x9bb3},
    {0x5ce0, 0x93bb}, {0x5ce1, 0x8bac}, {0x5ce8, 0x89e3}, {0x5ce9, 0x9bb4},
    {0x5cea, 0x9bb9}, {0x5ced, 0x9bb7}, {0x5cef, 0x95f5}, {0x5cf0, 0x95f4},
    {0x5cf5, 0xfaae}, {0x5cf6, 0x9387}, {0x5cfa, 0x9bb6}, {0x5cfb, 0x8f73},
    {0x5cfd, 0x9bb5}, {0x5d07, 0x9092}, {0x5d0b, 0x9bba}, {0x5d0e, 0x8de8},
    {0x5d11, 0x9bc0}, {0x5d14, 0x9bc1}, {0x5d15, 0x9bbb}, {0x5d16, 0x8a52},
    {0x5d17, 0x9bbc}, {0x5d18, 0x9bc5}, {0x5d19, 0x9bc4}, {0x5d1a, 0x9bc3},
    {0x5d1b, 0x9bbf}, {0x5d1f, 0x9bbe}, {0x5d22, 0x9bc2}, {0x5d27, 0xfaaf},
    {0x5d29, 0x95f6}, {0x5d42, 0xfab2}, {0x5d4b, 0x9bc9}, {0x5d4c, 0x9bc6},
    {0x5d4e, 0x9bc8}, {0x5d50, 0x9792}, {0x5d52, 0x9bc7}, {0x5d53, 0xfab0},
    {0x5d5c, 0x9bbd}, {0x5d69, 0x9093}, {0x5d6c, 0x9bca}, {0x5d6d, 0xfab3},
    {0x5d6f, 0x8db5}, {0x5d73, 0x9bcb}, {0x5d76, 0x9bcc}, {0x5d82, 0x9bcf},
    {0x5d84, 0x9bce}, {0x5d87, 0x9bcd}, {0x5d8b, 0x9388}, {0x5d8c, 0x9bb8},
    {0x5d90, 0x9bd5}, {0x5d9d, 0x9bd1}, {0x5da2, 0x9bd0}, {0x5dac, 0x9bd2},
    {0x5dae, 0x9bd3}, {0x5db7, 0x9bd6}, {0x5db8, 0xfab4}, {0x5db9, 0xfab5},
    {0x5dba, 0x97e4}, {0x5dbc, 0x9bd7}, {0x5dbd, 0x9bd4}, {0x5dc9, 0x9bd8},
    {0x5dcc, 0x8ade}, {0x5dcd, 0x9bd9}, {0x5dd0, 0xfab6}, {0x5dd2, 0x9bdb},
    {0x5dd3, 0x9bda}, {0x5dd6, 0x9bdc}, {0x5ddb, 0x9bdd}, {0x5ddd, 0x90ec},
    {0x5dde, 0x8f42}, {0x5de1, 0x8f84}, {0x5de3, 0x9183}, {0x5de5, 0x8d48},
    {0x5de6, 0x8db6}, {0x5de7, 0x8d49}, {0x5de8, 0x8b90}, {0x5deb, 0x9bde},
    {0x5dee, 0x8db7}, {0x5df1, 0x8cc8}, {0x5df2, 0x9bdf}, {0x5df3, 0x96a4},
    {0x5df4, 0x9462}, {0x5df5, 0x9be0}, {0x5df7, 0x8d4a}, {0x5dfb, 0x8aaa},
    {0x5dfd, 0x9246}, {0x5dfe, 0x8bd0}, {0x5e02, 0x8e73}, {0x5e03, 0x957a},
    {0x5e06, 0x94bf}, {0x5e0b, 0x9be1}, {0x5e0c, 0x8af3}, {0x5e11, 0x9be4},
    {0x5e16, 0x929f}, {0x5e19, 0x9be3}, {0x5e1a, 0x9be2}, {0x5e1b, 0x9be5},
    {0x5e1d, 0x92e9}, {0x5e25, 0x9083}, {0x5e2b, 0x8e74}, {0x5e2d, 0x90c8},
    {0x5e2f, 0x91d1}, {0x5e30, 0x8b41}, {0x5e33, 0x92a0}, {0x5e36, 0x9be6},
    {0x5e37, 0x9be7}, {0x5e38, 0x8fed}, {0x5e3d, 0x9658}, {0x5e40, 0x9bea},
    {0x5e43, 0x9be9}, {0x5e44, 0x9be8}, {0x5e45, 0x959d}, {0x5e47, 0x9bf1},
    {0x5e4c, 0x9679}, {0x5e4e, 0x9beb}, {0x5e54, 0x9bed}, {0x5e55, 0x968b},
    {0x5e57, 0x9bec}, {0x5e5f, 0x9bee}, {0x5e61, 0x94a6}, {0x5e62, 0x9bef},
    {0x5e63, 0x95bc}, {0x5e64, 0x9bf0}, {0x5e72, 0x8ab1}, {0x5e73, 0x95bd},
    {0x5e74, 0x944e}, {0x5e75, 0x9bf2}, {0x5e76, 0x9bf3}, {0x5e78, 0x8d4b},
    {0x5e79, 0x8ab2}, {0x5e7a, 0x9bf4}, {0x5e7b, 0x8cb6}, {0x5e7c, 0x9763},
    {0x5e7d, 0x9748}, {0x5e7e, 0x8af4}, {0x5e7f, 0x9bf6}, {0x5e81, 0x92a1},
    {0x5e83, 0x8d4c}, {0x5e84, 0x8faf}, {0x5e87, 0x94dd}, {0x5e8a, 0x8fb0},
    {0x5e8f, 0x8f98}, {0x5e95, 0x92ea}, {0x5e96, 0x95f7}, {0x5e97, 0x9358},
    {0x5e9a, 0x8d4d}, {0x5e9c, 0x957b}, {0x5ea0, 0x9bf7}, {0x5ea6, 0x9378},
    {0x5ea7, 0x8dc0}, {0x5eab, 0x8cc9}, {0x5ead, 0x92eb}, {0x5eb5, 0x88c1},
    {0x5eb6, 0x8f8e}, {0x5eb7, 0x8d4e}, {0x5eb8, 0x9766}, {0x5ec1, 0x9bf8},
    {0x5ec2, 0x9bf9}, {0x5ec3, 0x9470}, {0x5ec8, 0x9bfa}, {0x5ec9, 0x97f5},
    {0x5eca, 0x984c}, {0x5ecf, 0x9bfc}, {0x5ed0, 0x9bfb}, {0x5ed3, 0x8a66},
    {0x5ed6, 0x9c40}, {0x5eda, 0x9c43}, {0x5edb, 0x9c44}, {0x5edd, 0x9c42},
    {0x5edf, 0x955f}, {0x5ee0, 0x8fb1}, {0x5ee1, 0x9c46}, {0x5ee2, 0x9c45},
    {0x5ee3, 0x9c41}, {0x5ee8, 0x9c47}, {0x5ee9, 0x9c48}, {0x5eec, 0x9c49},
    {0x5ef0, 0x9c4c}, {0x5ef1, 0x9c4a}, {0x5ef3, 0x9c4b}, {0x5ef4, 0x9c4d},
    {0x5ef6, 0x8984}, {0x5ef7, 0x92ec}, {0x5ef8, 0x9c4e}, {0x5efa, 0x8c9a},
    {0x5efb, 0x89f4}, {0x5efc, 0x9455}, {0x5efe, 0x9c4f}, {0x5eff, 0x93f9},
    {0x5f01, 0x95d9}, {0x5f03, 0x9c50}, {0x5f04, 0x984d}, {0x5f09, 0x9c51},
    {0x5f0a, 0x95be}, {0x5f0b, 0x9c54}, {0x5f0c, 0x989f}, {0x5f0d, 0x98af},
    {0x5f0f, 0x8eae}, {0x5f10, 0x93f3}, {0x5f11, 0x9c55}, {0x5f13, 0x8b7c},
    {0x5f14, 0x92a2}, {0x5f15, 0x88f8}, {0x5f16, 0x9c56}, {0x5f17, 0x95a4},
    {0x5f18, 0x8d4f}, {0x5f1b, 0x926f}, {0x5f1f, 0x92ed}, {0x5f21, 0xfab7},
    {0x5f25, 0x96ed}, {0x5f26, 0x8cb7}, {0x5f27, 0x8cca}, {0x5f29, 0x9c57},
    {0x5f2d, 0x9c58}, {0x5f2f, 0x9c5e}, {0x5f31, 0x8ee3}, {0x5f34, 0xfab8},
    {0x5f35, 0x92a3}, {0x5f37, 0x8bad}, {0x5f38, 0x9c59}, {0x5f3c, 0x954a},
    {0x5f3e, 0x9265}, {0x5f41, 0x9c5a}, {0x5f45, 0xfa67}, {0x5f48, 0x9c5b},
    {0x5f4a, 0x8bae}, {0x5f4c, 0x9c5c}, {0x5f4e, 0x9c5d}, {0x5f51, 0x9c5f},
    {0x5f53, 0x9396}, {0x5f56, 0x9c60}, {0x5f57, 0x9c61}, {0x5f59, 0x9c62},
    {0x5f5c, 0x9c53}, {0x5f5d, 0x9c52}, {0x5f61, 0x9c63}, {0x5f62, 0x8c60},
    {0x5f66, 0x9546}, {0x5f67, 0xfab9}, {0x5f69, 0x8dca}, {0x5f6a, 0x9556},
    {0x5f6b, 0x92a4}, {0x5f6c, 0x956a}, {0x5f6d, 0x9c64}, {0x5f70, 0x8fb2},
    {0x5f71, 0x8965}, {0x5f73, 0x9c65}, {0x5f77, 0x9c66}, {0x5f79, 0x96f0},
    {0x5f7c, 0x94de}, {0x5f7f, 0x9c69}, {0x5f80, 0x899d}, {0x5f81, 0x90aa},
    {0x5f82, 0x9c68}, {0x5f83, 0x9c67}, {0x5f84, 0x8c61}, {0x5f85, 0x91d2},
    {0x5f87, 0x9c6d}, {0x5f88, 0x9c6b}, {0x5f8a, 0x9c6a}, {0x5f8b, 0x97a5},
    {0x5f8c, 0x8ce3}, {0x5f90, 0x8f99}, {0x5f91, 0x9c6c}, {0x5f92, 0x936b},
    {0x5f93, 0x8f5d}, {0x5f97, 0x93be}, {0x5f98, 0x9c70}, {0x5f99, 0x9c6f},
    {0x5f9e, 0x9c6e}, {0x5fa0, 0x9c71}, {0x5fa1, 0x8ce4}, {0x5fa8, 0x9c72},
    {0x5fa9, 0x959c}, {0x5faa, 0x8f7a}, {0x5fad, 0x9c73}, {0x5fae, 0x94f7},
    {0x5fb3, 0x93bf}, {0x5fb4, 0x92a5}, {0x5fb7, 0xfaba}, {0x5fb9, 0x934f},
    {0x5fbc, 0x9c74}, {0x5fbd, 0x8b4a}, {0x5fc3, 0x9053}, {0x5fc5, 0x954b},
    {0x5fcc, 0x8af5}, {0x5fcd, 0x9445}, {0x5fd6, 0x9c75}, {0x5fd7, 0x8e75},
    {0x5fd8, 0x9659}, {0x5fd9, 0x965a}, {0x5fdc, 0x899e}, {0x5fdd, 0x9c7a},
    {0x5fde, 0xfabb}, {0x5fe0, 0x9289}, {0x5fe4, 0x9c77}, {0x5feb, 0x89f5},
    {0x5ff0, 0x9cab}, {0x5ff1, 0x9c79}, {0x5ff5, 0x944f}, {0x5ff8, 0x9c78},
    {0x5ffb, 0x9c76}, {0x5ffd, 0x8d9a}, {0x5fff, 0x9c7c}, {0x600e, 0x9c83},
    {0x600f, 0x9c89}, {0x6010, 0x9c81}, {0x6012, 0x937b}, {0x6015, 0x9c86},
    {0x6016, 0x957c}, {0x6019, 0x9c80}, {0x601b, 0x9c85}, {0x601c, 0x97e5},
    {0x601d, 0x8e76}, {0x6020, 0x91d3}, {0x6021, 0x9c7d}, {0x6025, 0x8b7d},
    {0x6026, 0x9c88}, {0x6027, 0x90ab}, {0x6028, 0x8985}, {0x6029, 0x9c82},
    {0x602a, 0x89f6}, {0x602b, 0x9c87}, {0x602f, 0x8baf}, {0x6031, 0x9c84},
    {0x603a, 0x9c8a}, {0x6041, 0x9c8c}, {0x6042, 0x9c96}, {0x6043, 0x9c94},
    {0x6046, 0x9c91}, {0x604a, 0x9c90}, {0x604b, 0x97f6}, {0x604d, 0x9c92},
    {0x6050, 0x8bb0}, {0x6052, 0x8d50}, {0x6055, 0x8f9a}, {0x6059, 0x9c99},
    {0x605a, 0x9c8b}, {0x605d, 0xfabc}, {0x605f, 0x9c8f}, {0x6060, 0x9c7e},
    {0x6062, 0x89f8}, {0x6063, 0x9c93}, {0x6064, 0x9c95}, {0x6065, 0x9270},
    {0x6068, 0x8da6}, {0x6069, 0x89b6}, {0x606a, 0x9c8d}, {0x606b, 0x9c98},
    {0x606c, 0x9c97}, {0x606d, 0x8bb1}, {0x606f, 0x91a7}, {0x6070, 0x8a86},
    {0x6075, 0x8c62}, {0x6077, 0x9c8e}, {0x6081, 0x9c9a}, {0x6083, 0x9c9d},
    {0x6084, 0x9c9f}, {0x6085, 0xfabd}, {0x6089, 0x8ebb}, {0x608a, 0xfabe},
    {0x608b, 0x9ca5}, {0x608c, 0x92ee}, {0x608d, 0x9c9b}, {0x6092, 0x9ca3},
    {0x6094, 0x89f7}, {0x6096, 0x9ca1}, {0x6097, 0x9ca2}, {0x609a, 0x9c9e},
    {0x609b, 0x9ca0}, {0x609f, 0x8ce5}, {0x60a0, 0x9749}, {0x60a3, 0x8ab3},
    {0x60a6, 0x8978}, {0x60a7, 0x9ca4}, {0x60a9, 0x9459}, {0x60aa, 0x88ab},
    {0x60b2, 0x94df}, {0x60b3, 0x9c7b}, {0x60b4, 0x9caa}, {0x60b5, 0x9cae},
    {0x60b6, 0x96e3}, {0x60b8, 0x9ca7}, {0x60bc, 0x9389}, {0x60bd, 0x9cac},
    {0x60c5, 0x8fee}, {0x60c6, 0x9cad}, {0x60c7, 0x93d5}, {0x60d1, 0x9866},
    {0x60d3, 0x9ca9}, {0x60d5, 0xfac0}, {0x60d8, 0x9caf}, {0x60da, 0x8d9b},
    {0x60dc, 0x90c9}, {0x60de, 0xfabf}, {0x60df, 0x88d2}, {0x60e0, 0x9ca8},
    {0x60e1, 0x9ca6}, {0x60e3, 0x9179}, {0x60e7, 0x9c9c}, {0x60e8, 0x8e53},
    {0x60f0, 0x91c4}, {0x60f1, 0x9cbb}, {0x60f2, 0xfac2}, {0x60f3, 0x917a},
    {0x60f4, 0x9cb6}, {0x60f6, 0x9cb3}, {0x60f7, 0x9cb4}, {0x60f9, 0x8ee4},
    {0x60fa, 0x9cb7}, {0x60fb, 0x9cba}, {0x6100, 0x9cb5}, {0x6101, 0x8f44},
    {0x6103, 0x9cb8}, {0x6106, 0x9cb2}, {0x6108, 0x96fa}, {0x6109, 0x96f9},
    {0x610d, 0x9cbc}, {0x610e, 0x9cbd}, {0x610f, 0x88d3}, {0x6111, 0xfac3},
    {0x6115, 0x9cb1}, {0x611a, 0x8bf0}, {0x611b, 0x88a4}, {0x611f, 0x8ab4},
    {0x6120, 0xfac1}, {0x6121, 0x9cb9}, {0x6127, 0x9cc1}, {0x6128, 0x9cc0},
    {0x612c, 0x9cc5}, {0x6130, 0xfac5}, {0x6134, 0x9cc6}, {0x6137, 0xfac4},
    {0x613c, 0x9cc4}, {0x613d, 0x9cc7}, {0x613e, 0x9cbf}, {0x613f, 0x9cc3},
    {0x6142, 0x9cc8}, {0x6144, 0x9cc9}, {0x6147, 0x9cbe}, {0x6148, 0x8e9c},
    {0x614a, 0x9cc2}, {0x614b, 0x91d4}, {0x614c, 0x8d51}, {0x614d, 0x9cb0},
    {0x614e, 0x9054}, {0x6153, 0x9cd6}, {0x6155, 0x95e7}, {0x6158, 0x9ccc},
    {0x6159, 0x9ccd}, {0x615a, 0x9cce}, {0x615d, 0x9cd5}, {0x615f, 0x9cd4},
    {0x6162, 0x969d}, {0x6163, 0x8ab5}, {0x6165, 0x9cd2}, {0x6167, 0x8c64},
    {0x6168, 0x8a53}, {0x616b, 0x9ccf}, {0x616e, 0x97b6}, {0x616f, 0x9cd1},
    {0x6170, 0x88d4}, {0x6171, 0x9cd3}, {0x6173, 0x9cca}, {0x6174, 0x9cd0},
    {0x6175, 0x9cd7}, {0x6176, 0x8c63}, {0x6177, 0x9ccb}, {0x617e, 0x977c},
    {0x6182, 0x974a}, {0x6187, 0x9cda}, {0x618a, 0x9cde}, {0x618e, 0x919e},
    {0x6190, 0x97f7}, {0x6191, 0x9cdf}, {0x6194, 0x9cdc}, {0x6196, 0x9cd9},
    {0x6198, 0xfac6}, {0x6199, 0x9cd8}, {0x619a, 0x9cdd}, {0x61a4, 0x95ae},
    {0x61a7, 0x93b2}, {0x61a9, 0x8c65}, {0x61ab, 0x9ce0}, {0x61ac, 0x9cdb},
    {0x61ae, 0x9ce1}, {0x61b2, 0x8c9b}, {0x61b6, 0x89af}, {0x61ba, 0x9ce9},
    {0x61be, 0x8ab6}, {0x61c3, 0x9ce7}, {0x61c6, 0x9ce8}, {0x61c7, 0x8da7},
    {0x61c8, 0x9ce6}, {0x61c9, 0x9ce4}, {0x61ca, 0x9ce3}, {0x61cb, 0x9cea},
    {0x61cc, 0x9ce2}, {0x61cd, 0x9cec}, {0x61d0, 0x89f9}, {0x61e3, 0x9cee},
    {0x61e6, 0x9ced}, {0x61f2, 0x92a6}, {0x61f4, 0x9cf1}, {0x61f6, 0x9cef},
    {0x61f7, 0x9ce5}, {0x61f8, 0x8c9c}, {0x61fa, 0x9cf0}, {0x61fc, 0x9cf4},
    {0x61fd, 0x9cf3}, {0x61fe, 0x9cf5}, {0x61ff, 0x9cf2}, {0x6200, 0x9cf6},
    {0x6208, 0x9cf7}, {0x6209, 0x9cf8}, {0x620a, 0x95e8}, {0x620c, 0x9cfa},
    {0x620d, 0x9cf9}, {0x620e, 0x8f5e}, {0x6210, 0x90ac}, {0x6211, 0x89e4},
    {0x6212, 0x89fa}, {0x6213, 0xfac7}, {0x6214, 0x9cfb}, {0x6216, 0x88bd},
    {0x621a, 0x90ca}, {0x621b, 0x9cfc}, {0x621d, 0xe6c1}, {0x621e, 0x9d40},
    {0x621f, 0x8c81}, {0x6221, 0x9d41}, {0x6226, 0x90ed}, {0x622a, 0x9d42},
    {0x622e, 0x9d43}, {0x622f, 0x8b59}, {0x6230, 0x9d44}, {0x6232, 0x9d45},
    {0x6233, 0x9d46}, {0x6234, 0x91d5}, {0x6238, 0x8ccb}, {0x623b, 0x96df},
    {0x623f, 0x965b}, {0x6240, 0x8f8a}, {0x6241, 0x9d47}, {0x6247, 0x90ee},
    {0x6248, 0xe7bb}, {0x6249, 0x94e0}, {0x624b, 0x8ee8}, {0x624d, 0x8dcb},
    {0x624e, 0x9d48}, {0x6253, 0x91c5}, {0x6255, 0x95a5}, {0x6258, 0x91ef},
    {0x625b, 0x9d4b}, {0x625e, 0x9d49}, {0x6260, 0x9d4c}, {0x6263, 0x9d4a},
    {0x6268, 0x9d4d}, {0x626e, 0x95af}, {0x6271, 0x88b5}, {0x6276, 0x957d},
    {0x6279, 0x94e1}, {0x627c, 0x9d4e}, {0x627e, 0x9d51}, {0x627f, 0x8fb3},
    {0x6280, 0x8b5a}, {0x6282, 0x9d4f}, {0x6283, 0x9d56}, {0x6284, 0x8fb4},
    {0x6289, 0x9d50}, {0x628a, 0x9463}, {0x6291, 0x977d}, {0x6292, 0x9d52},
    {0x6293, 0x9d53}, {0x6294, 0x9d57}, {0x6295, 0x938a}, {0x6296, 0x9d54},
    {0x6297, 0x8d52}, {0x6298, 0x90dc}, {0x629b, 0x9d65}, {0x629c, 0x94b2},
    {0x629e, 0x91f0}, {0x62a6, 0xfac8}, {0x62ab, 0x94e2}, {0x62ac, 0x9dab},
    {0x62b1, 0x95f8}, {0x62b5, 0x92ef}, {0x62b9, 0x9695}, {0x62bb, 0x9d5a},
    {0x62bc, 0x899f}, {0x62bd, 0x928a}, {0x62c2, 0x9d63}, {0x62c5, 0x9253},
    {0x62c6, 0x9d5d}, {0x62c7, 0x9d64}, {0x62c8, 0x9d5f}, {0x62c9, 0x9d66},
    {0x62ca, 0x9d62}, {0x62cc, 0x9d61}, {0x62cd, 0x948f}, {0x62cf, 0x9d5b},
    {0x62d0, 0x89fb}, {0x62d1, 0x9d59}, {0x62d2, 0x8b91}, {0x62d3, 0x91f1},
    {0x62d4, 0x9d55}, {0x62d7, 0x9d58}, {0x62d8, 0x8d53}, {0x62d9, 0x90d9},
    {0x62db, 0x8fb5}, {0x62dc, 0x9d60}, {0x62dd, 0x9471}, {0x62e0, 0x8b92},
    {0x62e1, 0x8a67}, {0x62ec, 0x8a87}, {0x62ed, 0x9040}, {0x62ee, 0x9d68},
    {0x62ef, 0x9d6d}, {0x62f1, 0x9d69}, {0x62f3, 0x8c9d}, {0x62f5, 0x9d6e},
    {0x62f6, 0x8e41}, {0x62f7, 0x8d89}, {0x62fe, 0x8f45}, {0x62ff, 0x9d5c},
    {0x6301, 0x8e9d}, {0x6302, 0x9d6b}, {0x6307, 0x8e77}, {0x6308, 0x9d6c},
    {0x6309, 0x88c2}, {0x630c, 0x9d67}, {0x6311, 0x92a7}, {0x6319, 0x8b93},
    {0x631f, 0x8bb2}, {0x6327, 0x9d6a}, {0x6328, 0x88a5}, {0x632b, 0x8dc1},
    {0x632f, 0x9055}, {0x633a, 0x92f0}, {0x633d, 0x94d2}, {0x633e, 0x9d70},
    {0x633f, 0x917d}, {0x6349, 0x91a8}, {0x634c, 0x8e4a}, {0x634d, 0x9d71},
    {0x634f, 0x9d73}, {0x6350, 0x9d6f}, {0x6355, 0x95df}, {0x6357, 0x92bb},
    {0x635c, 0x917b}, {0x6367, 0x95f9}, {0x6368, 0x8ecc}, {0x6369, 0x9d80},
    {0x636b, 0x9d7e}, {0x636e, 0x9098}, {0x6372, 0x8c9e}, {0x6376, 0x9d78},
    {0x6377, 0x8fb7}, {0x637a, 0x93e6}, {0x637b, 0x9450}, {0x6380, 0x9d76},
    {0x6383, 0x917c}, {0x6388, 0x8ef6}, {0x6389, 0x9d7b}, {0x638c, 0x8fb6},
    {0x638e, 0x9d75}, {0x638f, 0x9d7a}, {0x6392, 0x9472}, {0x6396, 0x9d74},
    {0x6398, 0x8c40}, {0x639b, 0x8a7c}, {0x639f, 0x9d7c}, {0x63a0, 0x97a9},
    {0x63a1, 0x8dcc}, {0x63a2, 0x9254}, {0x63a3, 0x9d79}, {0x63a5, 0x90da},
    {0x63a7, 0x8d54}, {0x63a8, 0x9084}, {0x63a9, 0x8986}, {0x63aa, 0x915b},
    {0x63ab, 0x9d77}, {0x63ac, 0x8b64}, {0x63b2, 0x8c66}, {0x63b4, 0x92cd},
    {0x63b5, 0x9d7d}, {0x63bb, 0x917e}, {0x63be, 0x9d81}, {0x63c0, 0x9d83},
    {0x63c3, 0x91b5}, {0x63c4, 0x9d89}, {0x63c6, 0x9d84}, {0x63c9, 0x9d86},
    {0x63cf, 0x9560}, {0x63d0, 0x92f1}, {0x63d2, 0x9d87}, {0x63d6, 0x974b},
    {0x63da, 0x9767}, {0x63db, 0x8ab7}, {0x63e1, 0x88ac}, {0x63e3, 0x9d85},
    {0x63e9, 0x9d82}, {0x63ee, 0x8af6}, {0x63f4, 0x8987}, {0x63f5, 0xfac9},
    {0x63f6, 0x9d88}, {0x63fa, 0x9768}, {0x6406, 0x9d8c}, {0x640d, 0x91b9},
    {0x640f, 0x9d93}, {0x6413, 0x9d8d}, {0x6414, 0x917e}, {0x6416, 0x9d8a},
    {0x6417, 0x9d91}, {0x641c, 0x9d72}, {0x6426, 0x9d8e}, {0x6428, 0x9d92},
    {0x642c, 0x94c0}, {0x642d, 0x938b}, {0x6434, 0x9d8b}, {0x6436, 0x9d8f},
    {0x643a, 0x8c67}, {0x643e, 0x8def}, {0x6442, 0x90db}, {0x644e, 0x9d97},
    {0x6451, 0x92cd}, {0x6458, 0x9345}, {0x6460, 0xfaca}, {0x6467, 0x9d94},
    {0x6469, 0x9680}, {0x646f, 0x9d95}, {0x6476, 0x9d96}, {0x6478, 0x96cc},
    {0x647a, 0x90a0}, {0x6483, 0x8c82}, {0x6488, 0x9d9d}, {0x6492, 0x8e54},
    {0x6493, 0x9d9a}, {0x6495, 0x9d99}, {0x649a, 0x9451}, {0x649d, 0xfacb},
    {0x649e, 0x93b3}, {0x64a4, 0x9350}, {0x64a5, 0x9d9b}, {0x64a9, 0x9d9c},
    {0x64ab, 0x958f}, {0x64ad, 0x9464}, {0x64ae, 0x8e42}, {0x64b0, 0x90ef},
    {0x64b2, 0x966f}, {0x64b9, 0x8a68}, {0x64bb, 0x9da3}, {0x64bc, 0x9d9e},
    {0x64c1, 0x9769}, {0x64c2, 0x9da5}, {0x64c5, 0x9da1}, {0x64c7, 0x9da2},
    {0x64cd, 0x9180}, {0x64ce, 0xfacc}, {0x64d2, 0x9da0}, {0x64d4, 0x9d5e},
    {0x64d8, 0x9da4}, {0x64da, 0x9d9f}, {0x64e0, 0x9da9}, {0x64e1, 0x9daa},
    {0x64e2, 0x9346}, {0x64e3, 0x9dac}, {0x64e6, 0x8e43}, {0x64e7, 0x9da7},
    {0x64ec, 0x8b5b}, {0x64ef, 0x9dad}, {0x64f1, 0x9da6}, {0x64f2, 0x9db1},
    {0x64f4, 0x9db0}, {0x64f6, 0x9daf}, {0x64fa, 0x9db2}, {0x64fd, 0x9db4},
    {0x64fe, 0x8fef}, {0x6500, 0x9db3}, {0x6505, 0x9db7}, {0x6518, 0x9db5},
    {0x651c, 0x9db6}, {0x651d, 0x9d90}, {0x6522, 0x9db7}, {0x6523, 0x9db9},
    {0x6524, 0x9db8}, {0x652a, 0x9d98}, {0x652b, 0x9dba}, {0x652c, 0x9dae},
    {0x652f, 0x8e78}, {0x6534, 0x9dbb}, {0x6535, 0x9dbc}, {0x6536, 0x9dbe},
    {0x6537, 0x9dbd}, {0x6538, 0x9dbf}, {0x6539, 0x89fc}, {0x653b, 0x8d55},
    {0x653e, 0x95fa}, {0x653f, 0x90ad}, {0x6545, 0x8ccc}, {0x6548, 0x9dc1},
    {0x654d, 0x9dc4}, {0x654e, 0xfacd}, {0x654f, 0x9571}, {0x6551, 0x8b7e},
    {0x6555, 0x9dc3}, {0x6556, 0x9dc2}, {0x6557, 0x9473}, {0x6558, 0x9dc5},
    {0x6559, 0x8bb3}, {0x655d, 0x9dc7}, {0x655e, 0x9dc6}, {0x6562, 0x8ab8},
    {0x6563, 0x8e55}, {0x6566, 0x93d6}, {0x656c, 0x8c68}, {0x6570, 0x9094},
    {0x6572, 0x9dc8}, {0x6574, 0x90ae}, {0x6575, 0x9347}, {0x6577, 0x957e},
    {0x6578, 0x9dc9}, {0x6582, 0x9dca}, {0x6583, 0x9dcb}, {0x6587, 0x95b6},
    {0x6588, 0x9b7c}, {0x6589, 0x90c4}, {0x658c, 0x956b}, {0x658e, 0x8dd6},
    {0x6590, 0x94e3}, {0x6591, 0x94c1}, {0x6597, 0x936c}, {0x6599, 0x97bf},
    {0x659b, 0x9dcd}, {0x659c, 0x8ece}, {0x659f, 0x9dce}, {0x65a1, 0x88b4},
    {0x65a4, 0x8bd2}, {0x65a5, 0x90cb}, {0x65a7, 0x9580}, {0x65ab, 0x9dcf},
    {0x65ac, 0x8e61}, {0x65ad, 0x9266}, {0x65af, 0x8e7a}, {0x65b0, 0x9056},
    {0x65b7, 0x9dd0}, {0x65b9, 0x95fb}, {0x65bc, 0x8997}, {0x65bd, 0x8e7b},
    {0x65c1, 0x9dd3}, {0x65c3, 0x9dd1}, {0x65c4, 0x9dd4}, {0x65c5, 0x97b7},
    {0x65c6, 0x9dd2}, {0x65cb, 0x90f9}, {0x65cc, 0x9dd5}, {0x65cf, 0x91b0},
    {0x65d2, 0x9dd6}, {0x65d7, 0x8af8}, {0x65d9, 0x9dd8}, {0x65db, 0x9dd7},
    {0x65e0, 0x9dd9}, {0x65e1, 0x9dda}, {0x65e2, 0x8af9}, {0x65e5, 0x93fa},
    {0x65e6, 0x9255}, {0x65e7, 0x8b8c}, {0x65e8, 0x8e7c}, {0x65e9, 0x9181},
    {0x65ec, 0x8f7b}, {0x65ed, 0x88ae}, {0x65f1, 0x9ddb}, {0x65fa, 0x89a0},
    {0x65fb, 0x9ddf}, {0x6600, 0xface}, {0x6602, 0x8d56}, {0x6603, 0x9dde},
    {0x6606, 0x8da9}, {0x6607, 0x8fb8}, {0x6609, 0xfad1}, {0x660a, 0x9ddd},
    {0x660c, 0x8fb9}, {0x660e, 0x96be}, {0x660f, 0x8da8}, {0x6613, 0x88d5},
    {0x6614, 0x90cc}, {0x6615, 0xfacf}, {0x661c, 0x9de4}, {0x661e, 0xfad3},
    {0x661f, 0x90af}, {0x6620, 0x8966}, {0x6624, 0xfad4}, {0x6625, 0x8f74},
    {0x6627, 0x9686}, {0x6628, 0x8df0}, {0x662d, 0x8fba}, {0x662e, 0xfad2},
    {0x662f, 0x90a5}, {0x6631, 0xfa63}, {0x6634, 0x9de3}, {0x6635, 0x9de1},
    {0x6636, 0x9de2}, {0x663b, 0xfad0}, {0x663c, 0x928b}, {0x663f, 0x9e45},
    {0x6641, 0x9de8}, {0x6642, 0x8e9e}, {0x6643, 0x8d57}, {0x6644, 0x9de6},
    {0x6649, 0x9de7}, {0x664b, 0x9057}, {0x664f, 0x9de5}, {0x6652, 0x8e4e},
    {0x6657, 0xfad6}, {0x6659, 0xfad7}, {0x665d, 0x9dea}, {0x665e, 0x9de9},
    {0x665f, 0x9dee}, {0x6662, 0x9def}, {0x6664, 0x9deb}, {0x6665, 0xfad5},
    {0x6666, 0x8a41}, {0x6667, 0x9dec}, {0x6668, 0x9ded}, {0x6669, 0x94d3},
    {0x666e, 0x9581}, {0x666f, 0x8c69}, {0x6670, 0x9df0}, {0x6673, 0xfad9},
    {0x6674, 0x90b0}, {0x6676, 0x8fbb}, {0x667a, 0x9271}, {0x6681, 0x8bc5},
    {0x6683, 0x9df1}, {0x6684, 0x9df5}, {0x6687, 0x89c9}, {0x6688, 0x9df2},
    {0x6689, 0x9df4}, {0x668e, 0x9df3}, {0x6691, 0x8f8b}, {0x6696, 0x9267},
    {0x6697, 0x88c3}, {0x6698, 0x9df6}, {0x6699, 0xfada}, {0x669d, 0x9df7},
    {0x66a0, 0xfadb}, {0x66a2, 0x92a8}, {0x66a6, 0x97ef}, {0x66ab, 0x8e62},
    {0x66ae, 0x95e9}, {0x66b2, 0xfadc}, {0x66b4, 0x965c}, {0x66b8, 0x9e41},
    {0x66b9, 0x9df9}, {0x66bc, 0x9dfc}, {0x66be, 0x9dfb}, {0x66bf, 0xfadd},
    {0x66c1, 0x9df8}, {0x66c4, 0x9e40}, {0x66c7, 0x93dc}, {0x66c9, 0x9dfa},
    {0x66d6, 0x9e42}, {0x66d9, 0x8f8c}, {0x66da, 0x9e43}, {0x66dc, 0x976a},
    {0x66dd, 0x9498}, {0x66e0, 0x9e44}, {0x66e6, 0x9e46}, {0x66e9, 0x9e47},
    {0x66f0, 0x9e48}, {0x66f2, 0x8bc8}, {0x66f3, 0x8967}, {0x66f4, 0x8d58},
    {0x66f5, 0x9e49}, {0x66f7, 0x9e4a}, {0x66f8, 0x8f91}, {0x66f9, 0x9182},
    {0x66fa, 0xfade}, {0x66fb, 0xfa66}, {0x66fc, 0x99d6}, {0x66fd, 0x915d},
    {0x66fe, 0x915c}, {0x66ff, 0x91d6}, {0x6700, 0x8dc5}, {0x6703, 0x98f0},
    {0x6708, 0x8c8e}, {0x6709, 0x974c}, {0x670b, 0x95fc}, {0x670d, 0x959e},
    {0x670e, 0xfadf}, {0x670f, 0x9e4b}, {0x6714, 0x8df1}, {0x6715, 0x92bd},
    {0x6716, 0x9e4c}, {0x6717, 0x984e}, {0x671b, 0x965d}, {0x671d, 0x92a9},
    {0x671e, 0x9e4d}, {0x671f, 0x8afa}, {0x6726, 0x9e4e}, {0x6727, 0x9e4f},
    {0x6728, 0x96d8}, {0x672a, 0x96a2}, {0x672b, 0x9696}, {0x672c, 0x967b},
    {0x672d, 0x8e44}, {0x672e, 0x9e51}, {0x6731, 0x8ee9}, {0x6734, 0x9670},
    {0x6736, 0x9e53}, {0x6737, 0x9e56}, {0x6738, 0x9e55}, {0x673a, 0x8af7},
    {0x673d, 0x8b80}, {0x673f, 0x9e52}, {0x6741, 0x9e54}, {0x6746, 0x9e57},
    {0x6749, 0x9099}, {0x674e, 0x979b}, {0x674f, 0x88c7}, {0x6750, 0x8dde},
    {0x6751, 0x91ba}, {0x6753, 0x8edb}, {0x6756, 0x8ff1}, {0x6759, 0x9e5a},
    {0x675c, 0x936d}, {0x675e, 0x9e58}, {0x675f, 0x91a9}, {0x6760, 0x9e59},
    {0x6761, 0x8ff0}, {0x6762, 0x96db}, {0x6763, 0x9e5b}, {0x6764, 0x9e5c},
    {0x6765, 0x9788}, {0x6766, 0xfae1}, {0x676a, 0x9e61}, {0x676d, 0x8d59},
    {0x676f, 0x9474}, {0x6770, 0x9e5e}, {0x6771, 0x938c}, {0x6772, 0x9ddc},
    {0x6773, 0x9de0}, {0x6775, 0x8b6e}, {0x6777, 0x9466}, {0x677c, 0x9e60},
    {0x677e, 0x8fbc}, {0x677f, 0x94c2}, {0x6785, 0x9e66}, {0x6787, 0x94f8},
    {0x6789, 0x9e5d}, {0x678b, 0x9e63}, {0x678c, 0x9e62}, {0x6790, 0x90cd},
    {0x6795, 0x968d}, {0x6797, 0x97d1}, {0x679a, 0x9687}, {0x679c, 0x89ca},
    {0x679d, 0x8e7d}, {0x67a0, 0x9867}, {0x67a1, 0x9e65}, {0x67a2, 0x9095},
    {0x67a6, 0x9e64}, {0x67a9, 0x9e5f}, {0x67af, 0x8ccd}, {0x67b3, 0x9e6b},
    {0x67b4, 0x9e69}, {0x67b6, 0x89cb}, {0x67b7, 0x9e67}, {0x67b8, 0x9e6d},
    {0x67b9, 0x9e73}, {0x67bb, 0xfae2}, {0x67c0, 0xfae4}, {0x67c1, 0x91c6},
    {0x67c4, 0x95bf}, {0x67c6, 0x9e75}, {0x67ca, 0x9541}, {0x67ce, 0x9e74},
    {0x67cf, 0x9490}, {0x67d0, 0x965e}, {0x67d1, 0x8ab9}, {0x67d3, 0x90f5},
    {0x67d4, 0x8f5f}, {0x67d8, 0x92d1}, {0x67da, 0x974d}, {0x67dd, 0x9e70},
    {0x67de, 0x9e6f}, {0x67e2, 0x9e71}, {0x67e4, 0x9e6e}, {0x67e7, 0x9e76},
    {0x67e9, 0x9e6c}, {0x67ec, 0x9e6a}, {0x67ee, 0x9e72}, {0x67ef, 0x9e68},
    {0x67f1, 0x928c}, {0x67f3, 0x96f6}, {0x67f4, 0x8ec4}, {0x67f5, 0x8df2},
    {0x67fb, 0x8db8}, {0x67fe, 0x968f}, {0x67ff, 0x8a60}, {0x6801, 0xfae5},
    {0x6802, 0x92cc}, {0x6803, 0x93c8}, {0x6804, 0x8968}, {0x6805, 0x8df2},
    {0x6813, 0x90f0}, {0x6816, 0x90b2}, {0x6817, 0x8c49}, {0x681e, 0x9e78},
    {0x6821, 0x8d5a}, {0x6822, 0x8a9c}, {0x6829, 0x9e7a}, {0x682a, 0x8a94},
    {0x682b, 0x9e81}, {0x6832, 0x9e7d}, {0x6834, 0x90f1}, {0x6838, 0x8a6a},
    {0x6839, 0x8daa}, {0x683c, 0x8a69}, {0x683d, 0x8dcd}, {0x6840, 0x9e7b},
    {0x6841, 0x8c85}, {0x6842, 0x8c6a}, {0x6843, 0x938d}, {0x6844, 0xfae6},
    {0x6846, 0x9e79}, {0x6848, 0x88c4}, {0x684d, 0x9e7c}, {0x684e, 0x9e7e},
    {0x6850, 0x8bcb}, {0x6851, 0x8c4b}, {0x6852, 0xfae3}, {0x6853, 0x8aba},
    {0x6854, 0x8b6a}, {0x6859, 0x9e82}, {0x685c, 0x8df7}, {0x685d, 0x9691},
    {0x685f, 0x8e56}, {0x6863, 0x9e83}, {0x6867, 0x954f}, {0x6874, 0x9e8f},
    {0x6876, 0x89b1}, {0x6877, 0x9e84}, {0x687e, 0x9e95}, {0x687f, 0x9e85},
    {0x6881, 0x97c0}, {0x6883, 0x9e8c}, {0x6885, 0x947e}, {0x688d, 0x9e94},
    {0x688e, 0x9e94}, {0x688f, 0x9e87}, {0x6893, 0x88b2}, {0x6894, 0x9e89},
    {0x6897, 0x8d5b}, {0x689b, 0x9e8b}, {0x689d, 0x9e8a}, {0x689f, 0x9e86},
    {0x68a0, 0x9e91}, {0x68a2, 0x8fbd}, {0x68a6, 0x9aeb}, {0x68a7, 0x8ce6},
    {0x68a8, 0x979c}, {0x68ad, 0x9e88}, {0x68af, 0x92f2}, {0x68b0, 0x8a42},
    {0x68b1, 0x8dab}, {0x68b3, 0x9e80}, {0x68b5, 0x9e90}, {0x68b6, 0x8a81},
    {0x68b9, 0x9e8e}, {0x68ba, 0x9e92}, {0x68bc, 0x938e}, {0x68c4, 0x8afc},
    {0x68c6, 0x9eb0}, {0x68c8, 0xfa64}, {0x68c9, 0x96c7}, {0x68ca, 0x9e97},
    {0x68cb, 0x8afb}, {0x68cd, 0x9e9e}, {0x68cf, 0xfae7}, {0x68d2, 0x965f},
    {0x68d4, 0x9e9f}, {0x68d5, 0x9ea1}, {0x68d7, 0x9ea5}, {0x68d8, 0x9e99},
    {0x68da, 0x9249}, {0x68df, 0x938f}, {0x68e0, 0x9ea9}, {0x68e1, 0x9e9c},
    {0x68e3, 0x9ea6}, {0x68e7, 0x9ea0}, {0x68ee, 0x9058}, {0x68ef, 0x9eaa},
    {0x68f2, 0x90b1}, {0x68f9, 0x9ea8}, {0x68fa, 0x8abb}, {0x6900, 0x986f},
    {0x6901, 0x9e96}, {0x6904, 0x9ea4}, {0x6905, 0x88d6}, {0x6908, 0x9e98},
    {0x690b, 0x96b8}, {0x690c, 0x9e9d}, {0x690d, 0x9041}, {0x690e, 0x92c5},
    {0x690f, 0x9e93}, {0x6912, 0x9ea3}, {0x6919, 0x909a}, {0x691a, 0x9ead},
    {0x691b, 0x8a91}, {0x691c, 0x8c9f}, {0x6921, 0x9eaf}, {0x6922, 0x9e9a},
    {0x6923, 0x9eae}, {0x6925, 0x9ea7}, {0x6926, 0x9e9b}, {0x6928, 0x9eab},
    {0x692a, 0x9eac}, {0x6930, 0x9ebd}, {0x6934, 0x93cc}, {0x6936, 0x9ea2},
    {0x6939, 0x9eb9}, {0x693d, 0x9ebb}, {0x693f, 0x92d6}, {0x694a, 0x976b},
    {0x6953, 0x9596}, {0x6954, 0x9eb6}, {0x6955, 0x91c8}, {0x6959, 0x9ebc},
    {0x695a, 0x915e}, {0x695c, 0x9eb3}, {0x695d, 0x9ec0}, {0x695e, 0x9ebf},
    {0x6960, 0x93ed}, {0x6961, 0x9ebe}, {0x6962, 0x93e8}, {0x6968, 0xfae9},
    {0x696a, 0x9ec2}, {0x696b, 0x9eb5}, {0x696d, 0x8bc6}, {0x696e, 0x9eb8},
    {0x696f, 0x8f7c}, {0x6973, 0x9480}, {0x6974, 0x9eba}, {0x6975, 0x8bc9},
    {0x6977, 0x9eb2}, {0x6978, 0x9eb4}, {0x6979, 0x9eb1}, {0x697c, 0x984f},
    {0x697d, 0x8a79}, {0x697e, 0x9eb7}, {0x6981, 0x9ec1}, {0x6982, 0x8a54},
    {0x698a, 0x8de5}, {0x698e, 0x897c}, {0x6991, 0x9ed2}, {0x6994, 0x9850},
    {0x6995, 0x9ed5}, {0x6998, 0xfaeb}, {0x699b, 0x9059}, {0x699c, 0x9ed4},
    {0x69a0, 0x9ed3}, {0x69a7, 0x9ed0}, {0x69ae, 0x9ec4}, {0x69b1, 0x9ee1},
    {0x69b2, 0x9ec3}, {0x69b4, 0x9ed6}, {0x69bb, 0x9ece}, {0x69be, 0x9ec9},
    {0x69bf, 0x9ec6}, {0x69c1, 0x9ec7}, {0x69c3, 0x9ecf}, {0x69c7, 0xeaa0},
    {0x69ca, 0x9ecc}, {0x69cb, 0x8d5c}, {0x69cc, 0x92c6}, {0x69cd, 0x9184},
    {0x69ce, 0x9eca}, {0x69d0, 0x9ec5}, {0x69d3, 0x9ec8}, {0x69d8, 0x976c},
    {0x69d9, 0x968a}, {0x69dd, 0x9ecd}, {0x69de, 0x9ed7}, {0x69e2, 0xfaec},
    {0x69e7, 0x9edf}, {0x69e8, 0x9ed8}, {0x69eb, 0x9ee5}, {0x69ed, 0x9ee3},
    {0x69f2, 0x9ede}, {0x69f9, 0x9edd}, {0x69fb, 0x92ce}, {0x69fd, 0x9185},
    {0x69ff, 0x9edb}, {0x6a02, 0x9ed9}, {0x6a05, 0x9ee0}, {0x6a0a, 0x9ee6},
    {0x6a0b, 0x94f3}, {0x6a0c, 0x9eec}, {0x6a12, 0x9ee7}, {0x6a13, 0x9eea},
    {0x6a14, 0x9ee4}, {0x6a17, 0x9294}, {0x6a19, 0x9557}, {0x6a1b, 0x9eda},
    {0x6a1e, 0x9ee2}, {0x6a1f, 0x8fbe}, {0x6a21, 0x96cd}, {0x6a22, 0x9ef6},
    {0x6a23, 0x9ee9}, {0x6a29, 0x8ca0}, {0x6a2a, 0x89a1}, {0x6a2b, 0x8a7e},
    {0x6a2e, 0x9ed1}, {0x6a30, 0xfaed}, {0x6a35, 0x8fbf}, {0x6a36, 0x9eee},
    {0x6a38, 0x9ef5}, {0x6a39, 0x8ef7}, {0x6a3a, 0x8a92}, {0x6a3d, 0x924d},
    {0x6a44, 0x9eeb}, {0x6a46, 0xfaef}, {0x6a47, 0x9ef0}, {0x6a48, 0x9ef4},
    {0x6a4b, 0x8bb4}, {0x6a58, 0x8b6b}, {0x6a59, 0x9ef2}, {0x6a5f, 0x8b40},
    {0x6a61, 0x93c9}, {0x6a62, 0x9ef1}, {0x6a66, 0x9ef3}, {0x6a6b, 0xfaee},
    {0x6a72, 0x9eed}, {0x6a73, 0xfaf0}, {0x6a78, 0x9eef}, {0x6a7e, 0xfaf1},
    {0x6a7f, 0x8a80}, {0x6a80, 0x9268}, {0x6a84, 0x9efa}, {0x6a8d, 0x9ef8},
    {0x6a8e, 0x8ce7}, {0x6a90, 0x9ef7}, {0x6a97, 0x9f40}, {0x6a9c, 0x9e77},
    {0x6aa0, 0x9ef9}, {0x6aa2, 0x9efb}, {0x6aa3, 0x9efc}, {0x6aaa, 0x9f4b},
    {0x6aac, 0x9f47}, {0x6aae, 0x9e8d}, {0x6ab3, 0x9f46}, {0x6ab8, 0x9f45},
    {0x6abb, 0x9f42}, {0x6ac1, 0x9ee8}, {0x6ac2, 0x9f44}, {0x6ac3, 0x9f43},
    {0x6ad1, 0x9f49}, {0x6ad3, 0x9845}, {0x6ada, 0x9f4c}, {0x6adb, 0x8bf9},
    {0x6ade, 0x9f48}, {0x6adf, 0x9f4a}, {0x6ae2, 0xfaf2}, {0x6ae4, 0xfaf3},
    {0x6ae8, 0x94a5}, {0x6aea, 0x9f4d}, {0x6afa, 0x9f51}, {0x6afb, 0x9f4e},
    {0x6b04, 0x9793}, {0x6b05, 0x9f4f}, {0x6b0a, 0x9edc}, {0x6b12, 0x9f52},
    {0x6b16, 0x9f53}, {0x6b1d, 0x8954}, {0x6b1f, 0x9f55}, {0x6b20, 0x8c87},
    {0x6b21, 0x8e9f}, {0x6b23, 0x8bd3}, {0x6b27, 0x89a2}, {0x6b32, 0x977e},
    {0x6b37, 0x9f57}, {0x6b38, 0x9f56}, {0x6b39, 0x9f59}, {0x6b3a, 0x8b5c},
    {0x6b3d, 0x8bd4}, {0x6b3e, 0x8abc}, {0x6b43, 0x9f5c}, {0x6b47, 0x9f5b},
    {0x6b49, 0x9f5d}, {0x6b4c, 0x89cc}, {0x6b4e, 0x9256}, {0x6b50, 0x9f5e},
    {0x6b53, 0x8abd}, {0x6b54, 0x9f60}, {0x6b59, 0x9f5f}, {0x6b5b, 0x9f61},
    {0x6b5f, 0x9f62}, {0x6b61, 0x9f63}, {0x6b62, 0x8e7e}, {0x6b63, 0x90b3},
    {0x6b64, 0x8d9f}, {0x6b66, 0x9590}, {0x6b69, 0x95e0}, {0x6b6a, 0x9863},
    {0x6b6f, 0x8e95}, {0x6b73, 0x8dce}, {0x6b74, 0x97f0}, {0x6b78, 0x9f64},
    {0x6b79, 0x9f65}, {0x6b7b, 0x8e80}, {0x6b7f, 0x9f66}, {0x6b80, 0x9f67},
    {0x6b83, 0x9f69}, {0x6b84, 0x9f68}, {0x6b86, 0x9677}, {0x6b89, 0x8f7d},
    {0x6b8a, 0x8eea}, {0x6b8b, 0x8e63}, {0x6b8d, 0x9f6a}, {0x6b95, 0x9f6c},
    {0x6b96, 0x9042}, {0x6b98, 0x9f6b}, {0x6b9e, 0x9f6d}, {0x6ba4, 0x9f6e},
    {0x6baa, 0x9f6f}, {0x6bab, 0x9f70}, {0x6baf, 0x9f71}, {0x6bb1, 0x9f73},
    {0x6bb2, 0x9f72}, {0x6bb3, 0x9f74}, {0x6bb4, 0x89a3}, {0x6bb5, 0x9269},
    {0x6bb7, 0x9f75}, {0x6bba, 0x8e45}, {0x6bbb, 0x8a6b}, {0x6bbc, 0x9f76},
    {0x6bbf, 0x9361}, {0x6bc0, 0x9aca}, {0x6bc5, 0x8b42}, {0x6bc6, 0x9f77},
    {0x6bcb, 0x9f78}, {0x6bcd, 0x95ea}, {0x6bce, 0x9688}, {0x6bd2, 0x93c5},
    {0x6bd3, 0x9f79}, {0x6bd4, 0x94e4}, {0x6bd6, 0xfaf4}, {0x6bd8, 0x94f9},
    {0x6bdb, 0x96d1}, {0x6bdf, 0x9f7a}, {0x6beb, 0x9f7c}, {0x6bec, 0x9f7b},
    {0x6bef, 0x9f7e}, {0x6bf3, 0x9f7d}, {0x6c08, 0x9f81}, {0x6c0f, 0x8e81},
    {0x6c11, 0x96af}, {0x6c13, 0x9f82}, {0x6c14, 0x9f83}, {0x6c17, 0x8b43},
    {0x6c1b, 0x9f84}, {0x6c23, 0x9f86}, {0x6c24, 0x9f85}, {0x6c34, 0x9085},
    {0x6c37, 0x9558}, {0x6c38, 0x8969}, {0x6c3e, 0x94c3}, {0x6c3f, 0xfaf5},
    {0x6c40, 0x92f3}, {0x6c41, 0x8f60}, {0x6c42, 0x8b81}, {0x6c4e, 0x94c4},
    {0x6c50, 0x8eac}, {0x6c55, 0x9f88}, {0x6c57, 0x8abe}, {0x6c5a, 0x8998},
    {0x6c5c, 0xfaf6}, {0x6c5d, 0x93f0}, {0x6c5e, 0x9f87}, {0x6c5f, 0x8d5d},
    {0x6c60, 0x9272}, {0x6c62, 0x9f89}, {0x6c68, 0x9f91}, {0x6c6a, 0x9f8a},
    {0x6c6f, 0xfaf8}, {0x6c70, 0x91bf}, {0x6c72, 0x8b82}, {0x6c73, 0x9f92},
    {0x6c7a, 0x8c88}, {0x6c7d, 0x8b44}, {0x6c7e, 0x9f90}, {0x6c81, 0x9f8e},
    {0x6c82, 0x9f8b}, {0x6c83, 0x9780}, {0x6c86, 0xfaf7}, {0x6c88, 0x92be},
    {0x6c8c, 0x93d7}, {0x6c8d, 0x9f8c}, {0x6c90, 0x9f94}, {0x6c92, 0x9f93},
    {0x6c93, 0x8c42}, {0x6c96, 0x89ab}, {0x6c99, 0x8db9}, {0x6c9a, 0x9f8d},
    {0x6c9b, 0x9f8f}, {0x6ca1, 0x9676}, {0x6ca2, 0x91f2}, {0x6cab, 0x9697},
    {0x6cae, 0x9f9c}, {0x6cb1, 0x9f9d}, {0x6cb3, 0x89cd}, {0x6cb8, 0x95a6},
    {0x6cb9, 0x96fb}, {0x6cba, 0x9f9f}, {0x6cbb, 0x8ea1}, {0x6cbc, 0x8fc0},
    {0x6cbd, 0x9f98}, {0x6cbe, 0x9f9e}, {0x6cbf, 0x8988}, {0x6cc1, 0x8bb5},
    {0x6cc4, 0x9f95}, {0x6cc5, 0x9f9a}, {0x6cc9, 0x90f2}, {0x6cca, 0x9491},
    {0x6ccc, 0x94e5}, {0x6cd3, 0x9f97}, {0x6cd5, 0x9640}, {0x6cd7, 0x9f99},
    {0x6cd9, 0x9fa2}, {0x6cda, 0xfaf9}, {0x6cdb, 0x9fa0}, {0x6cdd, 0x9f9b},
    {0x6ce1, 0x9641}, {0x6ce2, 0x9467}, {0x6ce3, 0x8b83}, {0x6ce5, 0x9344},
    {0x6ce8, 0x928d}, {0x6cea, 0x9fa3}, {0x6cef, 0x9fa1}, {0x6cf0, 0x91d7},
    {0x6cf1, 0x9f96}, {0x6cf3, 0x896a}, {0x6d04, 0xfafa}, {0x6d0b, 0x976d},
    {0x6d0c, 0x9fae}, {0x6d12, 0x9fad}, {0x6d17, 0x90f4}, {0x6d19, 0x9faa},
    {0x6d1b, 0x978c}, {0x6d1e, 0x93b4}, {0x6d1f, 0x9fa4}, {0x6d25, 0x92c3},
    {0x6d29, 0x896b}, {0x6d2a, 0x8d5e}, {0x6d2b, 0x9fa7}, {0x6d32, 0x8f46},
    {0x6d33, 0x9fac}, {0x6d35, 0x9fab}, {0x6d36, 0x9fa6}, {0x6d38, 0x9fa9},
    {0x6d3b, 0x8a88}, {0x6d3d, 0x9fa8}, {0x6d3e, 0x9468}, {0x6d41, 0x97ac},
    {0x6d44, 0x8ff2}, {0x6d45, 0x90f3}, {0x6d59, 0x9fb4}, {0x6d5a, 0x9fb2},
    {0x6d5c, 0x956c}, {0x6d63, 0x9faf}, {0x6d64, 0x9fb1}, {0x6d66, 0x8959},
    {0x6d69, 0x8d5f}, {0x6d6a, 0x9851}, {0x6d6c, 0x8a5c}, {0x6d6e, 0x9582},
    {0x6d6f, 0xfafc}, {0x6d74, 0x9781}, {0x6d77, 0x8a43}, {0x6d78, 0x905a},
    {0x6d79, 0x9fb3}, {0x6d85, 0x9fb8}, {0x6d87, 0xfafb}, {0x6d88, 0x8fc1},
    {0x6d8c, 0x974f}, {0x6d8e, 0x9fb5}, {0x6d93, 0x9fb0}, {0x6d95, 0x9fb6},
    {0x6d96, 0xfb40}, {0x6d99, 0x97dc}, {0x6d9b, 0x9393}, {0x6d9c, 0x93c0},
    {0x6dac, 0xfb41}, {0x6daf, 0x8a55}, {0x6db2, 0x8974}, {0x6db5, 0x9fbc},
    {0x6db8, 0x9fbf}, {0x6dbc, 0x97c1}, {0x6dc0, 0x9784}, {0x6dc5, 0x9fc6},
    {0x6dc6, 0x9fc0}, {0x6dc7, 0x9fbd}, {0x6dcb, 0x97d2}, {0x6dcc, 0x9fc3},
    {0x6dcf, 0xfb42}, {0x6dd1, 0x8f69}, {0x6dd2, 0x9fc5}, {0x6dd5, 0x9fca},
    {0x6dd8, 0x9391}, {0x6dd9, 0x9fc8}, {0x6dde, 0x9fc2}, {0x6de1, 0x9257},
    {0x6de4, 0x9fc9}, {0x6de6, 0x9fbe}, {0x6de8, 0x9fc4}, {0x6dea, 0x9fcb},
    {0x6deb, 0x88fa}, {0x6dec, 0x9fc1}, {0x6dee, 0x9fcc}, {0x6df1, 0x905b},
    {0x6df2, 0xfb44}, {0x6df3, 0x8f7e}, {0x6df5, 0x95a3}, {0x6df7, 0x8dac},
    {0x6df8, 0xfb43}, {0x6df9, 0x9fb9}, {0x6dfa, 0x9fc7}, {0x6dfb, 0x9359},
    {0x6dfc, 0xfb45}, {0x6e05, 0x90b4}, {0x6e07, 0x8a89}, {0x6e08, 0x8dcf},
    {0x6e09, 0x8fc2}, {0x6e0a, 0x9fbb}, {0x6e0b, 0x8f61}, {0x6e13, 0x8c6b},
    {0x6e15, 0x9fba}, {0x6e19, 0x9fd0}, {0x6e1a, 0x8f8d}, {0x6e1b, 0x8cb8},
    {0x6e1d, 0x9fdf}, {0x6e1f, 0x9fd9}, {0x6e20, 0x8b94}, {0x6e21, 0x936e},
    {0x6e23, 0x9fd4}, {0x6e24, 0x9fdd}, {0x6e25, 0x88ad}, {0x6e26, 0x8951},
    {0x6e27, 0xfb48}, {0x6e29, 0x89b7}, {0x6e2b, 0x9fd6}, {0x6e2c, 0x91aa},
    {0x6e2d, 0x9fcd}, {0x6e2e, 0x9fcf}, {0x6e2f, 0x8d60}, {0x6e38, 0x9fe0},
    {0x6e39, 0xfb46}, {0x6e3a, 0x9fdb}, {0x6e3c, 0xfb49}, {0x6e3e, 0x9fd3},
    {0x6e43, 0x9fda}, {0x6e4a, 0x96a9}, {0x6e4d, 0x9fd8}, {0x6e4e, 0x9fdc},
    {0x6e56, 0x8cce}, {0x6e58, 0x8fc3}, {0x6e5b, 0x9258}, {0x6e5c, 0xfb47},
    {0x6e5f, 0x9fd2}, {0x6e67, 0x974e}, {0x6e6b, 0x9fd5}, {0x6e6e, 0x9fce},
    {0x6e6f, 0x9392}, {0x6e72, 0x9fd1}, {0x6e76, 0x9fd7}, {0x6e7e, 0x9870},
    {0x6e7f, 0x8ebc}, {0x6e80, 0x969e}, {0x6e82, 0x9fe1}, {0x6e8c, 0x94ac},
    {0x6e8f, 0x9fed}, {0x6e90, 0x8cb9}, {0x6e96, 0x8f80}, {0x6e98, 0x9fe3},
    {0x6e9c, 0x97ad}, {0x6e9d, 0x8d61}, {0x6e9f, 0x9ff0}, {0x6ea2, 0x88ec},
    {0x6ea5, 0x9fee}, {0x6eaa, 0x9fe2}, {0x6eaf, 0x9fe8}, {0x6eb2, 0x9fea},
    {0x6eb6, 0x976e}, {0x6eb7, 0x9fe5}, {0x6eba, 0x934d}, {0x6ebd, 0x9fe7},
    {0x6ebf, 0xfb4a}, {0x6ec2, 0x9fef}, {0x6ec4, 0x9fe9}, {0x6ec5, 0x96c5},
    {0x6ec9, 0x9fe4}, {0x6ecb, 0x8ea0}, {0x6ecc, 0x9ffc}, {0x6ed1, 0x8a8a},
    {0x6ed3, 0x9fe6}, {0x6ed4, 0x9feb}, {0x6ed5, 0x9fec}, {0x6edd, 0x91ea},
    {0x6ede, 0x91d8}, {0x6eec, 0x9ff4}, {0x6eef, 0x9ffa}, {0x6ef2, 0x9ff8},
    {0x6ef4, 0x9348}, {0x6ef7, 0xe042}, {0x6ef8, 0x9ff5}, {0x6efe, 0x9ff6},
    {0x6eff, 0x9fde}, {0x6f01, 0x8b99}, {0x6f02, 0x9559}, {0x6f06, 0x8ebd},
    {0x6f09, 0x8d97}, {0x6f0f, 0x9852}, {0x6f11, 0x9ff2}, {0x6f13, 0xe041},
    {0x6f14, 0x8989}, {0x6f15, 0x9186}, {0x6f20, 0x9499}, {0x6f22, 0x8abf},
    {0x6f23, 0x97f8}, {0x6f2b, 0x969f}, {0x6f2c, 0x92d0}, {0x6f31, 0x9ff9},
    {0x6f32, 0x9ffb}, {0x6f38, 0x9151}, {0x6f3e, 0xe040}, {0x6f3f, 0x9ff7},
    {0x6f41, 0x9ff1}, {0x6f45, 0x8ac1}, {0x6f51, 0x94ac}, {0x6f54, 0x8c89},
    {0x6f58, 0xe04e}, {0x6f5b, 0xe049}, {0x6f5c, 0x90f6}, {0x6f5f, 0x8a83},
    {0x6f64, 0x8f81}, {0x6f66, 0xe052}, {0x6f6d, 0xe04b}, {0x6f6e, 0x92aa},
    {0x6f6f, 0xe048}, {0x6f70, 0x92d7}, {0x6f74, 0xe06b}, {0x6f78, 0xe045},
    {0x6f7a, 0xe044}, {0x6f7c, 0xe04d}, {0x6f80, 0xe047}, {0x6f81, 0xe046},
    {0x6f82, 0xe04c}, {0x6f84, 0x909f}, {0x6f86, 0xe043}, {0x6f88, 0xfb4b},
    {0x6f8e, 0xe04f}, {0x6f91, 0xe050}, {0x6f97, 0x8ac0}, {0x6fa1, 0xe055},
    {0x6fa3, 0xe054}, {0x6fa4, 0xe056}, {0x6faa, 0xe059}, {0x6fb1, 0x9362},
    {0x6fb3, 0xe053}, {0x6fb5, 0xfb4c}, {0x6fb9, 0xe057}, {0x6fc0, 0x8c83},
    {0x6fc1, 0x91f7}, {0x6fc2, 0xe051}, {0x6fc3, 0x945a}, {0x6fc6, 0xe058},
    {0x6fd4, 0xe05d}, {0x6fd5, 0xe05b}, {0x6fd8, 0xe05e}, {0x6fdb, 0xe061},
    {0x6fdf, 0xe05a}, {0x6fe0, 0x8d8a}, {0x6fe1, 0x9447}, {0x6fe4, 0x9fb7},
    {0x6feb, 0x9794}, {0x6fec, 0xe05c}, {0x6fee, 0xe060}, {0x6fef, 0x91f3},
    {0x6ff1, 0xe05f}, {0x6ff3, 0xe04a}, {0x6ff5, 0xfb4d}, {0x6ff6, 0xe889},
    {0x6ffa, 0xe064}, {0x6ffe, 0xe068}, {0x7001, 0xe066}, {0x7005, 0xfb4e},
    {0x7006, 0x93c0}, {0x7007, 0xfb4f}, {0x7009, 0xe062}, {0x700b, 0xe063},
    {0x700f, 0xe067}, {0x7011, 0xe065}, {0x7015, 0x956d}, {0x7018, 0xe06d},
    {0x701a, 0xe06a}, {0x701b, 0xe069}, {0x701d, 0xe06c}, {0x701e, 0x93d2},
    {0x701f, 0xe06e}, {0x7026, 0x9295}, {0x7027, 0x91eb}, {0x7028, 0xfb50},
    {0x702c, 0x90a3}, {0x7030, 0xe06f}, {0x7032, 0xe071}, {0x703e, 0xe070},
    {0x704c, 0x9ff3}, {0x7051, 0xe072}, {0x7058, 0x93e5}, {0x7063, 0xe073},
    {0x706b, 0x89ce}, {0x706f, 0x9394}, {0x7070, 0x8a44}, {0x7078, 0x8b84},
    {0x707c, 0x8edc}, {0x707d, 0x8dd0}, {0x7085, 0xfb51}, {0x7089, 0x9846},
    {0x708a, 0x9086}, {0x708e, 0x898a}, {0x7092, 0xe075}, {0x7099, 0xe074},
    {0x70ab, 0xfb52}, {0x70ac, 0xe078}, {0x70ad, 0x9259}, {0x70ae, 0xe07b},
    {0x70af, 0xe076}, {0x70b3, 0xe07a}, {0x70b8, 0xe079}, {0x70b9, 0x935f},
    {0x70ba, 0x88d7}, {0x70bb, 0xfa62}, {0x70c8, 0x97f3}, {0x70cb, 0xe07d},
    {0x70cf, 0x8947}, {0x70d9, 0xe080}, {0x70dd, 0xe07e}, {0x70df, 0xe07c},
    {0x70f1, 0xe077}, {0x70f9, 0x9642}, {0x70fd, 0xe082}, {0x7104, 0xfb54},
    {0x7109, 0xe081}, {0x710f, 0xfb53}, {0x7114, 0x898b}, {0x7119, 0xe084},
    {0x711a, 0x95b0}, {0x711c, 0xe083}, {0x7121, 0x96b3}, {0x7126, 0x8fc5},
    {0x7130, 0x898b}, {0x7136, 0x9152}, {0x713c, 0x8fc4}, {0x7146, 0xfb56},
    {0x7147, 0xfb57}, {0x7149, 0x97f9}, {0x714c, 0xe08a}, {0x714e, 0x90f7},
    {0x7155, 0xe086}, {0x7156, 0xe08b}, {0x7159, 0x898c}, {0x715c, 0xfb55},
    {0x7162, 0xe089}, {0x7164, 0x9481}, {0x7165, 0xe085}, {0x7166, 0xe088},
    {0x7167, 0x8fc6}, {0x7169, 0x94cf}, {0x716c, 0xe08c}, {0x716e, 0x8ecf},
    {0x717d, 0x90f8}, {0x7184, 0xe08f}, {0x7188, 0xe087}, {0x718a, 0x8c46},
    {0x718f, 0xe08d}, {0x7194, 0x976f}, {0x7195, 0xe090}, {0x7199, 0xeaa4},
    {0x719f, 0x8f6e}, {0x71a8, 0xe091}, {0x71ac, 0xe092}, {0x71b1, 0x944d},
    {0x71b9, 0xe094}, {0x71be, 0xe095}, {0x71c1, 0xfb59}, {0x71c3, 0x9452},
    {0x71c8, 0x9395}, {0x71c9, 0xe097}, {0x71ce, 0xe099}, {0x71d0, 0x97d3},
    {0x71d2, 0xe096}, {0x71d4, 0xe098}, {0x71d5, 0x898d}, {0x71d7, 0xe093},
    {0x71df, 0x9a7a}, {0x71e0, 0xe09a}, {0x71e5, 0x9187}, {0x71e6, 0x8e57},
    {0x71e7, 0xe09c}, {0x71ec, 0xe09b}, {0x71ed, 0x9043}, {0x71ee, 0x99d7},
    {0x71f5, 0xe09d}, {0x71f9, 0xe09f}, {0x71fb, 0xe08e}, {0x71fc, 0xe09e},
    {0x71fe, 0xfb5a}, {0x71ff, 0xe0a0}, {0x7206, 0x949a}, {0x720d, 0xe0a1},
    {0x7210, 0xe0a2}, {0x721b, 0xe0a3}, {0x7228, 0xe0a4}, {0x722a, 0x92dc},
    {0x722c, 0xe0a6}, {0x722d, 0xe0a5}, {0x7230, 0xe0a7}, {0x7232, 0xe0a8},
    {0x7235, 0x8edd}, {0x7236, 0x9583}, {0x723a, 0x96ea}, {0x723b, 0xe0a9},
    {0x723c, 0xe0aa}, {0x723d, 0x9175}, {0x723e, 0x8ea2}, {0x723f, 0xe0ab},
    {0x7240, 0xe0ac}, {0x7246, 0xe0ad}, {0x7247, 0x95d0}, {0x7248, 0x94c5},
    {0x724b, 0xe0ae}, {0x724c, 0x9476}, {0x7252, 0x92ab}, {0x7258, 0xe0af},
    {0x7259, 0x89e5}, {0x725b, 0x8b8d}, {0x725d, 0x96c4}, {0x725f, 0x96b4},
    {0x7261, 0x89b2}, {0x7262, 0x9853}, {0x7267, 0x9671}, {0x7269, 0x95a8},
    {0x7272, 0x90b5}, {0x7274, 0xe0b0}, {0x7279, 0x93c1}, {0x727d, 0x8ca1},
    {0x727e, 0xe0b1}, {0x7280, 0x8dd2}, {0x7281, 0xe0b3}, {0x7282, 0xe0b2},
    {0x7287, 0xe0b4}, {0x7292, 0xe0b5}, {0x7296, 0xe0b6}, {0x72a0, 0x8b5d},
    {0x72a2, 0xe0b7}, {0x72a7, 0xe0b8}, {0x72ac, 0x8ca2}, {0x72af, 0x94c6},
    {0x72b1, 0xfb5b}, {0x72b2, 0xe0ba}, {0x72b6, 0x8ff3}, {0x72b9, 0xe0b9},
    {0x72be, 0xfb5c}, {0x72c2, 0x8bb6}, {0x72c3, 0xe0bb}, {0x72c4, 0xe0bd},
    {0x72c6, 0xe0bc}, {0x72ce, 0xe0be}, {0x72d0, 0x8ccf}, {0x72d2, 0xe0bf},
    {0x72d7, 0x8be7}, {0x72d9, 0x915f}, {0x72db, 0x8d9d}, {0x72e0, 0xe0c1},
    {0x72e1, 0xe0c2}, {0x72e2, 0xe0c0}, {0x72e9, 0x8eeb}, {0x72ec, 0x93c6},
    {0x72ed, 0x8bb7}, {0x72f7, 0xe0c4}, {0x72f8, 0x924b}, {0x72f9, 0xe0c3},
    {0x72fc, 0x9854}, {0x72fd, 0x9482}, {0x730a, 0xe0c7}, {0x7316, 0xe0c9},
    {0x7317, 0xe0c6}, {0x731b, 0x96d2}, {0x731c, 0xe0c8}, {0x731d, 0xe0ca},
    {0x731f, 0x97c2}, {0x7324, 0xfb5d}, {0x7325, 0xe0ce}, {0x7329, 0xe0cd},
    {0x732a, 0x9296}, {0x732b, 0x944c}, {0x732e, 0x8ca3}, {0x732f, 0xe0cc},
    {0x7334, 0xe0cb}, {0x7336, 0x9750}, {0x7337, 0x9751}, {0x733e, 0xe0cf},
    {0x733f, 0x898e}, {0x7344, 0x8d96}, {0x7345, 0x8e82}, {0x734e, 0xe0d0},
    {0x734f, 0xe0d1}, {0x7357, 0xe0d3}, {0x7363, 0x8f62}, {0x7368, 0xe0d5},
    {0x736a, 0xe0d4}, {0x7370, 0xe0d6}, {0x7372, 0x8a6c}, {0x7375, 0xe0d8},
    {0x7377, 0xfb5f}, {0x7378, 0xe0d7}, {0x737a, 0xe0da}, {0x737b, 0xe0d9},
    {0x7384, 0x8cba}, {0x7387, 0x97a6}, {0x7389, 0x8bca}, {0x738b, 0x89a4},
    {0x7396, 0x8be8}, {0x73a9, 0x8adf}, {0x73b2, 0x97e6}, {0x73b3, 0xe0dc},
    {0x73bb, 0xe0de}, {0x73bd, 0xfb60}, {0x73c0, 0xe0df}, {0x73c2, 0x89cf},
    {0x73c8, 0xe0db}, {0x73c9, 0xfb61}, {0x73ca, 0x8e58}, {0x73cd, 0x92bf},
    {0x73ce, 0xe0dd}, {0x73d2, 0xfb64}, {0x73d6, 0xfb62}, {0x73de, 0xe0e2},
    {0x73e0, 0x8eec}, {0x73e3, 0xfb63}, {0x73e5, 0xe0e0}, {0x73ea, 0x8c5d},
    {0x73ed, 0x94c7}, {0x73ee, 0xe0e1}, {0x73f1, 0xe0fc}, {0x73f5, 0xfb66},
    {0x73f8, 0xe0e7}, {0x73fe, 0x8cbb}, {0x7403, 0x8b85}, {0x7405, 0xe0e4},
    {0x7406, 0x979d}, {0x7407, 0xfb65}, {0x7409, 0x97ae}, {0x7422, 0x91f4},
    {0x7425, 0xe0e6}, {0x7426, 0xfb67}, {0x7429, 0xfb69}, {0x742a, 0xfb68},
    {0x742e, 0xfb6a}, {0x7432, 0xe0e8}, {0x7433, 0x97d4}, {0x7434, 0x8bd5},
    {0x7435, 0x94fa}, {0x7436, 0x9469}, {0x743a, 0xe0e9}, {0x743f, 0xe0eb},
    {0x7441, 0xe0ee}, {0x7455, 0xe0ea}, {0x7459, 0xe0ed}, {0x745a, 0x8ce8},
    {0x745b, 0x896c}, {0x745c, 0xe0ef}, {0x745e, 0x9090}, {0x745f, 0xe0ec},
    {0x7460, 0x97da}, {0x7462, 0xfb6b}, {0x7463, 0xe0f2}, {0x7464, 0xeaa2},
    {0x7469, 0xe0f0}, {0x746a, 0xe0f3}, {0x746f, 0xe0e5}, {0x7470, 0xe0f1},
    {0x7473, 0x8dba}, {0x7476, 0xe0f4}, {0x747e, 0xe0f5}, {0x7483, 0x979e},
    {0x7489, 0xfb6c}, {0x748b, 0xe0f6}, {0x749e, 0xe0f7}, {0x749f, 0xfb6d},
    {0x74a2, 0xe0e3}, {0x74a7, 0xe0f8}, {0x74b0, 0x8ac2}, {0x74bd, 0x8ea3},
    {0x74ca, 0xe0f9}, {0x74cf, 0xe0fa}, {0x74d4, 0xe0fb}, {0x74dc, 0x895a},
    {0x74e0, 0xe140}, {0x74e2, 0x955a}, {0x74e3, 0xe141}, {0x74e6, 0x8aa2},
    {0x74e7, 0xe142}, {0x74e9, 0xe143}, {0x74ee, 0xe144}, {0x74f0, 0xe146},
    {0x74f1, 0xe147}, {0x74f2, 0xe145}, {0x74f6, 0x9572}, {0x74f7, 0xe149},
    {0x74f8, 0xe148}, {0x7501, 0xfb6e}, {0x7503, 0xe14b}, {0x7504, 0xe14a},
    {0x7505, 0xe14c}, {0x750c, 0xe14d}, {0x750d, 0xe14f}, {0x750e, 0xe14e},
    {0x7511, 0x8d99}, {0x7513, 0xe151}, {0x7515, 0xe150}, {0x7518, 0x8ac3},
    {0x751a, 0x9072}, {0x751c, 0x935b}, {0x751e, 0xe152}, {0x751f, 0x90b6},
    {0x7523, 0x8e59}, {0x7525, 0x8999}, {0x7526, 0xe153}, {0x7528, 0x9770},
    {0x752b, 0x95e1}, {0x752c, 0xe154}, {0x752f, 0xfaa8}, {0x7530, 0x9363},
    {0x7531, 0x9752}, {0x7532, 0x8d62}, {0x7533, 0x905c}, {0x7537, 0x926a},
    {0x7538, 0x99b2}, {0x753a, 0x92ac}, {0x753b, 0x89e6}, {0x753c, 0xe155},
    {0x7544, 0xe156}, {0x7546, 0xe15b}, {0x7549, 0xe159}, {0x754a, 0xe158},
    {0x754b, 0x9dc0}, {0x754c, 0x8a45}, {0x754d, 0xe157}, {0x754f, 0x88d8},
    {0x7551, 0x94a8}, {0x7554, 0x94c8}, {0x7559, 0x97af}, {0x755a, 0xe15c},
    {0x755b, 0xe15a}, {0x755c, 0x927b}, {0x755d, 0x90a4}, {0x7560, 0x94a9},
    {0x7562, 0x954c}, {0x7564, 0xe15e}, {0x7565, 0x97aa}, {0x7566, 0x8c6c},
    {0x7567, 0xe15f}, {0x7569, 0xe15d}, {0x756a, 0x94d4}, {0x756b, 0xe160},
    {0x756d, 0xe161}, {0x756f, 0xfb6f}, {0x7570, 0x88d9}, {0x7573, 0x8ff4},
    {0x7574, 0xe166}, {0x7576, 0xe163}, {0x7577, 0x93eb}, {0x7578, 0xe162},
    {0x757f, 0x8b45}, {0x7582, 0xe169}, {0x7586, 0xe164}, {0x7587, 0xe165},
    {0x7589, 0xe168}, {0x758a, 0xe167}, {0x758b, 0x9544}, {0x758e, 0x9161},
    {0x758f, 0x9160}, {0x7591, 0x8b5e}, {0x7594, 0xe16a}, {0x759a, 0xe16b},
    {0x759d, 0xe16c}, {0x75a3, 0xe16e}, {0x75a5, 0xe16d}, {0x75ab, 0x8975},
    {0x75b1, 0xe176}, {0x75b2, 0x94e6}, {0x75b3, 0xe170}, {0x75b5, 0xe172},
    {0x75b8, 0xe174}, {0x75b9, 0x905d}, {0x75bc, 0xe175}, {0x75bd, 0xe173},
    {0x75be, 0x8ebe}, {0x75c2, 0xe16f}, {0x75c3, 0xe171}, {0x75c5, 0x9561},
    {0x75c7, 0x8fc7}, {0x75ca, 0xe178}, {0x75cd, 0xe177}, {0x75d2, 0xe179},
    {0x75d4, 0x8ea4}, {0x75d5, 0x8dad}, {0x75d8, 0x9397}, {0x75d9, 0xe17a},
    {0x75db, 0x92c9}, {0x75de, 0xe17c}, {0x75e2, 0x979f}, {0x75e3, 0xe17b},
    {0x75e9, 0x9189}, {0x75f0, 0xe182}, {0x75f2, 0xe184}, {0x75f3, 0xe185},
    {0x75f4, 0x9273}, {0x75fa, 0xe183}, {0x75fc, 0xe180}, {0x75fe, 0xe17d},
    {0x75ff, 0xe17e}, {0x7601, 0xe181}, {0x7609, 0xe188}, {0x760b, 0xe186},
    {0x760d, 0xe187}, {0x761f, 0xe189}, {0x7620, 0xe18b}, {0x7621, 0xe18c},
    {0x7622, 0xe18d}, {0x7624, 0xe18e}, {0x7626, 0x9189}, {0x7627, 0xe18a},
    {0x7630, 0xe190}, {0x7634, 0xe18f}, {0x763b, 0xe191}, {0x7642, 0x97c3},
    {0x7646, 0xe194}, {0x7647, 0xe192}, {0x7648, 0xe193}, {0x764c, 0x8ae0},
    {0x7652, 0x96fc}, {0x7656, 0x95c8}, {0x7658, 0xe196}, {0x765c, 0xe195},
    {0x7661, 0xe197}, {0x7662, 0xe198}, {0x7667, 0xe19c}, {0x7668, 0xe199},
    {0x7669, 0xe19a}, {0x766a, 0xe19b}, {0x766c, 0xe19d}, {0x7670, 0xe19e},
    {0x7672, 0xe19f}, {0x7676, 0xe1a0}, {0x7678, 0xe1a1}, {0x767a, 0x94ad},
    {0x767b, 0x936f}, {0x767c, 0xe1a2}, {0x767d, 0x9492}, {0x767e, 0x9553},
    {0x7680, 0xe1a3}, {0x7682, 0xfb70}, {0x7683, 0xe1a4}, {0x7684, 0x9349},
    {0x7686, 0x8a46}, {0x7687, 0x8d63}, {0x7688, 0xe1a5}, {0x768b, 0xe1a6},
    {0x768e, 0xe1a7}, {0x7690, 0x8e48}, {0x7693, 0xe1a9}, {0x7696, 0xe1a8},
    {0x7699, 0xe1aa}, {0x769a, 0xe1ab}, {0x769b, 0xfb73}, {0x769c, 0xfb71},
    {0x769e, 0xfb72}, {0x76a6, 0xfb74}, {0x76ae, 0x94e7}, {0x76b0, 0xe1ac},
    {0x76b4, 0xe1ad}, {0x76b7, 0xea89}, {0x76b8, 0xe1ae}, {0x76b9, 0xe1af},
    {0x76ba, 0xe1b0}, {0x76bf, 0x8e4d}, {0x76c2, 0xe1b1}, {0x76c3, 0x9475},
    {0x76c6, 0x967e}, {0x76c8, 0x896d}, {0x76ca, 0x8976}, {0x76cd, 0xe1b2},
    {0x76d2, 0xe1b4}, {0x76d6, 0xe1b3}, {0x76d7, 0x9390}, {0x76db, 0x90b7},
    {0x76dc, 0x9f58}, {0x76de, 0xe1b5}, {0x76df, 0x96bf}, {0x76e1, 0xe1b6},
    {0x76e3, 0x8ac4}, {0x76e4, 0x94d5}, {0x76e5, 0xe1b7}, {0x76e7, 0xe1b8},
    {0x76ea, 0xe1b9}, {0x76ee, 0x96da}, {0x76f2, 0x96d3}, {0x76f4, 0x92bc},
    {0x76f8, 0x918a}, {0x76fb, 0xe1bb}, {0x76fe, 0x8f82}, {0x7701, 0x8fc8},
    {0x7704, 0xe1be}, {0x7707, 0xe1bd}, {0x7708, 0xe1bc}, {0x7709, 0x94fb},
    {0x770b, 0x8ac5}, {0x770c, 0x8ca7}, {0x771b, 0xe1c4}, {0x771e, 0xe1c1},
    {0x771f, 0x905e}, {0x7720, 0x96b0}, {0x7724, 0xe1c0}, {0x7725, 0xe1c2},
    {0x7726, 0xe1c3}, {0x7729, 0xe1bf}, {0x7737, 0xe1c5}, {0x7738, 0xe1c6},
    {0x773a, 0x92ad}, {0x773c, 0x8ae1}, {0x7740, 0x9285}, {0x7746, 0xfb76},
    {0x7747, 0xe1c7}, {0x775a, 0xe1c8}, {0x775b, 0xe1cb}, {0x7761, 0x9087},
    {0x7763, 0x93c2}, {0x7765, 0xe1cc}, {0x7766, 0x9672}, {0x7768, 0xe1c9},
    {0x776b, 0xe1ca}, {0x7779, 0xe1cf}, {0x777e, 0xe1ce}, {0x777f, 0xe1cd},
    {0x778b, 0xe1d1}, {0x778e, 0xe1d0}, {0x7791, 0xe1d2}, {0x779e, 0xe1d4},
    {0x77a0, 0xe1d3}, {0x77a5, 0x95cb}, {0x77ac, 0x8f75}, {0x77ad, 0x97c4},
    {0x77b0, 0xe1d5}, {0x77b3, 0x93b5}, {0x77b6, 0xe1d6}, {0x77b9, 0xe1d7},
    {0x77bb, 0xe1db}, {0x77bc, 0xe1d9}, {0x77bd, 0xe1da}, {0x77bf, 0xe1d8},
    {0x77c7, 0xe1dc}, {0x77cd, 0xe1dd}, {0x77d7, 0xe1de}, {0x77da, 0xe1df},
    {0x77db, 0x96b5}, {0x77dc, 0xe1e0}, {0x77e2, 0x96ee}, {0x77e3, 0xe1e1},
    {0x77e5, 0x926d}, {0x77e7, 0x948a}, {0x77e9, 0x8be9}, {0x77ed, 0x925a},
    {0x77ee, 0xe1e2}, {0x77ef, 0x8bb8}, {0x77f3, 0x90ce}, {0x77fc, 0xe1e3},
    {0x7802, 0x8dbb}, {0x780c, 0xe1e4}, {0x7812, 0xe1e5}, {0x7814, 0x8ca4},
    {0x7815, 0x8dd3}, {0x7820, 0xe1e7}, {0x7821, 0xfb78}, {0x7825, 0x9375},
    {0x7826, 0x8dd4}, {0x7827, 0x8b6d}, {0x7832, 0x9643}, {0x7834, 0x946a},
    {0x783a, 0x9376}, {0x783f, 0x8d7b}, {0x7845, 0xe1e9}, {0x784e, 0xfb79},
    {0x785d, 0x8fc9}, {0x7864, 0xfb7a}, {0x786b, 0x97b0}, {0x786c, 0x8d64},
    {0x786f, 0x8ca5}, {0x7872, 0x94a1}, {0x7874, 0xe1eb}, {0x787a, 0xfb7b},
    {0x787c, 0xe1ed}, {0x7881, 0x8ce9}, {0x7886, 0xe1ec}, {0x7887, 0x92f4},
    {0x788c, 0xe1ef}, {0x788d, 0x8a56}, {0x788e, 0xe1ea}, {0x7891, 0x94e8},
    {0x7893, 0x894f}, {0x7895, 0x8dea}, {0x7897, 0x9871}, {0x789a, 0xe1ee},
    {0x78a3, 0xe1f0}, {0x78a7, 0x95c9}, {0x78a9, 0x90d7}, {0x78aa, 0xe1f2},
    {0x78af, 0xe1f3}, {0x78b5, 0xe1f1}, {0x78ba, 0x8a6d}, {0x78bc, 0xe1f9},
    {0x78be, 0xe1f8}, {0x78c1, 0x8ea5}, {0x78c5, 0xe1fa}, {0x78c6, 0xe1f5},
    {0x78ca, 0xe1fb}, {0x78cb, 0xe1f6}, {0x78d0, 0x94d6}, {0x78d1, 0xe1f4},
    {0x78d4, 0xe1f7}, {0x78da, 0xe241}, {0x78e7, 0xe240}, {0x78e8, 0x9681},
    {0x78ec, 0xe1fc}, {0x78ef, 0x88e9}, {0x78f4, 0xe243}, {0x78fd, 0xe242},
    {0x7901, 0x8fca}, {0x7907, 0xe244}, {0x790e, 0x9162}, {0x7911, 0xe246},
    {0x7912, 0xe245}, {0x7919, 0xe247}, {0x7926, 0xe1e6}, {0x792a, 0xe1e8},
    {0x792b, 0xe249}, {0x792c, 0xe248}, {0x7930, 0xfb7c}, {0x793a, 0x8ea6},
    {0x793c, 0x97e7}, {0x793e, 0x8ed0}, {0x7940, 0xe24a}, {0x7941, 0x8c56},
    {0x7947, 0x8b5f}, {0x7948, 0x8b46}, {0x7949, 0x8e83}, {0x7950, 0x9753},
    {0x7953, 0xe250}, {0x7955, 0xe24f}, {0x7956, 0x9163}, {0x7957, 0xe24c},
    {0x795a, 0xe24e}, {0x795d, 0x8f6a}, {0x795e, 0x905f}, {0x795f, 0xe24d},
    {0x7960, 0xe24b}, {0x7962, 0x9449}, {0x7965, 0x8fcb}, {0x7968, 0x955b},
    {0x796d, 0x8dd5}, {0x7977, 0x9398}, {0x797a, 0xe251}, {0x797f, 0xe252},
    {0x7980, 0xe268}, {0x7981, 0x8bd6}, {0x7984, 0x985c}, {0x7985, 0x9154},
    {0x798a, 0xe253}, {0x798d, 0x89d0}, {0x798e, 0x92f5}, {0x798f, 0x959f},
    {0x7994, 0xfb81}, {0x799b, 0xfb83}, {0x799d, 0xe254}, {0x79a6, 0x8b9a},
    {0x79a7, 0xe255}, {0x79aa, 0xe257}, {0x79ae, 0xe258}, {0x79b0, 0x9448},
    {0x79b1, 0x9398}, {0x79b3, 0xe259}, {0x79b9, 0xe25a}, {0x79ba, 0xe25b},
    {0x79bd, 0x8bd7}, {0x79be, 0x89d1}, {0x79bf, 0x93c3}, {0x79c0, 0x8f47},
    {0x79c1, 0x8e84}, {0x79c9, 0xe25c}, {0x79cb, 0x8f48}, {0x79d1, 0x89c8},
    {0x79d2, 0x9562}, {0x79d5, 0xe25d}, {0x79d8, 0x94e9}, {0x79df, 0x9164},
    {0x79e1, 0xe260}, {0x79e3, 0xe261}, {0x79e4, 0x9489}, {0x79e6, 0x9060},
    {0x79e7, 0xe25e}, {0x79e9, 0x9281}, {0x79ec, 0xe25f}, {0x79f0, 0x8fcc},
    {0x79fb, 0x88da}, {0x7a00, 0x8b48}, {0x7a08, 0xe262}, {0x7a0b, 0x92f6},
    {0x7a0d, 0xe263}, {0x7a0e, 0x90c5}, {0x7a14, 0x96ab}, {0x7a17, 0x9542},
    {0x7a18, 0xe264}, {0x7a19, 0xe265}, {0x7a1a, 0x9274}, {0x7a1c, 0x97c5},
    {0x7a1f, 0xe267}, {0x7a20, 0xe266}, {0x7a2e, 0x8eed}, {0x7a31, 0xe269},
    {0x7a32, 0x88ee}, {0x7a37, 0xe26c}, {0x7a3b, 0xe26a}, {0x7a3c, 0x89d2},
    {0x7a3d, 0x8c6d}, {0x7a3e, 0xe26b}, {0x7a3f, 0x8d65}, {0x7a40, 0x8d92},
    {0x7a42, 0x95e4}, {0x7a43, 0xe26d}, {0x7a46, 0x9673}, {0x7a49, 0xe26f},
    {0x7a4d, 0x90cf}, {0x7a4e, 0x896e}, {0x7a4f, 0x89b8}, {0x7a50, 0x88aa},
    {0x7a57, 0xe26e}, {0x7a61, 0xe270}, {0x7a62, 0xe271}, {0x7a63, 0x8ff5},
    {0x7a69, 0xe272}, {0x7a6b, 0x8a6e}, {0x7a70, 0xe274}, {0x7a74, 0x8c8a},
    {0x7a76, 0x8b86}, {0x7a79, 0xe275}, {0x7a7a, 0x8bf3}, {0x7a7d, 0xe276},
    {0x7a7f, 0x90fa}, {0x7a81, 0x93cb}, {0x7a83, 0x90de}, {0x7a84, 0x8df3},
    {0x7a88, 0xe277}, {0x7a92, 0x9282}, {0x7a93, 0x918b}, {0x7a95, 0xe279},
    {0x7a96, 0xe27b}, {0x7a97, 0xe278}, {0x7a98, 0xe27a}, {0x7a9f, 0x8c41},
    {0x7aa9, 0xe27c}, {0x7aaa, 0x8c45}, {0x7aae, 0x8b87}, {0x7aaf, 0x9771},
    {0x7ab0, 0xe27e}, {0x7ab6, 0xe280}, {0x7aba, 0x894d}, {0x7abf, 0xe283},
    {0x7ac3, 0x8a96}, {0x7ac4, 0xe282}, {0x7ac5, 0xe281}, {0x7ac7, 0xe285},
    {0x7ac8, 0xe27d}, {0x7aca, 0xe286}, {0x7acb, 0x97a7}, {0x7acd, 0xe287},
    {0x7acf, 0xe288}, {0x7ad1, 0xfb84}, {0x7ad2, 0x9af2}, {0x7ad3, 0xe28a},
    {0x7ad5, 0xe289}, {0x7ad9, 0xe28b}, {0x7ada, 0xe28c}, {0x7adc, 0x97b3},
    {0x7add, 0xe28d}, {0x7adf, 0xe8ed}, {0x7ae0, 0x8fcd}, {0x7ae1, 0xe28e},
    {0x7ae2, 0xe28f}, {0x7ae3, 0x8f76}, {0x7ae5, 0x93b6}, {0x7ae6, 0xe290},
    {0x7ae7, 0xfb85}, {0x7aea, 0x9247}, {0x7aeb, 0xfb87}, {0x7aed, 0xe291},
    {0x7aef, 0x925b}, {0x7af0, 0xe292}, {0x7af6, 0x8ba3}, {0x7af8, 0x995e},
    {0x7af9, 0x927c}, {0x7afa, 0x8eb1}, {0x7aff, 0x8ac6}, {0x7b02, 0xe293},
    {0x7b04, 0xe2a0}, {0x7b06, 0xe296}, {0x7b08, 0x8b88}, {0x7b0a, 0xe295},
    {0x7b0b, 0xe2a2}, {0x7b0f, 0xe294}, {0x7b11, 0x8fce}, {0x7b18, 0xe298},
    {0x7b19, 0xe299}, {0x7b1b, 0x934a}, {0x7b1e, 0xe29a}, {0x7b20, 0x8a7d},
    {0x7b25, 0x9079}, {0x7b26, 0x9584}, {0x7b28, 0xe29c}, {0x7b2c, 0x91e6},
    {0x7b33, 0xe297}, {0x7b35, 0xe29b}, {0x7b36, 0xe29d}, {0x7b39, 0x8df9},
    {0x7b45, 0xe2a4}, {0x7b46, 0x954d}, {0x7b48, 0x94a4}, {0x7b49, 0x9399},
    {0x7b4b, 0x8bd8}, {0x7b4c, 0xe2a3}, {0x7b4d, 0xe2a1}, {0x7b4f, 0x94b3},
    {0x7b50, 0xe29e}, {0x7b51, 0x927d}, {0x7b52, 0x939b}, {0x7b54, 0x939a},
    {0x7b56, 0x8df4}, {0x7b5d, 0xe2b6}, {0x7b65, 0xe2a6}, {0x7b67, 0xe2a8},
    {0x7b6c, 0xe2ab}, {0x7b6e, 0xe2ac}, {0x7b70, 0xe2a9}, {0x7b71, 0xe2aa},
    {0x7b74, 0xe2a7}, {0x7b75, 0xe2a5}, {0x7b7a, 0xe29f}, {0x7b86, 0x95cd},
    {0x7b87, 0x89d3}, {0x7b8b, 0xe2b3}, {0x7b8d, 0xe2b0}, {0x7b8f, 0xe2b5},
    {0x7b92, 0xe2b4}, {0x7b94, 0x9493}, {0x7b95, 0x96a5}, {0x7b97, 0x8e5a},
    {0x7b98, 0xe2ae}, {0x7b99, 0xe2b7}, {0x7b9a, 0xe2b2}, {0x7b9c, 0xe2b1},
    {0x7b9d, 0xe2ad}, {0x7b9e, 0xfb88}, {0x7b9f, 0xe2af}, {0x7ba1, 0x8ac7},
    {0x7baa, 0x925c}, {0x7bad, 0x90fb}, {0x7bb1, 0x94a0}, {0x7bb4, 0xe2bc},
    {0x7bb8, 0x94a2}, {0x7bc0, 0x90df}, {0x7bc1, 0xe2b9}, {0x7bc4, 0x94cd},
    {0x7bc6, 0xe2bd}, {0x7bc7, 0x95d1}, {0x7bc9, 0x927a}, {0x7bcb, 0xe2b8},
    {0x7bcc, 0xe2ba}, {0x7bcf, 0xe2bb}, {0x7bdd, 0xe2be}, {0x7be0, 0x8ec2},
    {0x7be4, 0x93c4}, {0x7be5, 0xe2c3}, {0x7be6, 0xe2c2}, {0x7be9, 0xe2bf},
    {0x7bed, 0x9855}, {0x7bf3, 0xe2c8}, {0x7bf6, 0xe2cc}, {0x7bf7, 0xe2c9},
    {0x7c00, 0xe2c5}, {0x7c07, 0xe2c6}, {0x7c0d, 0xe2cb}, {0x7c11, 0xe2c0},
    {0x7c12, 0x99d3}, {0x7c13, 0xe2c7}, {0x7c14, 0xe2c1}, {0x7c17, 0xe2ca},
    {0x7c1e, 0x925c}, {0x7c1f, 0xe2d0}, {0x7c21, 0x8ac8}, {0x7c23, 0xe2cd},
    {0x7c27, 0xe2ce}, {0x7c2a, 0xe2cf}, {0x7c2b, 0xe2d2}, {0x7c37, 0xe2d1},
    {0x7c38, 0x94f4}, {0x7c3d, 0xe2d3}, {0x7c3e, 0x97fa}, {0x7c3f, 0x95eb},
    {0x7c40, 0xe2d8}, {0x7c43, 0xe2d5}, {0x7c4c, 0xe2d4}, {0x7c4d, 0x90d0},
    {0x7c4f, 0xe2d7}, {0x7c50, 0xe2d9}, {0x7c54, 0xe2d6}, {0x7c56, 0xe2dd},
    {0x7c58, 0xe2da}, {0x7c5f, 0xe2db}, {0x7c60, 0xe2c4}, {0x7c64, 0xe2dc},
    {0x7c65, 0xe2de}, {0x7c6c, 0xe2df}, {0x7c73, 0x95c4}, {0x7c75, 0xe2e0},
    {0x7c7e, 0x96e0}, {0x7c81, 0x8bcc}, {0x7c82, 0x8c48}, {0x7c83, 0xe2e1},
    {0x7c89, 0x95b2}, {0x7c8b, 0x9088}, {0x7c8d, 0x96ae}, {0x7c90, 0xe2e2},
    {0x7c92, 0x97b1}, {0x7c95, 0x9494}, {0x7c97, 0x9165}, {0x7c98, 0x9453},
    {0x7c9b, 0x8f6c}, {0x7c9f, 0x88be}, {0x7ca1, 0xe2e7}, {0x7ca2, 0xe2e5},
    {0x7ca4, 0xe2e3}, {0x7ca5, 0x8a9f}, {0x7ca7, 0x8fcf}, {0x7ca8, 0xe2e8},
    {0x7cab, 0xe2e6}, {0x7cad, 0xe2e4}, {0x7cae, 0xe2ec}, {0x7cb1, 0xe2eb},
    {0x7cb2, 0xe2ea}, {0x7cb3, 0xe2e9}, {0x7cb9, 0xe2ed}, {0x7cbd, 0xe2ee},
    {0x7cbe, 0x90b8}, {0x7cc0, 0xe2ef}, {0x7cc2, 0xe2f1}, {0x7cc5, 0xe2f0},
    {0x7cca, 0x8cd0}, {0x7cce, 0x9157}, {0x7cd2, 0xe2f3}, {0x7cd6, 0x939c},
    {0x7cd8, 0xe2f2}, {0x7cdc, 0xe2f4}, {0x7cde, 0x95b3}, {0x7cdf, 0x918c},
    {0x7ce0, 0x8d66}, {0x7ce2, 0xe2f5}, {0x7ce7, 0x97c6}, {0x7cef, 0xe2f7},
    {0x7cf2, 0xe2f8}, {0x7cf4, 0xe2f9}, {0x7cf6, 0xe2fa}, {0x7cf8, 0x8e85},
    {0x7cfa, 0xe2fb}, {0x7cfb, 0x8c6e}, {0x7cfe, 0x8b8a}, {0x7d00, 0x8b49},
    {0x7d02, 0xe340}, {0x7d04, 0x96f1}, {0x7d05, 0x8d67}, {0x7d06, 0xe2fc},
    {0x7d0a, 0xe343}, {0x7d0b, 0x96e4}, {0x7d0d, 0x945b}, {0x7d10, 0x9552},
    {0x7d14, 0x8f83}, {0x7d15, 0xe342}, {0x7d17, 0x8ed1}, {0x7d18, 0x8d68},
    {0x7d19, 0x8e86}, {0x7d1a, 0x8b89}, {0x7d1b, 0x95b4}, {0x7d1c, 0xe341},
    {0x7d20, 0x9166}, {0x7d21, 0x9661}, {0x7d22, 0x8df5}, {0x7d2b, 0x8e87},
    {0x7d2c, 0x92db}, {0x7d2e, 0xe346}, {0x7d2f, 0x97dd}, {0x7d30, 0x8dd7},
    {0x7d32, 0xe347}, {0x7d33, 0x9061}, {0x7d35, 0xe349}, {0x7d39, 0x8fd0},
    {0x7d3a, 0x8dae}, {0x7d3f, 0xe348}, {0x7d42, 0x8f49}, {0x7d43, 0x8cbc},
    {0x7d44, 0x9167}, {0x7d45, 0xe344}, {0x7d46, 0xe34a}, {0x7d48, 0xfb8a},
    {0x7d4b, 0xe345}, {0x7d4c, 0x8c6f}, {0x7d4e, 0xe34d}, {0x7d4f, 0xe351},
    {0x7d50, 0x8c8b}, {0x7d56, 0xe34c}, {0x7d5b, 0xe355}, {0x7d5c, 0xfb8b},
    {0x7d5e, 0x8d69}, {0x7d61, 0x978d}, {0x7d62, 0x88ba}, {0x7d63, 0xe352},
    {0x7d66, 0x8b8b}, {0x7d68, 0xe34f}, {0x7d6e, 0xe350}, {0x7d71, 0x939d},
    {0x7d72, 0xe34e}, {0x7d73, 0xe34b}, {0x7d75, 0x8a47}, {0x7d76, 0x90e2},
    {0x7d79, 0x8ca6}, {0x7d7d, 0xe357}, {0x7d89, 0xe354}, {0x7d8f, 0xe356},
    {0x7d93, 0xe353}, {0x7d99, 0x8c70}, {0x7d9a, 0x91b1}, {0x7d9b, 0xe358},
    {0x7d9c, 0x918e}, {0x7d9f, 0xe365}, {0x7da0, 0xfb8d}, {0x7da2, 0xe361},
    {0x7da3, 0xe35b}, {0x7dab, 0xe35f}, {0x7dac, 0x8ef8}, {0x7dad, 0x88db},
    {0x7dae, 0xe35a}, {0x7daf, 0xe362}, {0x7db0, 0xe366}, {0x7db1, 0x8d6a},
    {0x7db2, 0x96d4}, {0x7db4, 0x92d4}, {0x7db5, 0xe35c}, {0x7db7, 0xfb8c},
    {0x7db8, 0xe364}, {0x7dba, 0xe359}, {0x7dbb, 0x925d}, {0x7dbd, 0xe35e},
    {0x7dbe, 0x88bb}, {0x7dbf, 0x96c8}, {0x7dc7, 0xe35d}, {0x7dca, 0x8bd9},
    {0x7dcb, 0x94ea}, {0x7dcf, 0x918d}, {0x7dd1, 0x97ce}, {0x7dd2, 0x8f8f},
    {0x7dd5, 0xe38e}, {0x7dd6, 0xfb8e}, {0x7dd8, 0xe367}, {0x7dda, 0x90fc},
    {0x7ddc, 0xe363}, {0x7ddd, 0xe368}, {0x7dde, 0xe36a}, {0x7de0, 0x92f7},
    {0x7de1, 0xe36d}, {0x7de4, 0xe369}, {0x7de8, 0x95d2}, {0x7de9, 0x8ac9},
    {0x7dec, 0x96c9}, {0x7def, 0x88dc}, {0x7df2, 0xe36c}, {0x7df4, 0x97fb},
    {0x7dfb, 0xe36b}, {0x7e01, 0x898f}, {0x7e04, 0x93ea}, {0x7e05, 0xe36e},
    {0x7e09, 0xe375}, {0x7e0a, 0xe36f}, {0x7e0b, 0xe376}, {0x7e12, 0xe372},
    {0x7e1b, 0x949b}, {0x7e1e, 0x8ec8}, {0x7e1f, 0xe374}, {0x7e21, 0xe371},
    {0x7e22, 0xe377}, {0x7e23, 0xe370}, {0x7e26, 0x8f63}, {0x7e2b, 0x9644},
    {0x7e2e, 0x8f6b}, {0x7e31, 0xe373}, {0x7e32, 0xe380}, {0x7e35, 0xe37b},
    {0x7e37, 0xe37e}, {0x7e39, 0xe37c}, {0x7e3a, 0xe381}, {0x7e3b, 0xe37a},
    {0x7e3d, 0xe360}, {0x7e3e, 0x90d1}, {0x7e41, 0x94c9}, {0x7e43, 0xe37d},
    {0x7e46, 0xe378}, {0x7e48, 0xe379}, {0x7e4a, 0x9140}, {0x7e4b, 0x8c71},
    {0x7e4d, 0x8f4a}, {0x7e52, 0xfb8f}, {0x7e54, 0x9044}, {0x7e55, 0x9155},
    {0x7e56, 0xe384}, {0x7e59, 0xe386}, {0x7e5a, 0xe387}, {0x7e5d, 0xe383},
    {0x7e5e, 0xe385}, {0x7e61, 0x8f4a}, {0x7e66, 0xe379}, {0x7e67, 0xe382},
    {0x7e69, 0xe38a}, {0x7e6a, 0xe389}, {0x7e6b, 0x8c71}, {0x7e6d, 0x969a},
    {0x7e70, 0x8c4a}, {0x7e79, 0xe388}, {0x7e7b, 0xe38c}, {0x7e7c, 0xe38b},
    {0x7e7d, 0xe38f}, {0x7e7f, 0xe391}, {0x7e82, 0x8e5b}, {0x7e83, 0xe38d},
    {0x7e88, 0xe392}, {0x7e89, 0xe393}, {0x7e8a, 0xfa5c}, {0x7e8c, 0xe394},
    {0x7e8e, 0xe39a}, {0x7e8f, 0x935a}, {0x7e90, 0xe396}, {0x7e92, 0xe395},
    {0x7e93, 0xe397}, {0x7e94, 0xe398}, {0x7e96, 0xe399}, {0x7e9b, 0xe39b},
    {0x7e9c, 0xe39c}, {0x7f36, 0x8aca}, {0x7f38, 0xe39d}, {0x7f3a, 0xe39e},
    {0x7f45, 0xe39f}, {0x7f47, 0xfb90}, {0x7f4c, 0xe3a0}, {0x7f4d, 0xe3a1},
    {0x7f4e, 0xe3a2}, {0x7f50, 0xe3a3}, {0x7f51, 0xe3a4}, {0x7f54, 0xe3a6},
    {0x7f55, 0xe3a5}, {0x7f58, 0xe3a7}, {0x7f5f, 0xe3a8}, {0x7f60, 0xe3a9},
    {0x7f67, 0xe3ac}, {0x7f68, 0xe3aa}, {0x7f69, 0xe3ab}, {0x7f6a, 0x8ddf},
    {0x7f6b, 0x8c72}, {0x7f6e, 0x9275}, {0x7f70, 0x94b1}, {0x7f72, 0x8f90},
    {0x7f75, 0x946c}, {0x7f77, 0x94eb}, {0x7f78, 0xe3ad}, {0x7f79, 0x9ceb},
    {0x7f82, 0xe3ae}, {0x7f83, 0xe3b0}, {0x7f85, 0x9785}, {0x7f86, 0xe3af},
    {0x7f87, 0xe3b2}, {0x7f88, 0xe3b1}, {0x7f8a, 0x9772}, {0x7f8c, 0xe3b3},
    {0x7f8e, 0x94fc}, {0x7f94, 0xe3b4}, {0x7f9a, 0xe3b7}, {0x7f9d, 0xe3b6},
    {0x7f9e, 0xe3b5}, {0x7fa1, 0xfb91}, {0x7fa3, 0xe3b8}, {0x7fa4, 0x8c51},
    {0x7fa8, 0x9141}, {0x7fa9, 0x8b60}, {0x7fae, 0xe3bc}, {0x7faf, 0xe3b9},
    {0x7fb2, 0xe3ba}, {0x7fb6, 0xe3bd}, {0x7fb8, 0xe3be}, {0x7fb9, 0xe3bb},
    {0x7fbd, 0x8948}, {0x7fc1, 0x89a5}, {0x7fc5, 0xe3c0}, {0x7fc6, 0xe3c1},
    {0x7fca, 0xe3c2}, {0x7fcc, 0x9782}, {0x7fd2, 0x8f4b}, {0x7fd4, 0xe3c4},
    {0x7fd5, 0xe3c3}, {0x7fe0, 0x9089}, {0x7fe1, 0xe3c5}, {0x7fe6, 0xe3c6},
    {0x7fe9, 0xe3c7}, {0x7feb, 0x8ae3}, {0x7ff0, 0x8acb}, {0x7ff3, 0xe3c8},
    {0x7ff9, 0xe3c9}, {0x7ffb, 0x967c}, {0x7ffc, 0x9783}, {0x8000, 0x9773},
    {0x8001, 0x9856}, {0x8003, 0x8d6c}, {0x8004, 0xe3cc}, {0x8005, 0x8ed2},
    {0x8006, 0xe3cb}, {0x800b, 0xe3cd}, {0x800c, 0x8ea7}, {0x8010, 0x91cf},
    {0x8012, 0xe3ce}, {0x8015, 0x8d6b}, {0x8017, 0x96d5}, {0x8018, 0xe3cf},
    {0x8019, 0xe3d0}, {0x801c, 0xe3d1}, {0x8021, 0xe3d2}, {0x8028, 0xe3d3},
    {0x8033, 0x8ea8}, {0x8036, 0x96eb}, {0x803b, 0xe3d5}, {0x803d, 0x925e},
    {0x803f, 0xe3d4}, {0x8046, 0xe3d7}, {0x804a, 0xe3d6}, {0x8052, 0xe3d8},
    {0x8056, 0x90b9}, {0x8058, 0xe3d9}, {0x805a, 0xe3da}, {0x805e, 0x95b7},
    {0x805f, 0xe3db}, {0x8061, 0x918f}, {0x8062, 0xe3dc}, {0x8068, 0xe3dd},
    {0x806f, 0x97fc}, {0x8070, 0xe3e0}, {0x8072, 0xe3df}, {0x8073, 0xe3de},
    {0x8074, 0x92ae}, {0x8076, 0xe3e1}, {0x8077, 0x9045}, {0x8079, 0xe3e2},
    {0x807d, 0xe3e3}, {0x807e, 0x9857}, {0x807f, 0xe3e4}, {0x8084, 0xe3e5},
    {0x8085, 0xe3e7}, {0x8086, 0xe3e6}, {0x8087, 0x94a3}, {0x8089, 0x93f7},
    {0x808b, 0x985d}, {0x808c, 0x94a7}, {0x8093, 0xe3e9}, {0x8096, 0x8fd1},
    {0x8098, 0x9549}, {0x809a, 0xe3ea}, {0x809b, 0xe3e8}, {0x809d, 0x8acc},
    {0x80a1, 0x8cd2}, {0x80a2, 0x8e88}, {0x80a5, 0x94ec}, {0x80a9, 0x8ca8},
    {0x80aa, 0x9662}, {0x80ac, 0xe3ed}, {0x80ad, 0xe3eb}, {0x80af, 0x8d6d},
    {0x80b1, 0x8d6e}, {0x80b2, 0x88e7}, {0x80b4, 0x8de6}, {0x80ba, 0x9478},
    {0x80c3, 0x88dd}, {0x80c4, 0xe3f2}, {0x80c6, 0x925f}, {0x80cc, 0x9477},
    {0x80ce, 0x91d9}, {0x80d6, 0xe3f4}, {0x80d9, 0xe3f0}, {0x80da, 0xe3f3},
    {0x80db, 0xe3ee}, {0x80dd, 0xe3f1}, {0x80de, 0x9645}, {0x80e1, 0x8cd3},
    {0x80e4, 0x88fb}, {0x80e5, 0xe3ef}, {0x80ef, 0xe3f6}, {0x80f1, 0xe3f7},
    {0x80f4, 0x93b7}, {0x80f8, 0x8bb9}, {0x80fc, 0xe445}, {0x80fd, 0x945c},
    {0x8102, 0x8e89}, {0x8105, 0x8bba}, {0x8106, 0x90c6}, {0x8107, 0x9865},
    {0x8108, 0x96ac}, {0x8109, 0xe3f5}, {0x810a, 0x90d2}, {0x811a, 0x8b72},
    {0x811b, 0xe3f8}, {0x8123, 0xe3fa}, {0x8129, 0xe3f9}, {0x812f, 0xe3fb},
    {0x8131, 0x9245}, {0x8133, 0x945d}, {0x8139, 0x92af}, {0x813e, 0xe442},
    {0x8141, 0xe445}, {0x8146, 0xe441}, {0x814b, 0xe3fc}, {0x814e, 0x9074},
    {0x8150, 0x9585}, {0x8151, 0xe444}, {0x8153, 0xe443}, {0x8154, 0x8d6f},
    {0x8155, 0x9872}, {0x815f, 0xe454}, {0x8165, 0xe448}, {0x8166, 0xe449},
    {0x816b, 0x8eee}, {0x816e, 0xe447}, {0x8170, 0x8d98}, {0x8171, 0xe446},
    {0x8174, 0xe44a}, {0x8178, 0x92b0}, {0x8179, 0x95a0}, {0x817a, 0x9142},
    {0x817f, 0x91da}, {0x8180, 0xe44e}, {0x8182, 0xe44f}, {0x8183, 0xe44b},
    {0x8188, 0xe44c}, {0x818a, 0xe44d}, {0x818f, 0x8d70}, {0x8193, 0xe455},
    {0x8195, 0xe451}, {0x819a, 0x9586}, {0x819c, 0x968c}, {0x819d, 0x9547},
    {0x81a0, 0xe450}, {0x81a3, 0xe453}, {0x81a4, 0xe452}, {0x81a8, 0x9663},
    {0x81a9, 0xe456}, {0x81b0, 0xe457}, {0x81b3, 0x9156}, {0x81b5, 0xe458},
    {0x81b8, 0xe45a}, {0x81ba, 0xe45e}, {0x81bd, 0xe45b}, {0x81be, 0xe459},
    {0x81bf, 0x945e}, {0x81c0, 0xe45c}, {0x81c2, 0xe45d}, {0x81c6, 0x89b0},
    {0x81c8, 0xe464}, {0x81c9, 0xe45f}, {0x81cd, 0xe460}, {0x81d1, 0xe461},
    {0x81d3, 0x919f}, {0x81d8, 0xe463}, {0x81d9, 0xe462}, {0x81da, 0xe465},
    {0x81df, 0xe466}, {0x81e0, 0xe467}, {0x81e3, 0x9062}, {0x81e5, 0x89e7},
    {0x81e7, 0xe468}, {0x81e8, 0x97d5}, {0x81ea, 0x8ea9}, {0x81ed, 0x8f4c},
    {0x81f3, 0x8e8a}, {0x81f4, 0x9276}, {0x81fa, 0xe469}, {0x81fb, 0xe46a},
    {0x81fc, 0x8950}, {0x81fe, 0xe46b}, {0x8201, 0xe46c}, {0x8202, 0xe46d},
    {0x8205, 0xe46e}, {0x8207, 0xe46f}, {0x8208, 0x8bbb}, {0x8209, 0x9da8},
    {0x820a, 0xe470}, {0x820c, 0x90e3}, {0x820d, 0xe471}, {0x820e, 0x8ec9},
    {0x8210, 0xe472}, {0x8212, 0x98ae}, {0x8216, 0xe473}, {0x8217, 0x95dc},
    {0x8218, 0x8ada}, {0x821b, 0x9143}, {0x821c, 0x8f77}, {0x821e, 0x9591},
    {0x821f, 0x8f4d}, {0x8229, 0xe474}, {0x822a, 0x8d71}, {0x822b, 0xe475},
    {0x822c, 0x94ca}, {0x822e, 0xe484}, {0x8233, 0xe477}, {0x8235, 0x91c7},
    {0x8236, 0x9495}, {0x8237, 0x8cbd}, {0x8238, 0xe476}, {0x8239, 0x9144},
    {0x8240, 0xe478}, {0x8247, 0x92f8}, {0x8258, 0xe47a}, {0x8259, 0xe479},
    {0x825a, 0xe47c}, {0x825d, 0xe47b}, {0x825f, 0xe47d}, {0x8262, 0xe480},
    {0x8264, 0xe47e}, {0x8266, 0x8acd}, {0x8268, 0xe481}, {0x826a, 0xe482},
    {0x826b, 0xe483}, {0x826e, 0x8daf}, {0x826f, 0x97c7}, {0x8271, 0xe485},
    {0x8272, 0x9046}, {0x8276, 0x8990}, {0x8277, 0xe486}, {0x8278, 0xe487},
    {0x827e, 0xe488}, {0x828b, 0x88f0}, {0x828d, 0xe489}, {0x8292, 0xe48a},
    {0x8299, 0x9587}, {0x829d, 0x8ec5}, {0x829f, 0xe48c}, {0x82a5, 0x8a48},
    {0x82a6, 0x88b0}, {0x82ab, 0xe48b}, {0x82ac, 0xe48e}, {0x82ad, 0x946d},
    {0x82af, 0x9063}, {0x82b1, 0x89d4}, {0x82b3, 0x9646}, {0x82b8, 0x8c7c},
    {0x82b9, 0x8bda}, {0x82bb, 0xe48d}, {0x82bd, 0x89e8}, {0x82c5, 0x8aa1},
    {0x82d1, 0x8991}, {0x82d2, 0xe492}, {0x82d3, 0x97e8}, {0x82d4, 0x91db},
    {0x82d7, 0x9563}, {0x82d9, 0xe49e}, {0x82db, 0x89d5}, {0x82dc, 0xe49c},
    {0x82de, 0xe49a}, {0x82df, 0xe491}, {0x82e1, 0xe48f}, {0x82e3, 0xe490},
    {0x82e5, 0x8ee1}, {0x82e6, 0x8bea}, {0x82e7, 0x9297}, {0x82eb, 0x93cf},
    {0x82f1, 0x8970}, {0x82f3, 0xe494}, {0x82f4, 0xe493}, {0x82f9, 0xe499},
    {0x82fa, 0xe495}, {0x82fb, 0xe498}, {0x8301, 0xfb93}, {0x8302, 0x96ce},
    {0x8303, 0xe497}, {0x8304, 0x89d6}, {0x8305, 0x8a9d}, {0x8306, 0xe49b},
    {0x8309, 0xe49d}, {0x830e, 0x8c73}, {0x8316, 0xe4a1}, {0x8317, 0xe4aa},
    {0x8318, 0xe4ab}, {0x831c, 0x88a9}, {0x8323, 0xe4b2}, {0x8328, 0x88ef},
    {0x832b, 0xe4a9}, {0x832f, 0xe4a8}, {0x8331, 0xe4a3}, {0x8332, 0xe4a2},
    {0x8334, 0xe4a0}, {0x8335, 0xe49f}, {0x8336, 0x9283}, {0x8338, 0x91f9},
    {0x8339, 0xe4a5}, {0x8340, 0xe4a4}, {0x8345, 0xe4a7}, {0x8346, 0x8c74},
    {0x8349, 0x9190}, {0x834a, 0x8c74}, {0x834f, 0x8960}, {0x8350, 0xe4a6},
    {0x8352, 0x8d72}, {0x8358, 0x9191}, {0x8362, 0xfb94}, {0x8373, 0xe4b8},
    {0x8375, 0xe4b9}, {0x8377, 0x89d7}, {0x837b, 0x89ac}, {0x837c, 0xe4b6},
    {0x837f, 0xfb95}, {0x8385, 0xe4ac}, {0x8387, 0xe4b4}, {0x8389, 0xe4bb},
    {0x838a, 0xe4b5}, {0x838e, 0xe4b3}, {0x8393, 0xe496}, {0x8396, 0xe4b1},
    {0x839a, 0xe4ad}, {0x839e, 0x8ace}, {0x839f, 0xe4af}, {0x83a0, 0xe4ba},
    {0x83a2, 0xe4b0}, {0x83a8, 0xe4bc}, {0x83aa, 0xe4ae}, {0x83ab, 0x949c},
    {0x83b1, 0x9789}, {0x83b5, 0xe4b7}, {0x83bd, 0xe4cd}, {0x83c1, 0xe4c5},
    {0x83c5, 0x909b}, {0x83c7, 0xfb96}, {0x83ca, 0x8b65}, {0x83cc, 0x8bdb},
    {0x83ce, 0xe4c0}, {0x83d3, 0x89d9}, {0x83d6, 0x8fd2}, {0x83d8, 0xe4c3},
    {0x83dc, 0x8dd8}, {0x83df, 0x9370}, {0x83e0, 0xe4c8}, {0x83e9, 0x95ec},
    {0x83eb, 0xe4bf}, {0x83ef, 0x89d8}, {0x83f0, 0x8cd4}, {0x83f1, 0x9548},
    {0x83f2, 0xe4c9}, {0x83f4, 0xe4bd}, {0x83f6, 0xfb97}, {0x83f7, 0xe4c6},
    {0x83fb, 0xe4d0}, {0x83fd, 0xe4c1}, {0x8403, 0xe4c2}, {0x8404, 0x93b8},
    {0x8407, 0xe4c7}, {0x840a, 0x9789}, {0x840b, 0xe4c4}, {0x840c, 0x9647},
    {0x840d, 0xe4ca}, {0x840e, 0x88de}, {0x8413, 0xe4be}, {0x8420, 0xe4cc},
    {0x8422, 0xe4cb}, {0x8429, 0x948b}, {0x842a, 0xe4d2}, {0x842c, 0xe4dd},
    {0x8431, 0x8a9e}, {0x8435, 0xe4e0}, {0x8438, 0xe4ce}, {0x843c, 0xe4d3},
    {0x843d, 0x978e}, {0x8446, 0xe4dc}, {0x8448, 0xfb98}, {0x8449, 0x9774},
    {0x844e, 0x97a8}, {0x8457, 0x9298}, {0x845b, 0x8a8b}, {0x8461, 0x9592},
    {0x8462, 0xe4e2}, {0x8463, 0x939f}, {0x8466, 0x88af}, {0x8469, 0xe4db},
    {0x846b, 0xe4d7}, {0x846c, 0x9192}, {0x846d, 0xe4d1}, {0x846e, 0xe4d9},
    {0x846f, 0xe4de}, {0x8471, 0x944b}, {0x8475, 0x88a8}, {0x8477, 0xe4d6},
    {0x8479, 0xe4df}, {0x847a, 0x9598}, {0x8482, 0xe4da}, {0x8484, 0xe4d5},
    {0x848b, 0x8fd3}, {0x8490, 0x8f4e}, {0x8494, 0x8eaa}, {0x8499, 0x96d6},
    {0x849c, 0x9566}, {0x849f, 0xe4e5}, {0x84a1, 0xe4ee}, {0x84ad, 0xe4d8},
    {0x84b2, 0x8a97}, {0x84b4, 0xfb99}, {0x84b8, 0x8ff6}, {0x84b9, 0xe4e3},
    {0x84bb, 0xe4e8}, {0x84bc, 0x9193}, {0x84bf, 0xe4e4}, {0x84c1, 0xe4eb},
    {0x84c4, 0x927e}, {0x84c6, 0xe4ec}, {0x84c9, 0x9775}, {0x84ca, 0xe4e1},
    {0x84cb, 0x8a57}, {0x84cd, 0xe4e7}, {0x84d0, 0xe4ea}, {0x84d1, 0x96aa},
    {0x84d6, 0xe4ed}, {0x84d9, 0xe4e6}, {0x84da, 0xe4e9}, {0x84dc, 0xfa60},
    {0x84ec, 0x9648}, {0x84ee, 0x9840}, {0x84f4, 0xe4f1}, {0x84fc, 0xe4f8},
    {0x84ff, 0xe4f0}, {0x8500, 0x8ec1}, {0x8506, 0xe4cf}, {0x8511, 0x95cc},
    {0x8513, 0x96a0}, {0x8514, 0xe4f7}, {0x8515, 0xe4f6}, {0x8517, 0xe4f2},
    {0x8518, 0xe4f3}, {0x851a, 0x8955}, {0x851f, 0xe4f5}, {0x8521, 0xe4ef},
    {0x8523, 0x8fd3}, {0x8526, 0x92d3}, {0x852c, 0xe4f4}, {0x852d, 0x88fc},
    {0x8535, 0x91a0}, {0x853d, 0x95c1}, {0x8540, 0xe4f9}, {0x8541, 0xe540},
    {0x8543, 0x94d7}, {0x8548, 0xe4fc}, {0x8549, 0x8fd4}, {0x854a, 0x8ec7},
    {0x854b, 0xe542}, {0x854e, 0x8bbc}, {0x8553, 0xfb9a}, {0x8555, 0xe543},
    {0x8557, 0x9599}, {0x8558, 0xe4fb}, {0x8559, 0xfb9b}, {0x855a, 0xe4d4},
    {0x8563, 0xe4fa}, {0x8568, 0x986e}, {0x8569, 0x93a0}, {0x856a, 0x9593},
    {0x856b, 0xfb9c}, {0x856d, 0xe54a}, {0x8577, 0xe550}, {0x857e, 0xe551},
    {0x8580, 0xe544}, {0x8584, 0x9496}, {0x8587, 0xe54e}, {0x8588, 0xe546},
    {0x858a, 0xe548}, {0x8590, 0xe552}, {0x8591, 0xe547}, {0x8594, 0xe54b},
    {0x8597, 0x8992}, {0x8599, 0x93e3}, {0x859b, 0xe54c}, {0x859c, 0xe54f},
    {0x85a4, 0xe545}, {0x85a6, 0x9145}, {0x85a8, 0xe549}, {0x85a9, 0x8e46},
    {0x85aa, 0x9064}, {0x85ab, 0x8c4f}, {0x85ac, 0x96f2}, {0x85ae, 0x96f7},
    {0x85af, 0x8f92}, {0x85b0, 0xfb9e}, {0x85b9, 0xe556}, {0x85ba, 0xe554},
    {0x85c1, 0x986d}, {0x85c9, 0xe553}, {0x85cd, 0x9795}, {0x85cf, 0xe555},
    {0x85d0, 0xe557}, {0x85d5, 0xe558}, {0x85dc, 0xe55b}, {0x85dd, 0xe559},
    {0x85e4, 0x93a1}, {0x85e5, 0xe55a}, {0x85e9, 0x94cb}, {0x85ea, 0xe54d},
    {0x85f7, 0x8f93}, {0x85f9, 0xe55c}, {0x85fa, 0xe561}, {0x85fb, 0x9194},
    {0x85fe, 0xe560}, {0x8602, 0xe541}, {0x8606, 0xe562}, {0x8607, 0x9168},
    {0x860a, 0xe55d}, {0x860b, 0xe55f}, {0x8613, 0xe55e}, {0x8616, 0x9f50},
    {0x8617, 0x9f41}, {0x861a, 0xe564}, {0x8622, 0xe563}, {0x862d, 0x9796},
    {0x862f, 0xe1ba}, {0x8630, 0xe565}, {0x863f, 0xe566}, {0x864d, 0xe567},
    {0x864e, 0x8cd5}, {0x8650, 0x8b73}, {0x8654, 0xe569}, {0x8655, 0x997c},
    {0x865a, 0x8b95}, {0x865c, 0x97b8}, {0x865e, 0x8bf1}, {0x865f, 0xe56a},
    {0x8667, 0xe56b}, {0x866b, 0x928e}, {0x8671, 0xe56c}, {0x8679, 0x93f8},
    {0x867b, 0x88b8}, {0x868a, 0x89e1}, {0x868b, 0xe571}, {0x868c, 0xe572},
    {0x8693, 0xe56d}, {0x8695, 0x8e5c}, {0x86a3, 0xe56e}, {0x86a4, 0x9461},
    {0x86a9, 0xe56f}, {0x86aa, 0xe570}, {0x86ab, 0xe57a}, {0x86af, 0xe574},
    {0x86b0, 0xe577}, {0x86b6, 0xe573}, {0x86c4, 0xe575}, {0x86c6, 0xe576},
    {0x86c7, 0x8ed6}, {0x86c9, 0xe578}, {0x86cb, 0x9260}, {0x86cd, 0x8c75},
    {0x86ce, 0x8a61}, {0x86d4, 0xe57b}, {0x86d9, 0x8a5e}, {0x86db, 0xe581},
    {0x86de, 0xe57c}, {0x86df, 0xe580}, {0x86e4, 0x94b8}, {0x86e9, 0xe57d},
    {0x86ec, 0xe57e}, {0x86ed, 0x9567}, {0x86ee, 0x94d8}, {0x86ef, 0xe582},
    {0x86f8, 0x91fb}, {0x86f9, 0xe58c}, {0x86fb, 0xe588}, {0x86fe, 0x89e9},
    {0x8700, 0xe586}, {0x8702, 0x9649}, {0x8703, 0xe587}, {0x8706, 0xe584},
    {0x8708, 0xe585}, {0x8709, 0xe58a}, {0x870a, 0xe58d}, {0x870d, 0xe58b},
    {0x8711, 0xe589}, {0x8712, 0xe583}, {0x8718, 0x9277}, {0x871a, 0xe594},
    {0x871c, 0x96a8}, {0x8725, 0xe592}, {0x8729, 0xe593}, {0x8734, 0xe58e},
    {0x8737, 0xe590}, {0x873b, 0xe591}, {0x873f, 0xe58f}, {0x8749, 0x90e4},
    {0x874b, 0x9858}, {0x874c, 0xe598}, {0x874e, 0xe599}, {0x8753, 0xe59f},
    {0x8755, 0x9049}, {0x8757, 0xe59b}, {0x8759, 0xe59e}, {0x875f, 0xe596},
    {0x8760, 0xe595}, {0x8763, 0xe5a0}, {0x8766, 0x89da}, {0x8768, 0xe59c},
    {0x876a, 0xe5a1}, {0x876e, 0xe59d}, {0x8774, 0xe59a}, {0x8776, 0x92b1},
    {0x8778, 0xe597}, {0x877f, 0x9488}, {0x8782, 0xe5a5}, {0x878d, 0x975a},
    {0x879f, 0xe5a4}, {0x87a2, 0xe5a3}, {0x87ab, 0xe5ac}, {0x87af, 0xe5a6},
    {0x87b3, 0xe5ae}, {0x87ba, 0x9786}, {0x87bb, 0xe5b1}, {0x87bd, 0xe5a8},
    {0x87c0, 0xe5a9}, {0x87c4, 0xe5ad}, {0x87c6, 0xe5b0}, {0x87c7, 0xe5af},
    {0x87cb, 0xe5a7}, {0x87d0, 0xe5aa}, {0x87d2, 0xe5bb}, {0x87e0, 0xe5b4},
    {0x87ec, 0x90e4}, {0x87ef, 0xe5b2}, {0x87f2, 0xe5b3}, {0x87f6, 0xe5b8},
    {0x87f7, 0xe5b9}, {0x87f9, 0x8a49}, {0x87fb, 0x8b61}, {0x87fe, 0xe5b7},
    {0x8805, 0xe5a2}, {0x8807, 0xfba1}, {0x880d, 0xe5b6}, {0x880e, 0xe5ba},
    {0x880f, 0xe5b5}, {0x8811, 0xe5bc}, {0x8815, 0xe5be}, {0x8816, 0xe5bd},
    {0x881f, 0x9858}, {0x8821, 0xe5c0}, {0x8822, 0xe5bf}, {0x8823, 0xe579},
    {0x8827, 0xe5c4}, {0x8831, 0xe5c1}, {0x8836, 0xe5c2}, {0x8839, 0xe5c3},
    {0x883b, 0xe5c5}, {0x8840, 0x8c8c}, {0x8842, 0xe5c7}, {0x8844, 0xe5c6},
    {0x8846, 0x8f4f}, {0x884c, 0x8d73}, {0x884d, 0x9fa5}, {0x8852, 0xe5c8},
    {0x8853, 0x8f70}, {0x8857, 0x8a58}, {0x8859, 0xe5c9}, {0x885b, 0x8971},
    {0x885d, 0x8fd5}, {0x885e, 0xe5ca}, {0x8861, 0x8d74}, {0x8862, 0xe5cb},
    {0x8863, 0x88df}, {0x8868, 0x955c}, {0x886b, 0xe5cc}, {0x8870, 0x908a},
    {0x8872, 0xe5d3}, {0x8875, 0xe5d0}, {0x8877, 0x928f}, {0x887d, 0xe5d1},
    {0x887e, 0xe5ce}, {0x887f, 0x8bdc}, {0x8881, 0xe5cd}, {0x8882, 0xe5d4},
    {0x8888, 0x8c55}, {0x888b, 0x91dc}, {0x888d, 0xe5da}, {0x8892, 0xe5d6},
    {0x8896, 0x91b3}, {0x8897, 0xe5d5}, {0x8899, 0xe5d8}, {0x889e, 0xe5cf},
    {0x88a2, 0xe5d9}, {0x88a4, 0xe5db}, {0x88ab, 0x94ed}, {0x88ae, 0xe5d7},
    {0x88b0, 0xe5dc}, {0x88b1, 0xe5de}, {0x88b4, 0x8cd1}, {0x88b5, 0xe5d2},
    {0x88b7, 0x88bf}, {0x88bf, 0xe5dd}, {0x88c1, 0x8dd9}, {0x88c2, 0x97f4},
    {0x88c3, 0xe5df}, {0x88c4, 0xe5e0}, {0x88c5, 0x9195}, {0x88cf, 0x97a0},
    {0x88d4, 0xe5e1}, {0x88d5, 0x9754}, {0x88d8, 0xe5e2}, {0x88d9, 0xe5e3},
    {0x88dc, 0x95e2}, {0x88dd, 0xe5e4}, {0x88df, 0x8dbe}, {0x88e1, 0x97a1},
    {0x88e8, 0xe5e9}, {0x88f2, 0xe5ea}, {0x88f3, 0x8fd6}, {0x88f4, 0xe5e8},
    {0x88f5, 0xfba2}, {0x88f8, 0x9787}, {0x88f9, 0xe5e5}, {0x88fc, 0xe5e7},
    {0x88fd, 0x90bb}, {0x88fe, 0x909e}, {0x8902, 0xe5e6}, {0x8904, 0xe5eb},
    {0x8907, 0x95a1}, {0x890a, 0xe5ed}, {0x890c, 0xe5ec}, {0x8910, 0x8a8c},
    {0x8912, 0x964a}, {0x8913, 0xe5ee}, {0x891c, 0xfa5d}, {0x891d, 0xe5fa},
    {0x891e, 0xe5f0}, {0x8925, 0xe5f1}, {0x892a, 0xe5f2}, {0x892b, 0xe5f3},
    {0x8936, 0xe5f7}, {0x8938, 0xe5f8}, {0x893b, 0xe5f6}, {0x8941, 0xe5f4},
    {0x8943, 0xe5ef}, {0x8944, 0xe5f5}, {0x894c, 0xe5f9}, {0x894d, 0xe8b5},
    {0x8956, 0x89a6}, {0x895e, 0xe5fc}, {0x895f, 0x8bdd}, {0x8960, 0xe5fb},
    {0x8964, 0xe641}, {0x8966, 0xe640}, {0x896a, 0xe643}, {0x896d, 0xe642},
    {0x896f, 0xe644}, {0x8972, 0x8f50}, {0x8974, 0xe645}, {0x8977, 0xe646},
    {0x897e, 0xe647}, {0x897f, 0x90bc}, {0x8981, 0x9776}, {0x8983, 0xe648},
    {0x8986, 0x95a2}, {0x8987, 0x9465}, {0x8988, 0xe649}, {0x898a, 0xe64a},
    {0x898b, 0x8ca9}, {0x898f, 0x8b4b}, {0x8993, 0xe64b}, {0x8996, 0x8e8b},
    {0x8997, 0x9460}, {0x8998, 0xe64c}, {0x899a, 0x8a6f}, {0x89a1, 0xe64d},
    {0x89a6, 0xe64f}, {0x89a7, 0x9797}, {0x89a9, 0xe64e}, {0x89aa, 0x9065},
    {0x89ac, 0xe650}, {0x89af, 0xe651}, {0x89b2, 0xe652}, {0x89b3, 0x8acf},
    {0x89ba, 0xe653}, {0x89bd, 0xe654}, {0x89bf, 0xe655}, {0x89c0, 0xe656},
    {0x89d2, 0x8a70}, {0x89da, 0xe657}, {0x89dc, 0xe658}, {0x89dd, 0xe659},
    {0x89e3, 0x89f0}, {0x89e6, 0x9047}, {0x89e7, 0xe65a}, {0x89f4, 0xe65b},
    {0x89f8, 0xe65c}, {0x8a00, 0x8cbe}, {0x8a02, 0x92f9}, {0x8a03, 0xe65d},
    {0x8a08, 0x8c76}, {0x8a0a, 0x9075}, {0x8a0c, 0xe660}, {0x8a0e, 0x93a2},
    {0x8a10, 0xe65f}, {0x8a12, 0xfba3}, {0x8a13, 0x8c50}, {0x8a16, 0xe65e},
    {0x8a17, 0x91f5}, {0x8a18, 0x8b4c}, {0x8a1b, 0xe661}, {0x8a1d, 0xe662},
    {0x8a1f, 0x8fd7}, {0x8a23, 0x8c8d}, {0x8a25, 0xe663}, {0x8a2a, 0x964b},
    {0x8a2d, 0x90dd}, {0x8a31, 0x8b96}, {0x8a33, 0x96f3}, {0x8a34, 0x9169},
    {0x8a36, 0xe664}, {0x8a37, 0xfba4}, {0x8a3a, 0x9066}, {0x8a3b, 0x9290},
    {0x8a3c, 0x8fd8}, {0x8a41, 0xe665}, {0x8a46, 0xe668}, {0x8a48, 0xe669},
    {0x8a50, 0x8dbc}, {0x8a51, 0x91c0}, {0x8a52, 0xe667}, {0x8a54, 0x8fd9},
    {0x8a55, 0x955d}, {0x8a5b, 0xe666}, {0x8a5e, 0x8e8c}, {0x8a60, 0x8972},
    {0x8a62, 0xe66d}, {0x8a63, 0x8c77}, {0x8a66, 0x8e8e}, {0x8a69, 0x8e8d},
    {0x8a6b, 0x986c}, {0x8a6c, 0xe66c}, {0x8a6d, 0xe66b}, {0x8a6e, 0x9146},
    {0x8a70, 0x8b6c}, {0x8a71, 0x9862}, {0x8a72, 0x8a59}, {0x8a73, 0x8fda},
    {0x8a79, 0xfba5}, {0x8a7c, 0xe66a}, {0x8a82, 0xe66f}, {0x8a84, 0xe670},
    {0x8a85, 0xe66e}, {0x8a87, 0x8cd6}, {0x8a89, 0x975f}, {0x8a8c, 0x8e8f},
    {0x8a8d, 0x9446}, {0x8a91, 0xe673}, {0x8a93, 0x90be}, {0x8a95, 0x9261},
    {0x8a98, 0x9755}, {0x8a9a, 0xe676}, {0x8a9e, 0x8cea}, {0x8aa0, 0x90bd},
    {0x8aa1, 0xe672}, {0x8aa3, 0xe677}, {0x8aa4, 0x8ceb}, {0x8aa5, 0xe674},
    {0x8aa6, 0xe675}, {0x8aa7, 0xfba6}, {0x8aa8, 0xe671}, {0x8aac, 0x90e0},
    {0x8aad, 0x93c7}, {0x8ab0, 0x924e}, {0x8ab2, 0x89db}, {0x8ab9, 0x94ee},
    {0x8abc, 0x8b62}, {0x8abe, 0xfba7}, {0x8abf, 0x92b2}, {0x8ac2, 0xe67a},
    {0x8ac4, 0xe678}, {0x8ac7, 0x926b}, {0x8acb, 0x90bf}, {0x8acc, 0x8ad0},
    {0x8acd, 0xe679}, {0x8acf, 0x907a}, {0x8ad2, 0x97c8}, {0x8ad6, 0x985f},
    {0x8ada, 0xe67b}, {0x8adb, 0xe687}, {0x8adc, 0x92b3}, {0x8ade, 0xe686},
    {0x8adf, 0xfba8}, {0x8ae0, 0xe683}, {0x8ae1, 0xe68b}, {0x8ae2, 0xe684},
    {0x8ae4, 0xe680}, {0x8ae6, 0x92fa}, {0x8ae7, 0xe67e}, {0x8aeb, 0xe67c},
    {0x8aed, 0x9740}, {0x8aee, 0x8e90}, {0x8af1, 0xe681}, {0x8af3, 0xe67d},
    {0x8af6, 0xfbaa}, {0x8af7, 0xe685}, {0x8af8, 0x8f94}, {0x8afa, 0x8cbf},
    {0x8afe, 0x91f8}, {0x8b00, 0x9664}, {0x8b01, 0x8979}, {0x8b02, 0x88e0},
    {0x8b04, 0x93a3}, {0x8b07, 0xe689}, {0x8b0c, 0xe688}, {0x8b0e, 0x93e4},
    {0x8b10, 0xe68d}, {0x8b14, 0xe682}, {0x8b16, 0xe68c}, {0x8b17, 0xe68e},
    {0x8b19, 0x8caa}, {0x8b1a, 0xe68a}, {0x8b1b, 0x8d75}, {0x8b1d, 0x8ed3},
    {0x8b20, 0xe68f}, {0x8b21, 0x9777}, {0x8b26, 0xe692}, {0x8b28, 0xe695},
    {0x8b2b, 0xe693}, {0x8b2c, 0x9554}, {0x8b33, 0xe690}, {0x8b39, 0x8bde},
    {0x8b3e, 0xe694}, {0x8b41, 0xe696}, {0x8b49, 0xe69a}, {0x8b4c, 0xe697},
    {0x8b4e, 0xe699}, {0x8b4f, 0xe698}, {0x8b53, 0xfbab}, {0x8b56, 0xe69b},
    {0x8b58, 0x8eaf}, {0x8b5a, 0xe69d}, {0x8b5b, 0xe69c}, {0x8b5c, 0x9588},
    {0x8b5f, 0xe69f}, {0x8b66, 0x8c78}, {0x8b6b, 0xe69e}, {0x8b6c, 0xe6a0},
    {0x8b6f, 0xe6a1}, {0x8b70, 0x8b63}, {0x8b71, 0xe3bf}, {0x8b72, 0x8ff7},
    {0x8b74, 0xe6a2}, {0x8b77, 0x8cec}, {0x8b7d, 0xe6a3}, {0x8b7f, 0xfbac},
    {0x8b80, 0xe6a4}, {0x8b83, 0x8e5d}, {0x8b8a, 0x9dcc}, {0x8b8c, 0xe6a5},
    {0x8b8e, 0xe6a6}, {0x8b90, 0x8f51}, {0x8b92, 0xe6a7}, {0x8b93, 0xe6a8},
    {0x8b96, 0xe6a9}, {0x8b99, 0xe6aa}, {0x8b9a, 0xe6ab}, {0x8c37, 0x924a},
    {0x8c3a, 0xe6ac}, {0x8c3f, 0xe6ae}, {0x8c41, 0xe6ad}, {0x8c46, 0x93a4},
    {0x8c48, 0xe6af}, {0x8c4a, 0x964c}, {0x8c4c, 0xe6b0}, {0x8c4e, 0xe6b1},
    {0x8c50, 0xe6b2}, {0x8c55, 0xe6b3}, {0x8c5a, 0x93d8}, {0x8c61, 0x8fdb},
    {0x8c62, 0xe6b4}, {0x8c6a, 0x8d8b}, {0x8c6b, 0x98ac}, {0x8c6c, 0xe6b5},
    {0x8c78, 0xe6b6}, {0x8c79, 0x955e}, {0x8c7a, 0xe6b7}, {0x8c7c, 0xe6bf},
    {0x8c82, 0xe6b8}, {0x8c85, 0xe6ba}, {0x8c89, 0xe6b9}, {0x8c8a, 0xe6bb},
    {0x8c8c, 0x9665}, {0x8c8d, 0xe6bc}, {0x8c8e, 0xe6bd}, {0x8c94, 0xe6be},
    {0x8c98, 0xe6c0}, {0x8c9d, 0x8a4c}, {0x8c9e, 0x92e5}, {0x8ca0, 0x9589},
    {0x8ca1, 0x8de0}, {0x8ca2, 0x8d76}, {0x8ca7, 0x956e}, {0x8ca8, 0x89dd},
    {0x8ca9, 0x94cc}, {0x8caa, 0xe6c3}, {0x8cab, 0x8ad1}, {0x8cac, 0x90d3},
    {0x8cad, 0xe6c2}, {0x8cae, 0xe6c7}, {0x8caf, 0x9299}, {0x8cb0, 0x96e1},
    {0x8cb2, 0xe6c5}, {0x8cb3, 0xe6c6}, {0x8cb4, 0x8b4d}, {0x8cb6, 0xe6c8},
    {0x8cb7, 0x9483}, {0x8cb8, 0x91dd}, {0x8cbb, 0x94ef}, {0x8cbc, 0x935c},
    {0x8cbd, 0xe6c4}, {0x8cbf, 0x9666}, {0x8cc0, 0x89ea}, {0x8cc1, 0xe6ca},
    {0x8cc2, 0x9847}, {0x8cc3, 0x92c0}, {0x8cc4, 0x9864}, {0x8cc7, 0x8e91},
    {0x8cc8, 0xe6c9}, {0x8cca, 0x91af}, {0x8ccd, 0xe6da}, {0x8cce, 0x9147},
    {0x8cd1, 0x93f6}, {0x8cd3, 0x956f}, {0x8cda, 0xe6cd}, {0x8cdb, 0x8e5e},
    {0x8cdc, 0x8e92}, {0x8cde, 0x8fdc}, {0x8ce0, 0x9485}, {0x8ce2, 0x8cab},
    {0x8ce3, 0xe6cc}, {0x8ce4, 0xe6cb}, {0x8ce6, 0x958a}, {0x8cea, 0x8ebf},
    {0x8ced, 0x9371}, {0x8cf0, 0xfbad}, {0x8cf4, 0xfbae}, {0x8cfa, 0xe6cf},
    {0x8cfb, 0xe6d0}, {0x8cfc, 0x8d77}, {0x8cfd, 0xe6ce}, {0x8d04, 0xe6d1},
    {0x8d05, 0xe6d2}, {0x8d07, 0xe6d4}, {0x8d08, 0x91a1}, {0x8d0a, 0xe6d3},
    {0x8d0b, 0x8ae4}, {0x8d0d, 0xe6d6}, {0x8d0f, 0xe6d5}, {0x8d10, 0xe6d7},
    {0x8d12, 0xfbaf}, {0x8d13, 0xe6d9}, {0x8d14, 0xe6db}, {0x8d16, 0xe6dc},
    {0x8d64, 0x90d4}, {0x8d66, 0x8ecd}, {0x8d67, 0xe6dd}, {0x8d6b, 0x8a71},
    {0x8d6d, 0xe6de}, {0x8d70, 0x9196}, {0x8d71, 0xe6df}, {0x8d73, 0xe6e0},
    {0x8d74, 0x958b}, {0x8d76, 0xfbb0}, {0x8d77, 0x8b4e}, {0x8d81, 0xe6e1},
    {0x8d85, 0x92b4}, {0x8d8a, 0x897a}, {0x8d99, 0xe6e2}, {0x8da3, 0x8eef},
    {0x8da8, 0x9096}, {0x8db3, 0x91ab}, {0x8dba, 0xe6e5}, {0x8dbe, 0xe6e4},
    {0x8dc2, 0xe6e3}, {0x8dcb, 0xe6eb}, {0x8dcc, 0xe6e9}, {0x8dcf, 0xe6e6},
    {0x8dd6, 0xe6e8}, {0x8dda, 0xe6e7}, {0x8ddb, 0xe6ea}, {0x8ddd, 0x8b97},
    {0x8ddf, 0xe6ee}, {0x8de1, 0x90d5}, {0x8de3, 0xe6ef}, {0x8de8, 0x8cd7},
    {0x8dea, 0xe6ec}, {0x8deb, 0xe6ed}, {0x8def, 0x9848}, {0x8df3, 0x92b5},
    {0x8df5, 0x9148}, {0x8dfc, 0xe6f0}, {0x8dff, 0xe6f3}, {0x8e08, 0xe6f1},
    {0x8e09, 0xe6f2}, {0x8e0a, 0x9778}, {0x8e0f, 0x93a5}, {0x8e10, 0xe6f6},
    {0x8e1d, 0xe6f4}, {0x8e1e, 0xe6f5}, {0x8e1f, 0xe6f7}, {0x8e2a, 0xe748},
    {0x8e30, 0xe6fa}, {0x8e34, 0xe6fb}, {0x8e35, 0xe6f9}, {0x8e42, 0xe6f8},
    {0x8e44, 0x92fb}, {0x8e47, 0xe740}, {0x8e48, 0xe744}, {0x8e49, 0xe741},
    {0x8e4a, 0xe6fc}, {0x8e4c, 0xe742}, {0x8e50, 0xe743}, {0x8e55, 0xe74a},
    {0x8e59, 0xe745}, {0x8e5f, 0x90d6}, {0x8e60, 0xe747}, {0x8e63, 0xe749},
    {0x8e64, 0xe746}, {0x8e72, 0xe74c}, {0x8e74, 0x8f52}, {0x8e76, 0xe74b},
    {0x8e7c, 0xe74d}, {0x8e81, 0xe74e}, {0x8e84, 0xe751}, {0x8e85, 0xe750},
    {0x8e87, 0xe74f}, {0x8e8a, 0xe753}, {0x8e8b, 0xe752}, {0x8e8d, 0x96f4},
    {0x8e91, 0xe755}, {0x8e93, 0xe754}, {0x8e94, 0xe756}, {0x8e99, 0xe757},
    {0x8ea1, 0xe759}, {0x8eaa, 0xe758}, {0x8eab, 0x9067}, {0x8eac, 0xe75a},
    {0x8eaf, 0x8beb}, {0x8eb0, 0xe75b}, {0x8eb1, 0xe75d}, {0x8ebe, 0xe75e},
    {0x8ec0, 0x8beb}, {0x8ec5, 0xe75f}, {0x8ec6, 0xe75c}, {0x8ec8, 0xe760},
    {0x8eca, 0x8ed4}, {0x8ecb, 0xe761}, {0x8ecc, 0x8b4f}, {0x8ecd, 0x8c52},
    {0x8ecf, 0xfbb2}, {0x8ed2, 0x8cac}, {0x8edb, 0xe762}, {0x8edf, 0x93ee},
    {0x8ee2, 0x935d}, {0x8ee3, 0xe763}, {0x8eeb, 0xe766}, {0x8ef8, 0x8eb2},
    {0x8efb, 0xe765}, {0x8efc, 0xe764}, {0x8efd, 0x8c79}, {0x8efe, 0xe767},
    {0x8f03, 0x8a72}, {0x8f05, 0xe769}, {0x8f09, 0x8dda}, {0x8f0a, 0xe768},
    {0x8f0c, 0xe771}, {0x8f12, 0xe76b}, {0x8f13, 0xe76d}, {0x8f14, 0x95e3},
    {0x8f15, 0xe76a}, {0x8f19, 0xe76c}, {0x8f1b, 0xe770}, {0x8f1c, 0xe76e},
    {0x8f1d, 0x8b50}, {0x8f1f, 0xe76f}, {0x8f26, 0xe772}, {0x8f29, 0x9479},
    {0x8f2a, 0x97d6}, {0x8f2f, 0x8f53}, {0x8f33, 0xe773}, {0x8f38, 0x9741},
    {0x8f39, 0xe775}, {0x8f3b, 0xe774}, {0x8f3e, 0xe778}, {0x8f3f, 0x9760},
    {0x8f42, 0xe777}, {0x8f44, 0x8a8d}, {0x8f45, 0xe776}, {0x8f46, 0xe77b},
    {0x8f49, 0xe77a}, {0x8f4c, 0xe779}, {0x8f4d, 0x9351}, {0x8f4e, 0xe77c},
    {0x8f57, 0xe77d}, {0x8f5c, 0xe77e}, {0x8f5f, 0x8d8c}, {0x8f61, 0x8c44},
    {0x8f62, 0xe780}, {0x8f63, 0xe781}, {0x8f64, 0xe782}, {0x8f9b, 0x9068},
    {0x8f9c, 0xe783}, {0x8f9e, 0x8eab}, {0x8f9f, 0xe784}, {0x8fa3, 0xe785},
    {0x8fa7, 0x999f}, {0x8fa8, 0x999e}, {0x8fad, 0xe786}, {0x8fae, 0xe390},
    {0x8faf, 0xe787}, {0x8fb0, 0x9243}, {0x8fb1, 0x904a}, {0x8fb2, 0x945f},
    {0x8fb7, 0xe788}, {0x8fba, 0x95d3}, {0x8fbb, 0x92d2}, {0x8fbc, 0x8d9e},
    {0x8fbf, 0x9248}, {0x8fc2, 0x8949}, {0x8fc4, 0x9698}, {0x8fc5, 0x9076},
    {0x8fce, 0x8c7d}, {0x8fd1, 0x8bdf}, {0x8fd4, 0x95d4}, {0x8fda, 0xe789},
    {0x8fe2, 0xe78b}, {0x8fe5, 0xe78a}, {0x8fe6, 0x89de}, {0x8fe9, 0x93f4},
    {0x8fea, 0xe78c}, {0x8feb, 0x9497}, {0x8fed, 0x9352}, {0x8fef, 0xe78d},
    {0x8ff0, 0x8f71}, {0x8ff4, 0xe78f}, {0x8ff7, 0x96c0}, {0x8ff8, 0xe79e},
    {0x8ff9, 0xe791}, {0x8ffa, 0xe792}, {0x8ffd, 0x92c7}, {0x9000, 0x91de},
    {0x9001, 0x9197}, {0x9003, 0x93a6}, {0x9005, 0xe790}, {0x9006, 0x8b74},
    {0x900b, 0xe799}, {0x900d, 0xe796}, {0x900e, 0xe7a3}, {0x900f, 0x93a7},
    {0x9010, 0x9280}, {0x9011, 0xe793}, {0x9013, 0x92fc}, {0x9014, 0x9372},
    {0x9015, 0xe794}, {0x9016, 0xe798}, {0x9017, 0x9080}, {0x9019, 0x9487},
    {0x901a, 0x92ca}, {0x901d, 0x90c0}, {0x901e, 0xe797}, {0x901f, 0x91ac},
    {0x9020, 0x91a2}, {0x9021, 0xe795}, {0x9022, 0x88a7}, {0x9023, 0x9841},
    {0x9027, 0xe79a}, {0x902e, 0x91df}, {0x9031, 0x8f54}, {0x9032, 0x9069},
    {0x9035, 0xe79c}, {0x9036, 0xe79b}, {0x9038, 0x88ed}, {0x9039, 0xe79d},
    {0x903c, 0x954e}, {0x903e, 0xe7a5}, {0x9041, 0x93d9}, {0x9042, 0x908b},
    {0x9045, 0x9278}, {0x9047, 0x8bf6}, {0x9049, 0xe7a4}, {0x904a, 0x9756},
    {0x904b, 0x895e}, {0x904d, 0x95d5}, {0x904e, 0x89df}, {0x904f, 0xe79f},
    {0x9050, 0xe7a0}, {0x9051, 0xe7a1}, {0x9052, 0xe7a2}, {0x9053, 0x93b9},
    {0x9054, 0x9242}, {0x9055, 0x88e1}, {0x9056, 0xe7a6}, {0x9058, 0xe7a7},
    {0x9059, 0xeaa1}, {0x905c, 0x91bb}, {0x905e, 0xe7a8}, {0x9060, 0x8993},
    {0x9061, 0x916b}, {0x9063, 0x8cad}, {0x9065, 0x9779}, {0x9067, 0xfbb5},
    {0x9068, 0xe7a9}, {0x9069, 0x934b}, {0x906d, 0x9198}, {0x906e, 0x8ed5},
    {0x906f, 0xe7aa}, {0x9072, 0xe7ad}, {0x9075, 0x8f85}, {0x9076, 0xe7ab},
    {0x9077, 0x914a}, {0x9078, 0x9149}, {0x907a, 0x88e2}, {0x907c, 0x97c9},
    {0x907d, 0xe7af}, {0x907f, 0x94f0}, {0x9080, 0xe7b1}, {0x9081, 0xe7b0},
    {0x9082, 0xe7ae}, {0x9083, 0xe284}, {0x9084, 0x8ad2}, {0x9087, 0xe78e},
    {0x9089, 0xe7b3}, {0x908a, 0xe7b2}, {0x908f, 0xe7b4}, {0x9091, 0x9757},
    {0x90a3, 0x93df}, {0x90a6, 0x964d}, {0x90a8, 0xe7b5}, {0x90aa, 0x8ed7},
    {0x90af, 0xe7b6}, {0x90b1, 0xe7b7}, {0x90b5, 0xe7b8}, {0x90b8, 0x9340},
    {0x90c1, 0x88e8}, {0x90ca, 0x8d78}, {0x90ce, 0x9859}, {0x90db, 0xe7bc},
    {0x90de, 0xfbb6}, {0x90e1, 0x8c53}, {0x90e2, 0xe7b9}, {0x90e4, 0xe7ba},
    {0x90e8, 0x9594}, {0x90ed, 0x8a73}, {0x90f5, 0x9758}, {0x90f7, 0x8bbd},
    {0x90fd, 0x9373}, {0x9102, 0xe7bd}, {0x9112, 0xe7be}, {0x9115, 0xfbb8},
    {0x9119, 0xe7bf}, {0x9127, 0xfbb9}, {0x912d, 0x9341}, {0x9130, 0xe7c1},
    {0x9132, 0xe7c0}, {0x9149, 0x93d1}, {0x914a, 0xe7c2}, {0x914b, 0x8f55},
    {0x914c, 0x8ede}, {0x914d, 0x947a}, {0x914e, 0x9291}, {0x9152, 0x8ef0},
    {0x9154, 0x908c}, {0x9156, 0xe7c3}, {0x9158, 0xe7c4}, {0x9162, 0x907c},
    {0x9163, 0xe7c5}, {0x9165, 0xe7c6}, {0x9169, 0xe7c7}, {0x916a, 0x978f},
    {0x916c, 0x8f56}, {0x9172, 0xe7c9}, {0x9173, 0xe7c8}, {0x9175, 0x8d79},
    {0x9177, 0x8d93}, {0x9178, 0x8e5f}, {0x9182, 0xe7cc}, {0x9187, 0x8f86},
    {0x9189, 0xe7cb}, {0x918b, 0xe7ca}, {0x918d, 0x91e7}, {0x9190, 0x8ced},
    {0x9192, 0x90c1}, {0x9197, 0x94ae}, {0x919c, 0x8f58}, {0x91a2, 0xe7cd},
    {0x91a4, 0x8fdd}, {0x91aa, 0xe7d0}, {0x91ab, 0xe7ce}, {0x91ac, 0x8fdd},
    {0x91af, 0xe7cf}, {0x91b1, 0x94ae}, {0x91b4, 0xe7d2}, {0x91b5, 0xe7d1},
    {0x91b8, 0x8ff8}, {0x91ba, 0xe7d3}, {0x91c0, 0xe7d4}, {0x91c1, 0xe7d5},
    {0x91c6, 0x94ce}, {0x91c7, 0x8dd1}, {0x91c8, 0x8edf}, {0x91c9, 0xe7d6},
    {0x91cb, 0xe7d7}, {0x91cc, 0x97a2}, {0x91cd, 0x8f64}, {0x91ce, 0x96ec},
    {0x91cf, 0x97ca}, {0x91d0, 0xe7d8}, {0x91d1, 0x8be0}, {0x91d6, 0xe7d9},
    {0x91d7, 0xfbbb}, {0x91d8, 0x9342}, {0x91da, 0xfbba}, {0x91db, 0xe7dc},
    {0x91dc, 0x8a98}, {0x91dd, 0x906a}, {0x91de, 0xfbbc}, {0x91df, 0xe7da},
    {0x91e1, 0xe7db}, {0x91e3, 0x92de}, {0x91e4, 0xfbbf}, {0x91e5, 0xfbc0},
    {0x91e6, 0x9674}, {0x91e7, 0x8bfa}, {0x91ed, 0xfbbd}, {0x91ee, 0xfbbe},
    {0x91f5, 0xe7de}, {0x91f6, 0xe7df}, {0x91fc, 0xe7dd}, {0x91ff, 0xe7e1},
    {0x9206, 0xfbc1}, {0x920a, 0xfbc3}, {0x920d, 0x93dd}, {0x920e, 0x8a62},
    {0x9210, 0xfbc2}, {0x9211, 0xe7e5}, {0x9214, 0xe7e2}, {0x9215, 0xe7e4},
    {0x921e, 0xe7e0}, {0x9229, 0xe86e}, {0x922c, 0xe7e3}, {0x9234, 0x97e9},
    {0x9237, 0x8cd8}, {0x9239, 0xfbca}, {0x923a, 0xfbc4}, {0x923c, 0xfbc6},
    {0x923f, 0xe7ed}, {0x9240, 0xfbc5}, {0x9244, 0x9353}, {0x9245, 0xe7e8},
    {0x9248, 0xe7eb}, {0x9249, 0xe7e9}, {0x924b, 0xe7ee}, {0x924e, 0xfbc7},
    {0x9250, 0xe7ef}, {0x9251, 0xfbc9}, {0x9257, 0xe7e7}, {0x9259, 0xfbc8},
    {0x925a, 0xe7f4}, {0x925b, 0x8994}, {0x925e, 0xe7e6}, {0x9262, 0x94ab},
    {0x9264, 0xe7ea}, {0x9266, 0x8fde}, {0x9267, 0xfbcb}, {0x9271, 0x8d7a},
    {0x9277, 0xfbcd}, {0x9278, 0xfbce}, {0x927e, 0x9667}, {0x9280, 0x8be2},
    {0x9283, 0x8f65}, {0x9285, 0x93ba}, {0x9288, 0xfa5f}, {0x9291, 0x914c},
    {0x9293, 0xe7f2}, {0x9295, 0xe7ec}, {0x9296, 0xe7f1}, {0x9298, 0x96c1},
    {0x929a, 0x92b6}, {0x929b, 0xe7f3}, {0x929c, 0xe7f0}, {0x92a7, 0xfbcc},
    {0x92ad, 0x914b}, {0x92b7, 0xe7f7}, {0x92b9, 0xe7f6}, {0x92cf, 0xe7f5},
    {0x92d0, 0xfbd2}, {0x92d2, 0x964e}, {0x92d3, 0xfbd6}, {0x92d5, 0xfbd4},
    {0x92d7, 0xfbd0}, {0x92d9, 0xfbd1}, {0x92e0, 0xfbd5}, {0x92e4, 0x8f9b},
    {0x92e7, 0xfbcf}, {0x92e9, 0xe7f8}, {0x92ea, 0x95dd}, {0x92ed, 0x8973},
    {0x92f2, 0x9565}, {0x92f3, 0x9292}, {0x92f8, 0x8b98}, {0x92f9, 0xfa65},
    {0x92fa, 0xe7fa}, {0x92fb, 0xfbd9}, {0x92fc, 0x8d7c}, {0x92ff, 0xfbdc},
    {0x9302, 0xfbde}, {0x9306, 0x8e4b}, {0x930f, 0xe7f9}, {0x9310, 0x908d},
    {0x9318, 0x908e}, {0x9319, 0xe840}, {0x931a, 0xe842}, {0x931d, 0xfbdd},
    {0x931e, 0xfbdb}, {0x9320, 0x8ff9}, {0x9321, 0xfbd8}, {0x9322, 0xe841},
    {0x9323, 0xe843}, {0x9325, 0xfbd7}, {0x9326, 0x8bd1}, {0x9328, 0x9564},
    {0x932b, 0x8ee0}, {0x932c, 0x9842}, {0x932e, 0xe7fc}, {0x932f, 0x8df6},
    {0x9332, 0x985e}, {0x9335, 0xe845}, {0x933a, 0xe844}, {0x933b, 0xe846},
    {0x9344, 0xe7fb}, {0x9348, 0xfa5e}, {0x934b, 0x93e7}, {0x934d, 0x9374},
    {0x9354, 0x92d5}, {0x9356, 0xe84b}, {0x9357, 0xfbe0}, {0x935b, 0x9262},
    {0x935c, 0xe847}, {0x9360, 0xe848}, {0x936c, 0x8c4c}, {0x936e, 0xe84a},
    {0x9370, 0xfbdf}, {0x9375, 0x8cae}, {0x937c, 0xe849}, {0x937e, 0x8fdf},
    {0x938c, 0x8a99}, {0x9394, 0xe84f}, {0x9396, 0x8dbd}, {0x9397, 0x9199},
    {0x939a, 0x92c8}, {0x93a4, 0xfbe1}, {0x93a7, 0x8a5a}, {0x93ac, 0xe84d},
    {0x93ad, 0xe84e}, {0x93ae, 0x92c1}, {0x93b0, 0xe84c}, {0x93b9, 0xe850},
    {0x93c3, 0xe856}, {0x93c6, 0xfbe2}, {0x93c8, 0xe859}, {0x93d0, 0xe858},
    {0x93d1, 0x934c}, {0x93d6, 0xe851}, {0x93d7, 0xe852}, {0x93d8, 0xe855},
    {0x93dd, 0xe857}, {0x93de, 0xfbe3}, {0x93e1, 0x8bbe}, {0x93e4, 0xe85a},
    {0x93e5, 0xe854}, {0x93e8, 0xe853}, {0x93f8, 0xfbe4}, {0x9403, 0xe85e},
    {0x9407, 0xe85f}, {0x9410, 0xe860}, {0x9413, 0xe85d}, {0x9414, 0xe85c},
    {0x9418, 0x8fe0}, {0x9419, 0x93a8}, {0x941a, 0xe85b}, {0x9421, 0xe864},
    {0x942b, 0xe862}, {0x9431, 0xfbe5}, {0x9435, 0xe863}, {0x9436, 0xe861},
    {0x9438, 0x91f6}, {0x943a, 0xe865}, {0x9441, 0xe866}, {0x9444, 0xe868},
    {0x9445, 0xfbe6}, {0x9448, 0xfbe7}, {0x9451, 0x8ad3}, {0x9452, 0xe867},
    {0x9453, 0x96f8}, {0x945a, 0xe873}, {0x945b, 0xe869}, {0x945e, 0xe86c},
    {0x9460, 0xe86a}, {0x9462, 0xe86b}, {0x946a, 0xe86d}, {0x9470, 0xe86f},
    {0x9475, 0xe870}, {0x9477, 0xe871}, {0x947c, 0xe874}, {0x947d, 0xe872},
    {0x947e, 0xe875}, {0x947f, 0xe877}, {0x9481, 0xe876}, {0x9577, 0x92b7},
    {0x9580, 0x96e5}, {0x9582, 0xe878}, {0x9583, 0x914d}, {0x9587, 0xe879},
    {0x9589, 0x95c2}, {0x958a, 0xe87a}, {0x958b, 0x8a4a}, {0x958f, 0x895b},
    {0x9591, 0x8ad5}, {0x9592, 0xfbe8}, {0x9593, 0x8ad4}, {0x9594, 0xe87b},
    {0x9596, 0xe87c}, {0x9598, 0xe87d}, {0x9599, 0xe87e}, {0x95a0, 0xe880},
    {0x95a2, 0x8ad6}, {0x95a3, 0x8a74}, {0x95a4, 0x8d7d}, {0x95a5, 0x94b4},
    {0x95a7, 0xe882}, {0x95a8, 0xe881}, {0x95ad, 0xe883}, {0x95b2, 0x897b},
    {0x95b9, 0xe886}, {0x95bb, 0xe885}, {0x95bc, 0xe884}, {0x95be, 0xe887},
    {0x95c3, 0xe88a}, {0x95c7, 0x88c5}, {0x95ca, 0xe888}, {0x95cc, 0xe88c},
    {0x95cd, 0xe88b}, {0x95d4, 0xe88e}, {0x95d5, 0xe88d}, {0x95d6, 0xe88f},
    {0x95d8, 0x93ac}, {0x95dc, 0xe890}, {0x95e1, 0xe891}, {0x95e2, 0xe893},
    {0x95e5, 0xe892}, {0x961c, 0x958c}, {0x9621, 0xe894}, {0x9628, 0xe895},
    {0x962a, 0x8de3}, {0x962e, 0xe896}, {0x962f, 0xe897}, {0x9632, 0x9668},
    {0x963b, 0x916a}, {0x963f, 0x88a2}, {0x9640, 0x91c9}, {0x9642, 0xe898},
    {0x9644, 0x958d}, {0x964b, 0xe89b}, {0x964c, 0xe899}, {0x964d, 0x8d7e},
    {0x964f, 0xe89a}, {0x9650, 0x8cc0}, {0x965b, 0x95c3}, {0x965c, 0xe89d},
    {0x965d, 0xe89f}, {0x965e, 0xe89e}, {0x965f, 0xe8a0}, {0x9662, 0x8940},
    {0x9663, 0x9077}, {0x9664, 0x8f9c}, {0x9665, 0x8ad7}, {0x9666, 0xe8a1},
    {0x966a, 0x9486}, {0x966c, 0xe8a3}, {0x9670, 0x8941}, {0x9672, 0xe8a2},
    {0x9673, 0x92c2}, {0x9675, 0x97cb}, {0x9676, 0x93a9}, {0x9677, 0xe89c},
    {0x9678, 0x97a4}, {0x967a, 0x8caf}, {0x967d, 0x977a}, {0x9685, 0x8bf7},
    {0x9686, 0x97b2}, {0x9688, 0x8c47}, {0x968a, 0x91e0}, {0x968b, 0xe440},
    {0x968d, 0xe8a4}, {0x968e, 0x8a4b}, {0x968f, 0x908f}, {0x9694, 0x8a75},
    {0x9695, 0xe8a6}, {0x9697, 0xe8a7}, {0x9698, 0xe8a5}, {0x9699, 0x8c84},
    {0x969b, 0x8ddb}, {0x969c, 0x8fe1}, {0x969d, 0xfbeb}, {0x96a0, 0x8942},
    {0x96a3, 0x97d7}, {0x96a7, 0xe8a9}, {0x96a8, 0xe7ac}, {0x96aa, 0xe8a8},
    {0x96af, 0xfbec}, {0x96b0, 0xe8ac}, {0x96b1, 0xe8aa}, {0x96b2, 0xe8ab},
    {0x96b4, 0xe8ad}, {0x96b6, 0xe8ae}, {0x96b7, 0x97ea}, {0x96b8, 0xe8af},
    {0x96b9, 0xe8b0}, {0x96bb, 0x90c7}, {0x96bc, 0x94b9}, {0x96c0, 0x909d},
    {0x96c1, 0x8ae5}, {0x96c4, 0x9759}, {0x96c5, 0x89eb}, {0x96c6, 0x8f57},
    {0x96c7, 0x8cd9}, {0x96c9, 0xe8b3}, {0x96cb, 0xe8b2}, {0x96cc, 0x8e93},
    {0x96cd, 0xe8b4}, {0x96ce, 0xe8b1}, {0x96d1, 0x8e47}, {0x96d5, 0xe8b8},
    {0x96d6, 0xe5ab}, {0x96d9, 0x99d4}, {0x96db, 0x9097}, {0x96dc, 0xe8b6},
    {0x96e2, 0x97a3}, {0x96e3, 0x93ef}, {0x96e8, 0x894a}, {0x96ea, 0x90e1},
    {0x96eb, 0x8eb4}, {0x96f0, 0x95b5}, {0x96f2, 0x895f}, {0x96f6, 0x97eb},
    {0x96f7, 0x978b}, {0x96f9, 0xe8b9}, {0x96fb, 0x9364}, {0x9700, 0x8ef9},
    {0x9704, 0xe8ba}, {0x9706, 0xe8bb}, {0x9707, 0x906b}, {0x9708, 0xe8bc},
    {0x970a, 0x97ec}, {0x970d, 0xe8b7}, {0x970e, 0xe8be}, {0x970f, 0xe8c0},
    {0x9711, 0xe8bf}, {0x9713, 0xe8bd}, {0x9716, 0xe8c1}, {0x9719, 0xe8c2},
    {0x971c, 0x919a}, {0x971e, 0x89e0}, {0x9724, 0xe8c3}, {0x9727, 0x96b6},
    {0x972a, 0xe8c4}, {0x9730, 0xe8c5}, {0x9732, 0x9849}, {0x9733, 0xfbed},
    {0x9738, 0x9e50}, {0x9739, 0xe8c6}, {0x973b, 0xfbee}, {0x973d, 0xe8c7},
    {0x973e, 0xe8c8}, {0x9742, 0xe8cc}, {0x9743, 0xfbef}, {0x9744, 0xe8c9},
    {0x9746, 0xe8ca}, {0x9748, 0xe8cb}, {0x9749, 0xe8cd}, {0x974d, 0xfbf0},
    {0x974f, 0xfbf1}, {0x9751, 0xfbf2}, {0x9752, 0x90c2}, {0x9755, 0xfbf3},
    {0x9756, 0x96f5}, {0x9759, 0x90c3}, {0x975c, 0xe8ce}, {0x975e, 0x94f1},
    {0x9760, 0xe8cf}, {0x9761, 0xea72}, {0x9762, 0x96ca}, {0x9764, 0xe8d0},
    {0x9766, 0xe8d1}, {0x9768, 0xe8d2}, {0x9769, 0x8a76}, {0x976b, 0xe8d4},
    {0x976d, 0x9078}, {0x9771, 0xe8d5}, {0x9774, 0x8c43}, {0x9779, 0xe8d6},
    {0x977a, 0xe8da}, {0x977c, 0xe8d8}, {0x9781, 0xe8d9}, {0x9784, 0x8a93},
    {0x9785, 0xe8d7}, {0x9786, 0xe8db}, {0x978b, 0xe8dc}, {0x978d, 0x88c6},
    {0x978f, 0xe8dd}, {0x9790, 0xe8de}, {0x9798, 0x8fe2}, {0x979c, 0xe8df},
    {0x97a0, 0x8b66}, {0x97a3, 0xe8e2}, {0x97a6, 0xe8e1}, {0x97a8, 0xe8e0},
    {0x97ab, 0xe691}, {0x97ad, 0x95da}, {0x97b3, 0xe8e3}, {0x97b4, 0xe8e4},
    {0x97c3, 0xe8e5}, {0x97c6, 0xe8e6}, {0x97c8, 0xe8e7}, {0x97cb, 0xe8e8},
    {0x97d3, 0x8ad8}, {0x97dc, 0xe8e9}, {0x97ed, 0xe8ea}, {0x97ee, 0x9442},
    {0x97f2, 0xe8ec}, {0x97f3, 0x89b9}, {0x97f5, 0xe8ef}, {0x97f6, 0xe8ee},
    {0x97fb, 0x8943}, {0x97ff, 0x8bbf}, {0x9801, 0x95c5}, {0x9802, 0x92b8},
    {0x9803, 0x8da0}, {0x9805, 0x8d80}, {0x9806, 0x8f87}, {0x9808, 0x907b},
    {0x980c, 0xe8f1}, {0x980f, 0xe8f0}, {0x9810, 0x9761}, {0x9811, 0x8ae6},
    {0x9812, 0x94d0}, {0x9813, 0x93da}, {0x9817, 0x909c}, {0x9818, 0x97cc},
    {0x981a, 0x8c7a}, {0x9821, 0xe8f4}, {0x9824, 0xe8f3}, {0x982c, 0x966a},
    {0x982d, 0x93aa}, {0x9830, 0x966a}, {0x9834, 0x896f}, {0x9837, 0xe8f5},
    {0x9838, 0xe8f2}, {0x9839, 0xe8f6}, {0x983b, 0x9570}, {0x983c, 0x978a},
    {0x983d, 0xe8f6}, {0x9846, 0xe8f7}, {0x984b, 0xe8f9}, {0x984c, 0x91e8},
    {0x984d, 0x8a7a}, {0x984e, 0x8a7b}, {0x984f, 0xe8f8}, {0x9854, 0x8ae7},
    {0x9855, 0x8cb0}, {0x9857, 0xfbf4}, {0x9858, 0x8ae8}, {0x985a, 0x935e},
    {0x985b, 0x935e}, {0x985e, 0x97de}, {0x9865, 0xfbf5}, {0x9867, 0x8cda},
    {0x986b, 0xe8fa}, {0x986f, 0xe8fb}, {0x9870, 0xe8fc}, {0x9871, 0xe940},
    {0x9873, 0xe942}, {0x9874, 0xe941}, {0x98a8, 0x9597}, {0x98aa, 0xe943},
    {0x98af, 0xe944}, {0x98b1, 0xe945}, {0x98b6, 0xe946}, {0x98c3, 0xe948},
    {0x98c4, 0xe947}, {0x98c6, 0xe949}, {0x98db, 0x94f2}, {0x98dc, 0xe3ca},
    {0x98df, 0x9048}, {0x98e2, 0x8b51}, {0x98e9, 0xe94a}, {0x98eb, 0xe94b},
    {0x98ed, 0x99aa}, {0x98ee, 0x9f5a}, {0x98ef, 0x94d1}, {0x98f2, 0x88f9},
    {0x98f4, 0x88b9}, {0x98fc, 0x8e94}, {0x98fd, 0x964f}, {0x98fe, 0x8ffc},
    {0x9903, 0xe94c}, {0x9905, 0x96dd}, {0x9909, 0xe94d}, {0x990a, 0x977b},
    {0x990c, 0x8961}, {0x9910, 0x8e60}, {0x9912, 0xe94e}, {0x9913, 0x89ec},
    {0x9914, 0xe94f}, {0x9918, 0xe950}, {0x991d, 0xe952}, {0x991e, 0xe953},
    {0x9920, 0xe955}, {0x9921, 0xe951}, {0x9924, 0xe954}, {0x9927, 0xfbf8},
    {0x9928, 0x8ad9}, {0x992c, 0xe956}, {0x992e, 0xe957}, {0x993d, 0xe958},
    {0x993e, 0xe959}, {0x9942, 0xe95a}, {0x9945, 0xe95c}, {0x9949, 0xe95b},
    {0x994b, 0xe95e}, {0x994c, 0xe961}, {0x9950, 0xe95d}, {0x9951, 0xe95f},
    {0x9952, 0xe960}, {0x9955, 0xe962}, {0x9957, 0x8bc0}, {0x9996, 0x8ef1},
    {0x9997, 0xe963}, {0x9998, 0xe964}, {0x9999, 0x8d81}, {0x999e, 0xfbfa},
    {0x99a5, 0xe965}, {0x99a8, 0x8a5d}, {0x99ac, 0x946e}, {0x99ad, 0xe966},
    {0x99ae, 0xe967}, {0x99b3, 0x9279}, {0x99b4, 0x93e9}, {0x99bc, 0xe968},
    {0x99c1, 0x949d}, {0x99c4, 0x91ca}, {0x99c5, 0x8977}, {0x99c6, 0x8bec},
    {0x99c8, 0x8bed}, {0x99d0, 0x9293}, {0x99d1, 0xe96d}, {0x99d2, 0x8bee},
    {0x99d5, 0x89ed}, {0x99d8, 0xe96c}, {0x99db, 0xe96a}, {0x99dd, 0xe96b},
    {0x99df, 0xe969}, {0x99e2, 0xe977}, {0x99ed, 0xe96e}, {0x99ee, 0xe96f},
    {0x99f1, 0xe970}, {0x99f2, 0xe971}, {0x99f8, 0xe973}, {0x99fb, 0xe972},
    {0x99ff, 0x8f78}, {0x9a01, 0xe974}, {0x9a05, 0xe976}, {0x9a0e, 0x8b52},
    {0x9a0f, 0xe975}, {0x9a12, 0x919b}, {0x9a13, 0x8cb1}, {0x9a19, 0xe978},
    {0x9a28, 0x91cb}, {0x9a2b, 0xe979}, {0x9a30, 0x93ab}, {0x9a37, 0xe97a},
    {0x9a3e, 0xe980}, {0x9a40, 0xe97d}, {0x9a42, 0xe97c}, {0x9a43, 0xe97e},
    {0x9a45, 0xe97b}, {0x9a4d, 0xe982}, {0x9a4e, 0xfbfb}, {0x9a52, 0x91cb},
    {0x9a55, 0xe981}, {0x9a57, 0xe984}, {0x9a5a, 0x8bc1}, {0x9a5b, 0xe983},
    {0x9a5f, 0xe985}, {0x9a62, 0xe986}, {0x9a64, 0xe988}, {0x9a65, 0xe987},
    {0x9a69, 0xe989}, {0x9a6a, 0xe98b}, {0x9a6b, 0xe98a}, {0x9aa8, 0x8d9c},
    {0x9aad, 0xe98c}, {0x9ab0, 0xe98d}, {0x9ab8, 0x8a5b}, {0x9abc, 0xe98e},
    {0x9ac0, 0xe98f}, {0x9ac4, 0x9091}, {0x9acf, 0xe990}, {0x9ad1, 0xe991},
    {0x9ad3, 0xe992}, {0x9ad4, 0xe993}, {0x9ad8, 0x8d82}, {0x9ad9, 0xfbfc},
    {0x9adc, 0xfc40}, {0x9ade, 0xe994}, {0x9adf, 0xe995}, {0x9ae2, 0xe996},
    {0x9ae3, 0xe997}, {0x9ae6, 0xe998}, {0x9aea, 0x94af}, {0x9aeb, 0xe99a},
    {0x9aed, 0x9545}, {0x9aee, 0xe99b}, {0x9aef, 0xe999}, {0x9af1, 0xe99d},
    {0x9af4, 0xe99c}, {0x9af7, 0xe99e}, {0x9afb, 0xe99f}, {0x9b06, 0xe9a0},
    {0x9b18, 0xe9a1}, {0x9b1a, 0xe9a2}, {0x9b1f, 0xe9a3}, {0x9b22, 0xe9a4},
    {0x9b23, 0xe9a5}, {0x9b25, 0xe9a6}, {0x9b27, 0xe9a7}, {0x9b28, 0xe9a8},
    {0x9b29, 0xe9a9}, {0x9b2a, 0xe9aa}, {0x9b2e, 0xe9ab}, {0x9b2f, 0xe9ac},
    {0x9b31, 0x9f54}, {0x9b32, 0xe9ad}, {0x9b3b, 0xe2f6}, {0x9b3c, 0x8b53},
    {0x9b41, 0x8a40}, {0x9b42, 0x8db0}, {0x9b43, 0xe9af}, {0x9b44, 0xe9ae},
    {0x9b45, 0x96a3}, {0x9b4d, 0xe9b1}, {0x9b4e, 0xe9b2}, {0x9b4f, 0xe9b0},
    {0x9b51, 0xe9b3}, {0x9b54, 0x9682}, {0x9b58, 0xe9b4}, {0x9b5a, 0x8b9b},
    {0x9b6f, 0x9844}, {0x9b72, 0xfc42}, {0x9b74, 0xe9b5}, {0x9b75, 0xfc41},
    {0x9b83, 0xe9b7}, {0x9b8e, 0x88bc}, {0x9b8f, 0xfc43}, {0x9b91, 0xe9b8},
    {0x9b92, 0x95a9}, {0x9b93, 0xe9b6}, {0x9b96, 0xe9b9}, {0x9b97, 0xe9ba},
    {0x9b9f, 0xe9bb}, {0x9ba0, 0xe9bc}, {0x9ba8, 0xe9bd}, {0x9baa, 0x968e},
    {0x9bab, 0x8e4c}, {0x9bad, 0x8df8}, {0x9bae, 0x914e}, {0x9bb1, 0xfc44},
    {0x9bb4, 0xe9be}, {0x9bb9, 0xe9c1}, {0x9bbb, 0xfc45}, {0x9bc0, 0xe9bf},
    {0x9bc6, 0xe9c2}, {0x9bc9, 0x8cef}, {0x9bca, 0xe9c0}, {0x9bcf, 0xe9c3},
    {0x9bd1, 0xe9c4}, {0x9bd2, 0xe9c5}, {0x9bd4, 0xe9c9}, {0x9bd6, 0x8e49},
    {0x9bdb, 0x91e2}, {0x9be1, 0xe9ca}, {0x9be2, 0xe9c7}, {0x9be3, 0xe9c6},
    {0x9be4, 0xe9c8}, {0x9be8, 0x8c7e}, {0x9bf0, 0xe9ce}, {0x9bf1, 0xe9cd},
    {0x9bf2, 0xe9cc}, {0x9bf5, 0x88b1}, {0x9c00, 0xfc46}, {0x9c04, 0xe9d8},
    {0x9c06, 0xe9d4}, {0x9c08, 0xe9d5}, {0x9c09, 0xe9d1}, {0x9c0a, 0xe9d7},
    {0x9c0c, 0xe9d3}, {0x9c0d, 0x8a82}, {0x9c10, 0x986b}, {0x9c12, 0xe9d6},
    {0x9c13, 0xe9d2}, {0x9c14, 0xe9d0}, {0x9c15, 0xe9cf}, {0x9c1b, 0xe9da},
    {0x9c21, 0xe9dd}, {0x9c24, 0xe9dc}, {0x9c25, 0xe9db}, {0x9c2d, 0x9568},
    {0x9c2e, 0xe9d9}, {0x9c2f, 0x88f1}, {0x9c30, 0xe9de}, {0x9c32, 0xe9e0},
    {0x9c39, 0x8a8f}, {0x9c3a, 0xe9cb}, {0x9c3b, 0x8956}, {0x9c3e, 0xe9e2},
    {0x9c46, 0xe9e1}, {0x9c47, 0xe9df}, {0x9c48, 0x924c}, {0x9c52, 0x9690},
    {0x9c57, 0x97d8}, {0x9c5a, 0xe9e3}, {0x9c60, 0xe9e4}, {0x9c67, 0xe9e5},
    {0x9c76, 0xe9e6}, {0x9c78, 0xe9e7}, {0x9ce5, 0x92b9}, {0x9ce7, 0xe9e8},
    {0x9ce9, 0x94b5}, {0x9ceb, 0xe9ed}, {0x9cec, 0xe9e9}, {0x9cf0, 0xe9ea},
    {0x9cf3, 0x9650}, {0x9cf4, 0x96c2}, {0x9cf6, 0x93ce}, {0x9d03, 0xe9ee},
    {0x9d06, 0xe9ef}, {0x9d07, 0x93bc}, {0x9d08, 0xe9ec}, {0x9d09, 0xe9eb},
    {0x9d0e, 0x89a8}, {0x9d12, 0xe9f7}, {0x9d15, 0xe9f6}, {0x9d1b, 0x8995},
    {0x9d1f, 0xe9f4}, {0x9d23, 0xe9f3}, {0x9d26, 0xe9f1}, {0x9d28, 0x8a9b},
    {0x9d2a, 0xe9f0}, {0x9d2b, 0x8eb0}, {0x9d2c, 0x89a7}, {0x9d3b, 0x8d83},
    {0x9d3e, 0xe9fa}, {0x9d3f, 0xe9f9}, {0x9d41, 0xe9f8}, {0x9d44, 0xe9f5},
    {0x9d46, 0xe9fb}, {0x9d48, 0xe9fc}, {0x9d50, 0xea44}, {0x9d51, 0xea43},
    {0x9d59, 0xea45}, {0x9d5c, 0x894c}, {0x9d5d, 0xea40}, {0x9d5e, 0xea41},
    {0x9d60, 0x8d94}, {0x9d61, 0x96b7}, {0x9d64, 0xea42}, {0x9d6b, 0xfc48},
    {0x9d6c, 0x9651}, {0x9d6f, 0xea4a}, {0x9d70, 0xfc47}, {0x9d72, 0xea46},
    {0x9d7a, 0xea4b}, {0x9d87, 0xea48}, {0x9d89, 0xea47}, {0x9d8f, 0x8c7b},
    {0x9d9a, 0xea4c}, {0x9da4, 0xea4d}, {0x9da9, 0xea4e}, {0x9dab, 0xea49},
    {0x9daf, 0xe9f2}, {0x9db2, 0xea4f}, {0x9db4, 0x92df}, {0x9db8, 0xea53},
    {0x9dba, 0xea54}, {0x9dbb, 0xea52}, {0x9dc1, 0xea51}, {0x9dc2, 0xea57},
    {0x9dc4, 0xea50}, {0x9dc6, 0xea55}, {0x9dcf, 0xea56}, {0x9dd3, 0xea59},
    {0x9dd7, 0x89a8}, {0x9dd9, 0xea58}, {0x9de6, 0xea5b}, {0x9ded, 0xea5c},
    {0x9def, 0xea5d}, {0x9df2, 0x9868}, {0x9df8, 0xea5a}, {0x9df9, 0x91e9},
    {0x9dfa, 0x8deb}, {0x9dfd, 0xea5e}, {0x9e19, 0xfc4a}, {0x9e1a, 0xea5f},
    {0x9e1b, 0xea60}, {0x9e1e, 0xea61}, {0x9e75, 0xea62}, {0x9e78, 0x8cb2},
    {0x9e79, 0xea63}, {0x9e7c, 0x8cb2}, {0x9e7d, 0xea64}, {0x9e7f, 0x8ead},
    {0x9e81, 0xea65}, {0x9e88, 0xea66}, {0x9e8b, 0xea67}, {0x9e8c, 0xea68},
    {0x9e91, 0xea6b}, {0x9e92, 0xea69}, {0x9e93, 0x985b}, {0x9e95, 0xea6a},
    {0x9e97, 0x97ed}, {0x9e9d, 0xea6c}, {0x9e9f, 0x97d9}, {0x9ea5, 0xea6d},
    {0x9ea6, 0x949e}, {0x9ea9, 0xea6e}, {0x9eaa, 0xea70}, {0x9ead, 0xea71},
    {0x9eb4, 0x8d8d}, {0x9eb5, 0x96cb}, {0x9eb8, 0xea6f}, {0x9eb9, 0x8d8d},
    {0x9eba, 0x96cb}, {0x9ebb, 0x9683}, {0x9ebc, 0x9bf5}, {0x9ebe, 0x9f80},
    {0x9ebf, 0x969b}, {0x9ec4, 0x89a9}, {0x9ecc, 0xea73}, {0x9ecd, 0x8b6f},
    {0x9ece, 0xea74}, {0x9ecf, 0xea75}, {0x9ed0, 0xea76}, {0x9ed1, 0xfc4b},
    {0x9ed2, 0x8d95}, {0x9ed4, 0xea77}, {0x9ed8, 0xe0d2}, {0x9ed9, 0x96d9},
    {0x9edb, 0x91e1}, {0x9edc, 0xea78}, {0x9edd, 0xea7a}, {0x9ede, 0xea79},
    {0x9ee0, 0xea7b}, {0x9ee5, 0xea7c}, {0x9ee8, 0xea7d}, {0x9eef, 0xea7e},
    {0x9ef4, 0xea80}, {0x9ef6, 0xea81}, {0x9ef7, 0xea82}, {0x9ef9, 0xea83},
    {0x9efb, 0xea84}, {0x9efc, 0xea85}, {0x9efd, 0xea86}, {0x9f07, 0xea87},
    {0x9f08, 0xea88}, {0x9f0e, 0x9343}, {0x9f13, 0x8cdb}, {0x9f15, 0xea8a},
    {0x9f20, 0x916c}, {0x9f21, 0xea8b}, {0x9f2c, 0xea8c}, {0x9f3b, 0x9540},
    {0x9f3e, 0xea8d}, {0x9f4a, 0xea8e}, {0x9f4b, 0xe256}, {0x9f4e, 0xe6d8},
    {0x9f4f, 0xe8eb}, {0x9f52, 0xea8f}, {0x9f54, 0xea90}, {0x9f5f, 0xea92},
    {0x9f60, 0xea93}, {0x9f61, 0xea94}, {0x9f62, 0x97ee}, {0x9f63, 0xea91},
    {0x9f66, 0xea95}, {0x9f67, 0xea96}, {0x9f6a, 0xea98}, {0x9f6c, 0xea97},
    {0x9f72, 0xea9a}, {0x9f76, 0xea9b}, {0x9f77, 0xea99}, {0x9f8d, 0x97b4},
    {0x9f95, 0xea9c}, {0x9f9c, 0xea9d}, {0x9f9d, 0xe273}, {0x9fa0, 0xea9e},
    {0xe000, 0xf040}, {0xe001, 0xf041}, {0xe002, 0xf042}, {0xe003, 0xf043},
    {0xe004, 0xf044}, {0xe005, 0xf045}, {0xe006, 0xf046}, {0xe007, 0xf047},
    {0xe008, 0xf048}, {0xe009, 0xf049}, {0xe00a, 0xf04a}, {0xe00b, 0xf04b},
    {0xe00c, 0xf04c}, {0xe00d, 0xf04d}, {0xe00e, 0xf04e}, {0xe00f, 0xf04f},
    {0xe010, 0xf050}, {0xe011, 0xf051}, {0xe012, 0xf052}, {0xe013, 0xf053},
    {0xe014, 0xf054}, {0xe015, 0xf055}, {0xe016, 0xf056}, {0xe017, 0xf057},
    {0xe018, 0xf058}, {0xe019, 0xf059}, {0xe01a, 0xf05a}, {0xe01b, 0xf05b},
    {0xe01c, 0xf05c}, {0xe01d, 0xf05d}, {0xe01e, 0xf05e}, {0xe01f, 0xf05f},
    {0xe020, 0xf060}, {0xe021, 0xf061}, {0xe022, 0xf062}, {0xe023, 0xf063},
    {0xe024, 0xf064}, {0xe025, 0xf065}, {0xe026, 0xf066}, {0xe027, 0xf067},
    {0xe028, 0xf068}, {0xe029, 0xf069}, {0xe02a, 0xf06a}, {0xe02b, 0xf06b},
    {0xe02c, 0xf06c}, {0xe02d, 0xf06d}, {0xe02e, 0xf06e}, {0xe02f, 0xf06f},
    {0xe030, 0xf070}, {0xe031, 0xf071}, {0xe032, 0xf072}, {0xe033, 0xf073},
    {0xe034, 0xf074}, {0xe035, 0xf075}, {0xe036, 0xf076}, {0xe037, 0xf077},
    {0xe038, 0xf078}, {0xe039, 0xf079}, {0xe03a, 0xf07a}, {0xe03b, 0xf07b},
    {0xe03c, 0xf07c}, {0xe03d, 0xf07d}, {0xe03e, 0xf07e}, {0xe03f, 0xf080},
    {0xe040, 0xf081}, {0xe041, 0xf082}, {0xe042, 0xf083}, {0xe043, 0xf084},
    {0xe044, 0xf085}, {0xe045, 0xf086}, {0xe046, 0xf087}, {0xe047, 0xf088},
    {0xe048, 0xf089}, {0xe049, 0xf08a}, {0xe04a, 0xf08b}, {0xe04b, 0xf08c},
    {0xe04c, 0xf08d}, {0xe04d, 0xf08e}, {0xe04e, 0xf08f}, {0xe04f, 0xf090},
    {0xe050, 0xf091}, {0xe051, 0xf092}, {0xe052, 0xf093}, {0xe053, 0xf094},
    {0xe054, 0xf095}, {0xe055, 0xf096}, {0xe056, 0xf097}, {0xe057, 0xf098},
    {0xe058, 0xf099}, {0xe059, 0xf09a}, {0xe05a, 0xf09b}, {0xe05b, 0xf09c},
    {0xe05c, 0xf09d}, {0xe05d, 0xf09e}, {0xe05e, 0xf09f}, {0xe05f, 0xf0a0},
    {0xe060, 0xf0a1}, {0xe061, 0xf0a2}, {0xe062, 0xf0a3}, {0xe063, 0xf0a4},
    {0xe064, 0xf0a5}, {0xe065, 0xf0a6}, {0xe066, 0xf0a7}, {0xe067, 0xf0a8},
    {0xe068, 0xf0a9}, {0xe069, 0xf0aa}, {0xe06a, 0xf0ab}, {0xe06b, 0xf0ac},
    {0xe06c, 0xf0ad}, {0xe06d, 0xf0ae}, {0xe06e, 0xf0af}, {0xe06f, 0xf0b0},
    {0xe070, 0xf0b1}, {0xe071, 0xf0b2}, {0xe072, 0xf0b3}, {0xe073, 0xf0b4},
    {0xe074, 0xf0b5}, {0xe075, 0xf0b6}, {0xe076, 0xf0b7}, {0xe077, 0xf0b8},
    {0xe078, 0xf0b9}, {0xe079, 0xf0ba}, {0xe07a, 0xf0bb}, {0xe07b, 0xf0bc},
    {0xe07c, 0xf0bd}, {0xe07d, 0xf0be}, {0xe07e, 0xf0bf}, {0xe07f, 0xf0c0},
    {0xe080, 0xf0c1}, {0xe081, 0xf0c2}, {0xe082, 0xf0c3}, {0xe083, 0xf0c4},
    {0xe084, 0xf0c5}, {0xe085, 0xf0c6}, {0xe086, 0xf0c7}, {0xe087, 0xf0c8},
    {0xe088, 0xf0c9}, {0xe089, 0xf0ca}, {0xe08a, 0xf0cb}, {0xe08b, 0xf0cc},
    {0xe08c, 0xf0cd}, {0xe08d, 0xf0ce}, {0xe08e, 0xf0cf}, {0xe08f, 0xf0d0},
    {0xe090, 0xf0d1}, {0xe091, 0xf0d2}, {0xe092, 0xf0d3}, {0xe093, 0xf0d4},
    {0xe094, 0xf0d5}, {0xe095, 0xf0d6}, {0xe096, 0xf0d7}, {0xe097, 0xf0d8},
    {0xe098, 0xf0d9}, {0xe099, 0xf0da}, {0xe09a, 0xf0db}, {0xe09b, 0xf0dc},
    {0xe09c, 0xf0dd}, {0xe09d, 0xf0de}, {0xe09e, 0xf0df}, {0xe09f, 0xf0e0},
    {0xe0a0, 0xf0e1}, {0xe0a1, 0xf0e2}, {0xe0a2, 0xf0e3}, {0xe0a3, 0xf0e4},
    {0xe0a4, 0xf0e5}, {0xe0a5, 0xf0e6}, {0xe0a6, 0xf0e7}, {0xe0a7, 0xf0e8},
    {0xe0a8, 0xf0e9}, {0xe0a9, 0xf0ea}, {0xe0aa, 0xf0eb}, {0xe0ab, 0xf0ec},
    {0xe0ac, 0xf0ed}, {0xe0ad, 0xf0ee}, {0xe0ae, 0xf0ef}, {0xe0af, 0xf0f0},
    {0xe0b0, 0xf0f1}, {0xe0b1, 0xf0f2}, {0xe0b2, 0xf0f3}, {0xe0b3, 0xf0f4},
    {0xe0b4, 0xf0f5}, {0xe0b5, 0xf0f6}, {0xe0b6, 0xf0f7}, {0xe0b7, 0xf0f8},
    {0xe0b8, 0xf0f9}, {0xe0b9, 0xf0fa}, {0xe0ba, 0xf0fb}, {0xe0bb, 0xf0fc},
    {0xe0bc, 0xf140}, {0xe0bd, 0xf141}, {0xe0be, 0xf142}, {0xe0bf, 0xf143},
    {0xe0c0, 0xf144}, {0xe0c1, 0xf145}, {0xe0c2, 0xf146}, {0xe0c3, 0xf147},
    {0xe0c4, 0xf148}, {0xe0c5, 0xf149}, {0xe0c6, 0xf14a}, {0xe0c7, 0xf14b},
    {0xe0c8, 0xf14c}, {0xe0c9, 0xf14d}, {0xe0ca, 0xf14e}, {0xe0cb, 0xf14f},
    {0xe0cc, 0xf150}, {0xe0cd, 0xf151}, {0xe0ce, 0xf152}, {0xe0cf, 0xf153},
    {0xe0d0, 0xf154}, {0xe0d1, 0xf155}, {0xe0d2, 0xf156}, {0xe0d3, 0xf157},
    {0xe0d4, 0xf158}, {0xe0d5, 0xf159}, {0xe0d6, 0xf15a}, {0xe0d7, 0xf15b},
    {0xe0d8, 0xf15c}, {0xe0d9, 0xf15d}, {0xe0da, 0xf15e}, {0xe0db, 0xf15f},
    {0xe0dc, 0xf160}, {0xe0dd, 0xf161}, {0xe0de, 0xf162}, {0xe0df, 0xf163},
    {0xe0e0, 0xf164}, {0xe0e1, 0xf165}, {0xe0e2, 0xf166}, {0xe0e3, 0xf167},
    {0xe0e4, 0xf168}, {0xe0e5, 0xf169}, {0xe0e6, 0xf16a}, {0xe0e7, 0xf16b},
    {0xe0e8, 0xf16c}, {0xe0e9, 0xf16d}, {0xe0ea, 0xf16e}, {0xe0eb, 0xf16f},
    {0xe0ec, 0xf170}, {0xe0ed, 0xf171}, {0xe0ee, 0xf172}, {0xe0ef, 0xf173},
    {0xe0f0, 0xf174}, {0xe0f1, 0xf175}, {0xe0f2, 0xf176}, {0xe0f3, 0xf177},
    {0xe0f4, 0xf178}, {0xe0f5, 0xf179}, {0xe0f6, 0xf17a}, {0xe0f7, 0xf17b},
    {0xe0f8, 0xf17c}, {0xe0f9, 0xf17d}, {0xe0fa, 0xf17e}, {0xe0fb, 0xf180},
    {0xe0fc, 0xf181}, {0xe0fd, 0xf182}, {0xe0fe, 0xf183}, {0xe0ff, 0xf184},
    {0xe100, 0xf185}, {0xe101, 0xf186}, {0xe102, 0xf187}, {0xe103, 0xf188},
    {0xe104, 0xf189}, {0xe105, 0xf18a}, {0xe106, 0xf18b}, {0xe107, 0xf18c},
    {0xe108, 0xf18d}, {0xe109, 0xf18e}, {0xe10a, 0xf18f}, {0xe10b, 0xf190},
    {0xe10c, 0xf191}, {0xe10d, 0xf192}, {0xe10e, 0xf193}, {0xe10f, 0xf194},
    {0xe110, 0xf195}, {0xe111, 0xf196}, {0xe112, 0xf197}, {0xe113, 0xf198},
    {0xe114, 0xf199}, {0xe115, 0xf19a}, {0xe116, 0xf19b}, {0xe117, 0xf19c},
    {0xe118, 0xf19d}, {0xe119, 0xf19e}, {0xe11a, 0xf19f}, {0xe11b, 0xf1a0},
    {0xe11c, 0xf1a1}, {0xe11d, 0xf1a2}, {0xe11e, 0xf1a3}, {0xe11f, 0xf1a4},
    {0xe120, 0xf1a5}, {0xe121, 0xf1a6}, {0xe122, 0xf1a7}, {0xe123, 0xf1a8},
    {0xe124, 0xf1a9}, {0xe125, 0xf1aa}, {0xe126, 0xf1ab}, {0xe127, 0xf1ac},
    {0xe128, 0xf1ad}, {0xe129, 0xf1ae}, {0xe12a, 0xf1af}, {0xe12b, 0xf1b0},
    {0xe12c, 0xf1b1}, {0xe12d, 0xf1b2}, {0xe12e, 0xf1b3}, {0xe12f, 0xf1b4},
    {0xe130, 0xf1b5}, {0xe131, 0xf1b6}, {0xe132, 0xf1b7}, {0xe133, 0xf1b8},
    {0xe134, 0xf1b9}, {0xe135, 0xf1ba}, {0xe136, 0xf1bb}, {0xe137, 0xf1bc},
    {0xe138, 0xf1bd}, {0xe139, 0xf1be}, {0xe13a, 0xf1bf}, {0xe13b, 0xf1c0},
    {0xe13c, 0xf1c1}, {0xe13d, 0xf1c2}, {0xe13e, 0xf1c3}, {0xe13f, 0xf1c4},
    {0xe140, 0xf1c5}, {0xe141, 0xf1c6}, {0xe142, 0xf1c7}, {0xe143, 0xf1c8},
    {0xe144, 0xf1c9}, {0xe145, 0xf1ca}, {0xe146, 0xf1cb}, {0xe147, 0xf1cc},
    {0xe148, 0xf1cd}, {0xe149, 0xf1ce}, {0xe14a, 0xf1cf}, {0xe14b, 0xf1d0},
    {0xe14c, 0xf1d1}, {0xe14d, 0xf1d2}, {0xe14e, 0xf1d3}, {0xe14f, 0xf1d4},
    {0xe150, 0xf1d5}, {0xe151, 0xf1d6}, {0xe152, 0xf1d7}, {0xe153, 0xf1d8},
    {0xe154, 0xf1d9}, {0xe155, 0xf1da}, {0xe156, 0xf1db}, {0xe157, 0xf1dc},
    {0xe158, 0xf1dd}, {0xe159, 0xf1de}, {0xe15a, 0xf1df}, {0xe15b, 0xf1e0},
    {0xe15c, 0xf1e1}, {0xe15d, 0xf1e2}, {0xe15e, 0xf1e3}, {0xe15f, 0xf1e4},
    {0xe160, 0xf1e5}, {0xe161, 0xf1e6}, {0xe162, 0xf1e7}, {0xe163, 0xf1e8},
    {0xe164, 0xf1e9}, {0xe165, 0xf1ea}, {0xe166, 0xf1eb}, {0xe167, 0xf1ec},
    {0xe168, 0xf1ed}, {0xe169, 0xf1ee}, {0xe16a, 0xf1ef}, {0xe16b, 0xf1f0},
    {0xe16c, 0xf1f1}, {0xe16d, 0xf1f2}, {0xe16e, 0xf1f3}, {0xe16f, 0xf1f4},
    {0xe170, 0xf1f5}, {0xe171, 0xf1f6}, {0xe172, 0xf1f7}, {0xe173, 0xf1f8},
    {0xe174, 0xf1f9}, {0xe175, 0xf1fa}, {0xe176, 0xf1fb}, {0xe177, 0xf1fc},
    {0xe178, 0xf240}, {0xe179, 0xf241}, {0xe17a, 0xf242}, {0xe17b, 0xf243},
    {0xe17c, 0xf244}, {0xe17d, 0xf245}, {0xe17e, 0xf246}, {0xe17f, 0xf247},
    {0xe180, 0xf248}, {0xe181, 0xf249}, {0xe182, 0xf24a}, {0xe183, 0xf24b},
    {0xe184, 0xf24c}, {0xe185, 0xf24d}, {0xe186, 0xf24e}, {0xe187, 0xf24f},
    {0xe188, 0xf250}, {0xe189, 0xf251}, {0xe18a, 0xf252}, {0xe18b, 0xf253},
    {0xe18c, 0xf254}, {0xe18d, 0xf255}, {0xe18e, 0xf256}, {0xe18f, 0xf257},
    {0xe190, 0xf258}, {0xe191, 0xf259}, {0xe192, 0xf25a}, {0xe193, 0xf25b},
    {0xe194, 0xf25c}, {0xe195, 0xf25d}, {0xe196, 0xf25e}, {0xe197, 0xf25f},
    {0xe198, 0xf260}, {0xe199, 0xf261}, {0xe19a, 0xf262}, {0xe19b, 0xf263},
    {0xe19c, 0xf264}, {0xe19d, 0xf265}, {0xe19e, 0xf266}, {0xe19f, 0xf267},
    {0xe1a0, 0xf268}, {0xe1a1, 0xf269}, {0xe1a2, 0xf26a}, {0xe1a3, 0xf26b},
    {0xe1a4, 0xf26c}, {0xe1a5, 0xf26d}, {0xe1a6, 0xf26e}, {0xe1a7, 0xf26f},
    {0xe1a8, 0xf270}, {0xe1a9, 0xf271}, {0xe1aa, 0xf272}, {0xe1ab, 0xf273},
    {0xe1ac, 0xf274}, {0xe1ad, 0xf275}, {0xe1ae, 0xf276}, {0xe1af, 0xf277},
    {0xe1b0, 0xf278}, {0xe1b1, 0xf279}, {0xe1b2, 0xf27a}, {0xe1b3, 0xf27b},
    {0xe1b4, 0xf27c}, {0xe1b5, 0xf27d}, {0xe1b6, 0xf27e}, {0xe1b7, 0xf280},
    {0xe1b8, 0xf281}, {0xe1b9, 0xf282}, {0xe1ba, 0xf283}, {0xe1bb, 0xf284},
    {0xe1bc, 0xf285}, {0xe1bd, 0xf286}, {0xe1be, 0xf287}, {0xe1bf, 0xf288},
    {0xe1c0, 0xf289}, {0xe1c1, 0xf28a}, {0xe1c2, 0xf28b}, {0xe1c3, 0xf28c},
    {0xe1c4, 0xf28d}, {0xe1c5, 0xf28e}, {0xe1c6, 0xf28f}, {0xe1c7, 0xf290},
    {0xe1c8, 0xf291}, {0xe1c9, 0xf292}, {0xe1ca, 0xf293}, {0xe1cb, 0xf294},
    {0xe1cc, 0xf295}, {0xe1cd, 0xf296}, {0xe1ce, 0xf297}, {0xe1cf, 0xf298},
    {0xe1d0, 0xf299}, {0xe1d1, 0xf29a}, {0xe1d2, 0xf29b}, {0xe1d3, 0xf29c},
    {0xe1d4, 0xf29d}, {0xe1d5, 0xf29e}, {0xe1d6, 0xf29f}, {0xe1d7, 0xf2a0},
    {0xe1d8, 0xf2a1}, {0xe1d9, 0xf2a2}, {0xe1da, 0xf2a3}, {0xe1db, 0xf2a4},
    {0xe1dc, 0xf2a5}, {0xe1dd, 0xf2a6}, {0xe1de, 0xf2a7}, {0xe1df, 0xf2a8},
    {0xe1e0, 0xf2a9}, {0xe1e1, 0xf2aa}, {0xe1e2, 0xf2ab}, {0xe1e3, 0xf2ac},
    {0xe1e4, 0xf2ad}, {0xe1e5, 0xf2ae}, {0xe1e6, 0xf2af}, {0xe1e7, 0xf2b0},
    {0xe1e8, 0xf2b1}, {0xe1e9, 0xf2b2}, {0xe1ea, 0xf2b3}, {0xe1eb, 0xf2b4},
    {0xe1ec, 0xf2b5}, {0xe1ed, 0xf2b6}, {0xe1ee, 0xf2b7}, {0xe1ef, 0xf2b8},
    {0xe1f0, 0xf2b9}, {0xe1f1, 0xf2ba}, {0xe1f2, 0xf2bb}, {0xe1f3, 0xf2bc},
    {0xe1f4, 0xf2bd}, {0xe1f5, 0xf2be}, {0xe1f6, 0xf2bf}, {0xe1f7, 0xf2c0},
    {0xe1f8, 0xf2c1}, {0xe1f9, 0xf2c2}, {0xe1fa, 0xf2c3}, {0xe1fb, 0xf2c4},
    {0xe1fc, 0xf2c5}, {0xe1fd, 0xf2c6}, {0xe1fe, 0xf2c7}, {0xe1ff, 0xf2c8},
    {0xe200, 0xf2c9}, {0xe201, 0xf2ca}, {0xe202, 0xf2cb}, {0xe203, 0xf2cc},
    {0xe204, 0xf2cd}, {0xe205, 0xf2ce}, {0xe206, 0xf2cf}, {0xe207, 0xf2d0},
    {0xe208, 0xf2d1}, {0xe209, 0xf2d2}, {0xe20a, 0xf2d3}, {0xe20b, 0xf2d4},
    {0xe20c, 0xf2d5}, {0xe20d, 0xf2d6}, {0xe20e, 0xf2d7}, {0xe20f, 0xf2d8},
    {0xe210, 0xf2d9}, {0xe211, 0xf2da}, {0xe212, 0xf2db}, {0xe213, 0xf2dc},
    {0xe214, 0xf2dd}, {0xe215, 0xf2de}, {0xe216, 0xf2df}, {0xe217, 0xf2e0},
    {0xe218, 0xf2e1}, {0xe219, 0xf2e2}, {0xe21a, 0xf2e3}, {0xe21b, 0xf2e4},
    {0xe21c, 0xf2e5}, {0xe21d, 0xf2e6}, {0xe21e, 0xf2e7}, {0xe21f, 0xf2e8},
    {0xe220, 0xf2e9}, {0xe221, 0xf2ea}, {0xe222, 0xf2eb}, {0xe223, 0xf2ec},
    {0xe224, 0xf2ed}, {0xe225, 0xf2ee}, {0xe226, 0xf2ef}, {0xe227, 0xf2f0},
    {0xe228, 0xf2f1}, {0xe229, 0xf2f2}, {0xe22a, 0xf2f3}, {0xe22b, 0xf2f4},
    {0xe22c, 0xf2f5}, {0xe22d, 0xf2f6}, {0xe22e, 0xf2f7}, {0xe22f, 0xf2f8},
    {0xe230, 0xf2f9}, {0xe231, 0xf2fa}, {0xe232, 0xf2fb}, {0xe233, 0xf2fc},
    {0xe234, 0xf340}, {0xe235, 0xf341}, {0xe236, 0xf342}, {0xe237, 0xf343},
    {0xe238, 0xf344}, {0xe239, 0xf345}, {0xe23a, 0xf346}, {0xe23b, 0xf347},
    {0xe23c, 0xf348}, {0xe23d, 0xf349}, {0xe23e, 0xf34a}, {0xe23f, 0xf34b},
    {0xe240, 0xf34c}, {0xe241, 0xf34d}, {0xe242, 0xf34e}, {0xe243, 0xf34f},
    {0xe244, 0xf350}, {0xe245, 0xf351}, {0xe246, 0xf352}, {0xe247, 0xf353},
    {0xe248, 0xf354}, {0xe249, 0xf355}, {0xe24a, 0xf356}, {0xe24b, 0xf357},
    {0xe24c, 0xf358}, {0xe24d, 0xf359}, {0xe24e, 0xf35a}, {0xe24f, 0xf35b},
    {0xe250, 0xf35c}, {0xe251, 0xf35d}, {0xe252, 0xf35e}, {0xe253, 0xf35f},
    {0xe254, 0xf360}, {0xe255, 0xf361}, {0xe256, 0xf362}, {0xe257, 0xf363},
    {0xe258, 0xf364}, {0xe259, 0xf365}, {0xe25a, 0xf366}, {0xe25b, 0xf367},
    {0xe25c, 0xf368}, {0xe25d, 0xf369}, {0xe25e, 0xf36a}, {0xe25f, 0xf36b},
    {0xe260, 0xf36c}, {0xe261, 0xf36d}, {0xe262, 0xf36e}, {0xe263, 0xf36f},
    {0xe264, 0xf370}, {0xe265, 0xf371}, {0xe266, 0xf372}, {0xe267, 0xf373},
    {0xe268, 0xf374}, {0xe269, 0xf375}, {0xe26a, 0xf376}, {0xe26b, 0xf377},
    {0xe26c, 0xf378}, {0xe26d, 0xf379}, {0xe26e, 0xf37a}, {0xe26f, 0xf37b},
    {0xe270, 0xf37c}, {0xe271, 0xf37d}, {0xe272, 0xf37e}, {0xe273, 0xf380},
    {0xe274, 0xf381}, {0xe275, 0xf382}, {0xe276, 0xf383}, {0xe277, 0xf384},
    {0xe278, 0xf385}, {0xe279, 0xf386}, {0xe27a, 0xf387}, {0xe27b, 0xf388},
    {0xe27c, 0xf389}, {0xe27d, 0xf38a}, {0xe27e, 0xf38b}, {0xe27f, 0xf38c},
    {0xe280, 0xf38d}, {0xe281, 0xf38e}, {0xe282, 0xf38f}, {0xe283, 0xf390},
    {0xe284, 0xf391}, {0xe285, 0xf392}, {0xe286, 0xf393}, {0xe287, 0xf394},
    {0xe288, 0xf395}, {0xe289, 0xf396}, {0xe28a, 0xf397}, {0xe28b, 0xf398},
    {0xe28c, 0xf399}, {0xe28d, 0xf39a}, {0xe28e, 0xf39b}, {0xe28f, 0xf39c},
    {0xe290, 0xf39d}, {0xe291, 0xf39e}, {0xe292, 0xf39f}, {0xe293, 0xf3a0},
    {0xe294, 0xf3a1}, {0xe295, 0xf3a2}, {0xe296, 0xf3a3}, {0xe297, 0xf3a4},
    {0xe298, 0xf3a5}, {0xe299, 0xf3a6}, {0xe29a, 0xf3a7}, {0xe29b, 0xf3a8},
    {0xe29c, 0xf3a9}, {0xe29d, 0xf3aa}, {0xe29e, 0xf3ab}, {0xe29f, 0xf3ac},
    {0xe2a0, 0xf3ad}, {0xe2a1, 0xf3ae}, {0xe2a2, 0xf3af}, {0xe2a3, 0xf3b0},
    {0xe2a4, 0xf3b1}, {0xe2a5, 0xf3b2}, {0xe2a6, 0xf3b3}, {0xe2a7, 0xf3b4},
    {0xe2a8, 0xf3b5}, {0xe2a9, 0xf3b6}, {0xe2aa, 0xf3b7}, {0xe2ab, 0xf3b8},
    {0xe2ac, 0xf3b9}, {0xe2ad, 0xf3ba}, {0xe2ae, 0xf3bb}, {0xe2af, 0xf3bc},
    {0xe2b0, 0xf3bd}, {0xe2b1, 0xf3be}, {0xe2b2, 0xf3bf}, {0xe2b3, 0xf3c0},
    {0xe2b4, 0xf3c1}, {0xe2b5, 0xf3c2}, {0xe2b6, 0xf3c3}, {0xe2b7, 0xf3c4},
    {0xe2b8, 0xf3c5}, {0xe2b9, 0xf3c6}, {0xe2ba, 0xf3c7}, {0xe2bb, 0xf3c8},
    {0xe2bc, 0xf3c9}, {0xe2bd, 0xf3ca}, {0xe2be, 0xf3cb}, {0xe2bf, 0xf3cc},
    {0xe2c0, 0xf3cd}, {0xe2c1, 0xf3ce}, {0xe2c2, 0xf3cf}, {0xe2c3, 0xf3d0},
    {0xe2c4, 0xf3d1}, {0xe2c5, 0xf3d2}, {0xe2c6, 0xf3d3}, {0xe2c7, 0xf3d4},
    {0xe2c8, 0xf3d5}, {0xe2c9, 0xf3d6}, {0xe2ca, 0xf3d7}, {0xe2cb, 0xf3d8},
    {0xe2cc, 0xf3d9}, {0xe2cd, 0xf3da}, {0xe2ce, 0xf3db}, {0xe2cf, 0xf3dc},
    {0xe2d0, 0xf3dd}, {0xe2d1, 0xf3de}, {0xe2d2, 0xf3df}, {0xe2d3, 0xf3e0},
    {0xe2d4, 0xf3e1}, {0xe2d5, 0xf3e2}, {0xe2d6, 0xf3e3}, {0xe2d7, 0xf3e4},
    {0xe2d8, 0xf3e5}, {0xe2d9, 0xf3e6}, {0xe2da, 0xf3e7}, {0xe2db, 0xf3e8},
    {0xe2dc, 0xf3e9}, {0xe2dd, 0xf3ea}, {0xe2de, 0xf3eb}, {0xe2df, 0xf3ec},
    {0xe2e0, 0xf3ed}, {0xe2e1, 0xf3ee}, {0xe2e2, 0xf3ef}, {0xe2e3, 0xf3f0},
    {0xe2e4, 0xf3f1}, {0xe2e5, 0xf3f2}, {0xe2e6, 0xf3f3}, {0xe2e7, 0xf3f4},
    {0xe2e8, 0xf3f5}, {0xe2e9, 0xf3f6}, {0xe2ea, 0xf3f7}, {0xe2eb, 0xf3f8},
    {0xe2ec, 0xf3f9}, {0xe2ed, 0xf3fa}, {0xe2ee, 0xf3fb}, {0xe2ef, 0xf3fc},
    {0xe2f0, 0xf440}, {0xe2f1, 0xf441}, {0xe2f2, 0xf442}, {0xe2f3, 0xf443},
    {0xe2f4, 0xf444}, {0xe2f5, 0xf445}, {0xe2f6, 0xf446}, {0xe2f7, 0xf447},
    {0xe2f8, 0xf448}, {0xe2f9, 0xf449}, {0xe2fa, 0xf44a}, {0xe2fb, 0xf44b},
    {0xe2fc, 0xf44c}, {0xe2fd, 0xf44d}, {0xe2fe, 0xf44e}, {0xe2ff, 0xf44f},
    {0xe300, 0xf450}, {0xe301, 0xf451}, {0xe302, 0xf452}, {0xe303, 0xf453},
    {0xe304, 0xf454}, {0xe305, 0xf455}, {0xe306, 0xf456}, {0xe307, 0xf457},
    {0xe308, 0xf458}, {0xe309, 0xf459}, {0xe30a, 0xf45a}, {0xe30b, 0xf45b},
    {0xe30c, 0xf45c}, {0xe30d, 0xf45d}, {0xe30e, 0xf45e}, {0xe30f, 0xf45f},
    {0xe310, 0xf460}, {0xe311, 0xf461}, {0xe312, 0xf462}, {0xe313, 0xf463},
    {0xe314, 0xf464}, {0xe315, 0xf465}, {0xe316, 0xf466}, {0xe317, 0xf467},
    {0xe318, 0xf468}, {0xe319, 0xf469}, {0xe31a, 0xf46a}, {0xe31b, 0xf46b},
    {0xe31c, 0xf46c}, {0xe31d, 0xf46d}, {0xe31e, 0xf46e}, {0xe31f, 0xf46f},
    {0xe320, 0xf470}, {0xe321, 0xf471}, {0xe322, 0xf472}, {0xe323, 0xf473},
    {0xe324, 0xf474}, {0xe325, 0xf475}, {0xe326, 0xf476}, {0xe327, 0xf477},
    {0xe328, 0xf478}, {0xe329, 0xf479}, {0xe32a, 0xf47a}, {0xe32b, 0xf47b},
    {0xe32c, 0xf47c}, {0xe32d, 0xf47d}, {0xe32e, 0xf47e}, {0xe32f, 0xf480},
    {0xe330, 0xf481}, {0xe331, 0xf482}, {0xe332, 0xf483}, {0xe333, 0xf484},
    {0xe334, 0xf485}, {0xe335, 0xf486}, {0xe336, 0xf487}, {0xe337, 0xf488},
    {0xe338, 0xf489}, {0xe339, 0xf48a}, {0xe33a, 0xf48b}, {0xe33b, 0xf48c},
    {0xe33c, 0xf48d}, {0xe33d, 0xf48e}, {0xe33e, 0xf48f}, {0xe33f, 0xf490},
    {0xe340, 0xf491}, {0xe341, 0xf492}, {0xe342, 0xf493}, {0xe343, 0xf494},
    {0xe344, 0xf495}, {0xe345, 0xf496}, {0xe346, 0xf497}, {0xe347, 0xf498},
    {0xe348, 0xf499}, {0xe349, 0xf49a}, {0xe34a, 0xf49b}, {0xe34b, 0xf49c},
    {0xe34c, 0xf49d}, {0xe34d, 0xf49e}, {0xe34e, 0xf49f}, {0xe34f, 0xf4a0},
    {0xe350, 0xf4a1}, {0xe351, 0xf4a2}, {0xe352, 0xf4a3}, {0xe353, 0xf4a4},
    {0xe354, 0xf4a5}, {0xe355, 0xf4a6}, {0xe356, 0xf4a7}, {0xe357, 0xf4a8},
    {0xe358, 0xf4a9}, {0xe359, 0xf4aa}, {0xe35a, 0xf4ab}, {0xe35b, 0xf4ac},
    {0xe35c, 0xf4ad}, {0xe35d, 0xf4ae}, {0xe35e, 0xf4af}, {0xe35f, 0xf4b0},
    {0xe360, 0xf4b1}, {0xe361, 0xf4b2}, {0xe362, 0xf4b3}, {0xe363, 0xf4b4},
    {0xe364, 0xf4b5}, {0xe365, 0xf4b6}, {0xe366, 0xf4b7}, {0xe367, 0xf4b8},
    {0xe368, 0xf4b9}, {0xe369, 0xf4ba}, {0xe36a, 0xf4bb}, {0xe36b, 0xf4bc},
    {0xe36c, 0xf4bd}, {0xe36d, 0xf4be}, {0xe36e, 0xf4bf}, {0xe36f, 0xf4c0},
    {0xe370, 0xf4c1}, {0xe371, 0xf4c2}, {0xe372, 0xf4c3}, {0xe373, 0xf4c4},
    {0xe374, 0xf4c5}, {0xe375, 0xf4c6}, {0xe376, 0xf4c7}, {0xe377, 0xf4c8},
    {0xe378, 0xf4c9}, {0xe379, 0xf4ca}, {0xe37a, 0xf4cb}, {0xe37b, 0xf4cc},
    {0xe37c, 0xf4cd}, {0xe37d, 0xf4ce}, {0xe37e, 0xf4cf}, {0xe37f, 0xf4d0},
    {0xe380, 0xf4d1}, {0xe381, 0xf4d2}, {0xe382, 0xf4d3}, {0xe383, 0xf4d4},
    {0xe384, 0xf4d5}, {0xe385, 0xf4d6}, {0xe386, 0xf4d7}, {0xe387, 0xf4d8},
    {0xe388, 0xf4d9}, {0xe389, 0xf4da}, {0xe38a, 0xf4db}, {0xe38b, 0xf4dc},
    {0xe38c, 0xf4dd}, {0xe38d, 0xf4de}, {0xe38e, 0xf4df}, {0xe38f, 0xf4e0},
    {0xe390, 0xf4e1}, {0xe391, 0xf4e2}, {0xe392, 0xf4e3}, {0xe393, 0xf4e4},
    {0xe394, 0xf4e5}, {0xe395, 0xf4e6}, {0xe396, 0xf4e7}, {0xe397, 0xf4e8},
    {0xe398, 0xf4e9}, {0xe399, 0xf4ea}, {0xe39a, 0xf4eb}, {0xe39b, 0xf4ec},
    {0xe39c, 0xf4ed}, {0xe39d, 0xf4ee}, {0xe39e, 0xf4ef}, {0xe39f, 0xf4f0},
    {0xe3a0, 0xf4f1}, {0xe3a1, 0xf4f2}, {0xe3a2, 0xf4f3}, {0xe3a3, 0xf4f4},
    {0xe3a4, 0xf4f5}, {0xe3a5, 0xf4f6}, {0xe3a6, 0xf4f7}, {0xe3a7, 0xf4f8},
    {0xe3a8, 0xf4f9}, {0xe3a9, 0xf4fa}, {0xe3aa, 0xf4fb}, {0xe3ab, 0xf4fc},
    {0xe3ac, 0xf540}, {0xe3ad, 0xf541}, {0xe3ae, 0xf542}, {0xe3af, 0xf543},
    {0xe3b0, 0xf544}, {0xe3b1, 0xf545}, {0xe3b2, 0xf546}, {0xe3b3, 0xf547},
    {0xe3b4, 0xf548}, {0xe3b5, 0xf549}, {0xe3b6, 0xf54a}, {0xe3b7, 0xf54b},
    {0xe3b8, 0xf54c}, {0xe3b9, 0xf54d}, {0xe3ba, 0xf54e}, {0xe3bb, 0xf54f},
    {0xe3bc, 0xf550}, {0xe3bd, 0xf551}, {0xe3be, 0xf552}, {0xe3bf, 0xf553},
    {0xe3c0, 0xf554}, {0xe3c1, 0xf555}, {0xe3c2, 0xf556}, {0xe3c3, 0xf557},
    {0xe3c4, 0xf558}, {0xe3c5, 0xf559}, {0xe3c6, 0xf55a}, {0xe3c7, 0xf55b},
    {0xe3c8, 0xf55c}, {0xe3c9, 0xf55d}, {0xe3ca, 0xf55e}, {0xe3cb, 0xf55f},
    {0xe3cc, 0xf560}, {0xe3cd, 0xf561}, {0xe3ce, 0xf562}, {0xe3cf, 0xf563},
    {0xe3d0, 0xf564}, {0xe3d1, 0xf565}, {0xe3d2, 0xf566}, {0xe3d3, 0xf567},
    {0xe3d4, 0xf568}, {0xe3d5, 0xf569}, {0xe3d6, 0xf56a}, {0xe3d7, 0xf56b},
    {0xe3d8, 0xf56c}, {0xe3d9, 0xf56d}, {0xe3da, 0xf56e}, {0xe3db, 0xf56f},
    {0xe3dc, 0xf570}, {0xe3dd, 0xf571}, {0xe3de, 0xf572}, {0xe3df, 0xf573},
    {0xe3e0, 0xf574}, {0xe3e1, 0xf575}, {0xe3e2, 0xf576}, {0xe3e3, 0xf577},
    {0xe3e4, 0xf578}, {0xe3e5, 0xf579}, {0xe3e6, 0xf57a}, {0xe3e7, 0xf57b},
    {0xe3e8, 0xf57c}, {0xe3e9, 0xf57d}, {0xe3ea, 0xf57e}, {0xe3eb, 0xf580},
    {0xe3ec, 0xf581}, {0xe3ed, 0xf582}, {0xe3ee, 0xf583}, {0xe3ef, 0xf584},
    {0xe3f0, 0xf585}, {0xe3f1, 0xf586}, {0xe3f2, 0xf587}, {0xe3f3, 0xf588},
    {0xe3f4, 0xf589}, {0xe3f5, 0xf58a}, {0xe3f6, 0xf58b}, {0xe3f7, 0xf58c},
    {0xe3f8, 0xf58d}, {0xe3f9, 0xf58e}, {0xe3fa, 0xf58f}, {0xe3fb, 0xf590},
    {0xe3fc, 0xf591}, {0xe3fd, 0xf592}, {0xe3fe, 0xf593}, {0xe3ff, 0xf594},
    {0xe400, 0xf595}, {0xe401, 0xf596}, {0xe402, 0xf597}, {0xe403, 0xf598},
    {0xe404, 0xf599}, {0xe405, 0xf59a}, {0xe406, 0xf59b}, {0xe407, 0xf59c},
    {0xe408, 0xf59d}, {0xe409, 0xf59e}, {0xe40a, 0xf59f}, {0xe40b, 0xf5a0},
    {0xe40c, 0xf5a1}, {0xe40d, 0xf5a2}, {0xe40e, 0xf5a3}, {0xe40f, 0xf5a4},
    {0xe410, 0xf5a5}, {0xe411, 0xf5a6}, {0xe412, 0xf5a7}, {0xe413, 0xf5a8},
    {0xe414, 0xf5a9}, {0xe415, 0xf5aa}, {0xe416, 0xf5ab}, {0xe417, 0xf5ac},
    {0xe418, 0xf5ad}, {0xe419, 0xf5ae}, {0xe41a, 0xf5af}, {0xe41b, 0xf5b0},
    {0xe41c, 0xf5b1}, {0xe41d, 0xf5b2}, {0xe41e, 0xf5b3}, {0xe41f, 0xf5b4},
    {0xe420, 0xf5b5}, {0xe421, 0xf5b6}, {0xe422, 0xf5b7}, {0xe423, 0xf5b8},
    {0xe424, 0xf5b9}, {0xe425, 0xf5ba}, {0xe426, 0xf5bb}, {0xe427, 0xf5bc},
    {0xe428, 0xf5bd}, {0xe429, 0xf5be}, {0xe42a, 0xf5bf}, {0xe42b, 0xf5c0},
    {0xe42c, 0xf5c1}, {0xe42d, 0xf5c2}, {0xe42e, 0xf5c3}, {0xe42f, 0xf5c4},
    {0xe430, 0xf5c5}, {0xe431, 0xf5c6}, {0xe432, 0xf5c7}, {0xe433, 0xf5c8},
    {0xe434, 0xf5c9}, {0xe435, 0xf5ca}, {0xe436, 0xf5cb}, {0xe437, 0xf5cc},
    {0xe438, 0xf5cd}, {0xe439, 0xf5ce}, {0xe43a, 0xf5cf}, {0xe43b, 0xf5d0},
    {0xe43c, 0xf5d1}, {0xe43d, 0xf5d2}, {0xe43e, 0xf5d3}, {0xe43f, 0xf5d4},
    {0xe440, 0xf5d5}, {0xe441, 0xf5d6}, {0xe442, 0xf5d7}, {0xe443, 0xf5d8},
    {0xe444, 0xf5d9}, {0xe445, 0xf5da}, {0xe446, 0xf5db}, {0xe447, 0xf5dc},
    {0xe448, 0xf5dd}, {0xe449, 0xf5de}, {0xe44a, 0xf5df}, {0xe44b, 0xf5e0},
    {0xe44c, 0xf5e1}, {0xe44d, 0xf5e2}, {0xe44e, 0xf5e3}, {0xe44f, 0xf5e4},
    {0xe450, 0xf5e5}, {0xe451, 0xf5e6}, {0xe452, 0xf5e7}, {0xe453, 0xf5e8},
    {0xe454, 0xf5e9}, {0xe455, 0xf5ea}, {0xe456, 0xf5eb}, {0xe457, 0xf5ec},
    {0xe458, 0xf5ed}, {0xe459, 0xf5ee}, {0xe45a, 0xf5ef}, {0xe45b, 0xf5f0},
    {0xe45c, 0xf5f1}, {0xe45d, 0xf5f2}, {0xe45e, 0xf5f3}, {0xe45f, 0xf5f4},
    {0xe460, 0xf5f5}, {0xe461, 0xf5f6}, {0xe462, 0xf5f7}, {0xe463, 0xf5f8},
    {0xe464, 0xf5f9}, {0xe465, 0xf5fa}, {0xe466, 0xf5fb}, {0xe467, 0xf5fc},
    {0xe468, 0xf640}, {0xe469, 0xf641}, {0xe46a, 0xf642}, {0xe46b, 0xf643},
    {0xe46c, 0xf644}, {0xe46d, 0xf645}, {0xe46e, 0xf646}, {0xe46f, 0xf647},
    {0xe470, 0xf648}, {0xe471, 0xf649}, {0xe472, 0xf64a}, {0xe473, 0xf64b},
    {0xe474, 0xf64c}, {0xe475, 0xf64d}, {0xe476, 0xf64e}, {0xe477, 0xf64f},
    {0xe478, 0xf650}, {0xe479, 0xf651}, {0xe47a, 0xf652}, {0xe47b, 0xf653},
    {0xe47c, 0xf654}, {0xe47d, 0xf655}, {0xe47e, 0xf656}, {0xe47f, 0xf657},
    {0xe480, 0xf658}, {0xe481, 0xf659}, {0xe482, 0xf65a}, {0xe483, 0xf65b},
    {0xe484, 0xf65c}, {0xe485, 0xf65d}, {0xe486, 0xf65e}, {0xe487, 0xf65f},
    {0xe488, 0xf660}, {0xe489, 0xf661}, {0xe48a, 0xf662}, {0xe48b, 0xf663},
    {0xe48c, 0xf664}, {0xe48d, 0xf665}, {0xe48e, 0xf666}, {0xe48f, 0xf667},
    {0xe490, 0xf668}, {0xe491, 0xf669}, {0xe492, 0xf66a}, {0xe493, 0xf66b},
    {0xe494, 0xf66c}, {0xe495, 0xf66d}, {0xe496, 0xf66e}, {0xe497, 0xf66f},
    {0xe498, 0xf670}, {0xe499, 0xf671}, {0xe49a, 0xf672}, {0xe49b, 0xf673},
    {0xe49c, 0xf674}, {0xe49d, 0xf675}, {0xe49e, 0xf676}, {0xe49f, 0xf677},
    {0xe4a0, 0xf678}, {0xe4a1, 0xf679}, {0xe4a2, 0xf67a}, {0xe4a3, 0xf67b},
    {0xe4a4, 0xf67c}, {0xe4a5, 0xf67d}, {0xe4a6, 0xf67e}, {0xe4a7, 0xf680},
    {0xe4a8, 0xf681}, {0xe4a9, 0xf682}, {0xe4aa, 0xf683}, {0xe4ab, 0xf684},
    {0xe4ac, 0xf685}, {0xe4ad, 0xf686}, {0xe4ae, 0xf687}, {0xe4af, 0xf688},
    {0xe4b0, 0xf689}, {0xe4b1, 0xf68a}, {0xe4b2, 0xf68b}, {0xe4b3, 0xf68c},
    {0xe4b4, 0xf68d}, {0xe4b5, 0xf68e}, {0xe4b6, 0xf68f}, {0xe4b7, 0xf690},
    {0xe4b8, 0xf691}, {0xe4b9, 0xf692}, {0xe4ba, 0xf693}, {0xe4bb, 0xf694},
    {0xe4bc, 0xf695}, {0xe4bd, 0xf696}, {0xe4be, 0xf697}, {0xe4bf, 0xf698},
    {0xe4c0, 0xf699}, {0xe4c1, 0xf69a}, {0xe4c2, 0xf69b}, {0xe4c3, 0xf69c},
    {0xe4c4, 0xf69d}, {0xe4c5, 0xf69e}, {0xe4c6, 0xf69f}, {0xe4c7, 0xf6a0},
    {0xe4c8, 0xf6a1}, {0xe4c9, 0xf6a2}, {0xe4ca, 0xf6a3}, {0xe4cb, 0xf6a4},
    {0xe4cc, 0xf6a5}, {0xe4cd, 0xf6a6}, {0xe4ce, 0xf6a7}, {0xe4cf, 0xf6a8},
    {0xe4d0, 0xf6a9}, {0xe4d1, 0xf6aa}, {0xe4d2, 0xf6ab}, {0xe4d3, 0xf6ac},
    {0xe4d4, 0xf6ad}, {0xe4d5, 0xf6ae}, {0xe4d6, 0xf6af}, {0xe4d7, 0xf6b0},
    {0xe4d8, 0xf6b1}, {0xe4d9, 0xf6b2}, {0xe4da, 0xf6b3}, {0xe4db, 0xf6b4},
    {0xe4dc, 0xf6b5}, {0xe4dd, 0xf6b6}, {0xe4de, 0xf6b7}, {0xe4df, 0xf6b8},
    {0xe4e0, 0xf6b9}, {0xe4e1, 0xf6ba}, {0xe4e2, 0xf6bb}, {0xe4e3, 0xf6bc},
    {0xe4e4, 0xf6bd}, {0xe4e5, 0xf6be}, {0xe4e6, 0xf6bf}, {0xe4e7, 0xf6c0},
    {0xe4e8, 0xf6c1}, {0xe4e9, 0xf6c2}, {0xe4ea, 0xf6c3}, {0xe4eb, 0xf6c4},
    {0xe4ec, 0xf6c5}, {0xe4ed, 0xf6c6}, {0xe4ee, 0xf6c7}, {0xe4ef, 0xf6c8},
    {0xe4f0, 0xf6c9}, {0xe4f1, 0xf6ca}, {0xe4f2, 0xf6cb}, {0xe4f3, 0xf6cc},
    {0xe4f4, 0xf6cd}, {0xe4f5, 0xf6ce}, {0xe4f6, 0xf6cf}, {0xe4f7, 0xf6d0},
    {0xe4f8, 0xf6d1}, {0xe4f9, 0xf6d2}, {0xe4fa, 0xf6d3}, {0xe4fb, 0xf6d4},
    {0xe4fc, 0xf6d5}, {0xe4fd, 0xf6d6}, {0xe4fe, 0xf6d7}, {0xe4ff, 0xf6d8},
    {0xe500, 0xf6d9}, {0xe501, 0xf6da}, {0xe502, 0xf6db}, {0xe503, 0xf6dc},
    {0xe504, 0xf6dd}, {0xe505, 0xf6de}, {0xe506, 0xf6df}, {0xe507, 0xf6e0},
    {0xe508, 0xf6e1}, {0xe509, 0xf6e2}, {0xe50a, 0xf6e3}, {0xe50b, 0xf6e4},
    {0xe50c, 0xf6e5}, {0xe50d, 0xf6e6}, {0xe50e, 0xf6e7}, {0xe50f, 0xf6e8},
    {0xe510, 0xf6e9}, {0xe511, 0xf6ea}, {0xe512, 0xf6eb}, {0xe513, 0xf6ec},
    {0xe514, 0xf6ed}, {0xe515, 0xf6ee}, {0xe516, 0xf6ef}, {0xe517, 0xf6f0},
    {0xe518, 0xf6f1}, {0xe519, 0xf6f2}, {0xe51a, 0xf6f3}, {0xe51b, 0xf6f4},
    {0xe51c, 0xf6f5}, {0xe51d, 0xf6f6}, {0xe51e, 0xf6f7}, {0xe51f, 0xf6f8},
    {0xe520, 0xf6f9}, {0xe521, 0xf6fa}, {0xe522, 0xf6fb}, {0xe523, 0xf6fc},
    {0xe524, 0xf740}, {0xe525, 0xf741}, {0xe526, 0xf742}, {0xe527, 0xf743},
    {0xe528, 0xf744}, {0xe529, 0xf745}, {0xe52a, 0xf746}, {0xe52b, 0xf747},
    {0xe52c, 0xf748}, {0xe52d, 0xf749}, {0xe52e, 0xf74a}, {0xe52f, 0xf74b},
    {0xe530, 0xf74c}, {0xe531, 0xf74d}, {0xe532, 0xf74e}, {0xe533, 0xf74f},
    {0xe534, 0xf750}, {0xe535, 0xf751}, {0xe536, 0xf752}, {0xe537, 0xf753},
    {0xe538, 0xf754}, {0xe539, 0xf755}, {0xe53a, 0xf756}, {0xe53b, 0xf757},
    {0xe53c, 0xf758}, {0xe53d, 0xf759}, {0xe53e, 0xf75a}, {0xe53f, 0xf75b},
    {0xe540, 0xf75c}, {0xe541, 0xf75d}, {0xe542, 0xf75e}, {0xe543, 0xf75f},
    {0xe544, 0xf760}, {0xe545, 0xf761}, {0xe546, 0xf762}, {0xe547, 0xf763},
    {0xe548, 0xf764}, {0xe549, 0xf765}, {0xe54a, 0xf766}, {0xe54b, 0xf767},
    {0xe54c, 0xf768}, {0xe54d, 0xf769}, {0xe54e, 0xf76a}, {0xe54f, 0xf76b},
    {0xe550, 0xf76c}, {0xe551, 0xf76d}, {0xe552, 0xf76e}, {0xe553, 0xf76f},
    {0xe554, 0xf770}, {0xe555, 0xf771}, {0xe556, 0xf772}, {0xe557, 0xf773},
    {0xe558, 0xf774}, {0xe559, 0xf775}, {0xe55a, 0xf776}, {0xe55b, 0xf777},
    {0xe55c, 0xf778}, {0xe55d, 0xf779}, {0xe55e, 0xf77a}, {0xe55f, 0xf77b},
    {0xe560, 0xf77c}, {0xe561, 0xf77d}, {0xe562, 0xf77e}, {0xe563, 0xf780},
    {0xe564, 0xf781}, {0xe565, 0xf782}, {0xe566, 0xf783}, {0xe567, 0xf784},
    {0xe568, 0xf785}, {0xe569, 0xf786}, {0xe56a, 0xf787}, {0xe56b, 0xf788},
    {0xe56c, 0xf789}, {0xe56d, 0xf78a}, {0xe56e, 0xf78b}, {0xe56f, 0xf78c},
    {0xe570, 0xf78d}, {0xe571, 0xf78e}, {0xe572, 0xf78f}, {0xe573, 0xf790},
    {0xe574, 0xf791}, {0xe575, 0xf792}, {0xe576, 0xf793}, {0xe577, 0xf794},
    {0xe578, 0xf795}, {0xe579, 0xf796}, {0xe57a, 0xf797}, {0xe57b, 0xf798},
    {0xe57c, 0xf799}, {0xe57d, 0xf79a}, {0xe57e, 0xf79b}, {0xe57f, 0xf79c},
    {0xe580, 0xf79d}, {0xe581, 0xf79e}, {0xe582, 0xf79f}, {0xe583, 0xf7a0},
    {0xe584, 0xf7a1}, {0xe585, 0xf7a2}, {0xe586, 0xf7a3}, {0xe587, 0xf7a4},
    {0xe588, 0xf7a5}, {0xe589, 0xf7a6}, {0xe58a, 0xf7a7}, {0xe58b, 0xf7a8},
    {0xe58c, 0xf7a9}, {0xe58d, 0xf7aa}, {0xe58e, 0xf7ab}, {0xe58f, 0xf7ac},
    {0xe590, 0xf7ad}, {0xe591, 0xf7ae}, {0xe592, 0xf7af}, {0xe593, 0xf7b0},
    {0xe594, 0xf7b1}, {0xe595, 0xf7b2}, {0xe596, 0xf7b3}, {0xe597, 0xf7b4},
    {0xe598, 0xf7b5}, {0xe599, 0xf7b6}, {0xe59a, 0xf7b7}, {0xe59b, 0xf7b8},
    {0xe59c, 0xf7b9}, {0xe59d, 0xf7ba}, {0xe59e, 0xf7bb}, {0xe59f, 0xf7bc},
    {0xe5a0, 0xf7bd}, {0xe5a1, 0xf7be}, {0xe5a2, 0xf7bf}, {0xe5a3, 0xf7c0},
    {0xe5a4, 0xf7c1}, {0xe5a5, 0xf7c2}, {0xe5a6, 0xf7c3}, {0xe5a7, 0xf7c4},
    {0xe5a8, 0xf7c5}, {0xe5a9, 0xf7c6}, {0xe5aa, 0xf7c7}, {0xe5ab, 0xf7c8},
    {0xe5ac, 0xf7c9}, {0xe5ad, 0xf7ca}, {0xe5ae, 0xf7cb}, {0xe5af, 0xf7cc},
    {0xe5b0, 0xf7cd}, {0xe5b1, 0xf7ce}, {0xe5b2, 0xf7cf}, {0xe5b3, 0xf7d0},
    {0xe5b4, 0xf7d1}, {0xe5b5, 0xf7d2}, {0xe5b6, 0xf7d3}, {0xe5b7, 0xf7d4},
    {0xe5b8, 0xf7d5}, {0xe5b9, 0xf7d6}, {0xe5ba, 0xf7d7}, {0xe5bb, 0xf7d8},
    {0xe5bc, 0xf7d9}, {0xe5bd, 0xf7da}, {0xe5be, 0xf7db}, {0xe5bf, 0xf7dc},
    {0xe5c0, 0xf7dd}, {0xe5c1, 0xf7de}, {0xe5c2, 0xf7df}, {0xe5c3, 0xf7e0},
    {0xe5c4, 0xf7e1}, {0xe5c5, 0xf7e2}, {0xe5c6, 0xf7e3}, {0xe5c7, 0xf7e4},
    {0xe5c8, 0xf7e5}, {0xe5c9, 0xf7e6}, {0xe5ca, 0xf7e7}, {0xe5cb, 0xf7e8},
    {0xe5cc, 0xf7e9}, {0xe5cd, 0xf7ea}, {0xe5ce, 0xf7eb}, {0xe5cf, 0xf7ec},
    {0xe5d0, 0xf7ed}, {0xe5d1, 0xf7ee}, {0xe5d2, 0xf7ef}, {0xe5d3, 0xf7f0},
    {0xe5d4, 0xf7f1}, {0xe5d5, 0xf7f2}, {0xe5d6, 0xf7f3}, {0xe5d7, 0xf7f4},
    {0xe5d8, 0xf7f5}, {0xe5d9, 0xf7f6}, {0xe5da, 0xf7f7}, {0xe5db, 0xf7f8},
    {0xe5dc, 0xf7f9}, {0xe5dd, 0xf7fa}, {0xe5de, 0xf7fb}, {0xe5df, 0xf7fc},
    {0xe5e0, 0xf840}, {0xe5e1, 0xf841}, {0xe5e2, 0xf842}, {0xe5e3, 0xf843},
    {0xe5e4, 0xf844}, {0xe5e5, 0xf845}, {0xe5e6, 0xf846}, {0xe5e7, 0xf847},
    {0xe5e8, 0xf848}, {0xe5e9, 0xf849}, {0xe5ea, 0xf84a}, {0xe5eb, 0xf84b},
    {0xe5ec, 0xf84c}, {0xe5ed, 0xf84d}, {0xe5ee, 0xf84e}, {0xe5ef, 0xf84f},
    {0xe5f0, 0xf850}, {0xe5f1, 0xf851}, {0xe5f2, 0xf852}, {0xe5f3, 0xf853},
    {0xe5f4, 0xf854}, {0xe5f5, 0xf855}, {0xe5f6, 0xf856}, {0xe5f7, 0xf857},
    {0xe5f8, 0xf858}, {0xe5f9, 0xf859}, {0xe5fa, 0xf85a}, {0xe5fb, 0xf85b},
    {0xe5fc, 0xf85c}, {0xe5fd, 0xf85d}, {0xe5fe, 0xf85e}, {0xe5ff, 0xf85f},
    {0xe600, 0xf860}, {0xe601, 0xf861}, {0xe602, 0xf862}, {0xe603, 0xf863},
    {0xe604, 0xf864}, {0xe605, 0xf865}, {0xe606, 0xf866}, {0xe607, 0xf867},
    {0xe608, 0xf868}, {0xe609, 0xf869}, {0xe60a, 0xf86a}, {0xe60b, 0xf86b},
    {0xe60c, 0xf86c}, {0xe60d, 0xf86d}, {0xe60e, 0xf86e}, {0xe60f, 0xf86f},
    {0xe610, 0xf870}, {0xe611, 0xf871}, {0xe612, 0xf872}, {0xe613, 0xf873},
    {0xe614, 0xf874}, {0xe615, 0xf875}, {0xe616, 0xf876}, {0xe617, 0xf877},
    {0xe618, 0xf878}, {0xe619, 0xf879}, {0xe61a, 0xf87a}, {0xe61b, 0xf87b},
    {0xe61c, 0xf87c}, {0xe61d, 0xf87d}, {0xe61e, 0xf87e}, {0xe61f, 0xf880},
    {0xe620, 0xf881}, {0xe621, 0xf882}, {0xe622, 0xf883}, {0xe623, 0xf884},
    {0xe624, 0xf885}, {0xe625, 0xf886}, {0xe626, 0xf887}, {0xe627, 0xf888},
    {0xe628, 0xf889}, {0xe629, 0xf88a}, {0xe62a, 0xf88b}, {0xe62b, 0xf88c},
    {0xe62c, 0xf88d}, {0xe62d, 0xf88e}, {0xe62e, 0xf88f}, {0xe62f, 0xf890},
    {0xe630, 0xf891}, {0xe631, 0xf892}, {0xe632, 0xf893}, {0xe633, 0xf894},
    {0xe634, 0xf895}, {0xe635, 0xf896}, {0xe636, 0xf897}, {0xe637, 0xf898},
    {0xe638, 0xf899}, {0xe639, 0xf89a}, {0xe63a, 0xf89b}, {0xe63b, 0xf89c},
    {0xe63c, 0xf89d}, {0xe63d, 0xf89e}, {0xe63e, 0xf89f}, {0xe63f, 0xf8a0},
    {0xe640, 0xf8a1}, {0xe641, 0xf8a2}, {0xe642, 0xf8a3}, {0xe643, 0xf8a4},
    {0xe644, 0xf8a5}, {0xe645, 0xf8a6}, {0xe646, 0xf8a7}, {0xe647, 0xf8a8},
    {0xe648, 0xf8a9}, {0xe649, 0xf8aa}, {0xe64a, 0xf8ab}, {0xe64b, 0xf8ac},
    {0xe64c, 0xf8ad}, {0xe64d, 0xf8ae}, {0xe64e, 0xf8af}, {0xe64f, 0xf8b0},
    {0xe650, 0xf8b1}, {0xe651, 0xf8b2}, {0xe652, 0xf8b3}, {0xe653, 0xf8b4},
    {0xe654, 0xf8b5}, {0xe655, 0xf8b6}, {0xe656, 0xf8b7}, {0xe657, 0xf8b8},
    {0xe658, 0xf8b9}, {0xe659, 0xf8ba}, {0xe65a, 0xf8bb}, {0xe65b, 0xf8bc},
    {0xe65c, 0xf8bd}, {0xe65d, 0xf8be}, {0xe65e, 0xf8bf}, {0xe65f, 0xf8c0},
    {0xe660, 0xf8c1}, {0xe661, 0xf8c2}, {0xe662, 0xf8c3}, {0xe663, 0xf8c4},
    {0xe664, 0xf8c5}, {0xe665, 0xf8c6}, {0xe666, 0xf8c7}, {0xe667, 0xf8c8},
    {0xe668, 0xf8c9}, {0xe669, 0xf8ca}, {0xe66a, 0xf8cb}, {0xe66b, 0xf8cc},
    {0xe66c, 0xf8cd}, {0xe66d, 0xf8ce}, {0xe66e, 0xf8cf}, {0xe66f, 0xf8d0},
    {0xe670, 0xf8d1}, {0xe671, 0xf8d2}, {0xe672, 0xf8d3}, {0xe673, 0xf8d4},
    {0xe674, 0xf8d5}, {0xe675, 0xf8d6}, {0xe676, 0xf8d7}, {0xe677, 0xf8d8},
    {0xe678, 0xf8d9}, {0xe679, 0xf8da}, {0xe67a, 0xf8db}, {0xe67b, 0xf8dc},
    {0xe67c, 0xf8dd}, {0xe67d, 0xf8de}, {0xe67e, 0xf8df}, {0xe67f, 0xf8e0},
    {0xe680, 0xf8e1}, {0xe681, 0xf8e2}, {0xe682, 0xf8e3}, {0xe683, 0xf8e4},
    {0xe684, 0xf8e5}, {0xe685, 0xf8e6}, {0xe686, 0xf8e7}, {0xe687, 0xf8e8},
    {0xe688, 0xf8e9}, {0xe689, 0xf8ea}, {0xe68a, 0xf8eb}, {0xe68b, 0xf8ec},
    {0xe68c, 0xf8ed}, {0xe68d, 0xf8ee}, {0xe68e, 0xf8ef}, {0xe68f, 0xf8f0},
    {0xe690, 0xf8f1}, {0xe691, 0xf8f2}, {0xe692, 0xf8f3}, {0xe693, 0xf8f4},
    {0xe694, 0xf8f5}, {0xe695, 0xf8f6}, {0xe696, 0xf8f7}, {0xe697, 0xf8f8},
    {0xe698, 0xf8f9}, {0xe699, 0xf8fa}, {0xe69a, 0xf8fb}, {0xe69b, 0xf8fc},
    {0xe69c, 0xf940}, {0xe69d, 0xf941}, {0xe69e, 0xf942}, {0xe69f, 0xf943},
    {0xe6a0, 0xf944}, {0xe6a1, 0xf945}, {0xe6a2, 0xf946}, {0xe6a3, 0xf947},
    {0xe6a4, 0xf948}, {0xe6a5, 0xf949}, {0xe6a6, 0xf94a}, {0xe6a7, 0xf94b},
    {0xe6a8, 0xf94c}, {0xe6a9, 0xf94d}, {0xe6aa, 0xf94e}, {0xe6ab, 0xf94f},
    {0xe6ac, 0xf950}, {0xe6ad, 0xf951}, {0xe6ae, 0xf952}, {0xe6af, 0xf953},
    {0xe6b0, 0xf954}, {0xe6b1, 0xf955}, {0xe6b2, 0xf956}, {0xe6b3, 0xf957},
    {0xe6b4, 0xf958}, {0xe6b5, 0xf959}, {0xe6b6, 0xf95a}, {0xe6b7, 0xf95b},
    {0xe6b8, 0xf95c}, {0xe6b9, 0xf95d}, {0xe6ba, 0xf95e}, {0xe6bb, 0xf95f},
    {0xe6bc, 0xf960}, {0xe6bd, 0xf961}, {0xe6be, 0xf962}, {0xe6bf, 0xf963},
    {0xe6c0, 0xf964}, {0xe6c1, 0xf965}, {0xe6c2, 0xf966}, {0xe6c3, 0xf967},
    {0xe6c4, 0xf968}, {0xe6c5, 0xf969}, {0xe6c6, 0xf96a}, {0xe6c7, 0xf96b},
    {0xe6c8, 0xf96c}, {0xe6c9, 0xf96d}, {0xe6ca, 0xf96e}, {0xe6cb, 0xf96f},
    {0xe6cc, 0xf970}, {0xe6cd, 0xf971}, {0xe6ce, 0xf972}, {0xe6cf, 0xf973},
    {0xe6d0, 0xf974}, {0xe6d1, 0xf975}, {0xe6d2, 0xf976}, {0xe6d3, 0xf977},
    {0xe6d4, 0xf978}, {0xe6d5, 0xf979}, {0xe6d6, 0xf97a}, {0xe6d7, 0xf97b},
    {0xe6d8, 0xf97c}, {0xe6d9, 0xf97d}, {0xe6da, 0xf97e}, {0xe6db, 0xf980},
    {0xe6dc, 0xf981}, {0xe6dd, 0xf982}, {0xe6de, 0xf983}, {0xe6df, 0xf984},
    {0xe6e0, 0xf985}, {0xe6e1, 0xf986}, {0xe6e2, 0xf987}, {0xe6e3, 0xf988},
    {0xe6e4, 0xf989}, {0xe6e5, 0xf98a}, {0xe6e6, 0xf98b}, {0xe6e7, 0xf98c},
    {0xe6e8, 0xf98d}, {0xe6e9, 0xf98e}, {0xe6ea, 0xf98f}, {0xe6eb, 0xf990},
    {0xe6ec, 0xf991}, {0xe6ed, 0xf992}, {0xe6ee, 0xf993}, {0xe6ef, 0xf994},
    {0xe6f0, 0xf995}, {0xe6f1, 0xf996}, {0xe6f2, 0xf997}, {0xe6f3, 0xf998},
    {0xe6f4, 0xf999}, {0xe6f5, 0xf99a}, {0xe6f6, 0xf99b}, {0xe6f7, 0xf99c},
    {0xe6f8, 0xf99d}, {0xe6f9, 0xf99e}, {0xe6fa, 0xf99f}, {0xe6fb, 0xf9a0},
    {0xe6fc, 0xf9a1}, {0xe6fd, 0xf9a2}, {0xe6fe, 0xf9a3}, {0xe6ff, 0xf9a4},
    {0xe700, 0xf9a5}, {0xe701, 0xf9a6}, {0xe702, 0xf9a7}, {0xe703, 0xf9a8},
    {0xe704, 0xf9a9}, {0xe705, 0xf9aa}, {0xe706, 0xf9ab}, {0xe707, 0xf9ac},
    {0xe708, 0xf9ad}, {0xe709, 0xf9ae}, {0xe70a, 0xf9af}, {0xe70b, 0xf9b0},
    {0xe70c, 0xf9b1}, {0xe70d, 0xf9b2}, {0xe70e, 0xf9b3}, {0xe70f, 0xf9b4},
    {0xe710, 0xf9b5}, {0xe711, 0xf9b6}, {0xe712, 0xf9b7}, {0xe713, 0xf9b8},
    {0xe714, 0xf9b9}, {0xe715, 0xf9ba}, {0xe716, 0xf9bb}, {0xe717, 0xf9bc},
    {0xe718, 0xf9bd}, {0xe719, 0xf9be}, {0xe71a, 0xf9bf}, {0xe71b, 0xf9c0},
    {0xe71c, 0xf9c1}, {0xe71d, 0xf9c2}, {0xe71e, 0xf9c3}, {0xe71f, 0xf9c4},
    {0xe720, 0xf9c5}, {0xe721, 0xf9c6}, {0xe722, 0xf9c7}, {0xe723, 0xf9c8},
    {0xe724, 0xf9c9}, {0xe725, 0xf9ca}, {0xe726, 0xf9cb}, {0xe727, 0xf9cc},
    {0xe728, 0xf9cd}, {0xe729, 0xf9ce}, {0xe72a, 0xf9cf}, {0xe72b, 0xf9d0},
    {0xe72c, 0xf9d1}, {0xe72d, 0xf9d2}, {0xe72e, 0xf9d3}, {0xe72f, 0xf9d4},
    {0xe730, 0xf9d5}, {0xe731, 0xf9d6}, {0xe732, 0xf9d7}, {0xe733, 0xf9d8},
    {0xe734, 0xf9d9}, {0xe735, 0xf9da}, {0xe736, 0xf9db}, {0xe737, 0xf9dc},
    {0xe738, 0xf9dd}, {0xe739, 0xf9de}, {0xe73a, 0xf9df}, {0xe73b, 0xf9e0},
    {0xe73c, 0xf9e1}, {0xe73d, 0xf9e2}, {0xe73e, 0xf9e3}, {0xe73f, 0xf9e4},
    {0xe740, 0xf9e5}, {0xe741, 0xf9e6}, {0xe742, 0xf9e7}, {0xe743, 0xf9e8},
    {0xe744, 0xf9e9}, {0xe745, 0xf9ea}, {0xe746, 0xf9eb}, {0xe747, 0xf9ec},
    {0xe748, 0xf9ed}, {0xe749, 0xf9ee}, {0xe74a, 0xf9ef}, {0xe74b, 0xf9f0},
    {0xe74c, 0xf9f1}, {0xe74d, 0xf9f2}, {0xe74e, 0xf9f3}, {0xe74f, 0xf9f4},
    {0xe750, 0xf9f5}, {0xe751, 0xf9f6}, {0xe752, 0xf9f7}, {0xe753, 0xf9f8},
    {0xe754, 0xf9f9}, {0xe755, 0xf9fa}, {0xe756, 0xf9fb}, {0xe757, 0xf9fc},
    {0xf86f, 0xfa59}, {0xf929, 0xfae0}, {0xf9dc, 0xfbe9}, {0xfa0e, 0xfa90},
    {0xfa0f, 0xfa9b}, {0xfa10, 0xfa9c}, {0xfa11, 0xfab1}, {0xfa12, 0xfad8},
    {0xfa13, 0xfae8}, {0xfa14, 0xfaea}, {0xfa15, 0xfb58}, {0xfa16, 0xfb5e},
    {0xfa17, 0xfb75}, {0xfa18, 0xfb7d}, {0xfa19, 0xfb7e}, {0xfa1a, 0xfb80},
    {0xfa1b, 0xfb82}, {0xfa1c, 0xfb86}, {0xfa1d, 0xfb89}, {0xfa1e, 0xfb92},
    {0xfa1f, 0xfb9d}, {0xfa20, 0xfb9f}, {0xfa21, 0xfba0}, {0xfa22, 0xfba9},
    {0xfa23, 0xfbb1}, {0xfa24, 0xfbb3}, {0xfa25, 0xfbb4}, {0xfa26, 0xfbb7},
    {0xfa27, 0xfbd3}, {0xfa28, 0xfbda}, {0xfa29, 0xfbea}, {0xfa2a, 0xfbf6},
    {0xfa2b, 0xfbf7}, {0xfa2c, 0xfbf9}, {0xfa2d, 0xfc49}, {0xff01, 0x8149},
    {0xff02, 0xfa57}, {0xff03, 0x8194}, {0xff04, 0x8190}, {0xff05, 0x8193},
    {0xff06, 0x8195}, {0xff07, 0xfa56}, {0xff08, 0x8169}, {0xff09, 0x816a},
    {0xff0a, 0x8196}, {0xff0b, 0x817b}, {0xff0c, 0x8143}, {0xff0d, 0x817c},
    {0xff0e, 0x8144}, {0xff0f, 0x815e}, {0xff10, 0x824f}, {0xff11, 0x8250},
    {0xff12, 0x8251}, {0xff13, 0x8252}, {0xff14, 0x8253}, {0xff15, 0x8254},
    {0xff16, 0x8255}, {0xff17, 0x8256}, {0xff18, 0x8257}, {0xff19, 0x8258},
    {0xff1a, 0x8146}, {0xff1b, 0x8147}, {0xff1c, 0x8183}, {0xff1d, 0x8181},
    {0xff1e, 0x8184}, {0xff1f, 0x8148}, {0xff20, 0x8197}, {0xff21, 0x8260},
    {0xff22, 0x8261}, {0xff23, 0x8262}, {0xff24, 0x8263}, {0xff25, 0x8264},
    {0xff26, 0x8265}, {0xff27, 0x8266}, {0xff28, 0x8267}, {0xff29, 0x8268},
    {0xff2a, 0x8269}, {0xff2b, 0x826a}, {0xff2c, 0x826b}, {0xff2d, 0x826c},
    {0xff2e, 0x826d}, {0xff2f, 0x826e}, {0xff30, 0x826f}, {0xff31, 0x8270},
    {0xff32, 0x8271}, {0xff33, 0x8272}, {0xff34, 0x8273}, {0xff35, 0x8274},
    {0xff36, 0x8275}, {0xff37, 0x8276}, {0xff38, 0x8277}, {0xff39, 0x8278},
    {0xff3a, 0x8279}, {0xff3b, 0x816d}, {0xff3c, 0x815f}, {0xff3d, 0x816e},
    {0xff3e, 0x814f}, {0xff3f, 0x8151}, {0xff40, 0x814d}, {0xff41, 0x8281},
    {0xff42, 0x8282}, {0xff43, 0x8283}, {0xff44, 0x8284}, {0xff45, 0x8285},
    {0xff46, 0x8286}, {0xff47, 0x8287}, {0xff48, 0x8288}, {0xff49, 0x8289},
    {0xff4a, 0x828a}, {0xff4b, 0x828b}, {0xff4c, 0x828c}, {0xff4d, 0x828d},
    {0xff4e, 0x828e}, {0xff4f, 0x828f}, {0xff50, 0x8290}, {0xff51, 0x8291},
    {0xff52, 0x8292}, {0xff53, 0x8293}, {0xff54, 0x8294}, {0xff55, 0x8295},
    {0xff56, 0x8296}, {0xff57, 0x8297}, {0xff58, 0x8298}, {0xff59, 0x8299},
    {0xff5a, 0x829a}, {0xff5b, 0x816f}, {0xff5c, 0x8162}, {0xff5d, 0x8170},
    {0xff5e, 0x8160}, {0xffe0, 0x8191}, {0xffe1, 0x8192}, {0xffe2, 0x81ca},
    {0xffe3, 0x8150}, {0xffe4, 0xfa55}, {0xffe5, 0x818f}
};

#endif /* ibm943.h */
