#!/usr/bin/gjs -m

import System from 'system';
import GLib from 'gi://GLib';
import GObject from 'gi://GObject';
import Gtk from 'gi://Gtk?version=4.0';
import Casilda from 'gi://Casilda?version=1.0';


let CasildaApplication = GObject.registerClass({},
    class CasildaApplication extends Gtk.Application {
    constructor() {
        super({
            application_id: 'ar.xjuan.casilda.Gjs.Example'
        });
    }

    vfunc_activate() {
        let compositor = new Casilda.Compositor();

        let window = new Gtk.ApplicationWindow({
            application: this,
            title: 'Casilda Compositor',
            default_width: 800,
            default_height: 600,
            child: compositor
        });

        window.connect('close-request', () => {
            this.quit();
        });

        compositor.spawn_async (
            null,
            ["/usr/bin/gtk4-demo"],
            null,
            GLib.SpawnFlags.DEFAULT,
            null
        );

        window.present();
    }
});

let app = new CasildaApplication();
app.run([System.programInvocationName].concat(ARGV));
