# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Content type for upload
    """

    #: Content Type 'application/pdf'.
    APPLICATION_PDF = "application/pdf"
    #: Content Type 'image/jpeg'.
    IMAGE_JPEG = "image/jpeg"
    #: Content Type 'image/png'.
    IMAGE_PNG = "image/png"
    #: Content Type 'image/tiff'.
    IMAGE_TIFF = "image/tiff"
    #: Content Type 'application/json'.
    APPLICATION_JSON = "application/json"

class FieldValueType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Semantic data type of the field value.
    """

    STRING = "string"
    DATE = "date"
    TIME = "time"
    PHONE_NUMBER = "phoneNumber"
    NUMBER = "number"
    INTEGER = "integer"
    ARRAY = "array"
    OBJECT = "object"

class Language(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Language code
    """

    EN = "en"
    ES = "es"

class LengthUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The unit used by the width, height and boundingBox properties. For images, the unit is "pixel".
    For PDF, the unit is "inch".
    """

    PIXEL = "pixel"
    INCH = "inch"

class ModelStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the model.
    """

    CREATING = "creating"
    READY = "ready"
    INVALID = "invalid"

class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the queued operation.
    """

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"

class TrainStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the training operation.
    """

    SUCCEEDED = "succeeded"
    PARTIALLY_SUCCEEDED = "partiallySucceeded"
    FAILED = "failed"
