# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.applicationinsights.aio import ApplicationInsightsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApplicationInsightsManagementWorkItemConfigurationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApplicationInsightsManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_work_item_configurations_list(self, resource_group):
        response = self.client.work_item_configurations.list(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2015-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_work_item_configurations_create(self, resource_group):
        response = await self.client.work_item_configurations.create(
            resource_group_name=resource_group.name,
            resource_name="str",
            work_item_configuration_properties={
                "ConnectorDataConfiguration": "str",
                "ConnectorId": "str",
                "ValidateOnly": bool,
                "WorkItemProperties": {"str": "str"},
            },
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_work_item_configurations_get_default(self, resource_group):
        response = await self.client.work_item_configurations.get_default(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_work_item_configurations_delete(self, resource_group):
        response = await self.client.work_item_configurations.delete(
            resource_group_name=resource_group.name,
            resource_name="str",
            work_item_config_id="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_work_item_configurations_get_item(self, resource_group):
        response = await self.client.work_item_configurations.get_item(
            resource_group_name=resource_group.name,
            resource_name="str",
            work_item_config_id="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_work_item_configurations_update_item(self, resource_group):
        response = await self.client.work_item_configurations.update_item(
            resource_group_name=resource_group.name,
            resource_name="str",
            work_item_config_id="str",
            work_item_configuration_properties={
                "ConnectorDataConfiguration": "str",
                "ConnectorId": "str",
                "ValidateOnly": bool,
                "WorkItemProperties": {"str": "str"},
            },
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...
