#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H

/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL (assembly code)
//
//=============================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
// 
// The Original Code is eCos - Embedded Cygnus Operating System, released
// September 30, 1998.
// 
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998,1999 Cygnus Solutions.  All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    Eric Miniere 
// Contributors: Eric Miniere 
// Modification : adaptation to EVMCAN 
// Purpose:     ARM EVMCAN/EASYCAN3 platform specific support routines
// Description: 
// Usage:       #include <cyg/hal/hal_platform_setup.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/
#include <pkgconf/hal_arm_evmcan.h>

/* Device Dependancies Definition */
.equ CS0,0x400030A9
.equ CS1,0x48003081
.equ CS2,0x400030A9
.equ CS3,0x400030A9
.equ MCR_REG,0x00000007
.equ EBI,0xFFE00000 
.equ EBI_CSR0,0x00     
.equ EBI_CSR1,0x04  
.equ EBI_CSR2,0x08
.equ EBI_CSR3,0x1C
.equ EBI_RCR,0x20
.equ EBI_MCR,0x24 
//#define CYGHWR_HAL_ARM_HAS_MMU  // Set this up so we can get the correct reset_vector on boot

/* Initialise the Memory Controller */

#define PLATFORM_SETUP1                                 \
	ldr     r4, =CS0                                    ;\
	ldr     r3, =EBI                                                    ;\
	str     r4, [r3, #EBI_CSR0]                                         ;\
                     ;\
	ldr     r4, =CS1                                                    ;\
	str     r4, [r3, #EBI_CSR1]                                         ;\
	ldr     r4, =MCR_REG                                                ;\
	str     r4, [r3, #EBI_MCR]                                          ;\
                     ;\
	.globl Remap                                                         ;\
Remap :                                                               ;\
	ldr     r12, PtJumpAddress                                          ;\
	ldr     r3, =EBI                                                    ;\
	mov     r4, #1                                                      ;\
	str     r4, [r3, #EBI_RCR]                                          ;\
	mov     pc, r12                                                     ;\
                     ;\
PtJumpAddress:                                                        ;\
	.long JumpAddress                                                    ;\
JumpAddress :                                                         ;

/*---------------------------------------------------------------------------*/
/* end of hal_platform_setup.h                                               */
#endif /* CYGONCE_HAL_PLATFORM_SETUP_H */
