/* powerpc-darwin.macho-entry.h
   created from powerpc-darwin.macho-entry.bin, 8292 (0x2064) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_POWERPC_DARWIN_MACHO_ENTRY_SIZE    8292
#define STUB_POWERPC_DARWIN_MACHO_ENTRY_ADLER32 0xee4896e3
#define STUB_POWERPC_DARWIN_MACHO_ENTRY_CRC32   0xa45f897d

unsigned char stub_powerpc_darwin_macho_entry[8292] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 20,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 25, 80,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0,  0,  0,  0,  0,  0,  0,104, 40,  6,  0,208, 76,130,  0, 32,
/* 0x0040 */  84,132,240,191, 77,130,  0, 32, 60,  0,  0, 16,124,  4,  0, 64,
/* 0x0050 */  65,128,  0,  8,124,  4,  3,120, 56,165,  1, 32,124,103, 27,120,
/* 0x0060 */  56, 99,255,252,124,137,  3,166, 72,  0,  0, 28, 85, 96,  2,186,
/* 0x0070 */ 124,  3,  0, 80,124,  0, 58, 20, 80, 11,  1,186,145, 99,  0,  0,
/* 0x0080 */  78, 64,  0, 32,133, 99,  0,  4, 85, 96, 85,190,124,  0, 40, 64,
/* 0x0090 */  65,162,255,220, 66,  0,255,240, 78,128,  0, 32, 72,  0,  0, 73,
/* 0x00a0 */ 124,  0, 41,236,125,168,  2,166, 40,  7,  0,  8, 64,130,  1, 64,
/* 0x00b0 */ 144,166,  0,  0,124,132, 26, 20, 60,  0,128,  0, 61, 32,128,  0,
/* 0x00c0 */  56, 99,255,255, 56,165,255,255, 57, 64,255,255, 72,  0,  1, 16,
/* 0x00d0 */  57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4, 97, 43,  0,  1,
/* 0x00e0 */ 124, 11,  0, 64,125, 41, 72, 20, 97, 41,  0,  1, 78,128,  0, 32,
/* 0x00f0 */ 141,  3,  0,  1,157,  5,  0,  1,124,  9,  0, 64,125, 41, 74, 20,
/* 0x0100 */  65,162,255,209, 65,129,255,236, 56,224,  0,  1, 72,  0,  0, 20,
/* 0x0110 */  56,231,255,255,125, 41, 72, 21, 65,162,255,185,124,231, 57, 20,
/* 0x0120 */ 125, 41, 72, 21, 65,162,255,173,124,231, 57, 20,124,  9,  0, 64,
/* 0x0130 */ 125, 41, 74, 20, 65,162,255,157, 65,160,255,216, 57,  0,  0,  0,
/* 0x0140 */  52,231,255,253, 84,231, 64, 46, 65,128,  0, 32,141, 99,  0,  1,
/* 0x0150 */ 124,234, 88,249,125, 74, 14,112, 65,130,  0,  0,113,107,  0,  1,
/* 0x0160 */  65,162,  0, 80, 72,  0,  0, 20,124,  9,  0, 64,125, 41, 74, 20,
/* 0x0170 */  65,162,255, 97, 65,161,  0, 60, 57,  0,  0,  1,124,  9,  0, 64,
/* 0x0180 */ 125, 41, 74, 20, 65,162,255, 77, 65,161,  0, 40,125, 41, 72, 21,
/* 0x0190 */  65,162,255, 65,125,  8, 65, 20,124,  9,  0, 64,125, 41, 74, 20,
/* 0x01a0 */  65,162,255, 49, 65,160,255,232, 57,  8,  0,  2, 72,  0,  0, 16,
/* 0x01b0 */ 125, 41, 72, 21, 65,162,255, 29,125,  8, 65, 20, 32,234,250,255,
/* 0x01c0 */  57,  8,  0,  2,125,  8,  1,148,124,234, 42, 20,125,  9,  3,166,
/* 0x01d0 */ 141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248, 56,224,  1,  0,
/* 0x01e0 */ 124,  7, 41,236,124,  7, 26, 44, 75,255,255, 16,124,  0, 41,236,
/* 0x01f0 */ 125,168,  2,166, 40,  7,  0,  5, 64,130,  1, 36,144,166,  0,  0,
/* 0x0200 */ 124,132, 26, 20, 60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255,
/* 0x0210 */  56,165,255,255, 57, 64,255,255, 72,  0,  0,244, 57, 32,  0,  1,
/* 0x0220 */ 125, 41, 28, 44, 56, 99,  0,  4, 97, 43,  0,  1,124, 11,  0, 64,
/* 0x0230 */ 125, 41, 72, 20, 97, 41,  0,  1, 78,128,  0, 32,141,  3,  0,  1,
/* 0x0240 */ 157,  5,  0,  1,124,  9,  0, 64,125, 41, 74, 20, 65,162,255,209,
/* 0x0250 */  65,129,255,236, 56,224,  0,  1, 72,  0,  0, 20, 56,231,255,255,
/* 0x0260 */ 125, 41, 72, 21, 65,162,255,185,124,231, 57, 21,125, 41, 72, 21,
/* 0x0270 */  65,162,255,173,124,231, 57, 21,124,  9,  0, 64,125, 41, 74, 20,
/* 0x0280 */  65,162,255,157, 65,160,255,216, 57,  0,  0,  0, 52,231,255,253,
/* 0x0290 */  84,231, 64, 46, 65,128,  0, 24,141, 99,  0,  1,124,234, 88,249,
/* 0x02a0 */ 125, 74, 14,112, 65,130,  0,  0, 72,  0,  0, 12,125, 41, 72, 21,
/* 0x02b0 */  65,162,255,109,125,  8, 65, 21,125, 41, 72, 21, 65,162,255, 97,
/* 0x02c0 */ 125,  8, 65, 21, 64,130,  0, 40, 57,  0,  0,  1,125, 41, 72, 21,
/* 0x02d0 */  65,162,255, 77,125,  8, 65, 21,124,  9,  0, 64,125, 41, 74, 20,
/* 0x02e0 */  65,162,255, 61, 65,160,255,232, 57,  8,  0,  2, 32,234,250,255,
/* 0x02f0 */  57,  8,  0,  1,125,  8,  1,148,124,234, 42, 20,125,  9,  3,166,
/* 0x0300 */ 141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248, 56,224,  1,  0,
/* 0x0310 */ 124,  7, 41,236,124,  7, 26, 44, 75,255,255, 44,124,  0, 41,236,
/* 0x0320 */ 125,168,  2,166, 40,  7,  0,  2, 64,130,  0,232,144,166,  0,  0,
/* 0x0330 */ 124,132, 26, 20, 60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255,
/* 0x0340 */  56,165,255,255, 57, 64,255,255, 72,  0,  0,184,124,  9,  0, 64,
/* 0x0350 */ 125, 41, 72, 20, 76,162,  0, 32, 57, 32,  0,  1,125, 41, 28, 44,
/* 0x0360 */  56, 99,  0,  4, 97, 43,  0,  1,124, 11,  0, 64,125, 41, 73, 20,
/* 0x0370 */  78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1, 75,255,255,209,
/* 0x0380 */  65,129,255,244, 56,224,  0,  1, 75,255,255,197,124,231, 57, 21,
/* 0x0390 */  75,255,255,189, 65,160,255,244, 52,231,255,253, 57,  0,  0,  0,
/* 0x03a0 */  65,128,  0, 20,141, 99,  0,  1, 84,231, 64, 46,124,234, 88,249,
/* 0x03b0 */  65,130,  0,  0, 75,255,255,153,125,  8, 65, 21, 75,255,255,145,
/* 0x03c0 */ 125,  8, 65, 21, 56,224,  0,  1, 64,130,  0, 28, 56,224,  0,  3,
/* 0x03d0 */  57,  0,  0,  1, 75,255,255,121,125,  8, 65, 21, 75,255,255,113,
/* 0x03e0 */  65,160,255,244, 33,106,242,255,125,  8, 57, 20,124,234, 42, 20,
/* 0x03f0 */ 125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248,
/* 0x0400 */  56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44, 75,255,255,112,
/* 0x0410 */  40,  7,  0, 14, 64,130,  0, 36,148, 33,255,232,124,  8,  2,166,
/* 0x0420 */ 124,201, 51,120,129,  6,  0,  0,124,167, 43,120, 56,164,255,254,
/* 0x0430 */  56,131,  0,  2,144,  1,  0,  8,136,  3,  0,  0, 84, 11,232,254,
/* 0x0440 */  84, 12,  7,126, 56, 96,250,  0,124, 99, 88, 48, 56, 99,241,124,
/* 0x0450 */ 124, 38, 11,120,124, 33, 26, 20, 84, 33,  0, 52, 56,  0,  0,  0,
/* 0x0460 */ 124,195, 51,120,144,  9,  0,  0,148,  3,255,252,124,  1, 24, 64,
/* 0x0470 */  65,128,255,248,144,193,  0,  0,136,  4,255,255,144,225,  0,  8,
/* 0x0480 */  56,193,  0, 16,145, 33,  0, 12, 56, 97,  0, 20, 84, 11,225, 62,
/* 0x0490 */  84,  0,  7, 62,153,131,  0,  2,153, 99,  0,  1,152,  3,  0,  0,
/* 0x04a0 */ 124,  8,  2,166,148, 33,255,160,189,193,  0, 24, 59, 32,  0,  0,
/* 0x04b0 */ 125, 40,  3,166,124,206, 51,120,124,147, 35,120,144,  1,  0,100,
/* 0x04c0 */ 124,245, 59,120,125, 20, 67,120,137, 67,  0,  2, 59,  3,  0,  4,
/* 0x04d0 */  59,224,  0,  0,137, 99,  0,  1, 58,224,  0,  0, 59, 64,  0,  1,
/* 0x04e0 */ 138, 67,  0,  0, 58, 32,  0,  1, 58,  0,  0,  1,147, 38,  0,  0,
/* 0x04f0 */  57,224,  0,  1,147, 41,  0,  0, 57, 32,  3,  0,136,  3,  0,  1,
/* 0x0500 */ 124, 18,  2, 20,125, 41,  0, 48, 56,  9,  7, 54, 57, 32,  0,  1,
/* 0x0510 */ 127,153,  0, 64,125, 43, 88, 48,125, 41, 80, 48, 57,107,255,255,
/* 0x0520 */  57, 41,255,255,145, 97,  0, 12,145, 33,  0,  8, 57, 32,  0,  0,
/* 0x0530 */  64,156,  0, 28,124,  9,  3,166, 57, 96,  4,  0, 85, 32,  8, 60,
/* 0x0540 */  57, 41,  0,  1,125,120,  3, 46, 66,  0,255,244,127,147, 42, 20,
/* 0x0550 */ 126,108,155,120, 56,160,  0,  0, 57,  0,255,255, 57, 96,  0,  0,
/* 0x0560 */ 127,140,224,  0, 57,107,  0,  1, 47, 11,  0,  4, 84,169, 64, 46,
/* 0x0570 */  65,158,  8,156,136, 12,  0,  0, 57,140,  0,  1,125, 37,  3,120,
/* 0x0580 */  64,153,255,224,127,153,160, 64, 64,156,  8,100, 62,192,  0,255,
/* 0x0590 */  98,214,255,255,127,136,176, 64,128,  1,  0,  8,127, 35,  0, 56,
/* 0x05a0 */  86,224, 32, 54,124,  0, 26, 20, 84,  6,  8, 60, 65,157,  0, 32,
/* 0x05b0 */ 127,140,224,  0, 65,158,  8, 88,137, 44,  0,  0, 84,160, 64, 46,
/* 0x05c0 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,124,230,194, 46,
/* 0x05d0 */  85,  0,170,254,125, 64, 57,214,127,133, 80, 64, 64,156,  1,172,
/* 0x05e0 */ 128,  1,  0, 12, 47,151,  0,  6,125, 72, 83,120, 56, 96,  0,  1,
/* 0x05f0 */ 127, 41,  0, 56, 32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,
/* 0x0600 */ 125, 41,  2, 20, 32,  7,  8,  0, 29, 41,  6,  0,124,  0, 46,112,
/* 0x0610 */ 124,  7,  2, 20,124,  6,195, 46,125, 56, 74, 20, 56,201, 14,108,
/* 0x0620 */  64,157,  0,180,124, 26,200, 80, 63, 96,  0,255,127,245,  0,174,
/* 0x0630 */  99,123,255,255,127,136,216, 64, 87,255,  8, 60, 87,253,  5,238,
/* 0x0640 */  84,100,  8, 60, 87,160,  8, 60,127, 12,224,  0,124,  6,  2, 20,
/* 0x0650 */  84,169, 64, 46,124,224, 34, 20, 65,157,  0, 24, 65,154,  7,176,
/* 0x0660 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0670 */ 161,103,  2,  0, 85,  0,170,254, 47, 29,  0,  0,124,131, 35,120,
/* 0x0680 */ 125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,
/* 0x0690 */ 124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80,
/* 0x06a0 */  64,156,  0, 20,176,  7,  2,  0,125, 72, 83,120, 65,186,  0, 24,
/* 0x06b0 */  72,  0,  0, 28,177,103,  2,  0,124,170, 40, 80, 56,100,  0,  1,
/* 0x06c0 */  65,154,  0, 12, 47,131,  0,255, 64,157,255,108, 47,131,  0,255,
/* 0x06d0 */  65,157,  0,132, 63,224,  0,255, 99,255,255,255,127,136,248, 64,
/* 0x06e0 */  84,103,  8, 60,127, 12,224,  0, 84,169, 64, 46,124,227, 59,120,
/* 0x06f0 */  65,157,  0, 24, 65,154,  7, 24,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0700 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x0710 */ 125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,
/* 0x0720 */ 124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80,
/* 0x0730 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,
/* 0x0740 */ 124,170, 40, 80,125,102, 59, 46, 56,103,  0,  1, 47,131,  0,255,
/* 0x0750 */  64,157,255,140, 47,151,  0,  3, 84,127,  6, 62,127,249,169,174,
/* 0x0760 */  59, 57,  0,  1, 65,157,  0, 12, 58,224,  0,  0, 72,  0,  6,120,
/* 0x0770 */  47,151,  0,  9, 65,157,  0, 12, 58,247,255,253, 72,  0,  6,104,
/* 0x0780 */  58,247,255,250, 72,  0,  6, 96,125, 10, 64, 80, 84,224,217,126,
/* 0x0790 */ 127,136,176, 64,124,  0, 56, 80, 86,233,  8, 60,124,  6,195, 46,
/* 0x07a0 */ 124,170, 40, 80,124,248, 74, 20, 65,157,  0, 32,127,140,224,  0,
/* 0x07b0 */  65,158,  6, 92,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x07c0 */  57,140,  0,  1,124,  5, 75,120,161,103,  1,128, 85,  0,170,254,
/* 0x07d0 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 64, 47,151,  0,  6,
/* 0x07e0 */  32, 11,  8,  0,124,  0, 46,112,126, 15,131,120,124, 11,  2, 20,
/* 0x07f0 */ 126, 48,139,120,176,  7,  1,128,125, 72, 83,120, 56,  0,  0,  0,
/* 0x0800 */ 127, 81,211,120, 64,157,  0,  8, 56,  0,  0,  3,124, 23,  3,120,
/* 0x0810 */  56,216,  6,100, 72,  0,  2, 24,125, 10, 64, 80, 85, 96,217,126,
/* 0x0820 */ 127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,128,
/* 0x0830 */  65,157,  0, 32,127,140,224,  0, 65,158,  5,212,137, 44,  0,  0,
/* 0x0840 */  84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,
/* 0x0850 */ 161,103,  1,152, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x0860 */  64,156,  0,188,127,138,176, 64, 32, 11,  8,  0,124,  0, 46,112,
/* 0x0870 */  86,233, 40, 52,124, 11,  2, 20,125, 56, 74, 20, 84,107,  8, 60,
/* 0x0880 */ 176,  7,  1,152,125, 72, 83,120,124,233, 90, 20, 65,157,  0, 32,
/* 0x0890 */ 127,140,224,  0, 65,158,  5,120,137, 44,  0,  0, 84,160, 64, 46,
/* 0x08a0 */  85, 72, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,103,  1,224,
/* 0x08b0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 72,
/* 0x08c0 */  47,153,  0,  0, 32, 11,  8,  0,124,  0, 46,112,125, 72, 83,120,
/* 0x08d0 */ 124, 11,  2, 20,176,  7,  1,224, 65,158,  5, 52, 47,151,  0,  6,
/* 0x08e0 */  57, 32,  0,  9, 64,157,  0,  8, 57, 32,  0, 11,124, 26,200, 80,
/* 0x08f0 */ 125, 55, 75,120,127,245,  0,174,127,249,169,174, 59, 57,  0,  1,
/* 0x0900 */  72,  0,  4,228, 85, 96,217,126,124,170, 40, 80,124,  0, 88, 80,
/* 0x0910 */ 125, 10, 64, 80,176,  7,  1,224, 72,  0,  0,252,125, 10, 64, 80,
/* 0x0920 */  85, 96,217,126,127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,
/* 0x0930 */ 176,  7,  1,152, 65,157,  0, 32,127,140,224,  0, 65,158,  4,208,
/* 0x0940 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0950 */ 124,  5, 75,120,161,103,  1,176, 85,  0,170,254,125, 64, 89,214,
/* 0x0960 */ 127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,125, 72, 83,120,
/* 0x0970 */ 124,  0, 46,112,126, 41,139,120,124, 11,  2, 20,176,  7,  1,176,
/* 0x0980 */  72,  0,  0,140,125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,
/* 0x0990 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,176, 65,157,  0, 32,
/* 0x09a0 */ 127,140,224,  0, 65,158,  4,104,137, 44,  0,  0, 84,160, 64, 46,
/* 0x09b0 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,103,  1,200,
/* 0x09c0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32,
/* 0x09d0 */  32, 11,  8,  0,125, 72, 83,120,124,  0, 46,112,126,  9,131,120,
/* 0x09e0 */ 124, 11,  2, 20,176,  7,  1,200, 72,  0,  0, 32, 85, 96,217,126,
/* 0x09f0 */ 125,233,123,120,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,200,
/* 0x0a00 */ 125, 10, 64, 80,126, 15,131,120,126, 48,139,120,127, 81,211,120,
/* 0x0a10 */ 125, 58, 75,120, 47,151,  0,  6, 56,  0,  0,  8, 64,157,  0,  8,
/* 0x0a20 */  56,  0,  0, 11,124, 23,  3,120, 56,216, 10,104,127,136,176, 64,
/* 0x0a30 */  65,157,  0, 32,127,140,224,  0, 65,158,  3,212,137, 44,  0,  0,
/* 0x0a40 */  84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,
/* 0x0a50 */ 161,102,  0,  0, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x0a60 */  64,156,  0, 48, 84,105, 32, 54, 32, 11,  8,  0,125, 38, 74, 20,
/* 0x0a70 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120, 56,137,  0,  4,
/* 0x0a80 */  59, 96,  0,  0,176,  6,  0,  0, 56, 96,  0,  3, 72,  0,  0,156,
/* 0x0a90 */ 125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,124,  0, 88, 80,
/* 0x0aa0 */ 124,170, 40, 80,176,  6,  0,  0, 65,157,  0, 32,127,140,224,  0,
/* 0x0ab0 */  65,158,  3, 92,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x0ac0 */  57,140,  0,  1,124,  5, 75,120,161,102,  0,  2, 85,  0,170,254,
/* 0x0ad0 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48, 84,105, 32, 54,
/* 0x0ae0 */  32, 11,  8,  0,125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,
/* 0x0af0 */ 125, 72, 83,120, 56,137,  1,  4, 59, 96,  0,  8,176,  6,  0,  2,
/* 0x0b00 */  56, 96,  0,  3, 72,  0,  0, 36, 85, 96,217,126,124,170, 40, 80,
/* 0x0b10 */ 124,  0, 88, 80,125, 10, 64, 80,176,  6,  0,  2, 56,134,  2,  4,
/* 0x0b20 */  59, 96,  0, 16, 56, 96,  0,  8, 63,224,  0,255,124,105,  3,166,
/* 0x0b30 */  59,160,  0,  1, 99,255,255,255,127,136,248, 64, 87,167,  8, 60,
/* 0x0b40 */ 127, 12,224,  0, 84,169, 64, 46,124,253, 59,120, 65,157,  0, 24,
/* 0x0b50 */  65,154,  2,188,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0b60 */ 125, 37,  3,120,125,100, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x0b70 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x0b80 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,
/* 0x0b90 */ 125, 72, 83,120,124,  4, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x0ba0 */  59,167,  0,  1,125,100, 59, 46, 66,  0,255,144, 47,151,  0,  3,
/* 0x0bb0 */  56,  0,  0,  1,124,  0, 24, 48,127,160,232, 80,127,189,218, 20,
/* 0x0bc0 */  65,157,  1,232, 47,157,  0,  3, 58,247,  0,  7,127,169,235,120,
/* 0x0bd0 */  64,157,  0,  8, 57, 32,  0,  3, 85, 41, 56, 48, 63,224,  0,255,
/* 0x0be0 */ 125, 56, 74, 20, 99,255,255,255, 56,201,  3, 96, 57, 32,  0,  6,
/* 0x0bf0 */ 125, 41,  3,166, 56,128,  0,  1,127,136,248, 64, 84,135,  8, 60,
/* 0x0c00 */ 127, 12,224,  0, 84,169, 64, 46,124,228, 59,120, 65,157,  0, 24,
/* 0x0c10 */  65,154,  1,252,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0c20 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x0c30 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x0c40 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,
/* 0x0c50 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x0c60 */  56,135,  0,  1,125,102, 59, 46, 66,  0,255,144, 56,132,255,192,
/* 0x0c70 */  47,132,  0,  3,124,154, 35,120, 64,157,  1, 40, 47,132,  0, 13,
/* 0x0c80 */ 124,137, 14,112, 84,128,  7,254, 57,105,255,255, 96, 26,  0,  2,
/* 0x0c90 */ 125,105,  3,166, 65,157,  0, 32,127, 90, 88, 48, 84,128,  8, 60,
/* 0x0ca0 */  87, 73,  8, 60,125, 56, 74, 20,125, 32, 72, 80, 56,201,  5, 94,
/* 0x0cb0 */  72,  0,  0,100, 57, 41,255,251, 61, 96,  0,255,125, 41,  3,166,
/* 0x0cc0 */  97,107,255,255,127,136, 88, 64,127, 12,224,  0, 84,169, 64, 46,
/* 0x0cd0 */  87, 90,  8, 60, 65,157,  0, 24, 65,154,  1, 52,136, 12,  0,  0,
/* 0x0ce0 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120, 85,  8,248,126,
/* 0x0cf0 */ 127,133, 64, 64, 65,156,  0, 12,124,168, 40, 80, 99, 90,  0,  1,
/* 0x0d00 */  66,  0,255,196, 56,  0,  0,  4, 87, 90, 32, 54,124,  9,  3,166,
/* 0x0d10 */  56,216,  6, 68, 60, 96,  0,255, 56,128,  0,  1, 96, 99,255,255,
/* 0x0d20 */  59,224,  0,  1,127,136, 24, 64, 87,231,  8, 60,127, 12,224,  0,
/* 0x0d30 */  84,169, 64, 46,124,255, 59,120, 65,157,  0, 24, 65,154,  0,208,
/* 0x0d40 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0d50 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x0d60 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x0d70 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x0d80 */ 124,  6, 59, 46, 72,  0,  0, 20,124,170, 40, 80, 59,231,  0,  1,
/* 0x0d90 */ 125,102, 59, 46,127, 90, 35,120, 84,132,  8, 60, 66,  0,255,136,
/* 0x0da0 */  55, 90,  0,  1, 65,130,  0, 72,127,154,200, 64, 59,189,  0,  2,
/* 0x0db0 */  65,157,  0, 92,124, 26,200, 80, 59,189,255,255,127,245,  0,174,
/* 0x0dc0 */  49,125,255,255,125, 43,233, 16,127,249,169,174, 59, 57,  0,  1,
/* 0x0dd0 */ 124, 20,200, 16,124,  0,  1, 16,124,  0,  0,208,125, 43,  0, 57,
/* 0x0de0 */  64,130,255,212,127,153,160, 64, 65,156,247,172, 60,  0,  0,255,
/* 0x0df0 */  96,  0,255,255,127,136,  0, 64, 65,157,  0, 32,127,140,224,  0,
/* 0x0e00 */  56, 96,  0,  1, 65,158,  0, 40, 72,  0,  0, 12, 56, 96,  0,  1,
/* 0x0e10 */  72,  0,  0, 28, 57,140,  0,  1,125, 40,  2,166,124, 19, 96, 80,
/* 0x0e20 */  56, 96,  0,  0,144, 14,  0,  0,147, 41,  0,  0,128,  1,  0,100,
/* 0x0e30 */ 185,193,  0, 24, 56, 33,  0, 96,124,  8,  3,166,124,  8,  2,166,
/* 0x0e40 */ 148, 33,255,160,189,193,  0, 24, 59, 32,  0,  0,125, 40,  3,166,
/* 0x0e50 */ 124,206, 51,120,124,147, 35,120,144,  1,  0,100,124,245, 59,120,
/* 0x0e60 */ 125, 20, 67,120,137, 67,  0,  2, 59,  3,  0,  4, 59,224,  0,  0,
/* 0x0e70 */ 137, 99,  0,  1, 58,224,  0,  0, 59, 64,  0,  1,138, 67,  0,  0,
/* 0x0e80 */  58, 32,  0,  1, 58,  0,  0,  1,147, 38,  0,  0, 57,224,  0,  1,
/* 0x0e90 */ 147, 41,  0,  0, 57, 32,  3,  0,136,  3,  0,  1,124, 18,  2, 20,
/* 0x0ea0 */ 125, 41,  0, 48, 56,  9,  7, 54, 57, 32,  0,  1,127,153,  0, 64,
/* 0x0eb0 */ 125, 43, 88, 48,125, 41, 80, 48, 57,107,255,255, 57, 41,255,255,
/* 0x0ec0 */ 145, 97,  0, 12,145, 33,  0,  8, 57, 32,  0,  0, 64,156,  0, 28,
/* 0x0ed0 */ 124,  9,  3,166, 57, 96,  4,  0, 85, 32,  8, 60, 57, 41,  0,  1,
/* 0x0ee0 */ 125,120,  3, 46, 66,  0,255,244,127,147, 42, 20,126,108,155,120,
/* 0x0ef0 */  56,160,  0,  0, 57,  0,255,255, 57, 96,  0,  0,127,140,224,  0,
/* 0x0f00 */  57,107,  0,  1, 47, 11,  0,  4, 84,169, 64, 46, 65,158,  8,156,
/* 0x0f10 */ 136, 12,  0,  0, 57,140,  0,  1,125, 37,  3,120, 64,153,255,224,
/* 0x0f20 */ 127,153,160, 64, 64,156,  8,100, 62,192,  0,255, 98,214,255,255,
/* 0x0f30 */ 127,136,176, 64,128,  1,  0,  8,127, 35,  0, 56, 86,224, 32, 54,
/* 0x0f40 */ 124,  0, 26, 20, 84,  6,  8, 60, 65,157,  0, 32,127,140,224,  0,
/* 0x0f50 */  65,158,  8, 88,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x0f60 */  57,140,  0,  1,124,  5, 75,120,124,230,194, 46, 85,  0,170,254,
/* 0x0f70 */ 125, 64, 57,214,127,133, 80, 64, 64,156,  1,172,128,  1,  0, 12,
/* 0x0f80 */  47,151,  0,  6,125, 72, 83,120, 56, 96,  0,  1,127, 41,  0, 56,
/* 0x0f90 */  32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,125, 41,  2, 20,
/* 0x0fa0 */  32,  7,  8,  0, 29, 41,  6,  0,124,  0, 46,112,124,  7,  2, 20,
/* 0x0fb0 */ 124,  6,195, 46,125, 56, 74, 20, 56,201, 14,108, 64,157,  0,180,
/* 0x0fc0 */ 124, 26,200, 80, 63, 96,  0,255,127,245,  0,174, 99,123,255,255,
/* 0x0fd0 */ 127,136,216, 64, 87,255,  8, 60, 87,253,  5,238, 84,100,  8, 60,
/* 0x0fe0 */  87,160,  8, 60,127, 12,224,  0,124,  6,  2, 20, 84,169, 64, 46,
/* 0x0ff0 */ 124,224, 34, 20, 65,157,  0, 24, 65,154,  7,176,136, 12,  0,  0,
/* 0x1000 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,161,103,  2,  0,
/* 0x1010 */  85,  0,170,254, 47, 29,  0,  0,124,131, 35,120,125, 64, 89,214,
/* 0x1020 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x1030 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 20,
/* 0x1040 */ 176,  7,  2,  0,125, 72, 83,120, 65,186,  0, 24, 72,  0,  0, 28,
/* 0x1050 */ 177,103,  2,  0,124,170, 40, 80, 56,100,  0,  1, 65,154,  0, 12,
/* 0x1060 */  47,131,  0,255, 64,157,255,108, 47,131,  0,255, 65,157,  0,132,
/* 0x1070 */  63,224,  0,255, 99,255,255,255,127,136,248, 64, 84,103,  8, 60,
/* 0x1080 */ 127, 12,224,  0, 84,169, 64, 46,124,227, 59,120, 65,157,  0, 24,
/* 0x1090 */  65,154,  7, 24,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x10a0 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x10b0 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x10c0 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,
/* 0x10d0 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x10e0 */ 125,102, 59, 46, 56,103,  0,  1, 47,131,  0,255, 64,157,255,140,
/* 0x10f0 */  47,151,  0,  3, 84,127,  6, 62,127,249,169,174, 59, 57,  0,  1,
/* 0x1100 */  65,157,  0, 12, 58,224,  0,  0, 72,  0,  6,120, 47,151,  0,  9,
/* 0x1110 */  65,157,  0, 12, 58,247,255,253, 72,  0,  6,104, 58,247,255,250,
/* 0x1120 */  72,  0,  6, 96,125, 10, 64, 80, 84,224,217,126,127,136,176, 64,
/* 0x1130 */ 124,  0, 56, 80, 86,233,  8, 60,124,  6,195, 46,124,170, 40, 80,
/* 0x1140 */ 124,248, 74, 20, 65,157,  0, 32,127,140,224,  0, 65,158,  6, 92,
/* 0x1150 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1160 */ 124,  5, 75,120,161,103,  1,128, 85,  0,170,254,125, 64, 89,214,
/* 0x1170 */ 127,133, 80, 64, 64,156,  0, 64, 47,151,  0,  6, 32, 11,  8,  0,
/* 0x1180 */ 124,  0, 46,112,126, 15,131,120,124, 11,  2, 20,126, 48,139,120,
/* 0x1190 */ 176,  7,  1,128,125, 72, 83,120, 56,  0,  0,  0,127, 81,211,120,
/* 0x11a0 */  64,157,  0,  8, 56,  0,  0,  3,124, 23,  3,120, 56,216,  6,100,
/* 0x11b0 */  72,  0,  2, 24,125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,
/* 0x11c0 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,128, 65,157,  0, 32,
/* 0x11d0 */ 127,140,224,  0, 65,158,  5,212,137, 44,  0,  0, 84,160, 64, 46,
/* 0x11e0 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,103,  1,152,
/* 0x11f0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0,188,
/* 0x1200 */ 127,138,176, 64, 32, 11,  8,  0,124,  0, 46,112, 86,233, 40, 52,
/* 0x1210 */ 124, 11,  2, 20,125, 56, 74, 20, 84,107,  8, 60,176,  7,  1,152,
/* 0x1220 */ 125, 72, 83,120,124,233, 90, 20, 65,157,  0, 32,127,140,224,  0,
/* 0x1230 */  65,158,  5,120,137, 44,  0,  0, 84,160, 64, 46, 85, 72, 64, 46,
/* 0x1240 */  57,140,  0,  1,124,  5, 75,120,161,103,  1,224, 85,  0,170,254,
/* 0x1250 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 72, 47,153,  0,  0,
/* 0x1260 */  32, 11,  8,  0,124,  0, 46,112,125, 72, 83,120,124, 11,  2, 20,
/* 0x1270 */ 176,  7,  1,224, 65,158,  5, 52, 47,151,  0,  6, 57, 32,  0,  9,
/* 0x1280 */  64,157,  0,  8, 57, 32,  0, 11,124, 26,200, 80,125, 55, 75,120,
/* 0x1290 */ 127,245,  0,174,127,249,169,174, 59, 57,  0,  1, 72,  0,  4,228,
/* 0x12a0 */  85, 96,217,126,124,170, 40, 80,124,  0, 88, 80,125, 10, 64, 80,
/* 0x12b0 */ 176,  7,  1,224, 72,  0,  0,252,125, 10, 64, 80, 85, 96,217,126,
/* 0x12c0 */ 127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,152,
/* 0x12d0 */  65,157,  0, 32,127,140,224,  0, 65,158,  4,208,137, 44,  0,  0,
/* 0x12e0 */  84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,
/* 0x12f0 */ 161,103,  1,176, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x1300 */  64,156,  0, 32, 32, 11,  8,  0,125, 72, 83,120,124,  0, 46,112,
/* 0x1310 */ 126, 41,139,120,124, 11,  2, 20,176,  7,  1,176, 72,  0,  0,140,
/* 0x1320 */ 125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,124,  0, 88, 80,
/* 0x1330 */ 124,170, 40, 80,176,  7,  1,176, 65,157,  0, 32,127,140,224,  0,
/* 0x1340 */  65,158,  4,104,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x1350 */  57,140,  0,  1,124,  5, 75,120,161,103,  1,200, 85,  0,170,254,
/* 0x1360 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,
/* 0x1370 */ 125, 72, 83,120,124,  0, 46,112,126,  9,131,120,124, 11,  2, 20,
/* 0x1380 */ 176,  7,  1,200, 72,  0,  0, 32, 85, 96,217,126,125,233,123,120,
/* 0x1390 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,200,125, 10, 64, 80,
/* 0x13a0 */ 126, 15,131,120,126, 48,139,120,127, 81,211,120,125, 58, 75,120,
/* 0x13b0 */  47,151,  0,  6, 56,  0,  0,  8, 64,157,  0,  8, 56,  0,  0, 11,
/* 0x13c0 */ 124, 23,  3,120, 56,216, 10,104,127,136,176, 64, 65,157,  0, 32,
/* 0x13d0 */ 127,140,224,  0, 65,158,  3,212,137, 44,  0,  0, 84,160, 64, 46,
/* 0x13e0 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,102,  0,  0,
/* 0x13f0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48,
/* 0x1400 */  84,105, 32, 54, 32, 11,  8,  0,125, 38, 74, 20,124,  0, 46,112,
/* 0x1410 */ 124, 11,  2, 20,125, 72, 83,120, 56,137,  0,  4, 59, 96,  0,  0,
/* 0x1420 */ 176,  6,  0,  0, 56, 96,  0,  3, 72,  0,  0,156,125, 10, 64, 80,
/* 0x1430 */  85, 96,217,126,127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,
/* 0x1440 */ 176,  6,  0,  0, 65,157,  0, 32,127,140,224,  0, 65,158,  3, 92,
/* 0x1450 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1460 */ 124,  5, 75,120,161,102,  0,  2, 85,  0,170,254,125, 64, 89,214,
/* 0x1470 */ 127,133, 80, 64, 64,156,  0, 48, 84,105, 32, 54, 32, 11,  8,  0,
/* 0x1480 */ 125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x1490 */  56,137,  1,  4, 59, 96,  0,  8,176,  6,  0,  2, 56, 96,  0,  3,
/* 0x14a0 */  72,  0,  0, 36, 85, 96,217,126,124,170, 40, 80,124,  0, 88, 80,
/* 0x14b0 */ 125, 10, 64, 80,176,  6,  0,  2, 56,134,  2,  4, 59, 96,  0, 16,
/* 0x14c0 */  56, 96,  0,  8, 63,224,  0,255,124,105,  3,166, 59,160,  0,  1,
/* 0x14d0 */  99,255,255,255,127,136,248, 64, 87,167,  8, 60,127, 12,224,  0,
/* 0x14e0 */  84,169, 64, 46,124,253, 59,120, 65,157,  0, 24, 65,154,  2,188,
/* 0x14f0 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x1500 */ 125,100, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x1510 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x1520 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x1530 */ 124,  4, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 59,167,  0,  1,
/* 0x1540 */ 125,100, 59, 46, 66,  0,255,144, 47,151,  0,  3, 56,  0,  0,  1,
/* 0x1550 */ 124,  0, 24, 48,127,160,232, 80,127,189,218, 20, 65,157,  1,232,
/* 0x1560 */  47,157,  0,  3, 58,247,  0,  7,127,169,235,120, 64,157,  0,  8,
/* 0x1570 */  57, 32,  0,  3, 85, 41, 56, 48, 63,224,  0,255,125, 56, 74, 20,
/* 0x1580 */  99,255,255,255, 56,201,  3, 96, 57, 32,  0,  6,125, 41,  3,166,
/* 0x1590 */  56,128,  0,  1,127,136,248, 64, 84,135,  8, 60,127, 12,224,  0,
/* 0x15a0 */  84,169, 64, 46,124,228, 59,120, 65,157,  0, 24, 65,154,  1,252,
/* 0x15b0 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x15c0 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x15d0 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x15e0 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x15f0 */ 124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 56,135,  0,  1,
/* 0x1600 */ 125,102, 59, 46, 66,  0,255,144, 56,132,255,192, 47,132,  0,  3,
/* 0x1610 */ 124,154, 35,120, 64,157,  1, 40, 47,132,  0, 13,124,137, 14,112,
/* 0x1620 */  84,128,  7,254, 57,105,255,255, 96, 26,  0,  2,125,105,  3,166,
/* 0x1630 */  65,157,  0, 32,127, 90, 88, 48, 84,128,  8, 60, 87, 73,  8, 60,
/* 0x1640 */ 125, 56, 74, 20,125, 32, 72, 80, 56,201,  5, 94, 72,  0,  0,100,
/* 0x1650 */  57, 41,255,251, 61, 96,  0,255,125, 41,  3,166, 97,107,255,255,
/* 0x1660 */ 127,136, 88, 64,127, 12,224,  0, 84,169, 64, 46, 87, 90,  8, 60,
/* 0x1670 */  65,157,  0, 24, 65,154,  1, 52,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x1680 */  57,140,  0,  1,125, 37,  3,120, 85,  8,248,126,127,133, 64, 64,
/* 0x1690 */  65,156,  0, 12,124,168, 40, 80, 99, 90,  0,  1, 66,  0,255,196,
/* 0x16a0 */  56,  0,  0,  4, 87, 90, 32, 54,124,  9,  3,166, 56,216,  6, 68,
/* 0x16b0 */  60, 96,  0,255, 56,128,  0,  1, 96, 99,255,255, 59,224,  0,  1,
/* 0x16c0 */ 127,136, 24, 64, 87,231,  8, 60,127, 12,224,  0, 84,169, 64, 46,
/* 0x16d0 */ 124,255, 59,120, 65,157,  0, 24, 65,154,  0,208,136, 12,  0,  0,
/* 0x16e0 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x16f0 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,
/* 0x1700 */ 124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,
/* 0x1710 */ 125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x1720 */  72,  0,  0, 20,124,170, 40, 80, 59,231,  0,  1,125,102, 59, 46,
/* 0x1730 */ 127, 90, 35,120, 84,132,  8, 60, 66,  0,255,136, 55, 90,  0,  1,
/* 0x1740 */  65,130,  0, 72,127,154,200, 64, 59,189,  0,  2, 65,157,  0, 92,
/* 0x1750 */ 124, 26,200, 80, 59,189,255,255,127,245,  0,174, 49,125,255,255,
/* 0x1760 */ 125, 43,233, 16,127,249,169,174, 59, 57,  0,  1,124, 20,200, 16,
/* 0x1770 */ 124,  0,  1, 16,124,  0,  0,208,125, 43,  0, 57, 64,130,255,212,
/* 0x1780 */ 127,153,160, 64, 65,156,247,172, 60,  0,  0,255, 96,  0,255,255,
/* 0x1790 */ 127,136,  0, 64, 65,157,  0, 32,127,140,224,  0, 56, 96,  0,  1,
/* 0x17a0 */  65,158,  0, 40, 72,  0,  0, 12, 56, 96,  0,  1, 72,  0,  0, 28,
/* 0x17b0 */  57,140,  0,  1,125, 40,  2,166,124, 19, 96, 80, 56, 96,  0,  0,
/* 0x17c0 */ 144, 14,  0,  0,147, 41,  0,  0,128,  1,  0,100,185,193,  0, 24,
/* 0x17d0 */  56, 33,  0, 96,124,  8,  3,166,128,161,  0, 12,128,225,  0,  8,
/* 0x17e0 */ 128,165,  0,  0,128, 33,  0,  0,124,165, 58, 20,128,  1,  0,  8,
/* 0x17f0 */  56,165,255,255,128, 33,  0,  0,124,  8,  3,166,128,230,  0,  0,
/* 0x1800 */ 125,168,  3,166,124,100, 24, 80,124,135, 40, 80, 56, 99,  0,  1,
/* 0x1810 */  56,132,  0,  1,144,134,  0,  0, 96,231,  0, 31,124,  0, 56,108,
/* 0x1820 */ 124,  7, 40, 64,124,  0, 63,172, 56,231,  0, 32, 65,128,255,240,
/* 0x1830 */ 124,  0,  4,172, 76,  0,  1, 44, 78,128,  0, 32,125,136,  2,166,
/* 0x1840 */ 128,140,  0, 12,124,137,  3,166,128,204,  0,  8,136,236,  0, 16,
/* 0x1850 */ 124,164, 98, 20, 56,165,  0, 16,124,102, 98, 20, 56, 99,  0,192,
/* 0x1860 */ 140,  5,255,255,156,  3,255,255, 66,  0,255,248,127,233,  3,166,
/* 0x1870 */  56,172,  0,128,144,193,255,252, 56,193,255,252,148, 33,255,232,
/* 0x1880 */  78,128,  4, 32,127,232,  2,166, 75,255,255,181, 72,  0,  0,128,
/* 0x1890 */   0,  0,  0,  0,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x18a0 */ 101,108,102, 51, 50, 45,112,111,119,101,114,112, 99, 10, 10, 83,
/* 0x18b0 */ 101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,
/* 0x18c0 */ 101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32,
/* 0x18d0 */  32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x18e0 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,
/* 0x18f0 */ 102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32,
/* 0x1900 */  32, 48, 32, 80, 80, 67, 51, 50, 66, 88, 88, 32, 32, 32, 32, 32,
/* 0x1910 */  32, 48, 54, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32,
/* 0x1920 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1930 */  32, 32, 49, 32, 77, 65, 67, 77, 65, 73, 78, 88, 32, 32, 32, 32,
/* 0x1940 */  32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 99, 32,
/* 0x1950 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1960 */  32, 32, 50, 32, 77, 65, 67, 72, 95, 85, 78, 67, 32, 32, 32, 32,
/* 0x1970 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 48, 32, 32,
/* 0x1980 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1990 */  32, 51, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x19a0 */  32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 48, 32, 32, 50,
/* 0x19b0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x19c0 */  52, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x19d0 */  48, 49, 52, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 48, 32,
/* 0x19e0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x19f0 */  32, 32, 53, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32,
/* 0x1a00 */  32, 32, 48, 49, 51, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x1a10 */ 101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1a20 */  84, 83, 10, 32, 32, 54, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32,
/* 0x1a30 */  32, 32, 32, 32, 32, 48,102, 52, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1a40 */  48, 51, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1a50 */  69, 78, 84, 83, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x1a60 */  70, 48, 48, 32, 32, 32, 32, 48, 57, 48, 32, 32, 48, 32, 32, 48,
/* 0x1a70 */  32, 32, 48, 52, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1a80 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 76, 90, 77, 65, 95,
/* 0x1a90 */  68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 57, 57, 99, 32, 32, 48,
/* 0x1aa0 */  32, 32, 48, 32, 32, 48, 52, 97, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x1ab0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76, 90,
/* 0x1ac0 */  77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 57, 57, 99,
/* 0x1ad0 */  32, 32, 48, 32, 32, 48, 32, 32, 48,101, 51, 99, 32, 32, 50, 42,
/* 0x1ae0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48,
/* 0x1af0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48,
/* 0x1b00 */  50, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 55,100, 56, 32,
/* 0x1b10 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1b20 */  32, 49, 49, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32,
/* 0x1b30 */  32, 32, 48, 49, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 55,
/* 0x1b40 */ 102, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1b50 */  84, 83, 10, 32, 49, 50, 32, 67, 70, 76, 85, 83, 72, 32, 32, 32,
/* 0x1b60 */  32, 32, 32, 32, 32, 48, 50, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1b70 */  48, 49, 56, 49, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1b80 */  84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 77, 65, 67, 72, 77, 65,
/* 0x1b90 */  73, 78, 89, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48,
/* 0x1ba0 */  32, 32, 48, 49, 56, 51, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1bb0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 52, 32, 77, 65, 67, 72,
/* 0x1bc0 */  77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 48, 53, 56, 32, 32, 48,
/* 0x1bd0 */  32, 32, 48, 32, 32, 48, 49, 56, 51, 99, 32, 32, 50, 42, 42, 48,
/* 0x1be0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79,
/* 0x1bf0 */  76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c00 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x1c10 */  69, 67, 51, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x1c20 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1c30 */ 100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 48, 32, 78, 82,
/* 0x1c40 */  86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c50 */ 108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78,
/* 0x1c60 */  90, 32, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x1c70 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x1c80 */  80, 67, 51, 50, 66, 88, 88, 32, 48, 32, 80, 80, 67, 51, 50, 66,
/* 0x1c90 */  88, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1ca0 */  32,100, 32, 32, 77, 65, 67, 77, 65, 73, 78, 88, 32, 48, 32, 77,
/* 0x1cb0 */  65, 67, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cc0 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72, 95, 85, 78,
/* 0x1cd0 */  67, 32, 48, 32, 77, 65, 67, 72, 95, 85, 78, 67, 10, 48, 48, 48,
/* 0x1ce0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,
/* 0x1cf0 */  86, 95, 72, 69, 65, 68, 32, 48, 32, 78, 82, 86, 95, 72, 69, 65,
/* 0x1d00 */  68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1d10 */ 100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32, 78, 82, 86, 50, 69,
/* 0x1d20 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1d30 */  32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10,
/* 0x1d40 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x1d50 */  32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x1d60 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1d70 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77,
/* 0x1d80 */  65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d90 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1da0 */  67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x1db0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1dc0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76,
/* 0x1dd0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x1de0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 70, 76, 85, 83,
/* 0x1df0 */  72, 32, 48, 32, 67, 70, 76, 85, 83, 72, 10, 48, 48, 48, 48, 48,
/* 0x1e00 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72,
/* 0x1e10 */  77, 65, 73, 78, 89, 32, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78,
/* 0x1e20 */  89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32,
/* 0x1e30 */  32, 32, 32, 77, 65, 67, 77, 65, 73, 78, 88, 32, 48, 32, 95,115,
/* 0x1e40 */ 116, 97,114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x1e50 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 77, 65,
/* 0x1e60 */  67, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1e70 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e80 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1e90 */  48, 48, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x1ea0 */  32, 32, 32, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 43, 48,
/* 0x1eb0 */ 120, 48, 48, 48, 48, 48, 48, 52, 56, 10, 10, 82, 69, 76, 79, 67,
/* 0x1ec0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x1ed0 */  82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x1ee0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ef0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x1f00 */  48, 48, 98, 56, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 49, 52,
/* 0x1f10 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10,
/* 0x1f20 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x1f30 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58,
/* 0x1f40 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x1f50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x1f60 */  69, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 80, 80, 67,
/* 0x1f70 */  95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1f80 */  95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1f90 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x1fa0 */  82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x1fb0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1fc0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 57, 52,
/* 0x1fd0 */  32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32,
/* 0x1fe0 */  32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76,
/* 0x1ff0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x2000 */  70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93,
/* 0x2010 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x2020 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x2030 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80,
/* 0x2040 */  67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2050 */  77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48, 48,
/* 0x2060 */  48, 50, 52, 10
};
