; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=loop-fusion < %s | FileCheck %s
;
;    int A[1024][1024];
;    int B[1024][1024];
;
;    #define EXPENSIVE_PURE_COMPUTATION(i) ((i - 3) * (i + 3) % i)
;
;    void dep_free() {
;
;      for (int i = 0; i < 100; i++)
;        for (int j = 0; j < 100; j++)
;          A[i][j] = EXPENSIVE_PURE_COMPUTATION(i);
;
;      for (int i = 0; i < 100; i++)
;        for (int j = 0; j < 100; j++)
;          B[i][j] = EXPENSIVE_PURE_COMPUTATION(i);
;    }
;
@A = common global [1024 x [1024 x i32]] zeroinitializer, align 16
@B = common global [1024 x [1024 x i32]] zeroinitializer, align 16


; TODO: The current version of loop fusion does not allow the inner loops to be
; fused because they are not control flow equivalent and adjacent. These are
; limitations that can be addressed in future improvements to fusion.
define void @dep_free() {
; CHECK-LABEL: define void @dep_free() {
; CHECK-NEXT:  [[BB:.*]]:
; CHECK-NEXT:    br label %[[BB16:.*]]
; CHECK:       [[BB16]]:
; CHECK-NEXT:    [[DOT06:%.*]] = phi i32 [ 0, %[[BB]] ], [ [[ADD_OUTER_FC0:%.*]], %[[BB45:.*]] ]
; CHECK-NEXT:    [[INDVARS_IV105:%.*]] = phi i64 [ 0, %[[BB]] ], [ [[INC_OUTER_FC0:%.*]], %[[BB45]] ]
; CHECK-NEXT:    [[DOT023:%.*]] = phi i32 [ 0, %[[BB]] ], [ [[TMP46:%.*]], %[[BB45]] ]
; CHECK-NEXT:    [[INDVARS_IV42:%.*]] = phi i64 [ 0, %[[BB]] ], [ [[INDVARS_IV_NEXT5:%.*]], %[[BB45]] ]
; CHECK-NEXT:    br label %[[BB18:.*]]
; CHECK:       [[BB18]]:
; CHECK-NEXT:    [[INDVARS_IV74:%.*]] = phi i64 [ 0, %[[BB16]] ], [ [[INDVARS_IV_NEXT8:%.*]], %[[BB43:.*]] ]
; CHECK-NEXT:    [[INDVARS_IV1:%.*]] = phi i64 [ 0, %[[BB16]] ], [ [[INDVARS_IV_NEXT:%.*]], %[[BB43]] ]
; CHECK-NEXT:    [[TMP:%.*]] = add nsw i32 [[DOT06]], -3
; CHECK-NEXT:    [[TMP19:%.*]] = add nuw nsw i64 [[INDVARS_IV105]], 3
; CHECK-NEXT:    [[TMP20:%.*]] = trunc i64 [[TMP19]] to i32
; CHECK-NEXT:    [[TMP21:%.*]] = mul nsw i32 [[TMP]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = trunc i64 [[INDVARS_IV105]] to i32
; CHECK-NEXT:    [[TMP23:%.*]] = srem i32 [[TMP21]], [[TMP22]]
; CHECK-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [1024 x [1024 x i32]], ptr @A, i64 0, i64 [[INDVARS_IV105]], i64 [[INDVARS_IV74]]
; CHECK-NEXT:    store i32 [[TMP23]], ptr [[TMP24]], align 4
; CHECK-NEXT:    br label %[[BB25:.*]]
; CHECK:       [[BB25]]:
; CHECK-NEXT:    [[TMP36:%.*]] = add nsw i32 [[DOT023]], -3
; CHECK-NEXT:    [[TMP37:%.*]] = add nuw nsw i64 [[INDVARS_IV42]], 3
; CHECK-NEXT:    [[TMP38:%.*]] = trunc i64 [[TMP37]] to i32
; CHECK-NEXT:    [[TMP39:%.*]] = mul nsw i32 [[TMP36]], [[TMP38]]
; CHECK-NEXT:    [[TMP40:%.*]] = trunc i64 [[INDVARS_IV42]] to i32
; CHECK-NEXT:    [[TMP41:%.*]] = srem i32 [[TMP39]], [[TMP40]]
; CHECK-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [1024 x [1024 x i32]], ptr @B, i64 0, i64 [[INDVARS_IV42]], i64 [[INDVARS_IV1]]
; CHECK-NEXT:    store i32 [[TMP41]], ptr [[TMP42]], align 4
; CHECK-NEXT:    br label %[[BB43]]
; CHECK:       [[BB31:.*]]:
; CHECK-NEXT:    br label %[[BB47:.*]]
; CHECK:       [[BB43]]:
; CHECK-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV74]], 1
; CHECK-NEXT:    [[EXITCOND9:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT8]], 100
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV1]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT]], 100
; CHECK-NEXT:    br i1 [[EXITCOND]], label %[[BB18]], label %[[BB45]]
; CHECK:       [[BB45]]:
; CHECK-NEXT:    [[INC_OUTER_FC0]] = add nuw nsw i64 [[INDVARS_IV105]], 1
; CHECK-NEXT:    [[ADD_OUTER_FC0]] = add nuw nsw i32 [[DOT06]], 1
; CHECK-NEXT:    [[CMP_OUTER_FC0:%.*]] = icmp ne i64 [[INC_OUTER_FC0]], 100
; CHECK-NEXT:    [[INDVARS_IV_NEXT5]] = add nuw nsw i64 [[INDVARS_IV42]], 1
; CHECK-NEXT:    [[TMP46]] = add nuw nsw i32 [[DOT023]], 1
; CHECK-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT5]], 100
; CHECK-NEXT:    br i1 [[EXITCOND6]], label %[[BB16]], label %[[BB31]]
; CHECK:       [[BB47]]:
; CHECK-NEXT:    ret void
;
bb:
  br label %bb16

bb16:                                   ; preds = %bb, %bb27
  %.06 = phi i32 [ 0, %bb ], [ %add.outer.fc0, %bb27 ]
  %indvars.iv105 = phi i64 [ 0, %bb ], [ %inc.outer.fc0, %bb27 ]
  br label %bb18

bb30:                                   ; preds = %bb27
  br label %bb33

bb18:                                             ; preds = %bb16, %bb25
  %indvars.iv74 = phi i64 [ 0, %bb16 ], [ %indvars.iv.next8, %bb25 ]
  %tmp = add nsw i32 %.06, -3
  %tmp19 = add nuw nsw i64 %indvars.iv105, 3
  %tmp20 = trunc i64 %tmp19 to i32
  %tmp21 = mul nsw i32 %tmp, %tmp20
  %tmp22 = trunc i64 %indvars.iv105 to i32
  %tmp23 = srem i32 %tmp21, %tmp22
  %tmp24 = getelementptr inbounds [1024 x [1024 x i32]], ptr @A, i64 0, i64 %indvars.iv105, i64 %indvars.iv74
  store i32 %tmp23, ptr %tmp24, align 4
  br label %bb25

bb25:                                             ; preds = %bb18
  %indvars.iv.next8 = add nuw nsw i64 %indvars.iv74, 1
  %exitcond9 = icmp ne i64 %indvars.iv.next8, 100
  br i1 %exitcond9, label %bb18, label %bb27

bb27:                                             ; preds = %bb25
  %inc.outer.fc0 = add nuw nsw i64 %indvars.iv105, 1
  %add.outer.fc0 = add nuw nsw i32 %.06, 1
  %cmp.outer.fc0 = icmp ne i64 %inc.outer.fc0, 100
  br i1 %cmp.outer.fc0, label %bb16, label %bb30

bb33:                                   ; preds = %bb30, %bb45
  %.023 = phi i32 [ 0, %bb30 ], [ %tmp46, %bb45 ]
  %indvars.iv42 = phi i64 [ 0, %bb30 ], [ %indvars.iv.next5, %bb45 ]
  br label %bb35

bb31:                                             ; preds = %bb45
  br label %bb47

bb35:                                             ; preds = %bb33, %bb43
  %indvars.iv1 = phi i64 [ 0, %bb33 ], [ %indvars.iv.next, %bb43 ]
  %tmp36 = add nsw i32 %.023, -3
  %tmp37 = add nuw nsw i64 %indvars.iv42, 3
  %tmp38 = trunc i64 %tmp37 to i32
  %tmp39 = mul nsw i32 %tmp36, %tmp38
  %tmp40 = trunc i64 %indvars.iv42 to i32
  %tmp41 = srem i32 %tmp39, %tmp40
  %tmp42 = getelementptr inbounds [1024 x [1024 x i32]], ptr @B, i64 0, i64 %indvars.iv42, i64 %indvars.iv1
  store i32 %tmp41, ptr %tmp42, align 4
  br label %bb43

bb43:                                             ; preds = %bb35
  %indvars.iv.next = add nuw nsw i64 %indvars.iv1, 1
  %exitcond = icmp ne i64 %indvars.iv.next, 100
  br i1 %exitcond, label %bb35, label %bb45

bb45:                                             ; preds = %bb43
  %indvars.iv.next5 = add nuw nsw i64 %indvars.iv42, 1
  %tmp46 = add nuw nsw i32 %.023, 1
  %exitcond6 = icmp ne i64 %indvars.iv.next5, 100
  br i1 %exitcond6, label %bb33, label %bb31

bb47:                                             ; preds = %bb31
  ret void
}
