; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -O1 -mcpu=atom -mtriple=i686-linux  | FileCheck %s

declare void @external_function(...)

define i32 @test_return_val(i32 %a) nounwind {
; CHECK-LABEL: test_return_val:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    retl
  ret i32 %a
}

define i32 @test_optsize(i32 %a) nounwind optsize {
; CHECK-LABEL: test_optsize:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    retl
  ret i32 %a
}

define i32 @test_minsize(i32 %a) nounwind minsize {
; CHECK-LABEL: test_minsize:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    retl
  ret i32 %a
}

define i32 @test_pgso(i32 %a) nounwind !prof !14 {
; CHECK-LABEL: test_pgso:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    retl
  ret i32 %a
}

define i32 @test_add(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: test_add:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    addl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    retl
  %result = add i32 %a, %b
  ret i32 %result
}

define i32 @test_multiple_ret(i32 %a, i32 %b, i1 %c) nounwind {
; CHECK-LABEL: test_multiple_ret:
; CHECK:       # %bb.0:
; CHECK-NEXT:    testb $1, {{[0-9]+}}(%esp)
; CHECK-NEXT:    je .LBB5_2
; CHECK-NEXT:  # %bb.1: # %bb1
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    retl
; CHECK-NEXT:  .LBB5_2: # %bb2
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    retl



  br i1 %c, label %bb1, label %bb2

bb1:
  ret i32 %a

bb2:
  ret i32 %b
}

define void @test_call_others(i32 %x) nounwind {
; CHECK-LABEL: test_call_others:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    jne external_function@PLT # TAILCALL
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    retl
  %tobool = icmp eq i32 %x, 0
  br i1 %tobool, label %if.end, label %true.case

true.case:
  tail call void @external_function() nounwind
  br label %if.end

if.end:
  ret void

}

define void @test_branch_to_same_bb(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: test_branch_to_same_bb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    jle .LBB7_2
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  .LBB7_1: # %while.cond
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    jmp .LBB7_1
; CHECK-NEXT:  .LBB7_2: # %while.end
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    retl
  %cmp = icmp sgt i32 %x, 0
  br i1 %cmp, label %while.cond, label %while.end

while.cond:
  br label %while.cond

while.end:
  ret void
}

!llvm.module.flags = !{!0}
!0 = !{i32 1, !"ProfileSummary", !1}
!1 = !{!2, !3, !4, !5, !6, !7, !8, !9}
!2 = !{!"ProfileFormat", !"InstrProf"}
!3 = !{!"TotalCount", i64 10000}
!4 = !{!"MaxCount", i64 10}
!5 = !{!"MaxInternalCount", i64 1}
!6 = !{!"MaxFunctionCount", i64 1000}
!7 = !{!"NumCounts", i64 3}
!8 = !{!"NumFunctions", i64 3}
!9 = !{!"DetailedSummary", !10}
!10 = !{!11, !12, !13}
!11 = !{i32 10000, i64 100, i32 1}
!12 = !{i32 999000, i64 100, i32 1}
!13 = !{i32 999999, i64 1, i32 2}
!14 = !{!"function_entry_count", i64 0}
