; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --include-generated-funcs --version 4
; RUN: llc -mtriple hexagon-- -o - %s | FileCheck %s

; Reproducer for https://github.com/llvm/llvm-project/issues/89060
; Problem was a bug in argument copy elison. Given that the %alloca is
; eliminated, the same frame index will be used for accessing %alloca and %a
; on the fixed stack. Care must be taken when setting up
; MachinePointerInfo/MemOperands for those accesses to either make sure that
; we always refer to the fixed stack slot the same way (not using the
; ir.alloca name), or make sure that we still detect that they alias each
; other if using different kinds of MemOperands to identify the same fixed
; stack entry.
define i32 @f(i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32 %q1, i32 %a, i32 %q2) {
  %alloca = alloca i32
  store i32 %a, ptr %alloca     ; Should be elided.
  store i32 666, ptr %alloca
  %x = sub i32 %q1, %q2
  %y = xor i32 %x, %a           ; Results in a load of %a from fixed stack.
                                ; Using same frame index as elided %alloca.
  ret i32 %y
}
; CHECK-LABEL: f:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = memw(r29+#36)
; CHECK-NEXT:     r1 = memw(r29+#28)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = sub(r1,r0)
; CHECK-NEXT:     r2 = memw(r29+#32)
; CHECK-NEXT:     memw(r29+#32) = ##666
; CHECK-EMPTY:
; CHECK-NEXT:    } :mem_noshuf
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = xor(r0,r2)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
