set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/foo.vcxproj")
if(NOT EXISTS "${vcProjectFile}")
  set(RunCMake_TEST_FAILED "Project file ${vcProjectFile} does not exist.")
  return()
endif()

set(frameworkReferenceSet FALSE)

file(STRINGS "${vcProjectFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES "^ *<FrameworkReference Include=\"([^\"]*)\" />$")
    if("${CMAKE_MATCH_1}" STREQUAL "Microsoft.WindowsDesktop.App.WPF")
        message(STATUS "foo.vcxproj has FrameworkReference set")
        set(frameworkReferenceSet TRUE)
    else()
        message(STATUS "foo.vcxproj has FrameworkReference incorrectly set to ${CMAKE_MATCH_1}")
    endif()
  endif()
endforeach()

if(NOT frameworkReferenceSet)
  set(RunCMake_TEST_FAILED "FrameworkReference not found or not set correctly.")
  return()
endif()
