"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoFetchDataAdapter = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _jsClient = require("@statsig/js-client");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
/**
 * Data adapter which only uses bootstrap data and will never fetch from network or cache.
 * We do this because we control the fetching of bootstrap data from FFS in Client.ts whereas the
 * default data adapter fetches from Statsig servers.
 */
var NoFetchDataAdapter = exports.NoFetchDataAdapter = /*#__PURE__*/function (_DataAdapterCore) {
  function NoFetchDataAdapter() {
    var _this;
    (0, _classCallCheck2.default)(this, NoFetchDataAdapter);
    _this = _callSuper(this, NoFetchDataAdapter, ['NoFetchDataAdapter', 'nofetch']);
    (0, _defineProperty2.default)(_this, "bootstrapResult", null);
    return _this;
  }

  /**
   * Make sure to call this **before** calling `initializeAsync` or `updateUserAsync` but
   * after the Statsig client has been created!
   */
  (0, _inherits2.default)(NoFetchDataAdapter, _DataAdapterCore);
  return (0, _createClass2.default)(NoFetchDataAdapter, [{
    key: "setBootstrapData",
    value: function setBootstrapData(data) {
      this.bootstrapResult = data ? {
        source: 'Bootstrap',
        data: JSON.stringify(data),
        receivedAt: Date.now(),
        stableID: _jsClient.StableID.get(this._getSdkKey()),
        fullUserHash: null
      } : null;
    }
  }, {
    key: "prefetchData",
    value: function () {
      var _prefetchData = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(_user, _options) {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function prefetchData(_x, _x2) {
        return _prefetchData.apply(this, arguments);
      }
      return prefetchData;
    }()
  }, {
    key: "getDataAsync",
    value: function () {
      var _getDataAsync = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(_current, user, _options) {
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              return _context2.abrupt("return", this.bootstrapResult && _objectSpread(_objectSpread({}, this.bootstrapResult), {}, {
                fullUserHash: (0, _jsClient._getFullUserHash)(user)
              }));
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function getDataAsync(_x3, _x4, _x5) {
        return _getDataAsync.apply(this, arguments);
      }
      return getDataAsync;
    }()
  }, {
    key: "getDataSync",
    value: function getDataSync(user) {
      return this.bootstrapResult && _objectSpread(_objectSpread({}, this.bootstrapResult), {}, {
        fullUserHash: (0, _jsClient._getFullUserHash)(user)
      });
    }
  }, {
    key: "_fetchFromNetwork",
    value: function () {
      var _fetchFromNetwork2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(_current, _user, _options) {
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              return _context3.abrupt("return", null);
            case 1:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      }));
      function _fetchFromNetwork(_x6, _x7, _x8) {
        return _fetchFromNetwork2.apply(this, arguments);
      }
      return _fetchFromNetwork;
    }()
  }, {
    key: "_getCacheKey",
    value: function _getCacheKey(user) {
      // Same logic as default data adapter
      // https://github.com/statsig-io/js-client-monorepo/blob/main/packages/js-client/src/StatsigEvaluationsDataAdapter.ts
      var key = (0, _jsClient._getStorageKey)(this._getSdkKey(), user);
      return "".concat(_jsClient.DataAdapterCachePrefix, ".").concat(this._cacheSuffix, ".").concat(key);
    }
  }, {
    key: "_isCachedResultValidFor204",
    value: function _isCachedResultValidFor204(_result, _user) {
      return false;
    }
  }, {
    key: "setDataLegacy",
    value: function setDataLegacy(data, user) {
      _superPropGet(NoFetchDataAdapter, "setData", this, 3)([data, user]);
    }

    // Do not stringify options property since that includes this adapter and will
    // cause a circular reference when Statsig sends diagnostic events and including
    // values is not necessary and makes the result huge
  }, {
    key: "toJSON",
    value: function toJSON() {
      var result = _objectSpread({}, this);
      delete result._options;
      delete result._inMemoryCache;
      delete result.bootstrapResult;
      return result;
    }
  }]);
}(_jsClient.DataAdapterCore);