/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Ser;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Period
implements ChronoPeriod,
Serializable {
    public static final Period ZERO = new Period(0, 0, 0);
    private static final long serialVersionUID = -3587258372562876L;
    private static final Pattern PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)Y)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)W)?(?:([-+]?[0-9]+)D)?", 2);
    private static final List<TemporalUnit> SUPPORTED_UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS));
    private final int years;
    private final int months;
    private final int days;

    public static Period ofYears(int n) {
        return Period.create(n, 0, 0);
    }

    public static Period ofMonths(int n) {
        return Period.create(0, n, 0);
    }

    public static Period ofWeeks(int n) {
        return Period.create(0, 0, Math.multiplyExact(n, 7));
    }

    public static Period ofDays(int n) {
        return Period.create(0, 0, n);
    }

    public static Period of(int n, int n2, int n3) {
        return Period.create(n, n2, n3);
    }

    public static Period from(TemporalAmount temporalAmount) {
        if (temporalAmount instanceof Period) {
            return (Period)temporalAmount;
        }
        if (temporalAmount instanceof ChronoPeriod && !IsoChronology.INSTANCE.equals(((ChronoPeriod)temporalAmount).getChronology())) {
            throw new DateTimeException("Period requires ISO chronology: " + temporalAmount);
        }
        Objects.requireNonNull(temporalAmount, "amount");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (TemporalUnit temporalUnit : temporalAmount.getUnits()) {
            long l = temporalAmount.get(temporalUnit);
            if (temporalUnit == ChronoUnit.YEARS) {
                n = Math.toIntExact(l);
                continue;
            }
            if (temporalUnit == ChronoUnit.MONTHS) {
                n2 = Math.toIntExact(l);
                continue;
            }
            if (temporalUnit == ChronoUnit.DAYS) {
                n3 = Math.toIntExact(l);
                continue;
            }
            throw new DateTimeException("Unit must be Years, Months or Days, but was " + temporalUnit);
        }
        return Period.create(n, n2, n3);
    }

    public static Period parse(CharSequence charSequence) {
        Objects.requireNonNull(charSequence, "text");
        Matcher matcher = PATTERN.matcher(charSequence);
        if (matcher.matches()) {
            int n = "-".equals(matcher.group(1)) ? -1 : 1;
            String string = matcher.group(2);
            String string2 = matcher.group(3);
            String string3 = matcher.group(4);
            String string4 = matcher.group(5);
            if (string != null || string2 != null || string4 != null || string3 != null) {
                try {
                    int n2 = Period.parseNumber(charSequence, string, n);
                    int n3 = Period.parseNumber(charSequence, string2, n);
                    int n4 = Period.parseNumber(charSequence, string3, n);
                    int n5 = Period.parseNumber(charSequence, string4, n);
                    n5 = Math.addExact(n5, Math.multiplyExact(n4, 7));
                    return Period.create(n2, n3, n5);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DateTimeParseException("Text cannot be parsed to a Period", charSequence, 0, numberFormatException);
                }
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a Period", charSequence, 0);
    }

    private static int parseNumber(CharSequence charSequence, String string, int n) {
        if (string == null) {
            return 0;
        }
        int n2 = Integer.parseInt(string);
        try {
            return Math.multiplyExact(n2, n);
        }
        catch (ArithmeticException arithmeticException) {
            throw new DateTimeParseException("Text cannot be parsed to a Period", charSequence, 0, arithmeticException);
        }
    }

    public static Period between(LocalDate localDate, LocalDate localDate2) {
        return localDate.until(localDate2);
    }

    private static Period create(int n, int n2, int n3) {
        if ((n | n2 | n3) == 0) {
            return ZERO;
        }
        return new Period(n, n2, n3);
    }

    private Period(int n, int n2, int n3) {
        this.years = n;
        this.months = n2;
        this.days = n3;
    }

    @Override
    public long get(TemporalUnit temporalUnit) {
        if (temporalUnit == ChronoUnit.YEARS) {
            return this.getYears();
        }
        if (temporalUnit == ChronoUnit.MONTHS) {
            return this.getMonths();
        }
        if (temporalUnit == ChronoUnit.DAYS) {
            return this.getDays();
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public IsoChronology getChronology() {
        return IsoChronology.INSTANCE;
    }

    @Override
    public boolean isZero() {
        return this == ZERO;
    }

    @Override
    public boolean isNegative() {
        return this.years < 0 || this.months < 0 || this.days < 0;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public Period withYears(int n) {
        if (n == this.years) {
            return this;
        }
        return Period.create(n, this.months, this.days);
    }

    public Period withMonths(int n) {
        if (n == this.months) {
            return this;
        }
        return Period.create(this.years, n, this.days);
    }

    public Period withDays(int n) {
        if (n == this.days) {
            return this;
        }
        return Period.create(this.years, this.months, n);
    }

    @Override
    public Period plus(TemporalAmount temporalAmount) {
        Period period = Period.from(temporalAmount);
        return Period.create(Math.addExact(this.years, period.years), Math.addExact(this.months, period.months), Math.addExact(this.days, period.days));
    }

    public Period plusYears(long l) {
        if (l == 0L) {
            return this;
        }
        return Period.create(Math.toIntExact(Math.addExact((long)this.years, l)), this.months, this.days);
    }

    public Period plusMonths(long l) {
        if (l == 0L) {
            return this;
        }
        return Period.create(this.years, Math.toIntExact(Math.addExact((long)this.months, l)), this.days);
    }

    public Period plusDays(long l) {
        if (l == 0L) {
            return this;
        }
        return Period.create(this.years, this.months, Math.toIntExact(Math.addExact((long)this.days, l)));
    }

    @Override
    public Period minus(TemporalAmount temporalAmount) {
        Period period = Period.from(temporalAmount);
        return Period.create(Math.subtractExact(this.years, period.years), Math.subtractExact(this.months, period.months), Math.subtractExact(this.days, period.days));
    }

    public Period minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public Period minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public Period minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    @Override
    public Period multipliedBy(int n) {
        if (this == ZERO || n == 1) {
            return this;
        }
        return Period.create(Math.multiplyExact(this.years, n), Math.multiplyExact(this.months, n), Math.multiplyExact(this.days, n));
    }

    @Override
    public Period negated() {
        return this.multipliedBy(-1);
    }

    @Override
    public Period normalized() {
        long l = this.toTotalMonths();
        long l2 = l / 12L;
        int n = (int)(l % 12L);
        if (l2 == (long)this.years && n == this.months) {
            return this;
        }
        return Period.create(Math.toIntExact(l2), n, this.days);
    }

    public long toTotalMonths() {
        return (long)this.years * 12L + (long)this.months;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        this.validateChrono(temporal);
        if (this.months == 0) {
            if (this.years != 0) {
                temporal = temporal.plus(this.years, ChronoUnit.YEARS);
            }
        } else {
            long l = this.toTotalMonths();
            if (l != 0L) {
                temporal = temporal.plus(l, ChronoUnit.MONTHS);
            }
        }
        if (this.days != 0) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        this.validateChrono(temporal);
        if (this.months == 0) {
            if (this.years != 0) {
                temporal = temporal.minus(this.years, ChronoUnit.YEARS);
            }
        } else {
            long l = this.toTotalMonths();
            if (l != 0L) {
                temporal = temporal.minus(l, ChronoUnit.MONTHS);
            }
        }
        if (this.days != 0) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    private void validateChrono(TemporalAccessor temporalAccessor) {
        Objects.requireNonNull(temporalAccessor, "temporal");
        Chronology chronology = temporalAccessor.query(TemporalQueries.chronology());
        if (chronology != null && !IsoChronology.INSTANCE.equals(chronology)) {
            throw new DateTimeException("Chronology mismatch, expected: ISO, actual: " + chronology.getId());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return this.years == period.years && this.months == period.months && this.days == period.days;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.years + Integer.rotateLeft(this.months, 8) + Integer.rotateLeft(this.days, 16);
    }

    @Override
    public String toString() {
        if (this == ZERO) {
            return "P0D";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('P');
        if (this.years != 0) {
            stringBuilder.append(this.years).append('Y');
        }
        if (this.months != 0) {
            stringBuilder.append(this.months).append('M');
        }
        if (this.days != 0) {
            stringBuilder.append(this.days).append('D');
        }
        return stringBuilder.toString();
    }

    private Object writeReplace() {
        return new Ser(14, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.years);
        dataOutput.writeInt(this.months);
        dataOutput.writeInt(this.days);
    }

    static Period readExternal(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        return Period.of(n, n2, n3);
    }
}

