/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.parser.gson;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.dto.RuleTemplateDTO;
import org.openhab.core.automation.dto.RuleTemplateDTOMapper;
import org.openhab.core.automation.internal.parser.gson.AbstractGSONParser;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.automation.parser.ParsingNestedException;
import org.openhab.core.automation.template.Template;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(immediate=true, service={Parser.class}, property={"parser.type=parser.template", "format=json"})
public class TemplateGSONParser
extends AbstractGSONParser<Template> {
    @Override
    public Set<Template> parse(InputStreamReader reader) throws ParsingException {
        JsonReader jr = new JsonReader((Reader)reader);
        try {
            if (jr.hasNext()) {
                JsonToken token = jr.peek();
                HashSet<Template> templates = new HashSet<Template>();
                if (JsonToken.BEGIN_ARRAY.equals((Object)token)) {
                    List templateDtos = (List)gson.fromJson(jr, new TypeToken<List<RuleTemplateDTO>>(){}.getType());
                    for (RuleTemplateDTO templateDto : templateDtos) {
                        templates.add(RuleTemplateDTOMapper.map(templateDto));
                    }
                } else {
                    RuleTemplateDTO template = (RuleTemplateDTO)gson.fromJson(jr, RuleTemplateDTO.class);
                    templates.add(RuleTemplateDTOMapper.map(template));
                }
                HashSet<Template> hashSet = templates;
                return hashSet;
            }
        }
        catch (Exception e) {
            throw new ParsingException(new ParsingNestedException(2, null, e));
        }
        finally {
            try {
                jr.close();
            }
            catch (IOException iOException) {}
        }
        return Set.of();
    }
}

