// Code generated by sdkgen-v2. DO NOT EDIT.
package iamsdk

import (
	"context"

	iam "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	sdkop "github.com/yandex-cloud/go-sdk/v2/pkg/operation"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/reflect/protoreflect"
)

// RefreshTokenClient provides methods for managing RefreshToken resources of Yandex.Cloud IAM.
type RefreshTokenClient interface {
	RefreshTokenClientIterator
	List(context.Context, *iam.ListRefreshTokensRequest, ...grpc.CallOption) (*iam.ListRefreshTokensResponse, error)
	Revoke(context.Context, *iam.RevokeRefreshTokenRequest, ...grpc.CallOption) (*RefreshTokenRevokeOperation, error)
}

var _ RefreshTokenClient = refreshTokenClient{}

type refreshTokenClient struct {
	connector transport.Connector
}

// NewRefreshTokenClient returns RefreshTokenClient implementation.
func NewRefreshTokenClient(connector transport.Connector) RefreshTokenClient {
	return refreshTokenClient{connector}
}

// List is an operation of Yandex.Cloud IAM RefreshToken service.
func (c refreshTokenClient) List(ctx context.Context, in *iam.ListRefreshTokensRequest, opts ...grpc.CallOption) (*iam.ListRefreshTokensResponse, error) {
	connection, err := c.connector.GetConnection(ctx, RefreshTokenList, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewRefreshTokenServiceClient(connection).List(ctx, in, opts...)
}

// RefreshTokenRevokeOperation is used to monitor the state of Revoke operations.
type RefreshTokenRevokeOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *RefreshTokenRevokeOperation) Metadata() *iam.RevokeRefreshTokenMetadata {
	return o.Operation.Metadata().(*iam.RevokeRefreshTokenMetadata)
}

// Response retrieves the operation response.
func (o *RefreshTokenRevokeOperation) Response() *iam.RevokeRefreshTokenResponse {
	return o.Operation.Response().(*iam.RevokeRefreshTokenResponse)
}

// Wait polls the operation until it's done.
func (o *RefreshTokenRevokeOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*iam.RevokeRefreshTokenResponse, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*iam.RevokeRefreshTokenResponse)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *RefreshTokenRevokeOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*iam.RevokeRefreshTokenResponse, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*iam.RevokeRefreshTokenResponse)
	return response, err
}

// Revoke is an operation of Yandex.Cloud IAM RefreshToken service.
// It returns an object which should be used to monitor the operation state.
func (c refreshTokenClient) Revoke(ctx context.Context, in *iam.RevokeRefreshTokenRequest, opts ...grpc.CallOption) (*RefreshTokenRevokeOperation, error) {
	connection, err := c.connector.GetConnection(ctx, RefreshTokenRevoke, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewRefreshTokenServiceClient(connection).Revoke(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*iam.RevokeRefreshTokenMetadata)(nil),
		ResponseType: (*iam.RevokeRefreshTokenResponse)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &RefreshTokenRevokeOperation{*op}, nil
}

// pollOperation returns the current state of the polled operation.
func (c refreshTokenClient) pollOperation(ctx context.Context, operationId string, opts ...grpc.CallOption) (sdkop.YCOperation, error) {
	connection, err := c.connector.GetConnection(ctx, RefreshTokenOperationPoller, opts...)
	if err != nil {
		return nil, err
	}
	return operation.NewOperationServiceClient(connection).Get(ctx, &operation.GetOperationRequest{OperationId: operationId}, opts...)
}

var (
	RefreshTokenList            = protoreflect.FullName("yandex.cloud.iam.v1.RefreshTokenService.List")
	RefreshTokenRevoke          = protoreflect.FullName("yandex.cloud.iam.v1.RefreshTokenService.Revoke")
	RefreshTokenOperationPoller = protoreflect.FullName("yandex.cloud.operation.OperationService.Get")
)
