# -*- coding: utf-8 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

from gallery_dl.extractor import weebdex


__tests__ = (
{
    "#url"     : "https://weebdex.org/chapter/f6c0awnrba",
    "#class"   : weebdex.WeebdexChapterExtractor,
    "#pattern" : r"https://s\d+\.weebdex\.net/data/f6c0awnrba/\d+-\w{64}\.png",
    "#count"   : 14,

    "artist"       : ["Nokomi (のこみ)"],
    "author"       : ["Tanabata Satori"],
    "chapter"      : 11,
    "chapter_id"   : "f6c0awnrba",
    "chapter_minor": ".5",
    "count"        : 14,
    "page"         : range(1, 14),
    "date"         : "dt:2025-10-13 10:47:26",
    "date_updated" : "type:datetime",
    "demographic"  : "shoujo",
    "extension"    : "png",
    "filename"     : str,
    "group"        : ["Knights of Earl Grey"],
    "width"        : range(800, 2800),
    "height"       : range(800, 2800),
    "lang"         : "en",
    "manga"        : "Akuyaku Reijou Level 99: Watashi wa UraBoss desu ga Maou de wa Arimasen",
    "manga_date"   : "dt:2025-10-09 07:32:07",
    "manga_id"     : "raa6dfy3da",
    "origin"       : "ja",
    "status"       : "ongoing",
    "title"        : "[Extra] A Day In The Life Of Patrick",
    "uploader"     : "system",
    "version"      : 1,
    "volume"       : 2,
    "year"         : 2020,
    "description"  : """\
I reincarnated as the "Villainess Eumiella" from an RPG Otome game. In the main story, Eumiella is merely a side character, but after the ending, she re-enters the story as the Hidden Boss, a character boasting high stats on par with the heroes! Lighting a fire in my gamer's soul, and taking advantage of being left on my own in my parent's territory, I trained, trained, and trained! As a result of my training... by the time I enrolled in the academy, I managed to reach level 99. Though I had planned to live out my days as inconspicuously and peacefully as possible, soon after entering the school, I'm suspected by the Heroine and Love Interests of being the "Demon Lord"...?
___
**Links:**
- Alternative Official Raw - [Niconico](https://manga.nicovideo.jp/comic/46067)\
""",
    "tags"         : [
        "format:Adaptation",
        "genre:Action",
        "genre:Comedy",
        "genre:Fantasy",
        "genre:Isekai",
        "genre:Romance",
        "theme:Demons",
        "theme:Magic",
        "theme:Monsters",
        "theme:Reincarnation",
        "theme:School Life",
        "theme:Video Games",
        "theme:Villainess",
    ],
},

{
    "#url"     : "https://weebdex.org/chapter/itizot1rxc",
    "#class"   : weebdex.WeebdexChapterExtractor,
    "#pattern" : r"https://s\d+\.weebdex\.net/data/itizot1rxc/\d+\-\w+\.jpg",
    "#count"   : 17,

    "artist"       : ["Matsuda Minoru"],
    "author"       : ["Matsuda Minoru"],
    "chapter"      : 10,
    "chapter_id"   : "itizot1rxc",
    "chapter_minor": "",
    "count"        : 17,
    "demographic"  : "seinen",
    "group"        : ["BBB Translation (Big Beaming Bluewhale)"],
    "lang"         : "vi",
    "manga"        : "Ani Datta Mono",
    "manga_date"   : "dt:2025-10-09 19:02:04",
    "manga_id"     : "3o0icxno26",
    "origin"       : "ja",
    "title"        : "Cuộc hẹn tại phía Đông vườn địa đàng",
    "uploader"     : str,
    "version"      : 1,
    "volume"       : 2,
    "year"         : 2021,
},

{
    "#url"     : "https://weebdex.org/chapter/itizot1rxc",
    "#comment" : "'data-saver' option (#8914)",
    "#class"   : weebdex.WeebdexChapterExtractor,
    "#options" : {"data-saver": True},
    "#range"   : "1-3",
    "#results" : (
        "https://s11.weebdex.net/data/itizot1rxc/1-fa838df3d9b2d16ab3f900a5d74d8e1fe2b15446825978209053297b8e3f7d0d.webp",
        "https://s11.weebdex.net/data/itizot1rxc/2-b4914436ab21e7915440024a5b5bd705c3a844df314c3c7d722388b3ce81626a.webp",
        "https://s11.weebdex.net/data/itizot1rxc/3-6b0e1901cfae7d6d5c21769d714c992fb1fa1af6e9e8e10083ea5a6bf5d53cef.webp",
    ),
},

{
    "#url"     : "https://weebdex.org/chapter/spsn025m8a",
    "#comment" : "no 'demographic' data (#8939)",
    "#class"   : weebdex.WeebdexChapterExtractor,
    "#count"   : 49,

    "artist"       : ["Fuugetsu Makoto"],
    "author"       : ["Koyagi Mei"],
    "chapter"      : 1,
    "chapter_id"   : "spsn025m8a",
    "chapter_minor": "",
    "count"        : 49,
    "date"         : "dt:2026-01-19 11:12:36",
    "demographic"  : None,
    "group"        : ["Asmodeus Scans"],
    "lang"         : "en",
    "manga"        : "Yuusha no Sensei, Saikyou no Kuzu ni naru. ~S-kyuu Party no Moto Eiyuu, Ura Shakai no Ihou Guild de Nariagari~",
    "manga_date"   : "dt:2025-10-09 09:21:18",
    "manga_id"     : "vtyi8syfjd",
    "origin"       : "ja",
    "original"     : True,
    "title"        : "",
    "uploader"     : "asmodai",
    "version"      : 1,
    "volume"       : 1,
    "year"         : 2023,
},

{
    "#url"     : "https://weebdex.org/chapter/0fignihbv8",
    "#comment" : "no 'volume' data",
    "#class"   : weebdex.WeebdexChapterExtractor,
    "#count"   : 47,

    "artist"       : ["Azuma Kiyohiko"],
    "author"       : ["Azuma Kiyohiko"],
    "chapter"      : 114,
    "chapter_id"   : "0fignihbv8",
    "chapter_minor": "",
    "count"        : 47,
    "date"         : "dt:2025-10-17 23:36:27",
    "demographic"  : "shounen",
    "group"        : ["Ralen"],
    "lang"         : "en",
    "manga"        : "Yotsuba to!",
    "volume"       : 0,
},

{
    "#url"     : "https://weebdex.org/title/3o0icxno26/ani-datta-mono",
    "#class"   : weebdex.WeebdexMangaExtractor,
    "#pattern" : weebdex.WeebdexChapterExtractor.pattern,
    "#options" : {"lang": None},
    "#count"   : range(120, 300),

    "artist"       : ["Matsuda Minoru"],
    "author"       : ["Matsuda Minoru"],
    "volume"       : int,
    "chapter"      : int,
    "chapter_minor": {"", ".5"},
    "created_at"   : "iso:dt",
    "published_at" : "iso:dt",
    "updated_at"   : "iso:dt",
    "demographic"  : "seinen",
    "id"           : str,
    "language"     : {"en", "vi"},
    "manga"        : "Ani Datta Mono",
    "manga_date"   : "dt:2025-10-09 19:02:04",
    "manga_id"     : "3o0icxno26",
    "origin"       : "ja",
    "status"       : "ongoing",
    "version"      : {1, 2, 3, 4},
    "year"         : 2021,
    "description"  : """\
My brother died. When I went to visit my brother's grave with my brother's lover——……

This is the story of my brother's lover, me, and “the thing that was my brother”.
___
**Additional Links:**
- [Official TikTok](http://tiktok.com/@anidattamono)
- [Official X](https://x.com/anidattamono)\
""",
    "tags"         : [
        "genre:Drama",
        "genre:Horror",
        "genre:Psychological",
        "genre:Romance",
        "genre:Thriller",
        "theme:Ghosts",
        "theme:Supernatural",
    ],
},

{
    "#url"     : "https://weebdex.org/title/f29vfu3dd4/yotsuba-to",
    "#comment" : "no 'volume' data (#8954)",
    "#class"   : weebdex.WeebdexMangaExtractor,
    "#pattern" : weebdex.WeebdexChapterExtractor.pattern,

    "artist"     : ["Azuma Kiyohiko"],
    "author"     : ["Azuma Kiyohiko"],
    "demographic": "shounen",
    "manga"      : "Yotsuba to!",
    "manga_date" : "dt:2025-10-09 09:34:27",
    "manga_id"   : "f29vfu3dd4",
    "origin"     : "ja",
    "volume"     : int,
    "year"       : 2003,
},

{
    "#url"     : "https://weebdex.org/title/3o0icxno26/ani-datta-mono",
    "#comment" : "'lang' option (#8957)",
    "#class"   : weebdex.WeebdexMangaExtractor,
    "#pattern" : weebdex.WeebdexChapterExtractor.pattern,
    "#options" : {"lang": "vi"},
    "#count"   : 105,

    "artist"       : ["Matsuda Minoru"],
    "author"       : ["Matsuda Minoru"],
    "chapter"      : range(1, 105),
    "chapter_minor": {"", ".5"},
    "demographic"  : "seinen",
    "description"  : str,
    "language"     : "vi",
    "manga"        : "Ani Datta Mono",
    "manga_date"   : "dt:2025-10-09 19:02:04",
    "manga_id"     : "3o0icxno26",
    "origin"       : "ja",
    "status"       : "ongoing",
    "version"      : int,
    "volume"       : int,
    "year"         : 2021,
    "tags"         : [
        "genre:Drama",
        "genre:Horror",
        "genre:Psychological",
        "genre:Romance",
        "genre:Thriller",
        "theme:Ghosts",
        "theme:Supernatural",
    ],
    "relationships": {
        "groups"  : [{
            "id"  : "u7kmeka8v6",
            "name": "BBB Translation (Big Beaming Bluewhale)",
        }],
    },
},

{
    "#url"     : "https://weebdex.org/title/3o0icxno26/ani-datta-mono?group=j0fsj3oem3&order=desc",
    "#comment" : "query parameters (#8957)",
    "#class"   : weebdex.WeebdexMangaExtractor,
    "#range"   : "1-3",
    "#results" : (
        "https://weebdex.org/chapter/u18zq7aclx",
        "https://weebdex.org/chapter/2qb8jw9paz",
        "https://weebdex.org/chapter/aht5ukglyv",
    ),

    "artist"       : ["Matsuda Minoru"],
    "author"       : ["Matsuda Minoru"],
    "chapter"      : range(30, 50),
    "language"     : "en",
    "manga"        : "Ani Datta Mono",
    "manga_date"   : "dt:2025-10-09 19:02:04",
    "manga_id"     : "3o0icxno26",
    "version"      : 1,
    "volume"       : {3, 4, 5},
    "relationships": {
        "groups"  : [{
            "id"  : "j0fsj3oem3",
            "name": "Rainbow D Translations",
        }],
    },
},

{
    "#url"     : "https://weebdex.org/title/3o0icxno26/ani-datta-mono?group=j0fsj3oem3",
    "#comment" : "'chapter-reverse' option (#9041)",
    "#class"   : weebdex.WeebdexMangaExtractor,
    "#options" : {"chapter-reverse": True},
    "#range"   : "1-3",
    "#results" : (
        "https://weebdex.org/chapter/xv2cm9bj1a",
        "https://weebdex.org/chapter/etoaxmxgcq",
        "https://weebdex.org/chapter/24ew0mo562",
    ),
},

)
