// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package netapp provides access to the NetApp API.
//
// For product documentation, see: https://cloud.google.com/netapp/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/netapp/v1"
//	...
//	ctx := context.Background()
//	netappService, err := netapp.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	netappService, err := netapp.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	netappService, err := netapp.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package netapp // import "google.golang.org/api/netapp/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "netapp:v1"
const apiName = "netapp"
const apiVersion = "v1"
const basePath = "https://netapp.googleapis.com/"
const basePathTemplate = "https://netapp.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://netapp.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.ActiveDirectories = NewProjectsLocationsActiveDirectoriesService(s)
	rs.BackupPolicies = NewProjectsLocationsBackupPoliciesService(s)
	rs.BackupVaults = NewProjectsLocationsBackupVaultsService(s)
	rs.KmsConfigs = NewProjectsLocationsKmsConfigsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.StoragePools = NewProjectsLocationsStoragePoolsService(s)
	rs.Volumes = NewProjectsLocationsVolumesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	ActiveDirectories *ProjectsLocationsActiveDirectoriesService

	BackupPolicies *ProjectsLocationsBackupPoliciesService

	BackupVaults *ProjectsLocationsBackupVaultsService

	KmsConfigs *ProjectsLocationsKmsConfigsService

	Operations *ProjectsLocationsOperationsService

	StoragePools *ProjectsLocationsStoragePoolsService

	Volumes *ProjectsLocationsVolumesService
}

func NewProjectsLocationsActiveDirectoriesService(s *Service) *ProjectsLocationsActiveDirectoriesService {
	rs := &ProjectsLocationsActiveDirectoriesService{s: s}
	return rs
}

type ProjectsLocationsActiveDirectoriesService struct {
	s *Service
}

func NewProjectsLocationsBackupPoliciesService(s *Service) *ProjectsLocationsBackupPoliciesService {
	rs := &ProjectsLocationsBackupPoliciesService{s: s}
	return rs
}

type ProjectsLocationsBackupPoliciesService struct {
	s *Service
}

func NewProjectsLocationsBackupVaultsService(s *Service) *ProjectsLocationsBackupVaultsService {
	rs := &ProjectsLocationsBackupVaultsService{s: s}
	rs.Backups = NewProjectsLocationsBackupVaultsBackupsService(s)
	return rs
}

type ProjectsLocationsBackupVaultsService struct {
	s *Service

	Backups *ProjectsLocationsBackupVaultsBackupsService
}

func NewProjectsLocationsBackupVaultsBackupsService(s *Service) *ProjectsLocationsBackupVaultsBackupsService {
	rs := &ProjectsLocationsBackupVaultsBackupsService{s: s}
	return rs
}

type ProjectsLocationsBackupVaultsBackupsService struct {
	s *Service
}

func NewProjectsLocationsKmsConfigsService(s *Service) *ProjectsLocationsKmsConfigsService {
	rs := &ProjectsLocationsKmsConfigsService{s: s}
	return rs
}

type ProjectsLocationsKmsConfigsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsStoragePoolsService(s *Service) *ProjectsLocationsStoragePoolsService {
	rs := &ProjectsLocationsStoragePoolsService{s: s}
	return rs
}

type ProjectsLocationsStoragePoolsService struct {
	s *Service
}

func NewProjectsLocationsVolumesService(s *Service) *ProjectsLocationsVolumesService {
	rs := &ProjectsLocationsVolumesService{s: s}
	rs.QuotaRules = NewProjectsLocationsVolumesQuotaRulesService(s)
	rs.Replications = NewProjectsLocationsVolumesReplicationsService(s)
	rs.Snapshots = NewProjectsLocationsVolumesSnapshotsService(s)
	return rs
}

type ProjectsLocationsVolumesService struct {
	s *Service

	QuotaRules *ProjectsLocationsVolumesQuotaRulesService

	Replications *ProjectsLocationsVolumesReplicationsService

	Snapshots *ProjectsLocationsVolumesSnapshotsService
}

func NewProjectsLocationsVolumesQuotaRulesService(s *Service) *ProjectsLocationsVolumesQuotaRulesService {
	rs := &ProjectsLocationsVolumesQuotaRulesService{s: s}
	return rs
}

type ProjectsLocationsVolumesQuotaRulesService struct {
	s *Service
}

func NewProjectsLocationsVolumesReplicationsService(s *Service) *ProjectsLocationsVolumesReplicationsService {
	rs := &ProjectsLocationsVolumesReplicationsService{s: s}
	return rs
}

type ProjectsLocationsVolumesReplicationsService struct {
	s *Service
}

func NewProjectsLocationsVolumesSnapshotsService(s *Service) *ProjectsLocationsVolumesSnapshotsService {
	rs := &ProjectsLocationsVolumesSnapshotsService{s: s}
	return rs
}

type ProjectsLocationsVolumesSnapshotsService struct {
	s *Service
}

// ActiveDirectory: ActiveDirectory is the public representation of the active
// directory config.
type ActiveDirectory struct {
	// Administrators: Optional. Users to be added to the Built-in Admininstrators
	// group.
	Administrators []string `json:"administrators,omitempty"`
	// AesEncryption: If enabled, AES encryption will be enabled for SMB
	// communication.
	AesEncryption bool `json:"aesEncryption,omitempty"`
	// BackupOperators: Optional. Users to be added to the Built-in Backup Operator
	// active directory group.
	BackupOperators []string `json:"backupOperators,omitempty"`
	// CreateTime: Output only. Create time of the active directory.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the active directory.
	Description string `json:"description,omitempty"`
	// Dns: Required. Comma separated list of DNS server IP addresses for the
	// Active Directory domain.
	Dns string `json:"dns,omitempty"`
	// Domain: Required. Name of the Active Directory domain
	Domain string `json:"domain,omitempty"`
	// EncryptDcConnections: If enabled, traffic between the SMB server to Domain
	// Controller (DC) will be encrypted.
	EncryptDcConnections bool `json:"encryptDcConnections,omitempty"`
	// KdcHostname: Name of the active directory machine. This optional parameter
	// is used only while creating kerberos volume
	KdcHostname string `json:"kdcHostname,omitempty"`
	// KdcIp: KDC server IP address for the active directory machine.
	KdcIp string `json:"kdcIp,omitempty"`
	// Labels: Labels for the active directory.
	Labels map[string]string `json:"labels,omitempty"`
	// LdapSigning: Specifies whether or not the LDAP traffic needs to be signed.
	LdapSigning bool `json:"ldapSigning,omitempty"`
	// Name: Identifier. The resource name of the active directory. Format:
	// `projects/{project_number}/locations/{location_id}/activeDirectories/{active_
	// directory_id}`.
	Name string `json:"name,omitempty"`
	// NetBiosPrefix: Required. NetBIOSPrefix is used as a prefix for SMB server
	// name.
	NetBiosPrefix string `json:"netBiosPrefix,omitempty"`
	// NfsUsersWithLdap: If enabled, will allow access to local users and LDAP
	// users. If access is needed for only LDAP users, it has to be disabled.
	NfsUsersWithLdap bool `json:"nfsUsersWithLdap,omitempty"`
	// OrganizationalUnit: The Organizational Unit (OU) within the Windows Active
	// Directory the user belongs to.
	OrganizationalUnit string `json:"organizationalUnit,omitempty"`
	// Password: Required. Password of the Active Directory domain administrator.
	Password string `json:"password,omitempty"`
	// SecurityOperators: Optional. Domain users to be given the
	// SeSecurityPrivilege.
	SecurityOperators []string `json:"securityOperators,omitempty"`
	// Site: The Active Directory site the service will limit Domain Controller
	// discovery too.
	Site string `json:"site,omitempty"`
	// State: Output only. The state of the AD.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified Active Directory State
	//   "CREATING" - Active Directory State is Creating
	//   "READY" - Active Directory State is Ready
	//   "UPDATING" - Active Directory State is Updating
	//   "IN_USE" - Active Directory State is In use
	//   "DELETING" - Active Directory State is Deleting
	//   "ERROR" - Active Directory State is Error
	//   "DIAGNOSING" - Active Directory State is Diagnosing.
	State string `json:"state,omitempty"`
	// StateDetails: Output only. The state details of the Active Directory.
	StateDetails string `json:"stateDetails,omitempty"`
	// Username: Required. Username of the Active Directory domain administrator.
	Username string `json:"username,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Administrators") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Administrators") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActiveDirectory) MarshalJSON() ([]byte, error) {
	type NoMethod ActiveDirectory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Backup: A NetApp Backup.
type Backup struct {
	// BackupRegion: Output only. Region in which backup is stored. Format:
	// `projects/{project_id}/locations/{location}`
	BackupRegion string `json:"backupRegion,omitempty"`
	// BackupType: Output only. Type of backup, manually created or created by a
	// backup policy.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified backup type.
	//   "MANUAL" - Manual backup type.
	//   "SCHEDULED" - Scheduled backup type.
	BackupType string `json:"backupType,omitempty"`
	// ChainStorageBytes: Output only. Total size of all backups in a chain in
	// bytes = baseline backup size + sum(incremental backup size)
	ChainStorageBytes int64 `json:"chainStorageBytes,omitempty,string"`
	// CreateTime: Output only. The time when the backup was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: A description of the backup with 2048 characters or less.
	// Requests with longer descriptions will be rejected.
	Description string `json:"description,omitempty"`
	// EnforcedRetentionEndTime: Output only. The time until which the backup is
	// not deletable.
	EnforcedRetentionEndTime string `json:"enforcedRetentionEndTime,omitempty"`
	// Labels: Resource labels to represent user provided metadata.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the backup. Format:
	// `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/ba
	// ckups/{backup_id}`.
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SourceSnapshot: If specified, backup will be created from the given
	// snapshot. If not specified, there will be a new snapshot taken to initiate
	// the backup creation. Format:
	// `projects/{project_id}/locations/{location}/volumes/{volume_id}/snapshots/{sn
	// apshot_id}`
	SourceSnapshot string `json:"sourceSnapshot,omitempty"`
	// SourceVolume: Volume full name of this backup belongs to. Format:
	// `projects/{projects_id}/locations/{location}/volumes/{volume_id}`
	SourceVolume string `json:"sourceVolume,omitempty"`
	// State: Output only. The backup state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set.
	//   "CREATING" - Backup is being created. While in this state, the snapshot
	// for the backup point-in-time may not have been created yet, and so the
	// point-in-time may not have been fixed.
	//   "UPLOADING" - Backup is being uploaded. While in this state, none of the
	// writes to the volume will be included in the backup.
	//   "READY" - Backup is available for use.
	//   "DELETING" - Backup is being deleted.
	//   "ERROR" - Backup is not valid and cannot be used for creating new volumes
	// or restoring existing volumes.
	//   "UPDATING" - Backup is being updated.
	State string `json:"state,omitempty"`
	// VolumeRegion: Output only. Region of the volume from which the backup was
	// created. Format: `projects/{project_id}/locations/{location}`
	VolumeRegion string `json:"volumeRegion,omitempty"`
	// VolumeUsageBytes: Output only. Size of the file system when the backup was
	// created. When creating a new volume from the backup, the volume capacity
	// will have to be at least as big.
	VolumeUsageBytes int64 `json:"volumeUsageBytes,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupRegion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupRegion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Backup) MarshalJSON() ([]byte, error) {
	type NoMethod Backup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupConfig: BackupConfig contains backup related config on a volume.
type BackupConfig struct {
	// BackupChainBytes: Output only. Total size of all backups in a chain in bytes
	// = baseline backup size + sum(incremental backup size).
	BackupChainBytes int64 `json:"backupChainBytes,omitempty,string"`
	// BackupPolicies: Optional. When specified, schedule backups will be created
	// based on the policy configuration.
	BackupPolicies []string `json:"backupPolicies,omitempty"`
	// BackupVault: Optional. Name of backup vault. Format:
	// projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}
	BackupVault string `json:"backupVault,omitempty"`
	// ScheduledBackupEnabled: Optional. When set to true, scheduled backup is
	// enabled on the volume. This field should be nil when there's no backup
	// policy attached.
	ScheduledBackupEnabled bool `json:"scheduledBackupEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackupChainBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupChainBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BackupConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupPolicy: Backup Policy.
type BackupPolicy struct {
	// AssignedVolumeCount: Output only. The total number of volumes assigned by
	// this backup policy.
	AssignedVolumeCount int64 `json:"assignedVolumeCount,omitempty"`
	// CreateTime: Output only. The time when the backup policy was created.
	CreateTime string `json:"createTime,omitempty"`
	// DailyBackupLimit: Number of daily backups to keep. Note that the minimum
	// daily backup limit is 2.
	DailyBackupLimit int64 `json:"dailyBackupLimit,omitempty"`
	// Description: Description of the backup policy.
	Description string `json:"description,omitempty"`
	// Enabled: If enabled, make backups automatically according to the schedules.
	// This will be applied to all volumes that have this policy attached and
	// enforced on volume level. If not specified, default is true.
	Enabled bool `json:"enabled,omitempty"`
	// Labels: Resource labels to represent user provided metadata.
	Labels map[string]string `json:"labels,omitempty"`
	// MonthlyBackupLimit: Number of monthly backups to keep. Note that the sum of
	// daily, weekly and monthly backups should be greater than 1.
	MonthlyBackupLimit int64 `json:"monthlyBackupLimit,omitempty"`
	// Name: Identifier. The resource name of the backup policy. Format:
	// `projects/{project_id}/locations/{location}/backupPolicies/{backup_policy_id}
	// `.
	Name string `json:"name,omitempty"`
	// State: Output only. The backup policy state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set.
	//   "CREATING" - BackupPolicy is being created.
	//   "READY" - BackupPolicy is available for use.
	//   "DELETING" - BackupPolicy is being deleted.
	//   "ERROR" - BackupPolicy is not valid and cannot be used.
	//   "UPDATING" - BackupPolicy is being updated.
	State string `json:"state,omitempty"`
	// WeeklyBackupLimit: Number of weekly backups to keep. Note that the sum of
	// daily, weekly and monthly backups should be greater than 1.
	WeeklyBackupLimit int64 `json:"weeklyBackupLimit,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssignedVolumeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssignedVolumeCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackupPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupRetentionPolicy: Retention policy for backups in the backup vault
type BackupRetentionPolicy struct {
	// BackupMinimumEnforcedRetentionDays: Required. Minimum retention duration in
	// days for backups in the backup vault.
	BackupMinimumEnforcedRetentionDays int64 `json:"backupMinimumEnforcedRetentionDays,omitempty"`
	// DailyBackupImmutable: Optional. Indicates if the daily backups are
	// immutable. Atleast one of daily_backup_immutable, weekly_backup_immutable,
	// monthly_backup_immutable and manual_backup_immutable must be true.
	DailyBackupImmutable bool `json:"dailyBackupImmutable,omitempty"`
	// ManualBackupImmutable: Optional. Indicates if the manual backups are
	// immutable. Atleast one of daily_backup_immutable, weekly_backup_immutable,
	// monthly_backup_immutable and manual_backup_immutable must be true.
	ManualBackupImmutable bool `json:"manualBackupImmutable,omitempty"`
	// MonthlyBackupImmutable: Optional. Indicates if the monthly backups are
	// immutable. Atleast one of daily_backup_immutable, weekly_backup_immutable,
	// monthly_backup_immutable and manual_backup_immutable must be true.
	MonthlyBackupImmutable bool `json:"monthlyBackupImmutable,omitempty"`
	// WeeklyBackupImmutable: Optional. Indicates if the weekly backups are
	// immutable. Atleast one of daily_backup_immutable, weekly_backup_immutable,
	// monthly_backup_immutable and manual_backup_immutable must be true.
	WeeklyBackupImmutable bool `json:"weeklyBackupImmutable,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "BackupMinimumEnforcedRetentionDays") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "BackupMinimumEnforcedRetentionDays") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s BackupRetentionPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackupRetentionPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupVault: A NetApp BackupVault.
type BackupVault struct {
	// BackupRegion: Optional. Region where the backups are stored. Format:
	// `projects/{project_id}/locations/{location}`
	BackupRegion string `json:"backupRegion,omitempty"`
	// BackupRetentionPolicy: Optional. Backup retention policy defining the
	// retenton of backups.
	BackupRetentionPolicy *BackupRetentionPolicy `json:"backupRetentionPolicy,omitempty"`
	// BackupVaultType: Optional. Type of backup vault to be created. Default is
	// IN_REGION.
	//
	// Possible values:
	//   "BACKUP_VAULT_TYPE_UNSPECIFIED" - BackupVault type not set.
	//   "IN_REGION" - BackupVault type is IN_REGION.
	//   "CROSS_REGION" - BackupVault type is CROSS_REGION.
	BackupVaultType string `json:"backupVaultType,omitempty"`
	// CreateTime: Output only. Create time of the backup vault.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the backup vault.
	Description string `json:"description,omitempty"`
	// DestinationBackupVault: Output only. Name of the Backup vault created in
	// backup region. Format:
	// `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
	DestinationBackupVault string `json:"destinationBackupVault,omitempty"`
	// Labels: Resource labels to represent user provided metadata.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the backup vault. Format:
	// `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`.
	Name string `json:"name,omitempty"`
	// SourceBackupVault: Output only. Name of the Backup vault created in source
	// region. Format:
	// `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
	SourceBackupVault string `json:"sourceBackupVault,omitempty"`
	// SourceRegion: Output only. Region in which the backup vault is created.
	// Format: `projects/{project_id}/locations/{location}`
	SourceRegion string `json:"sourceRegion,omitempty"`
	// State: Output only. The backup vault state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not set.
	//   "CREATING" - BackupVault is being created.
	//   "READY" - BackupVault is available for use.
	//   "DELETING" - BackupVault is being deleted.
	//   "ERROR" - BackupVault is not valid and cannot be used.
	//   "UPDATING" - BackupVault is being updated.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupRegion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupRegion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupVault) MarshalJSON() ([]byte, error) {
	type NoMethod BackupVault
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// DailySchedule: Make a snapshot every day e.g. at 04:00, 05:20, 23:50
type DailySchedule struct {
	// Hour: Set the hour to start the snapshot (0-23), defaults to midnight (0).
	Hour float64 `json:"hour,omitempty"`
	// Minute: Set the minute of the hour to start the snapshot (0-59), defaults to
	// the top of the hour (0).
	Minute float64 `json:"minute,omitempty"`
	// SnapshotsToKeep: The maximum number of Snapshots to keep for the hourly
	// schedule
	SnapshotsToKeep float64 `json:"snapshotsToKeep,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hour") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hour") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DailySchedule) MarshalJSON() ([]byte, error) {
	type NoMethod DailySchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DailySchedule) UnmarshalJSON(data []byte) error {
	type NoMethod DailySchedule
	var s1 struct {
		Hour            gensupport.JSONFloat64 `json:"hour"`
		Minute          gensupport.JSONFloat64 `json:"minute"`
		SnapshotsToKeep gensupport.JSONFloat64 `json:"snapshotsToKeep"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Hour = float64(s1.Hour)
	s.Minute = float64(s1.Minute)
	s.SnapshotsToKeep = float64(s1.SnapshotsToKeep)
	return nil
}

// DestinationVolumeParameters: DestinationVolumeParameters specify input
// parameters used for creating destination volume.
type DestinationVolumeParameters struct {
	// Description: Description for the destination volume.
	Description string `json:"description,omitempty"`
	// ShareName: Destination volume's share name. If not specified, source
	// volume's share name will be used.
	ShareName string `json:"shareName,omitempty"`
	// StoragePool: Required. Existing destination StoragePool name.
	StoragePool string `json:"storagePool,omitempty"`
	// TieringPolicy: Optional. Tiering policy for the volume.
	TieringPolicy *TieringPolicy `json:"tieringPolicy,omitempty"`
	// VolumeId: Desired destination volume resource id. If not specified, source
	// volume's resource id will be used. This value must start with a lowercase
	// letter followed by up to 62 lowercase letters, numbers, or hyphens, and
	// cannot end with a hyphen.
	VolumeId string `json:"volumeId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DestinationVolumeParameters) MarshalJSON() ([]byte, error) {
	type NoMethod DestinationVolumeParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EncryptVolumesRequest: EncryptVolumesRequest specifies the KMS config to
// encrypt existing volumes.
type EncryptVolumesRequest struct {
}

// EstablishPeeringRequest: EstablishPeeringRequest establishes cluster and svm
// peerings between the source and the destination replications.
type EstablishPeeringRequest struct {
	// PeerClusterName: Required. Name of the user's local source cluster to be
	// peered with the destination cluster.
	PeerClusterName string `json:"peerClusterName,omitempty"`
	// PeerIpAddresses: Optional. List of IPv4 ip addresses to be used for peering.
	PeerIpAddresses []string `json:"peerIpAddresses,omitempty"`
	// PeerSvmName: Required. Name of the user's local source vserver svm to be
	// peered with the destination vserver svm.
	PeerSvmName string `json:"peerSvmName,omitempty"`
	// PeerVolumeName: Required. Name of the user's local source volume to be
	// peered with the destination volume.
	PeerVolumeName string `json:"peerVolumeName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PeerClusterName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PeerClusterName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EstablishPeeringRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EstablishPeeringRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportPolicy: Defines the export policy for the volume.
type ExportPolicy struct {
	// Rules: Required. List of export policy rules
	Rules []*SimpleExportPolicyRule `json:"rules,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Rules") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Rules") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ExportPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// HourlySchedule: Make a snapshot every hour e.g. at 04:00, 05:00, 06:00.
type HourlySchedule struct {
	// Minute: Set the minute of the hour to start the snapshot (0-59), defaults to
	// the top of the hour (0).
	Minute float64 `json:"minute,omitempty"`
	// SnapshotsToKeep: The maximum number of Snapshots to keep for the hourly
	// schedule
	SnapshotsToKeep float64 `json:"snapshotsToKeep,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Minute") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Minute") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HourlySchedule) MarshalJSON() ([]byte, error) {
	type NoMethod HourlySchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *HourlySchedule) UnmarshalJSON(data []byte) error {
	type NoMethod HourlySchedule
	var s1 struct {
		Minute          gensupport.JSONFloat64 `json:"minute"`
		SnapshotsToKeep gensupport.JSONFloat64 `json:"snapshotsToKeep"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Minute = float64(s1.Minute)
	s.SnapshotsToKeep = float64(s1.SnapshotsToKeep)
	return nil
}

// HybridPeeringDetails: HybridPeeringDetails contains details about the hybrid
// peering.
type HybridPeeringDetails struct {
	// Command: Output only. Copy-paste-able commands to be used on user's ONTAP to
	// accept peering requests.
	Command string `json:"command,omitempty"`
	// CommandExpiryTime: Output only. Expiration time for the peering command to
	// be executed on user's ONTAP.
	CommandExpiryTime string `json:"commandExpiryTime,omitempty"`
	// Passphrase: Output only. Temporary passphrase generated to accept cluster
	// peering command.
	Passphrase string `json:"passphrase,omitempty"`
	// PeerClusterName: Output only. Name of the user's local source cluster to be
	// peered with the destination cluster.
	PeerClusterName string `json:"peerClusterName,omitempty"`
	// PeerSvmName: Output only. Name of the user's local source vserver svm to be
	// peered with the destination vserver svm.
	PeerSvmName string `json:"peerSvmName,omitempty"`
	// PeerVolumeName: Output only. Name of the user's local source volume to be
	// peered with the destination volume.
	PeerVolumeName string `json:"peerVolumeName,omitempty"`
	// SubnetIp: Output only. IP address of the subnet.
	SubnetIp string `json:"subnetIp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Command") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Command") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HybridPeeringDetails) MarshalJSON() ([]byte, error) {
	type NoMethod HybridPeeringDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HybridReplicationParameters: The Hybrid Replication parameters for the
// volume.
type HybridReplicationParameters struct {
	// ClusterLocation: Optional. Name of source cluster location associated with
	// the Hybrid replication. This is a free-form field for the display purpose
	// only.
	ClusterLocation string `json:"clusterLocation,omitempty"`
	// Description: Optional. Description of the replication.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Labels to be added to the replication as the key value
	// pairs.
	Labels map[string]string `json:"labels,omitempty"`
	// PeerClusterName: Required. Name of the user's local source cluster to be
	// peered with the destination cluster.
	PeerClusterName string `json:"peerClusterName,omitempty"`
	// PeerIpAddresses: Required. List of node ip addresses to be peered with.
	PeerIpAddresses []string `json:"peerIpAddresses,omitempty"`
	// PeerSvmName: Required. Name of the user's local source vserver svm to be
	// peered with the destination vserver svm.
	PeerSvmName string `json:"peerSvmName,omitempty"`
	// PeerVolumeName: Required. Name of the user's local source volume to be
	// peered with the destination volume.
	PeerVolumeName string `json:"peerVolumeName,omitempty"`
	// Replication: Required. Desired name for the replication of this volume.
	Replication string `json:"replication,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterLocation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HybridReplicationParameters) MarshalJSON() ([]byte, error) {
	type NoMethod HybridReplicationParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KmsConfig: KmsConfig is the customer managed encryption key(CMEK)
// configuration.
type KmsConfig struct {
	// CreateTime: Output only. Create time of the KmsConfig.
	CreateTime string `json:"createTime,omitempty"`
	// CryptoKeyName: Required. Customer managed crypto key resource full name.
	// Format:
	// projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{key}.
	CryptoKeyName string `json:"cryptoKeyName,omitempty"`
	// Description: Description of the KmsConfig.
	Description string `json:"description,omitempty"`
	// Instructions: Output only. Instructions to provide the access to the
	// customer provided encryption key.
	Instructions string `json:"instructions,omitempty"`
	// Labels: Labels as key value pairs
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the KmsConfig.
	Name string `json:"name,omitempty"`
	// ServiceAccount: Output only. The Service account which will have access to
	// the customer provided encryption key.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// State: Output only. State of the KmsConfig.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified KmsConfig State
	//   "READY" - KmsConfig State is Ready
	//   "CREATING" - KmsConfig State is Creating
	//   "DELETING" - KmsConfig State is Deleting
	//   "UPDATING" - KmsConfig State is Updating
	//   "IN_USE" - KmsConfig State is In Use.
	//   "ERROR" - KmsConfig State is Error
	//   "KEY_CHECK_PENDING" - KmsConfig State is Pending to verify crypto key
	// access.
	//   "KEY_NOT_REACHABLE" - KmsConfig State is Not accessbile by the SDE service
	// account to the crypto key.
	//   "DISABLING" - KmsConfig State is Disabling.
	//   "DISABLED" - KmsConfig State is Disabled.
	//   "MIGRATING" - KmsConfig State is Migrating. The existing volumes are
	// migrating from SMEK to CMEK.
	State string `json:"state,omitempty"`
	// StateDetails: Output only. State details of the KmsConfig.
	StateDetails string `json:"stateDetails,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KmsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod KmsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListActiveDirectoriesResponse: ListActiveDirectoriesResponse contains all
// the active directories requested.
type ListActiveDirectoriesResponse struct {
	// ActiveDirectories: The list of active directories.
	ActiveDirectories []*ActiveDirectory `json:"activeDirectories,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveDirectories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveDirectories") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListActiveDirectoriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListActiveDirectoriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBackupPoliciesResponse: ListBackupPoliciesResponse contains all the
// backup policies requested.
type ListBackupPoliciesResponse struct {
	// BackupPolicies: The list of backup policies.
	BackupPolicies []*BackupPolicy `json:"backupPolicies,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupPolicies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupPolicies") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBackupPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBackupPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBackupVaultsResponse: ListBackupVaultsResponse is the result of
// ListBackupVaultsRequest.
type ListBackupVaultsResponse struct {
	// BackupVaults: A list of backupVaults in the project for the specified
	// location.
	BackupVaults []*BackupVault `json:"backupVaults,omitempty"`
	// NextPageToken: The token you can use to retrieve the next page of results.
	// Not returned if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupVaults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupVaults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBackupVaultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBackupVaultsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBackupsResponse: ListBackupsResponse is the result of
// ListBackupsRequest.
type ListBackupsResponse struct {
	// Backups: A list of backups in the project.
	Backups []*Backup `json:"backups,omitempty"`
	// NextPageToken: The token you can use to retrieve the next page of results.
	// Not returned if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Backups") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBackupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBackupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListKmsConfigsResponse: ListKmsConfigsResponse is the response to a
// ListKmsConfigsRequest.
type ListKmsConfigsResponse struct {
	// KmsConfigs: The list of KmsConfigs
	KmsConfigs []*KmsConfig `json:"kmsConfigs,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KmsConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListKmsConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListKmsConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListQuotaRulesResponse: ListQuotaRulesResponse is the response to a
// ListQuotaRulesRequest.
type ListQuotaRulesResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QuotaRules: List of quota rules
	QuotaRules []*QuotaRule `json:"quotaRules,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListQuotaRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListQuotaRulesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReplicationsResponse: ListReplicationsResponse is the result of
// ListReplicationsRequest.
type ListReplicationsResponse struct {
	// NextPageToken: The token you can use to retrieve the next page of results.
	// Not returned if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Replications: A list of replications in the project for the specified
	// volume.
	Replications []*Replication `json:"replications,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReplicationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReplicationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSnapshotsResponse: ListSnapshotsResponse is the result of
// ListSnapshotsRequest.
type ListSnapshotsResponse struct {
	// NextPageToken: The token you can use to retrieve the next page of results.
	// Not returned if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Snapshots: A list of snapshots in the project for the specified volume.
	Snapshots []*Snapshot `json:"snapshots,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSnapshotsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSnapshotsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListStoragePoolsResponse: ListStoragePoolsResponse is the response to a
// ListStoragePoolsRequest.
type ListStoragePoolsResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// StoragePools: The list of StoragePools
	StoragePools []*StoragePool `json:"storagePools,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListStoragePoolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListStoragePoolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListVolumesResponse: Message for response to listing Volumes
type ListVolumesResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`
	// Volumes: The list of Volume
	Volumes []*Volume `json:"volumes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListVolumesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVolumesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocationMetadata: Metadata for a given google.cloud.location.Location.
type LocationMetadata struct {
	// SupportedFlexPerformance: Output only. Supported flex performance in a
	// location.
	//
	// Possible values:
	//   "FLEX_PERFORMANCE_UNSPECIFIED" - Unspecified flex performance.
	//   "FLEX_PERFORMANCE_DEFAULT" - Flex Storage Pool with default performance.
	//   "FLEX_PERFORMANCE_CUSTOM" - Flex Storage Pool with custom performance.
	SupportedFlexPerformance []string `json:"supportedFlexPerformance,omitempty"`
	// SupportedServiceLevels: Output only. Supported service levels in a location.
	//
	// Possible values:
	//   "SERVICE_LEVEL_UNSPECIFIED" - Unspecified service level.
	//   "PREMIUM" - Premium service level.
	//   "EXTREME" - Extreme service level.
	//   "STANDARD" - Standard service level.
	//   "FLEX" - Flex service level.
	SupportedServiceLevels []string `json:"supportedServiceLevels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SupportedFlexPerformance")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SupportedFlexPerformance") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod LocationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MonthlySchedule: Make a snapshot once a month e.g. at 2nd 04:00, 7th 05:20,
// 24th 23:50
type MonthlySchedule struct {
	// DaysOfMonth: Set the day or days of the month to make a snapshot (1-31).
	// Accepts a comma separated number of days. Defaults to '1'.
	DaysOfMonth string `json:"daysOfMonth,omitempty"`
	// Hour: Set the hour to start the snapshot (0-23), defaults to midnight (0).
	Hour float64 `json:"hour,omitempty"`
	// Minute: Set the minute of the hour to start the snapshot (0-59), defaults to
	// the top of the hour (0).
	Minute float64 `json:"minute,omitempty"`
	// SnapshotsToKeep: The maximum number of Snapshots to keep for the hourly
	// schedule
	SnapshotsToKeep float64 `json:"snapshotsToKeep,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DaysOfMonth") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DaysOfMonth") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MonthlySchedule) MarshalJSON() ([]byte, error) {
	type NoMethod MonthlySchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *MonthlySchedule) UnmarshalJSON(data []byte) error {
	type NoMethod MonthlySchedule
	var s1 struct {
		Hour            gensupport.JSONFloat64 `json:"hour"`
		Minute          gensupport.JSONFloat64 `json:"minute"`
		SnapshotsToKeep gensupport.JSONFloat64 `json:"snapshotsToKeep"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Hour = float64(s1.Hour)
	s.Minute = float64(s1.Minute)
	s.SnapshotsToKeep = float64(s1.SnapshotsToKeep)
	return nil
}

// MountOption: View only mount options for a volume.
type MountOption struct {
	// Export: Export string
	Export string `json:"export,omitempty"`
	// ExportFull: Full export string
	ExportFull string `json:"exportFull,omitempty"`
	// Instructions: Instructions for mounting
	Instructions string `json:"instructions,omitempty"`
	// IpAddress: Output only. IP Address.
	IpAddress string `json:"ipAddress,omitempty"`
	// Protocol: Protocol to mount with.
	//
	// Possible values:
	//   "PROTOCOLS_UNSPECIFIED" - Unspecified protocol
	//   "NFSV3" - NFS V3 protocol
	//   "NFSV4" - NFS V4 protocol
	//   "SMB" - SMB protocol
	Protocol string `json:"protocol,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Export") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Export") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MountOption) MarshalJSON() ([]byte, error) {
	type NoMethod MountOption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been canceled
	// successfully have Operation.error value with a google.rpc.Status.code of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QuotaRule: QuotaRule specifies the maximum disk space a user or group can
// use within a volume. They can be used for creating default and individual
// quota rules.
type QuotaRule struct {
	// CreateTime: Output only. Create time of the quota rule
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the quota rule
	Description string `json:"description,omitempty"`
	// DiskLimitMib: Required. The maximum allowed disk space in MiB.
	DiskLimitMib int64 `json:"diskLimitMib,omitempty"`
	// Labels: Optional. Labels of the quota rule
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the quota rule. Format:
	// `projects/{project_number}/locations/{location_id}/volumes/volumes/{volume_id
	// }/quotaRules/{quota_rule_id}`.
	Name string `json:"name,omitempty"`
	// State: Output only. State of the quota rule
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state for quota rule
	//   "CREATING" - Quota rule is creating
	//   "UPDATING" - Quota rule is updating
	//   "DELETING" - Quota rule is deleting
	//   "READY" - Quota rule is ready
	//   "ERROR" - Quota rule is in error state.
	State string `json:"state,omitempty"`
	// StateDetails: Output only. State details of the quota rule
	StateDetails string `json:"stateDetails,omitempty"`
	// Target: Optional. The quota rule applies to the specified user or group,
	// identified by a Unix UID/GID, Windows SID, or null for default.
	Target string `json:"target,omitempty"`
	// Type: Required. The type of quota rule.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified type for quota rule
	//   "INDIVIDUAL_USER_QUOTA" - Individual user quota rule
	//   "INDIVIDUAL_GROUP_QUOTA" - Individual group quota rule
	//   "DEFAULT_USER_QUOTA" - Default user quota rule
	//   "DEFAULT_GROUP_QUOTA" - Default group quota rule
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QuotaRule) MarshalJSON() ([]byte, error) {
	type NoMethod QuotaRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Replication: Replication is a nested resource under Volume, that describes a
// cross-region replication relationship between 2 volumes in different
// regions.
type Replication struct {
	// ClusterLocation: Optional. Location of the user cluster.
	ClusterLocation string `json:"clusterLocation,omitempty"`
	// CreateTime: Output only. Replication create time.
	CreateTime string `json:"createTime,omitempty"`
	// Description: A description about this replication relationship.
	Description string `json:"description,omitempty"`
	// DestinationVolume: Output only. Full name of destination volume resource.
	// Example : "projects/{project}/locations/{location}/volumes/{volume_id}"
	DestinationVolume string `json:"destinationVolume,omitempty"`
	// DestinationVolumeParameters: Required. Input only. Destination volume
	// parameters
	DestinationVolumeParameters *DestinationVolumeParameters `json:"destinationVolumeParameters,omitempty"`
	// Healthy: Output only. Condition of the relationship. Can be one of the
	// following: - true: The replication relationship is healthy. It has not
	// missed the most recent scheduled transfer. - false: The replication
	// relationship is not healthy. It has missed the most recent scheduled
	// transfer.
	Healthy bool `json:"healthy,omitempty"`
	// HybridPeeringDetails: Output only. Hybrid peering details.
	HybridPeeringDetails *HybridPeeringDetails `json:"hybridPeeringDetails,omitempty"`
	// HybridReplicationType: Output only. Type of the hybrid replication.
	//
	// Possible values:
	//   "HYBRID_REPLICATION_TYPE_UNSPECIFIED" - Unspecified hybrid replication
	// type.
	//   "MIGRATION" - Hybrid replication type for migration.
	//   "CONTINUOUS_REPLICATION" - Hybrid replication type for continuous
	// replication.
	HybridReplicationType string `json:"hybridReplicationType,omitempty"`
	// Labels: Resource labels to represent user provided metadata.
	Labels map[string]string `json:"labels,omitempty"`
	// MirrorState: Output only. Indicates the state of mirroring.
	//
	// Possible values:
	//   "MIRROR_STATE_UNSPECIFIED" - Unspecified MirrorState
	//   "PREPARING" - Destination volume is being prepared.
	//   "MIRRORED" - Destination volume has been initialized and is ready to
	// receive replication transfers.
	//   "STOPPED" - Destination volume is not receiving replication transfers.
	//   "TRANSFERRING" - Incremental replication is in progress.
	//   "BASELINE_TRANSFERRING" - Baseline replication is in progress.
	//   "ABORTED" - Replication is aborted.
	MirrorState string `json:"mirrorState,omitempty"`
	// Name: Identifier. The resource name of the Replication. Format:
	// `projects/{project_id}/locations/{location}/volumes/{volume_id}/replications/
	// {replication_id}`.
	Name string `json:"name,omitempty"`
	// ReplicationSchedule: Required. Indicates the schedule for replication.
	//
	// Possible values:
	//   "REPLICATION_SCHEDULE_UNSPECIFIED" - Unspecified ReplicationSchedule
	//   "EVERY_10_MINUTES" - Replication happens once every 10 minutes.
	//   "HOURLY" - Replication happens once every hour.
	//   "DAILY" - Replication happens once every day.
	ReplicationSchedule string `json:"replicationSchedule,omitempty"`
	// Role: Output only. Indicates whether this points to source or destination.
	//
	// Possible values:
	//   "REPLICATION_ROLE_UNSPECIFIED" - Unspecified replication role
	//   "SOURCE" - Indicates Source volume.
	//   "DESTINATION" - Indicates Destination volume.
	Role string `json:"role,omitempty"`
	// SourceVolume: Output only. Full name of source volume resource. Example :
	// "projects/{project}/locations/{location}/volumes/{volume_id}"
	SourceVolume string `json:"sourceVolume,omitempty"`
	// State: Output only. State of the replication.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified replication State
	//   "CREATING" - Replication is creating.
	//   "READY" - Replication is ready.
	//   "UPDATING" - Replication is updating.
	//   "DELETING" - Replication is deleting.
	//   "ERROR" - Replication is in error state.
	//   "PENDING_CLUSTER_PEERING" - Replication is waiting for cluster peering to
	// be established.
	//   "PENDING_SVM_PEERING" - Replication is waiting for SVM peering to be
	// established.
	State string `json:"state,omitempty"`
	// StateDetails: Output only. State details of the replication.
	StateDetails string `json:"stateDetails,omitempty"`
	// TransferStats: Output only. Replication transfer statistics.
	TransferStats *TransferStats `json:"transferStats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClusterLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterLocation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Replication) MarshalJSON() ([]byte, error) {
	type NoMethod Replication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestoreParameters: The RestoreParameters if volume is created from a
// snapshot or backup.
type RestoreParameters struct {
	// SourceBackup: Full name of the backup resource. Format:
	// projects/{project}/locations/{location}/backupVaults/{backup_vault_id}/backup
	// s/{backup_id}
	SourceBackup string `json:"sourceBackup,omitempty"`
	// SourceSnapshot: Full name of the snapshot resource. Format:
	// projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}
	SourceSnapshot string `json:"sourceSnapshot,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SourceBackup") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceBackup") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestoreParameters) MarshalJSON() ([]byte, error) {
	type NoMethod RestoreParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResumeReplicationRequest: ResumeReplicationRequest resumes a stopped
// replication.
type ResumeReplicationRequest struct {
}

// ReverseReplicationDirectionRequest: ReverseReplicationDirectionRequest
// reverses direction of replication. Source becomes destination and
// destination becomes source.
type ReverseReplicationDirectionRequest struct {
}

// RevertVolumeRequest: RevertVolumeRequest reverts the given volume to the
// specified snapshot.
type RevertVolumeRequest struct {
	// SnapshotId: Required. The snapshot resource ID, in the format 'my-snapshot',
	// where the specified ID is the {snapshot_id} of the fully qualified name like
	// projects/{project_id}/locations/{location_id}/volumes/{volume_id}/snapshots/{
	// snapshot_id}
	SnapshotId string `json:"snapshotId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SnapshotId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SnapshotId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RevertVolumeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RevertVolumeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SimpleExportPolicyRule: An export policy rule describing various export
// options.
type SimpleExportPolicyRule struct {
	// AccessType: Access type (ReadWrite, ReadOnly, None)
	//
	// Possible values:
	//   "ACCESS_TYPE_UNSPECIFIED" - Unspecified Access Type
	//   "READ_ONLY" - Read Only
	//   "READ_WRITE" - Read Write
	//   "READ_NONE" - None
	AccessType string `json:"accessType,omitempty"`
	// AllowedClients: Comma separated list of allowed clients IP addresses
	AllowedClients string `json:"allowedClients,omitempty"`
	// HasRootAccess: Whether Unix root access will be granted.
	HasRootAccess string `json:"hasRootAccess,omitempty"`
	// Kerberos5ReadOnly: If enabled (true) the rule defines a read only access for
	// clients matching the 'allowedClients' specification. It enables nfs clients
	// to mount using 'authentication' kerberos security mode.
	Kerberos5ReadOnly bool `json:"kerberos5ReadOnly,omitempty"`
	// Kerberos5ReadWrite: If enabled (true) the rule defines read and write access
	// for clients matching the 'allowedClients' specification. It enables nfs
	// clients to mount using 'authentication' kerberos security mode. The
	// 'kerberos5ReadOnly' value be ignored if this is enabled.
	Kerberos5ReadWrite bool `json:"kerberos5ReadWrite,omitempty"`
	// Kerberos5iReadOnly: If enabled (true) the rule defines a read only access
	// for clients matching the 'allowedClients' specification. It enables nfs
	// clients to mount using 'integrity' kerberos security mode.
	Kerberos5iReadOnly bool `json:"kerberos5iReadOnly,omitempty"`
	// Kerberos5iReadWrite: If enabled (true) the rule defines read and write
	// access for clients matching the 'allowedClients' specification. It enables
	// nfs clients to mount using 'integrity' kerberos security mode. The
	// 'kerberos5iReadOnly' value be ignored if this is enabled.
	Kerberos5iReadWrite bool `json:"kerberos5iReadWrite,omitempty"`
	// Kerberos5pReadOnly: If enabled (true) the rule defines a read only access
	// for clients matching the 'allowedClients' specification. It enables nfs
	// clients to mount using 'privacy' kerberos security mode.
	Kerberos5pReadOnly bool `json:"kerberos5pReadOnly,omitempty"`
	// Kerberos5pReadWrite: If enabled (true) the rule defines read and write
	// access for clients matching the 'allowedClients' specification. It enables
	// nfs clients to mount using 'privacy' kerberos security mode. The
	// 'kerberos5pReadOnly' value be ignored if this is enabled.
	Kerberos5pReadWrite bool `json:"kerberos5pReadWrite,omitempty"`
	// Nfsv3: NFS V3 protocol.
	Nfsv3 bool `json:"nfsv3,omitempty"`
	// Nfsv4: NFS V4 protocol.
	Nfsv4 bool `json:"nfsv4,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SimpleExportPolicyRule) MarshalJSON() ([]byte, error) {
	type NoMethod SimpleExportPolicyRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Snapshot: Snapshot is a point-in-time version of a Volume's content.
type Snapshot struct {
	// CreateTime: Output only. The time when the snapshot was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: A description of the snapshot with 2048 characters or less.
	// Requests with longer descriptions will be rejected.
	Description string `json:"description,omitempty"`
	// Labels: Resource labels to represent user provided metadata.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the snapshot. Format:
	// `projects/{project_id}/locations/{location}/volumes/{volume_id}/snapshots/{sn
	// apshot_id}`.
	Name string `json:"name,omitempty"`
	// State: Output only. The snapshot state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified Snapshot State
	//   "READY" - Snapshot State is Ready
	//   "CREATING" - Snapshot State is Creating
	//   "DELETING" - Snapshot State is Deleting
	//   "UPDATING" - Snapshot State is Updating
	//   "DISABLED" - Snapshot State is Disabled
	//   "ERROR" - Snapshot State is Error
	State string `json:"state,omitempty"`
	// StateDetails: Output only. State details of the storage pool
	StateDetails string `json:"stateDetails,omitempty"`
	// UsedBytes: Output only. Current storage usage for the snapshot in bytes.
	UsedBytes float64 `json:"usedBytes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Snapshot) MarshalJSON() ([]byte, error) {
	type NoMethod Snapshot
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Snapshot) UnmarshalJSON(data []byte) error {
	type NoMethod Snapshot
	var s1 struct {
		UsedBytes gensupport.JSONFloat64 `json:"usedBytes"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UsedBytes = float64(s1.UsedBytes)
	return nil
}

// SnapshotPolicy: Snapshot Policy for a volume.
type SnapshotPolicy struct {
	// DailySchedule: Daily schedule policy.
	DailySchedule *DailySchedule `json:"dailySchedule,omitempty"`
	// Enabled: If enabled, make snapshots automatically according to the
	// schedules. Default is false.
	Enabled bool `json:"enabled,omitempty"`
	// HourlySchedule: Hourly schedule policy.
	HourlySchedule *HourlySchedule `json:"hourlySchedule,omitempty"`
	// MonthlySchedule: Monthly schedule policy.
	MonthlySchedule *MonthlySchedule `json:"monthlySchedule,omitempty"`
	// WeeklySchedule: Weekly schedule policy.
	WeeklySchedule *WeeklySchedule `json:"weeklySchedule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DailySchedule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DailySchedule") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SnapshotPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod SnapshotPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StopReplicationRequest: StopReplicationRequest stops a replication until
// resumed.
type StopReplicationRequest struct {
	// Force: Indicates whether to stop replication forcefully while data transfer
	// is in progress. Warning! if force is true, this will abort any current
	// transfers and can lead to data loss due to partial transfer. If force is
	// false, stop replication will fail while data transfer is in progress and you
	// will need to retry later.
	Force bool `json:"force,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Force") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Force") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StopReplicationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod StopReplicationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StoragePool: StoragePool is a container for volumes with a service level and
// capacity. Volumes can be created in a pool of sufficient available capacity.
// StoragePool capacity is what you are billed for.
type StoragePool struct {
	// ActiveDirectory: Optional. Specifies the Active Directory to be used for
	// creating a SMB volume.
	ActiveDirectory string `json:"activeDirectory,omitempty"`
	// AllowAutoTiering: Optional. True if the storage pool supports Auto Tiering
	// enabled volumes. Default is false. Auto-tiering can be enabled after storage
	// pool creation but it can't be disabled once enabled.
	AllowAutoTiering bool `json:"allowAutoTiering,omitempty"`
	// CapacityGib: Required. Capacity in GIB of the pool
	CapacityGib int64 `json:"capacityGib,omitempty,string"`
	// CreateTime: Output only. Create time of the storage pool
	CreateTime string `json:"createTime,omitempty"`
	// CustomPerformanceEnabled: Optional. True if using Independent Scaling of
	// capacity and performance (Hyperdisk) By default set to false
	CustomPerformanceEnabled bool `json:"customPerformanceEnabled,omitempty"`
	// Description: Optional. Description of the storage pool
	Description string `json:"description,omitempty"`
	// EncryptionType: Output only. Specifies the current pool encryption key
	// source.
	//
	// Possible values:
	//   "ENCRYPTION_TYPE_UNSPECIFIED" - The source of the encryption key is not
	// specified.
	//   "SERVICE_MANAGED" - Google managed encryption key.
	//   "CLOUD_KMS" - Customer managed encryption key, which is stored in KMS.
	EncryptionType string `json:"encryptionType,omitempty"`
	// GlobalAccessAllowed: Deprecated. Used to allow SO pool to access AD or DNS
	// server from other regions.
	GlobalAccessAllowed bool `json:"globalAccessAllowed,omitempty"`
	// KmsConfig: Optional. Specifies the KMS config to be used for volume
	// encryption.
	KmsConfig string `json:"kmsConfig,omitempty"`
	// Labels: Optional. Labels as key value pairs
	Labels map[string]string `json:"labels,omitempty"`
	// LdapEnabled: Optional. Flag indicating if the pool is NFS LDAP enabled or
	// not.
	LdapEnabled bool `json:"ldapEnabled,omitempty"`
	// Name: Identifier. Name of the storage pool
	Name string `json:"name,omitempty"`
	// Network: Required. VPC Network name. Format:
	// projects/{project}/global/networks/{network}
	Network string `json:"network,omitempty"`
	// PsaRange: Optional. This field is not implemented. The values provided in
	// this field are ignored.
	PsaRange string `json:"psaRange,omitempty"`
	// ReplicaZone: Optional. Specifies the replica zone for regional storagePool.
	ReplicaZone string `json:"replicaZone,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ServiceLevel: Required. Service level of the storage pool
	//
	// Possible values:
	//   "SERVICE_LEVEL_UNSPECIFIED" - Unspecified service level.
	//   "PREMIUM" - Premium service level.
	//   "EXTREME" - Extreme service level.
	//   "STANDARD" - Standard service level.
	//   "FLEX" - Flex service level.
	ServiceLevel string `json:"serviceLevel,omitempty"`
	// State: Output only. State of the storage pool
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified Storage Pool State
	//   "READY" - Storage Pool State is Ready
	//   "CREATING" - Storage Pool State is Creating
	//   "DELETING" - Storage Pool State is Deleting
	//   "UPDATING" - Storage Pool State is Updating
	//   "RESTORING" - Storage Pool State is Restoring
	//   "DISABLED" - Storage Pool State is Disabled
	//   "ERROR" - Storage Pool State is Error
	State string `json:"state,omitempty"`
	// StateDetails: Output only. State details of the storage pool
	StateDetails string `json:"stateDetails,omitempty"`
	// TotalIops: Optional. Custom Performance Total IOPS of the pool If not
	// provided, it will be calculated based on the total_throughput_mibps
	TotalIops int64 `json:"totalIops,omitempty,string"`
	// TotalThroughputMibps: Optional. Custom Performance Total Throughput of the
	// pool (in MiB/s)
	TotalThroughputMibps int64 `json:"totalThroughputMibps,omitempty,string"`
	// VolumeCapacityGib: Output only. Allocated size of all volumes in GIB in the
	// storage pool
	VolumeCapacityGib int64 `json:"volumeCapacityGib,omitempty,string"`
	// VolumeCount: Output only. Volume count of the storage pool
	VolumeCount int64 `json:"volumeCount,omitempty"`
	// Zone: Optional. Specifies the active zone for regional storagePool.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveDirectory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveDirectory") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StoragePool) MarshalJSON() ([]byte, error) {
	type NoMethod StoragePool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SwitchActiveReplicaZoneRequest: SwitchActiveReplicaZoneRequest switch the
// active/replica zone for a regional storagePool.
type SwitchActiveReplicaZoneRequest struct {
}

// SyncReplicationRequest: SyncReplicationRequest syncs the replication from
// source to destination.
type SyncReplicationRequest struct {
}

// TieringPolicy: Defines tiering policy for the volume.
type TieringPolicy struct {
	// CoolingThresholdDays: Optional. Time in days to mark the volume's data block
	// as cold and make it eligible for tiering, can be range from 2-183. Default
	// is 31.
	CoolingThresholdDays int64 `json:"coolingThresholdDays,omitempty"`
	// TierAction: Optional. Flag indicating if the volume has tiering policy
	// enable/pause. Default is PAUSED.
	//
	// Possible values:
	//   "TIER_ACTION_UNSPECIFIED" - Unspecified.
	//   "ENABLED" - When tiering is enabled, new cold data will be tiered.
	//   "PAUSED" - When paused, tiering won't be performed on new data. Existing
	// data stays tiered until accessed.
	TierAction string `json:"tierAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoolingThresholdDays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoolingThresholdDays") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TieringPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod TieringPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransferStats: TransferStats reports all statistics related to replication
// transfer.
type TransferStats struct {
	// LagDuration: Lag duration indicates the duration by which Destination region
	// volume content lags behind the primary region volume content.
	LagDuration string `json:"lagDuration,omitempty"`
	// LastTransferBytes: Last transfer size in bytes.
	LastTransferBytes int64 `json:"lastTransferBytes,omitempty,string"`
	// LastTransferDuration: Time taken during last transfer.
	LastTransferDuration string `json:"lastTransferDuration,omitempty"`
	// LastTransferEndTime: Time when last transfer completed.
	LastTransferEndTime string `json:"lastTransferEndTime,omitempty"`
	// LastTransferError: A message describing the cause of the last transfer
	// failure.
	LastTransferError string `json:"lastTransferError,omitempty"`
	// TotalTransferDuration: Cumulative time taken across all transfers for the
	// replication relationship.
	TotalTransferDuration string `json:"totalTransferDuration,omitempty"`
	// TransferBytes: Cumulative bytes transferred so far for the replication
	// relationship.
	TransferBytes int64 `json:"transferBytes,omitempty,string"`
	// UpdateTime: Time when progress was updated last.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LagDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LagDuration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransferStats) MarshalJSON() ([]byte, error) {
	type NoMethod TransferStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidateDirectoryServiceRequest: ValidateDirectoryServiceRequest validates
// the directory service policy attached to the storage pool.
type ValidateDirectoryServiceRequest struct {
	// DirectoryServiceType: Type of directory service policy attached to the
	// storage pool.
	//
	// Possible values:
	//   "DIRECTORY_SERVICE_TYPE_UNSPECIFIED" - Directory service type is not
	// specified.
	//   "ACTIVE_DIRECTORY" - Active directory policy attached to the storage pool.
	DirectoryServiceType string `json:"directoryServiceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DirectoryServiceType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DirectoryServiceType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidateDirectoryServiceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ValidateDirectoryServiceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VerifyKmsConfigRequest: VerifyKmsConfigRequest specifies the KMS config to
// be validated.
type VerifyKmsConfigRequest struct {
}

// VerifyKmsConfigResponse: VerifyKmsConfigResponse contains the information if
// the config is correctly and error message.
type VerifyKmsConfigResponse struct {
	// HealthError: Output only. Error message if config is not healthy.
	HealthError string `json:"healthError,omitempty"`
	// Healthy: Output only. If the customer key configured correctly to the
	// encrypt volume.
	Healthy bool `json:"healthy,omitempty"`
	// Instructions: Output only. Instructions for the customers to provide the
	// access to the encryption key.
	Instructions string `json:"instructions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "HealthError") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HealthError") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VerifyKmsConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod VerifyKmsConfigResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Volume: Volume provides a filesystem that you can mount.
type Volume struct {
	// ActiveDirectory: Output only. Specifies the ActiveDirectory name of a SMB
	// volume.
	ActiveDirectory string `json:"activeDirectory,omitempty"`
	// BackupConfig: BackupConfig of the volume.
	BackupConfig *BackupConfig `json:"backupConfig,omitempty"`
	// CapacityGib: Required. Capacity in GIB of the volume
	CapacityGib int64 `json:"capacityGib,omitempty,string"`
	// ColdTierSizeGib: Output only. Size of the volume cold tier data in GiB.
	ColdTierSizeGib int64 `json:"coldTierSizeGib,omitempty,string"`
	// CreateTime: Output only. Create time of the volume
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the volume
	Description string `json:"description,omitempty"`
	// EncryptionType: Output only. Specified the current volume encryption key
	// source.
	//
	// Possible values:
	//   "ENCRYPTION_TYPE_UNSPECIFIED" - The source of the encryption key is not
	// specified.
	//   "SERVICE_MANAGED" - Google managed encryption key.
	//   "CLOUD_KMS" - Customer managed encryption key, which is stored in KMS.
	EncryptionType string `json:"encryptionType,omitempty"`
	// ExportPolicy: Optional. Export policy of the volume
	ExportPolicy *ExportPolicy `json:"exportPolicy,omitempty"`
	// HasReplication: Output only. Indicates whether the volume is part of a
	// replication relationship.
	HasReplication bool `json:"hasReplication,omitempty"`
	// HybridReplicationParameters: Optional. The Hybrid Replication parameters for
	// the volume.
	HybridReplicationParameters *HybridReplicationParameters `json:"hybridReplicationParameters,omitempty"`
	// KerberosEnabled: Optional. Flag indicating if the volume is a kerberos
	// volume or not, export policy rules control kerberos security modes (krb5,
	// krb5i, krb5p).
	KerberosEnabled bool `json:"kerberosEnabled,omitempty"`
	// KmsConfig: Output only. Specifies the KMS config to be used for volume
	// encryption.
	KmsConfig string `json:"kmsConfig,omitempty"`
	// Labels: Optional. Labels as key value pairs
	Labels map[string]string `json:"labels,omitempty"`
	// LargeCapacity: Optional. Flag indicating if the volume will be a large
	// capacity volume or a regular volume.
	LargeCapacity bool `json:"largeCapacity,omitempty"`
	// LdapEnabled: Output only. Flag indicating if the volume is NFS LDAP enabled
	// or not.
	LdapEnabled bool `json:"ldapEnabled,omitempty"`
	// MountOptions: Output only. Mount options of this volume
	MountOptions []*MountOption `json:"mountOptions,omitempty"`
	// MultipleEndpoints: Optional. Flag indicating if the volume will have an IP
	// address per node for volumes supporting multiple IP endpoints. Only the
	// volume with large_capacity will be allowed to have multiple endpoints.
	MultipleEndpoints bool `json:"multipleEndpoints,omitempty"`
	// Name: Identifier. Name of the volume
	Name string `json:"name,omitempty"`
	// Network: Output only. VPC Network name. Format:
	// projects/{project}/global/networks/{network}
	Network string `json:"network,omitempty"`
	// Protocols: Required. Protocols required for the volume
	//
	// Possible values:
	//   "PROTOCOLS_UNSPECIFIED" - Unspecified protocol
	//   "NFSV3" - NFS V3 protocol
	//   "NFSV4" - NFS V4 protocol
	//   "SMB" - SMB protocol
	Protocols []string `json:"protocols,omitempty"`
	// PsaRange: Output only. This field is not implemented. The values provided in
	// this field are ignored.
	PsaRange string `json:"psaRange,omitempty"`
	// ReplicaZone: Output only. Specifies the replica zone for regional volume.
	ReplicaZone string `json:"replicaZone,omitempty"`
	// RestoreParameters: Optional. Specifies the source of the volume to be
	// created from.
	RestoreParameters *RestoreParameters `json:"restoreParameters,omitempty"`
	// RestrictedActions: Optional. List of actions that are restricted on this
	// volume.
	//
	// Possible values:
	//   "RESTRICTED_ACTION_UNSPECIFIED" - Unspecified restricted action
	//   "DELETE" - Prevent volume from being deleted when mounted.
	RestrictedActions []string `json:"restrictedActions,omitempty"`
	// SecurityStyle: Optional. Security Style of the Volume
	//
	// Possible values:
	//   "SECURITY_STYLE_UNSPECIFIED" - SecurityStyle is unspecified
	//   "NTFS" - SecurityStyle uses NTFS
	//   "UNIX" - SecurityStyle uses UNIX
	SecurityStyle string `json:"securityStyle,omitempty"`
	// ServiceLevel: Output only. Service level of the volume
	//
	// Possible values:
	//   "SERVICE_LEVEL_UNSPECIFIED" - Unspecified service level.
	//   "PREMIUM" - Premium service level.
	//   "EXTREME" - Extreme service level.
	//   "STANDARD" - Standard service level.
	//   "FLEX" - Flex service level.
	ServiceLevel string `json:"serviceLevel,omitempty"`
	// ShareName: Required. Share name of the volume
	ShareName string `json:"shareName,omitempty"`
	// SmbSettings: Optional. SMB share settings for the volume.
	//
	// Possible values:
	//   "SMB_SETTINGS_UNSPECIFIED" - Unspecified default option
	//   "ENCRYPT_DATA" - SMB setting encrypt data
	//   "BROWSABLE" - SMB setting browsable
	//   "CHANGE_NOTIFY" - SMB setting notify change
	//   "NON_BROWSABLE" - SMB setting not to notify change
	//   "OPLOCKS" - SMB setting oplocks
	//   "SHOW_SNAPSHOT" - SMB setting to show snapshots
	//   "SHOW_PREVIOUS_VERSIONS" - SMB setting to show previous versions
	//   "ACCESS_BASED_ENUMERATION" - SMB setting to access volume based on
	// enumerartion
	//   "CONTINUOUSLY_AVAILABLE" - Continuously available enumeration
	SmbSettings []string `json:"smbSettings,omitempty"`
	// SnapReserve: Optional. Snap_reserve specifies percentage of volume storage
	// reserved for snapshot storage. Default is 0 percent.
	SnapReserve float64 `json:"snapReserve,omitempty"`
	// SnapshotDirectory: Optional. Snapshot_directory if enabled (true) the volume
	// will contain a read-only .snapshot directory which provides access to each
	// of the volume's snapshots.
	SnapshotDirectory bool `json:"snapshotDirectory,omitempty"`
	// SnapshotPolicy: Optional. SnapshotPolicy for a volume.
	SnapshotPolicy *SnapshotPolicy `json:"snapshotPolicy,omitempty"`
	// State: Output only. State of the volume
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified Volume State
	//   "READY" - Volume State is Ready
	//   "CREATING" - Volume State is Creating
	//   "DELETING" - Volume State is Deleting
	//   "UPDATING" - Volume State is Updating
	//   "RESTORING" - Volume State is Restoring
	//   "DISABLED" - Volume State is Disabled
	//   "ERROR" - Volume State is Error
	//   "PREPARING" - Volume State is Preparing. Note that this is different from
	// CREATING where CREATING means the volume is being created, while PREPARING
	// means the volume is created and now being prepared for the replication.
	//   "READ_ONLY" - Volume State is Read Only
	State string `json:"state,omitempty"`
	// StateDetails: Output only. State details of the volume
	StateDetails string `json:"stateDetails,omitempty"`
	// StoragePool: Required. StoragePool name of the volume
	StoragePool string `json:"storagePool,omitempty"`
	// TieringPolicy: Tiering policy for the volume.
	TieringPolicy *TieringPolicy `json:"tieringPolicy,omitempty"`
	// UnixPermissions: Optional. Default unix style permission (e.g. 777) the
	// mount point will be created with. Applicable for NFS protocol types only.
	UnixPermissions string `json:"unixPermissions,omitempty"`
	// UsedGib: Output only. Used capacity in GIB of the volume. This is computed
	// periodically and it does not represent the realtime usage.
	UsedGib int64 `json:"usedGib,omitempty,string"`
	// Zone: Output only. Specifies the active zone for regional volume.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveDirectory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveDirectory") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Volume) MarshalJSON() ([]byte, error) {
	type NoMethod Volume
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Volume) UnmarshalJSON(data []byte) error {
	type NoMethod Volume
	var s1 struct {
		SnapReserve gensupport.JSONFloat64 `json:"snapReserve"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SnapReserve = float64(s1.SnapReserve)
	return nil
}

// WeeklySchedule: Make a snapshot every week e.g. at Monday 04:00, Wednesday
// 05:20, Sunday 23:50
type WeeklySchedule struct {
	// Day: Set the day or days of the week to make a snapshot. Accepts a comma
	// separated days of the week. Defaults to 'Sunday'.
	Day string `json:"day,omitempty"`
	// Hour: Set the hour to start the snapshot (0-23), defaults to midnight (0).
	Hour float64 `json:"hour,omitempty"`
	// Minute: Set the minute of the hour to start the snapshot (0-59), defaults to
	// the top of the hour (0).
	Minute float64 `json:"minute,omitempty"`
	// SnapshotsToKeep: The maximum number of Snapshots to keep for the hourly
	// schedule
	SnapshotsToKeep float64 `json:"snapshotsToKeep,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WeeklySchedule) MarshalJSON() ([]byte, error) {
	type NoMethod WeeklySchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *WeeklySchedule) UnmarshalJSON(data []byte) error {
	type NoMethod WeeklySchedule
	var s1 struct {
		Hour            gensupport.JSONFloat64 `json:"hour"`
		Minute          gensupport.JSONFloat64 `json:"minute"`
		SnapshotsToKeep gensupport.JSONFloat64 `json:"snapshotsToKeep"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Hour = float64(s1.Hour)
	s.Minute = float64(s1.Minute)
	s.SnapshotsToKeep = float64(s1.SnapshotsToKeep)
	return nil
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": A list
// of extra location types that should be used as conditions for controlling
// the visibility of the locations.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsActiveDirectoriesCreateCall struct {
	s               *Service
	parent          string
	activedirectory *ActiveDirectory
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: CreateActiveDirectory Creates the active directory specified in the
// request.
//
// - parent: Value for parent.
func (r *ProjectsLocationsActiveDirectoriesService) Create(parent string, activedirectory *ActiveDirectory) *ProjectsLocationsActiveDirectoriesCreateCall {
	c := &ProjectsLocationsActiveDirectoriesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.activedirectory = activedirectory
	return c
}

// ActiveDirectoryId sets the optional parameter "activeDirectoryId": Required.
// ID of the active directory to create. Must be unique within the parent
// resource. Must contain only letters, numbers and hyphen, with the first
// character a letter , the last a letter or a number, and a 63 character
// maximum.
func (c *ProjectsLocationsActiveDirectoriesCreateCall) ActiveDirectoryId(activeDirectoryId string) *ProjectsLocationsActiveDirectoriesCreateCall {
	c.urlParams_.Set("activeDirectoryId", activeDirectoryId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsActiveDirectoriesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsActiveDirectoriesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsActiveDirectoriesCreateCall) Context(ctx context.Context) *ProjectsLocationsActiveDirectoriesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsActiveDirectoriesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsActiveDirectoriesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.activedirectory)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/activeDirectories")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.activeDirectories.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsActiveDirectoriesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsActiveDirectoriesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete the active directory specified in the request.
//
// - name: Name of the active directory.
func (r *ProjectsLocationsActiveDirectoriesService) Delete(name string) *ProjectsLocationsActiveDirectoriesDeleteCall {
	c := &ProjectsLocationsActiveDirectoriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsActiveDirectoriesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsActiveDirectoriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsActiveDirectoriesDeleteCall) Context(ctx context.Context) *ProjectsLocationsActiveDirectoriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsActiveDirectoriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsActiveDirectoriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.activeDirectories.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsActiveDirectoriesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsActiveDirectoriesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes a specified active directory.
//
// - name: Name of the active directory.
func (r *ProjectsLocationsActiveDirectoriesService) Get(name string) *ProjectsLocationsActiveDirectoriesGetCall {
	c := &ProjectsLocationsActiveDirectoriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsActiveDirectoriesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsActiveDirectoriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsActiveDirectoriesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsActiveDirectoriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsActiveDirectoriesGetCall) Context(ctx context.Context) *ProjectsLocationsActiveDirectoriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsActiveDirectoriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsActiveDirectoriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.activeDirectories.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ActiveDirectory.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsActiveDirectoriesGetCall) Do(opts ...googleapi.CallOption) (*ActiveDirectory, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ActiveDirectory{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsActiveDirectoriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists active directories.
//
// - parent: Parent value for ListActiveDirectoriesRequest.
func (r *ProjectsLocationsActiveDirectoriesService) List(parent string) *ProjectsLocationsActiveDirectoriesListCall {
	c := &ProjectsLocationsActiveDirectoriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results
func (c *ProjectsLocationsActiveDirectoriesListCall) Filter(filter string) *ProjectsLocationsActiveDirectoriesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results
func (c *ProjectsLocationsActiveDirectoriesListCall) OrderBy(orderBy string) *ProjectsLocationsActiveDirectoriesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, the server will pick
// an appropriate default.
func (c *ProjectsLocationsActiveDirectoriesListCall) PageSize(pageSize int64) *ProjectsLocationsActiveDirectoriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsActiveDirectoriesListCall) PageToken(pageToken string) *ProjectsLocationsActiveDirectoriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsActiveDirectoriesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsActiveDirectoriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsActiveDirectoriesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsActiveDirectoriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsActiveDirectoriesListCall) Context(ctx context.Context) *ProjectsLocationsActiveDirectoriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsActiveDirectoriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsActiveDirectoriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/activeDirectories")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.activeDirectories.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListActiveDirectoriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsActiveDirectoriesListCall) Do(opts ...googleapi.CallOption) (*ListActiveDirectoriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListActiveDirectoriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsActiveDirectoriesListCall) Pages(ctx context.Context, f func(*ListActiveDirectoriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsActiveDirectoriesPatchCall struct {
	s               *Service
	name            string
	activedirectory *ActiveDirectory
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Update the parameters of an active directories.
//
//   - name: Identifier. The resource name of the active directory. Format:
//     `projects/{project_number}/locations/{location_id}/activeDirectories/{activ
//     e_directory_id}`.
func (r *ProjectsLocationsActiveDirectoriesService) Patch(name string, activedirectory *ActiveDirectory) *ProjectsLocationsActiveDirectoriesPatchCall {
	c := &ProjectsLocationsActiveDirectoriesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.activedirectory = activedirectory
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the Active Directory
// resource by the update. The fields specified in the update_mask are relative
// to the resource, not the full request. A field will be overwritten if it is
// in the mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsActiveDirectoriesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsActiveDirectoriesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsActiveDirectoriesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsActiveDirectoriesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsActiveDirectoriesPatchCall) Context(ctx context.Context) *ProjectsLocationsActiveDirectoriesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsActiveDirectoriesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsActiveDirectoriesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.activedirectory)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.activeDirectories.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsActiveDirectoriesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.activeDirectories.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupPoliciesCreateCall struct {
	s            *Service
	parent       string
	backuppolicy *BackupPolicy
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates new backup policy
//
//   - parent: The location to create the backup policies of, in the format
//     `projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsBackupPoliciesService) Create(parent string, backuppolicy *BackupPolicy) *ProjectsLocationsBackupPoliciesCreateCall {
	c := &ProjectsLocationsBackupPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.backuppolicy = backuppolicy
	return c
}

// BackupPolicyId sets the optional parameter "backupPolicyId": Required. The
// ID to use for the backup policy. The ID must be unique within the specified
// location. Must contain only letters, numbers and hyphen, with the first
// character a letter, the last a letter or a number, and a 63 character
// maximum.
func (c *ProjectsLocationsBackupPoliciesCreateCall) BackupPolicyId(backupPolicyId string) *ProjectsLocationsBackupPoliciesCreateCall {
	c.urlParams_.Set("backupPolicyId", backupPolicyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsBackupPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backuppolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backupPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Warning! This operation will permanently delete the backup policy.
//
//   - name: The backup policy resource name, in the format
//     `projects/{project_id}/locations/{location}/backupPolicies/{backup_policy_i
//     d}`.
func (r *ProjectsLocationsBackupPoliciesService) Delete(name string) *ProjectsLocationsBackupPoliciesDeleteCall {
	c := &ProjectsLocationsBackupPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsBackupPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the description of the specified backup policy by
// backup_policy_id.
//
//   - name: The backupPolicy resource name, in the format
//     `projects/{project_id}/locations/{location}/backupPolicies/{backup_policy_i
//     d}`.
func (r *ProjectsLocationsBackupPoliciesService) Get(name string) *ProjectsLocationsBackupPoliciesGetCall {
	c := &ProjectsLocationsBackupPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsBackupPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *BackupPolicy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPoliciesGetCall) Do(opts ...googleapi.CallOption) (*BackupPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BackupPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns list of all available backup policies.
//
// - parent: Parent value for ListBackupPoliciesRequest.
func (r *ProjectsLocationsBackupPoliciesService) List(parent string) *ProjectsLocationsBackupPoliciesListCall {
	c := &ProjectsLocationsBackupPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results
func (c *ProjectsLocationsBackupPoliciesListCall) Filter(filter string) *ProjectsLocationsBackupPoliciesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results
func (c *ProjectsLocationsBackupPoliciesListCall) OrderBy(orderBy string) *ProjectsLocationsBackupPoliciesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, the server will pick
// an appropriate default.
func (c *ProjectsLocationsBackupPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsBackupPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsBackupPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsBackupPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsBackupPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backupPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBackupPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListBackupPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBackupPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackupPoliciesListCall) Pages(ctx context.Context, f func(*ListBackupPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackupPoliciesPatchCall struct {
	s            *Service
	name         string
	backuppolicy *BackupPolicy
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates settings of a specific backup policy.
//
//   - name: Identifier. The resource name of the backup policy. Format:
//     `projects/{project_id}/locations/{location}/backupPolicies/{backup_policy_i
//     d}`.
func (r *ProjectsLocationsBackupPoliciesService) Patch(name string, backuppolicy *BackupPolicy) *ProjectsLocationsBackupPoliciesPatchCall {
	c := &ProjectsLocationsBackupPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.backuppolicy = backuppolicy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the Backup Policy resource
// by the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsBackupPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBackupPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsBackupPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backuppolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupVaultsCreateCall struct {
	s           *Service
	parent      string
	backupvault *BackupVault
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates new backup vault
//
//   - parent: The location to create the backup vaults, in the format
//     `projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsBackupVaultsService) Create(parent string, backupvault *BackupVault) *ProjectsLocationsBackupVaultsCreateCall {
	c := &ProjectsLocationsBackupVaultsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.backupvault = backupvault
	return c
}

// BackupVaultId sets the optional parameter "backupVaultId": Required. The ID
// to use for the backupVault. The ID must be unique within the specified
// location. Must contain only letters, numbers and hyphen, with the first
// character a letter, the last a letter or a number, and a 63 character
// maximum.
func (c *ProjectsLocationsBackupVaultsCreateCall) BackupVaultId(backupVaultId string) *ProjectsLocationsBackupVaultsCreateCall {
	c.urlParams_.Set("backupVaultId", backupVaultId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsCreateCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backupvault)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backupVaults")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupVaultsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupVaultsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Warning! This operation will permanently delete the backup vault.
//
//   - name: The backupVault resource name, in the format
//     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`.
func (r *ProjectsLocationsBackupVaultsService) Delete(name string) *ProjectsLocationsBackupVaultsDeleteCall {
	c := &ProjectsLocationsBackupVaultsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsDeleteCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupVaultsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupVaultsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the description of the specified backup vault
//
//   - name: The backupVault resource name, in the format
//     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`.
func (r *ProjectsLocationsBackupVaultsService) Get(name string) *ProjectsLocationsBackupVaultsGetCall {
	c := &ProjectsLocationsBackupVaultsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupVaultsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupVaultsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsGetCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *BackupVault.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupVaultsGetCall) Do(opts ...googleapi.CallOption) (*BackupVault, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BackupVault{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupVaultsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns list of all available backup vaults.
//
//   - parent: The location for which to retrieve backupVault information, in the
//     format `projects/{project_id}/locations/{location}`.
func (r *ProjectsLocationsBackupVaultsService) List(parent string) *ProjectsLocationsBackupVaultsListCall {
	c := &ProjectsLocationsBackupVaultsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": List filter.
func (c *ProjectsLocationsBackupVaultsListCall) Filter(filter string) *ProjectsLocationsBackupVaultsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort results. Supported
// values are "name", "name desc" or "" (unsorted).
func (c *ProjectsLocationsBackupVaultsListCall) OrderBy(orderBy string) *ProjectsLocationsBackupVaultsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return.
func (c *ProjectsLocationsBackupVaultsListCall) PageSize(pageSize int64) *ProjectsLocationsBackupVaultsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// to use if there are additional results to retrieve for this list request.
func (c *ProjectsLocationsBackupVaultsListCall) PageToken(pageToken string) *ProjectsLocationsBackupVaultsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupVaultsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupVaultsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsListCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backupVaults")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBackupVaultsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupVaultsListCall) Do(opts ...googleapi.CallOption) (*ListBackupVaultsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBackupVaultsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackupVaultsListCall) Pages(ctx context.Context, f func(*ListBackupVaultsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackupVaultsPatchCall struct {
	s           *Service
	name        string
	backupvault *BackupVault
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates the settings of a specific backup vault.
//
//   - name: Identifier. The resource name of the backup vault. Format:
//     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
//     .
func (r *ProjectsLocationsBackupVaultsService) Patch(name string, backupvault *BackupVault) *ProjectsLocationsBackupVaultsPatchCall {
	c := &ProjectsLocationsBackupVaultsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.backupvault = backupvault
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the Backup resource to be
// updated. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsBackupVaultsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBackupVaultsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsPatchCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backupvault)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupVaultsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupVaultsBackupsCreateCall struct {
	s          *Service
	parent     string
	backup     *Backup
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a backup from the volume specified in the request The backup
// can be created from the given snapshot if specified in the request. If no
// snapshot specified, there'll be a new snapshot taken to initiate the backup
// creation.
//
//   - parent: The NetApp backupVault to create the backups of, in the format
//     `projects/*/locations/*/backupVaults/{backup_vault_id}`.
func (r *ProjectsLocationsBackupVaultsBackupsService) Create(parent string, backup *Backup) *ProjectsLocationsBackupVaultsBackupsCreateCall {
	c := &ProjectsLocationsBackupVaultsBackupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.backup = backup
	return c
}

// BackupId sets the optional parameter "backupId": Required. The ID to use for
// the backup. The ID must be unique within the specified backupVault. Must
// contain only letters, numbers and hyphen, with the first character a letter,
// the last a letter or a number, and a 63 character maximum.
func (c *ProjectsLocationsBackupVaultsBackupsCreateCall) BackupId(backupId string) *ProjectsLocationsBackupVaultsBackupsCreateCall {
	c.urlParams_.Set("backupId", backupId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsBackupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsBackupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsBackupsCreateCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsBackupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsBackupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsBackupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.backups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupVaultsBackupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupVaultsBackupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Warning! This operation will permanently delete the backup.
//
//   - name: The backup resource name, in the format
//     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/
//     backups/{backup_id}`.
func (r *ProjectsLocationsBackupVaultsBackupsService) Delete(name string) *ProjectsLocationsBackupVaultsBackupsDeleteCall {
	c := &ProjectsLocationsBackupVaultsBackupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsBackupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsBackupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsBackupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsBackupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsBackupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsBackupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.backups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupVaultsBackupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupVaultsBackupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the description of the specified backup
//
//   - name: The backup resource name, in the format
//     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/
//     backups/{backup_id}`.
func (r *ProjectsLocationsBackupVaultsBackupsService) Get(name string) *ProjectsLocationsBackupVaultsBackupsGetCall {
	c := &ProjectsLocationsBackupVaultsBackupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsBackupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsBackupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupVaultsBackupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupVaultsBackupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsBackupsGetCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsBackupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsBackupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsBackupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.backups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Backup.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupVaultsBackupsGetCall) Do(opts ...googleapi.CallOption) (*Backup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Backup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBackupVaultsBackupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns descriptions of all backups for a backupVault.
//
//   - parent: The backupVault for which to retrieve backup information, in the
//     format
//     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
//     . To retrieve backup information for all locations, use "-" for the
//     `{location}` value. To retrieve backup information for all backupVaults,
//     use "-" for the `{backup_vault_id}` value. To retrieve backup information
//     for a volume, use "-" for the `{backup_vault_id}` value and specify volume
//     full name with the filter.
func (r *ProjectsLocationsBackupVaultsBackupsService) List(parent string) *ProjectsLocationsBackupVaultsBackupsListCall {
	c := &ProjectsLocationsBackupVaultsBackupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The standard list filter. If
// specified, backups will be returned based on the attribute name that matches
// the filter expression. If empty, then no backups are filtered out. See
// https://google.aip.dev/160
func (c *ProjectsLocationsBackupVaultsBackupsListCall) Filter(filter string) *ProjectsLocationsBackupVaultsBackupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort results. Supported
// values are "name", "name desc" or "" (unsorted).
func (c *ProjectsLocationsBackupVaultsBackupsListCall) OrderBy(orderBy string) *ProjectsLocationsBackupVaultsBackupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. The service may return fewer than this value. The maximum value
// is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsBackupVaultsBackupsListCall) PageSize(pageSize int64) *ProjectsLocationsBackupVaultsBackupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// to use if there are additional results to retrieve for this list request.
func (c *ProjectsLocationsBackupVaultsBackupsListCall) PageToken(pageToken string) *ProjectsLocationsBackupVaultsBackupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsBackupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsBackupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupVaultsBackupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupVaultsBackupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsBackupsListCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsBackupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsBackupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsBackupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.backups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBackupsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBackupVaultsBackupsListCall) Do(opts ...googleapi.CallOption) (*ListBackupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBackupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackupVaultsBackupsListCall) Pages(ctx context.Context, f func(*ListBackupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackupVaultsBackupsPatchCall struct {
	s          *Service
	name       string
	backup     *Backup
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update backup with full spec.
//
//   - name: Identifier. The resource name of the backup. Format:
//     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/
//     backups/{backup_id}`.
func (r *ProjectsLocationsBackupVaultsBackupsService) Patch(name string, backup *Backup) *ProjectsLocationsBackupVaultsBackupsPatchCall {
	c := &ProjectsLocationsBackupVaultsBackupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.backup = backup
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the Backup resource to be
// updated. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsBackupVaultsBackupsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBackupVaultsBackupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupVaultsBackupsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupVaultsBackupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupVaultsBackupsPatchCall) Context(ctx context.Context) *ProjectsLocationsBackupVaultsBackupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupVaultsBackupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupVaultsBackupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.backupVaults.backups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupVaultsBackupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.backupVaults.backups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsKmsConfigsCreateCall struct {
	s          *Service
	parent     string
	kmsconfig  *KmsConfig
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new KMS config.
//
// - parent: Value for parent.
func (r *ProjectsLocationsKmsConfigsService) Create(parent string, kmsconfig *KmsConfig) *ProjectsLocationsKmsConfigsCreateCall {
	c := &ProjectsLocationsKmsConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.kmsconfig = kmsconfig
	return c
}

// KmsConfigId sets the optional parameter "kmsConfigId": Required. Id of the
// requesting KmsConfig. Must be unique within the parent resource. Must
// contain only letters, numbers and hyphen, with the first character a letter,
// the last a letter or a number, and a 63 character maximum.
func (c *ProjectsLocationsKmsConfigsCreateCall) KmsConfigId(kmsConfigId string) *ProjectsLocationsKmsConfigsCreateCall {
	c.urlParams_.Set("kmsConfigId", kmsConfigId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsKmsConfigsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsKmsConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsKmsConfigsCreateCall) Context(ctx context.Context) *ProjectsLocationsKmsConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsKmsConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsKmsConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.kmsconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/kmsConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.kmsConfigs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsKmsConfigsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsKmsConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Warning! This operation will permanently delete the Kms config.
//
// - name: Name of the KmsConfig.
func (r *ProjectsLocationsKmsConfigsService) Delete(name string) *ProjectsLocationsKmsConfigsDeleteCall {
	c := &ProjectsLocationsKmsConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsKmsConfigsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsKmsConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsKmsConfigsDeleteCall) Context(ctx context.Context) *ProjectsLocationsKmsConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsKmsConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsKmsConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.kmsConfigs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsKmsConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsKmsConfigsEncryptCall struct {
	s                     *Service
	name                  string
	encryptvolumesrequest *EncryptVolumesRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Encrypt: Encrypt the existing volumes without CMEK encryption with the
// desired the KMS config for the whole region.
//
// - name: Name of the KmsConfig.
func (r *ProjectsLocationsKmsConfigsService) Encrypt(name string, encryptvolumesrequest *EncryptVolumesRequest) *ProjectsLocationsKmsConfigsEncryptCall {
	c := &ProjectsLocationsKmsConfigsEncryptCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.encryptvolumesrequest = encryptvolumesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsKmsConfigsEncryptCall) Fields(s ...googleapi.Field) *ProjectsLocationsKmsConfigsEncryptCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsKmsConfigsEncryptCall) Context(ctx context.Context) *ProjectsLocationsKmsConfigsEncryptCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsKmsConfigsEncryptCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsKmsConfigsEncryptCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.encryptvolumesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:encrypt")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.encrypt", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.kmsConfigs.encrypt" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsKmsConfigsEncryptCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.encrypt", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsKmsConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the description of the specified KMS config by kms_config_id.
//
// - name: Name of the KmsConfig.
func (r *ProjectsLocationsKmsConfigsService) Get(name string) *ProjectsLocationsKmsConfigsGetCall {
	c := &ProjectsLocationsKmsConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsKmsConfigsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsKmsConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsKmsConfigsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsKmsConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsKmsConfigsGetCall) Context(ctx context.Context) *ProjectsLocationsKmsConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsKmsConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsKmsConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.kmsConfigs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *KmsConfig.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsKmsConfigsGetCall) Do(opts ...googleapi.CallOption) (*KmsConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &KmsConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsKmsConfigsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns descriptions of all KMS configs owned by the caller.
//
// - parent: Parent value.
func (r *ProjectsLocationsKmsConfigsService) List(parent string) *ProjectsLocationsKmsConfigsListCall {
	c := &ProjectsLocationsKmsConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": List filter.
func (c *ProjectsLocationsKmsConfigsListCall) Filter(filter string) *ProjectsLocationsKmsConfigsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort results. Supported
// values are "name", "name desc" or "" (unsorted).
func (c *ProjectsLocationsKmsConfigsListCall) OrderBy(orderBy string) *ProjectsLocationsKmsConfigsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return.
func (c *ProjectsLocationsKmsConfigsListCall) PageSize(pageSize int64) *ProjectsLocationsKmsConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// to use if there are additional results to retrieve for this list request.
func (c *ProjectsLocationsKmsConfigsListCall) PageToken(pageToken string) *ProjectsLocationsKmsConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsKmsConfigsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsKmsConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsKmsConfigsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsKmsConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsKmsConfigsListCall) Context(ctx context.Context) *ProjectsLocationsKmsConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsKmsConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsKmsConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/kmsConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.kmsConfigs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListKmsConfigsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsKmsConfigsListCall) Do(opts ...googleapi.CallOption) (*ListKmsConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListKmsConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsKmsConfigsListCall) Pages(ctx context.Context, f func(*ListKmsConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsKmsConfigsPatchCall struct {
	s          *Service
	name       string
	kmsconfig  *KmsConfig
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the Kms config properties with the full spec
//
// - name: Identifier. Name of the KmsConfig.
func (r *ProjectsLocationsKmsConfigsService) Patch(name string, kmsconfig *KmsConfig) *ProjectsLocationsKmsConfigsPatchCall {
	c := &ProjectsLocationsKmsConfigsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.kmsconfig = kmsconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the KmsConfig resource by
// the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsKmsConfigsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsKmsConfigsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsKmsConfigsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsKmsConfigsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsKmsConfigsPatchCall) Context(ctx context.Context) *ProjectsLocationsKmsConfigsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsKmsConfigsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsKmsConfigsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.kmsconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.kmsConfigs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsKmsConfigsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsKmsConfigsVerifyCall struct {
	s                      *Service
	name                   string
	verifykmsconfigrequest *VerifyKmsConfigRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Verify: Verifies KMS config reachability.
//
// - name: Name of the KMS Config to be verified.
func (r *ProjectsLocationsKmsConfigsService) Verify(name string, verifykmsconfigrequest *VerifyKmsConfigRequest) *ProjectsLocationsKmsConfigsVerifyCall {
	c := &ProjectsLocationsKmsConfigsVerifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.verifykmsconfigrequest = verifykmsconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsKmsConfigsVerifyCall) Fields(s ...googleapi.Field) *ProjectsLocationsKmsConfigsVerifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsKmsConfigsVerifyCall) Context(ctx context.Context) *ProjectsLocationsKmsConfigsVerifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsKmsConfigsVerifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsKmsConfigsVerifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.verifykmsconfigrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:verify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.verify", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.kmsConfigs.verify" call.
// Any non-2xx status code is an error. Response headers are in either
// *VerifyKmsConfigResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsKmsConfigsVerifyCall) Do(opts ...googleapi.CallOption) (*VerifyKmsConfigResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VerifyKmsConfigResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.kmsConfigs.verify", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsStoragePoolsCreateCall struct {
	s           *Service
	parent      string
	storagepool *StoragePool
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a new storage pool.
//
// - parent: Value for parent.
func (r *ProjectsLocationsStoragePoolsService) Create(parent string, storagepool *StoragePool) *ProjectsLocationsStoragePoolsCreateCall {
	c := &ProjectsLocationsStoragePoolsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.storagepool = storagepool
	return c
}

// StoragePoolId sets the optional parameter "storagePoolId": Required. Id of
// the requesting storage pool. Must be unique within the parent resource. Must
// contain only letters, numbers and hyphen, with the first character a letter,
// the last a letter or a number, and a 63 character maximum.
func (c *ProjectsLocationsStoragePoolsCreateCall) StoragePoolId(storagePoolId string) *ProjectsLocationsStoragePoolsCreateCall {
	c.urlParams_.Set("storagePoolId", storagePoolId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsStoragePoolsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsStoragePoolsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsStoragePoolsCreateCall) Context(ctx context.Context) *ProjectsLocationsStoragePoolsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsStoragePoolsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsStoragePoolsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.storagepool)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/storagePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.storagePools.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsStoragePoolsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsStoragePoolsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Warning! This operation will permanently delete the storage pool.
//
// - name: Name of the storage pool.
func (r *ProjectsLocationsStoragePoolsService) Delete(name string) *ProjectsLocationsStoragePoolsDeleteCall {
	c := &ProjectsLocationsStoragePoolsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsStoragePoolsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsStoragePoolsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsStoragePoolsDeleteCall) Context(ctx context.Context) *ProjectsLocationsStoragePoolsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsStoragePoolsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsStoragePoolsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.storagePools.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsStoragePoolsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsStoragePoolsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the description of the specified storage pool by poolId.
//
// - name: Name of the storage pool.
func (r *ProjectsLocationsStoragePoolsService) Get(name string) *ProjectsLocationsStoragePoolsGetCall {
	c := &ProjectsLocationsStoragePoolsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsStoragePoolsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsStoragePoolsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsStoragePoolsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsStoragePoolsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsStoragePoolsGetCall) Context(ctx context.Context) *ProjectsLocationsStoragePoolsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsStoragePoolsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsStoragePoolsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.storagePools.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *StoragePool.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsStoragePoolsGetCall) Do(opts ...googleapi.CallOption) (*StoragePool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StoragePool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsStoragePoolsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns descriptions of all storage pools owned by the caller.
//
// - parent: Parent value.
func (r *ProjectsLocationsStoragePoolsService) List(parent string) *ProjectsLocationsStoragePoolsListCall {
	c := &ProjectsLocationsStoragePoolsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": List filter.
func (c *ProjectsLocationsStoragePoolsListCall) Filter(filter string) *ProjectsLocationsStoragePoolsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort results. Supported
// values are "name", "name desc" or "" (unsorted).
func (c *ProjectsLocationsStoragePoolsListCall) OrderBy(orderBy string) *ProjectsLocationsStoragePoolsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return.
func (c *ProjectsLocationsStoragePoolsListCall) PageSize(pageSize int64) *ProjectsLocationsStoragePoolsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// to use if there are additional results to retrieve for this list request.
func (c *ProjectsLocationsStoragePoolsListCall) PageToken(pageToken string) *ProjectsLocationsStoragePoolsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsStoragePoolsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsStoragePoolsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsStoragePoolsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsStoragePoolsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsStoragePoolsListCall) Context(ctx context.Context) *ProjectsLocationsStoragePoolsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsStoragePoolsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsStoragePoolsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/storagePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.storagePools.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListStoragePoolsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsStoragePoolsListCall) Do(opts ...googleapi.CallOption) (*ListStoragePoolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListStoragePoolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsStoragePoolsListCall) Pages(ctx context.Context, f func(*ListStoragePoolsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsStoragePoolsPatchCall struct {
	s           *Service
	name        string
	storagepool *StoragePool
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates the storage pool properties with the full spec
//
// - name: Identifier. Name of the storage pool.
func (r *ProjectsLocationsStoragePoolsService) Patch(name string, storagepool *StoragePool) *ProjectsLocationsStoragePoolsPatchCall {
	c := &ProjectsLocationsStoragePoolsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.storagepool = storagepool
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the StoragePool resource by
// the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsStoragePoolsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsStoragePoolsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsStoragePoolsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsStoragePoolsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsStoragePoolsPatchCall) Context(ctx context.Context) *ProjectsLocationsStoragePoolsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsStoragePoolsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsStoragePoolsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.storagepool)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.storagePools.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsStoragePoolsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsStoragePoolsSwitchCall struct {
	s                              *Service
	name                           string
	switchactivereplicazonerequest *SwitchActiveReplicaZoneRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Switch: This operation will switch the active/replica zone for a regional
// storagePool.
//
// - name: Name of the storage pool.
func (r *ProjectsLocationsStoragePoolsService) Switch(name string, switchactivereplicazonerequest *SwitchActiveReplicaZoneRequest) *ProjectsLocationsStoragePoolsSwitchCall {
	c := &ProjectsLocationsStoragePoolsSwitchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.switchactivereplicazonerequest = switchactivereplicazonerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsStoragePoolsSwitchCall) Fields(s ...googleapi.Field) *ProjectsLocationsStoragePoolsSwitchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsStoragePoolsSwitchCall) Context(ctx context.Context) *ProjectsLocationsStoragePoolsSwitchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsStoragePoolsSwitchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsStoragePoolsSwitchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.switchactivereplicazonerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:switch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.switch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.storagePools.switch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsStoragePoolsSwitchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.switch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsStoragePoolsValidateDirectoryServiceCall struct {
	s                               *Service
	name                            string
	validatedirectoryservicerequest *ValidateDirectoryServiceRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// ValidateDirectoryService: ValidateDirectoryService does a connectivity check
// for a directory service policy attached to the storage pool.
//
// - name: Name of the storage pool.
func (r *ProjectsLocationsStoragePoolsService) ValidateDirectoryService(name string, validatedirectoryservicerequest *ValidateDirectoryServiceRequest) *ProjectsLocationsStoragePoolsValidateDirectoryServiceCall {
	c := &ProjectsLocationsStoragePoolsValidateDirectoryServiceCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.validatedirectoryservicerequest = validatedirectoryservicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsStoragePoolsValidateDirectoryServiceCall) Fields(s ...googleapi.Field) *ProjectsLocationsStoragePoolsValidateDirectoryServiceCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsStoragePoolsValidateDirectoryServiceCall) Context(ctx context.Context) *ProjectsLocationsStoragePoolsValidateDirectoryServiceCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsStoragePoolsValidateDirectoryServiceCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsStoragePoolsValidateDirectoryServiceCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.validatedirectoryservicerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:validateDirectoryService")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.validateDirectoryService", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.storagePools.validateDirectoryService" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsStoragePoolsValidateDirectoryServiceCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.storagePools.validateDirectoryService", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesCreateCall struct {
	s          *Service
	parent     string
	volume     *Volume
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Volume in a given project and location.
//
// - parent: Value for parent.
func (r *ProjectsLocationsVolumesService) Create(parent string, volume *Volume) *ProjectsLocationsVolumesCreateCall {
	c := &ProjectsLocationsVolumesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.volume = volume
	return c
}

// VolumeId sets the optional parameter "volumeId": Required. Id of the
// requesting volume. Must be unique within the parent resource. Must contain
// only letters, numbers and hyphen, with the first character a letter, the
// last a letter or a number, and a 63 character maximum.
func (c *ProjectsLocationsVolumesCreateCall) VolumeId(volumeId string) *ProjectsLocationsVolumesCreateCall {
	c.urlParams_.Set("volumeId", volumeId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesCreateCall) Context(ctx context.Context) *ProjectsLocationsVolumesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.volume)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/volumes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Volume.
//
// - name: Name of the volume.
func (r *ProjectsLocationsVolumesService) Delete(name string) *ProjectsLocationsVolumesDeleteCall {
	c := &ProjectsLocationsVolumesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If this field is set as true,
// CCFE will not block the volume resource deletion even if it has any
// snapshots resource. (Otherwise, the request will only work if the volume has
// no snapshots.)
func (c *ProjectsLocationsVolumesDeleteCall) Force(force bool) *ProjectsLocationsVolumesDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesDeleteCall) Context(ctx context.Context) *ProjectsLocationsVolumesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Volume.
//
// - name: Name of the volume.
func (r *ProjectsLocationsVolumesService) Get(name string) *ProjectsLocationsVolumesGetCall {
	c := &ProjectsLocationsVolumesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVolumesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVolumesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesGetCall) Context(ctx context.Context) *ProjectsLocationsVolumesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Volume.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesGetCall) Do(opts ...googleapi.CallOption) (*Volume, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Volume{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Volumes in a given project.
//
// - parent: Parent value for ListVolumesRequest.
func (r *ProjectsLocationsVolumesService) List(parent string) *ProjectsLocationsVolumesListCall {
	c := &ProjectsLocationsVolumesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results
func (c *ProjectsLocationsVolumesListCall) Filter(filter string) *ProjectsLocationsVolumesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results
func (c *ProjectsLocationsVolumesListCall) OrderBy(orderBy string) *ProjectsLocationsVolumesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, the server will pick
// an appropriate default.
func (c *ProjectsLocationsVolumesListCall) PageSize(pageSize int64) *ProjectsLocationsVolumesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsVolumesListCall) PageToken(pageToken string) *ProjectsLocationsVolumesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVolumesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVolumesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesListCall) Context(ctx context.Context) *ProjectsLocationsVolumesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/volumes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListVolumesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsVolumesListCall) Do(opts ...googleapi.CallOption) (*ListVolumesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVolumesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVolumesListCall) Pages(ctx context.Context, f func(*ListVolumesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsVolumesPatchCall struct {
	s          *Service
	name       string
	volume     *Volume
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single Volume.
//
// - name: Identifier. Name of the volume.
func (r *ProjectsLocationsVolumesService) Patch(name string, volume *Volume) *ProjectsLocationsVolumesPatchCall {
	c := &ProjectsLocationsVolumesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.volume = volume
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the Volume resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsVolumesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsVolumesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesPatchCall) Context(ctx context.Context) *ProjectsLocationsVolumesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.volume)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesRevertCall struct {
	s                   *Service
	name                string
	revertvolumerequest *RevertVolumeRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Revert: Revert an existing volume to a specified snapshot. Warning! This
// operation will permanently revert all changes made after the snapshot was
// created.
//
//   - name: The resource name of the volume, in the format of
//     projects/{project_id}/locations/{location}/volumes/{volume_id}.
func (r *ProjectsLocationsVolumesService) Revert(name string, revertvolumerequest *RevertVolumeRequest) *ProjectsLocationsVolumesRevertCall {
	c := &ProjectsLocationsVolumesRevertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.revertvolumerequest = revertvolumerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesRevertCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesRevertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesRevertCall) Context(ctx context.Context) *ProjectsLocationsVolumesRevertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesRevertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesRevertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.revertvolumerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:revert")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.revert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.revert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesRevertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.revert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesQuotaRulesCreateCall struct {
	s          *Service
	parent     string
	quotarule  *QuotaRule
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new quota rule.
//
// - parent: Parent value for CreateQuotaRuleRequest.
func (r *ProjectsLocationsVolumesQuotaRulesService) Create(parent string, quotarule *QuotaRule) *ProjectsLocationsVolumesQuotaRulesCreateCall {
	c := &ProjectsLocationsVolumesQuotaRulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.quotarule = quotarule
	return c
}

// QuotaRuleId sets the optional parameter "quotaRuleId": Required. ID of the
// quota rule to create. Must be unique within the parent resource. Must
// contain only letters, numbers, underscore and hyphen, with the first
// character a letter or underscore, the last a letter or underscore or a
// number, and a 63 character maximum.
func (c *ProjectsLocationsVolumesQuotaRulesCreateCall) QuotaRuleId(quotaRuleId string) *ProjectsLocationsVolumesQuotaRulesCreateCall {
	c.urlParams_.Set("quotaRuleId", quotaRuleId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesQuotaRulesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesQuotaRulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesQuotaRulesCreateCall) Context(ctx context.Context) *ProjectsLocationsVolumesQuotaRulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesQuotaRulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesQuotaRulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.quotarule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/quotaRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.quotaRules.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesQuotaRulesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesQuotaRulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a quota rule.
//
// - name: Name of the quota rule.
func (r *ProjectsLocationsVolumesQuotaRulesService) Delete(name string) *ProjectsLocationsVolumesQuotaRulesDeleteCall {
	c := &ProjectsLocationsVolumesQuotaRulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesQuotaRulesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesQuotaRulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesQuotaRulesDeleteCall) Context(ctx context.Context) *ProjectsLocationsVolumesQuotaRulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesQuotaRulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesQuotaRulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.quotaRules.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesQuotaRulesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesQuotaRulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns details of the specified quota rule.
//
// - name: Name of the quota rule.
func (r *ProjectsLocationsVolumesQuotaRulesService) Get(name string) *ProjectsLocationsVolumesQuotaRulesGetCall {
	c := &ProjectsLocationsVolumesQuotaRulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesQuotaRulesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesQuotaRulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVolumesQuotaRulesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVolumesQuotaRulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesQuotaRulesGetCall) Context(ctx context.Context) *ProjectsLocationsVolumesQuotaRulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesQuotaRulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesQuotaRulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.quotaRules.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *QuotaRule.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesQuotaRulesGetCall) Do(opts ...googleapi.CallOption) (*QuotaRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QuotaRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesQuotaRulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns list of all quota rules in a location.
//
// - parent: Parent value for ListQuotaRulesRequest.
func (r *ProjectsLocationsVolumesQuotaRulesService) List(parent string) *ProjectsLocationsVolumesQuotaRulesListCall {
	c := &ProjectsLocationsVolumesQuotaRulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results
func (c *ProjectsLocationsVolumesQuotaRulesListCall) Filter(filter string) *ProjectsLocationsVolumesQuotaRulesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results
func (c *ProjectsLocationsVolumesQuotaRulesListCall) OrderBy(orderBy string) *ProjectsLocationsVolumesQuotaRulesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, the server will pick
// an appropriate default.
func (c *ProjectsLocationsVolumesQuotaRulesListCall) PageSize(pageSize int64) *ProjectsLocationsVolumesQuotaRulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsVolumesQuotaRulesListCall) PageToken(pageToken string) *ProjectsLocationsVolumesQuotaRulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesQuotaRulesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesQuotaRulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVolumesQuotaRulesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVolumesQuotaRulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesQuotaRulesListCall) Context(ctx context.Context) *ProjectsLocationsVolumesQuotaRulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesQuotaRulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesQuotaRulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/quotaRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.quotaRules.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListQuotaRulesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsVolumesQuotaRulesListCall) Do(opts ...googleapi.CallOption) (*ListQuotaRulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListQuotaRulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVolumesQuotaRulesListCall) Pages(ctx context.Context, f func(*ListQuotaRulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsVolumesQuotaRulesPatchCall struct {
	s          *Service
	name       string
	quotarule  *QuotaRule
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a quota rule.
//
//   - name: Identifier. The resource name of the quota rule. Format:
//     `projects/{project_number}/locations/{location_id}/volumes/volumes/{volume_
//     id}/quotaRules/{quota_rule_id}`.
func (r *ProjectsLocationsVolumesQuotaRulesService) Patch(name string, quotarule *QuotaRule) *ProjectsLocationsVolumesQuotaRulesPatchCall {
	c := &ProjectsLocationsVolumesQuotaRulesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.quotarule = quotarule
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Quota Rule resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsVolumesQuotaRulesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsVolumesQuotaRulesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesQuotaRulesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesQuotaRulesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesQuotaRulesPatchCall) Context(ctx context.Context) *ProjectsLocationsVolumesQuotaRulesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesQuotaRulesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesQuotaRulesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.quotarule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.quotaRules.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesQuotaRulesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.quotaRules.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesReplicationsCreateCall struct {
	s           *Service
	parent      string
	replication *Replication
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Create a new replication for a volume.
//
//   - parent: The NetApp volume to create the replications of, in the format
//     `projects/{project_id}/locations/{location}/volumes/{volume_id}`.
func (r *ProjectsLocationsVolumesReplicationsService) Create(parent string, replication *Replication) *ProjectsLocationsVolumesReplicationsCreateCall {
	c := &ProjectsLocationsVolumesReplicationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.replication = replication
	return c
}

// ReplicationId sets the optional parameter "replicationId": Required. ID of
// the replication to create. Must be unique within the parent resource. Must
// contain only letters, numbers and hyphen, with the first character a letter,
// the last a letter or a number, and a 63 character maximum.
func (c *ProjectsLocationsVolumesReplicationsCreateCall) ReplicationId(replicationId string) *ProjectsLocationsVolumesReplicationsCreateCall {
	c.urlParams_.Set("replicationId", replicationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsCreateCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.replication)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/replications")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesReplicationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a replication.
//
//   - name: The replication resource name, in the format
//     `projects/*/locations/*/volumes/*/replications/{replication_id}`.
func (r *ProjectsLocationsVolumesReplicationsService) Delete(name string) *ProjectsLocationsVolumesReplicationsDeleteCall {
	c := &ProjectsLocationsVolumesReplicationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesReplicationsEstablishPeeringCall struct {
	s                       *Service
	name                    string
	establishpeeringrequest *EstablishPeeringRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// EstablishPeering: Establish replication peering.
//
//   - name: The resource name of the replication, in the format of
//     projects/{project_id}/locations/{location}/volumes/{volume_id}/replications
//     /{replication_id}.
func (r *ProjectsLocationsVolumesReplicationsService) EstablishPeering(name string, establishpeeringrequest *EstablishPeeringRequest) *ProjectsLocationsVolumesReplicationsEstablishPeeringCall {
	c := &ProjectsLocationsVolumesReplicationsEstablishPeeringCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.establishpeeringrequest = establishpeeringrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsEstablishPeeringCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsEstablishPeeringCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsEstablishPeeringCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsEstablishPeeringCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsEstablishPeeringCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsEstablishPeeringCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.establishpeeringrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:establishPeering")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.establishPeering", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.establishPeering" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsEstablishPeeringCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.establishPeering", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesReplicationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describe a replication for a volume.
//
//   - name: The replication resource name, in the format
//     `projects/{project_id}/locations/{location}/volumes/{volume_id}/replication
//     s/{replication_id}`.
func (r *ProjectsLocationsVolumesReplicationsService) Get(name string) *ProjectsLocationsVolumesReplicationsGetCall {
	c := &ProjectsLocationsVolumesReplicationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVolumesReplicationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVolumesReplicationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsGetCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Replication.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsGetCall) Do(opts ...googleapi.CallOption) (*Replication, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Replication{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesReplicationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns descriptions of all replications for a volume.
//
//   - parent: The volume for which to retrieve replication information, in the
//     format `projects/{project_id}/locations/{location}/volumes/{volume_id}`.
func (r *ProjectsLocationsVolumesReplicationsService) List(parent string) *ProjectsLocationsVolumesReplicationsListCall {
	c := &ProjectsLocationsVolumesReplicationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": List filter.
func (c *ProjectsLocationsVolumesReplicationsListCall) Filter(filter string) *ProjectsLocationsVolumesReplicationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort results. Supported
// values are "name", "name desc" or "" (unsorted).
func (c *ProjectsLocationsVolumesReplicationsListCall) OrderBy(orderBy string) *ProjectsLocationsVolumesReplicationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return.
func (c *ProjectsLocationsVolumesReplicationsListCall) PageSize(pageSize int64) *ProjectsLocationsVolumesReplicationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// to use if there are additional results to retrieve for this list request.
func (c *ProjectsLocationsVolumesReplicationsListCall) PageToken(pageToken string) *ProjectsLocationsVolumesReplicationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVolumesReplicationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVolumesReplicationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsListCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/replications")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListReplicationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsListCall) Do(opts ...googleapi.CallOption) (*ListReplicationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReplicationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVolumesReplicationsListCall) Pages(ctx context.Context, f func(*ListReplicationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsVolumesReplicationsPatchCall struct {
	s           *Service
	name        string
	replication *Replication
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates the settings of a specific replication.
//
//   - name: Identifier. The resource name of the Replication. Format:
//     `projects/{project_id}/locations/{location}/volumes/{volume_id}/replication
//     s/{replication_id}`.
func (r *ProjectsLocationsVolumesReplicationsService) Patch(name string, replication *Replication) *ProjectsLocationsVolumesReplicationsPatchCall {
	c := &ProjectsLocationsVolumesReplicationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.replication = replication
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask of
// fields to update. At least one path must be supplied in this field.
func (c *ProjectsLocationsVolumesReplicationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsVolumesReplicationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsPatchCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.replication)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesReplicationsResumeCall struct {
	s                        *Service
	name                     string
	resumereplicationrequest *ResumeReplicationRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Resume: Resume Cross Region Replication.
//
//   - name: The resource name of the replication, in the format of
//     projects/{project_id}/locations/{location}/volumes/{volume_id}/replications
//     /{replication_id}.
func (r *ProjectsLocationsVolumesReplicationsService) Resume(name string, resumereplicationrequest *ResumeReplicationRequest) *ProjectsLocationsVolumesReplicationsResumeCall {
	c := &ProjectsLocationsVolumesReplicationsResumeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.resumereplicationrequest = resumereplicationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsResumeCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsResumeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsResumeCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsResumeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsResumeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsResumeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.resumereplicationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:resume")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.resume", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.resume" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsResumeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.resume", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesReplicationsReverseDirectionCall struct {
	s                                  *Service
	name                               string
	reversereplicationdirectionrequest *ReverseReplicationDirectionRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// ReverseDirection: Reverses direction of replication. Source becomes
// destination and destination becomes source.
//
//   - name: The resource name of the replication, in the format of
//     projects/{project_id}/locations/{location}/volumes/{volume_id}/replications
//     /{replication_id}.
func (r *ProjectsLocationsVolumesReplicationsService) ReverseDirection(name string, reversereplicationdirectionrequest *ReverseReplicationDirectionRequest) *ProjectsLocationsVolumesReplicationsReverseDirectionCall {
	c := &ProjectsLocationsVolumesReplicationsReverseDirectionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.reversereplicationdirectionrequest = reversereplicationdirectionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsReverseDirectionCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsReverseDirectionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsReverseDirectionCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsReverseDirectionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsReverseDirectionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsReverseDirectionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reversereplicationdirectionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:reverseDirection")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.reverseDirection", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.reverseDirection" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsReverseDirectionCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.reverseDirection", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesReplicationsStopCall struct {
	s                      *Service
	name                   string
	stopreplicationrequest *StopReplicationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Stop: Stop Cross Region Replication.
//
//   - name: The resource name of the replication, in the format of
//     projects/{project_id}/locations/{location}/volumes/{volume_id}/replications
//     /{replication_id}.
func (r *ProjectsLocationsVolumesReplicationsService) Stop(name string, stopreplicationrequest *StopReplicationRequest) *ProjectsLocationsVolumesReplicationsStopCall {
	c := &ProjectsLocationsVolumesReplicationsStopCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.stopreplicationrequest = stopreplicationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsStopCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsStopCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsStopCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsStopCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsStopCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsStopCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.stopreplicationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:stop")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.stop", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.stop" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsStopCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.stop", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesReplicationsSyncCall struct {
	s                      *Service
	name                   string
	syncreplicationrequest *SyncReplicationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Sync: Syncs the replication. This will invoke one time volume data transfer
// from source to destination.
//
//   - name: The resource name of the replication, in the format of
//     projects/{project_id}/locations/{location}/volumes/{volume_id}/replications
//     /{replication_id}.
func (r *ProjectsLocationsVolumesReplicationsService) Sync(name string, syncreplicationrequest *SyncReplicationRequest) *ProjectsLocationsVolumesReplicationsSyncCall {
	c := &ProjectsLocationsVolumesReplicationsSyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.syncreplicationrequest = syncreplicationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesReplicationsSyncCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesReplicationsSyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesReplicationsSyncCall) Context(ctx context.Context) *ProjectsLocationsVolumesReplicationsSyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesReplicationsSyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesReplicationsSyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.syncreplicationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:sync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.sync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.replications.sync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesReplicationsSyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.replications.sync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesSnapshotsCreateCall struct {
	s          *Service
	parent     string
	snapshot   *Snapshot
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a new snapshot for a volume.
//
//   - parent: The NetApp volume to create the snapshots of, in the format
//     `projects/{project_id}/locations/{location}/volumes/{volume_id}`.
func (r *ProjectsLocationsVolumesSnapshotsService) Create(parent string, snapshot *Snapshot) *ProjectsLocationsVolumesSnapshotsCreateCall {
	c := &ProjectsLocationsVolumesSnapshotsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.snapshot = snapshot
	return c
}

// SnapshotId sets the optional parameter "snapshotId": Required. ID of the
// snapshot to create. Must be unique within the parent resource. Must contain
// only letters, numbers and hyphen, with the first character a letter, the
// last a letter or a number, and a 63 character maximum.
func (c *ProjectsLocationsVolumesSnapshotsCreateCall) SnapshotId(snapshotId string) *ProjectsLocationsVolumesSnapshotsCreateCall {
	c.urlParams_.Set("snapshotId", snapshotId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesSnapshotsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesSnapshotsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesSnapshotsCreateCall) Context(ctx context.Context) *ProjectsLocationsVolumesSnapshotsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesSnapshotsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesSnapshotsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.snapshot)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/snapshots")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.snapshots.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesSnapshotsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesSnapshotsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a snapshot.
//
//   - name: The snapshot resource name, in the format
//     `projects/*/locations/*/volumes/*/snapshots/{snapshot_id}`.
func (r *ProjectsLocationsVolumesSnapshotsService) Delete(name string) *ProjectsLocationsVolumesSnapshotsDeleteCall {
	c := &ProjectsLocationsVolumesSnapshotsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesSnapshotsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesSnapshotsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesSnapshotsDeleteCall) Context(ctx context.Context) *ProjectsLocationsVolumesSnapshotsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesSnapshotsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesSnapshotsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.snapshots.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesSnapshotsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesSnapshotsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describe a snapshot for a volume.
//
//   - name: The snapshot resource name, in the format
//     `projects/{project_id}/locations/{location}/volumes/{volume_id}/snapshots/{
//     snapshot_id}`.
func (r *ProjectsLocationsVolumesSnapshotsService) Get(name string) *ProjectsLocationsVolumesSnapshotsGetCall {
	c := &ProjectsLocationsVolumesSnapshotsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesSnapshotsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesSnapshotsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVolumesSnapshotsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVolumesSnapshotsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesSnapshotsGetCall) Context(ctx context.Context) *ProjectsLocationsVolumesSnapshotsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesSnapshotsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesSnapshotsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.snapshots.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Snapshot.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesSnapshotsGetCall) Do(opts ...googleapi.CallOption) (*Snapshot, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Snapshot{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVolumesSnapshotsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns descriptions of all snapshots for a volume.
//
//   - parent: The volume for which to retrieve snapshot information, in the
//     format `projects/{project_id}/locations/{location}/volumes/{volume_id}`.
func (r *ProjectsLocationsVolumesSnapshotsService) List(parent string) *ProjectsLocationsVolumesSnapshotsListCall {
	c := &ProjectsLocationsVolumesSnapshotsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": List filter.
func (c *ProjectsLocationsVolumesSnapshotsListCall) Filter(filter string) *ProjectsLocationsVolumesSnapshotsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort results. Supported
// values are "name", "name desc" or "" (unsorted).
func (c *ProjectsLocationsVolumesSnapshotsListCall) OrderBy(orderBy string) *ProjectsLocationsVolumesSnapshotsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return.
func (c *ProjectsLocationsVolumesSnapshotsListCall) PageSize(pageSize int64) *ProjectsLocationsVolumesSnapshotsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// to use if there are additional results to retrieve for this list request.
func (c *ProjectsLocationsVolumesSnapshotsListCall) PageToken(pageToken string) *ProjectsLocationsVolumesSnapshotsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesSnapshotsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesSnapshotsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVolumesSnapshotsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVolumesSnapshotsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesSnapshotsListCall) Context(ctx context.Context) *ProjectsLocationsVolumesSnapshotsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesSnapshotsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesSnapshotsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/snapshots")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.snapshots.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSnapshotsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsVolumesSnapshotsListCall) Do(opts ...googleapi.CallOption) (*ListSnapshotsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSnapshotsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVolumesSnapshotsListCall) Pages(ctx context.Context, f func(*ListSnapshotsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsVolumesSnapshotsPatchCall struct {
	s          *Service
	name       string
	snapshot   *Snapshot
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the settings of a specific snapshot.
//
//   - name: Identifier. The resource name of the snapshot. Format:
//     `projects/{project_id}/locations/{location}/volumes/{volume_id}/snapshots/{
//     snapshot_id}`.
func (r *ProjectsLocationsVolumesSnapshotsService) Patch(name string, snapshot *Snapshot) *ProjectsLocationsVolumesSnapshotsPatchCall {
	c := &ProjectsLocationsVolumesSnapshotsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.snapshot = snapshot
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask of
// fields to update. At least one path must be supplied in this field.
func (c *ProjectsLocationsVolumesSnapshotsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsVolumesSnapshotsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVolumesSnapshotsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsVolumesSnapshotsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVolumesSnapshotsPatchCall) Context(ctx context.Context) *ProjectsLocationsVolumesSnapshotsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVolumesSnapshotsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVolumesSnapshotsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.snapshot)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "netapp.projects.locations.volumes.snapshots.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVolumesSnapshotsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "netapp.projects.locations.volumes.snapshots.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
