#pragma once

#include <config/config.hpp>

namespace utils {
template <typename T>
inline std::vector<std::vector<T>> chunk(const std::vector<T> &vector,
                                         const std::size_t size) {
  std::vector<std::vector<T>> output;
  std::vector<T> current_chunk;
  for (const auto &el : vector) {
    current_chunk.push_back(el);
    if (current_chunk.size() >= size) {
      output.push_back(current_chunk);
      current_chunk = {};
    }
  }
  if (current_chunk.size() != 0)
    output.push_back(current_chunk);

  return output;
}

} // namespace utils
