/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public final class ConfigureProxy
extends Task {
    private URL connectTo;
    private String hostProperty = "http.proxyHost";
    private String portProperty = "http.proxyPort";

    public void setConnectTo(String uri) throws MalformedURLException {
        this.connectTo = new URL(uri);
    }

    public void setHostProperty(String host) {
        this.hostProperty = host;
    }

    public void setPortProperty(String port) {
        this.portProperty = port;
    }

    public void execute() throws BuildException {
        try {
            URI[] connectedVia = new URI[]{null};
            URLConnection connect = ConfigureProxy.openConnection(this, this.connectTo, connectedVia);
            if (connect == null) {
                throw new BuildException("Cannot connect to " + this.connectTo);
            }
            if (connectedVia[0] != null) {
                String host = connectedVia[0].getHost();
                this.log(String.format("Setting %s to %s", this.hostProperty, host), 2);
                this.getProject().setUserProperty(this.hostProperty, host);
                int port = connectedVia[0].getPort();
                this.log(String.format("Setting %s to %d", this.portProperty, port), 2);
                this.getProject().setUserProperty(this.portProperty, "" + port);
            } else {
                this.log(String.format("Resetting %s to empty string", this.hostProperty), 2);
                this.getProject().setUserProperty(this.hostProperty, "");
                this.getProject().setUserProperty(this.portProperty, "80");
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    static URLConnection openConnection(Task task, URL url, URI[] connectedVia) throws IOException {
        long connectTimeoutMs = ConfigureProxy.getProjectPropertyInt(task, "downloadBinaries.connectTimeoutMs", 15000);
        task.log("Connect timeout set to " + connectTimeoutMs + " milliseconds prior to connecting to " + url, 4);
        URLConnection[] conn = new URLConnection[]{null};
        CopyOnWriteArrayList errs = new CopyOnWriteArrayList();
        StringBuffer msgs = new StringBuffer();
        CountDownLatch connected = new CountDownLatch(1);
        ExecutorService connectors = Executors.newFixedThreadPool(3);
        connectors.submit(() -> ConfigureProxy.checkProxyProperty("http_proxy", url, conn, connectedVia, connected, errs, msgs));
        connectors.submit(() -> ConfigureProxy.checkProxyProperty("https_proxy", url, conn, connectedVia, connected, errs, msgs));
        connectors.submit(() -> {
            try {
                URLConnection test = url.openConnection(Proxy.NO_PROXY);
                test.connect();
                conn[0] = test;
                msgs.append("\nNo proxy connected");
                connected.countDown();
            }
            catch (IOException ex) {
                errs.add(ex);
            }
        });
        try {
            if (!connected.await(connectTimeoutMs, TimeUnit.MILLISECONDS)) {
                throw new IOException("Could not connect to " + url + " within " + connectTimeoutMs + " milliseconds");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (conn[0] == null) {
            for (Exception ex : errs) {
                task.log((Throwable)ex, 0);
            }
            if (msgs.length() > 0) {
                task.log(msgs.toString(), 0);
            }
            throw new IOException("Cannot connect to " + url);
        }
        task.log(msgs.toString(), 4);
        return conn[0];
    }

    private static void checkProxyProperty(String propertyName, URL url, URLConnection[] conn, URI[] connectedVia, CountDownLatch connected, List<Exception> errs, StringBuffer msgs) {
        String httpProxy = System.getenv(propertyName);
        msgs.append("\n[" + propertyName + "] set to " + httpProxy);
        if (httpProxy != null) {
            try {
                URI uri = new URI(httpProxy);
                InetSocketAddress address = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                URLConnection test = url.openConnection(proxy);
                test.connect();
                msgs.append("\n[" + propertyName + "] connected");
                conn[0] = test;
                if (connectedVia != null) {
                    connectedVia[0] = uri;
                }
                connected.countDown();
                msgs.append("\n[" + propertyName + "] countDown");
            }
            catch (IOException | URISyntaxException ex) {
                errs.add(ex);
                msgs.append("\n[" + propertyName + "] exception " + ex.getMessage());
            }
        }
    }

    private static long getProjectPropertyInt(Task task, String propertyName, int defaultValue) {
        if (task == null) {
            return defaultValue;
        }
        Project project = task.getProject();
        if (project != null) {
            String p = project.getProperty(propertyName);
            if (p == null) {
                return defaultValue;
            }
            try {
                return Long.parseLong(p);
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

