\page Exampleneuron Example neuron

\authors M. Batmunkh *(a,b), L. Bayarchimeg (a) \n
(a) Laboratory of Radiation Biology, Joint Institute for Nuclear Research (JINR), 
6 Joliot-Curie St., 141980 Dubna, Moscow Region, Russia  \n
(b) Division of Natural Sciences, National University of Mongolia (NUM), 
1 University St., 210646 Ulaanbaatar, Mongolia \n
* Corresponding author, email to batmunkh@jinr.ru \n

Any report or published results obtained using the Geant4-DNA software shall
cite the following Geant4-DNA collaboration publications:\n
Phys. Med. 31 (2015) 861-874                             \n
Med. Phys. 37 (2010) 4692-4708                           \n\n

We also suggest these other references related to this example:\n
Phys. Part. Nucl. 56 (2025) 1030-1058                          \n
Phys. Part. Nucl. Lett. 16 (2019) 54–62                        \n
Physica Medica. 57 (2019) 88-94                                \n
EPJ Web Conf. 173 (2018) 05005                                 \n
Physica Medica. 32 (2016) 1510-1520                            \n
Radiat Res Appl Sci. V (2015) 498-507                          \n\n

## INTRODUCTION
                                                                       
The NEURON example allows for the modelling of neuron cell irradiation, including physical,
physico-chemical and chemical processes (eg. production of oxidative radical species in the
vicinity of neurons). It uses realistic geometrical models of neurons generated from a
standardized SWC file representing neuron morphology.

A typical neuron cell is composed of a cell body (soma), a single axon, a dendritic tree,
and thousands of dendritic spines. In the example, individual compartments of a neuron cell
are simulated by spherical and cylindrical voxels. 
The soma is represented by combination of several spheres, while the dendritic tree is described with combinations of cylinders. 
Each voxel is represented as interconnection of two tracing points of the neuron model.

A standardized neuromorphometric format (SWC) is an output file representing individual neuron 
morphology generated by digitally tracing tools based on 3D confocal microscopy images. 
In the SWC file, different numerical markers (e.g. from 1 to 6) describe different types of tracing points:	
- 1 - soma
- 2 - axon
- 3 - apical dendrite
- 4 - basal dendrite
- 5+ - custom (5 – spines, 6 – terminals, etc.). 
Details are available in the NeuronLoadDataFile class.

In order to simulate a neural network, user can create his own file containing
a combination of several individual neurons (see NeuralNETWORK.dat sample file
describing a network of 10 pyramidal neurons).

Geant4-DNA models are activated in the neuron model, which is declared as a G4Region.
Geant4 condensed EM models are used outside the neuron structure.
	
The example package contains:
- source files (src, include, neuron.cc)
- README
- .in, plotDend.C and visualization macro files
- GranuleCell-Nr2.CNG.swc (Sample file describing a single granule neuron is loaded by default)
- NeuralNETWORK.dat (Sample file describing a network of 10 pyramidal neurons)

To run the example: see section HOW TO RUN THE EXAMPLE of this README. \n
To simulation output: see section SIMULATION OUTPUT AND RESULT ANALYSIS of this README.

The code can be compiled with cmake.
It works in MT mode.

## GEOMETRY SET-UP
 
The geometry is cube (World) made of galactic material. 
Before computation, user loads a standardized SWC file of a neuron and generates 
a bounding volume and a homogeneous spherical medium of liquid water. 
Dimensions of the target volume are automatically extrapolated using SWC file describing
3D coordinates of a neuron. The homogeneous medium contains volumes of neuronal cell and a bounding slice. 
The side cube (World) is again represented as overall dimensions of neuronal cell 
that is equal to the diameter of the homogeneous medium.

The construction of whole geometry of neuron morphology is set in the 
DetectorConstruction class.

User can choose between single-neuron simulation and modelling a neural network. Single-neuron
simulation is set by default. To switch simulation to neural network, the following command should be used:
> ./neuron -network FileName.dat

## EVENT: THE PRIMARY GENERATOR
                                                                        
The primary kinematic consists of a single particle starting at the random positions 
on the sphere surface. Then, the particle beam is directed towards the bounding slice volume,
and traverses the individual neurons (default option). The type of the particle and its energy are set in the 
PrimaryGeneratorAction class, and can be changed via the G4 build-in commands of G4ParticleGun class.   
We included the following options for particle directions:

a) Particles are directed to "square" on the XY plane of bounding slice (or YZ, XZ)
> ./neuron -mac myMacro.mac -sXY 

b) Particles are directed to "disk" on the XY plane of bounding slice (or YZ, XZ)
> ./neuron -mac myMacro.mac -dXY

c) Particles are directed towards the bounding slice (default option)
> ./neuron -mac myMacro.mac

## PHYSICS

The following options of physical and chemical processes are included:
Default Livermore physics
> ./neuron -mac myMacro.mac 

a) Livermore + DNAphysics when use DNARegion in myMacro.mac file
> ./neuron -mac myMacro.mac

b) Livermore + DNAPhysics + DNAChemistry 
> ./neuron -mac myMacro.mac -dnachemON

c) Combination of DNA- and Livermore- physics with hadronic physics.
> ./neuron -mac myMacro.mac -dnahad

NOTE, that it requires more memory or computing resources when chemistry is ON (b) and
also long computational time when dnaphysics activated. Conversely, it can works faster when default.

Look at the src/PhyscisList.cc files.

## HOW TO RUN THE EXAMPLE
                                       
To get help, run:

> ./neuron -h

In visualization and interactive mode, run:
> ./neuron -gui
( OGL used by default)

or you may use your own visualization driver, for instance:
> ./neuron -vis "DAWNFILE"

"GranuleCell-Nr2.CNG.swc" is the default file and it should be placed into same directory as the executable.
You can download it here:
http://neuromorpho.org/neuron_info.jsp?neuron_name=GranuleCell-Nr2
You can change neuron`s file name using the following command:

> ./neuron -gui -swc newFileName.swc

In batch mode , run:

> ./neuron(.exe) [-mac neuron.in] [-mt numberofThreads]
> ./neuron -mac ../neuron.in -mt 3 > neuron.out

To get visualization, make sure to uncomment the #/control/execute vis.mac line in the macro.
User can start a visualization of the chemical track evolution in time and space
using SetEndTime (default-10 ps) and SetVerbose setting in src/ActionInitialization.cc file.

## SIMULATION OUTPUT AND RESULT ANALYSIS

The simulation outputs appears in terminal display.
- the energy deposit in the bounding slice and each structure of neuron (in kiloelectronVolt)
- the scored energy deposit within hitting compartment of neuron structure (in kiloelectronVolt)
- the number of particles inside and outside neuron 
- the number of radiolytic species inside neuron when chemistry is activated

The main output results are stored in OutputPerEvent.out file, containing for each event. 
Dend3DEdep.out, Axon3DEdep.out and Soma3DEdep.out files for given dose:
- the position (x, y, z in micrometre) of compartments traversed by particle track.
- the Axon and Dendrite (basal and apical) distance of compartments from Soma (in micrometre).
- the energy deposition in compartments (in kiloelectronVolt).
- the dose deposition in compartments (in Gray).

This file can be easily analysed using for example the provided ROOT macro 
file plotDend.C; to do so:
- be sure to have ROOT installed on your machine
- be sure to be in the neuron directory
- launch ROOT by typing root
- under your ROOT session, type in : .X plotDend.C to execute the macro file
- alternatively you can type directly under your session : root plotDend.C

---------------------------------------------------------------------------

If you have any questions or wish to notify of updates and/or modification please contact: 
batmunkh@jinr.ru \n
