// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>The requested bucket name is not available. The bucket namespace is shared by all users of the system. Select a different name and try again.</p>
    BucketAlreadyExists(crate::types::error::BucketAlreadyExists),
    /// <p>The bucket you tried to create already exists, and you own it. Amazon S3 returns this error in all Amazon Web Services Regions except in the North Virginia Region. For legacy compatibility, if you re-create an existing bucket that you already own in the North Virginia Region, Amazon S3 returns 200 OK and resets the bucket access control lists (ACLs).</p>
    BucketAlreadyOwnedByYou(crate::types::error::BucketAlreadyOwnedByYou),
    /// <p>The existing object was created with a different encryption type. Subsequent write requests must include the appropriate encryption parameters in the request or while creating the session.</p>
    EncryptionTypeMismatch(crate::types::error::EncryptionTypeMismatch),
    /// <p>Parameters on this idempotent request are inconsistent with parameters used in previous request(s).</p>
    /// <p>For a list of error codes and more information on Amazon S3 errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">Error codes</a>.</p><note>
    /// <p>Idempotency ensures that an API request completes no more than one time. With an idempotent request, if the original request completes successfully, any subsequent retries complete successfully without performing any further actions.</p>
    /// </note>
    IdempotencyParameterMismatch(crate::types::error::IdempotencyParameterMismatch),
    /// <p>Object is archived and inaccessible until restored.</p>
    /// <p>If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a copy using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a> in the <i>Amazon S3 User Guide</i>.</p>
    InvalidObjectState(crate::types::error::InvalidObjectState),
    /// <p>You may receive this error in multiple cases. Depending on the reason for the error, you may receive one of the messages below:</p>
    /// <ul>
    /// <li>
    /// <p>Cannot specify both a write offset value and user-defined object metadata for existing objects.</p></li>
    /// <li>
    /// <p>Checksum Type mismatch occurred, expected checksum Type: sha1, actual checksum Type: crc32c.</p></li>
    /// <li>
    /// <p>Request body cannot be empty when 'write offset' is specified.</p></li>
    /// </ul>
    InvalidRequest(crate::types::error::InvalidRequest),
    /// <p>The write offset value that you specified does not match the current object size.</p>
    InvalidWriteOffset(crate::types::error::InvalidWriteOffset),
    /// <p>The specified bucket does not exist.</p>
    NoSuchBucket(crate::types::error::NoSuchBucket),
    /// <p>The specified key does not exist.</p>
    NoSuchKey(crate::types::error::NoSuchKey),
    /// <p>The specified multipart upload does not exist.</p>
    NoSuchUpload(crate::types::error::NoSuchUpload),
    /// <p>The specified content does not exist.</p>
    NotFound(crate::types::error::NotFound),
    /// <p>This action is not allowed against this storage tier.</p>
    ObjectAlreadyInActiveTierError(crate::types::error::ObjectAlreadyInActiveTierError),
    /// <p>The source object of the COPY action is not in the active tier and is only stored in Amazon S3 Glacier.</p>
    ObjectNotInActiveTierError(crate::types::error::ObjectNotInActiveTierError),
    /// <p>You have attempted to add more parts than the maximum of 10000 that are allowed for this object. You can use the CopyObject operation to copy this object to another and then add more data to the newly copied object.</p>
    TooManyParts(crate::types::error::TooManyParts),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::BucketAlreadyExists(inner) => inner.fmt(f),
            Error::BucketAlreadyOwnedByYou(inner) => inner.fmt(f),
            Error::EncryptionTypeMismatch(inner) => inner.fmt(f),
            Error::IdempotencyParameterMismatch(inner) => inner.fmt(f),
            Error::InvalidObjectState(inner) => inner.fmt(f),
            Error::InvalidRequest(inner) => inner.fmt(f),
            Error::InvalidWriteOffset(inner) => inner.fmt(f),
            Error::NoSuchBucket(inner) => inner.fmt(f),
            Error::NoSuchKey(inner) => inner.fmt(f),
            Error::NoSuchUpload(inner) => inner.fmt(f),
            Error::NotFound(inner) => inner.fmt(f),
            Error::ObjectAlreadyInActiveTierError(inner) => inner.fmt(f),
            Error::ObjectNotInActiveTierError(inner) => inner.fmt(f),
            Error::TooManyParts(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::BucketAlreadyExists(inner) => inner.meta(),
            Self::BucketAlreadyOwnedByYou(inner) => inner.meta(),
            Self::EncryptionTypeMismatch(inner) => inner.meta(),
            Self::IdempotencyParameterMismatch(inner) => inner.meta(),
            Self::InvalidObjectState(inner) => inner.meta(),
            Self::InvalidRequest(inner) => inner.meta(),
            Self::InvalidWriteOffset(inner) => inner.meta(),
            Self::NoSuchBucket(inner) => inner.meta(),
            Self::NoSuchKey(inner) => inner.meta(),
            Self::NoSuchUpload(inner) => inner.meta(),
            Self::NotFound(inner) => inner.meta(),
            Self::ObjectAlreadyInActiveTierError(inner) => inner.meta(),
            Self::ObjectNotInActiveTierError(inner) => inner.meta(),
            Self::TooManyParts(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::abort_multipart_upload::AbortMultipartUploadError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::abort_multipart_upload::AbortMultipartUploadError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::abort_multipart_upload::AbortMultipartUploadError> for Error {
    fn from(err: crate::operation::abort_multipart_upload::AbortMultipartUploadError) -> Self {
        match err {
            crate::operation::abort_multipart_upload::AbortMultipartUploadError::NoSuchUpload(inner) => Error::NoSuchUpload(inner),
            crate::operation::abort_multipart_upload::AbortMultipartUploadError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::complete_multipart_upload::CompleteMultipartUploadError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::complete_multipart_upload::CompleteMultipartUploadError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::complete_multipart_upload::CompleteMultipartUploadError> for Error {
    fn from(err: crate::operation::complete_multipart_upload::CompleteMultipartUploadError) -> Self {
        match err {
            crate::operation::complete_multipart_upload::CompleteMultipartUploadError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::copy_object::CopyObjectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::copy_object::CopyObjectError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::copy_object::CopyObjectError> for Error {
    fn from(err: crate::operation::copy_object::CopyObjectError) -> Self {
        match err {
            crate::operation::copy_object::CopyObjectError::ObjectNotInActiveTierError(inner) => Error::ObjectNotInActiveTierError(inner),
            crate::operation::copy_object::CopyObjectError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_bucket::CreateBucketError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_bucket::CreateBucketError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_bucket::CreateBucketError> for Error {
    fn from(err: crate::operation::create_bucket::CreateBucketError) -> Self {
        match err {
            crate::operation::create_bucket::CreateBucketError::BucketAlreadyExists(inner) => Error::BucketAlreadyExists(inner),
            crate::operation::create_bucket::CreateBucketError::BucketAlreadyOwnedByYou(inner) => Error::BucketAlreadyOwnedByYou(inner),
            crate::operation::create_bucket::CreateBucketError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationError> for Error {
    fn from(err: crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationError) -> Self {
        match err {
            crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError> for Error {
    fn from(err: crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError) -> Self {
        match err {
            crate::operation::create_bucket_metadata_table_configuration::CreateBucketMetadataTableConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_multipart_upload::CreateMultipartUploadError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_multipart_upload::CreateMultipartUploadError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_multipart_upload::CreateMultipartUploadError> for Error {
    fn from(err: crate::operation::create_multipart_upload::CreateMultipartUploadError) -> Self {
        match err {
            crate::operation::create_multipart_upload::CreateMultipartUploadError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_session::CreateSessionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_session::CreateSessionError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_session::CreateSessionError> for Error {
    fn from(err: crate::operation::create_session::CreateSessionError) -> Self {
        match err {
            crate::operation::create_session::CreateSessionError::NoSuchBucket(inner) => Error::NoSuchBucket(inner),
            crate::operation::create_session::CreateSessionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket::DeleteBucketError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket::DeleteBucketError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket::DeleteBucketError> for Error {
    fn from(err: crate::operation::delete_bucket::DeleteBucketError) -> Self {
        match err {
            crate::operation::delete_bucket::DeleteBucketError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_analytics_configuration::DeleteBucketAnalyticsConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_analytics_configuration::DeleteBucketAnalyticsConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_analytics_configuration::DeleteBucketAnalyticsConfigurationError> for Error {
    fn from(err: crate::operation::delete_bucket_analytics_configuration::DeleteBucketAnalyticsConfigurationError) -> Self {
        match err {
            crate::operation::delete_bucket_analytics_configuration::DeleteBucketAnalyticsConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_cors::DeleteBucketCorsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_cors::DeleteBucketCorsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_cors::DeleteBucketCorsError> for Error {
    fn from(err: crate::operation::delete_bucket_cors::DeleteBucketCorsError) -> Self {
        match err {
            crate::operation::delete_bucket_cors::DeleteBucketCorsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_encryption::DeleteBucketEncryptionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_encryption::DeleteBucketEncryptionError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_encryption::DeleteBucketEncryptionError> for Error {
    fn from(err: crate::operation::delete_bucket_encryption::DeleteBucketEncryptionError) -> Self {
        match err {
            crate::operation::delete_bucket_encryption::DeleteBucketEncryptionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_intelligent_tiering_configuration::DeleteBucketIntelligentTieringConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_intelligent_tiering_configuration::DeleteBucketIntelligentTieringConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_intelligent_tiering_configuration::DeleteBucketIntelligentTieringConfigurationError> for Error {
    fn from(err: crate::operation::delete_bucket_intelligent_tiering_configuration::DeleteBucketIntelligentTieringConfigurationError) -> Self {
        match err {
            crate::operation::delete_bucket_intelligent_tiering_configuration::DeleteBucketIntelligentTieringConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_inventory_configuration::DeleteBucketInventoryConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_inventory_configuration::DeleteBucketInventoryConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_inventory_configuration::DeleteBucketInventoryConfigurationError> for Error {
    fn from(err: crate::operation::delete_bucket_inventory_configuration::DeleteBucketInventoryConfigurationError) -> Self {
        match err {
            crate::operation::delete_bucket_inventory_configuration::DeleteBucketInventoryConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_lifecycle::DeleteBucketLifecycleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_lifecycle::DeleteBucketLifecycleError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_lifecycle::DeleteBucketLifecycleError> for Error {
    fn from(err: crate::operation::delete_bucket_lifecycle::DeleteBucketLifecycleError) -> Self {
        match err {
            crate::operation::delete_bucket_lifecycle::DeleteBucketLifecycleError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_metadata_configuration::DeleteBucketMetadataConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_metadata_configuration::DeleteBucketMetadataConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_metadata_configuration::DeleteBucketMetadataConfigurationError> for Error {
    fn from(err: crate::operation::delete_bucket_metadata_configuration::DeleteBucketMetadataConfigurationError) -> Self {
        match err {
            crate::operation::delete_bucket_metadata_configuration::DeleteBucketMetadataConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError> for Error {
    fn from(err: crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError) -> Self {
        match err {
            crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_metrics_configuration::DeleteBucketMetricsConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_metrics_configuration::DeleteBucketMetricsConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_metrics_configuration::DeleteBucketMetricsConfigurationError> for Error {
    fn from(err: crate::operation::delete_bucket_metrics_configuration::DeleteBucketMetricsConfigurationError) -> Self {
        match err {
            crate::operation::delete_bucket_metrics_configuration::DeleteBucketMetricsConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_ownership_controls::DeleteBucketOwnershipControlsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_ownership_controls::DeleteBucketOwnershipControlsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_ownership_controls::DeleteBucketOwnershipControlsError> for Error {
    fn from(err: crate::operation::delete_bucket_ownership_controls::DeleteBucketOwnershipControlsError) -> Self {
        match err {
            crate::operation::delete_bucket_ownership_controls::DeleteBucketOwnershipControlsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_policy::DeleteBucketPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_policy::DeleteBucketPolicyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_policy::DeleteBucketPolicyError> for Error {
    fn from(err: crate::operation::delete_bucket_policy::DeleteBucketPolicyError) -> Self {
        match err {
            crate::operation::delete_bucket_policy::DeleteBucketPolicyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_replication::DeleteBucketReplicationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_replication::DeleteBucketReplicationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_replication::DeleteBucketReplicationError> for Error {
    fn from(err: crate::operation::delete_bucket_replication::DeleteBucketReplicationError) -> Self {
        match err {
            crate::operation::delete_bucket_replication::DeleteBucketReplicationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_tagging::DeleteBucketTaggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_tagging::DeleteBucketTaggingError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_tagging::DeleteBucketTaggingError> for Error {
    fn from(err: crate::operation::delete_bucket_tagging::DeleteBucketTaggingError) -> Self {
        match err {
            crate::operation::delete_bucket_tagging::DeleteBucketTaggingError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_website::DeleteBucketWebsiteError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_bucket_website::DeleteBucketWebsiteError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_bucket_website::DeleteBucketWebsiteError> for Error {
    fn from(err: crate::operation::delete_bucket_website::DeleteBucketWebsiteError) -> Self {
        match err {
            crate::operation::delete_bucket_website::DeleteBucketWebsiteError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_object::DeleteObjectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_object::DeleteObjectError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_object::DeleteObjectError> for Error {
    fn from(err: crate::operation::delete_object::DeleteObjectError) -> Self {
        match err {
            crate::operation::delete_object::DeleteObjectError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_objects::DeleteObjectsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_objects::DeleteObjectsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_objects::DeleteObjectsError> for Error {
    fn from(err: crate::operation::delete_objects::DeleteObjectsError) -> Self {
        match err {
            crate::operation::delete_objects::DeleteObjectsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_object_tagging::DeleteObjectTaggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_object_tagging::DeleteObjectTaggingError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_object_tagging::DeleteObjectTaggingError> for Error {
    fn from(err: crate::operation::delete_object_tagging::DeleteObjectTaggingError) -> Self {
        match err {
            crate::operation::delete_object_tagging::DeleteObjectTaggingError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_public_access_block::DeletePublicAccessBlockError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_public_access_block::DeletePublicAccessBlockError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_public_access_block::DeletePublicAccessBlockError> for Error {
    fn from(err: crate::operation::delete_public_access_block::DeletePublicAccessBlockError) -> Self {
        match err {
            crate::operation::delete_public_access_block::DeletePublicAccessBlockError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_abac::GetBucketAbacError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_abac::GetBucketAbacError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_abac::GetBucketAbacError> for Error {
    fn from(err: crate::operation::get_bucket_abac::GetBucketAbacError) -> Self {
        match err {
            crate::operation::get_bucket_abac::GetBucketAbacError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_accelerate_configuration::GetBucketAccelerateConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_accelerate_configuration::GetBucketAccelerateConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_accelerate_configuration::GetBucketAccelerateConfigurationError> for Error {
    fn from(err: crate::operation::get_bucket_accelerate_configuration::GetBucketAccelerateConfigurationError) -> Self {
        match err {
            crate::operation::get_bucket_accelerate_configuration::GetBucketAccelerateConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_acl::GetBucketAclError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_acl::GetBucketAclError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_acl::GetBucketAclError> for Error {
    fn from(err: crate::operation::get_bucket_acl::GetBucketAclError) -> Self {
        match err {
            crate::operation::get_bucket_acl::GetBucketAclError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_analytics_configuration::GetBucketAnalyticsConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_analytics_configuration::GetBucketAnalyticsConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_analytics_configuration::GetBucketAnalyticsConfigurationError> for Error {
    fn from(err: crate::operation::get_bucket_analytics_configuration::GetBucketAnalyticsConfigurationError) -> Self {
        match err {
            crate::operation::get_bucket_analytics_configuration::GetBucketAnalyticsConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_cors::GetBucketCorsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_cors::GetBucketCorsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_cors::GetBucketCorsError> for Error {
    fn from(err: crate::operation::get_bucket_cors::GetBucketCorsError) -> Self {
        match err {
            crate::operation::get_bucket_cors::GetBucketCorsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_encryption::GetBucketEncryptionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_encryption::GetBucketEncryptionError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_encryption::GetBucketEncryptionError> for Error {
    fn from(err: crate::operation::get_bucket_encryption::GetBucketEncryptionError) -> Self {
        match err {
            crate::operation::get_bucket_encryption::GetBucketEncryptionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_intelligent_tiering_configuration::GetBucketIntelligentTieringConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_intelligent_tiering_configuration::GetBucketIntelligentTieringConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_intelligent_tiering_configuration::GetBucketIntelligentTieringConfigurationError> for Error {
    fn from(err: crate::operation::get_bucket_intelligent_tiering_configuration::GetBucketIntelligentTieringConfigurationError) -> Self {
        match err {
            crate::operation::get_bucket_intelligent_tiering_configuration::GetBucketIntelligentTieringConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_inventory_configuration::GetBucketInventoryConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_inventory_configuration::GetBucketInventoryConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_inventory_configuration::GetBucketInventoryConfigurationError> for Error {
    fn from(err: crate::operation::get_bucket_inventory_configuration::GetBucketInventoryConfigurationError) -> Self {
        match err {
            crate::operation::get_bucket_inventory_configuration::GetBucketInventoryConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_lifecycle_configuration::GetBucketLifecycleConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_lifecycle_configuration::GetBucketLifecycleConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_lifecycle_configuration::GetBucketLifecycleConfigurationError> for Error {
    fn from(err: crate::operation::get_bucket_lifecycle_configuration::GetBucketLifecycleConfigurationError) -> Self {
        match err {
            crate::operation::get_bucket_lifecycle_configuration::GetBucketLifecycleConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_location::GetBucketLocationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_location::GetBucketLocationError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_location::GetBucketLocationError> for Error {
    fn from(err: crate::operation::get_bucket_location::GetBucketLocationError) -> Self {
        match err {
            crate::operation::get_bucket_location::GetBucketLocationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_logging::GetBucketLoggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_logging::GetBucketLoggingError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_logging::GetBucketLoggingError> for Error {
    fn from(err: crate::operation::get_bucket_logging::GetBucketLoggingError) -> Self {
        match err {
            crate::operation::get_bucket_logging::GetBucketLoggingError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_metadata_configuration::GetBucketMetadataConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_metadata_configuration::GetBucketMetadataConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_metadata_configuration::GetBucketMetadataConfigurationError> for Error {
    fn from(err: crate::operation::get_bucket_metadata_configuration::GetBucketMetadataConfigurationError) -> Self {
        match err {
            crate::operation::get_bucket_metadata_configuration::GetBucketMetadataConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_metadata_table_configuration::GetBucketMetadataTableConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_metadata_table_configuration::GetBucketMetadataTableConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_metadata_table_configuration::GetBucketMetadataTableConfigurationError> for Error {
    fn from(err: crate::operation::get_bucket_metadata_table_configuration::GetBucketMetadataTableConfigurationError) -> Self {
        match err {
            crate::operation::get_bucket_metadata_table_configuration::GetBucketMetadataTableConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_metrics_configuration::GetBucketMetricsConfigurationError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_metrics_configuration::GetBucketMetricsConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_metrics_configuration::GetBucketMetricsConfigurationError> for Error {
    fn from(err: crate::operation::get_bucket_metrics_configuration::GetBucketMetricsConfigurationError) -> Self {
        match err {
            crate::operation::get_bucket_metrics_configuration::GetBucketMetricsConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationError> for Error {
    fn from(err: crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationError) -> Self {
        match err {
            crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_ownership_controls::GetBucketOwnershipControlsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_ownership_controls::GetBucketOwnershipControlsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_ownership_controls::GetBucketOwnershipControlsError> for Error {
    fn from(err: crate::operation::get_bucket_ownership_controls::GetBucketOwnershipControlsError) -> Self {
        match err {
            crate::operation::get_bucket_ownership_controls::GetBucketOwnershipControlsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_policy::GetBucketPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_policy::GetBucketPolicyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_policy::GetBucketPolicyError> for Error {
    fn from(err: crate::operation::get_bucket_policy::GetBucketPolicyError) -> Self {
        match err {
            crate::operation::get_bucket_policy::GetBucketPolicyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_policy_status::GetBucketPolicyStatusError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_policy_status::GetBucketPolicyStatusError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_policy_status::GetBucketPolicyStatusError> for Error {
    fn from(err: crate::operation::get_bucket_policy_status::GetBucketPolicyStatusError) -> Self {
        match err {
            crate::operation::get_bucket_policy_status::GetBucketPolicyStatusError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_replication::GetBucketReplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_replication::GetBucketReplicationError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_replication::GetBucketReplicationError> for Error {
    fn from(err: crate::operation::get_bucket_replication::GetBucketReplicationError) -> Self {
        match err {
            crate::operation::get_bucket_replication::GetBucketReplicationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_request_payment::GetBucketRequestPaymentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_request_payment::GetBucketRequestPaymentError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_request_payment::GetBucketRequestPaymentError> for Error {
    fn from(err: crate::operation::get_bucket_request_payment::GetBucketRequestPaymentError) -> Self {
        match err {
            crate::operation::get_bucket_request_payment::GetBucketRequestPaymentError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_tagging::GetBucketTaggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_tagging::GetBucketTaggingError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_tagging::GetBucketTaggingError> for Error {
    fn from(err: crate::operation::get_bucket_tagging::GetBucketTaggingError) -> Self {
        match err {
            crate::operation::get_bucket_tagging::GetBucketTaggingError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_versioning::GetBucketVersioningError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_versioning::GetBucketVersioningError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_versioning::GetBucketVersioningError> for Error {
    fn from(err: crate::operation::get_bucket_versioning::GetBucketVersioningError) -> Self {
        match err {
            crate::operation::get_bucket_versioning::GetBucketVersioningError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_website::GetBucketWebsiteError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_bucket_website::GetBucketWebsiteError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_bucket_website::GetBucketWebsiteError> for Error {
    fn from(err: crate::operation::get_bucket_website::GetBucketWebsiteError) -> Self {
        match err {
            crate::operation::get_bucket_website::GetBucketWebsiteError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object::GetObjectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object::GetObjectError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_object::GetObjectError> for Error {
    fn from(err: crate::operation::get_object::GetObjectError) -> Self {
        match err {
            crate::operation::get_object::GetObjectError::InvalidObjectState(inner) => Error::InvalidObjectState(inner),
            crate::operation::get_object::GetObjectError::NoSuchKey(inner) => Error::NoSuchKey(inner),
            crate::operation::get_object::GetObjectError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_acl::GetObjectAclError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_acl::GetObjectAclError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_object_acl::GetObjectAclError> for Error {
    fn from(err: crate::operation::get_object_acl::GetObjectAclError) -> Self {
        match err {
            crate::operation::get_object_acl::GetObjectAclError::NoSuchKey(inner) => Error::NoSuchKey(inner),
            crate::operation::get_object_acl::GetObjectAclError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_attributes::GetObjectAttributesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_attributes::GetObjectAttributesError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_object_attributes::GetObjectAttributesError> for Error {
    fn from(err: crate::operation::get_object_attributes::GetObjectAttributesError) -> Self {
        match err {
            crate::operation::get_object_attributes::GetObjectAttributesError::NoSuchKey(inner) => Error::NoSuchKey(inner),
            crate::operation::get_object_attributes::GetObjectAttributesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_legal_hold::GetObjectLegalHoldError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_legal_hold::GetObjectLegalHoldError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_object_legal_hold::GetObjectLegalHoldError> for Error {
    fn from(err: crate::operation::get_object_legal_hold::GetObjectLegalHoldError) -> Self {
        match err {
            crate::operation::get_object_legal_hold::GetObjectLegalHoldError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_lock_configuration::GetObjectLockConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_lock_configuration::GetObjectLockConfigurationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_object_lock_configuration::GetObjectLockConfigurationError> for Error {
    fn from(err: crate::operation::get_object_lock_configuration::GetObjectLockConfigurationError) -> Self {
        match err {
            crate::operation::get_object_lock_configuration::GetObjectLockConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_retention::GetObjectRetentionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_retention::GetObjectRetentionError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_object_retention::GetObjectRetentionError> for Error {
    fn from(err: crate::operation::get_object_retention::GetObjectRetentionError) -> Self {
        match err {
            crate::operation::get_object_retention::GetObjectRetentionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_tagging::GetObjectTaggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_tagging::GetObjectTaggingError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_object_tagging::GetObjectTaggingError> for Error {
    fn from(err: crate::operation::get_object_tagging::GetObjectTaggingError) -> Self {
        match err {
            crate::operation::get_object_tagging::GetObjectTaggingError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_torrent::GetObjectTorrentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_object_torrent::GetObjectTorrentError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_object_torrent::GetObjectTorrentError> for Error {
    fn from(err: crate::operation::get_object_torrent::GetObjectTorrentError) -> Self {
        match err {
            crate::operation::get_object_torrent::GetObjectTorrentError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_public_access_block::GetPublicAccessBlockError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_public_access_block::GetPublicAccessBlockError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_public_access_block::GetPublicAccessBlockError> for Error {
    fn from(err: crate::operation::get_public_access_block::GetPublicAccessBlockError) -> Self {
        match err {
            crate::operation::get_public_access_block::GetPublicAccessBlockError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::head_bucket::HeadBucketError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::head_bucket::HeadBucketError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::head_bucket::HeadBucketError> for Error {
    fn from(err: crate::operation::head_bucket::HeadBucketError) -> Self {
        match err {
            crate::operation::head_bucket::HeadBucketError::NotFound(inner) => Error::NotFound(inner),
            crate::operation::head_bucket::HeadBucketError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::head_object::HeadObjectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::head_object::HeadObjectError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::head_object::HeadObjectError> for Error {
    fn from(err: crate::operation::head_object::HeadObjectError) -> Self {
        match err {
            crate::operation::head_object::HeadObjectError::NotFound(inner) => Error::NotFound(inner),
            crate::operation::head_object::HeadObjectError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsError> for Error {
    fn from(err: crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsError) -> Self {
        match err {
            crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_bucket_intelligent_tiering_configurations::ListBucketIntelligentTieringConfigurationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_bucket_intelligent_tiering_configurations::ListBucketIntelligentTieringConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_bucket_intelligent_tiering_configurations::ListBucketIntelligentTieringConfigurationsError> for Error {
    fn from(err: crate::operation::list_bucket_intelligent_tiering_configurations::ListBucketIntelligentTieringConfigurationsError) -> Self {
        match err {
            crate::operation::list_bucket_intelligent_tiering_configurations::ListBucketIntelligentTieringConfigurationsError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsError> for Error {
    fn from(err: crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsError) -> Self {
        match err {
            crate::operation::list_bucket_inventory_configurations::ListBucketInventoryConfigurationsError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsError> for Error {
    fn from(err: crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsError) -> Self {
        match err {
            crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_buckets::ListBucketsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_buckets::ListBucketsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_buckets::ListBucketsError> for Error {
    fn from(err: crate::operation::list_buckets::ListBucketsError) -> Self {
        match err {
            crate::operation::list_buckets::ListBucketsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_directory_buckets::ListDirectoryBucketsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_directory_buckets::ListDirectoryBucketsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_directory_buckets::ListDirectoryBucketsError> for Error {
    fn from(err: crate::operation::list_directory_buckets::ListDirectoryBucketsError) -> Self {
        match err {
            crate::operation::list_directory_buckets::ListDirectoryBucketsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_multipart_uploads::ListMultipartUploadsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_multipart_uploads::ListMultipartUploadsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_multipart_uploads::ListMultipartUploadsError> for Error {
    fn from(err: crate::operation::list_multipart_uploads::ListMultipartUploadsError) -> Self {
        match err {
            crate::operation::list_multipart_uploads::ListMultipartUploadsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_objects::ListObjectsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_objects::ListObjectsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_objects::ListObjectsError> for Error {
    fn from(err: crate::operation::list_objects::ListObjectsError) -> Self {
        match err {
            crate::operation::list_objects::ListObjectsError::NoSuchBucket(inner) => Error::NoSuchBucket(inner),
            crate::operation::list_objects::ListObjectsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_objects_v2::ListObjectsV2Error, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_objects_v2::ListObjectsV2Error, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_objects_v2::ListObjectsV2Error> for Error {
    fn from(err: crate::operation::list_objects_v2::ListObjectsV2Error) -> Self {
        match err {
            crate::operation::list_objects_v2::ListObjectsV2Error::NoSuchBucket(inner) => Error::NoSuchBucket(inner),
            crate::operation::list_objects_v2::ListObjectsV2Error::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_object_versions::ListObjectVersionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_object_versions::ListObjectVersionsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_object_versions::ListObjectVersionsError> for Error {
    fn from(err: crate::operation::list_object_versions::ListObjectVersionsError) -> Self {
        match err {
            crate::operation::list_object_versions::ListObjectVersionsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_parts::ListPartsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_parts::ListPartsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_parts::ListPartsError> for Error {
    fn from(err: crate::operation::list_parts::ListPartsError) -> Self {
        match err {
            crate::operation::list_parts::ListPartsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_abac::PutBucketAbacError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_abac::PutBucketAbacError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_abac::PutBucketAbacError> for Error {
    fn from(err: crate::operation::put_bucket_abac::PutBucketAbacError) -> Self {
        match err {
            crate::operation::put_bucket_abac::PutBucketAbacError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_accelerate_configuration::PutBucketAccelerateConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_accelerate_configuration::PutBucketAccelerateConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_accelerate_configuration::PutBucketAccelerateConfigurationError> for Error {
    fn from(err: crate::operation::put_bucket_accelerate_configuration::PutBucketAccelerateConfigurationError) -> Self {
        match err {
            crate::operation::put_bucket_accelerate_configuration::PutBucketAccelerateConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_acl::PutBucketAclError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_acl::PutBucketAclError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_acl::PutBucketAclError> for Error {
    fn from(err: crate::operation::put_bucket_acl::PutBucketAclError) -> Self {
        match err {
            crate::operation::put_bucket_acl::PutBucketAclError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationError> for Error {
    fn from(err: crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationError) -> Self {
        match err {
            crate::operation::put_bucket_analytics_configuration::PutBucketAnalyticsConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_cors::PutBucketCorsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_cors::PutBucketCorsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_cors::PutBucketCorsError> for Error {
    fn from(err: crate::operation::put_bucket_cors::PutBucketCorsError) -> Self {
        match err {
            crate::operation::put_bucket_cors::PutBucketCorsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_encryption::PutBucketEncryptionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_encryption::PutBucketEncryptionError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_encryption::PutBucketEncryptionError> for Error {
    fn from(err: crate::operation::put_bucket_encryption::PutBucketEncryptionError) -> Self {
        match err {
            crate::operation::put_bucket_encryption::PutBucketEncryptionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_intelligent_tiering_configuration::PutBucketIntelligentTieringConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_intelligent_tiering_configuration::PutBucketIntelligentTieringConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_intelligent_tiering_configuration::PutBucketIntelligentTieringConfigurationError> for Error {
    fn from(err: crate::operation::put_bucket_intelligent_tiering_configuration::PutBucketIntelligentTieringConfigurationError) -> Self {
        match err {
            crate::operation::put_bucket_intelligent_tiering_configuration::PutBucketIntelligentTieringConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_inventory_configuration::PutBucketInventoryConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_inventory_configuration::PutBucketInventoryConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_inventory_configuration::PutBucketInventoryConfigurationError> for Error {
    fn from(err: crate::operation::put_bucket_inventory_configuration::PutBucketInventoryConfigurationError) -> Self {
        match err {
            crate::operation::put_bucket_inventory_configuration::PutBucketInventoryConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_lifecycle_configuration::PutBucketLifecycleConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_lifecycle_configuration::PutBucketLifecycleConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_lifecycle_configuration::PutBucketLifecycleConfigurationError> for Error {
    fn from(err: crate::operation::put_bucket_lifecycle_configuration::PutBucketLifecycleConfigurationError) -> Self {
        match err {
            crate::operation::put_bucket_lifecycle_configuration::PutBucketLifecycleConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_logging::PutBucketLoggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_logging::PutBucketLoggingError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_logging::PutBucketLoggingError> for Error {
    fn from(err: crate::operation::put_bucket_logging::PutBucketLoggingError) -> Self {
        match err {
            crate::operation::put_bucket_logging::PutBucketLoggingError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_metrics_configuration::PutBucketMetricsConfigurationError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_metrics_configuration::PutBucketMetricsConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_metrics_configuration::PutBucketMetricsConfigurationError> for Error {
    fn from(err: crate::operation::put_bucket_metrics_configuration::PutBucketMetricsConfigurationError) -> Self {
        match err {
            crate::operation::put_bucket_metrics_configuration::PutBucketMetricsConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_notification_configuration::PutBucketNotificationConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_bucket_notification_configuration::PutBucketNotificationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_notification_configuration::PutBucketNotificationConfigurationError> for Error {
    fn from(err: crate::operation::put_bucket_notification_configuration::PutBucketNotificationConfigurationError) -> Self {
        match err {
            crate::operation::put_bucket_notification_configuration::PutBucketNotificationConfigurationError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_ownership_controls::PutBucketOwnershipControlsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_ownership_controls::PutBucketOwnershipControlsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_ownership_controls::PutBucketOwnershipControlsError> for Error {
    fn from(err: crate::operation::put_bucket_ownership_controls::PutBucketOwnershipControlsError) -> Self {
        match err {
            crate::operation::put_bucket_ownership_controls::PutBucketOwnershipControlsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_policy::PutBucketPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_policy::PutBucketPolicyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_policy::PutBucketPolicyError> for Error {
    fn from(err: crate::operation::put_bucket_policy::PutBucketPolicyError) -> Self {
        match err {
            crate::operation::put_bucket_policy::PutBucketPolicyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_replication::PutBucketReplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_replication::PutBucketReplicationError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_replication::PutBucketReplicationError> for Error {
    fn from(err: crate::operation::put_bucket_replication::PutBucketReplicationError) -> Self {
        match err {
            crate::operation::put_bucket_replication::PutBucketReplicationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_request_payment::PutBucketRequestPaymentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_request_payment::PutBucketRequestPaymentError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_request_payment::PutBucketRequestPaymentError> for Error {
    fn from(err: crate::operation::put_bucket_request_payment::PutBucketRequestPaymentError) -> Self {
        match err {
            crate::operation::put_bucket_request_payment::PutBucketRequestPaymentError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_tagging::PutBucketTaggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_tagging::PutBucketTaggingError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_tagging::PutBucketTaggingError> for Error {
    fn from(err: crate::operation::put_bucket_tagging::PutBucketTaggingError) -> Self {
        match err {
            crate::operation::put_bucket_tagging::PutBucketTaggingError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_versioning::PutBucketVersioningError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_versioning::PutBucketVersioningError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_versioning::PutBucketVersioningError> for Error {
    fn from(err: crate::operation::put_bucket_versioning::PutBucketVersioningError) -> Self {
        match err {
            crate::operation::put_bucket_versioning::PutBucketVersioningError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_website::PutBucketWebsiteError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_bucket_website::PutBucketWebsiteError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_bucket_website::PutBucketWebsiteError> for Error {
    fn from(err: crate::operation::put_bucket_website::PutBucketWebsiteError) -> Self {
        match err {
            crate::operation::put_bucket_website::PutBucketWebsiteError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object::PutObjectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object::PutObjectError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_object::PutObjectError> for Error {
    fn from(err: crate::operation::put_object::PutObjectError) -> Self {
        match err {
            crate::operation::put_object::PutObjectError::EncryptionTypeMismatch(inner) => Error::EncryptionTypeMismatch(inner),
            crate::operation::put_object::PutObjectError::InvalidRequest(inner) => Error::InvalidRequest(inner),
            crate::operation::put_object::PutObjectError::InvalidWriteOffset(inner) => Error::InvalidWriteOffset(inner),
            crate::operation::put_object::PutObjectError::TooManyParts(inner) => Error::TooManyParts(inner),
            crate::operation::put_object::PutObjectError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_acl::PutObjectAclError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_acl::PutObjectAclError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_object_acl::PutObjectAclError> for Error {
    fn from(err: crate::operation::put_object_acl::PutObjectAclError) -> Self {
        match err {
            crate::operation::put_object_acl::PutObjectAclError::NoSuchKey(inner) => Error::NoSuchKey(inner),
            crate::operation::put_object_acl::PutObjectAclError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_legal_hold::PutObjectLegalHoldError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_legal_hold::PutObjectLegalHoldError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_object_legal_hold::PutObjectLegalHoldError> for Error {
    fn from(err: crate::operation::put_object_legal_hold::PutObjectLegalHoldError) -> Self {
        match err {
            crate::operation::put_object_legal_hold::PutObjectLegalHoldError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_lock_configuration::PutObjectLockConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_lock_configuration::PutObjectLockConfigurationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_object_lock_configuration::PutObjectLockConfigurationError> for Error {
    fn from(err: crate::operation::put_object_lock_configuration::PutObjectLockConfigurationError) -> Self {
        match err {
            crate::operation::put_object_lock_configuration::PutObjectLockConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_retention::PutObjectRetentionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_retention::PutObjectRetentionError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_object_retention::PutObjectRetentionError> for Error {
    fn from(err: crate::operation::put_object_retention::PutObjectRetentionError) -> Self {
        match err {
            crate::operation::put_object_retention::PutObjectRetentionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_tagging::PutObjectTaggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_object_tagging::PutObjectTaggingError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_object_tagging::PutObjectTaggingError> for Error {
    fn from(err: crate::operation::put_object_tagging::PutObjectTaggingError) -> Self {
        match err {
            crate::operation::put_object_tagging::PutObjectTaggingError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_public_access_block::PutPublicAccessBlockError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_public_access_block::PutPublicAccessBlockError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_public_access_block::PutPublicAccessBlockError> for Error {
    fn from(err: crate::operation::put_public_access_block::PutPublicAccessBlockError) -> Self {
        match err {
            crate::operation::put_public_access_block::PutPublicAccessBlockError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::rename_object::RenameObjectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::rename_object::RenameObjectError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::rename_object::RenameObjectError> for Error {
    fn from(err: crate::operation::rename_object::RenameObjectError) -> Self {
        match err {
            crate::operation::rename_object::RenameObjectError::IdempotencyParameterMismatch(inner) => Error::IdempotencyParameterMismatch(inner),
            crate::operation::rename_object::RenameObjectError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::restore_object::RestoreObjectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::restore_object::RestoreObjectError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::restore_object::RestoreObjectError> for Error {
    fn from(err: crate::operation::restore_object::RestoreObjectError) -> Self {
        match err {
            crate::operation::restore_object::RestoreObjectError::ObjectAlreadyInActiveTierError(inner) => {
                Error::ObjectAlreadyInActiveTierError(inner)
            }
            crate::operation::restore_object::RestoreObjectError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::select_object_content::SelectObjectContentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::select_object_content::SelectObjectContentError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::select_object_content::SelectObjectContentError> for Error {
    fn from(err: crate::operation::select_object_content::SelectObjectContentError) -> Self {
        match err {
            crate::operation::select_object_content::SelectObjectContentError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_bucket_metadata_inventory_table_configuration::UpdateBucketMetadataInventoryTableConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_bucket_metadata_inventory_table_configuration::UpdateBucketMetadataInventoryTableConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_bucket_metadata_inventory_table_configuration::UpdateBucketMetadataInventoryTableConfigurationError> for Error {
    fn from(
        err: crate::operation::update_bucket_metadata_inventory_table_configuration::UpdateBucketMetadataInventoryTableConfigurationError,
    ) -> Self {
        match err {
            crate::operation::update_bucket_metadata_inventory_table_configuration::UpdateBucketMetadataInventoryTableConfigurationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationError> for Error {
    fn from(err: crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationError) -> Self {
        match err {
            crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationError::Unhandled(
                inner,
            ) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::upload_part::UploadPartError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::upload_part::UploadPartError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::upload_part::UploadPartError> for Error {
    fn from(err: crate::operation::upload_part::UploadPartError) -> Self {
        match err {
            crate::operation::upload_part::UploadPartError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::upload_part_copy::UploadPartCopyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::upload_part_copy::UploadPartCopyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::upload_part_copy::UploadPartCopyError> for Error {
    fn from(err: crate::operation::upload_part_copy::UploadPartCopyError) -> Self {
        match err {
            crate::operation::upload_part_copy::UploadPartCopyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::write_get_object_response::WriteGetObjectResponseError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::write_get_object_response::WriteGetObjectResponseError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::write_get_object_response::WriteGetObjectResponseError> for Error {
    fn from(err: crate::operation::write_get_object_response::WriteGetObjectResponseError) -> Self {
        match err {
            crate::operation::write_get_object_response::WriteGetObjectResponseError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<O, E> ::std::convert::From<::aws_smithy_runtime_api::client::waiters::error::WaiterError<O, E>> for Error
where
    O: ::std::fmt::Debug + ::std::marker::Send + ::std::marker::Sync + 'static,
    E: ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::waiters::error::WaiterError<O, E>) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            meta: ::std::default::Default::default(),
            source: err.into(),
        })
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::SelectObjectContentEventStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::SelectObjectContentEventStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::SelectObjectContentEventStreamError> for Error {
    fn from(err: crate::types::error::SelectObjectContentEventStreamError) -> Self {
        match err {
            crate::types::error::SelectObjectContentEventStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::BucketAlreadyExists(inner) => inner.source(),
            Error::BucketAlreadyOwnedByYou(inner) => inner.source(),
            Error::EncryptionTypeMismatch(inner) => inner.source(),
            Error::IdempotencyParameterMismatch(inner) => inner.source(),
            Error::InvalidObjectState(inner) => inner.source(),
            Error::InvalidRequest(inner) => inner.source(),
            Error::InvalidWriteOffset(inner) => inner.source(),
            Error::NoSuchBucket(inner) => inner.source(),
            Error::NoSuchKey(inner) => inner.source(),
            Error::NoSuchUpload(inner) => inner.source(),
            Error::NotFound(inner) => inner.source(),
            Error::ObjectAlreadyInActiveTierError(inner) => inner.source(),
            Error::ObjectNotInActiveTierError(inner) => inner.source(),
            Error::TooManyParts(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl crate::s3_request_id::RequestIdExt for Error {
    fn extended_request_id(&self) -> Option<&str> {
        match self {
            Self::BucketAlreadyExists(e) => e.extended_request_id(),
            Self::BucketAlreadyOwnedByYou(e) => e.extended_request_id(),
            Self::EncryptionTypeMismatch(e) => e.extended_request_id(),
            Self::IdempotencyParameterMismatch(e) => e.extended_request_id(),
            Self::InvalidObjectState(e) => e.extended_request_id(),
            Self::InvalidRequest(e) => e.extended_request_id(),
            Self::InvalidWriteOffset(e) => e.extended_request_id(),
            Self::NoSuchBucket(e) => e.extended_request_id(),
            Self::NoSuchKey(e) => e.extended_request_id(),
            Self::NoSuchUpload(e) => e.extended_request_id(),
            Self::NotFound(e) => e.extended_request_id(),
            Self::ObjectAlreadyInActiveTierError(e) => e.extended_request_id(),
            Self::ObjectNotInActiveTierError(e) => e.extended_request_id(),
            Self::TooManyParts(e) => e.extended_request_id(),
            Self::Unhandled(e) => e.meta.extended_request_id(),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::BucketAlreadyExists(e) => e.request_id(),
            Self::BucketAlreadyOwnedByYou(e) => e.request_id(),
            Self::EncryptionTypeMismatch(e) => e.request_id(),
            Self::IdempotencyParameterMismatch(e) => e.request_id(),
            Self::InvalidObjectState(e) => e.request_id(),
            Self::InvalidRequest(e) => e.request_id(),
            Self::InvalidWriteOffset(e) => e.request_id(),
            Self::NoSuchBucket(e) => e.request_id(),
            Self::NoSuchKey(e) => e.request_id(),
            Self::NoSuchUpload(e) => e.request_id(),
            Self::NotFound(e) => e.request_id(),
            Self::ObjectAlreadyInActiveTierError(e) => e.request_id(),
            Self::ObjectNotInActiveTierError(e) => e.request_id(),
            Self::TooManyParts(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
