/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.ImageEncoderCCITTFax;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSImageHandlerRawCCITTFax
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_CCITTFAX};

    @Override
    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRawCCITTFax ccitt = (ImageRawCCITTFax)image;
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        Rectangle2D.Float targetRect = new Rectangle2D.Float(x, y, w, h);
        ImageInfo info = image.getInfo();
        ImageEncoderCCITTFax encoder = new ImageEncoderCCITTFax(ccitt);
        PSImageUtils.writeImage((ImageEncoder)encoder, (Dimension)info.getSize().getDimensionPx(), (String)info.getOriginalURI(), (Rectangle2D)targetRect, (ColorSpace)ccitt.getColorSpace(), (int)1, (boolean)false, (PSGenerator)gen);
    }

    @Override
    public void generateForm(RenderingContext context, Image image, PSImageFormResource form) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRawCCITTFax ccitt = (ImageRawCCITTFax)image;
        ImageInfo info = image.getInfo();
        String imageDescription = info.getMimeType() + " " + info.getOriginalURI();
        ImageEncoderCCITTFax encoder = new ImageEncoderCCITTFax(ccitt);
        ImageFormGenerator formGen = new ImageFormGenerator(form.getName(), imageDescription, info.getSize().getDimensionPt(), info.getSize().getDimensionPx(), (ImageEncoder)encoder, ccitt.getColorSpace(), 1, false);
        formGen.generate(gen);
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public Class getSupportedImageClass() {
        return ImageRawCCITTFax.class;
    }

    @Override
    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isCompatible(RenderingContext targetContext, Image image) {
        PSRenderingContext psContext;
        if (targetContext instanceof PSRenderingContext && (psContext = (PSRenderingContext)targetContext).getGenerator().getPSLevel() >= 2) {
            return image == null || image instanceof ImageRawCCITTFax;
        }
        return false;
    }
}

