/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.QNameException;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.z.IntIterator;

public abstract class NameChecker {
    public static boolean isQName(IntIterator codePoints) {
        boolean atStart = true;
        boolean foundColon = false;
        while (codePoints.hasNext()) {
            int ch = codePoints.next();
            if (ch == 58) {
                if (atStart || foundColon) {
                    return false;
                }
                atStart = true;
                foundColon = true;
                continue;
            }
            if (atStart) {
                if (!NameChecker.isNCNameStartChar(ch)) {
                    return false;
                }
                atStart = false;
                continue;
            }
            if (NameChecker.isNCNameChar(ch)) continue;
            return false;
        }
        return !atStart;
    }

    public static String getPrefix(String qname) {
        int colon = qname.indexOf(58);
        if (colon < 0) {
            return "";
        }
        return qname.substring(0, colon);
    }

    public static String[] getQNameParts(String qname) throws QNameException {
        String[] parts = new String[2];
        int len = qname.length();
        int colon = qname.indexOf(58, 0);
        if (colon < 0) {
            parts[0] = "";
            parts[1] = qname;
            if (!NameChecker.isValidNCName(StringTool.codePoints(qname))) {
                throw new QNameException("Invalid QName " + Err.wrap(qname));
            }
        } else {
            if (colon == 0) {
                throw new QNameException("QName cannot start with colon: " + Err.wrap(qname));
            }
            if (colon == len - 1) {
                throw new QNameException("QName cannot end with colon: " + Err.wrap(qname));
            }
            parts[0] = qname.substring(0, colon);
            parts[1] = qname.substring(colon + 1);
            if (!NameChecker.isValidNCName(parts[1])) {
                if (!NameChecker.isValidNCName(parts[0])) {
                    throw new QNameException("Both the prefix " + Err.wrap(parts[0]) + " and the local part " + Err.wrap(parts[1]) + " are invalid");
                }
                throw new QNameException("Invalid QName local part " + Err.wrap(parts[1]));
            }
        }
        return parts;
    }

    public static String[] checkQNameParts(String qname) throws XPathException {
        try {
            String[] parts = NameChecker.getQNameParts(qname);
            if (parts[0].length() > 0 && !NameChecker.isValidNCName(parts[0])) {
                throw new XPathException("Invalid QName prefix " + Err.wrap(parts[0]));
            }
            return parts;
        }
        catch (QNameException e) {
            throw new XPathException(e.getMessage(), "FORG0001");
        }
    }

    public static boolean isValidNCName(IntIterator codePoints) {
        boolean first = true;
        while (codePoints.hasNext()) {
            int ch = codePoints.next();
            if (first) {
                if (!NameChecker.isNCNameStartChar(ch)) {
                    return false;
                }
                first = false;
                continue;
            }
            if (NameChecker.isNCNameChar(ch)) continue;
            return false;
        }
        return !first;
    }

    public static boolean isValidNCName(String str) {
        return NameChecker.isValidNCName(StringTool.codePoints(str));
    }

    public static boolean isValidNmtoken(UnicodeString in) {
        IntIterator codePoints = in.codePoints();
        boolean empty = true;
        while (codePoints.hasNext()) {
            int ch = codePoints.next();
            empty = false;
            if (ch == 58 || NameChecker.isNCNameChar(ch)) continue;
            return false;
        }
        return !empty;
    }

    public static boolean isNCNameChar(int ch) {
        return XMLCharacterData.isNCName11(ch);
    }

    public static boolean isNCNameStartChar(int ch) {
        return XMLCharacterData.isNCNameStart11(ch);
    }
}

