/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package externalversions

import (
	fmt "fmt"

	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
	v1 "k8s.io/code-generator/examples/crd/apis/conflicting/v1"
	examplev1 "k8s.io/code-generator/examples/crd/apis/example/v1"
	example2v1 "k8s.io/code-generator/examples/crd/apis/example2/v1"
	extensionsv1 "k8s.io/code-generator/examples/crd/apis/extensions/v1"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=conflicting.test.crd.code-generator.k8s.io, Version=v1
	case v1.SchemeGroupVersion.WithResource("testtypes"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.ConflictingExample().V1().TestTypes().Informer()}, nil

		// Group=example.crd.code-generator.k8s.io, Version=v1
	case examplev1.SchemeGroupVersion.WithResource("clustertesttypes"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Example().V1().ClusterTestTypes().Informer()}, nil
	case examplev1.SchemeGroupVersion.WithResource("testtypes"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Example().V1().TestTypes().Informer()}, nil

		// Group=example.test.crd.code-generator.k8s.io, Version=v1
	case example2v1.SchemeGroupVersion.WithResource("testtypes"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.SecondExample().V1().TestTypes().Informer()}, nil

		// Group=extensions.test.crd.code-generator.k8s.io, Version=v1
	case extensionsv1.SchemeGroupVersion.WithResource("testtypes"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.ExtensionsExample().V1().TestTypes().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
