﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock/model/AutomatedReasoningPolicyDefinition.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Bedrock {
namespace Model {

AutomatedReasoningPolicyDefinition::AutomatedReasoningPolicyDefinition(JsonView jsonValue) { *this = jsonValue; }

AutomatedReasoningPolicyDefinition& AutomatedReasoningPolicyDefinition::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("version")) {
    m_version = jsonValue.GetString("version");
    m_versionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("types")) {
    Aws::Utils::Array<JsonView> typesJsonList = jsonValue.GetArray("types");
    for (unsigned typesIndex = 0; typesIndex < typesJsonList.GetLength(); ++typesIndex) {
      m_types.push_back(typesJsonList[typesIndex].AsObject());
    }
    m_typesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("rules")) {
    Aws::Utils::Array<JsonView> rulesJsonList = jsonValue.GetArray("rules");
    for (unsigned rulesIndex = 0; rulesIndex < rulesJsonList.GetLength(); ++rulesIndex) {
      m_rules.push_back(rulesJsonList[rulesIndex].AsObject());
    }
    m_rulesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("variables")) {
    Aws::Utils::Array<JsonView> variablesJsonList = jsonValue.GetArray("variables");
    for (unsigned variablesIndex = 0; variablesIndex < variablesJsonList.GetLength(); ++variablesIndex) {
      m_variables.push_back(variablesJsonList[variablesIndex].AsObject());
    }
    m_variablesHasBeenSet = true;
  }
  return *this;
}

JsonValue AutomatedReasoningPolicyDefinition::Jsonize() const {
  JsonValue payload;

  if (m_versionHasBeenSet) {
    payload.WithString("version", m_version);
  }

  if (m_typesHasBeenSet) {
    Aws::Utils::Array<JsonValue> typesJsonList(m_types.size());
    for (unsigned typesIndex = 0; typesIndex < typesJsonList.GetLength(); ++typesIndex) {
      typesJsonList[typesIndex].AsObject(m_types[typesIndex].Jsonize());
    }
    payload.WithArray("types", std::move(typesJsonList));
  }

  if (m_rulesHasBeenSet) {
    Aws::Utils::Array<JsonValue> rulesJsonList(m_rules.size());
    for (unsigned rulesIndex = 0; rulesIndex < rulesJsonList.GetLength(); ++rulesIndex) {
      rulesJsonList[rulesIndex].AsObject(m_rules[rulesIndex].Jsonize());
    }
    payload.WithArray("rules", std::move(rulesJsonList));
  }

  if (m_variablesHasBeenSet) {
    Aws::Utils::Array<JsonValue> variablesJsonList(m_variables.size());
    for (unsigned variablesIndex = 0; variablesIndex < variablesJsonList.GetLength(); ++variablesIndex) {
      variablesJsonList[variablesIndex].AsObject(m_variables[variablesIndex].Jsonize());
    }
    payload.WithArray("variables", std::move(variablesJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
