/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.util.Collections;
import java.util.Set;
import org.minidns.MiniDnsException;
import org.minidns.dnssec.DnssecUnverifiedReason;

public final class DnssecResultNotAuthenticException
extends MiniDnsException {
    private static final long serialVersionUID = 1L;
    private final Set<DnssecUnverifiedReason> unverifiedReasons;

    private DnssecResultNotAuthenticException(String message, Set<DnssecUnverifiedReason> unverifiedReasons) {
        super(message);
        if (unverifiedReasons.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.unverifiedReasons = Collections.unmodifiableSet(unverifiedReasons);
    }

    public static DnssecResultNotAuthenticException from(Set<DnssecUnverifiedReason> unverifiedReasons) {
        StringBuilder sb = new StringBuilder();
        sb.append("DNSSEC result not authentic. Reasons: ");
        for (DnssecUnverifiedReason reason : unverifiedReasons) {
            sb.append(reason).append('.');
        }
        return new DnssecResultNotAuthenticException(sb.toString(), unverifiedReasons);
    }

    public Set<DnssecUnverifiedReason> getUnverifiedReasons() {
        return this.unverifiedReasons;
    }
}

