/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam.element;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.mam.element.MamVersion;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class MamQueryIQ
extends IQ {
    public static final String ELEMENT = "query";
    private final String queryId;
    private final String node;
    private final DataForm dataForm;

    public MamQueryIQ(MamVersion version, String queryId) {
        this(version, queryId, null, null);
        this.setType(IQ.Type.get);
    }

    public MamQueryIQ(MamVersion version, DataForm form) {
        this(version, null, null, form);
    }

    public MamQueryIQ(MamVersion version, String queryId, DataForm form) {
        this(version, queryId, null, form);
    }

    public MamQueryIQ(MamVersion version, String queryId, String node, DataForm dataForm) {
        super(ELEMENT, version.getNamespace());
        this.queryId = queryId;
        this.node = node;
        this.dataForm = dataForm;
        if (dataForm != null) {
            String formType = dataForm.getFormType();
            if (formType == null) {
                throw new IllegalArgumentException("If a data form is given it must posses a hidden form type field");
            }
            if (!formType.equals(version.getNamespace())) {
                throw new IllegalArgumentException("Value of the hidden form type field must be '" + version.getNamespace() + "'");
            }
            this.addExtension(dataForm);
        }
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getNode() {
        return this.node;
    }

    public DataForm getDataForm() {
        return this.dataForm;
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.optAttribute("queryid", this.queryId);
        xml.optAttribute("node", this.node);
        xml.rightAngleBracket();
        return xml;
    }
}

