/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	corev1 "kubevirt.io/api/core/v1"
	scheme "kubevirt.io/client-go/kubevirt/scheme"
)

// VirtualMachinesGetter has a method to return a VirtualMachineInterface.
// A group's client should implement this interface.
type VirtualMachinesGetter interface {
	VirtualMachines(namespace string) VirtualMachineInterface
}

// VirtualMachineInterface has methods to work with VirtualMachine resources.
type VirtualMachineInterface interface {
	Create(ctx context.Context, virtualMachine *corev1.VirtualMachine, opts metav1.CreateOptions) (*corev1.VirtualMachine, error)
	Update(ctx context.Context, virtualMachine *corev1.VirtualMachine, opts metav1.UpdateOptions) (*corev1.VirtualMachine, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, virtualMachine *corev1.VirtualMachine, opts metav1.UpdateOptions) (*corev1.VirtualMachine, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*corev1.VirtualMachine, error)
	List(ctx context.Context, opts metav1.ListOptions) (*corev1.VirtualMachineList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *corev1.VirtualMachine, err error)
	VirtualMachineExpansion
}

// virtualMachines implements VirtualMachineInterface
type virtualMachines struct {
	*gentype.ClientWithList[*corev1.VirtualMachine, *corev1.VirtualMachineList]
}

// newVirtualMachines returns a VirtualMachines
func newVirtualMachines(c *KubevirtV1Client, namespace string) *virtualMachines {
	return &virtualMachines{
		gentype.NewClientWithList[*corev1.VirtualMachine, *corev1.VirtualMachineList](
			"virtualmachines",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *corev1.VirtualMachine { return &corev1.VirtualMachine{} },
			func() *corev1.VirtualMachineList { return &corev1.VirtualMachineList{} },
		),
	}
}
