/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	v1 "kubevirt.io/api/core/v1"
	corev1 "kubevirt.io/client-go/kubevirt/typed/core/v1"
)

// fakeVirtualMachineInstances implements VirtualMachineInstanceInterface
type fakeVirtualMachineInstances struct {
	*gentype.FakeClientWithList[*v1.VirtualMachineInstance, *v1.VirtualMachineInstanceList]
	Fake *FakeKubevirtV1
}

func newFakeVirtualMachineInstances(fake *FakeKubevirtV1, namespace string) corev1.VirtualMachineInstanceInterface {
	return &fakeVirtualMachineInstances{
		gentype.NewFakeClientWithList[*v1.VirtualMachineInstance, *v1.VirtualMachineInstanceList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("virtualmachineinstances"),
			v1.SchemeGroupVersion.WithKind("VirtualMachineInstance"),
			func() *v1.VirtualMachineInstance { return &v1.VirtualMachineInstance{} },
			func() *v1.VirtualMachineInstanceList { return &v1.VirtualMachineInstanceList{} },
			func(dst, src *v1.VirtualMachineInstanceList) { dst.ListMeta = src.ListMeta },
			func(list *v1.VirtualMachineInstanceList) []*v1.VirtualMachineInstance {
				return gentype.ToPointerSlice(list.Items)
			},
			func(list *v1.VirtualMachineInstanceList, items []*v1.VirtualMachineInstance) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
