/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.net.URI;
import java.util.Optional;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.KeyScope;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class ConkeyrefFilter
extends AbstractXMLFilter {
    private KeyScope keys;

    public void setKeyDefinitions(KeyScope keys) {
        this.keys = keys;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        Attributes resAtts = null;
        String conkeyref = atts.getValue("conkeyref");
        if (conkeyref != null) {
            int keyIndex = conkeyref.indexOf("/");
            String key = keyIndex != -1 ? conkeyref.substring(0, keyIndex) : conkeyref;
            KeyDef keyDef = this.keys.get(key);
            if (keyDef != null) {
                String id = keyIndex != -1 ? conkeyref.substring(keyIndex + 1) : null;
                resAtts = new AttributesImpl(atts);
                XMLUtils.removeAttribute((AttributesImpl)resAtts, "conkeyref");
                KeyDef k = this.keys.get(key);
                if (k.href != null && k.scope.equals("local")) {
                    URI target = this.getRelativePath(keyDef.source, k.href);
                    String keyFragment = k.href.getFragment();
                    if (id != null && keyFragment != null) {
                        target = URLUtils.setFragment(target, keyFragment + "/" + id);
                    } else if (id != null) {
                        target = URLUtils.setFragment(target, id);
                    } else if (keyFragment != null) {
                        target = URLUtils.setFragment(target, keyFragment);
                    }
                    XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, "conref", target.toString());
                } else {
                    this.logger.warn(MessageUtils.getMessage("DOTJ060W", key, conkeyref).setLocation(atts).toString());
                }
            } else {
                this.logger.error(MessageUtils.getMessage("DOTJ046E", conkeyref).setLocation(atts).toString());
            }
        }
        this.getContentHandler().startElement(uri, localName, name, resAtts != null ? resAtts : atts);
    }

    private URI getRelativePath(URI keyMap, URI href) {
        URI keyValue;
        URI inputMap = Optional.ofNullable(this.job.getFileInfo(keyMap)).map(fi -> fi.uri).orElse(null);
        if (inputMap != null) {
            URI tmpMap = this.job.tempDirURI.resolve(inputMap);
            keyValue = tmpMap.resolve(URLUtils.stripFragment(href));
        } else {
            keyValue = this.job.tempDirURI.resolve(URLUtils.stripFragment(href));
        }
        return URLUtils.getRelativePath(this.currentFile, keyValue);
    }
}

