/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.store;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.lib.EmptySource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.UncheckedXPathException;
import org.apache.commons.io.FileUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.store.AbstractStore;
import org.dita.dost.store.Store;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class StreamStore
extends AbstractStore
implements Store {
    public StreamStore(File tempDir, XMLUtils xmlUtils) {
        super(tempDir, xmlUtils);
    }

    @Override
    public Document getImmutableDocument(URI path) throws IOException {
        return this.getDocument(path);
    }

    @Override
    public XdmNode getImmutableNode(URI path) throws IOException {
        try {
            return this.xmlUtils.getProcessor().newDocumentBuilder().build((Source)new StreamSource(path.toString()));
        }
        catch (SaxonApiException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Document getDocument(URI path) throws IOException {
        try {
            return this.xmlUtils.getDocumentBuilder().parse(path.toString());
        }
        catch (Exception e) {
            throw new IOException("Failed to read document: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(URI file) throws IOException {
        URI f = this.getUri(file.normalize());
        if ("file".equals(f.getScheme())) {
            File ff = new File(this.getUri(f.isAbsolute() ? f : this.tempDirUri.resolve(f)));
            if (ff.exists() && !ff.delete()) {
                throw new IOException("Deleting " + String.valueOf(file) + " failed");
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void writeDocument(Document doc, URI dst) throws IOException {
        XdmNode source = this.xmlUtils.getProcessor().newDocumentBuilder().wrap((Object)doc);
        this.writeDocument(source, dst);
    }

    @Override
    public void writeDocument(XdmNode node, URI dst) throws IOException {
        Serializer serializer = null;
        try {
            serializer = this.getSerializer(dst);
            serializer.serializeNode(node);
        }
        catch (SaxonApiException e) {
            throw new IOException(e);
        }
        finally {
            try {
                serializer.close();
            }
            catch (SaxonApiException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void writeDocument(Node doc, ContentHandler dst) throws IOException {
        XdmNode source = this.xmlUtils.getProcessor().newDocumentBuilder().wrap((Object)doc);
        this.writeDocument(source, dst);
    }

    @Override
    public void writeDocument(XdmNode source, ContentHandler dst) throws IOException {
        try {
            SAXDestination destination = new SAXDestination(dst);
            this.xmlUtils.getProcessor().writeXdmValue((XdmValue)source, (Destination)destination);
        }
        catch (SaxonApiException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void transform(URI input, ContentHandler contentHandler) throws DITAOTException {
        assert (input.isAbsolute());
        if (!input.getScheme().equals("file")) {
            throw new IllegalArgumentException("Only file URI scheme supported: " + String.valueOf(input));
        }
        try {
            XMLReader xmlReader = XMLUtils.getXMLReader();
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(input.toString());
        }
        catch (IOException | SAXException e) {
            throw new DITAOTException(e);
        }
    }

    @Override
    void transformURI(URI input, URI output, List<XMLFilter> filters) throws DITAOTException {
        if (!this.exists(input)) {
            return;
        }
        Serializer result = null;
        try {
            StreamStore streamStore = this;
            XMLReader reader = streamStore.xmlUtils.getXMLReader();
            for (XMLFilter filter : filters) {
                filter.setContentHandler(null);
                filter.setParent(reader);
                reader = filter;
            }
            result = this.getSerializer(output);
            ContentHandler serializer = result.getContentHandler();
            reader.setContentHandler(serializer);
            InputSource inputSource = new InputSource(input.toString());
            reader.parse(inputSource);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to transform " + String.valueOf(input) + ": " + e.getMessage(), e);
        }
        finally {
            try {
                result.close();
            }
            catch (SaxonApiException e) {
                throw new DITAOTException("Failed to transform " + String.valueOf(input) + ": " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void transform(URI input, URI output, XsltTransformer transformer) throws DITAOTException {
        URI dst;
        URI src = input.normalize();
        if (src.equals(dst = output.normalize())) {
            this.transform(src, transformer);
        } else {
            this.transformUri(src, dst, transformer);
        }
    }

    @Override
    public void transform(URI src, XsltTransformer transformer) throws DITAOTException {
        if (!this.exists(src)) {
            return;
        }
        URI dst = URLUtils.toURI(src.toString() + ".temp").normalize();
        this.transformUri(src, dst, transformer);
        try {
            this.move(dst, src);
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to replace " + String.valueOf(src) + ": " + e.getMessage());
        }
    }

    @Override
    void transformUri(URI src, URI dst, XsltTransformer transformer) throws DITAOTException {
        if (!this.exists(src)) {
            return;
        }
        Destination result = null;
        try {
            Source source = this.getSource(src);
            transformer.setSource(source);
            result = this.getDestination(dst);
            transformer.setDestination(result);
            transformer.transform();
        }
        catch (UncheckedXPathException e) {
            throw new DITAOTException("Failed to transform document", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to transform document: " + e.getMessage(), e);
        }
        finally {
            try {
                result.close();
            }
            catch (SaxonApiException e) {
                throw new DITAOTException("Failed to transform document", e);
            }
        }
    }

    @VisibleForTesting
    Serializer getSerializer(URI dst) throws IOException {
        File outputFile = new File(dst);
        File dir = outputFile.getParentFile();
        if (!dir.exists()) {
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        return this.xmlUtils.getProcessor().newSerializer(outputFile);
    }

    @Override
    public Source getSource(URI path) {
        URI f = this.getUri(path);
        if (this.isTempFile(f)) {
            if (this.exists(f)) {
                StreamSource s = new StreamSource(f.toString());
                s.setSystemId(f.toString());
                return s;
            }
            return EmptySource.getInstance();
        }
        return new StreamSource(path.toString());
    }

    @Override
    public Destination getDestination(URI path) throws IOException {
        return this.getSerializer(path);
    }

    @Override
    public ContentHandler getContentHandler(URI outputFile) throws SaxonApiException, IOException {
        Configuration configuration = this.xmlUtils.getProcessor().getUnderlyingConfiguration();
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        Destination dst = this.getDestination(outputFile);
        Receiver receiver = dst.getReceiver(pipelineConfiguration, new SerializationProperties());
        ReceivingContentHandler receivingContentHandler = new ReceivingContentHandler();
        receivingContentHandler.setPipelineConfiguration(pipelineConfiguration);
        receivingContentHandler.setReceiver(receiver);
        return receivingContentHandler;
    }

    @Override
    public void copy(URI src, URI dst) throws IOException {
        if (!Objects.equals(src.getScheme(), "file") || !Objects.equals(dst.getScheme(), "file")) {
            throw new IOException(String.format("Unable to copy non-file resource %s to %s", src, dst));
        }
        File s = new File(this.getUri((src.isAbsolute() ? src : this.tempDirUri.resolve(src)).normalize()));
        File d = new File(this.getUri((dst.isAbsolute() ? dst : this.tempDirUri.resolve(dst)).normalize()));
        FileUtils.copyFile((File)s, (File)d);
    }

    @Override
    public void move(URI src, URI dst) throws IOException {
        File d;
        File s;
        if (Objects.equals(src.getScheme(), "file") && Objects.equals(dst.getScheme(), "file")) {
            s = new File(this.getUri((src.isAbsolute() ? src : this.tempDirUri.resolve(src)).normalize()));
            d = new File(this.getUri((dst.isAbsolute() ? dst : this.tempDirUri.resolve(dst)).normalize()));
            if (d.exists()) {
                FileUtils.forceDelete((File)d);
            }
        } else {
            throw new IOException(String.format("Unable to move non-file resource %s to %s", src, dst));
        }
        FileUtils.moveFile((File)s, (File)d);
    }

    @Override
    public boolean exists(URI path) {
        if (Objects.equals(path.getScheme(), "file")) {
            File d = new File(this.getUri(URLUtils.setFragment(path, null)));
            return d.exists();
        }
        return false;
    }

    @Override
    public long getLastModified(URI path) {
        if (Objects.equals(path.getScheme(), "file")) {
            File d = new File(this.getUri(URLUtils.setFragment(path, null)));
            return d.lastModified();
        }
        return -1L;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        URI f;
        URI h = URLUtils.toURI(href);
        URI uRI = f = h.isAbsolute() ? h : URLUtils.toURI(base).resolve(h);
        if (this.isTempFile(f)) {
            if (this.exists(f)) {
                return new StreamSource(f.toString());
            }
            return EmptySource.getInstance();
        }
        return null;
    }

    @Override
    public InputStream getInputStream(URI path) throws IOException {
        URI f = this.getUri(path);
        if (this.isTempFile(f)) {
            return new FileInputStream(URLUtils.toFile(f));
        }
        if ("file".equals(path.getScheme())) {
            return new FileInputStream(URLUtils.toFile(path));
        }
        return f.toURL().openStream();
    }

    @Override
    public OutputStream getOutputStream(URI path) throws IOException {
        URI f = this.getUri(path);
        if (this.isTempFile(f)) {
            return Files.newOutputStream(Paths.get(f), new OpenOption[0]);
        }
        if ("file".equals(path.getScheme())) {
            return Files.newOutputStream(Paths.get(path), new OpenOption[0]);
        }
        throw new UnsupportedOperationException("Unable to write to " + String.valueOf(f));
    }
}

