/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IHelpContextIdProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.IDialogPageContainer;
import org.jkiss.dbeaver.ui.editors.object.struct.EditObjectDialog;

public abstract class BaseObjectEditPage
extends DialogPage {
    private IDialogPageContainer container;

    public BaseObjectEditPage(String title) {
        super(title);
    }

    public BaseObjectEditPage(String title, DBIcon icon) {
        super(title, DBeaverIcons.getImageDescriptor((DBPImage)icon));
    }

    public abstract DBSObject getObject();

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        if (this.container != null) {
            this.container.updateMessage();
        }
    }

    protected String getEditError() {
        return null;
    }

    public final void validateProperties() {
        this.setErrorMessage(this.getEditError());
    }

    public void performHelp() {
        IWorkbenchHelpSystem helpSystem;
        if (this instanceof IHelpContextIdProvider && (helpSystem = UIUtils.getActiveWorkbenchWindow().getWorkbench().getHelpSystem()) != null) {
            final String helpContextId = ((IHelpContextIdProvider)this).getHelpContextId();
            IContext helpContext = new IContext(){

                public IHelpResource[] getRelatedTopics() {
                    return new IHelpResource[]{new IHelpResource(){

                        public String getHref() {
                            return helpContextId;
                        }

                        public String getLabel() {
                            return helpContextId;
                        }
                    }};
                }

                public String getText() {
                    return helpContextId;
                }
            };
            helpSystem.displayHelp(helpContext);
        }
    }

    public void createControl(Composite parent) {
        Control pageContents = this.createPageContents(parent);
        this.setControl(pageContents);
        pageContents.addHelpListener(e -> this.performHelp());
    }

    public boolean isPageComplete() {
        return true;
    }

    protected void updatePageState() {
        if (this.container != null) {
            UIUtils.asyncExec(() -> {
                this.container.updateMessage();
                this.container.updateButtons();
            });
        }
    }

    public void setContainer(IDialogPageContainer container) {
        this.container = container;
    }

    public void performFinish() throws DBException {
    }

    protected abstract Control createPageContents(Composite var1);

    public boolean edit() {
        return EditObjectDialog.showDialog((IDialogPage)this);
    }

    public boolean edit(Shell shell) {
        return EditObjectDialog.showDialog(shell, (IDialogPage)this);
    }
}

