/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.preferences;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageDashboards
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageDashboards.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.dashboards";
    private Button openSeparateConnectionCheck;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("dashboard.openSeparateConnection");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group commonGroup = UIUtils.createControlGroup((Composite)composite, (String)UIDashboardMessages.pref_page_dashboards_group_common, (int)2, (int)770, (int)0);
        this.openSeparateConnectionCheck = UIUtils.createCheckbox((Composite)commonGroup, (String)UIDashboardMessages.pref_page_dashboards_open_separate_connection_label, null, (boolean)false, (int)2);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.openSeparateConnectionCheck.setSelection(store.getBoolean("dashboard.openSeparateConnection"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("dashboard.openSeparateConnection", this.openSeparateConnectionCheck.getText());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("dashboard.openSeparateConnection");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

