/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.AddAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.ExcludeAllEntriesTransformation;
import com.unboundid.ldap.sdk.transformations.ExcludeAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.ExcludeChangeTypeTransformation;
import com.unboundid.ldap.sdk.transformations.ExcludeEntryTransformation;
import com.unboundid.ldap.sdk.transformations.FlattenSubtreeTransformation;
import com.unboundid.ldap.sdk.transformations.MoveSubtreeTransformation;
import com.unboundid.ldap.sdk.transformations.PreEncodedLDIFEntry;
import com.unboundid.ldap.sdk.transformations.RedactAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.RenameAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.ReplaceAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.ReplaceWithCounterTransformation;
import com.unboundid.ldap.sdk.transformations.ScrambleAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.TransformationMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReaderChangeRecordTranslator;
import com.unboundid.ldif.LDIFReaderEntryTranslator;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class TransformLDIF
extends CommandLineTool
implements LDIFReaderEntryTranslator {
    private static final int MAX_OUTPUT_LINE_LENGTH = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @Nullable
    private BooleanArgument addToExistingValues = null;
    @Nullable
    private BooleanArgument appendToTargetLDIF = null;
    @Nullable
    private BooleanArgument compressTarget = null;
    @Nullable
    private BooleanArgument encryptTarget = null;
    @Nullable
    private BooleanArgument excludeRecordsWithoutChangeType = null;
    @Nullable
    private BooleanArgument excludeNonMatchingEntries = null;
    @Nullable
    private BooleanArgument flattenAddOmittedRDNAttributesToEntry = null;
    @Nullable
    private BooleanArgument flattenAddOmittedRDNAttributesToRDN = null;
    @Nullable
    private BooleanArgument hideRedactedValueCount = null;
    @Nullable
    private BooleanArgument processDNs = null;
    @Nullable
    private BooleanArgument sourceCompressed = null;
    @Nullable
    private BooleanArgument sourceContainsChangeRecords = null;
    @Nullable
    private BooleanArgument sourceFromStandardInput = null;
    @Nullable
    private BooleanArgument targetToStandardOutput = null;
    @Nullable
    private DNArgument addAttributeBaseDN = null;
    @Nullable
    private DNArgument excludeEntryBaseDN = null;
    @Nullable
    private DNArgument flattenBaseDN = null;
    @Nullable
    private DNArgument moveSubtreeFrom = null;
    @Nullable
    private DNArgument moveSubtreeTo = null;
    @Nullable
    private FileArgument encryptionPassphraseFile = null;
    @Nullable
    private FileArgument schemaPath = null;
    @Nullable
    private FileArgument sourceLDIF = null;
    @Nullable
    private FileArgument targetLDIF = null;
    @Nullable
    private FilterArgument addAttributeFilter = null;
    @Nullable
    private FilterArgument excludeEntryFilter = null;
    @Nullable
    private FilterArgument flattenExcludeFilter = null;
    @Nullable
    private IntegerArgument initialSequentialValue = null;
    @Nullable
    private IntegerArgument numThreads = null;
    @Nullable
    private IntegerArgument randomSeed = null;
    @Nullable
    private IntegerArgument sequentialValueIncrement = null;
    @Nullable
    private IntegerArgument wrapColumn = null;
    @Nullable
    private ScopeArgument addAttributeScope = null;
    @Nullable
    private ScopeArgument excludeEntryScope = null;
    @Nullable
    private StringArgument addAttributeName = null;
    @Nullable
    private StringArgument addAttributeValue = null;
    @Nullable
    private StringArgument excludeAttribute = null;
    @Nullable
    private StringArgument excludeChangeType = null;
    @Nullable
    private StringArgument redactAttribute = null;
    @Nullable
    private StringArgument renameAttributeFrom = null;
    @Nullable
    private StringArgument renameAttributeTo = null;
    @Nullable
    private StringArgument replaceValuesAttribute = null;
    @Nullable
    private StringArgument replacementValue = null;
    @Nullable
    private StringArgument scrambleAttribute = null;
    @Nullable
    private StringArgument scrambleJSONField = null;
    @Nullable
    private StringArgument sequentialAttribute = null;
    @Nullable
    private StringArgument textAfterSequentialValue = null;
    @Nullable
    private StringArgument textBeforeSequentialValue = null;
    @NotNull
    private final ThreadLocal<ByteStringBuffer> byteStringBuffers = new ThreadLocal();

    public static void main(String ... args) {
        ResultCode resultCode = TransformLDIF.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        TransformLDIF tool = new TransformLDIF(out, err);
        return tool.runTool(args);
    }

    public TransformLDIF(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "transform-ldif";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return TransformationMessages.INFO_TRANSFORM_LDIF_TOOL_DESCRIPTION.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.8";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.sourceLDIF = new FileArgument(Character.valueOf('l'), "sourceLDIF", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_LDIF.get(), true, true, true, false);
        this.sourceLDIF.addLongIdentifier("inputLDIF", true);
        this.sourceLDIF.addLongIdentifier("source-ldif", true);
        this.sourceLDIF.addLongIdentifier("input-ldif", true);
        this.sourceLDIF.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.sourceLDIF);
        this.sourceFromStandardInput = new BooleanArgument(null, "sourceFromStandardInput", 1, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_STD_IN.get());
        this.sourceFromStandardInput.addLongIdentifier("source-from-standard-input", true);
        this.sourceFromStandardInput.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.sourceFromStandardInput);
        parser.addRequiredArgumentSet(this.sourceLDIF, this.sourceFromStandardInput, new Argument[0]);
        parser.addExclusiveArgumentSet(this.sourceLDIF, this.sourceFromStandardInput, new Argument[0]);
        this.targetLDIF = new FileArgument(Character.valueOf('o'), "targetLDIF", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_TARGET_LDIF.get(), false, true, true, false);
        this.targetLDIF.addLongIdentifier("outputLDIF", true);
        this.targetLDIF.addLongIdentifier("target-ldif", true);
        this.targetLDIF.addLongIdentifier("output-ldif", true);
        this.targetLDIF.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.targetLDIF);
        this.targetToStandardOutput = new BooleanArgument(null, "targetToStandardOutput", 1, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_TARGET_STD_OUT.get());
        this.targetToStandardOutput.addLongIdentifier("target-to-standard-output", true);
        this.targetToStandardOutput.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.targetToStandardOutput);
        parser.addExclusiveArgumentSet(this.targetLDIF, this.targetToStandardOutput, new Argument[0]);
        this.sourceContainsChangeRecords = new BooleanArgument(null, "sourceContainsChangeRecords", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_CONTAINS_CHANGE_RECORDS.get());
        this.sourceContainsChangeRecords.addLongIdentifier("source-contains-change-records", true);
        this.sourceContainsChangeRecords.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.sourceContainsChangeRecords);
        this.appendToTargetLDIF = new BooleanArgument(null, "appendToTargetLDIF", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_APPEND_TO_TARGET.get());
        this.appendToTargetLDIF.addLongIdentifier("append-to-target-ldif", true);
        this.appendToTargetLDIF.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.appendToTargetLDIF);
        parser.addExclusiveArgumentSet(this.targetToStandardOutput, this.appendToTargetLDIF, new Argument[0]);
        this.wrapColumn = new IntegerArgument(null, "wrapColumn", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_WRAP_COLUMN.get(), 5, Integer.MAX_VALUE);
        this.wrapColumn.addLongIdentifier("wrap-column", true);
        this.wrapColumn.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.wrapColumn);
        this.sourceCompressed = new BooleanArgument(Character.valueOf('C'), "sourceCompressed", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SOURCE_COMPRESSED.get());
        this.sourceCompressed.addLongIdentifier("inputCompressed", true);
        this.sourceCompressed.addLongIdentifier("source-compressed", true);
        this.sourceCompressed.addLongIdentifier("input-compressed", true);
        this.sourceCompressed.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.sourceCompressed);
        this.compressTarget = new BooleanArgument(Character.valueOf('c'), "compressTarget", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_COMPRESS_TARGET.get());
        this.compressTarget.addLongIdentifier("compressOutput", true);
        this.compressTarget.addLongIdentifier("compress", true);
        this.compressTarget.addLongIdentifier("compress-target", true);
        this.compressTarget.addLongIdentifier("compress-output", true);
        this.compressTarget.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.compressTarget);
        this.encryptTarget = new BooleanArgument(null, "encryptTarget", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ENCRYPT_TARGET.get());
        this.encryptTarget.addLongIdentifier("encryptOutput", true);
        this.encryptTarget.addLongIdentifier("encrypt", true);
        this.encryptTarget.addLongIdentifier("encrypt-target", true);
        this.encryptTarget.addLongIdentifier("encrypt-output", true);
        this.encryptTarget.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.encryptTarget);
        this.encryptionPassphraseFile = new FileArgument(null, "encryptionPassphraseFile", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ENCRYPTION_PW_FILE.get(), true, true, true, false);
        this.encryptionPassphraseFile.addLongIdentifier("encryptionPasswordFile", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-passphrase-file", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-password-file", true);
        this.encryptionPassphraseFile.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_LDIF.get());
        parser.addArgument(this.encryptionPassphraseFile);
        this.scrambleAttribute = new StringArgument(Character.valueOf('a'), "scrambleAttribute", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SCRAMBLE_ATTR.get());
        this.scrambleAttribute.addLongIdentifier("attributeName", true);
        this.scrambleAttribute.addLongIdentifier("scramble-attribute", true);
        this.scrambleAttribute.addLongIdentifier("attribute-name", true);
        this.scrambleAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SCRAMBLE.get());
        parser.addArgument(this.scrambleAttribute);
        this.scrambleJSONField = new StringArgument(null, "scrambleJSONField", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_FIELD_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SCRAMBLE_JSON_FIELD.get(this.scrambleAttribute.getIdentifierString()));
        this.scrambleJSONField.addLongIdentifier("scramble-json-field", true);
        this.scrambleJSONField.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SCRAMBLE.get());
        parser.addArgument(this.scrambleJSONField);
        parser.addDependentArgumentSet(this.scrambleJSONField, this.scrambleAttribute, new Argument[0]);
        this.randomSeed = new IntegerArgument(Character.valueOf('s'), "randomSeed", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_RANDOM_SEED.get());
        this.randomSeed.addLongIdentifier("random-seed", true);
        this.randomSeed.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SCRAMBLE.get());
        parser.addArgument(this.randomSeed);
        this.sequentialAttribute = new StringArgument(Character.valueOf('S'), "sequentialAttribute", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_ATTR.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.sequentialAttribute.addLongIdentifier("sequentialAttributeName", true);
        this.sequentialAttribute.addLongIdentifier("sequential-attribute", true);
        this.sequentialAttribute.addLongIdentifier("sequential-attribute-name", true);
        this.sequentialAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.sequentialAttribute);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.sequentialAttribute, new Argument[0]);
        this.initialSequentialValue = new IntegerArgument(Character.valueOf('i'), "initialSequentialValue", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_INITIAL_SEQUENTIAL_VALUE.get(this.sequentialAttribute.getIdentifierString()));
        this.initialSequentialValue.addLongIdentifier("initial-sequential-value", true);
        this.initialSequentialValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.initialSequentialValue);
        parser.addDependentArgumentSet(this.initialSequentialValue, this.sequentialAttribute, new Argument[0]);
        this.sequentialValueIncrement = new IntegerArgument(null, "sequentialValueIncrement", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_INCREMENT.get(this.sequentialAttribute.getIdentifierString()));
        this.sequentialValueIncrement.addLongIdentifier("sequential-value-increment", true);
        this.sequentialValueIncrement.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.sequentialValueIncrement);
        parser.addDependentArgumentSet(this.sequentialValueIncrement, this.sequentialAttribute, new Argument[0]);
        this.textBeforeSequentialValue = new StringArgument(null, "textBeforeSequentialValue", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_TEXT_BEFORE.get(this.sequentialAttribute.getIdentifierString()));
        this.textBeforeSequentialValue.addLongIdentifier("text-before-sequential-value", true);
        this.textBeforeSequentialValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.textBeforeSequentialValue);
        parser.addDependentArgumentSet(this.textBeforeSequentialValue, this.sequentialAttribute, new Argument[0]);
        this.textAfterSequentialValue = new StringArgument(null, "textAfterSequentialValue", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SEQUENTIAL_TEXT_AFTER.get(this.sequentialAttribute.getIdentifierString()));
        this.textAfterSequentialValue.addLongIdentifier("text-after-sequential-value", true);
        this.textAfterSequentialValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_SEQUENTIAL.get());
        parser.addArgument(this.textAfterSequentialValue);
        parser.addDependentArgumentSet(this.textAfterSequentialValue, this.sequentialAttribute, new Argument[0]);
        this.replaceValuesAttribute = new StringArgument(null, "replaceValuesAttribute", false, 1, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_REPLACE_VALUES_ATTR.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.replaceValuesAttribute.addLongIdentifier("replace-values-attribute", true);
        this.replaceValuesAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_REPLACE_VALUES.get());
        parser.addArgument(this.replaceValuesAttribute);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.replaceValuesAttribute, new Argument[0]);
        this.replacementValue = new StringArgument(null, "replacementValue", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_REPLACEMENT_VALUE.get(this.replaceValuesAttribute.getIdentifierString()));
        this.replacementValue.addLongIdentifier("replacement-value", true);
        this.replacementValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_REPLACE_VALUES.get());
        parser.addArgument(this.replacementValue);
        parser.addDependentArgumentSet(this.replaceValuesAttribute, this.replacementValue, new Argument[0]);
        parser.addDependentArgumentSet(this.replacementValue, this.replaceValuesAttribute, new Argument[0]);
        this.addAttributeName = new StringArgument(null, "addAttributeName", false, 1, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_ATTR.get("--addAttributeValue", this.sourceContainsChangeRecords.getIdentifierString()));
        this.addAttributeName.addLongIdentifier("add-attribute-name", true);
        this.addAttributeName.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeName);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.addAttributeName, new Argument[0]);
        this.addAttributeValue = new StringArgument(null, "addAttributeValue", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_VALUE.get(this.addAttributeName.getIdentifierString()));
        this.addAttributeValue.addLongIdentifier("add-attribute-value", true);
        this.addAttributeValue.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeValue);
        parser.addDependentArgumentSet(this.addAttributeName, this.addAttributeValue, new Argument[0]);
        parser.addDependentArgumentSet(this.addAttributeValue, this.addAttributeName, new Argument[0]);
        this.addToExistingValues = new BooleanArgument(null, "addToExistingValues", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_MERGE_VALUES.get(this.addAttributeName.getIdentifierString(), this.addAttributeValue.getIdentifierString()));
        this.addToExistingValues.addLongIdentifier("add-to-existing-values", true);
        this.addToExistingValues.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addToExistingValues);
        parser.addDependentArgumentSet(this.addToExistingValues, this.addAttributeName, new Argument[0]);
        this.addAttributeBaseDN = new DNArgument(null, "addAttributeBaseDN", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_BASE_DN.get(this.addAttributeName.getIdentifierString()));
        this.addAttributeBaseDN.addLongIdentifier("add-attribute-base-dn", true);
        this.addAttributeBaseDN.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeBaseDN);
        parser.addDependentArgumentSet(this.addAttributeBaseDN, this.addAttributeName, new Argument[0]);
        this.addAttributeScope = new ScopeArgument(null, "addAttributeScope", false, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_SCOPE.get(this.addAttributeBaseDN.getIdentifierString(), this.addAttributeName.getIdentifierString()));
        this.addAttributeScope.addLongIdentifier("add-attribute-scope", true);
        this.addAttributeScope.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeScope);
        parser.addDependentArgumentSet(this.addAttributeScope, this.addAttributeName, new Argument[0]);
        this.addAttributeFilter = new FilterArgument(null, "addAttributeFilter", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_ADD_FILTER.get(this.addAttributeName.getIdentifierString()));
        this.addAttributeFilter.addLongIdentifier("add-attribute-filter", true);
        this.addAttributeFilter.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_ADD_ATTR.get());
        parser.addArgument(this.addAttributeFilter);
        parser.addDependentArgumentSet(this.addAttributeFilter, this.addAttributeName, new Argument[0]);
        this.renameAttributeFrom = new StringArgument(null, "renameAttributeFrom", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_RENAME_FROM.get());
        this.renameAttributeFrom.addLongIdentifier("rename-attribute-from", true);
        this.renameAttributeFrom.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_RENAME.get());
        parser.addArgument(this.renameAttributeFrom);
        this.renameAttributeTo = new StringArgument(null, "renameAttributeTo", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_RENAME_TO.get(this.renameAttributeFrom.getIdentifierString()));
        this.renameAttributeTo.addLongIdentifier("rename-attribute-to", true);
        this.renameAttributeTo.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_RENAME.get());
        parser.addArgument(this.renameAttributeTo);
        parser.addDependentArgumentSet(this.renameAttributeFrom, this.renameAttributeTo, new Argument[0]);
        parser.addDependentArgumentSet(this.renameAttributeTo, this.renameAttributeFrom, new Argument[0]);
        this.flattenBaseDN = new DNArgument(null, "flattenBaseDN", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_BASE_DN.get());
        this.flattenBaseDN.addLongIdentifier("flatten-base-dn", true);
        this.flattenBaseDN.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_FLATTEN.get());
        parser.addArgument(this.flattenBaseDN);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.flattenBaseDN, new Argument[0]);
        this.flattenAddOmittedRDNAttributesToEntry = new BooleanArgument(null, "flattenAddOmittedRDNAttributesToEntry", 1, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_ADD_OMITTED_TO_ENTRY.get());
        this.flattenAddOmittedRDNAttributesToEntry.addLongIdentifier("flatten-add-omitted-rdn-attributes-to-entry", true);
        this.flattenAddOmittedRDNAttributesToEntry.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_FLATTEN.get());
        parser.addArgument(this.flattenAddOmittedRDNAttributesToEntry);
        parser.addDependentArgumentSet(this.flattenAddOmittedRDNAttributesToEntry, this.flattenBaseDN, new Argument[0]);
        this.flattenAddOmittedRDNAttributesToRDN = new BooleanArgument(null, "flattenAddOmittedRDNAttributesToRDN", 1, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_ADD_OMITTED_TO_RDN.get());
        this.flattenAddOmittedRDNAttributesToRDN.addLongIdentifier("flatten-add-omitted-rdn-attributes-to-rdn", true);
        this.flattenAddOmittedRDNAttributesToRDN.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_FLATTEN.get());
        parser.addArgument(this.flattenAddOmittedRDNAttributesToRDN);
        parser.addDependentArgumentSet(this.flattenAddOmittedRDNAttributesToRDN, this.flattenBaseDN, new Argument[0]);
        this.flattenExcludeFilter = new FilterArgument(null, "flattenExcludeFilter", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_FLATTEN_EXCLUDE_FILTER.get());
        this.flattenExcludeFilter.addLongIdentifier("flatten-exclude-filter", true);
        this.flattenExcludeFilter.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_FLATTEN.get());
        parser.addArgument(this.flattenExcludeFilter);
        parser.addDependentArgumentSet(this.flattenExcludeFilter, this.flattenBaseDN, new Argument[0]);
        this.moveSubtreeFrom = new DNArgument(null, "moveSubtreeFrom", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_MOVE_SUBTREE_FROM.get());
        this.moveSubtreeFrom.addLongIdentifier("move-subtree-from", true);
        this.moveSubtreeFrom.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_MOVE.get());
        parser.addArgument(this.moveSubtreeFrom);
        this.moveSubtreeTo = new DNArgument(null, "moveSubtreeTo", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_MOVE_SUBTREE_TO.get(this.moveSubtreeFrom.getIdentifierString()));
        this.moveSubtreeTo.addLongIdentifier("move-subtree-to", true);
        this.moveSubtreeTo.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_MOVE.get());
        parser.addArgument(this.moveSubtreeTo);
        parser.addDependentArgumentSet(this.moveSubtreeFrom, this.moveSubtreeTo, new Argument[0]);
        parser.addDependentArgumentSet(this.moveSubtreeTo, this.moveSubtreeFrom, new Argument[0]);
        this.redactAttribute = new StringArgument(null, "redactAttribute", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_REDACT_ATTR.get());
        this.redactAttribute.addLongIdentifier("redact-attribute", true);
        this.redactAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_REDACT.get());
        parser.addArgument(this.redactAttribute);
        this.hideRedactedValueCount = new BooleanArgument(null, "hideRedactedValueCount", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_HIDE_REDACTED_COUNT.get());
        this.hideRedactedValueCount.addLongIdentifier("hide-redacted-value-count", true);
        this.hideRedactedValueCount.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_REDACT.get());
        parser.addArgument(this.hideRedactedValueCount);
        parser.addDependentArgumentSet(this.hideRedactedValueCount, this.redactAttribute, new Argument[0]);
        this.excludeAttribute = new StringArgument(null, "excludeAttribute", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_ATTR_NAME.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ATTR.get());
        this.excludeAttribute.addLongIdentifier("suppressAttribute", true);
        this.excludeAttribute.addLongIdentifier("exclude-attribute", true);
        this.excludeAttribute.addLongIdentifier("suppress-attribute", true);
        this.excludeAttribute.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeAttribute);
        this.excludeEntryBaseDN = new DNArgument(null, "excludeEntryBaseDN", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ENTRY_BASE_DN.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.excludeEntryBaseDN.addLongIdentifier("suppressEntryBaseDN", true);
        this.excludeEntryBaseDN.addLongIdentifier("exclude-entry-base-dn", true);
        this.excludeEntryBaseDN.addLongIdentifier("suppress-entry-base-dn", true);
        this.excludeEntryBaseDN.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeEntryBaseDN);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.excludeEntryBaseDN, new Argument[0]);
        this.excludeEntryScope = new ScopeArgument(null, "excludeEntryScope", false, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ENTRY_SCOPE.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.excludeEntryScope.addLongIdentifier("suppressEntryScope", true);
        this.excludeEntryScope.addLongIdentifier("exclude-entry-scope", true);
        this.excludeEntryScope.addLongIdentifier("suppress-entry-scope", true);
        this.excludeEntryScope.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeEntryScope);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.excludeEntryScope, new Argument[0]);
        this.excludeEntryFilter = new FilterArgument(null, "excludeEntryFilter", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_ENTRY_FILTER.get(this.sourceContainsChangeRecords.getIdentifierString()));
        this.excludeEntryFilter.addLongIdentifier("suppressEntryFilter", true);
        this.excludeEntryFilter.addLongIdentifier("exclude-entry-filter", true);
        this.excludeEntryFilter.addLongIdentifier("suppress-entry-filter", true);
        this.excludeEntryFilter.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeEntryFilter);
        parser.addExclusiveArgumentSet(this.sourceContainsChangeRecords, this.excludeEntryFilter, new Argument[0]);
        this.excludeNonMatchingEntries = new BooleanArgument(null, "excludeNonMatchingEntries", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_NON_MATCHING.get());
        this.excludeNonMatchingEntries.addLongIdentifier("exclude-non-matching-entries", true);
        this.excludeNonMatchingEntries.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeNonMatchingEntries);
        parser.addDependentArgumentSet(this.excludeNonMatchingEntries, this.excludeEntryBaseDN, this.excludeEntryScope, this.excludeEntryFilter);
        this.excludeChangeType = new StringArgument(null, "excludeChangeType", false, 0, TransformationMessages.INFO_TRANSFORM_LDIF_PLACEHOLDER_CHANGE_TYPES.get(), TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_EXCLUDE_CHANGE_TYPE.get(), StaticUtils.setOf("add", "delete", "modify", "moddn"));
        this.excludeChangeType.addLongIdentifier("exclude-change-type", true);
        this.excludeChangeType.addLongIdentifier("exclude-changetype", true);
        this.excludeChangeType.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeChangeType);
        this.excludeRecordsWithoutChangeType = new BooleanArgument(null, "excludeRecordsWithoutChangeType", 1, TransformationMessages.INFO_TRANSFORM_LDIF_EXCLUDE_WITHOUT_CHANGETYPE.get());
        this.excludeRecordsWithoutChangeType.addLongIdentifier("exclude-records-without-change-type", true);
        this.excludeRecordsWithoutChangeType.addLongIdentifier("exclude-records-without-changetype", true);
        this.excludeRecordsWithoutChangeType.setArgumentGroupName(TransformationMessages.INFO_TRANSFORM_LDIF_ARG_GROUP_EXCLUDE.get());
        parser.addArgument(this.excludeRecordsWithoutChangeType);
        this.schemaPath = new FileArgument(null, "schemaPath", false, 0, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_SCHEMA_PATH.get(), true, true, false, false);
        this.schemaPath.addLongIdentifier("schemaFile", true);
        this.schemaPath.addLongIdentifier("schemaDirectory", true);
        this.schemaPath.addLongIdentifier("schema-path", true);
        this.schemaPath.addLongIdentifier("schema-file", true);
        this.schemaPath.addLongIdentifier("schema-directory", true);
        parser.addArgument(this.schemaPath);
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", false, 1, null, TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_NUM_THREADS.get(), 1, Integer.MAX_VALUE, 1);
        this.numThreads.addLongIdentifier("num-threads", true);
        parser.addArgument(this.numThreads);
        this.processDNs = new BooleanArgument(Character.valueOf('d'), "processDNs", TransformationMessages.INFO_TRANSFORM_LDIF_ARG_DESC_PROCESS_DNS.get());
        this.processDNs.addLongIdentifier("process-dns", true);
        parser.addArgument(this.processDNs);
        parser.addRequiredArgumentSet(this.scrambleAttribute, this.sequentialAttribute, this.replaceValuesAttribute, this.addAttributeName, this.renameAttributeFrom, this.flattenBaseDN, this.moveSubtreeFrom, this.redactAttribute, this.excludeAttribute, this.excludeEntryBaseDN, this.excludeEntryScope, this.excludeEntryFilter, this.excludeChangeType, this.excludeRecordsWithoutChangeType);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        int moveToOccurrences;
        int renameToOccurrences;
        if (!(this.targetLDIF.isPresent() || this.targetToStandardOutput.isPresent() || this.scrambleAttribute.isPresent() || this.sequentialAttribute.isPresent())) {
            throw new ArgumentException(TransformationMessages.ERR_TRANSFORM_LDIF_MISSING_TARGET_ARG.get(this.targetLDIF.getIdentifierString(), this.targetToStandardOutput.getIdentifierString()));
        }
        int renameFromOccurrences = this.renameAttributeFrom.getNumOccurrences();
        if (renameFromOccurrences != (renameToOccurrences = this.renameAttributeTo.getNumOccurrences())) {
            throw new ArgumentException(TransformationMessages.ERR_TRANSFORM_LDIF_ARG_COUNT_MISMATCH.get(this.renameAttributeFrom.getIdentifierString(), this.renameAttributeTo.getIdentifierString()));
        }
        int moveFromOccurrences = this.moveSubtreeFrom.getNumOccurrences();
        if (moveFromOccurrences != (moveToOccurrences = this.moveSubtreeTo.getNumOccurrences())) {
            throw new ArgumentException(TransformationMessages.ERR_TRANSFORM_LDIF_ARG_COUNT_MISMATCH.get(this.moveSubtreeFrom.getIdentifierString(), this.moveSubtreeTo.getIdentifierString()));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 43[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private Schema getSchema() throws LDAPException {
        if (this.schemaPath.isPresent()) {
            ArrayList<File> schemaFiles = new ArrayList<File>(10);
            for (File path : this.schemaPath.getValues()) {
                if (path.isFile()) {
                    schemaFiles.add(path);
                    continue;
                }
                TreeMap<String, File> fileMap = new TreeMap<String, File>();
                for (File schemaDirFile : path.listFiles()) {
                    String name = schemaDirFile.getName();
                    if (!schemaDirFile.isFile() || !name.toLowerCase().endsWith(".ldif")) continue;
                    fileMap.put(name, schemaDirFile);
                }
                schemaFiles.addAll(fileMap.values());
            }
            if (schemaFiles.isEmpty()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, TransformationMessages.ERR_TRANSFORM_LDIF_NO_SCHEMA_FILES.get(this.schemaPath.getIdentifierString()));
            }
            try {
                return Schema.getSchema(schemaFiles);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, TransformationMessages.ERR_TRANSFORM_LDIF_ERROR_LOADING_SCHEMA.get(StaticUtils.getExceptionMessage(e)));
            }
        }
        try {
            File instanceRoot;
            File configDir;
            File schemaDir;
            String instanceRootStr = StaticUtils.getEnvironmentVariable("INSTANCE_ROOT");
            if (instanceRootStr != null && (schemaDir = new File(configDir = new File(instanceRoot = new File(instanceRootStr), "config"), "schema")).exists()) {
                TreeMap<String, File> fileMap = new TreeMap<String, File>();
                for (File schemaDirFile : schemaDir.listFiles()) {
                    String name = schemaDirFile.getName();
                    if (!schemaDirFile.isFile() || !name.toLowerCase().endsWith(".ldif")) continue;
                    fileMap.put(name, schemaDirFile);
                }
                if (!fileMap.isEmpty()) {
                    return Schema.getSchema(new ArrayList<File>(fileMap.values()));
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return null;
    }

    private void createTranslators(@NotNull List<LDIFReaderEntryTranslator> entryTranslators, @NotNull List<LDIFReaderChangeRecordTranslator> changeRecordTranslators, @Nullable Schema schema, @NotNull AtomicLong excludedEntryCount) {
        if (this.scrambleAttribute.isPresent()) {
            Long seed = this.randomSeed.isPresent() ? Long.valueOf(this.randomSeed.getValue().longValue()) : null;
            ScrambleAttributeTransformation t = new ScrambleAttributeTransformation(schema, seed, this.processDNs.isPresent(), this.scrambleAttribute.getValues(), this.scrambleJSONField.getValues());
            entryTranslators.add(t);
            changeRecordTranslators.add(t);
        }
        if (this.sequentialAttribute.isPresent()) {
            long initialValue = this.initialSequentialValue.isPresent() ? this.initialSequentialValue.getValue().longValue() : 0L;
            long incrementAmount = this.sequentialValueIncrement.isPresent() ? this.sequentialValueIncrement.getValue().longValue() : 1L;
            for (String attrName : this.sequentialAttribute.getValues()) {
                ReplaceWithCounterTransformation t = new ReplaceWithCounterTransformation(schema, attrName, initialValue, incrementAmount, this.textBeforeSequentialValue.getValue(), this.textAfterSequentialValue.getValue(), this.processDNs.isPresent());
                entryTranslators.add(t);
            }
        }
        if (this.replaceValuesAttribute.isPresent()) {
            ReplaceAttributeTransformation t = new ReplaceAttributeTransformation(schema, this.replaceValuesAttribute.getValue(), this.replacementValue.getValues());
            entryTranslators.add(t);
        }
        if (this.addAttributeName.isPresent()) {
            AddAttributeTransformation t = new AddAttributeTransformation(schema, this.addAttributeBaseDN.getValue(), this.addAttributeScope.getValue(), this.addAttributeFilter.getValue(), new Attribute(this.addAttributeName.getValue(), schema, this.addAttributeValue.getValues()), !this.addToExistingValues.isPresent());
            entryTranslators.add(t);
        }
        if (this.renameAttributeFrom.isPresent()) {
            Iterator<String> renameFromIterator = this.renameAttributeFrom.getValues().iterator();
            Iterator<String> renameToIterator = this.renameAttributeTo.getValues().iterator();
            while (renameFromIterator.hasNext()) {
                RenameAttributeTransformation t = new RenameAttributeTransformation(schema, renameFromIterator.next(), renameToIterator.next(), this.processDNs.isPresent());
                entryTranslators.add(t);
                changeRecordTranslators.add(t);
            }
        }
        if (this.flattenBaseDN.isPresent()) {
            FlattenSubtreeTransformation t = new FlattenSubtreeTransformation(schema, this.flattenBaseDN.getValue(), this.flattenAddOmittedRDNAttributesToEntry.isPresent(), this.flattenAddOmittedRDNAttributesToRDN.isPresent(), this.flattenExcludeFilter.getValue());
            entryTranslators.add(t);
        }
        if (this.moveSubtreeFrom.isPresent()) {
            Iterator<DN> moveFromIterator = this.moveSubtreeFrom.getValues().iterator();
            Iterator<DN> moveToIterator = this.moveSubtreeTo.getValues().iterator();
            while (moveFromIterator.hasNext()) {
                MoveSubtreeTransformation t = new MoveSubtreeTransformation(moveFromIterator.next(), moveToIterator.next());
                entryTranslators.add(t);
                changeRecordTranslators.add(t);
            }
        }
        if (this.redactAttribute.isPresent()) {
            RedactAttributeTransformation t = new RedactAttributeTransformation(schema, this.processDNs.isPresent(), !this.hideRedactedValueCount.isPresent(), this.redactAttribute.getValues());
            entryTranslators.add(t);
            changeRecordTranslators.add(t);
        }
        if (this.excludeAttribute.isPresent()) {
            ExcludeAttributeTransformation t = new ExcludeAttributeTransformation(schema, this.excludeAttribute.getValues());
            entryTranslators.add(t);
            changeRecordTranslators.add(t);
        }
        if (this.excludeEntryBaseDN.isPresent() || this.excludeEntryScope.isPresent() || this.excludeEntryFilter.isPresent()) {
            ExcludeEntryTransformation t = new ExcludeEntryTransformation(schema, this.excludeEntryBaseDN.getValue(), this.excludeEntryScope.getValue(), this.excludeEntryFilter.getValue(), !this.excludeNonMatchingEntries.isPresent(), excludedEntryCount);
            entryTranslators.add(t);
        }
        if (this.excludeChangeType.isPresent()) {
            EnumSet<ChangeType> changeTypes = EnumSet.noneOf(ChangeType.class);
            for (String changeTypeName : this.excludeChangeType.getValues()) {
                changeTypes.add(ChangeType.forName(changeTypeName));
            }
            changeRecordTranslators.add(new ExcludeChangeTypeTransformation(changeTypes));
        }
        if (this.excludeRecordsWithoutChangeType.isPresent()) {
            entryTranslators.add(new ExcludeAllEntriesTransformation());
        }
        entryTranslators.add(this);
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(4));
        examples.put(new String[]{"--sourceLDIF", "input.ldif", "--targetLDIF", "scrambled.ldif", "--scrambleAttribute", "givenName", "--scrambleAttribute", "sn", "--scrambleAttribute", "cn", "--numThreads", "10", "--schemaPath", "/ds/config/schema", "--processDNs"}, TransformationMessages.INFO_TRANSFORM_LDIF_EXAMPLE_SCRAMBLE.get());
        examples.put(new String[]{"--sourceLDIF", "input.ldif", "--targetLDIF", "sequential.ldif", "--sequentialAttribute", "uid", "--initialSequentialValue", "1", "--sequentialValueIncrement", "1", "--textBeforeSequentialValue", "user.", "--numThreads", "10", "--schemaPath", "/ds/config/schema", "--processDNs"}, TransformationMessages.INFO_TRANSFORM_LDIF_EXAMPLE_SEQUENTIAL.get());
        examples.put(new String[]{"--sourceLDIF", "input.ldif", "--targetLDIF", "added-organization.ldif", "--addAttributeName", "o", "--addAttributeValue", "Example Corp.", "--addAttributeFilter", "(objectClass=person)", "--numThreads", "10", "--schemaPath", "/ds/config/schema"}, TransformationMessages.INFO_TRANSFORM_LDIF_EXAMPLE_ADD.get());
        examples.put(new String[]{"--sourceLDIF", "input.ldif", "--targetLDIF", "rebased.ldif", "--moveSubtreeFrom", "o=example.com", "--moveSubtreeTo", "dc=example,dc=com", "--numThreads", "10", "--schemaPath", "/ds/config/schema"}, TransformationMessages.INFO_TRANSFORM_LDIF_EXAMPLE_REBASE.get());
        return examples;
    }

    @Override
    @Nullable
    public Entry translate(@NotNull Entry original, long firstLineNumber) throws LDIFException {
        ByteStringBuffer buffer = this.getBuffer();
        if (this.wrapColumn.isPresent()) {
            original.toLDIF(buffer, this.wrapColumn.getValue());
        } else {
            original.toLDIF(buffer, 0);
        }
        buffer.append(StaticUtils.EOL_BYTES);
        return new PreEncodedLDIFEntry(original, buffer.toByteArray());
    }

    @NotNull
    private ByteStringBuffer getBuffer() {
        ByteStringBuffer buffer = this.byteStringBuffers.get();
        if (buffer == null) {
            buffer = new ByteStringBuffer();
            this.byteStringBuffers.set(buffer);
        } else {
            buffer.clear();
        }
        return buffer;
    }
}

