// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteLogTargetFrontendAcceptedCode is the HTTP code returned for type DeleteLogTargetFrontendAccepted
const DeleteLogTargetFrontendAcceptedCode int = 202

/*
DeleteLogTargetFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteLogTargetFrontendAccepted
*/
type DeleteLogTargetFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteLogTargetFrontendAccepted creates DeleteLogTargetFrontendAccepted with default headers values
func NewDeleteLogTargetFrontendAccepted() *DeleteLogTargetFrontendAccepted {

	return &DeleteLogTargetFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete log target frontend accepted response
func (o *DeleteLogTargetFrontendAccepted) WithReloadID(reloadID string) *DeleteLogTargetFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete log target frontend accepted response
func (o *DeleteLogTargetFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteLogTargetFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteLogTargetFrontendNoContentCode is the HTTP code returned for type DeleteLogTargetFrontendNoContent
const DeleteLogTargetFrontendNoContentCode int = 204

/*
DeleteLogTargetFrontendNoContent Log Target deleted

swagger:response deleteLogTargetFrontendNoContent
*/
type DeleteLogTargetFrontendNoContent struct {
}

// NewDeleteLogTargetFrontendNoContent creates DeleteLogTargetFrontendNoContent with default headers values
func NewDeleteLogTargetFrontendNoContent() *DeleteLogTargetFrontendNoContent {

	return &DeleteLogTargetFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteLogTargetFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteLogTargetFrontendNotFoundCode is the HTTP code returned for type DeleteLogTargetFrontendNotFound
const DeleteLogTargetFrontendNotFoundCode int = 404

/*
DeleteLogTargetFrontendNotFound The specified resource was not found

swagger:response deleteLogTargetFrontendNotFound
*/
type DeleteLogTargetFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetFrontendNotFound creates DeleteLogTargetFrontendNotFound with default headers values
func NewDeleteLogTargetFrontendNotFound() *DeleteLogTargetFrontendNotFound {

	return &DeleteLogTargetFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete log target frontend not found response
func (o *DeleteLogTargetFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target frontend not found response
func (o *DeleteLogTargetFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target frontend not found response
func (o *DeleteLogTargetFrontendNotFound) WithPayload(payload *models.Error) *DeleteLogTargetFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target frontend not found response
func (o *DeleteLogTargetFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteLogTargetFrontendDefault General Error

swagger:response deleteLogTargetFrontendDefault
*/
type DeleteLogTargetFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetFrontendDefault creates DeleteLogTargetFrontendDefault with default headers values
func NewDeleteLogTargetFrontendDefault(code int) *DeleteLogTargetFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteLogTargetFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete log target frontend default response
func (o *DeleteLogTargetFrontendDefault) WithStatusCode(code int) *DeleteLogTargetFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete log target frontend default response
func (o *DeleteLogTargetFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete log target frontend default response
func (o *DeleteLogTargetFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target frontend default response
func (o *DeleteLogTargetFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target frontend default response
func (o *DeleteLogTargetFrontendDefault) WithPayload(payload *models.Error) *DeleteLogTargetFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target frontend default response
func (o *DeleteLogTargetFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
