// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `DocumentFormat`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let documentformat = unimplemented!();
/// match documentformat {
///     DocumentFormat::Csv => { /* ... */ },
///     DocumentFormat::Doc => { /* ... */ },
///     DocumentFormat::Docx => { /* ... */ },
///     DocumentFormat::Html => { /* ... */ },
///     DocumentFormat::Md => { /* ... */ },
///     DocumentFormat::Pdf => { /* ... */ },
///     DocumentFormat::Txt => { /* ... */ },
///     DocumentFormat::Xls => { /* ... */ },
///     DocumentFormat::Xlsx => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `documentformat` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `DocumentFormat::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `DocumentFormat::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `DocumentFormat::NewFeature` is defined.
/// Specifically, when `documentformat` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `DocumentFormat::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum DocumentFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Doc,
    #[allow(missing_docs)] // documentation missing in model
    Docx,
    #[allow(missing_docs)] // documentation missing in model
    Html,
    #[allow(missing_docs)] // documentation missing in model
    Md,
    #[allow(missing_docs)] // documentation missing in model
    Pdf,
    #[allow(missing_docs)] // documentation missing in model
    Txt,
    #[allow(missing_docs)] // documentation missing in model
    Xls,
    #[allow(missing_docs)] // documentation missing in model
    Xlsx,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for DocumentFormat {
    fn from(s: &str) -> Self {
        match s {
            "csv" => DocumentFormat::Csv,
            "doc" => DocumentFormat::Doc,
            "docx" => DocumentFormat::Docx,
            "html" => DocumentFormat::Html,
            "md" => DocumentFormat::Md,
            "pdf" => DocumentFormat::Pdf,
            "txt" => DocumentFormat::Txt,
            "xls" => DocumentFormat::Xls,
            "xlsx" => DocumentFormat::Xlsx,
            other => DocumentFormat::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for DocumentFormat {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(DocumentFormat::from(s))
    }
}
impl DocumentFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentFormat::Csv => "csv",
            DocumentFormat::Doc => "doc",
            DocumentFormat::Docx => "docx",
            DocumentFormat::Html => "html",
            DocumentFormat::Md => "md",
            DocumentFormat::Pdf => "pdf",
            DocumentFormat::Txt => "txt",
            DocumentFormat::Xls => "xls",
            DocumentFormat::Xlsx => "xlsx",
            DocumentFormat::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &["csv", "doc", "docx", "html", "md", "pdf", "txt", "xls", "xlsx"]
    }
}
impl ::std::convert::AsRef<str> for DocumentFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl DocumentFormat {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for DocumentFormat {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            DocumentFormat::Csv => write!(f, "csv"),
            DocumentFormat::Doc => write!(f, "doc"),
            DocumentFormat::Docx => write!(f, "docx"),
            DocumentFormat::Html => write!(f, "html"),
            DocumentFormat::Md => write!(f, "md"),
            DocumentFormat::Pdf => write!(f, "pdf"),
            DocumentFormat::Txt => write!(f, "txt"),
            DocumentFormat::Xls => write!(f, "xls"),
            DocumentFormat::Xlsx => write!(f, "xlsx"),
            DocumentFormat::Unknown(value) => write!(f, "{value}"),
        }
    }
}
