/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.auth;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.auth.OracleDatabaseNativeCredentials;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionRole;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OracleAuthModelDatabaseNative
extends AuthModelDatabaseNative<OracleDatabaseNativeCredentials> {
    public static final String ID = "oracle_native";

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull OracleDatabaseNativeCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        boolean setOsUser;
        Object userName = configuration.getUserName();
        if (!CommonUtils.isEmpty((String)userName) && !((String)userName).contains(" AS ")) {
            String role = configuration.getAuthProperty("oracle.logon-as");
            if (CommonUtils.isEmpty((String)role)) {
                String logonAs = configuration.getProviderProperty("oracle.logon-as");
                if (!OracleConnectionRole.NORMAL.getTitle().equalsIgnoreCase(logonAs)) {
                    role = configuration.getProviderProperty("oracle.logon-as");
                }
            }
            if (!CommonUtils.isEmpty((String)role)) {
                userName = (String)userName + " AS " + role;
            }
        }
        if (setOsUser = CommonUtils.getBoolean((String)configuration.getProviderProperty("oracle.set-os-user"), (boolean)false)) {
            String formattedUsername = ((String)userName).toUpperCase().split(" AS ")[0];
            connProperties.setProperty("v$session.osuser", formattedUsername);
        }
        credentials.setUserName((String)userName);
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }

    @NotNull
    public OracleDatabaseNativeCredentials createCredentials() {
        return new OracleDatabaseNativeCredentials();
    }
}

