# Security Policy

## Supported Versions

| Version   | Supported          |
| --------- | ------------------ |
| 6.x.x     | :white_check_mark: |
| 5.x.x     | :x:                |
| 4.x.x     | :x:                |
| 3.x.x     | :x:                |
| 2.x.x     | :x:                |
| 1.0.x     | :x:                |
| 0.38.5    | :x:                |
| <= 0.38.4 | :x:                |

## Reporting Security Issues

⚠ **Please do not report security vulnerabilities through public GitHub issues.** ⚠

Instead, either encrypted through Keybase chat
  - [keybase.io/cakebuild](https://keybase.io/cakebuild)

Or report them to us using NuGet.org *Contact owners*
  - [Cake.Tool](https://www.nuget.org/packages/Cake.Tool)
  - [Cake.Frosting](https://www.nuget.org/packages/Cake.Frosting)
  - [Cake.Core](https://www.nuget.org/packages/Cake.Core)
  - [Cake.Common](https://www.nuget.org/packages/Cake.Common)
  - [Cake.Testing](https://www.nuget.org/packages/Cake.Testing)
  - [Cake.Testing.Xunit](https://www.nuget.org/packages/Cake.Testing.Xunit)
  - [Cake.Testing.Xunit.v3](https://www.nuget.org/packages/Cake.Testing.Xunit.v3)
  - [Cake.NuGet](https://www.nuget.org/packages/Cake.NuGet)
  - [Cake.Cli](https://www.nuget.org/packages/Cake.Cli)
  - [Cake.DotNetTool.Module](https://www.nuget.org/packages/Cake.DotNetTool.Module)

If you prefer to submit without logging in, send an email to [security@cakebuild.net](mailto:security@cakebuild.net).

You should receive a response within 24 hours. If for some reason you do not, please follow up via email to ensure we received your original message.

Please include the requested information listed below (as much as you can provide) to help us better understand the nature and scope of the possible issue:

  * Type of issue (e.g. buffer overflow, SQL injection, cross-site scripting, etc.)
  * Full paths of source file(s) related to the manifestation of the issue
  * The location of the affected source code (tag/branch/commit or direct URL)
  * Any special configuration required to reproduce the issue
  * Step-by-step instructions to reproduce the issue
  * Proof-of-concept or exploit code (if possible)
  * Impact of the issue, including how an attacker might exploit the issue

This information will help us triage your report more quickly.

## Preferred Languages

We prefer all communications to be in English.
