//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextstorageeditactions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTextStorageEditActions(pub NSUInteger);
bitflags::bitflags! {
    impl NSTextStorageEditActions: NSUInteger {
        #[doc(alias = "NSTextStorageEditedAttributes")]
        const EditedAttributes = 1<<0;
        #[doc(alias = "NSTextStorageEditedCharacters")]
        const EditedCharacters = 1<<1;
    }
}

unsafe impl Encode for NSTextStorageEditActions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTextStorageEditActions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextstorage?language=objc)
    #[unsafe(super(NSMutableAttributedString, NSAttributedString, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSTextStorage;
);

extern_conformance!(
    unsafe impl NSCoding for NSTextStorage {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSTextStorage {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for NSTextStorage {}
);

impl NSTextStorage {
    extern_methods!(
        #[cfg(feature = "NSLayoutManager")]
        /// ************************** Layout manager ***************************
        #[unsafe(method(layoutManagers))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutManagers(&self) -> Retained<NSArray<NSLayoutManager>>;

        #[cfg(feature = "NSLayoutManager")]
        #[unsafe(method(addLayoutManager:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addLayoutManager(&self, a_layout_manager: &NSLayoutManager);

        #[cfg(feature = "NSLayoutManager")]
        #[unsafe(method(removeLayoutManager:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeLayoutManager(&self, a_layout_manager: &NSLayoutManager);

        /// ************************** Pending edit info ***************************
        #[unsafe(method(editedMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn editedMask(&self) -> NSTextStorageEditActions;

        #[unsafe(method(editedRange))]
        #[unsafe(method_family = none)]
        pub unsafe fn editedRange(&self) -> NSRange;

        #[unsafe(method(changeInLength))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeInLength(&self) -> NSInteger;

        /// ************************** Delegate ***************************
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSTextStorageDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSTextStorageDelegate>>,
        );

        /// ************************** Edit management ***************************
        #[unsafe(method(edited:range:changeInLength:))]
        #[unsafe(method_family = none)]
        pub unsafe fn edited_range_changeInLength(
            &self,
            edited_mask: NSTextStorageEditActions,
            edited_range: NSRange,
            delta: NSInteger,
        );

        #[unsafe(method(processEditing))]
        #[unsafe(method_family = none)]
        pub unsafe fn processEditing(&self);

        /// ************************** Attribute fixing ***************************
        #[unsafe(method(fixesAttributesLazily))]
        #[unsafe(method_family = none)]
        pub unsafe fn fixesAttributesLazily(&self) -> bool;

        #[unsafe(method(invalidateAttributesInRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidateAttributesInRange(&self, range: NSRange);

        #[unsafe(method(ensureAttributesAreFixedInRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn ensureAttributesAreFixedInRange(&self, range: NSRange);

        /// ************************** NSTextStorageObserving ***************************
        #[unsafe(method(textStorageObserver))]
        #[unsafe(method_family = none)]
        pub unsafe fn textStorageObserver(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSTextStorageObserving>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`textStorageObserver`][Self::textStorageObserver].
        #[unsafe(method(setTextStorageObserver:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTextStorageObserver(
            &self,
            text_storage_observer: Option<&ProtocolObject<dyn NSTextStorageObserving>>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl NSTextStorage {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// **  NSTextStorage delegate methods ***
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextstoragedelegate?language=objc)
    pub unsafe trait NSTextStorageDelegate: NSObjectProtocol {
        #[optional]
        #[unsafe(method(textStorage:willProcessEditing:range:changeInLength:))]
        #[unsafe(method_family = none)]
        unsafe fn textStorage_willProcessEditing_range_changeInLength(
            &self,
            text_storage: &NSTextStorage,
            edited_mask: NSTextStorageEditActions,
            edited_range: NSRange,
            delta: NSInteger,
        );

        #[optional]
        #[unsafe(method(textStorage:didProcessEditing:range:changeInLength:))]
        #[unsafe(method_family = none)]
        unsafe fn textStorage_didProcessEditing_range_changeInLength(
            &self,
            text_storage: &NSTextStorage,
            edited_mask: NSTextStorageEditActions,
            edited_range: NSRange,
            delta: NSInteger,
        );
    }
);

extern "C" {
    /// ** Notifications ***
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextstoragewillprocesseditingnotification?language=objc)
    pub static NSTextStorageWillProcessEditingNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextstoragedidprocesseditingnotification?language=objc)
    pub static NSTextStorageDidProcessEditingNotification: &'static NSNotificationName;
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextstorageobserving?language=objc)
    pub unsafe trait NSTextStorageObserving: NSObjectProtocol {
        #[unsafe(method(textStorage))]
        #[unsafe(method_family = none)]
        unsafe fn textStorage(&self) -> Option<Retained<NSTextStorage>>;

        /// Setter for [`textStorage`][Self::textStorage].
        #[unsafe(method(setTextStorage:))]
        #[unsafe(method_family = none)]
        unsafe fn setTextStorage(&self, text_storage: Option<&NSTextStorage>);

        #[unsafe(method(processEditingForTextStorage:edited:range:changeInLength:invalidatedRange:))]
        #[unsafe(method_family = none)]
        unsafe fn processEditingForTextStorage_edited_range_changeInLength_invalidatedRange(
            &self,
            text_storage: &NSTextStorage,
            edit_mask: NSTextStorageEditActions,
            new_char_range: NSRange,
            delta: NSInteger,
            invalidated_char_range: NSRange,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(performEditingTransactionForTextStorage:usingBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn performEditingTransactionForTextStorage_usingBlock(
            &self,
            text_storage: &NSTextStorage,
            transaction: &block2::DynBlock<dyn Fn() + '_>,
        );
    }
);

/// ** Deprecations ***
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextstorageeditedoptions?language=objc)
pub type NSTextStorageEditedOptions = NSUInteger;
