## RabbitMQ 4.1.4

RabbitMQ `4.1.4` is a maintenance release in the `4.1.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.1.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.1.0)
in detail if upgrading from a version prior to `4.1.0`.


### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.1.x/release-notes).


### Core Server

#### Bug Fixes

 * `default_password`, `ssl_options.password` now can tell between a generated random password
   value and an [encrypted value](https://www.rabbitmq.com/docs/configure#configuration-encryption) better.

   Encrypted values must be prefixed with `encrypted:`. All other values, including
   generated passwords that contain a colon (`:`), will be considered non-encrypted ones.

   GitHub issue: [#14365](https://github.com/rabbitmq/rabbitmq-server/pull/14365)

 * Import of definition files that contained topic exchange permissions failed.

   GitHub issue: [#14409](https://github.com/rabbitmq/rabbitmq-server/pull/14409)

#### Enhancements

 * When a configured [authentication or authorization backend](https://www.rabbitmq.com/docs/access-control#backends) comes from a known
   plugin but the plugin is not enabled, the node will now refuse to start.

   Previously the node would boot but client connections would fail because
   of the missing backend modules.

   GitHub issues: [#13783](https://github.com/rabbitmq/rabbitmq-server/discussions/13783), [#14408](https://github.com/rabbitmq/rabbitmq-server/pull/14408)

 * Similarly to the number of [queues](https://github.com/rabbitmq/rabbitmq-server/pull/11196) and [virtual hosts](https://github.com/rabbitmq/rabbitmq-server/pull/7798), it is now possible
   to configure a limit on the cluster-wide number of exchanges that applications
   can create:

   ```ini
   # Applications won't be able to decalre more than 200 exchanges
   # (including the protocol-standard pre-declared ones) in the cluster
   cluster_exchange_limit = 200
   ```

   The setting must be set to the same value on all cluster nodes.

   As with other limits, the goal is to introduce a guard against applications
   that leak resources.

   GitHub issue: [#14339](https://github.com/rabbitmq/rabbitmq-server/pull/14339)


 * In some environments, the use of load balancers is mandated and therefore
   [Local Random exchanges](https://www.rabbitmq.com/docs/local-random-exchange) cannot be used.

   A new setting, `exchange_types.local_random.enabled`, can be used to explicitly disable the local random exchange type,
   returning an error to the clients that try to declare such an exchange:

   ```ini
   # use in environments where the locality requirements of the local random exchange type cannot
   # be satisfied
   exchange_types.local_random.enabled = false
   ```

   GitHub issue: [#14363](https://github.com/rabbitmq/rabbitmq-server/pull/14363)

 * `RABBITMQ_MAX_OPEN_FILES` is a new environment variable supported by the `rabbitmq-server`
   startup script on Linux, macOS and BSD family operating systems.

   It **does not** replace the [standard mechanisms](https://www.rabbitmq.com/docs/networking#open-file-handle-limit) of increasing the maximum allowed
   file handle limit for the node. However, it can be useful in environments where the
   soft (current) limit is meaningfully lower than the hard (maximum allowed per system configuration) limit, and the user can only control the soft limit.

   For example, this is the case in most hosted Kubernetes environments.


### Stream Plugin

#### Bug Fixes

 * Stream client connections that authenticate using a JWT token (OAuth 2) have
   to periodically renew their JWT tokens. Should such an update fail,
   the RabbitMQ Stream Protocol connection will be immediately closed.

   In addition, stream connections now verify that the newly obtained JWT
   token still grants access to the virtual host the client is connected to.

   GitHub issues: [#14403](https://github.com/rabbitmq/rabbitmq-server/pull/14403), [#14406](https://github.com/rabbitmq/rabbitmq-server/pull/14406)

 * If a Single Active Consumer could not leave its SAC group because the stream
   coordinator was not available, the operation will now be retried a few times
   before reporting a failure back to the client.

   GitHub issue: [#14341](https://github.com/rabbitmq/rabbitmq-server/pull/14341)

 * Advertised TLS hostname setting value was not passed on to the stream protocol
   metadata frame.

   GitHub issue: [#14345](https://github.com/rabbitmq/rabbitmq-server/pull/14345)


### CLI TOols

#### Bug Fixes

 * `rabbitmqctl cluster_status --formatter=json` double converted the `running_nodes`
   field.

   GitHub issue: [#14382](https://github.com/rabbitmq/rabbitmq-server/pull/14382)


### Shovel Plugin

#### Bug Fixes

 * `rabbitmqctl shovel_status` command now handles the presence of metrics.

   GitHub issue: [#14298](https://github.com/rabbitmq/rabbitmq-server/pull/14298)

 * AMQP 1.0 shovels now perform stricter validation on the `src-delete-after` values.
   They support a narrower set of values compared to their AMQP 0-9-1 counterparts
   but shovel definition validation did not account for that difference.

   GitHub issue: [#14420](https://github.com/rabbitmq/rabbitmq-server/pull/14420)


### Dependency Changes

 * `ra` was upgraded to [`2.16.13`](https://github.com/rabbitmq/ra/releases)
 * `cuttlefish` was upgraded to [`3.5.0`](https://github.com/kyorai/cuttlefish/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.1.4.tar.xz`
instead of the source tarball produced by GitHub.
