
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDtls.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QDtls>
#include <QChildEvent>
#include <QEvent>
#include <QHostAddress>
#include <QMetaMethod>
#include <QObject>
#include <QSslCipher>
#include <QSslConfiguration>
#include <QSslError>
#include <QSslPreSharedKeyAuthenticator>
#include <QThread>
#include <QTimerEvent>
#include <QUdpSocket>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDtls

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QDtls::staticMetaObject);
}


// bool QDtls::abortHandshake(QUdpSocket *socket)


static void _init_f_abortHandshake_1617 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socket");
  decl->add_arg<QUdpSocket * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_abortHandshake_1617 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUdpSocket *arg1 = gsi::arg_reader<QUdpSocket * >() (args, heap);
  ret.write<bool > ((bool)((QDtls *)cls)->abortHandshake (arg1));
}


// QDtls::GeneratorParameters QDtls::cookieGeneratorParameters()


static void _init_f_cookieGeneratorParameters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDtls::GeneratorParameters > ();
}

static void _call_f_cookieGeneratorParameters_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDtls::GeneratorParameters > ((QDtls::GeneratorParameters)((QDtls *)cls)->cookieGeneratorParameters ());
}


// QByteArray QDtls::decryptDatagram(QUdpSocket *socket, const QByteArray &dgram)


static void _init_f_decryptDatagram_3818 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socket");
  decl->add_arg<QUdpSocket * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dgram");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<QByteArray > ();
}

static void _call_f_decryptDatagram_3818 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUdpSocket *arg1 = gsi::arg_reader<QUdpSocket * >() (args, heap);
  const QByteArray &arg2 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<QByteArray > ((QByteArray)((QDtls *)cls)->decryptDatagram (arg1, arg2));
}


// bool QDtls::doHandshake(QUdpSocket *socket, const QByteArray &dgram)


static void _init_f_doHandshake_3818 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socket");
  decl->add_arg<QUdpSocket * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dgram", true, "{}");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_doHandshake_3818 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUdpSocket *arg1 = gsi::arg_reader<QUdpSocket * >() (args, heap);
  const QByteArray &arg2 = args ? gsi::arg_reader<const QByteArray & >() (args, heap) : gsi::arg_maker<const QByteArray & >() ({}, heap);
  ret.write<bool > ((bool)((QDtls *)cls)->doHandshake (arg1, arg2));
}


// QSslConfiguration QDtls::dtlsConfiguration()


static void _init_f_dtlsConfiguration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslConfiguration > ();
}

static void _call_f_dtlsConfiguration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSslConfiguration > ((QSslConfiguration)((QDtls *)cls)->dtlsConfiguration ());
}


// QDtlsError QDtls::dtlsError()


static void _init_f_dtlsError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDtlsError>::target_type > ();
}

static void _call_f_dtlsError_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QDtlsError>::target_type > ((qt_gsi::Converter<QDtlsError>::target_type)qt_gsi::CppToQtAdaptor<QDtlsError>(((QDtls *)cls)->dtlsError ()));
}


// QString QDtls::dtlsErrorString()


static void _init_f_dtlsErrorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_dtlsErrorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDtls *)cls)->dtlsErrorString ());
}


// bool QDtls::handleTimeout(QUdpSocket *socket)


static void _init_f_handleTimeout_1617 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socket");
  decl->add_arg<QUdpSocket * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_handleTimeout_1617 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUdpSocket *arg1 = gsi::arg_reader<QUdpSocket * >() (args, heap);
  ret.write<bool > ((bool)((QDtls *)cls)->handleTimeout (arg1));
}


// QDtls::HandshakeState QDtls::handshakeState()


static void _init_f_handshakeState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDtls::HandshakeState>::target_type > ();
}

static void _call_f_handshakeState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QDtls::HandshakeState>::target_type > ((qt_gsi::Converter<QDtls::HandshakeState>::target_type)qt_gsi::CppToQtAdaptor<QDtls::HandshakeState>(((QDtls *)cls)->handshakeState ()));
}


// void QDtls::ignoreVerificationErrors(const QVector<QSslError> &errorsToIgnore)


static void _init_f_ignoreVerificationErrors_3052 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("errorsToIgnore");
  decl->add_arg<const QVector<QSslError> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ignoreVerificationErrors_3052 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<QSslError> &arg1 = gsi::arg_reader<const QVector<QSslError> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDtls *)cls)->ignoreVerificationErrors (arg1);
}


// bool QDtls::isConnectionEncrypted()


static void _init_f_isConnectionEncrypted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isConnectionEncrypted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDtls *)cls)->isConnectionEncrypted ());
}


// quint16 QDtls::mtuHint()


static void _init_f_mtuHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint16 > ();
}

static void _call_f_mtuHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint16 > ((quint16)((QDtls *)cls)->mtuHint ());
}


// QHostAddress QDtls::peerAddress()


static void _init_f_peerAddress_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHostAddress > ();
}

static void _call_f_peerAddress_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHostAddress > ((QHostAddress)((QDtls *)cls)->peerAddress ());
}


// quint16 QDtls::peerPort()


static void _init_f_peerPort_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint16 > ();
}

static void _call_f_peerPort_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint16 > ((quint16)((QDtls *)cls)->peerPort ());
}


// QVector<QSslError> QDtls::peerVerificationErrors()


static void _init_f_peerVerificationErrors_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector<QSslError> > ();
}

static void _call_f_peerVerificationErrors_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVector<QSslError> > ((QVector<QSslError>)((QDtls *)cls)->peerVerificationErrors ());
}


// QString QDtls::peerVerificationName()


static void _init_f_peerVerificationName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_peerVerificationName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDtls *)cls)->peerVerificationName ());
}


// bool QDtls::resumeHandshake(QUdpSocket *socket)


static void _init_f_resumeHandshake_1617 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socket");
  decl->add_arg<QUdpSocket * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_resumeHandshake_1617 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUdpSocket *arg1 = gsi::arg_reader<QUdpSocket * >() (args, heap);
  ret.write<bool > ((bool)((QDtls *)cls)->resumeHandshake (arg1));
}


// QSslCipher QDtls::sessionCipher()


static void _init_f_sessionCipher_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslCipher > ();
}

static void _call_f_sessionCipher_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSslCipher > ((QSslCipher)((QDtls *)cls)->sessionCipher ());
}


// QSsl::SslProtocol QDtls::sessionProtocol()


static void _init_f_sessionProtocol_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSsl::SslProtocol>::target_type > ();
}

static void _call_f_sessionProtocol_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSsl::SslProtocol>::target_type > ((qt_gsi::Converter<QSsl::SslProtocol>::target_type)qt_gsi::CppToQtAdaptor<QSsl::SslProtocol>(((QDtls *)cls)->sessionProtocol ()));
}


// bool QDtls::setCookieGeneratorParameters(const QDtls::GeneratorParameters &params)


static void _init_f_setCookieGeneratorParameters_3896 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("params");
  decl->add_arg<const QDtls::GeneratorParameters & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setCookieGeneratorParameters_3896 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDtls::GeneratorParameters &arg1 = gsi::arg_reader<const QDtls::GeneratorParameters & >() (args, heap);
  ret.write<bool > ((bool)((QDtls *)cls)->setCookieGeneratorParameters (arg1));
}


// bool QDtls::setDtlsConfiguration(const QSslConfiguration &configuration)


static void _init_f_setDtlsConfiguration_3068 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("configuration");
  decl->add_arg<const QSslConfiguration & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setDtlsConfiguration_3068 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSslConfiguration &arg1 = gsi::arg_reader<const QSslConfiguration & >() (args, heap);
  ret.write<bool > ((bool)((QDtls *)cls)->setDtlsConfiguration (arg1));
}


// void QDtls::setMtuHint(quint16 mtuHint)


static void _init_f_setMtuHint_1100 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mtuHint");
  decl->add_arg<quint16 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMtuHint_1100 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint16 arg1 = gsi::arg_reader<quint16 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDtls *)cls)->setMtuHint (arg1);
}


// bool QDtls::setPeer(const QHostAddress &address, quint16 port, const QString &verificationName)


static void _init_f_setPeer_5427 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QHostAddress & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("verificationName", true, "{}");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setPeer_5427 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QHostAddress &arg1 = gsi::arg_reader<const QHostAddress & >() (args, heap);
  quint16 arg2 = gsi::arg_reader<quint16 >() (args, heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() ({}, heap);
  ret.write<bool > ((bool)((QDtls *)cls)->setPeer (arg1, arg2, arg3));
}


// bool QDtls::setPeerVerificationName(const QString &name)


static void _init_f_setPeerVerificationName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setPeerVerificationName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDtls *)cls)->setPeerVerificationName (arg1));
}


// bool QDtls::shutdown(QUdpSocket *socket)


static void _init_f_shutdown_1617 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socket");
  decl->add_arg<QUdpSocket * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_shutdown_1617 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUdpSocket *arg1 = gsi::arg_reader<QUdpSocket * >() (args, heap);
  ret.write<bool > ((bool)((QDtls *)cls)->shutdown (arg1));
}


// QSslSocket::SslMode QDtls::sslMode()


static void _init_f_sslMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSslSocket::SslMode>::target_type > ();
}

static void _call_f_sslMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSslSocket::SslMode>::target_type > ((qt_gsi::Converter<QSslSocket::SslMode>::target_type)qt_gsi::CppToQtAdaptor<QSslSocket::SslMode>(((QDtls *)cls)->sslMode ()));
}


// qint64 QDtls::writeDatagramEncrypted(QUdpSocket *socket, const QByteArray &dgram)


static void _init_f_writeDatagramEncrypted_3818 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socket");
  decl->add_arg<QUdpSocket * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dgram");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<qint64 > ();
}

static void _call_f_writeDatagramEncrypted_3818 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUdpSocket *arg1 = gsi::arg_reader<QUdpSocket * >() (args, heap);
  const QByteArray &arg2 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<qint64 > ((qint64)((QDtls *)cls)->writeDatagramEncrypted (arg1, arg2));
}


// static QString QDtls::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QDtls::tr (arg1, arg2, arg3));
}


// static QString QDtls::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QDtls::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QDtls () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("abortHandshake", "@brief Method bool QDtls::abortHandshake(QUdpSocket *socket)\n", false, &_init_f_abortHandshake_1617, &_call_f_abortHandshake_1617);
  methods += new qt_gsi::GenericMethod ("cookieGeneratorParameters", "@brief Method QDtls::GeneratorParameters QDtls::cookieGeneratorParameters()\n", true, &_init_f_cookieGeneratorParameters_c0, &_call_f_cookieGeneratorParameters_c0);
  methods += new qt_gsi::GenericMethod ("decryptDatagram", "@brief Method QByteArray QDtls::decryptDatagram(QUdpSocket *socket, const QByteArray &dgram)\n", false, &_init_f_decryptDatagram_3818, &_call_f_decryptDatagram_3818);
  methods += new qt_gsi::GenericMethod ("doHandshake", "@brief Method bool QDtls::doHandshake(QUdpSocket *socket, const QByteArray &dgram)\n", false, &_init_f_doHandshake_3818, &_call_f_doHandshake_3818);
  methods += new qt_gsi::GenericMethod ("dtlsConfiguration", "@brief Method QSslConfiguration QDtls::dtlsConfiguration()\n", true, &_init_f_dtlsConfiguration_c0, &_call_f_dtlsConfiguration_c0);
  methods += new qt_gsi::GenericMethod ("dtlsError", "@brief Method QDtlsError QDtls::dtlsError()\n", true, &_init_f_dtlsError_c0, &_call_f_dtlsError_c0);
  methods += new qt_gsi::GenericMethod ("dtlsErrorString", "@brief Method QString QDtls::dtlsErrorString()\n", true, &_init_f_dtlsErrorString_c0, &_call_f_dtlsErrorString_c0);
  methods += new qt_gsi::GenericMethod ("handleTimeout", "@brief Method bool QDtls::handleTimeout(QUdpSocket *socket)\n", false, &_init_f_handleTimeout_1617, &_call_f_handleTimeout_1617);
  methods += new qt_gsi::GenericMethod ("handshakeState", "@brief Method QDtls::HandshakeState QDtls::handshakeState()\n", true, &_init_f_handshakeState_c0, &_call_f_handshakeState_c0);
  methods += new qt_gsi::GenericMethod ("ignoreVerificationErrors", "@brief Method void QDtls::ignoreVerificationErrors(const QVector<QSslError> &errorsToIgnore)\n", false, &_init_f_ignoreVerificationErrors_3052, &_call_f_ignoreVerificationErrors_3052);
  methods += new qt_gsi::GenericMethod ("isConnectionEncrypted?", "@brief Method bool QDtls::isConnectionEncrypted()\n", true, &_init_f_isConnectionEncrypted_c0, &_call_f_isConnectionEncrypted_c0);
  methods += new qt_gsi::GenericMethod (":mtuHint", "@brief Method quint16 QDtls::mtuHint()\n", true, &_init_f_mtuHint_c0, &_call_f_mtuHint_c0);
  methods += new qt_gsi::GenericMethod ("peerAddress", "@brief Method QHostAddress QDtls::peerAddress()\n", true, &_init_f_peerAddress_c0, &_call_f_peerAddress_c0);
  methods += new qt_gsi::GenericMethod ("peerPort", "@brief Method quint16 QDtls::peerPort()\n", true, &_init_f_peerPort_c0, &_call_f_peerPort_c0);
  methods += new qt_gsi::GenericMethod ("peerVerificationErrors", "@brief Method QVector<QSslError> QDtls::peerVerificationErrors()\n", true, &_init_f_peerVerificationErrors_c0, &_call_f_peerVerificationErrors_c0);
  methods += new qt_gsi::GenericMethod ("peerVerificationName", "@brief Method QString QDtls::peerVerificationName()\n", true, &_init_f_peerVerificationName_c0, &_call_f_peerVerificationName_c0);
  methods += new qt_gsi::GenericMethod ("resumeHandshake", "@brief Method bool QDtls::resumeHandshake(QUdpSocket *socket)\n", false, &_init_f_resumeHandshake_1617, &_call_f_resumeHandshake_1617);
  methods += new qt_gsi::GenericMethod ("sessionCipher", "@brief Method QSslCipher QDtls::sessionCipher()\n", true, &_init_f_sessionCipher_c0, &_call_f_sessionCipher_c0);
  methods += new qt_gsi::GenericMethod ("sessionProtocol", "@brief Method QSsl::SslProtocol QDtls::sessionProtocol()\n", true, &_init_f_sessionProtocol_c0, &_call_f_sessionProtocol_c0);
  methods += new qt_gsi::GenericMethod ("setCookieGeneratorParameters", "@brief Method bool QDtls::setCookieGeneratorParameters(const QDtls::GeneratorParameters &params)\n", false, &_init_f_setCookieGeneratorParameters_3896, &_call_f_setCookieGeneratorParameters_3896);
  methods += new qt_gsi::GenericMethod ("setDtlsConfiguration", "@brief Method bool QDtls::setDtlsConfiguration(const QSslConfiguration &configuration)\n", false, &_init_f_setDtlsConfiguration_3068, &_call_f_setDtlsConfiguration_3068);
  methods += new qt_gsi::GenericMethod ("setMtuHint|mtuHint=", "@brief Method void QDtls::setMtuHint(quint16 mtuHint)\n", false, &_init_f_setMtuHint_1100, &_call_f_setMtuHint_1100);
  methods += new qt_gsi::GenericMethod ("setPeer", "@brief Method bool QDtls::setPeer(const QHostAddress &address, quint16 port, const QString &verificationName)\n", false, &_init_f_setPeer_5427, &_call_f_setPeer_5427);
  methods += new qt_gsi::GenericMethod ("setPeerVerificationName", "@brief Method bool QDtls::setPeerVerificationName(const QString &name)\n", false, &_init_f_setPeerVerificationName_2025, &_call_f_setPeerVerificationName_2025);
  methods += new qt_gsi::GenericMethod ("shutdown", "@brief Method bool QDtls::shutdown(QUdpSocket *socket)\n", false, &_init_f_shutdown_1617, &_call_f_shutdown_1617);
  methods += new qt_gsi::GenericMethod ("sslMode", "@brief Method QSslSocket::SslMode QDtls::sslMode()\n", true, &_init_f_sslMode_c0, &_call_f_sslMode_c0);
  methods += new qt_gsi::GenericMethod ("writeDatagramEncrypted", "@brief Method qint64 QDtls::writeDatagramEncrypted(QUdpSocket *socket, const QByteArray &dgram)\n", false, &_init_f_writeDatagramEncrypted_3818, &_call_f_writeDatagramEncrypted_3818);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QDtls::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("handshakeTimeout()", "handshakeTimeout", "@brief Signal declaration for QDtls::handshakeTimeout()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QDtls::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QSslPreSharedKeyAuthenticator * > ("pskRequired(QSslPreSharedKeyAuthenticator *)", "pskRequired", gsi::arg("authenticator"), "@brief Signal declaration for QDtls::pskRequired(QSslPreSharedKeyAuthenticator *authenticator)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDtls::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDtls::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QDtls> decl_QDtls (qtdecl_QObject (), "QtNetwork", "QDtls_Native",
  methods_QDtls (),
  "@hide\n@alias QDtls");

GSI_QTNETWORK_PUBLIC gsi::Class<QDtls> &qtdecl_QDtls () { return decl_QDtls; }

}


class QDtls_Adaptor : public QDtls, public qt_gsi::QtObjectBase
{
public:

  virtual ~QDtls_Adaptor();

  //  [adaptor ctor] QDtls::QDtls(QSslSocket::SslMode mode, QObject *parent)
  QDtls_Adaptor(QSslSocket::SslMode mode) : QDtls(mode)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDtls::QDtls(QSslSocket::SslMode mode, QObject *parent)
  QDtls_Adaptor(QSslSocket::SslMode mode, QObject *parent) : QDtls(mode, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QDtls::isSignalConnected(const QMetaMethod &signal)
  bool fp_QDtls_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QDtls::isSignalConnected(signal);
  }

  //  [expose] int QDtls::receivers(const char *signal)
  int fp_QDtls_receivers_c1731 (const char *signal) const {
    return QDtls::receivers(signal);
  }

  //  [expose] QObject *QDtls::sender()
  QObject * fp_QDtls_sender_c0 () const {
    return QDtls::sender();
  }

  //  [expose] int QDtls::senderSignalIndex()
  int fp_QDtls_senderSignalIndex_c0 () const {
    return QDtls::senderSignalIndex();
  }

  //  [emitter impl] void QDtls::destroyed(QObject *)
  void emitter_QDtls_destroyed_1302(QObject *arg1)
  {
    emit QDtls::destroyed(arg1);
  }

  //  [adaptor impl] bool QDtls::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QDtls::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QDtls_Adaptor, bool, QEvent *>(&QDtls_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QDtls::event(_event);
    }
  }

  //  [adaptor impl] bool QDtls::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QDtls::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QDtls_Adaptor, bool, QObject *, QEvent *>(&QDtls_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QDtls::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QDtls::handshakeTimeout()
  void emitter_QDtls_handshakeTimeout_0()
  {
    emit QDtls::handshakeTimeout();
  }

  //  [emitter impl] void QDtls::objectNameChanged(const QString &objectName)
  void emitter_QDtls_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QDtls::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QDtls::pskRequired(QSslPreSharedKeyAuthenticator *authenticator)
  void emitter_QDtls_pskRequired_3571(QSslPreSharedKeyAuthenticator *authenticator)
  {
    emit QDtls::pskRequired(authenticator);
  }

  //  [adaptor impl] void QDtls::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QDtls::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QDtls_Adaptor, QChildEvent *>(&QDtls_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QDtls::childEvent(event);
    }
  }

  //  [adaptor impl] void QDtls::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QDtls::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QDtls_Adaptor, QEvent *>(&QDtls_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QDtls::customEvent(event);
    }
  }

  //  [adaptor impl] void QDtls::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QDtls::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QDtls_Adaptor, const QMetaMethod &>(&QDtls_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QDtls::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QDtls::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QDtls::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QDtls_Adaptor, QTimerEvent *>(&QDtls_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QDtls::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QDtls_Adaptor::~QDtls_Adaptor() { }

//  Constructor QDtls::QDtls(QSslSocket::SslMode mode, QObject *parent) (adaptor class)

static void _init_ctor_QDtls_Adaptor_3445 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QSslSocket::SslMode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QDtls_Adaptor> ();
}

static void _call_ctor_QDtls_Adaptor_3445 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSslSocket::SslMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSslSocket::SslMode>::target_type & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QDtls_Adaptor *> (new QDtls_Adaptor (qt_gsi::QtToCppAdaptor<QSslSocket::SslMode>(arg1).cref(), arg2));
}


// void QDtls::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDtls_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QDtls_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QDtls::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDtls_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDtls_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QDtls::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QDtls_Adaptor *)cls)->emitter_QDtls_destroyed_1302 (arg1);
}


// void QDtls::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDtls_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QDtls_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QDtls::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QDtls_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDtls_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QDtls::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QDtls_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QDtls_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QDtls::handshakeTimeout()

static void _init_emitter_handshakeTimeout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_handshakeTimeout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QDtls_Adaptor *)cls)->emitter_QDtls_handshakeTimeout_0 ();
}


// exposed bool QDtls::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QDtls_Adaptor *)cls)->fp_QDtls_isSignalConnected_c2394 (arg1));
}


// emitter void QDtls::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QDtls_Adaptor *)cls)->emitter_QDtls_objectNameChanged_4567 (arg1);
}


// emitter void QDtls::pskRequired(QSslPreSharedKeyAuthenticator *authenticator)

static void _init_emitter_pskRequired_3571 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("authenticator");
  decl->add_arg<QSslPreSharedKeyAuthenticator * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_pskRequired_3571 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSslPreSharedKeyAuthenticator *arg1 = gsi::arg_reader<QSslPreSharedKeyAuthenticator * >() (args, heap);
  ((QDtls_Adaptor *)cls)->emitter_QDtls_pskRequired_3571 (arg1);
}


// exposed int QDtls::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QDtls_Adaptor *)cls)->fp_QDtls_receivers_c1731 (arg1));
}


// exposed QObject *QDtls::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QDtls_Adaptor *)cls)->fp_QDtls_sender_c0 ());
}


// exposed int QDtls::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDtls_Adaptor *)cls)->fp_QDtls_senderSignalIndex_c0 ());
}


// void QDtls::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDtls_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QDtls_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QDtls> &qtdecl_QDtls ();

static gsi::Methods methods_QDtls_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDtls::QDtls(QSslSocket::SslMode mode, QObject *parent)\nThis method creates an object of class QDtls.", &_init_ctor_QDtls_Adaptor_3445, &_call_ctor_QDtls_Adaptor_3445);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QDtls::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QDtls::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QDtls::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QDtls::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QDtls::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QDtls::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_handshakeTimeout", "@brief Emitter for signal void QDtls::handshakeTimeout()\nCall this method to emit this signal.", false, &_init_emitter_handshakeTimeout_0, &_call_emitter_handshakeTimeout_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QDtls::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QDtls::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_pskRequired", "@brief Emitter for signal void QDtls::pskRequired(QSslPreSharedKeyAuthenticator *authenticator)\nCall this method to emit this signal.", false, &_init_emitter_pskRequired_3571, &_call_emitter_pskRequired_3571);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QDtls::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QDtls::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QDtls::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QDtls::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QDtls_Adaptor> decl_QDtls_Adaptor (qtdecl_QDtls (), "QtNetwork", "QDtls",
  methods_QDtls_Adaptor (),
  "@qt\n@brief Binding of QDtls");

}


//  Implementation of the enum wrapper class for QDtls::HandshakeState
namespace qt_gsi
{

static gsi::Enum<QDtls::HandshakeState> decl_QDtls_HandshakeState_Enum ("QtNetwork", "QDtls_HandshakeState",
    gsi::enum_const ("HandshakeNotStarted", QDtls::HandshakeNotStarted, "@brief Enum constant QDtls::HandshakeNotStarted") +
    gsi::enum_const ("HandshakeInProgress", QDtls::HandshakeInProgress, "@brief Enum constant QDtls::HandshakeInProgress") +
    gsi::enum_const ("PeerVerificationFailed", QDtls::PeerVerificationFailed, "@brief Enum constant QDtls::PeerVerificationFailed") +
    gsi::enum_const ("HandshakeComplete", QDtls::HandshakeComplete, "@brief Enum constant QDtls::HandshakeComplete"),
  "@qt\n@brief This class represents the QDtls::HandshakeState enum");

static gsi::QFlagsClass<QDtls::HandshakeState > decl_QDtls_HandshakeState_Enums ("QtNetwork", "QDtls_QFlags_HandshakeState",
  "@qt\n@brief This class represents the QFlags<QDtls::HandshakeState> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDtls> inject_QDtls_HandshakeState_Enum_in_parent (decl_QDtls_HandshakeState_Enum.defs ());
static gsi::ClassExt<QDtls> decl_QDtls_HandshakeState_Enum_as_child (decl_QDtls_HandshakeState_Enum, "HandshakeState");
static gsi::ClassExt<QDtls> decl_QDtls_HandshakeState_Enums_as_child (decl_QDtls_HandshakeState_Enums, "QFlags_HandshakeState");

}

